/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/CFMTADR.H__   1.8   20 Jun 1996 09:25:30   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/CFMTADR.H__  $
** 
**    Rev 1.8   20 Jun 1996 09:25:30   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.6   10 Jun 1996 10:20:08   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.4   29 May 1996 09:29:36   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:06:52   ZJRD
** EasyPack/SLD Version 1.94
** 
**    Rev 1.2   10 May 1996 09:09:52   ZJRD
** EasyPack/SLD Version 1.93
** 
**    Rev 1.1   02 May 1996 10:26:30   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.1   18 Apr 1996 12:54:22   Shirley
** EasyPack/SLD Version 1.91
** 
**    Rev 1.0   12 Apr 1996 10:36:22   Shirley
** Initial revision.
** 
****************************************************************************/

/****************************************************************************
**
**  Name:   Fmtadr.h
**
**  Description:  Head file of CFmtadr.cpp
**                This file describe the class of CFormatAddress.
**                CFormatAddress deprived from the base class of CFormat.
**
**  Status:    Initialization
**             1996/2/16      Daniel Lin
**
**  Copyright (C) 1996 Microtek International.  All rights reserved.
*****************************************************************************/

#ifndef __CFMTADR__H
#define __CFMTADR__H

typedef enum tagADDRRET
{     
      ADR_OK            = 1,       // the address is ok
      ADR_FORMATERROR   = 2,       // the address format is error
      ADR_INVALIDCHAR   = 3,       // the address include invalid char
      ADR_OUTRANGE      = 4,       // the address out of range
      ADR_NOSYMBOL      = 5,       // The symbol doesn't exist(Only for conver
                                   // symbol to ADDRESS)
      ADR_COMPERROR     = 6,       // the second address is less than first
      ADR_OVERFLOW      = 7,       // the address text string is overflow
      ADR_EMPTY         = 8,       // the address text string is empty
      
}ADDR_RETCODE;

typedef enum tagFormatType
{
      IS_HEX      =  0,
      IS_DEC      =  1,
      IS_SYM      =  2,
      IS_SYM_DATA =  3,
      IS_UNKNOWN  =  32767
}FORMATTYPE;

//
//Data struct define
//

typedef    DWORD  ADDR_SIZE;
#define    HEXLENGTH       8
#define    DECLENGTH       9 

/**-----------------------------------------------------------
 ** Remarks
 **    This enum define the 51 based family's space style.
 **-----------------------------------------------------------*/
typedef  enum  //tagAddrSpace
{
   // The following is for 51 family
   // This order is by the ADDR_TYPE(define in AbiType.h)
   // Because this order is common.
   //
   SPACE_UNDEFINE = 0,  // Undefine the area
   SPACE_PROGRAME = 1,  // Program area
   SPACE_EXTERNAL = 2,  // External area(Data)
   SPACE_INTERNAL = 3,  // Internal area(On chip)
   SPACE_SFR      = 4,  // Special function register area
   SPACE_BIT      = 5,  // Bit area   

   //The following is for Motorola family (form power view, must be changed)
   //
   
   SPACE_UNDEF0,
   SPACE_UD,
   SPACE_UP,
   SPACE_UNDEF3,
   SPACE_UNDEF4,
   SPACE_SD,
   SPACE_SP,
   SPACE_CPU,
   SPACE_DONT_CARE
}ADDR_SPACE;


typedef struct tagADDR
{
   ADDR_SPACE  adrSpace;   // The address attribute
                           // Such in 51 family, this field is for p, x, i,
                           // r, b
   ADDR_SIZE   adrAddress; // The address
}ADDRESS;

class CFormatAddress          // Virtua base class
{
   protected:
      CString  m_strOriginAdr;// Original address string. No any change
                              // Get from construct or Set function
    ADDR_SIZE  m_dwAddress;   // The data of address(converted form string,
                              // or get from constructor)
                              // After converted successful, the m_dwAddress
                              // is the address.

      CString  m_strPrefix;   // Prefix front the address.
                              // Such as in 51 base family the prefix of
                              // p:0x987 is "p"
                              // In 86 family, the prefix is the segment or
                              // descriptor
                              // etc;

      CString  m_strAddress;     // After split the prefix,
                                 // In 51 family, it is the absoluted address
                                 // In 86 family, it is the offset
                                 // etc;

      CString  m_strAddressHex;  // The converted hex address
      CString  m_strAddressDec;  // The converted dec address
      
      // Add on 04/16/1996 for the new SPEC from Qingzhu MII.
      //
      UINT     m_nDefaultIsHex;        // Set the default input
                                       // 1 --> default is hex
                                       // 0 --> default is dec   

   public:
      static void  SkipHeadWS  (char* lpsz);    // ship white space in head
      static BOOL  IsSpace     (char ch);       // distinguish the char is white space
      static void  CutTailWS   (char* lpsz);    // filter the tail white space
      static void  SkipHeadZero(char* lpsz);    // skip all zero in head
      static BOOL  IsZero      (char ch);       // distinguish the char is zero
      static BOOL  IsHex       (char* lpsz);    // distinguish the string is Hex
      static BOOL  IsDec       (char* lpsz);    // distinguish the string is Dec
      static BOOL  IsSymbol    (char* lpsz);    // distinguish the string is symbol(#AA)
      static BOOL  IsSymbolData(char* lpsz);    // distinguish the string is sym data ($aa)   
      
 FORMATTYPE        IsWhichFormat (void);        // Return the format enum
      BOOL   CheckLength (FORMATTYPE ft, const CString &lpsz);  // Check if overflow

   public:
      // Constructor
      CFormatAddress();

      //Implementation
      virtual  BOOL  SplitPrefix(const char* lpsz) = 0;
      virtual  BOOL  ConvertCheck() = 0;
};

#endif

//////////////////////////////////////(EOF)////////////////////////////////////

