/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/COPT.CPP   1.4   20 Jun 1996 09:29:22   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/COPT.CPP  $
** 
**    Rev 1.4   20 Jun 1996 09:29:22   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.2   10 Jun 1996 10:24:00   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.0   29 May 1996 09:35:36   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
// copt.cpp
//
// Michael Long
//                                                                           
// 5/15/1996
//
/////////////////////////////////////////////////////////////////////////////
#include "stdafx.h"
#include "resource.h"

#include "toolopt.h"    
#include "cc.h"
#include "ccoption.h"
#include "ca.h"
#include "caoption.h"
#include "cl.h"
#include "cloption.h"
#include "ce.h"
#include "ceoption.h"
#include "ctab.h"
#include "projopt.h"
#include "copt.h"   

extern char szAppPath[_MAX_PATH+1];

/////////////////////////////////////////////////////////////////////////////
// operations
void COption::SetOption(CWnd *pParent)
{
    CCTab dlg(&m_ccTool, &m_caTool, &m_clTool,&m_ceTool, pParent);
    dlg.DoModal();
}

BOOL COption::SaveOption(FILE * fp)
{                              
    ASSERT(fp);
    
    if(!m_ccTool.SaveOption(fp))
        return FALSE;
    if(!m_caTool.SaveOption(fp))
        return FALSE;
    if(!m_clTool.SaveOption(fp))
        return FALSE;
    if(!m_ceTool.SaveOption(fp))
        return FALSE;
     if((_stricmp(m_ceTool.m_strPath," ")!=0)&&(_stricmp(m_ceTool.m_strProg,"c:\\ ")!=0))
       m_fValid=TRUE;
    else
       m_fValid=FALSE;   
    return TRUE;
}
                
BOOL COption::LoadOption(FILE * fp)
{                              
    ASSERT(fp);
    
    if(!m_ccTool.LoadOption(fp))
        return FALSE;
    if(!m_caTool.LoadOption(fp))
        return FALSE;
    if(!m_clTool.LoadOption(fp))
        return FALSE;
    if(!m_ceTool.LoadOption(fp))
        return FALSE;
    if((_stricmp(m_ceTool.m_strPath," ")!=0)&&(_stricmp(m_ceTool.m_strProg,"c:\\ ")!=0))
       m_fValid=TRUE;
    else
       m_fValid=FALSE;    
    return TRUE;
}                
    
// return 0:c file, 1:asm file, 2:other file(library)    
int COption::GetFileType(LPCSTR lpcszFile) const
{              
    ASSERT(lpcszFile);

    char ext[_MAX_EXT];

    _splitpath(lpcszFile, NULL, NULL, NULL, ext);
    if(_stricmp(ext, ".c") == 0) {
        return 0;                
    } else if(_stricmp(ext, ".asm") == 0) {
        return 1;
    } else {
        return 2;
    }
}        

BOOL COption::CreateLinkCmdFile(const CStringList &lst, LPCSTR lpcszProj)
{
    POSITION pos;
    CString str, str1, str2;
    FILE * fp,*fpold;
    int i;
    const int ncnt=1 ;
    char ad[ncnt];
    fp = fopen(GetName(lpcszProj, ".lnk"), "wt");
    if(!fp)
        goto CMDFAIL;          
      
    str1 ="options : ";
    str = m_clTool.GetOption();
    str1 += str;

    if(fwrite(str1.GetBuffer(str1.GetLength()), str1.GetLength(), 1, fp) != 1)
        goto CMDFAIL;
    else
        str1.ReleaseBuffer();

    if(fputc('\n', fp) == EOF)          
        goto CMDFAIL;
     
    for(i = 0, pos = lst.GetHeadPosition(); pos != NULL; i ++) {
        str2 = lst.GetNext(pos);
         
        
        if(GetFileType(str2) != 2) 
          { 
            str1 = "input : ";
            str = GetName(str2, ".obj");
            str1 += str;
           }
        else
            str1 = str2;
            
        if(fwrite(str1.GetBuffer(str1.GetLength()), str1.GetLength(), 1, fp) 
            != 1)
            goto CMDFAIL;
        else
            str1.ReleaseBuffer();
            
        if(i < lst.GetCount() - 1) {
            if(fputc(',', fp) == EOF)          
                goto CMDFAIL;
        } else {
            if(fputc(' ', fp) == EOF)          
                goto CMDFAIL;
        }
        if(fputc('\n', fp) == EOF)          
            goto CMDFAIL;
    }
                      
    str1 = "output  : ";
    str1 += GetName(lpcszProj, " ");                   
    
    if(fwrite(str1.GetBuffer(str1.GetLength()), str1.GetLength(), 1, fp) != 1)
        goto CMDFAIL;
    else 
        str1.ReleaseBuffer();
        
    if(fputc('\n', fp) == EOF)          
        goto CMDFAIL;
   
    
//    fpold = fopen("c:\\ep-sld\\ide.dat","rt");
    {
        CString strFile(::szAppPath);
        strFile += "ide.dat";
        fpold = fopen(strFile, "rt");
    }
    
    while(feof(fpold)==0){
    
    fread(ad,1,ncnt,fpold);
    fwrite(ad,1,ncnt,fp);
        
    }
         
    fclose(fpold); 
    fclose(fp);
    return TRUE;
                     
CMDFAIL:
    AfxMessageBox("Failed to create link command file!");                    
    if(fp)
        fclose(fp);
    return FALSE;
                     
}                                              

BOOL COption::WriteBatchFile(FILE * fp, LPCSTR lpcszText)
{
    ASSERT(fp);
    
    if(fwrite(lpcszText, lstrlen(lpcszText), 1, fp) != 1) 
        goto BATFAIL;
    if(fputc('\n', fp) == EOF)
        goto BATFAIL;
        
    return TRUE;

BATFAIL:    
    fclose(fp); 
    AfxMessageBox("Failed to create batch file!");
    return FALSE;
}


void COption::Build(const CStringList &lst, LPCSTR lpcszProj)
{
    POSITION pos;   
    CString str;
    CString strBuild;
    CString cstr;
    CString astr;
    CString lstr;
    if((m_ccTool.m_strPath)[(m_ccTool.m_strPath).GetLength()-1]!='\\')
    cstr = m_ccTool.m_strPath + "\\";
    if((m_caTool.m_strPath)[(m_caTool.m_strPath).GetLength()-1]!='\\')
    astr = m_caTool.m_strPath + "\\";
    if((m_clTool.m_strPath)[(m_clTool.m_strPath).GetLength()-1]!='\\')
    lstr = m_clTool.m_strPath + "\\";   
    int nType;                   
    FILE * fp;
    
    fp = fopen(GetName(lpcszProj, ".bat"), "wt");
    if(!fp) {
        AfxMessageBox("Failed to create batch file!");
        return;
    }
    
    // compile or macro preprocess
    for(pos = lst.GetHeadPosition(); pos != NULL; ) {
        str = lst.GetNext(pos);
        nType = GetFileType(str);
        if(nType == 0) {    // c file
            strBuild = cstr + "c8051.exe ";
            strBuild += str;
            strBuild +=" ";
            strBuild += m_ccTool.GetOption();
            strBuild +=" ";
            strBuild +="-o ";
            strBuild += GetName(lpcszProj,".obj");
      } else if(nType == 1) { // asm file
            strBuild = astr + "x8051.exe ";
            strBuild += str;            
            strBuild += " ";
            strBuild += m_caTool.GetOption(); 
            strBuild +=" ";
            strBuild +="-o ";
            strBuild += GetName(lpcszProj,".obj");
        } else {
            continue;
        }            
                
        if(!WriteBatchFile(fp, strBuild))
            return;
        
    }                                   
    
    // link
    if(!CreateLinkCmdFile(lst, lpcszProj))
        return;
    strBuild = lstr + "link.exe ";
    strBuild += " "; 
    strBuild += GetName(lpcszProj, ".lnk");
    if(!WriteBatchFile(fp, strBuild))
        return;

    fclose(fp);
    
    WinExec(GetName(lpcszProj, ".bat"), SW_SHOW);
}
            
 void COption::Editor(void)
  {
   CString str;             
   FILE *fp;                  
   fp = fopen("cedit.bat","wt");
    if(!fp) {
        AfxMessageBox("Failed to create batch file!");
        return;
    }
   
    char drive[_MAX_DRIVE], dir[_MAX_DIR];
    char fname[_MAX_FNAME],  ext[_MAX_EXT];
   
    _splitpath(m_ceTool.m_strPath, drive, dir, fname, ext);
    if(_stricmp(ext,".exe")==0&&_stricmp(ext,".com")==0)
    {
     AfxMessageBox("Editor command error!");
      return;
     }
   str = m_ceTool.GetOption();
   if(!WriteBatchFile(fp, str))
        return;
   
   fclose(fp);
   WinExec("cedit.bat", SW_SHOW);
}
                