/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/DA.CPP   1.5   20 Jun 1996 09:29:26   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/DA.CPP  $
** 
**    Rev 1.5   20 Jun 1996 09:29:26   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.3   10 Jun 1996 10:24:04   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.1   29 May 1996 09:35:40   ZJRD
** EasyPack/SLD Version 1.95
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
// da.cpp
//
// Michael Long
//                                                                           
// 5/14/96
//
/////////////////////////////////////////////////////////////////////////////
#include "stdafx.h"

#include "toolopt.h"
#include "da.h"

/////////////////////////////////////////////////////////////////////////////
// diagnostic
#ifdef _DEBUG
void DATool::Dump(CDumpContext &dc) const
{         
    CToolOption::Dump(dc);
    dc << "m_fDebug = " << m_fDebug << "\n";
    dc << "m_fList = " << m_fList << "\n";
    dc << "m_strMore = " << m_strMore << "\n";
    dc << "m_strPath = " << m_strPath << "\n";
 
}
#endif

/////////////////////////////////////////////////////////////////////////////
// operations
void DATool::SetDefault(void)
{
    m_fDebug = TRUE;
    m_fList =  TRUE;
    m_strMore = "SYMBOLS XREF ";
    m_strPath = "c:\\omf51 ";
}

BOOL DATool::LoadOption(FILE * fp)
{
    ASSERT(fp);
    
    const int nCnt = 2;
    
    char dch[nCnt];
    
    if(fread(dch, 1, nCnt, fp) != nCnt)
        return FALSE;
        
    m_fDebug = dch[0];
    m_fList = dch[1];
        
    WORD wLen;
    if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_strMore.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strMore.ReleaseBuffer(wLen);  
    if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_strPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strPath.ReleaseBuffer(wLen);  
    
    return TRUE;
}                 

BOOL DATool::SaveOption(FILE * fp)
{
    ASSERT(fp);
    
    const int nCnt = 2;

    char dch[nCnt];
    
    dch[0] = m_fDebug;
    dch[1] = m_fList;
  
    if(fwrite(dch, 1, nCnt, fp) != nCnt)
        return FALSE;
             
    WORD wLen = m_strMore.GetLength();           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_strMore.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strMore.ReleaseBuffer(wLen);  
    
    wLen = m_strPath.GetLength();           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_strPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strPath.ReleaseBuffer(wLen);  
   
    return TRUE;
}

CString DATool::GetOption(void) const
{
    CString str = " ";
    
            
    if(m_fDebug)
        str += "DB ";
        
    if(m_fList)
        str += "COND ";
    else
        str += "NOCOND ";
           
    str += m_strMore;
    str += " ";
    
    return str;
}

