/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/DC.CPP   1.5   20 Jun 1996 09:29:26   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/DC.CPP  $
** 
**    Rev 1.5   20 Jun 1996 09:29:26   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.3   10 Jun 1996 10:24:04   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.1   29 May 1996 09:35:42   ZJRD
** EasyPack/SLD Version 1.95
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
// dc.cpp
//
// Michael Long
//                                                                           
// 5/14/96
//
/////////////////////////////////////////////////////////////////////////////
#include "stdafx.h"

#include "toolopt.h"
#include "dc.h"

/////////////////////////////////////////////////////////////////////////////
// diagnostic
#ifdef _DEBUG
void DCTool::Dump(CDumpContext &dc) const
{         
    CToolOption::Dump(dc);
    dc << "m_nRegBank = " << m_nRegBank << "\n";
    dc << "m_nMemoryModel = " << m_nMemoryModel << "\n";
    dc << "m_nOptimize = " << m_nOptimize << "\n";
    dc << "m_fDb = " << m_fDb << "\n";
    dc << "m_fNopr = " << m_fNopr << "\n";
    dc << "m_strMore = " << m_strMore << "\n";  
    dc << "m_strPath = " << m_strPath << "\n";
}
#endif

/////////////////////////////////////////////////////////////////////////////
// operations
void DCTool::SetDefault(void)
{
    m_nRegBank = 2;     // 0-3
    m_nMemoryModel = 0; // 0 - 2 = s,c,l
    m_nOptimize = 5;    // 0 - 5
    m_fDb = TRUE;
    m_fNopr = FALSE;
    m_strMore = "NOREGPARMS OBJECTEXTEND "; 
    m_strPath = "c:\\omf51 ";
}

BOOL DCTool::LoadOption(FILE * fp)
{
    ASSERT(fp);
    
    const int nCnt = 5;
    
    char dch[nCnt];
    
    if(fread(dch, 1, nCnt, fp) != nCnt)
        return FALSE;
        
    m_nRegBank = dch[0];
    m_nMemoryModel = dch[1];
    m_nOptimize = dch[2];
    m_fDb = dch[4];
    m_fNopr = dch[3];
       
    WORD wLen;
    if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_strMore.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strMore.ReleaseBuffer(wLen);  
    if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_strPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strPath.ReleaseBuffer(wLen);  
    
    return TRUE;
}                 

BOOL DCTool::SaveOption(FILE * fp)
{
    ASSERT(fp);
    
    const int nCnt = 5;

    char dch[nCnt];
    
    dch[0] = m_nRegBank;
    dch[1] = m_nMemoryModel;
    dch[2] = m_nOptimize;
    dch[4] = m_fDb;
    dch[3] = m_fNopr;
    if(fwrite(dch, 1, nCnt, fp) != nCnt)
        return FALSE;
             
    WORD wLen = m_strMore.GetLength();           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_strMore.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strMore.ReleaseBuffer(wLen);  
    
    wLen = m_strPath.GetLength();           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_strMore.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strPath.ReleaseBuffer(wLen);  
    
    return TRUE;
}   
                            
static char * ar1[4] = { "RB(0) ", "RB(1) ", "RB(2) ", "RB(3) " };
static char * ar2[3] = { "SM ", "CP ", "LA "  };
static char * ar3[6] = { "OT(0) ", "OT(1) ", "OT(2) ", "OT(3) ", "OT(4) ", "OT(5) " };

CString DCTool::GetOption(void) const
{
    CString str = " ";
    
    str = ar1[m_nRegBank];
    str += ar2[m_nMemoryModel];
    str += ar3[m_nOptimize];
    
    if(m_fDb)
        str += "DB ";
        
    if(m_fNopr)
        str += "NOPR ";
        
    str += m_strMore;
    str += " ";
    
    return str;     
}

