
/**************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/DIAGNO/ABIMEM51.CPP   1.5   20 Jun 1996 09:34:36   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/DIAGNO/ABIMEM51.CPP  $
** 
**    Rev 1.5   20 Jun 1996 09:34:36   ZJRD
** No change.
** 
**    Rev 1.4   11 Jun 1996 10:33:34   ZJRD
** EasyPack/SLD Version 1.97
** 
**    Rev 1.2   05 Jun 1996 15:01:10   ZJRD
** No change.
** 
**    Rev 1.1   29 May 1996 09:43:14   ZJRD
** No change.
** 
**    Rev 1.0   16 May 1996 09:12:50   ZJRD
** Initial revision.
** 
**    Rev 1.1   02 May 1996 10:29:38   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 13:02:02   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:40:56   Shirley
** No change.
** 
**    Rev 1.29   02 Apr 1996 09:29:50   Shirley
** EasyPack/SLD Version 1.1
** 
**    Rev 1.28   15 Feb 1996 08:55:18   Shirley
** EasyPack/SLD Version 1.01
** 
**    Rev 1.27   12 Feb 1996 14:09:22   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:35:46   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:50:02   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:14:32   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:20:26   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:20:18   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:39:08   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:27:58   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:09:54   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:16:10   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:11:44   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:08:22   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:34:54   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:22:36   Shirley
** EasyPack/SLD Version 0.31
** 
**    Rev 1.13   13 Nov 1995 09:27:58   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:31:28   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:28:04   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:41:18   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:06:58   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:51:22   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:44:12   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:25:58   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:47:32   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:23:40   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:50:24   Shirley
** EasyPack/SLD Version 0.1c
** 
**    Rev 1.2   20 Sep 1995 10:52:20   Shirley
** EasyPack/SLD Version 0.1b
** 
**    Rev 1.1   15 Sep 1995 09:43:24   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:53:14   Shirley
** Initial revision.
**
***************************************************************************/

/***************************************************************************
**
** File name : abimem51.cpp
**
** Description: 
**
**
**
**
** Programmer: Frank Chang
**
**    Copyright (C) 1995 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/
#include "stdafx.h"

#include "abitype.h"
#include "abimacro.h"

static ADDR retAddr;

/////////////////////////////////////////////////////////////////                  
// Rountines declaration
//

STATUS AbiGetMemN(ADDR addr1, ADDR addr2,char* pchBuff);     
STATUS AbiSetMemN(ADDR addr, char* pchBuff, UINT uPatternLen);
STATUS AbiFill(ADDR addr1, ADDR addr2,char* pchBuff, UINT uPatternLen);
STATUS AbiChecksum(ADDR addr1, ADDR addr2, UINT* uChecksum);
STATUS AbiTest(ADDR addr1, ADDR addr2);
STATUS AbiCopy(ADDR addr1, ADDR addr2, ADDR destAddr);
STATUS AbiSearch(ADDR addr1, ADDR addr2, SEARCH_INFO searchInfo,
                 ADDR* retAddr);
STATUS AbiCompare(ADDR addr1, ADDR addr2, ADDR destAddr,
                  ADDR* retAddr);
          
STATUS AbiSetMap(MAP_INFO mapInfo);
STATUS AbiGetMap(ADDR addr1, ADDR addr2, MAP_INFO* mapInfo);

ADDR AbiGetErrorAddr();

//unreviewed, 05/04/95
STATUS AbiSetVerify(FLAG uVerifyFlag);

STATUS AbiInitEprom();
STATUS AbiBurnEprom(BURN_EPROM burnEprom, WORD *wChecksum);

//unchecked, 02/08/96
STATUS AbiSwitchFlash();
STATUS AbiEraseFlash();
STATUS AbiProgramFlash(ADDR addr, char* pchBuff, UINT uPatternLen);

/////////////////////////////////////////////////////////////////                  
// External rountines declaration
//
extern STATUS SendReceive(UINT lp, int tcount);

/****************************************************************************
**
**  Name: AbiGetMemN
**
**  Description:
**
**  Parameters:
**     input:
**
**     output:
**
**  Return data --
**
****************************************************************************/
STATUS AbiGetMemN(ADDR addr1, ADDR addr2,char* pchBuff)
{   
STATUS status;
UINT lp; 
UINT len;
    
    if (addr1.addrType == MEM_UNDEFINED) 
    	return(ICE_PARA_ERROR);
    	
    lp = 0;

    SaveId(FW_GET_MEM_N,lp);
    SaveVar(addr1,lp,sizeof(ADDR)); 
    SaveVar(addr2,lp,sizeof(ADDR));

    status = SendReceive(lp, BASE_TIME);
    if (status == ICE_OK){
        len =*(UINT*) &inputStream[1];
        memcpy(pchBuff,&inputStream[3],len);
    }
    return( status );
}

/****************************************************************************
**
**  Name: AbiSetMemN
**
**  Description:
**
**  Parameters:
**     input:
**
**     output:
**
**  Return data --
**
****************************************************************************/
STATUS AbiSetMemN(ADDR addr, char* pchBuff, UINT uPatternLen)
{
STATUS status;
ADDR addr2;
UINT lp; 

    lp = 0;
    addr2.addrType = addr.addrType;
    addr2.addr = addr.addr + uPatternLen-1;

    SaveId(FW_FILL,lp);
    SaveVar(addr,lp,sizeof(ADDR));
    SaveVar(addr2,lp,sizeof(ADDR));
    SaveBuff(pchBuff,lp,uPatternLen);

    status = SendReceive(lp, BASE_TIME);

    if (status == ICE_FAIL_MEM_WRITE)
      memcpy(&retAddr,&inputStream[1],sizeof(ADDR));
    return(status);

}


/****************************************************************************
**
**  Name: AbiFill
**
**  Description:
**
**  Parameters:
**     input:
**
**     output:
**
**  Return data --
**
****************************************************************************/
STATUS AbiFill(ADDR addr1, ADDR addr2,char* pchBuff, UINT uPatternLen)
{
    STATUS status;
    UINT lp,tCount; 
    
    lp =0;
    
    SaveId(FW_FILL,lp);           
    SaveVar(addr1,lp,sizeof(ADDR)); 
    SaveVar(addr2,lp,sizeof(ADDR));

    SaveBuff(pchBuff,lp,uPatternLen);

    tCount = 1;//(U16)(len/M128K) + 1;
    status = SendReceive(lp, BASE_TIME);

    if (status == ICE_FAIL_MEM_WRITE)
      memcpy(&retAddr,&inputStream[1],sizeof(ADDR));
    return(status);
}

/**************************************************************************
**
** Name : AbiChecksum
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
STATUS AbiChecksum(ADDR addr1, ADDR addr2, UINT *uChecksum)
{
    STATUS status;
    UINT lp,tCount;

    lp = 0;
    SaveId(FW_CHECKSUM,lp);
    SaveVar(addr1,lp,sizeof(ADDR)); 
    SaveVar(addr2,lp,sizeof(ADDR));

   tCount = 1;//(U16)(len/M128K) + 1;
   status = SendReceive(lp, BASE_TIME);
   
   if (status == ICE_OK)
      *uChecksum = *(UINT*)&inputStream[1]; /* checksum */

   return(status);
}

/**************************************************************************
**
** Name : AbiTest
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
STATUS AbiTest(ADDR addr1, ADDR addr2)
{
    STATUS status;
    UINT lp,tCount;

    lp = 0;
    SaveId(FW_TEST,lp);
    SaveVar(addr1,lp,sizeof(ADDR)); 
    SaveVar(addr2,lp,sizeof(ADDR));

    tCount = 1;//(U16)(len/M128K) + 1;
    status = SendReceive(lp, BASE_TIME);
    if (status == ICE_FAIL_MEM_WRITE) {
        memcpy(&retAddr,&inputStream[1],sizeof(ADDR));
        retAddr.addrType = 0;
    }
    return(status);
}

/**************************************************************************
**
** Name : AbiCopy
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
STATUS AbiCopy(ADDR addr1, ADDR addr2, ADDR destAddr)
{
    STATUS status;
    UINT lp,tCount;

    lp = 0;
    SaveId(FW_COPY,lp);
    SaveVar(addr1,lp,sizeof(ADDR)); 
    SaveVar(addr2,lp,sizeof(ADDR));
    SaveVar(destAddr, lp, sizeof(ADDR));

    tCount = 1;//(U16)(len/M128K) + 1;
    status = SendReceive(lp, 5*BASE_TIME);
    if (status == ICE_FAIL_MEM_WRITE) 
        memcpy(&retAddr,&inputStream[1],sizeof(ADDR));
    return(status);
}

/**************************************************************************
**
** Name : AbiSearch
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
STATUS AbiSearch(ADDR addr1, ADDR addr2, SEARCH_INFO searchInfo, 
                 ADDR* retAddr)
{
    STATUS status;
    UINT lp,tCount;

    lp = 0;
    SaveId(FW_SEARCH,lp);
    SaveVar(addr1,lp,sizeof(ADDR)); 
    SaveVar(addr2,lp,sizeof(ADDR));
    SaveVar(searchInfo,lp,sizeof(SEARCH_INFO));

    tCount = 1;//(U16)(len/M128K) + 1;
    status = SendReceive(lp, BASE_TIME);
    if (status == ICE_OK) {
        if (inputStream[1] == 0)
            status = ICE_NOT_FOUND;
        else {    
            memcpy(retAddr,&inputStream[1],sizeof(ADDR));
            status = ICE_FOUND;
        }
    }        
    return(status);
}


/**************************************************************************
**
** Name : AbiCompare
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
STATUS AbiCompare(ADDR addr1, ADDR addr2, ADDR destAddr,
                  ADDR* retAddr)
{
    STATUS status;
    UINT lp,tCount;

    lp = 0;
    SaveId(FW_COMPARE,lp);
    SaveVar(addr1,lp,sizeof(ADDR));
    SaveVar(addr2,lp,sizeof(ADDR));
    SaveVar(destAddr, lp, sizeof(destAddr));

    tCount = 1;//(U16)(len/M128K) + 1;
    status = SendReceive(lp, BASE_TIME);
   
    if (status == ICE_OK){
        if (inputStream[1] == 0)
            status = ICE_NOT_FOUND;
        else {     
            memcpy(retAddr,&inputStream[1],sizeof(ADDR));
            status = ICE_FOUND;
        }    
    }        
    return(status);
}


/**************************************************************************
**
** Name : AbiGetMap
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
STATUS AbiGetMap(ADDR addr1, ADDR addr2, MAP_INFO* mapInfo)
{ 
    STATUS status;
    UINT lp,tCount;

    lp = 0;
    SaveId(FW_GET_MAP,lp);
    SaveVar(addr1,lp,sizeof(ADDR)); 
    SaveVar(addr2,lp,sizeof(ADDR));

    tCount = 1;//(U16)(len/M128K) + 1;
    status = SendReceive(lp, BASE_TIME);
 
    if (status == ICE_OK) 
        memcpy(mapInfo, &inputStream[1],sizeof(MAP_INFO));
    return(status);

}

/**************************************************************************
**
** Name : AbiSetMap
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
STATUS AbiSetMap(MAP_INFO mapInfo)
{ 
    STATUS status;
    UINT lp,tCount;

    lp = 0;
    SaveId(FW_SET_MAP,lp);
    SaveVar(mapInfo, lp,sizeof(mapInfo));

    tCount = 1;//(U16)(len/M128K) + 1;
    status = SendReceive(lp, BASE_TIME);
 
    return(status);

}
     
/**************************************************************************
**
** Name : AbiGetErrorAddr
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
ADDR AbiGetErrorAddr()
{ 
    return(retAddr);
}

/*****************************************************
**
** Name : AbiSetVerify()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiSetVerify(FLAG uVerifyFlag)
{
    STATUS status;
    UINT lp;

    lp = 0;
    SaveId(FW_SET_VERIFY_ONOFF,lp);
    SaveVar(uVerifyFlag, lp, sizeof(FLAG));

    status = SendReceive(lp, BASE_TIME);
    return status;
}

/*****************************************************
**
** Name : AbiInitEprom()
**
** Function: Before programming, initialize the
**           communication with EPROM
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiInitEprom()
{
    STATUS status;
    UINT lp;

    lp = 0;
    SaveId(FW_INIT_EPROM,lp);
    status = SendReceive(lp, BASE_TIME);
    
    return(status);
}

/*****************************************************
**
** Name : AbiBurnEprom()
**
** Function:
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiBurnEprom(BURN_EPROM burnEprom, WORD *wChecksum)
{
    STATUS status;
    UINT lp;

    lp = 0;
    SaveId(FW_BURN_EPROM,lp);
    SaveVar(burnEprom, lp, sizeof(BURN_EPROM));
    status = SendReceive(lp, BASE_TIME);
    
    if (status == ICE_OK) {
        if (burnEprom.wActionId != 1)
            *wChecksum = *((WORD *) &inputStream[1]);
    }
    else {
        retAddr.addr = *((WORD *) &inputStream[1]);
    }
    return(status);

}

/*****************************************************
**
** Name : AbiSwitchEprom()
**
** Function:
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiSwitchFlash()
{
    STATUS status;
    UINT lp;

    lp = 0;
    SaveId(FW_FLASH_SWITCH,lp);
    status = SendReceive(lp, BASE_TIME);
    
    return(status);
}
     
/*****************************************************
**
** Name : AbiEraseFlash()
**
** Function:
**
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiEraseFlash()
{
    STATUS status;
    UINT lp;

    lp = 0;
    SaveId(FW_FLASH_ERASE,lp);
    status = SendReceive(lp, BASE_TIME);
    
    return(status);
}

/*****************************************************
**
** Name : AbiProgramFlash()
**
** Function:
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiProgramFlash(ADDR addr, char* pchBuff, UINT uPatternLen)
{
    STATUS status;
    UINT lp = 0;

    SaveId(FW_FLASH_PROGRAM,lp);

    SaveVar(uPatternLen, lp, 1);
    SaveVar(addr,lp,sizeof(ADDR));

    memcpy(&outputStream[lp], pchBuff, uPatternLen);
    lp += uPatternLen;


    status = SendReceive(lp, BASE_TIME);
    
    return(status);
}

     
