/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/DIAGNO/DIAGNOST.H__   1.5   20 Jun 1996 09:34:26   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/DIAGNO/DIAGNOST.H__  $
** 
**    Rev 1.5   20 Jun 1996 09:34:26   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.4   11 Jun 1996 10:33:28   ZJRD
** EasyPack/SLD Version 1.97
** 
**    Rev 1.2   05 Jun 1996 15:01:02   ZJRD
** EasyPack/SLD Version 1.96
** 
**    Rev 1.1   29 May 1996 09:43:02   ZJRD
** No change.
** 
**    Rev 1.0   16 May 1996 09:12:44   ZJRD
** Initial revision.
** 
****************************************************************************/
// diagnost.h : header file
//
//john chow 96.3
////////////////////////////////////////////////////////////////////////////
// CDiagnosticBox dialog
#ifndef _DIAGNOST_H
#define _DIAGNOST_H
#include "afxwin.h"
#include "afxext.h"
#include "resource.h"  
#include "meter.h" 
#include "abibase.h"

#define IDC_METER 51000

class CDiagnosticBox : public CDialog
{
// Construction
public:
    CDiagnosticBox(CWnd* pParent = NULL);   // standard constructor
    ~CDiagnosticBox();

// Dialog Data
    //{{AFX_DATA(CDiagnosticBox)
    enum { IDD = IDD_DIAGNOSTICBOX };
    CButton m_Button_Locate;
    CButton m_buttonDetail;
    CButton m_buttonQuit;
    CButton m_buttonEmulationRam;
    CButton m_buttonCheckTraceRam;
    CButton m_buttonCheckSpoonRam;
    CButton m_buttonCheckPIOCTC;
    CButton m_buttonCheckMapRam;
    CButton m_buttonCheckEventDataRam;
    CButton m_buttonCheckEventAddrRam;
    CButton m_buttonDiagnostic;
    CButton m_buttonCheckAll;
    CString m_POIResult;
    CString m_MAPRAMResult;
    CString m_EVENTADDRResult;
    CString m_EVENTDATARAMResult;
    CString m_SPOONRAMResult;
    CString m_EMULATIONRAMResult;
    CString m_TRACERAMResult;
    CString m_AllResult;
    //}}AFX_DATA

//members                 
protected:
    WORD wTimerCounter[10];//defined for showing diagnosis percent 
    HINSTANCE hLib;    
    CMeterControl m_Meter;
    CBrush  m_br;
    UINT m_nTimerID;
    BOOL m_isCanTime;
    BYTE m_bCurrentStep; 
    unsigned char m_nErrPIO;
    unsigned char m_nErrTrace;
    BYTE m_bPOIResult;
    BYTE m_bMAPRAMResult;
    BYTE m_bEVENTADDRResult;
    BYTE m_bEVENTDATARAMResult;
    BYTE m_bSPOONRAMResult;
    BYTE m_bEMULATIONRAMResult;
    BYTE m_bTRACERAMResult;
             
    WORD m_nPOIResultAddr;
    WORD m_nMAPRAMResultAddr;
    WORD m_nEVENTADDRResultAddr;
    WORD m_nEVENTDATARAMResultAddr;
    WORD m_nSPOONRAMResultAddr;
    WORD m_nEMULATIONRAMResultAddr;
    WORD m_nTRACERAMResultAddr;

// Implementation
private:
    void DecideDiagnosticButtonStatus();
    void DecideDetailButtonStatus();
    void SetMeter();
    void DeleteMeter();
protected:
    virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
    // Generated message map functions
    //{{AFX_MSG(CDiagnosticBox)
    afx_msg void OnButtonDiagnostic();
    afx_msg void OnCheckAll();
    afx_msg void OnCheckPioctc();
    afx_msg void OnCheckEventaddrram();
    afx_msg void OnCheckEventdataram();
    afx_msg void OnCheckMapram();
    afx_msg void OnCheckSpoonram();
    afx_msg void OnCheckTraceram();
    afx_msg void OnEmulationram();
    virtual BOOL OnInitDialog();
    afx_msg void OnTimer(UINT nIDEvent);
    virtual void OnCancel();
    afx_msg void OnSize(UINT nType, int cx, int cy);
    afx_msg void OnButtonDetail();
    afx_msg HBRUSH OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor);
    afx_msg void OnDestroy();
    afx_msg void OnPaint();
    afx_msg void OnButtonLocate();
    //}}AFX_MSG
    DECLARE_MESSAGE_MAP()
};
#endif
///////////////////////////END OF FILE //////////////////////////////////
