
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/DIAGNO/METER.H__   1.5   20 Jun 1996 09:34:30   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/DIAGNO/METER.H__  $
** 
**    Rev 1.5   20 Jun 1996 09:34:30   ZJRD
** No change.
** 
**    Rev 1.4   11 Jun 1996 10:33:18   ZJRD
** EasyPack/SLD Version 1.97
** 
**    Rev 1.2   05 Jun 1996 15:00:48   ZJRD
** No change.
** 
**    Rev 1.1   29 May 1996 09:42:46   ZJRD
** No change.
** 
**    Rev 1.0   16 May 1996 09:12:42   ZJRD
** Initial revision.
** 
**    Rev 1.1   02 May 1996 10:22:38   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.25   18 Apr 1996 13:01:40   Shirley
** No change.
** 
**    Rev 1.24   12 Apr 1996 10:38:40   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.22   15 Feb 1996 08:51:36   Shirley
** No change.
** 
**    Rev 1.21   12 Feb 1996 14:06:04   Shirley
** No change.
** 
**    Rev 1.20   06 Feb 1996 15:32:36   Shirley
** No change.
** 
**    Rev 1.19   06 Feb 1996 13:46:50   Shirley
** No change.
** 
**    Rev 1.18   01 Feb 1996 10:13:22   Shirley
** No change.
** 
**    Rev 1.17   26 Jan 1996 09:17:34   Shirley
** No change.
** 
**    Rev 1.16   25 Jan 1996 13:17:30   Shirley
** No change.
** 
**    Rev 1.15   24 Jan 1996 10:36:54   Shirley
** No change.
** 
**    Rev 1.14   23 Jan 1996 11:27:24   Shirley
** No change.
** 
**    Rev 1.13   18 Jan 1996 10:10:40   Shirley
** No change.
** 
**    Rev 1.12   15 Jan 1996 16:11:42   Shirley
** No change.
** 
**    Rev 1.11   04 Jan 1996 11:12:40   Shirley
** No change.
** 
**    Rev 1.10   30 Nov 1995 09:11:56   Shirley
** No change.
** 
**    Rev 1.9   28 Nov 1995 15:33:58   Shirley
** No change.
** 
**    Rev 1.8   21 Nov 1995 11:19:46   Shirley
** No change.
** 
**    Rev 1.7   13 Nov 1995 09:25:38   Shirley
** No change.
** 
**    Rev 1.6   12 Nov 1995 11:28:36   Shirley
** EasyPack/SLD Version 0.24
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  METER.H
//
//  Description:The header file for the class: CMeterControl
//
//  Author:     Roger Zhang
//
//  Date:       10/16/95
//
//  Modification:
//
//      1. 10/16/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#ifndef _METER_
#define _METER_

// Meter control sends WM_CTLCOLOR message to parent window 
// with the following identifier with in the HIWORD of the lParam.
#define CTLCOLOR_METER     (100)

// Meter control doesn't have any class-specific window styles.

// Meter control's class-specific window messages.
#define MM_SETPARTSINJOB         (WM_USER + 0)
#define MM_GETPARTSINJOB         (WM_USER + 1)
#define MM_SETPARTSCOMPLETE      (WM_USER + 2)
#define MM_GETPARTSCOMPLETE      (WM_USER + 3)

// Meter control has no notification codes to send to parent.

#define DLG_STYLEDLG    1000
#define ID_VALUE        100


class CMeterControl : public CWnd
{
    DECLARE_DYNAMIC(CMeterControl)

// Constructors
public:
    CMeterControl();
    BOOL Create(DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID);

// Attributes                                  
    void SetPartsInJob(WORD wParts);
    WORD GetPartsInJob(void);
    void SetPartsComplete(WORD wParts);
    WORD GetPartsComplete(void);

// Implementation
protected:
    virtual WNDPROC* GetSuperWndProcAddr();
};

/////////////////////////////////////////////////////////////////////////////
// inlines                      
inline CMeterControl::CMeterControl() {}
inline void CMeterControl::SetPartsInJob(WORD wParts)
{ SendMessage(MM_SETPARTSINJOB, wParts); }
inline WORD CMeterControl::GetPartsInJob(void)
{ return (WORD)SendMessage(MM_GETPARTSINJOB); }
inline void CMeterControl::SetPartsComplete(WORD wParts)
{                                            
	wParts = min(max(0, wParts), 100);
	SendMessage(MM_SETPARTSCOMPLETE, wParts); 
}
inline WORD CMeterControl::GetPartsComplete(void)
{ return (WORD)SendMessage(MM_GETPARTSCOMPLETE); }

#endif
//////////////////////////////(EOF)//////////////////////////////////////////
