
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/DIBAPI.H__   1.8   20 Jun 1996 09:24:52   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/DIBAPI.H__  $
** 
**    Rev 1.8   20 Jun 1996 09:24:52   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.6   10 Jun 1996 10:19:30   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.4   29 May 1996 09:28:36   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:05:50   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:11:52   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:23:42   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 12:57:28   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:42:56   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:55:02   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:03:16   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:29:44   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:44:06   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:17:04   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:19:40   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:19:34   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:32:42   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:26:28   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:15:06   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:17:14   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:14:20   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:14:34   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:29:06   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:21:20   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:24:36   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:28:52   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:31:46   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:40:20   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:07:36   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:50:48   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:47:12   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:31:26   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:47:18   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:24:28   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:48:22   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:54:14   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:45:40   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:55:42   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  DIBAPI.H
//
//  Description:The header file for the DIB APIs:
//
//      PaintDIB()          - Painting routine for a DIB
//      CreateDIBPalette()  - Creates a palette from a DIB
//      FindDIBBits()       - Returns a pointer to the DIB bits
//      DIBWidth()          - Gets the width of the DIB
//      DIBHeight()         - Gets the height of the DIB
//      PaletteSize()       - Gets the size required to store the DIB's palette
//      DIBNumColors()      - Calculates the number of colors
//                            in the DIB's color table
//      CopyHandle()        - Makes a copy of the given global memory block
//      SaveDIB()           - Saves the specified dib in a file
//      ReadDIBFile()       - Loads a DIB from a file
//
//  Author:     Roger Zhang
//
//  Date:       08/18/95
//
//  Modification:
//
//      1. 08/18/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////


#ifndef _DIBAPI_
#define _DIBAPI_

/* Handle to a DIB */
DECLARE_HANDLE(HDIB);

/* DIB constants */
#define PALVERSION   0x300

/* DIB Macros*/

#define IS_WIN30_DIB(lpbi)  ((*(LPDWORD)(lpbi)) == sizeof(BITMAPINFOHEADER))
#define RECTWIDTH(lpRect)     ((lpRect)->right - (lpRect)->left)
#define RECTHEIGHT(lpRect)    ((lpRect)->bottom - (lpRect)->top)

// WIDTHBYTES performs DWORD-aligning of DIB scanlines.  The "bits"
// parameter is the bit count for the scanline (biWidth * biBitCount),
// and this macro returns the number of DWORD-aligned bytes needed
// to hold those bits.

#define WIDTHBYTES(bits)    (((bits) + 31) / 32 * 4)

/* Function prototypes */
BOOL      WINAPI  PaintDIB (HDC, LPRECT, HDIB, LPRECT, CPalette* pPal);
BOOL      WINAPI  CreateDIBPalette(HDIB hDIB, CPalette* cPal);
LPSTR     WINAPI  FindDIBBits (LPSTR lpbi);
DWORD     WINAPI  DIBWidth (LPSTR lpDIB);
DWORD     WINAPI  DIBHeight (LPSTR lpDIB);
WORD      WINAPI  PaletteSize (LPSTR lpbi);
WORD      WINAPI  DIBNumColors (LPSTR lpbi);
HANDLE    WINAPI  CopyHandle (HANDLE h);

BOOL      WINAPI  SaveDIB (HDIB hDib, CFile& file);
HDIB      WINAPI  ReadDIBFile(CFile& file);

#endif 

///////////////////////////////(EOF)/////////////////////////////////////////

