/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/DL.CPP   1.5   20 Jun 1996 09:29:28   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/DL.CPP  $
** 
**    Rev 1.5   20 Jun 1996 09:29:28   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.3   10 Jun 1996 10:24:06   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.1   29 May 1996 09:35:42   ZJRD
** EasyPack/SLD Version 1.95
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
// dl.cpp
//
// Michael Long
//                                                                           
// 5/14/96
//
/////////////////////////////////////////////////////////////////////////////
#include "stdafx.h"

#include "toolopt.h"
#include "dl.h"

/////////////////////////////////////////////////////////////////////////////
// diagnostic
#ifdef _DEBUG
void DLTool::Dump(CDumpContext &dc) const
{         
    CToolOption::Dump(dc);                    
    dc << "m_fLSymbol = " << m_fLSymbol << "\n";
    dc << "m_fLine = " << m_fLine << "\n";
    dc << "m_fPSymbol = " << m_fPSymbol << "\n";
    dc << "m_strMore = " << m_strMore << "\n";
    dc << "m_strPath = " << m_strPath << "\n";
 
}
#endif

/////////////////////////////////////////////////////////////////////////////
// operations
void DLTool::SetDefault(void)
{                                                    
    m_fLSymbol = TRUE;
    m_fLine    = TRUE;
    m_fPSymbol = FALSE;
    m_strMore = "DB DP DL ";
    m_strPath = "c:\\omf51 ";
}

BOOL DLTool::LoadOption(FILE * fp)
{
    ASSERT(fp);
    
    const int nCnt = 3;
    
    char dch[nCnt];
    
    if(fread(dch, 1, nCnt, fp) != nCnt)
        return FALSE;
        
    m_fLSymbol = dch[0];
    m_fLine = dch[2];
    m_fPSymbol = dch[1];
    
    WORD wLen;
    if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_strMore.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strMore.ReleaseBuffer(wLen);  
    if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_strPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strPath.ReleaseBuffer(wLen);  
    
    return TRUE;
}                 

BOOL DLTool::SaveOption(FILE * fp)
{
    ASSERT(fp);
    
    const int nCnt = 3;

    char dch[nCnt];
    
    dch[0] = m_fLSymbol;
    dch[2] = m_fLine;
    dch[1] = m_fPSymbol;
        
    if(fwrite(dch, 1, nCnt, fp) != nCnt)
        return FALSE;
             
    WORD wLen = m_strMore.GetLength();           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_strMore.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strMore.ReleaseBuffer(wLen);
      
    wLen = m_strPath.GetLength();           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_strPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strPath.ReleaseBuffer(wLen);  
    
    return TRUE;
}

CString DLTool::GetOption(void)
{
    CString str = " ";

    if(!m_fLSymbol)    
        str += "NOSB ";
    else
        str += "SB ";
        
    if(!m_fLine)
        str += "NOLI ";
    else
        str += "LI " ;   
           
    if(!m_fPSymbol)
        str += "NOPL ";
    else
        str += "PL ";
    str += m_strMore;
    str += " ";
    
    return str;
}

