
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/ERROR/ERRTEXT.CPP   1.8   20 Jun 1996 09:33:52   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/ERROR/ERRTEXT.CPP  $
** 
**    Rev 1.8   20 Jun 1996 09:33:52   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.6   10 Jun 1996 10:28:18   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.4   29 May 1996 09:42:08   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:11:44   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:19:52   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:34:12   ZJRD
** EasyPack/SLD Versio 1.92
** 
****************************************************************************/

/****************************************************************************
**
**  Name:  ERRTEXT.CPP
**
**  Description:
**      Entry points for error handling.
**
**  Status:  CODED
**
**  Date:    15 Mar. 1996 8:30:00am   by:  Jamoon Zhou
** Initial revision.
**
**  Copyright (C) 1996 Microtek International.  All rights reserved.
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#include "stdafx.h"
#include <stdio.h>
#include <stdarg.h>

#include "hosterrs.h"

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/
static char chErrorText[E_ERRSIZE];

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/
extern  HINSTANCE hTextInst;

                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/

/*****************************************************************************
** ErrGetErrorText
**
** Description:
**   Retrieve error text or recover text and plug in optional arguments.  
**	 The *caller* is expected to have allocated storage for the return 
**	 string of size E_ERRSIZE if LPSTR is used. 
**	 Optional arguments must fit with the error format string. Refer to 
**	 wvsprintf() window function for the format-control character sequences.
**
** Parameters:
**    input :
**       errCode :   error type, and error number 
**					 or recover type, and recover number
**    output :
**       lpszError : error string
**       strError 
** Return :
**		GOOD(0) for success    FAILURE(-1) for failure	
*****************************************************************************/
//RETCODE EXPORT ErrGetFormattedErrorText(U32 errorCode, LPSTR lpError ...)
RETCODE EXPORT ErrGetErrorText(U32 errorCode, LPSTR lpszError ...)
{
	U16 nError = E_ERRORID( errorCode );

//	CString strFormat;
//	if ( !strFormat.LoadString( nError ) ) return FAILURE;
	if ( !LoadString(hTextInst, nError , chErrorText, E_ERRSIZE) )
		return FAILURE;
   	va_list marker;
   	va_start( marker, lpszError );     // Initialize variable arguments.
	wvsprintf( lpszError, chErrorText, marker );
	va_end( marker );
	return GOOD;
}

//RETCODE EXPORT ErrGetFormattedErrorText(U32 errorCode, CString& strError ...)
RETCODE EXPORT ErrGetErrorText(U32 errorCode, CString& strError ...)
{
	char chError[E_ERRSIZE];
	U16 nError = E_ERRORID( errorCode );

	if ( !LoadString(hTextInst, nError , chErrorText, E_ERRSIZE) )
		return FAILURE;
   	va_list marker;
   	va_start( marker, strError );     // Initialize variable arguments.
	wvsprintf( chError, chErrorText, marker );
	va_end( marker );
	strError = chError;
	return GOOD;
}

/*****************************************************************************
** ErrGetErrorText
**
** Description:
**   Retrieve error text and recover text and plug in optional arguments.  
**	 The *caller* is expected to have allocated storage for the return 
**	 string of size E_ERRSIZE if LPSTR is used
**	 Optional arguments must fit with the error format string. Refer to 
**	 wvsprintf() window function for the format-control character sequences.
**
** Parameters:
**    input :
**       errCode :   error type, and error number 
**		 recCode :	 recover type, and recover number
**    output :
**       lpszError : error string 
**		 lpszRecov : recover string
**       strError  : error CString
**		 strRecov  : recover CString
** Return :
**		GOOD(0) for success    FAILURE(-1) for failure	
*****************************************************************************/
RETCODE EXPORT 
//ErrGetErrorRecovText(U32 errCode,U32 recCode,LPSTR lpError, LPSTR lpRecov)
ErrGetErrorText(U32 errCode,U32 recCode,LPSTR lpszError, LPSTR lpszRecov ...)
{
   	va_list marker;
   	va_start( marker, lpszRecov );     // Initialize variable arguments.

	if( ErrGetErrorText( errCode, lpszError,marker ) != GOOD ) {
		va_end( marker );
		return FAILURE;
	}
	va_end( marker );
	
//	if( recCode && ErrGetRecoverText( recCode, lpRecov ) != GOOD )
	if( recCode && ErrGetErrorText( recCode, lpszRecov ) != GOOD )
		return FAILURE;
	return GOOD;
}

//RETCODE EXPORT ErrGetErrorRecovText(U32 errCode,U32 recCode, 
RETCODE EXPORT ErrGetErrorText(U32 errCode,U32 recCode, 
		CString& strError, CString& strRecov ...)
{
   	va_list marker;
   	va_start( marker, strRecov );     // Initialize variable arguments.

	if( ErrGetErrorText( errCode, strError ) != GOOD ) {
		va_end( marker );
		return FAILURE;
	}
	va_end( marker );
	
//	if( recCode && ErrGetRecoverText( recCode, strRecov ) != GOOD )
	if( recCode && ErrGetErrorText( recCode, strRecov ) != GOOD )
		return FAILURE;
	return GOOD;
}

/****************************************************************************
**
**  ErrGetErrorText
**
**  Description:
**     Retrieve the error text corresponding to the given errorCode.
**
**  Parameters:
**     input:
**        errorCode        error id
**	 output:
**        lperrString       text of error message obtained from .rc file
**        strError
**
*****************************************************************************/
/*
RETCODE EXPORT  ErrGetErrorText(U32 errorCode, LPSTR lpError)
{
	return ErrGetFormattedErrorText(errorCode,lpError);
}

RETCODE EXPORT  ErrGetErrorText(U32 errorCode, CString& strError)
{
	return ErrGetFormattedErrorText(errorCode,strError);
}
*/

/****************************************************************************
**
**  ErrGetRecoverText
**
**  Description:
**     Retrieve the error recovery text corresponding to the given recovCode.
**
**  Parameters:
**     input:
**        recovCode        recovery id
**	 output:
**        lpRecover       text of error recovery message obtained from .rc file
**        strREcover
**
*****************************************************************************/
/*
RETCODE EXPORT  ErrGetRecoverText(U32 recovCode, LPSTR lpRecover)
{
//	CString strRes;
//	if( !strRes.LoadString((U16) recovCode ) ) return FAILURE;
	if ( !LoadString(hTextInst,(UINT) recovCode , chErrorText, E_ERRSIZE) )
		return FAILURE;
	lstrcpy(lpRecover,chErrorText);
	return GOOD;
}

RETCODE EXPORT  ErrGetRecoverText(U32 ulRecCode, CString& strRecover)
{
//	if ( !strRecover.LoadString( (U16) recovCode ) ) return FAILURE;
	if ( !LoadString(hTextInst,(UINT) ulRecCode , chErrorText, E_ERRSIZE) )
		return FAILURE;
	strRecover = chErrorText;
	return GOOD;
}
*/


/****************************************************************************
**
**  ErrDisplayError
**
**  Description:
**     Obtain and display the error text corresponding to the given
**     error code.
**
**  Parameters:
**     input:
**        errCode      error id
**        recCode     error recovery id, 0 for nono
**        mode         display mode (shell vs. popup)
**     output:
**        none.
**
*****************************************************************************/
/*
RETCODE EXPORT ErrDisplayError(U32 errCode, U32 recCode )
{
	return ErrDisplayFormattedError(errCode,recCode);
}
*/

/****************************************************************************
**
**  ErrDisplayError
**
**  Description:
**     Obtain and display the error text corresponding to the given error code
**     with MessageBox, optional arguments must fit with the error  format  
**     string. Refer to wvsprintf() window function for the format-control  
**     character sequences.
**
**  Parameters:
**     input:
**        errCode          error code
**        recCode         recovery code
**     output:
**
*****************************************************************************/
RETCODE EXPORT ErrDisplayError(U32 errCode, U32 recCode ...)
{
	CString strErrText, strRecText;
	va_list marker;
	va_start(marker,recCode);
   	if (ErrGetErrorText(errCode, strErrText, marker) != GOOD) 
         return FAILURE; 	// ER_ERCODE_NOT_FOUND;
	if( recCode && ErrGetErrorText(recCode, strRecText) == GOOD ) {
		strErrText += "\n";
		strErrText += "Suggestion: ";
		strErrText += strRecText;
	}
	
	UINT fuStyle = 0;
	CString strCaption;
	
	switch ( errCode & E_SEVERITY_MASK ) {
		case E_WARNING 	:
			fuStyle = MB_ICONINFORMATION;
			strCaption = "Warning";
			break;
		case E_ERROR	 	:
			fuStyle = MB_ICONEXCLAMATION;
			strCaption = "Error";
			break;
		case E_FATAL	 	:
			fuStyle = MB_ICONQUESTION;
			strCaption = "Fatal Error";
			break;
		case E_SEVERE	 	:
			fuStyle = MB_ICONSTOP;
			strCaption = "Severe Error";
			break;
		default :
			fuStyle = MB_ICONEXCLAMATION;
	}
	
	fuStyle |= MB_OK;
	
	MessageBox( GetActiveWindow(), strErrText, strCaption,  
			fuStyle );
/*
#ifdef _USRDLL
	MessageBox( GetActiveWindow(), strErrText, "Error",  
			fuStyle );
#else
	AfxMessageBox( strErrText, fuStyle );
#endif
*/
	return GOOD;
}

RETCODE EXPORT ErrDisplayError(U32 errCode)
{
	return ErrDisplayError( errCode,0);
}

	