
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/ERROR/MKERROR1.H__   1.8   20 Jun 1996 09:33:56   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/ERROR/MKERROR1.H__  $
** 
**    Rev 1.8   20 Jun 1996 09:33:56   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.6   10 Jun 1996 10:28:22   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.4   29 May 1996 09:42:12   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:11:48   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:19:56   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:34:16   ZJRD
** EasyPack/SLD Versio 1.92
** 
****************************************************************************/

/****************************************************************************
**
**  Name:  mkerror1.h
**
**  Description:
**     This is the ONLY file to change in order to add or change error
**     definitions in EP/SLD
**
**	Date: 3/20/96		By:  Jamoon Zhou
**
**  Copyright (C) 1996 Microtek International.  All rights reserved.
**
*****************************************************************************/

#define _MKERROR1_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

/*
 * Here are all the error codes for all the error types in EP/SLD
 * The corresponding error text is in errtext.rc.
 *
 * ONLY MAKE CHANGES BELOW THIS LINE (in mkerrors.h)
 */
{
	"ER_NO_SUCH_ERRORCODE",
	E_ERROR | ( 0x500 ),
	"No such error code/recovery code."
},
{
   "ER_ADDRESS_NOT_FOUND",
   ( E_WARNING | 0L | 503L ),
   "Cannot find address in symbol table.",
},
{
   "ER_ADDRESS_UPDATED",
   ( E_WARNING | 0L | 504L ),
   "Public symbol updated.",
},
{
   "ER_ADR_END_ADDR_TOO_SMALL",
   ( E_ERROR | 0L | 510L ),
   "Cannot set end address smaller than start address.",
},
{
   "ER_ARRAY_INDEX_TOO_LARGE",
   (  E_ERROR  | 0L | 524L ),
   "Attempt to get a structure or union element larger than the structure or union.",
},
{
   "ER_BASENAME_NOT_FOUND",
   ( E_ERROR | 0L | 1156L ),
   "Cannot find base name.",
},
{
   "ER_BYADDRTABLE_EMPTY",
   (  E_ERROR | 0L | 574L ),
   "Line numbers cannot be loaded; invalid load state.",
},
{
   "ER_CLI_SYNTAX",
   ( E_ERROR | 0L | 648L ),
   "Syntax error.",
},
{
   "ER_DUPLICATE_GLOBAL_NAME",
   (  E_ERROR | 0L | 712L ),
   "Duplicate symbol name.",
},
{
   "ER_HEAP_CORRUPT",
   ( E_SEVERE | 0L | 728L ),
   "Memory has been corrupted; save work and exit program.",
},
{
   "ER_INDEX_ALREADY_EXISTS",
   (  E_ERROR | 0L | 734L ),
   "Cannot create base index.",
},
{
   "ER_INDEX_NOT_IN_TABLE",
   (  E_ERROR | 0L | 735L ),
   "Base index not in table.",
},
{
   "ER_INDEX_OUT_OF_BOUNDS",
   (  E_ERROR | 0L | 736L ),
   "Base index too large.",
},
{
   "ER_INVALID_ADDRESS",
   (  E_ERROR | 0L | 742L ),
   "Invalid symbol address.",
},
{
   "ER_INVALID_SYM_DESCRIPTOR",
   (  E_ERROR | 0L | 766L ),
   "Invalid symbol descriptor.",
},
{
   "ER_LINENUM_BAD_STATE",
   (  E_ERROR | 0L | 772L ),
   "Cannot add line number symbols.",
},
{
   "ER_LINENUM_INDEX_TOO_LARGE",
   (  E_ERROR | 0L | 773L ),
   "Line number index too large.",
},
{
   "ER_LINENUM_NOT_FOUND",
   ( E_ERROR | 0L | 774L ),
   "Cannot find line number.",
},
{
   "ER_LINENUMS_ALREADY_LOADED",
   (  E_ERROR | 0L | 770L ),
   "Line numbers have already been loaded.",
},
{
   "ER_LOADFILES_DONT_MATCH",
   (  E_ERROR | 0L | 778L ),
   "The load filename does not match previous load.",
},
{
   "ER_MODULE_ALREADY_OPEN",
   (  E_ERROR | 0L | 804L ),
   "Cannot open two modules simultaneously for symbol loading.",
},
{
   "ER_NAME_NOT_ADDED",
   ( E_ERROR | 0L | 808L ),
   "Cannot add module reference to symbol table. (Warning only.)",
},
{
   "ER_NO_LIFETIME_INFO",
   (  E_ERROR | 0L | 831L ),
   "Symbol has no lifetime information.",
},
{
   "ER_NO_LINEBLK_IN_MODULE",
   ( E_ERROR | 0L | 1044L ),
   "Module %s does not contain line number information.",
},
{
   "ER_NO_LINENUMS_ADDED",
   ( E_ERROR | 0L | 832L ),
   "There are no line numbers for this module.",
},
{
   "ER_NO_VALID_ADDRESS",
   (  E_ERROR | 0L | 851L ),
   "Invalid address.",
},
{
   "ER_NOT_A_VARIABLE",
   (  E_ERROR | 0L | 815L ),
   "Expected a variable type symbol.",
},
{
   "ER_NOT_IMPLEMENTED",
   (  E_ERROR | 0L | 819L ),
   "A variable address was requested, a code address was found.",
},
{
   "ER_OUT_OF_MEMORY",
   (  E_ERROR | 0L | 857L ),
   "Out of memory.",
},
{
   "ER_PUBLIC_IGNORED",
   ( E_ERROR | 0L | 861L ),
   "Public symbol ignored.",
},
{
   "ER_REGISTER_CLASS_UNKNOWN",
   (  E_ERROR | 0L | 864L ),
   "Unknown register class.",
},
{
   "ER_STORAGE_CLASS_UNKNOWN",
   (  E_ERROR | 0L | 933L ),
   "The variable has an unknown storage class.",
},
{
   "ER_STRING_LENGTH_ZERO",
   (  E_ERROR | 0L | 935L ),
   "This function or feature is not yet implemented.",
},
{
   "ER_SYM_INVALID_CHAR",
   (  E_ERROR | 0L | 947L ),
   "Invalid character.",
},
{
   "ER_SYM_INVALID_LN_END_ADDR",
   ( E_WARNING | 0L | 948L ),
   "No symbol information available about source modules.",
},
{
   "ER_SYM_LOCAL_VAR_ADDRESS",
   ( E_WARNING | 0L | 949L ),
   "Symbol is a local variable, thus it does not have a static address.",
},
{
   "ER_SYM_LOOP_COMPLETE",
   (  E_ERROR | 0L | 950L ),
   "Loop complete.",
},
{
   "ER_SYM_MAX_SEGCOUNT_REACHED",
   ( E_ERROR | 0L | 1148L ),
   "Maximum segments/selectors exceeded.",
// The load file has more segments/selectors than are supported by the
// symbol table.
},
{
   "ER_SYM_NO_CURRENT_CONTEXT",
   ( E_ERROR | 0L | 954L ),
   "The current execution context does not match any known module.",
},
{
   "ER_SYM_NO_MODULES_LOADED",
   ( E_ERROR | E_WARNING | 0L | 956L ),
   "No source module(s) loaded.",
},
{
   "ER_SYM_NOT_CODE_ADDRESS",
   (  E_ERROR | 0L | 951L ),
   "Attempted to put a zero length string into the symbol table.",
},
{
   "ER_SYM_NOT_DATA_ADDRESS",
   (  E_ERROR | 0L | 952L ),
   "Cannot increase the table size; out of memory.",
},
{
   "ER_SYM_OUT_OF_MEMORY",
   ( E_ERROR | 0L | 957L ),
   "Out of memory.",
},
{
   "ER_SYM_REG_VAR_NOT_ALLOWED",
   (  E_ERROR | 0L | 958L ),
   "A public variable cannot be a register.",
},
{
   "ER_SYM_STACK_FULL",
   (  E_ERROR | 0L | 960L ),
   "The number of nested functions and/or blocks exceeded internal limit.",
},
{
   "ER_SYM_SYM_START_NOT_SHARP",
   ( E_ERROR | 0L | 962L ),
   "Invalid symbol address type.",
},
{
   "ER_SYM_SYMBOL_NOT_IN_MODULE",
   (  E_SEVERE | 0L | 961L ),
   "Cannot sort symbols by address, none loaded into the symbol table.",
},
{
   "ER_SYMBOL_HAS_NO_CHILD",
   (  E_ERROR | 0L | 938L ),
   "Expected symbol to have a nested function or block.",
},
{
   "ER_SYMBOL_HAS_NO_LISTS",
   (  E_ERROR | 0L | 939L ),
   "Expected symbol to contain variables, labels, or constants.",
},
{
   "ER_SYMBOL_NOT_A_FUNCTION",
   (  E_ERROR | 0L | 940L ),
   "Expected a function type symbol.",
},
{
   "ER_SYMBOL_NOT_A_LABEL",
   (  E_ERROR | 0L | 941L ),
   "Symbol is not a label.",
},
{
   "ER_SYMBOL_NOT_A_MODULE",
   ( E_ERROR | 0L | 942L ),
   "No symbols are loaded.",
},
{
   "ER_SYMBOL_NOT_FOUND",
   ( E_WARNING | 0L | 943L ),
   "Cannot find symbol.",
},
{
   "ER_SYMBOL_STACK_EMPTY",
   (  E_ERROR | 0L | 944L ),
   "When loading modules, functions, and/or blocks, more closes than opens occurred.",
},
{
   "ER_SYMBOLS_LOADED",
   ( E_ERROR | 0L | 937L ),
   "Symbols already loaded.",
},
{
   "ER_TABLE_SMALLER_THAN_INDEX",
   ( E_ERROR | 0L | 964L ),
   "Symbol not located in table - base index too large.",
},
{
   "ER_TIMESTAMPS_DONT_MATCH",
   ( E_WARNING | 0L | 966L ),
   "The load file time stamp does not match previously loaded file's time stamp.",
},
{
   "ER_TOO_MANY_SYMBOLS",
   (  E_ERROR | 0L | 972L ),
   "Too many symbols in base.",
},
{
   "ER_TYPE_IDXS_DONT_MATCH",
   (  E_ERROR | 0L | 979L ),
   "Type index does not match.",
},
{
   "ER_TYPE_TOO_LARGE",
   (  E_ERROR | 0L | 980L ),
   "Symbol type information too large.",
},
{
   "ER_UNKNOWN_FWREF_TYPE",
   ( E_ERROR | 0L | 1043L ),
   "Unknown forward reference type.",
},
{
   "ER_UNKNOWN_LIST_TYPE",
   (  E_ERROR | 0L | 985L ),
   "Unknown symbol list.",
},
{
   "ER_UPDATE_BLOCK_FAIL",
   (  E_ERROR | 0L | 989L ),
   "Cannot update last symbol block.",
},
/* next error code available:  1189*/
/***************************** EOF *****************************************/
