
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/ERROR/MKERRORS.H__   1.8   20 Jun 1996 09:33:56   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/ERROR/MKERRORS.H__  $
** 
**    Rev 1.8   20 Jun 1996 09:33:56   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.6   10 Jun 1996 10:28:22   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.4   29 May 1996 09:42:14   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:11:48   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:19:58   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:34:16   ZJRD
** EasyPack/SLD Versio 1.92
** 
****************************************************************************/

/****************************************************************************
**
**  Name:  mkerrors.h
**
**  Description:
**     This is the ONLY file to change in order to add or change error
**     definitions in EP/SLD.  This file is the source for several
**     other files, which are automatically produced by mkerrors.exe.
**     The generated files are:
**       errcodec.h : error code defines in C format
**       errerr.h : error code offsets in the errtext.rc file
**       errtext.rc : string resources (error text)
**       mkerrors.new : the next version of THIS header file
**
**  Status:  PRELIMINARY
**
**  Date:     8 March 1996 09:11:00  by Jamoon Zhou
**
**
**  Copyright (C) 1996 Microtek International.  All rights reserved.
**
*****************************************************************************/

#define _MKERRORS_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

//  Here are all the error codes for all the error types in EP/SLD
//  The corresponding error text is in errtext.rc.
//  ONLY MAKE CHANGES BELOW THIS LINE (in mkerrors.h)
/*
{
	"ER_LDR_",
	( 0x400 ),
	
}, 
*/
{
	"ER_LDR_MEMORY_ALLOC",
	E_SEVERE | ( 0x4000 ),
	"Memory alloc failure!",
}, 
{
	"ER_LDR_ABI_MEMORY_READ",
	E_FATAL | ( 0x4001 ),
	"Memory read failure!"
}, 
{
	"ER_LDR_ABI_MEMORY_WRITE",
	E_FATAL | ( 0x4002 ),
	"Memory write failure!"
}, 
{
	"ER_SYM_UPLOAD_OPEN_FILE",
	E_ERROR | ( 0x4003 ),
	"Open file error!"
}, 
{
	"ER_SYM_EXIST",
	E_ERROR | ( 0x4004 ),
	"The symbol exists!"
}, 
{
	"ER_SYM_NOT_EXIST",
	E_ERROR | ( 0x4005 ),
	"The symbol does not exist!"
}, 
{
	"ER_SYM_CREATE_SYM",
	E_ERROR | ( 0x4006 ),
	"Create symbol failure!"
}, 
{
	"ER_SYM_DELETE_SYM",
	E_ERROR | ( 0x4007 ),
	"Delete symbol failure!",
}, 
{
	"ER_SYM_FILE_READ",
	E_ERROR | ( 0x4008 ),
	"Symbol file read error!",
}, 
{
	"ER_SYM_NO_SYM",
	E_WARNING | ( 0x4009 ),
	"no user defined symbol!",
}, 
{
	"ER_SYM_STRUCT",
	E_ERROR | ( 0x400A ),
	"Symbol struct error!",
}, 
{
	"ER_SYM_NOT_SYM_FILE",
	E_ERROR | ( 0x400B ),
	"Not a symbol file!",
}, 
{
	"ER_SYM_FILE_READ2",
	E_ERROR | ( 0x400C ),
	"symbol file read error!",
}, 
{
	"ER_LDR_2500AD_NO_ONDEM",
	E_ERROR | ( 0x400D ),
	"2500AD loader have not ondemand load!",
}, 
{
	"ER_LDR_SYM_FILE_FORMAT",
	E_ERROR | ( 0x400E ),
	"Symbol file format error!",
}, 
{
	"ER_LDR_READ_FILE",
	E_ERROR | ( 0x400F ),
	"Loader read file error!"
}, 
{
	"ER_LDR_ABORT",
	E_WARNING | ( 0x4010 ),
	"User abort requested.",
}, 
{
	"ER_LDR_2500AD_SYM_ADDR",
	E_WARNING | ( 0x4011 ),
	"2500AD format symbol address is not 16 bits",
}, 
{
	"ER_LDR_SYM_TYPE",
	E_ERROR | ( 0x4012 ),
	"Symbol Type Error!",
}, 
{
	"ER_LDR_FILE_FORMAT",
	E_ERROR | ( 0x4014 ),
	"Load file format error!",
}, 
{
	"ER_LDR_FUNC_LIST",
	E_ERROR | ( 0x4015 ),
	"Function list describes error!",
},
{
	"ER_LDR_TYPE",
	E_ERROR | ( 0x4016 ),
	"Error type!",
}, 
{
	"ER_LDR_NOT_RL51",
	E_ERROR | ( 0x4017 ),
	"Loading file is not generated by RL51!",
}, 
{
	"ER_LDR_RELOC_SYM",
	E_ERROR | ( 0x4018 ),
	"It is a relocatable symbol!",
}, 
{
	"ER_LDR_SCOPE",
	E_ERROR | ( 0x4019 ),
	"scope error!",
}, 
{
	"ER_LDR_MODULE_FORMAT",
	E_ERROR | ( 0x401A ),
	"Module format error !",
}, 
{
	"ER_LDR_MODNAME_NOT_MATCH",
	E_ERROR | ( 0x401B ),
	"Module name can not be matched!",
}, 
{
	"ER_LDR_BLOCK_INFO",
	E_ERROR | ( 0x401C ),
	"Block information error!",
}, 
{
	"ER_LDR_FUNCNAME_NOT_MATCH",
	E_ERROR | ( 0x401D ),
	"Function name can not be matched!",
}, 
{
	"ER_LDR_RELOC_ADDR",
	E_ERROR | ( 0x401E ),
	"A relocation address is meeting!",
},
{
	"ER_LDR_OMF51_FORMAT",
	E_ERROR | ( 0x401F ),
	"Omf51 format error !",
},
{
	"ER_LDR_DOWNLOAD_MEM",
	E_FATAL | ( 0X4020 ), 
	"Download file to memory failure !",
},
{
	"ER_LDR_LOAD_MODULE",
	E_ERROR | ( 0x4021 ),
	"Load module error!",
}, 
{
	"ER_LDR_MOD_INFO_LOADED",
	E_WARNING | ( 0x4022 ),
	"module information have been loaded!",
}, 
{
	"ER_LDR_ARRAY_HIGH_BOUND",
	E_ERROR | ( 0x4023 ),
	"Array high bound error !",
}, 
{
	"ER_LDR_UBROF_FORMAT",
	E_ERROR | ( 0x4024 ),
	"Ubrof format error !",
}, 
{
	"ER_LDR_SYM_SERVER",
	E_SEVERE | ( 0x4025 ),
	"Symbol Server Failure !",
}, 
{
	"ER_LDR_DOWNLOAD_FILE",
	E_ERROR | ( 0x4026 ),
	"Not MSC51 Series CPU download file!",
},
{
	"ER_LDR_UNKNOWN",
	E_ERROR | ( 0x4050 ),
	"Loader Unknown error!"
},
{
	"ER_LDR_NO_SYM",
	E_ERROR | ( 0x4052 ),
	"Symbol infomation have not be loaded!"
},
{
	"ER_LDR_DIFF_ONDEM_FILE",
	E_ERROR | ( 0x4053 ),
	"Load file is not same as OnDemand load file!"
},
{
	"ER_LDR_NO_MODULE",
	E_ERROR | ( 0x4054 ),
	"No such module!"
},
{
	"ER_LDR_OPENFILE_ERROR",
	E_ERROR | ( 0x4055 ),
	"Download file can not be opened!"
},
{
	"ER_LDR_UNKNOWN_FORMAT",
	E_ERROR | ( 0x4056 ),
	"Load file format has not been supported !"
},
{
	"ER_CODE_NOT_IN_CODESEG",
	E_ERROR | ( 0x4057 ),
	"Download code not in code segment!"
},
{
	"ER_SEG_UNKNOWN",
	( ER_SEG_BASE+ 0),
	"UNKNOWN"
},
{
	"ER_SEG_CODE",
	( ER_SEG_BASE+ 1),
	"CODE"
},
{
	"ER_SEG_XDATA",
	( ER_SEG_BASE+ 2),
	"XDATA"
},
{
	"ER_SEG_DATA",
	( ER_SEG_BASE+ 3),
	"DATA"
},
{
	"ER_SEG_SFR",
	( ER_SEG_BASE+ 4),
	"SFR"
},
{
	"ER_SEG_BIT",
	( ER_SEG_BASE+ 5),
	"BIT"
},
{
	"ER_ICE_OK",
	( ER_ICE_OK+0 ) ,
	" ICE ok!\\n\\r",
},
{
	"ER_ICE_FAIL_STEP",
	E_FATAL | ( ER_ICE_OK+1 ),
	" Target cannot step!\\n\\r",
},
{
	"ER_ICE_FAIL_MEM_WRITE",
	E_FATAL | ( ER_ICE_OK+2 ),
	" Memory write failure!\\n\\r",
},
{
	"ER_ICE_FAIL_MAP_INCLUDE",
	E_FATAL | ( ER_ICE_OK+3 ),
	" Map status not included!\\n\\r",
},
{
	"ER_ICE_FAIL_MAP_BOUNDARY",
	E_FATAL | ( ER_ICE_OK+4 ),
	" Map address boundary error!\\n\\r",
},
{
	"ER_ICE_NOT_FOUND",
	E_FATAL | ( ER_ICE_OK+5 ),
	" Can not find any more!\\n\\r",
},
{
	"ER_ICE_FOUND",
	E_FATAL | ( ER_ICE_OK+6 ),
	" Find!\\n\\r",
},
{
	"ER_ICE_TIME_OUT",
	E_FATAL | ( ER_ICE_OK+7 ),
	" Communication failure!\\n\\r",
},
{
	"ER_ICE_PARA_ERROR",
	E_FATAL | ( ER_ICE_OK+8 ),
	" Sended parameters Error!\\n\\r",
},
{
	"ER_ICE_EP_RUNNING",
	E_FATAL | ( ER_ICE_OK+0x10 ),
	" Emulator processor is running!\\n\\r",
},
{
	"ER_ICE_TRACE_RUNNING",
	E_FATAL | ( ER_ICE_OK+0x11 ),
	" Emulator processor is tracing!\\n\\r",
},
{
	"ER_ICE_TRACE_READ_OVER",
	E_FATAL | ( ER_ICE_OK+0x12 ),
	" Reading trace buffer is over!\\n\\r",
},
{
	"ER_ICE_COMMAND_INVALID",
	E_FATAL | ( ER_ICE_OK+0x13 ),
	" Invalid Command!\\n\\r",
},
{
	"ER_ICE_FLASH_SW_ERROR",
	E_FATAL | ( ER_ICE_OK+0x40 ),
	" Flush EPROM switching error!\\n\\r",
},
{
	"ER_ICE_FLASH_EC_ERROR",
	E_FATAL | ( ER_ICE_OK+0x41 ),
	" Flush EPROM erasing error!\\n\\r",
},
{
	"ER_ICE_FLASH_PRG_ERROR",
	E_FATAL | ( ER_ICE_OK+0x42 ),
	" Flush EPROM programming error!\\n\\r",
},
{
	"ER_ICE_FLASH_REC_ERROR",
	E_FATAL | ( ER_ICE_OK+0x43 ),
	" Flush EPROM recording error!\\n\\r"
},
{
	"ER_ABI_SET_REG",
	E_FATAL | ( ER_ICE_OK+0x50),
	"Set register value failure!"
},
{
	"ER_EMU_INSUFFICIENT_MEMORY",
	E_SEVERE | ( ER_EMU_BASE+0 ),
	"Insufficient Memory !"
},
{
	"ER_EMU_TARGET_CPU_HALT",
	E_ERROR | ( ER_EMU_BASE+1 ),
	"Target CPU halted."
},
{
	"ER_EMU_PROGRAM_IS_RUN",
	E_ERROR | ( ER_EMU_BASE+2 ),
	"Program is running."
},
{
	"ER_EMU_LOAD_FORMAT_ERROR",
	E_ERROR | ( ER_EMU_BASE+3 ),
	"Load format error."
},
{
	"ER_EMU_DAD_3",
	E_ERROR | ( ER_EMU_BASE+4 ),
	"opcodes haven't any meaning"
},
{
	"ER_EMU_DAD_6",
	E_ERROR | ( ER_EMU_BASE+6 ),
	"invalid cpu mode"
},
{
	"ER_EMU_DAD_7",
	E_ERROR | ( ER_EMU_BASE+7 ),
	" too many char"
},
{
	"ER_EMU_DAD_8",
	E_ERROR | ( ER_EMU_BASE+8 ),
	"invalid convert address from byte to bit"
},
{
	"ER_EMU_DAD_9",
	E_ERROR | ( ER_EMU_BASE+9 ),
	"offset of bit is too large"
},
{
	"ER_EMU_DAD_10",
	E_ERROR | ( ER_EMU_BASE+10 ),
	"unknown offset"
},
{
	"ER_EMU_DAD_11",
	E_ERROR | ( ER_EMU_BASE+11 ),
	". used in byte which can't be addressed in bit"
},
{
	"ER_EMU_DAD_12",
	E_ERROR | ( ER_EMU_BASE+12 ),
	"wrong use of /"
},
{
	"ER_EMU_DAD_13",
	E_ERROR | ( ER_EMU_BASE+13 ),
	"no corresponding in Cmd_51"
},
{
	"ER_EMU_DAD_14",
	E_ERROR | ( ER_EMU_BASE+14 ),
	"have no string"
},
{
	"ER_EMU_DAD_15",
	E_ERROR | ( ER_EMU_BASE+15 ),
	"rel address not in range -128 to 127"
},
{
	"ER_EMU_DAD_16",
	E_SEVERE | ( ER_EMU_BASE+16 ),
	"DAD table error,please call vendor!"
},
{
	"ER_EMU_DAD_17",
	E_ERROR | ( ER_EMU_BASE+17 ),
	"wrong address for acall"
},
{
	"ER_EMU_DAD_18",
	E_ERROR | ( ER_EMU_BASE+18 ),
	"too many opcodes"
},
{
	"ER_EMU_DAD_19",
	E_FATAL | ( ER_EMU_BASE+19 ),
	"ICE memory reading or writing error!"
},
{
	"ER_EMU_DAD_20",
	E_ERROR | ( ER_EMU_BASE+20 ),
	"having wrong address comparing to address type"
},
{
	"ER_EMU_DAD_99",
	E_ERROR | ( ER_EMU_BASE+21 ),
	"only one byte is needed!"
},
{
	"ER_EMU_DAD_DEFAULT",
	E_ERROR | ( ER_EMU_BASE+22 ),
	"can not get the correct figure! "
},
{
	"ER_EMU_DAD_SRC_2",
	E_ERROR | ( ER_EMU_BASE+23 ),
	"Error:too many instructions!"
},
{
	"ER_EMU_DAD_SRC_3",
	E_ERROR | ( ER_EMU_BASE+24 ),
	"Error:invalid cpu module!"
},
{
	"ER_EMU_DAD_SRC_6",
	E_ERROR | ( ER_EMU_BASE+25 ),
	"Error:input code length is zero!"
},
{
	"ER_EMU_DAD_SRC_7",
	E_ERROR | ( ER_EMU_BASE+26 ),
	"Error:wrong address !"
},
{
	"ER_EMU_DAD_SRC_105",
	E_FATAL | ( ER_EMU_BASE+27 ),
	"Error:memory reading error!"
},
{
	"ER_EMU_DAD_SRC_DEFAULT",
	E_ERROR | ( ER_EMU_BASE+28 ),
	"Error:DAD error!"
},
{
	"ER_GOFLY_ERR_MSG",
	E_ERROR | ( ER_EMU_BASE+29 ),
	"Please halt Cpu first!"	
},	
{
	"ER_PRE_SEL_REG",
	E_ERROR | ( ER_PRE_BASE+0 ),
	"Must select one register at least!"
},
{
	"ER_PRE_REG_VALUE",
	E_ERROR | ( ER_PRE_BASE+ 1),
	"Invalid register value"
},
{
	"ER_PRE_REG_NOT_EXIST",
	E_ERROR | ( ER_PRE_BASE+2 ),
	"This register does not exist."
},
{
	"ER_PRE_REG_VALUE_OVERFLOW",
	E_ERROR | ( ER_PRE_BASE+3 ),
	"Error! Register Value overflow."
},
{
	"ER_PRE_CPU_SETTING",
	E_ERROR | ( ER_PRE_BASE+4 ),
	"CPU Module setting error, now it is using the default one."
},
{
	"ER_PRE_INVALID_INPUT",
	E_ERROR | ( ER_PRE_BASE+5 ),
	"Your input is not valid!"
},
{
	"ER_PRE_VALUE_TOO_LARGE",
	E_ERROR | ( ER_PRE_BASE+6 ),
	"The value is too large!"
},
{
	"ER_PRE_CPU_NOT_SUPPORT",
	E_ERROR | ( ER_PRE_BASE+7 ),
	"Not Support this CPU! Please contact your provider."
},
{
	"ER_PRE_CPU_NO_INFO",
	E_ERROR | ( ER_PRE_BASE+8 ),
	"No Information for this CPU! Please contact your provider."
},
{
	"ER_PRE_NO_LIBRARY",
	E_ERROR | ( ER_PRE_BASE+9 ),
	"Can not do this test without custom control library!  Please install muscroll.dll"
},
{
	"ER_PRE_PROGRAM_SWITCH",
	E_FATAL | ( ER_PRE_BASE+10 ),
	"Program switched Error !"
},
{
	"ER_PRE_PROGRAM_ERASE",
	E_FATAL | ( ER_PRE_BASE+11 ),
	"Program Erase Error !"
},
{
	"ER_PRE_COMMUNICATION",
	E_FATAL | ( ER_PRE_BASE+12 ),
	"Communication Failue"
},
{
	"ER_PRE_NO_COMPATIBLE_FILE",
	E_ERROR | ( ER_PRE_BASE+13 ),
	"No Compatible file exists. Please install the file in current directory"
},
{
	"ER_PRE_DOWNLOAD",
	E_FATAL | ( ER_PRE_BASE+14 ),
	"DownLoad Error!"
},

{
	"ER_MEMDLG_LENGTH",
	E_ERROR | (ER_MEM_BASE +0 ),
	"Length may not include area define" 
},
{
	"ER_MEMDLG_INPUT",
	E_ERROR | (ER_MEM_BASE +1 ),
	"Input error"
},
{
	"ER_MEMDLG_COPYOVER",
	E_ERROR | (ER_MEM_BASE +2 ),
	"Copy range over flow"
},
{
	"ER_MAPDLG_OPENFILE",
	E_ERROR | (ER_MEM_BASE +3 ),
	"Open map file error"
},
{
	"ER_MAPDLG_ADROVER",
	E_ERROR | (ER_MEM_BASE +4 ),
	"Address over range"
},
{
	"ER_ADDR_FORMAT",
	E_ERROR | (ER_ADDR_BASE +0 ),
	"The address format is error!!"
},
{
	"ER_ADDR_INVALID",
	E_ERROR | (ER_ADDR_BASE +1 ),
	"The address include invalid char!!"
},
{
	"ER_ADDR_OUTRANGE",
	E_ERROR | (ER_ADDR_BASE +2 ),
	"The address is out of range!!"
},
{
	"ER_ADDR_SYMBOL",
	E_ERROR | (ER_ADDR_BASE +3 ),
	"The symbol is not exist!!"
},
{
	"ER_ADDR_COMPARE",
	E_ERROR | (ER_ADDR_BASE +4 ),
	"The addresses are compare error!!"
},
{
	"ER_ADDR_OVERFLOW",
	E_ERROR | (ER_ADDR_BASE +5 ),
	"The address is overflow!!"
},
{
	"ER_ADDR_EMPTY",
	E_ERROR | (ER_ADDR_BASE +6 ),
	"The address string is empty!!"
},
{
	"ER_ADDR_DEFAULT",
	E_ERROR | (ER_ADDR_BASE +7 ),
	"The address is error!!"
},

{
	"ER_TRCGRP_ADDR1_ERR",
	E_ERROR | ( ER_TRC_BASE+0 ),
	"Input Error: Start Addr"
}, 
{
	"ER_TRCGRP_ADDR2_ERR",
	E_ERROR | ( ER_TRC_BASE+1 ),
	"Input Error: End Addr"
}, 
{
	"ER_TRCGRP_ADDR_ORDER",
	E_ERROR | ( ER_TRC_BASE+2 ),
	"End Addr must great than Start Addr"
}, 
{
	"ER_TRCGRP_ADDR1_OUTRANGE",
	E_ERROR | ( ER_TRC_BASE+3 ),
	"Start Addr Out of Program Ram Range"
}, 
{
	"ER_TRCGRP_ADDR2_OUTRANGE",
	E_ERROR | ( ER_TRC_BASE+4 ),
	"End Addr Out of Program Ram Range"
}, 
{
	"ER_TRCGRP_ADDR_TOOMUCH",
	E_ERROR | ( ER_TRC_BASE+5 ),
	"Addr Number not in range 1 to 10"
}, 
{
	"ER_TRCGRPF_ADDR_ERR",
	E_ERROR | ( ER_TRC_BASE+6 ),
	"Input Error: Addr%d"
}, 
{
	"ER_TRCGRPF_ADDR_OUTRANGE",
	E_ERROR | ( ER_TRC_BASE+7 ),
	"Addr%d Out of Program Ram Range"
}, 
{
	"ER_TRCGRP_DATA1_NOWILD",
	E_ERROR | ( ER_TRC_BASE+8 ),
	"You should use Multiple mode"
}, 
{
	"ER_TRCGRP_DATA1_ERR",
	E_ERROR | ( ER_TRC_BASE+9 ),
	"Input Error: Start Data"
}, 
{
	"ER_TRCGRP_DATA2_ERR",
	E_ERROR | ( ER_TRC_BASE+10 ),
	"Input Error: End Data"
}, 
{
	"ER_TRCGRP_DATA1_OUTRANGE",
	E_ERROR | ( ER_TRC_BASE+11 ),
	"Start Data not in range 0 to 0xFF"
}, 
{
	"ER_TRCGRP_DATA2_OUTRANGE",
	E_ERROR | ( ER_TRC_BASE+12 ),
	"End Data not in range 0 to 0xFF"
}, 
{
	"ER_TRCGRP_DATA_ORDER",
	E_ERROR | ( ER_TRC_BASE+13 ),
	"End Data must great than Start Data"
}, 
{
	"ER_TRCGRP_COUNT_ERR",
	E_ERROR | ( ER_TRC_BASE+14 ),
	"Input Error: Count"
}, 
{
	"ER_TRCGRP_NONEINPUT",
	E_ERROR | ( ER_TRC_BASE+15 ),
	"Error: You Must Input Something!"
},
{
	"ER_SPA_BASE",
	E_ERROR | ( ER_SPA_BASE + 0),
	"OK"
}, 
{
	"ER_SPA_DEBUG",
	E_ERROR | ( ER_SPA_BASE + 1),
	"Debug"
}, 
{
	"ER_SPA_EMPTY",
	E_ERROR | ( ER_SPA_BASE + 2),
	"Input empty"
}, 
{
	"ER_SPA_NO_DELIMIT",
	E_ERROR | ( ER_SPA_BASE + 3),
	"Input no delimit"
}, 
{
	"ER_SPA_INPUT",
	E_ERROR | ( ER_SPA_BASE + 4),
	"Input error"
}, 
{
	"ER_SPA_EXIST",
	E_ERROR | ( ER_SPA_BASE + 5),
	"Range already exist"
}, 
{
	"ER_SPA_FILE",
	E_ERROR | ( ER_SPA_BASE + 6),
	"File open error"
}, 
{
	"ER_SPA_MEMORY",
	E_ERROR | ( ER_SPA_BASE + 7),
	"Insufficient memory"
}, 
{
	"ER_SPA_RANGE",
	E_ERROR | ( ER_SPA_BASE + 8),
	"Exceed the range"
}, 
{
	"ER_SPA_TIMER",
	E_ERROR | ( ER_SPA_BASE + 9),
	"Timer set failure"
}, 
{
	"ER_SPA_ABI",
	E_ERROR | ( ER_SPA_BASE + 10),
	"Communication failure"
}, 
{
	"ER_SPA_NO_COVERAGE",
	E_ERROR | ( ER_SPA_BASE + 11),
	"No coverage information"
},
 
{
	"ER_TST_BASE",
	E_ERROR | ( ER_TST_BASE + 0  ),
	"No Error"
},
{
	"ER_TST_LOG_EXIST",
	E_ERROR | ( ER_TST_BASE +  1 ),
	"Log file existed already."
},
{
	"ER_TST_LOG_UNOPEN",
	E_ERROR | ( ER_TST_BASE +  2 ),
	"No Log file opened."
},
{
	"ER_TST_OPEN_ERROR",
	E_ERROR | ( ER_TST_BASE +  3 ),
	"File open error."
},
{
	"ER_TST_CLOSE_ERROR",
	E_ERROR | ( ER_TST_BASE +  4 ),
	"File close error."
},
{
	"ER_TST_READ_ERROR",
	E_ERROR | ( ER_TST_BASE +  5 ),
	"File read error."
},
{
	"ER_TST_WRITE_ERROR",
	E_ERROR | ( ER_TST_BASE +  6 ),
	"File write error."
},
{
	"ER_TST_FILE_END",
	E_ERROR | ( ER_TST_BASE +  7 ),
	"End of Include file."
},
{
	"ER_TST_LONG_LINE",
	E_ERROR | ( ER_TST_BASE +  8 ),
	"More than 255 characters in one line."
},
{
	"ER_TST_NOT_INNER",
	E_ERROR | ( ER_TST_BASE +  9 ),
	"Not an Include inner command."
},
{
	"ER_TST_INNER_ERROR",
	E_ERROR | ( ER_TST_BASE +  10 ),
	"Include sub-command error."
},
{
	"ER_TST_INNER_SYNTAX",
	E_ERROR | ( ER_TST_BASE +  11 ),
	"Include sub-command error: Syntax error."
},
{
	"ER_TST_INNER_COUNT",
	E_ERROR | ( ER_TST_BASE +  12 ),
	"Include sub-command error: Invalid COUNT."
},
{
	"ER_TST_INNER_LABEL",
	E_ERROR | ( ER_TST_BASE +  13 ),
	"Include sub-command error: Invalid LABEL."
},
{
	"ER_TST_INNER_GOTO",
	E_ERROR | ( ER_TST_BASE +  14 ),
	"Include sub-command error: LABEL cannot matched."
},
{
	"ER_TST_INNER_LOOP",
	E_ERROR | ( ER_TST_BASE +  15 ),
	"Include sub-command error: More than 256 LOOP nested."
},
{
	"ER_TST_INNER_LOOPEND",
	E_ERROR | ( ER_TST_BASE +  16 ),
	"Include sub-command error: Invalid LOOPEND."
},
{
	"ER_TST_INNER_IF",
	E_ERROR | ( ER_TST_BASE +  17 ),
	"Include sub-command error: IF,IF_NOT & ELSE statement cannot nest."
},
{
	"ER_TST_INNER_ELSE",
	E_ERROR | ( ER_TST_BASE +  18 ),
	"Include sub-command error: ELSE without IF or IF_NOT statement."
},
{
	"ER_TST_INNER_BEGIN",
	E_ERROR | ( ER_TST_BASE +  19 ),
	"Include sub-command error: No expected {."
},
{
	"ER_TST_INNER_END",
	E_ERROR | ( ER_TST_BASE +  20 ),
	"Include sub-command error: No expected }."
},
{
	"ER_TST_INNER_MATCH",
	E_ERROR | ( ER_TST_BASE +  21 ),
	"Include sub-command error: { and } unmatched."
},
{
	"ER_TST_INNER_ESC",
	E_ERROR | ( ER_TST_BASE +  22 ),
	"Abort by user."
},
{
	"ER_TST_DELETE_MACRO_ERROR",
	E_ERROR | ( ER_TST_BASE +  23 ),
	"The macro is not exist."
},
{
	"ER_TST_MACRO_FILE_END",
	E_ERROR | ( ER_TST_BASE +  24 ),
	"End of Macro file."
},
{
	"ER_TST_NOT_MACRO_INNER",
	E_ERROR | ( ER_TST_BASE +  25 ),
	"Not a Macro inner command."
},
{
	"ER_TST_INNER_MACRO_ERROR",
	E_ERROR | ( ER_TST_BASE +  26 ),
	"Macro sub-command error."
},
{
	"ER_TST_INNER_MACRO_SYNTAX",
	E_ERROR | ( ER_TST_BASE +  27 ),
	"Macro sub-command error: Syntax error."
},
{
	"ER_TST_INNER_MACRO_IF",
	E_ERROR | ( ER_TST_BASE +  28 ),
	"Macro sub-command error: IF,IF_NOT & ELSE statement cannot nest."
},
{
	"ER_TST_INNER_MACRO_ELSE",
	E_ERROR | ( ER_TST_BASE +  29 ),
	"Macro sub-command error: ELSE without IF or IF_NOT statement."
},
{
	"ER_TST_INNER_MACRO_BEGIN",
	E_ERROR | ( ER_TST_BASE +  30 ),
	"Macro sub-command error: No expected {."
},
{
	"ER_TST_INNER_MACRO_END",
	E_ERROR | ( ER_TST_BASE +  31 ),
	"Macro sub-command error: No expected }."
},
{
	"ER_TST_INNER_MACRO_MATCH",
	E_ERROR | ( ER_TST_BASE +  32 ),
	"Macro sub-command error: { and } unmatched.",
},
{
	"ER_TST_INNER_MACRO_ESC",
	E_ERROR | ( ER_TST_BASE +  33 ),
	"Abort by user."
},
{
	"ER_TST_INNER_MACRO_COUNT",
	E_ERROR | ( ER_TST_BASE +  34 ),
	"Macro sub-command error: Invalid COUNT."
},
{
	"ER_TST_INNER_MACRO_LABEL",
	E_ERROR | ( ER_TST_BASE +  35 ),
	"Macro sub-command error: Invalid LABEL."
},
{
	"ER_TST_INNER_MACRO_GOTO",
	E_ERROR | ( ER_TST_BASE +  36 ),
	"Macro sub-command error: LABEL cannot matched."
},
{
	"ER_TST_INNER_MACRO_LOOP",
	E_ERROR | ( ER_TST_BASE +  37 ),
	"Macro sub-command error: More than 256 LOOP nested."
},
{
	"ER_TST_INNER_MACRO_LOOPEND",
	E_ERROR | ( ER_TST_BASE +  38 ),
	"Macro sub-command error: Invalid LOOPEND."
},
{
	"ER_SYN_BASE",
	E_ERROR | ( ER_SYN_BASE + 0 ),
	"No Error"
},
{
	"ER_SYN_NO_SUCH_COMMAND",
	E_ERROR | ( ER_SYN_BASE + 1 ),
	"No such command."
},
{
	"ER_SYN_SYNTAX_ERROR",
	E_ERROR | ( ER_SYN_BASE + 2 ),
	"Syntax error."
},
{
	"ER_SYN_COMMAND_NOT_FIND",
	E_ERROR | ( ER_SYN_BASE + 3 ),
	"old command not find"
},
{
	"ER_SYN_NOT_HAVE_ALIAS",
	E_ERROR | ( ER_SYN_BASE + 4 ),
	"@ or $ command cannot have alias"
},
{
	"ER_SYN_ALIAS_LEN_20",
	E_ERROR | ( ER_SYN_BASE + 5 ),
	"alias name must less than 20 characters"
},
{
	"ER_SYN_ALIAS_DIFFERENT",
	E_ERROR | ( ER_SYN_BASE + 6 ),
	"alias name must be different basic command name"
},
{
	"ER_SYN_ALIAS_EXIST",
	E_ERROR | ( ER_SYN_BASE + 7 ),
	"alias name is already exist"
},
/* - STOP - DO NOT ADD ANY ERROR CODE TO THIS FILE
**
** If you remove any error code form this file please put the error number
** in the list below so that the next person can reuse it.
**
** REUSABLE ERRORCODE:
**
**
*/

/***************************** EOF *****************************************/
