/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/FMTHEX.CPP   1.8   20 Jun 1996 09:24:46   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/FMTHEX.CPP  $
** 
**    Rev 1.8   20 Jun 1996 09:24:46   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.6   10 Jun 1996 10:19:24   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.4   29 May 1996 09:28:26   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:08:50   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:08:18   ZJRD
** EasyPack/SLD Version 1.93
** 
**    Rev 1.1   02 May 1996 10:25:58   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.1   18 Apr 1996 12:56:18   Shirley
** No change.
** 
**    Rev 1.0   12 Apr 1996 10:35:50   Shirley
** Initial revision.
** 
****************************************************************************/

/****************************************************************************
**
**  Name:      FmtHex.cpp
**
**  Description:  This file describe the hexadecimal string class. Deprivde
**                from the class CFormatString.
**                This class process the hex string, convert it to data(number)
**
**  Status: Initialization
**          1996/03/04        Daniel Lin
**
**  Copyright (C) 1996 Microtek International.  All rights reserved.
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include "stdafx.h"                                                
#include "address.h"                // Include main head file

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *       GLOBAL VARS        *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/

/**------------------------------------------------------------------------**
 ** Name: CFormatHexStr                                                    **
 **       Constructor of the CFormatHexStr                                 **
 **                                                                        **
 ** parameter :                                                            **
 **       CString&                                                         **
 **                                                                        **
 ** return value :                                                         **
 **       none                                                             **
 **------------------------------------------------------------------------**/

CFormatHexStr :: CFormatHexStr(CString& str)
{
   m_strOriginHexStr = str;
}

/**------------------------------------------------------------------------**
 ** Name:  CFormatHexStr                                                   **
 **        Constructor                                                     **
 **                                                                        **
 ** parameter :                                                            **
 **        char* lpsz                                                      **
 **                                                                        **
 ** return value :                                                         **
 **        none                                                            **
 **------------------------------------------------------------------------**/

CFormatHexStr :: CFormatHexStr(char* lpsz)
{
   m_strOriginHexStr = lpsz;
}

/**------------------------------------------------------------------------**
 ** Name:  Convert                                                         **
 **        COnvert the string                                              **
 **                                                                        **
 ** parameter :  none                                                      **
 **                                                                        **
 ** return value :   none                                                  **
 **------------------------------------------------------------------------**/

void
CFormatHexStr :: Convert()      // Process the convert
{
   char *psz1 = new char[m_strOriginHexStr.GetLength()+2];
   char *psz2 = new char[m_strOriginHexStr.GetLength()+2];
   
   ASSERT(NULL != psz1);
   ASSERT(NULL != psz2);
   memset(psz1, 0, m_strOriginHexStr.GetLength()+2);
   memset(psz2, 0, m_strOriginHexStr.GetLength()+2);
   strcpy(psz1, m_strOriginHexStr.GetBuffer(m_strOriginHexStr.GetLength()));
   strcpy(psz2, psz1+2);   //Skip head leading '0x'
   m_bIsOk = Hex2Num(psz2, m_dwData);
   delete []psz1;
   delete []psz2;
   
   return;
}

