/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/FMTSYM.H__   1.8   20 Jun 1996 09:28:48   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/FMTSYM.H__  $
** 
**    Rev 1.8   20 Jun 1996 09:28:48   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.6   10 Jun 1996 10:23:26   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.4   29 May 1996 09:34:44   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:00:10   ZJRD
** EasyPack/SLD Version 1.94
** 
**    Rev 1.2   10 May 1996 09:16:42   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:31:04   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.1   18 Apr 1996 12:56:18   Shirley
** No change.
** 
**    Rev 1.0   12 Apr 1996 10:35:50   Shirley
** Initial revision.
** 
****************************************************************************/

/****************************************************************************
**
**  Name:   Fmtsym.h
**
**  Description:  Describe the class of CFormatSymbol. The sub class deprived
**                from the class CFormatString. This class process the symbol
**                The symbol format is:
**                   #ModuleName:#SymbolName
**
**  Status:       Initialization
**                1996/02/16                    Daniel Lin
**
**  Copyright (C) 1996 Microtek International.  All rights reserved.
**
*****************************************************************************/

#ifndef __FMTSYM__H
#define __FMTSYM__H

class CFormatSymbol : public CFormatString
{
   private:
      CString  m_strOriginSymbol;   // Oringinal symbol string as the format
                                    // #ModuleName:#SymbolName
      CString  m_strModule;         // The module name
      CString  m_strSymbol;         // The symbol name
      DWORD    m_dwData;            // Converted address data
      unsigned char m_uchType;      // Segment space type
      
   public:
      UINT     m_uSymData;          // 0 -- Symbol
                                    // 1 -- Symbol Data   
      
      // Constructor
      CFormatSymbol(const CString& str);
      CFormatSymbol(const char* lpsz);

      //Implementation
      virtual  void Convert();      // Process the convert   
      
      CString  GetModuleName()      // Return the module name
      {
         return m_strModule;
      };
      
      CString  GetSymbolName()      // Return the symbol name
      {
         return m_strSymbol;
      };
      
      DWORD    GetAddress()            // Return the symbol data
      {
         return m_dwData;
      };
      
      unsigned char GetSpace()      // Return the space type
      {
         return m_uchType;
      };
};

#endif

//////////////////////////////////(EOF)///////////////////////////////////////
