/***************************************************************************
**               
**    $Header:   D:/EPSLDV1/SRC/LOG/FWSETUP/ABIREG51.CPP   1.3   20 Jun 1996 09:34:52   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/FWSETUP/ABIREG51.CPP  $
** 
**    Rev 1.3   20 Jun 1996 09:34:52   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.1   10 Jun 1996 10:29:46   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.30   12 Apr 1996 10:41:16   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:56:16   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:07:32   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:34:00   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:47:54   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:19:10   Shirley
** EasyPack/SLD Version 0.35b
** 
**    Rev 1.23   26 Jan 1996 09:14:22   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:14:16   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:33:08   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:26:54   Shirley
** EasypPack/SLD Version 0.34c
** 
**    Rev 1.19   18 Jan 1996 10:11:42   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:13:16   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:11:20   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:08:48   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:31:36   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:18:16   Shirley
** EasyPack/SLD Version 0.31
** 
**    Rev 1.13   13 Nov 1995 09:28:28   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:30:16   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:33:32   Shirley
** EasyPack/SLD Version 0.23
** 
**    Rev 1.10   08 Nov 1995 12:43:14   Shirley
** EasyPack/SLD Version 0.22
** 
**    Rev 1.9   02 Nov 1995 10:05:16   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:51:10   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:44:54   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:31:18   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:47:12   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:23:36   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:50:04   Shirley
** EasyPack/SLD Version 0.1c
** 
**    Rev 1.2   20 Sep 1995 10:52:22   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:43:28   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:53:16   Shirley
** Initial revision.
**
****************************************************************************/

/***************************************************************************
**
** File name : abireg51.cpp
**
** Description: 
** 
** 
**
** Programmer: Frank Chang
**
**    Copyright (C) 1995 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/
#include "stdafx.h"

#include <stdio.h>

#include "abireg51.h" 
#include "abitype.h"
#include "abimacro.h"
#include <time.h>

static UINT gRegLen = 0x7f;

/////////////////////////////////////////////////////////////////
// ABI rountine part
//
STATUS AbiGetAllReg(UINT* uRegValue);
STATUS AbiGetOneReg(int iRegId, UINT* uRegValue);
STATUS AbiSetReg(int iRegId, UINT uRegValue);
STATUS AbiGetRegLen(UINT *wRegLen);
STATUS AbiGetFWSupport(UINT *wCpuNum, UINT* wCpuType);
STATUS AbiGetTargetSupport(UINT *wCpuNum, UINT* wCpuType);


STATUS AbiOutput(PARA_PORT port, UINT uPortValue, UINT uMaskFlag);
STATUS AbiInput(PARA_PORT port, UINT *uPortValue);
STATUS AbiSetPort(PARA_PORT port);

//unreviewed
STATUS AbiGetControl(int iControlId, FLAG* uControlFlag);
STATUS AbiSetControl(int iControlId, FLAG uControlFlag);
STATUS AbiDiagnostic(unsigned char uchOption);

STATUS AbiGetCpuId(UINT *nCpuId);
STATUS AbiSetCpuId(UINT nSetCpuId, UINT *nGetCpuId);
STATUS AbiGetFwId(UCHAR *uchMajor,  UCHAR *uchMinor);

STATUS AbiGetCpuStatus(UINT *uCpuStatus);
STATUS AbiGetCpuStatusNoRelink(UINT *uCpuStatus);
STATUS AbiGetFreq(UCHAR *pszBuffer);
STATUS AbiGetTimerCount(TIMER_COUNT *pTimerCount);

/////////////////////////////////////////////////////////////////
// call ABI sub rountine 
//
extern STATUS SendReceive(UINT lp, int tcount);
//extern STATUS SendReceiveNoRelink(UINT lp, int tcount);

/****************************************************
**
** Name : AbiGetRegLen()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
****************************************************/
STATUS AbiGetRegLen(UINT *wRegLen)
{  
    STATUS status;
    UINT lp = 0;

    SaveId(FW_GET_REG_LEN,lp);
    status = SendReceive(lp, BASE_TIME);
    
    if (status == ICE_OK) {
        *wRegLen =*((UINT*) &inputStream[1]);
        gRegLen = *((UINT * )&inputStream[1]);
    }
    else
        *wRegLen = 0x7f;
        
    return(status);
}

/****************************************************
**
** Name : AbiGetFWSupport()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
****************************************************/
STATUS AbiGetFWSupport(UINT *wCpuNum, UINT* wCpuType)
{  
    STATUS status;
    UINT lp = 0;
    UINT uint;
    UCHAR *uchPtr;
    UCHAR *uchCpuNum = (UCHAR *) wCpuType;

    SaveId(FW_GET_FW_SUPPORT, lp);
    status = SendReceive(lp, BASE_TIME);
    
    if (status == ICE_OK) {
        *wCpuNum = *((UINT*) &inputStream[1]);

        uchPtr = &inputStream[3];
        for (uint = 0; uint < (*wCpuNum) * 2; uint++) {
           * uchCpuNum ++ = *uchPtr++;
        }
    }

    return(status);
}

/****************************************************
**
** Name : AbiGetTargetSupport()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
****************************************************/
STATUS AbiGetTargetSupport(UINT *wCpuNum, UINT* wCpuType)
{  
    STATUS status;
    UINT lp = 0;
    UINT uint;
    UCHAR *uchPtr;
    UCHAR *uchCpuNum = (UCHAR *) wCpuType;

    SaveId(FW_GET_TARGET_SUPPORT, lp);
    status = SendReceive(lp, BASE_TIME);
    
    if (status == ICE_OK) {
        *wCpuNum = *((UINT*) &inputStream[1]);

        uchPtr = &inputStream[3];
        for (uint = 0; uint < (*wCpuNum) * 2; uint++) {
           * uchCpuNum ++ = *uchPtr++;
        }
    }

    return(status);
}


/*****************************************************
**
** Name : AbiGetAllReg()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiGetAllReg(UINT* cpuValue)
{
    STATUS status;
    UINT lp;
    UCHAR *ptr;
    
    SaveId(FW_GET_ALL_REG,lp);
    status = SendReceive(lp, BASE_TIME);
    
    if(status == ICE_OK) {
        ptr = &inputStream[1];
        cpuValue[REG_PC]     = *((UINT*)ptr);
        ptr++;
        ptr++;
        cpuValue[REG_DPTR]   = *((UINT*)ptr);
        ptr++;
        ptr++;
        for (lp=REG_ACC; lp< gRegLen; lp++) {
            cpuValue[lp] = (UCHAR)*(ptr++);
        } 
    } 
   
    return(status);
}

/*****************************************************
**
** Name : AbiGetOneReg()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiGetOneReg(int iRegId, UINT* cpuValue)
{
    STATUS status;
    UINT lp;
    UCHAR *ptr;
    
    lp = 0;
    SaveId(FW_GET_ONE_REG,lp);
    SaveVar(iRegId,lp,sizeof(UCHAR)); 
    status = SendReceive(lp, BASE_TIME);
    
    if(status == ICE_OK) {
        ptr = &inputStream[1]; 
        *cpuValue= *((UINT*)ptr);
    } 
   
    return(status);
}

/****************************************************
**
** Name : AbiSetReg()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
****************************************************/
STATUS AbiSetReg(int iRegId, UINT uRegValue)
{
    STATUS status;
    UINT lp;

    lp = 0;
    SaveId(FW_SET_ONE_REG,lp); 
    SaveVar(iRegId, lp, sizeof(int));
    SaveVar(uRegValue,lp,sizeof(UINT));
    status = SendReceive(lp, BASE_TIME);
    
    return(status);
}

/****************************************************
**
** Name : AbiOutput()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
****************************************************/
STATUS AbiOutput(PARA_PORT port, UINT uPortValue, UINT uMaskFlag)
{
    STATUS status;
    UINT lp;

    lp = 0;
    SaveId(FW_OUTPUT,lp);                
    SaveVar(port, lp, sizeof(port));
    SaveVar(uPortValue, lp, sizeof(UINT));
    SaveVar(uMaskFlag, lp, sizeof(UINT));
    
    status = SendReceive(lp, BASE_TIME);
    
    return(status);
}

/****************************************************
**
** Name : AbiInput()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
****************************************************/
STATUS AbiInput(PARA_PORT port, UINT *uPortValue)
{
    STATUS status;
    UINT lp;

    lp = 0;
    SaveId(FW_INPUT,lp); 
    SaveVar(port, lp, sizeof(port));

    status = SendReceive(lp, BASE_TIME);
    if (status == ICE_OK) {
        memcpy(uPortValue, &inputStream[1], sizeof(UINT));
    }
    return(status);
}




/****************************************************
**
** Name : AbiSetPort()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
****************************************************/
STATUS AbiSetPort(PARA_PORT port)
{
    STATUS status;
    UINT lp;

    lp = 0;
    SaveId(FW_SET_PORT,lp); 
    SaveVar(port, lp, sizeof(PARA_PORT));

    status = SendReceive(lp, BASE_TIME);
    return(status);
}

/****************************************************
**
** Name : AbiGetControl()
**
** Function
**
**    Input  :
**
**    Output :  uControlId
**                  0: EA
**                  1: RESET
**              uControlFlag:
**                  0:Disable
**                  1:Enable
**
** Notes:
**
****************************************************/
STATUS AbiGetControl(int iControlId, FLAG* uControlFlag)
{
    STATUS status;
    UINT lp;

    lp = 0;
    SaveId(FW_GET_CONTROL, lp);
    SaveVar(iControlId, lp, sizeof(char));

    status = SendReceive(lp, BASE_TIME);
    if (status == ICE_OK) {
        *uControlFlag = inputStream[1];
    }

    return(status);
}

/****************************************************
**
** Name : AbiSetControl()
**
** Function
**
**    Input  :
**           iControlId: 0:EA,
**                       1:RESET,
**           uControlFlag:
**                       0:Disable
**                       1:Enable
**    Output : 
**               
**
** Notes:
**
****************************************************/
STATUS AbiSetControl(int iControlId, FLAG uControlFlag)
{
    STATUS status;
    UINT lp;

    lp = 0;
    SaveId(FW_SET_CONTROL, lp);
    SaveVar(iControlId, lp, sizeof(char));
    SaveVar(uControlFlag, lp, sizeof(uControlFlag));


    status = SendReceive(lp, BASE_TIME);
    return(status);
}

/****************************************************
**
** Name : AbiDiagnostic()
**
** Function
**
**    Input  : diagnostic option 0--7
**
**    Output : result 0 ok; !0 not ok
**
** Notes:
**
****************************************************/
STATUS AbiDiagnostic(unsigned char uchOption)
{
    STATUS status;
    UINT lp;

    lp = 0;
    SaveId(FW_DIAGNOSTIC, lp);            
    SaveVar(uchOption , lp, sizeof(unsigned char));

    status = SendReceive(lp, /*BASE_TIME*/0x100);
    return(status);
}

/****************************************************
**
** Name : AbiGetCpuId()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
****************************************************/
STATUS AbiGetCpuId(UINT *nCpuId)
{
    STATUS status;
    UINT lp;
    UCHAR *uchPtr;
    
    lp = 0;
    SaveId(FW_GET_CPU_ID, lp);
    status = SendReceive(lp, BASE_TIME);

    uchPtr = &inputStream[1];
    *nCpuId = *((UINT*)uchPtr);

    return(status);
}

/****************************************************
**
** Name : AbiSetCpuId()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
****************************************************/
STATUS AbiSetCpuId(UINT nSetCpuId, UINT *nGetCpuId)
{
    STATUS status;
    UINT lp;
    UCHAR *uchPtr;

    lp = 0;
    SaveId(FW_SET_CPU_ID, lp);
    SaveVar(nSetCpuId, lp, sizeof(UINT));

    status = SendReceive(lp, BASE_TIME);

    uchPtr = &inputStream[1];
    *nGetCpuId = *((UINT*)uchPtr);

    return(status);
}

/****************************************************
**
** Name : AbiGetFwId()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
****************************************************/
STATUS AbiGetFwId(UCHAR *uchMajor,  UCHAR *uchMinor)
{
    STATUS status;
    UINT lp;
    

    lp = 0;
    SaveId(FW_GET_FW_ID, lp);
    status = SendReceive(lp, BASE_TIME);

    *uchMajor = (UCHAR) inputStream[1];
    *uchMinor = (UCHAR) inputStream[2];

    return(status);
}

/****************************************************
**
** Name : AbiGetCpuStatus()
**
** Function : to get the current CPU status, Trace status,
**            Timer status
**
**    Input  :
**
**    Output :
**            bit 2     0: trace off
**                      1: trace on
**                3     0: trigger off
**                      1: trigger on
**              4~6     0: Stopped(break)
**                      1: Stopped(user)
**                      2: Stopped(write)
**                      3: Stopped(Guard)
**                      4: EP running
**                      5: EP wait
**                      6: EP halt
**                7     0: verify off
**                      1: verify on
**                8     0: timer off
**                      1: timer on 
**
** Notes:
**
****************************************************/
STATUS AbiGetCpuStatus(UINT *uCpuStatus)
{
    STATUS status;
    UINT lp;
    lp = 0;
    SaveId(FW_GET_CPU_STATUS, lp);
    status = SendReceive(lp, BASE_TIME);
    
    *uCpuStatus = *((UINT*) &inputStream[1]);  
    return status;
}


/****************************************************
**
** Name : AbiGetCpuStatusNoRelink()
**
** Function : to get the current CPU status, Trace status,
**            Timer status
**
**    Input  :
**
**    Output :
**            bit 2     0: trace off
**                      1: trace on
**                3     0: trigger off
**                      1: trigger on
**              4~6     0: Stopped(break)
**                      1: Stopped(user)
**                      2: Stopped(write)
**                      3: Stopped(Guard)
**                      4: EP running
**                      5: EP wait
**                      6: EP halt
**                7     0: verify off
**                      1: verify on
**                8     0: timer off
**                      1: timer on 
**
** Notes:
**
****************************************************/
STATUS AbiGetCpuStatusNoRelink(UINT *uCpuStatus)
{
    STATUS status;
    UINT lp;
    lp = 0;
    SaveId(FW_GET_CPU_STATUS, lp);
//    status = SendReceiveNoRelink(lp, BASE_TIME);
    
//    if( status == ICE_NO_RESPONSE ) return ICE_NO_RESPONSE;
    
    *uCpuStatus = *((UINT*) &inputStream[1]);  
    return status;
}


/****************************************************
**
** Name : AbiGetFreq()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
****************************************************/
STATUS AbiGetFreq(UCHAR *pszBuffer)
{
    STATUS status;
    UINT lp;

    lp = 0;
    SaveId(FW_GET_FREQ, lp);
    status = SendReceive(lp, BASE_TIME);

    if (status  == ICE_OK) {
        for (int i=0; i<10; i++)
            *pszBuffer++ = (UCHAR) inputStream[1+i];
    }

    return(status);
}

/****************************************************
**
** Name : AbiGetTimerCount()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
****************************************************/
STATUS AbiGetTimerCount(TIMER_COUNT *pTimerCount)
{
    STATUS status;
    UINT lp = 0;

    SaveId(FW_GET_TIMER_COUNT, lp);
    status = SendReceive(lp, BASE_TIME);

    if ( ICE_OK == status ) {
       // ASSERT ( 0 == inputStream[1] || 1 == inputStream[1] )
        if ( 0 == inputStream[1] ) {
            pTimerCount->ulLowCount = 0;
            pTimerCount->uchHighCount = 0;
        }
        else {
            pTimerCount->ulLowCount = * (ULONG * ) &inputStream[2];
            pTimerCount->uchHighCount =  (UCHAR ) inputStream[6];
        }
    }
    return status;
}

STATUS AbiIsECB2(BYTE *bResult)
{
    STATUS status;
    UINT lp = 0;

    SaveId(FW_IS_ECB2, lp);
    status = SendReceive(lp, BASE_TIME);

    if ( ICE_OK == status ) {      
    	*bResult = inputStream[1];
    }
    return status;
}