                
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/FWSETUP/ABISUB51.CPP   1.3   20 Jun 1996 09:34:52   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/FWSETUP/ABISUB51.CPP  $
** 
**    Rev 1.3   20 Jun 1996 09:34:52   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.1   10 Jun 1996 10:29:46   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.28   15 Feb 1996 08:48:08   Shirley
** 
** Initial revision.
**
****************************************************************************/

/***************************************************************************
**
** File name : ABISUB51.CPP
**
** Changing :
**
** Programmer: Frank Chang
**
**    Copyright (C) 1995 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

/***************************************************************************
**
**    Include files
**
***************************************************************************/
#include "stdafx.h"

#include <dos.h>
#include <conio.h>
#include <time.h>
#include <string.h>

#include "abibase.h"
#include <stdio.h>

////////////////////////////////////////////////////////////////////////
//
//extern void ExitEpsld();
extern STATUS AbiGetRegLen(UINT *);

//extern int OpenAbiComDlg(int); //Frank, 12/27/95

typedef enum {
    LEAD_CODE   = ':',
    HEAD_OK     = 0x55,
    HEAD_FAIL   = 0xaa,
    REC_OK      = 0x5a,
    REC_FAIL    = 0xa5
} ECHO_CODE;

//////////////////////////////////////////////////////////////////////
// IO_lOOP adjust the communication speed between PC and MICE
// EasyPack new Firmware cannot fluently communicate with each other
// while IO_lOOP = 4000, now enlarge to 0xFFFF
// Frank, 06/27/95
//
// IO_LOOP become non-important, please see "time()" function, 11/06/95, Frank
const int ESC = 27;

const UINT  IO_LOOP = 0xFFFF;
const WORD  wHeadLoop = 0x0a;

//#ifdef _TEST_BOX
    unsigned char inputStream[2048];
    unsigned char outputStream[512];
//#else
//    unsigned char *inputStream;
//    unsigned char *outputStream;
//#endif

static BOOL isInSetup = TRUE;    
/**************************************************************************
**
** Local define
**
***************************************************************************/

#define     inportb(a)           inp(a)
#define     outportb(a,b)        outp(a,b)
#define     HighByte(x)          ((UCHAR)((UINT)(x) >> 8))
#define     LowByte(x)           ((UCHAR)(x))

//extern int TestKey(WORD);
/**************************************************************************
**
** function prototype declaration
**
***************************************************************************/
BOOL SetCommType(int nTempCommType);
BOOL SetupCommunication(UINT pData);
 
STATUS SendReceive(UINT wLoop, int tcount);
STATUS SendStream(UCHAR* stream, UINT len) ;
STATUS ReceiveStream(UCHAR* inStream, UINT *inStreamLen, time_t waitSec);

int sendB(UCHAR txData);
int receiveB(UCHAR *rcvByte);
int sendWait(UCHAR txData);
int receiveWait(time_t waitSec, UCHAR *rcvByte);
BOOL IsEscape();

//int ChkRxReady(void);
//int GetRxData(void);
//int ChkTxReady(void);
//int SendTxData(UCHAR tx_data);



/**************************************************************************
**
** Local variables
**
***************************************************************************/

const int   RV_RDY  = 1;  // status of receive ready is 00000001
const int   SD_RDY  = 2;  // status of send ready is    00000010


enum STATUS_PORT {
   P_I_B0   =      0x08, // input data bit 0 is XXXX1XXX
   P_I_B1   =      0x10, // input data bit 1 is XXX1XXXX
   P_I_B2   =      0x20, // input data bit 2 is XX1XXXXX
   P_I_B3   =      0x80, // input data bit 3 is 1XXXXXXX
   P_I_MASK =      0xB8,
   P_IRQ    =      0x40  // input IRQ\ signal is X1XXXXXX
};

// in control port: 37A/27A/3BE
enum CONTROL_PORT {
  P_W_PCE    =    1,   // output to write PCE from LPT is XXXXXXX1
  P_R_PCE    =    2,   // output to read PCE from LPT is XXXXXX1X
  P_S_RDY    =    0x08,// SWITCH = 1, from nPortInp
  P_R_RDY    =    0x10,// SWITCH = 1, from nPortInp
  P_SWITCH   =    0,   // SWITCH\ = 1, nPortStatus
  P_NORMAL   =    8    // let all control to output disactive
};

extern int nCommType;
extern UINT nPortAddr;
extern UINT nPortStatus;
extern UINT nPortInp;

            
            /*****************************
            **
            ** Execution codes
            ** 
            *****************************/


/**************************************************************************
**
** Name : SetCommType
**
** Function
**
**    Input  :  0: serial_port, 1: PCE card  2:parallel_port
**    Output :
**    Return : valid or not
** Notes:
**
**************************************************************************/
BOOL SetCommType(int nTempCommType)
{
    if (nTempCommType >= 0 && nTempCommType <=2 ) {
        nCommType = nTempCommType;
        return(TRUE);
    }
    else return(FALSE);

}

/**************************************************************************
**
** Name : SetupCommunication
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
BOOL SetupCommunication(UINT pData)
{
    UINT uintTemp;

    switch(nCommType) {
        case 0: // RS-232
       //  return(open_pcport()) ;
            break;
        case 2:   // LPT
            nPortAddr = pData;
            nPortStatus = pData+2;
            nPortInp  = pData+1 ;
            outportb(nPortStatus, P_SWITCH) ;
            break ;
        case 1:   // PCE
        default:
            nPortAddr = pData;
            nPortStatus = pData+1;
            break;
    }
 return TRUE;    
 //  if ( AbiGetRegLen(&uintTemp) == ICE_OK ) {
 //       isInSetup = FALSE;
 //       return (TRUE);
 //   }    
 //   else return(FALSE);
}
 
/**************************************************************************
**
** Name : SendReceive
**
** Function  to call SendStream() and ReceiveStream()
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
STATUS SendReceive(UINT wLoop, int tcount)
{   
    STATUS status;
    UINT inputStreamLen;
    int nYesNo;
    
RE_LINK:  

    _disable();       
    
    status = SendStream(outputStream,wLoop);
    

    if (status == ICE_TIME_OUT){
        _enable();
        if (isInSetup == FALSE) {
    
 //           nYesNo = OpenAbiComDlg(1);
            
  //          if (nYesNo == IDOK) 
  //              goto RE_LINK; 
  //          else {
                //ExitEpsld(); 
         //   }    
        }        
        return(status);
    } 

   // _disable();
    status = ReceiveStream(inputStream,&inputStreamLen,tcount);
    _enable();

    if (status == ICE_TIME_OUT){
        if (isInSetup == FALSE) {
      
  //          nYesNo = OpenAbiComDlg(1);

  //          if (nYesNo == IDOK)
  //              goto RE_LINK; 
  //          else {
                //ExitEpsld();
   //         }    
        }    
        return(status);
    }             

    status = (STATUS) inputStream[0];
    return status;
}                         

/****************************************************************************
**
**  SendStream
**
**  Description: Send command protocol to communication port.
**
**  Parameters:
**     input:
**
**     output:
**
**        return data --
**
****************************************************************************/
STATUS SendStream(UCHAR* stream, UINT len)
{  
//extern int TestKey(WORD);

UCHAR uchChecksum, uchHighLen, uchLowLen;
UINT wLoop;
UCHAR uchEcho;

    uchChecksum = 0;
    for (wLoop = 0; wLoop < len; wLoop++){
        uchChecksum = (UCHAR)(uchChecksum + stream[wLoop]);  
    }    
    stream[len] = (UCHAR)(~uchChecksum + 1);
    len++;

    uchLowLen = LowByte(len);
    uchHighLen = HighByte(len);
    uchChecksum = (UCHAR)(~(uchLowLen+ uchHighLen) + 1);
   
   
    time_t startTime,currentTime;

    
    time(&startTime);

    while (1) {
       // if ( 1 == TestKey(VK_ESCAPE) ) return(ICE_TIME_OUT);
        if (sendWait(LEAD_CODE) == ABI_OK) {
            if (sendB(uchLowLen) == ABI_OK) {
                if (sendB(uchHighLen) == ABI_OK) {
                    if (sendB(uchChecksum) == ABI_OK)
                        break;
                }
            }
        }           

        time(&currentTime);
        if ((currentTime - startTime) > 5)
            return(ICE_TIME_OUT);
    }   
    
    if ( receiveB(&uchEcho) == ABI_OK) {
        if ( uchEcho != (UCHAR) HEAD_OK ) {
       //    MessageBeep(-1);
         //   printf(" Send echo head error!\n");
            return(ICE_TIME_OUT);
        }
    }
    else return(ICE_TIME_OUT);
          
    for (wLoop = 0; wLoop < len; wLoop++){
         if (sendB(stream[wLoop]) != ABI_OK){
     //       MessageBeep(-1);             
        //  printf(" Send data error!\n");
            return(ICE_TIME_OUT);
         }
    }   
    if ( receiveB(&uchEcho) == ABI_OK) {
        if (uchEcho == (UCHAR) REC_OK) return ICE_OK;
        else {
        //    printf ("Send rec_ok error!\n");
            return (ICE_TIME_OUT);
        }
    }
    else return(ICE_TIME_OUT);
   
}

/****************************************************************************
**
**  ReceiveStream
**
**  Description: Receive output command protocol to communication port.
**
**  Parameters:
**     input:
**
**     output:
**
**        return data --
**
****************************************************************************/
STATUS ReceiveStream(UCHAR* inStream, UINT *inStreamLen, time_t waitSec)
{
UCHAR uchEcho;
UINT len;
UCHAR uchChecksum,finalFlag;
UINT wLoop, i;
UCHAR receiveBuf[2048];

    for (i=0; i<wHeadLoop; i++) {
        if (ABI_OK != receiveWait(waitSec, &uchEcho)) {
        //  printf(" receiveWait error!\n");
            return(ICE_TIME_OUT);
        }
        receiveBuf[0] = (UCHAR)uchEcho;
        finalFlag = 1;//ON;
        for(wLoop = 1; wLoop < 4; wLoop++){
            if ( ABI_OK == receiveB(&uchEcho) )
                receiveBuf[wLoop] = (UCHAR)uchEcho;
            else {
                finalFlag = 0;//OFF;
                break;
            }
        }
        if (finalFlag == 0) return(ICE_OK); //continue;
        else break;
    }
    if (i >= wHeadLoop) {
    //  printf(" Receive Head Error!\n");
        return(ICE_TIME_OUT);
    }
    len = *(UINT *)&receiveBuf[1];   /* data length */
    uchChecksum = 0;
    for(wLoop = 1; wLoop < 4; wLoop++)
        uchChecksum=(UCHAR)(uchChecksum+ receiveBuf[wLoop]); 
        
    if ((uchChecksum == 0) && (receiveBuf[0] == LEAD_CODE)) {
        if ( sendB(HEAD_OK) != ABI_OK) {
    //        printf(" send head_ok error");
            return(ICE_TIME_OUT);
        }
        finalFlag = 1;//ON;
        for (wLoop = 0; wLoop < (UINT)len; wLoop++) {
            if ( receiveB(&uchEcho) == ABI_OK)
                receiveBuf[wLoop] = (UCHAR)uchEcho;
            else {
                finalFlag = 0;//OFF;
                break;
            }
            uchChecksum =(UCHAR)(uchChecksum+ receiveBuf[wLoop]);
        }
        if (finalFlag == 0 /*OFF*/) {
            return(ICE_OK);
        }    
        if (uchChecksum == 0) {
            *inStreamLen = len;
            memcpy(inStream,&receiveBuf[0],len);
            if (sendB(REC_OK) != ABI_OK) {
      //        printf(" cannot send Rec_OK!\n"); 
                return(ICE_TIME_OUT);//continue;
            }    
            else return(ICE_OK);
        }
        else if (sendB(REC_FAIL) != ABI_OK) {
       //   printf(" Cannot send rec_fail!\n");
            return(ICE_TIME_OUT);//continue;   
        }    
    }
    
//    printf("checksum error!\n"); 
    return(ICE_TIME_OUT);
}
              
              
/**************************************************************************
**
** Name : sendB()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
int sendB(UCHAR txData)
{
    UINT i;    

    switch(nCommType) {
        case 0: /* RS-232 */                  /*  wait for          */
            for (i = 0; i < IO_LOOP; i++ ) {   /*  transmit (TBE)    */
                if ((inportb(nPortStatus) & 0x20) && /*  holding register  */
                    (inportb(nPortAddr+6) & 0x20)) { /* DSR = high */
                    outportb(nPortAddr, txData) ;
                    return(ABI_OK) ;
                }
            }
            break ;
      case 2: /* LPT */
         for (i = 0; i < IO_LOOP; i++ )     
            if ((!(inportb(nPortInp) & P_S_RDY)) && (!(inportb(nPortInp) & P_S_RDY)) ){
		       outportb(nPortAddr,txData);
               outportb(nPortStatus, (P_SWITCH | P_W_PCE)); /* STROBE\ = low SWITCH=high xsq */
               outportb(nPortStatus, P_SWITCH); /* STROBE\ = high, SWITCH = high */
               return(ABI_OK) ;
            }  
         break ;
      case 1: /* PCE */
      default:
         for (i = 0; i < IO_LOOP; i++)
//          if (TRUE == IsEscape()) return (!ABI_OK);
            if (inportb(nPortStatus) & SD_RDY) {
               outportb(nPortAddr,txData);
               return(ABI_OK) ;
            }
         break ;
   }        
   //AfxMessageBox("Send Fail");
   return(!ABI_OK);
}        /* end of sendB() */

/**************************************************************************
**
** Name : receiveB()
**
** Function
**
**    Input  : none
**
**    Output :
**
** Notes:
**
**************************************************************************/
int receiveB(UCHAR *rcvByte)
{
UINT i;
UCHAR tmp, tmp1, tmp2 ;


    switch (nCommType) {
         case 0: /* RS-232 */
        //    for (i = 0; i < IO_LOOP; i++ ) {
        //      if (TRUE == IsEscape()) return (-1);
        //          if ((tmp = inportb(nPortStatus)) & 1) /* RxDRDY == 1 */
        //              return((UINT)inportb(nPortAddr)) ;
         //   }      
            break ;
         case 2: /* LPT */             
            outportb(nPortStatus, P_SWITCH) ; /* nPortInp switch to status */
//          outportb(nPortStatus, P_NORMAL);
            for (i = 0; i < IO_LOOP; i++) {
//              if (TRUE == IsEscape()) return (!ABI_OK);
                if ((!(inportb(nPortInp) & P_R_RDY)) && (!(inportb(nPortInp) & P_R_RDY))) {
                  outportb(nPortStatus, P_NORMAL ); /* switch = LOW  xsq */
                  outportb(nPortStatus, (P_NORMAL | P_R_PCE)); /* PC-RD-PCE\ = low */
                  tmp = P_I_MASK ; /* delay, wait data send from PCE */
                  tmp1 = tmp2 = 0x80 ;
                  tmp &= inportb(nPortInp) ;  /* Get high nibble */
                  outportb(nPortStatus, P_NORMAL); /* PC-RD-PCE\ = high */
                  outportb(nPortStatus, P_NORMAL); /* PC-RD-PCE\ = high */
                  tmp1 &= (~tmp) ;
                  tmp1 |= ((tmp << 1) & 0x70) ;
                  tmp = P_I_MASK ; /* delay, wait high/low nibble switch ready */
                  tmp &= inportb(nPortInp) ; /* Get low  nibble */
                  outportb(nPortStatus, P_SWITCH);
                  tmp2 &= (~tmp) ;
                  tmp2 |= ((tmp << 1) & 0x70) ;
                  tmp2 >>= 4 ;
                  *rcvByte = (UCHAR) (tmp1 | tmp2);
                  return(ABI_OK);
               } 
            }                            
            break ;
         case 1: /* PCE */
         default:
            for (i = 0; i < IO_LOOP; i++) {
                if (inportb(nPortStatus) & RV_RDY) {
                    *rcvByte = (UCHAR) (inportb(nPortAddr));
                    return(ABI_OK);
                }
            }       
            break ;
    }
   //AfxMessageBox("Receive Fail");
    return(!ABI_OK);
} // end of receiveB()

/**************************************************************************
**
** Name : sendWait()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
int sendWait(UCHAR txData)
{
time_t startTime,currentTime;

   time(&startTime);

   while(1) {               
//        if (TRUE == IsEscape()) return (!ABI_OK);
//        if ( 1 == TestKey(VK_ESCAPE) ) return( !ABI_OK);
        if (sendB(txData) == ABI_OK)
            return(ABI_OK) ;
        time(&currentTime);
        if ((currentTime - startTime) > 5) return(!ABI_OK);
   }
}        /* end of sendWait() */

/**************************************************************************
**
** Name :  receiveWait()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
int receiveWait(time_t waitSec, UCHAR *rcvByte)
{
//UCHAR rxData;
time_t startTime,currentTime;

    time(&startTime);

//     for ( i = 0; i < IO_LOOP; i++ )
//      if (inportb(nPortStatus) & RV_RDY) {
//          rxData = inportb(nPortAddr);
//          return(GetRxData());
//      }

    while (1) {
//        if ( 1 == TestKey(VK_ESCAPE) ) return (!ABI_OK);
        if ( receiveB(rcvByte) == ABI_OK )
            return(ABI_OK);
        time(&currentTime);
        if ((currentTime - startTime) > waitSec) return(!ABI_OK);
   }
} /* end of receiveWait() */

/**************************************************************************
**
** Name :  IsEscape()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
BOOL IsEscape()
{
/*    int nEcho;
    
    if (kbhit()) {
        nEcho = getch();
        if (nEcho == ESC) 
            return (TRUE);
        else 
            return (FALSE); 
    }
    else 
*/
    return(FALSE); 
    
}
/**************************** End of File **********************************/

