
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/FWSETUP/COMMUNIC.CPP   1.3   20 Jun 1996 09:34:54   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/FWSETUP/COMMUNIC.CPP  $
** 
**    Rev 1.3   20 Jun 1996 09:34:54   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.1   10 Jun 1996 10:29:48   ZJRD
** EasyPack/SLD Version 1.20
** 
**   
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  COMMUNIC.CPP
//
//  Description:The implement file of the class CCommunicationDialog
//
//  Author:     Roger Zhang
//  Date:       10/06/95
//
//  Updated by: Frank
//  Date:       12/27/95
//
//  Modification:
//
//      1. 10/06/95, Ver 0.1d
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "resource.h"

#include "communic.h"
//#include "uicom.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
extern UINT nPortAddr;
extern int nCommType;
extern BOOL Str2Num(char * psz, DWORD & dwVal);                   
char * PortAddr[8] = {
    "0x300",  //PCE
    "0x378",  //LPT1
    "0x278",  //LPT2
    "0x3BC",  //LPT3
    "0x3F8",  //COM1
    "0x2F8",  //COM2
    "0",    //COM3
    "0"     //COM4
};                                       

/////////////////////////////////////////////////////////////////////////////
// CCommunicationDialog dialog

extern int OpenAbiComDlg(int);

CCommunicationDialog::CCommunicationDialog(CWnd* pParent /*=NULL*/)
    : CDialog(CCommunicationDialog::IDD, pParent)
{
    //{{AFX_DATA_INIT(CCommunicationDialog)
    m_nType = 2;//1nCommType;
    //}}AFX_DATA_INIT
          
	char * pEnd;
	for(int i = 0; i < 8; i ++) {          
    	m_nPortAddr[i] = (int)strtol(PortAddr[i], &pEnd, 16);
    }                                               
//    m_nPortAddr[nCommType] = nPortAddr;
    wsprintf(m_strAddr.GetBuffer(10), "0x%X", nPortAddr);
    m_strAddr.ReleaseBuffer();
}

void CCommunicationDialog::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CCommunicationDialog)
    DDX_Radio(pDX, IDC_COMM_PCE, m_nType);
    DDX_Text(pDX, IDC_COMM_EDIT, m_strAddr);
    //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CCommunicationDialog, CDialog)
    //{{AFX_MSG_MAP(CCommunicationDialog)
    ON_BN_CLICKED(IDC_COMM_LPT1, OnCommLpt1)
    ON_BN_CLICKED(IDC_COMM_LPT2, OnCommLpt2)
    ON_BN_CLICKED(IDC_COMM_LPT3, OnCommLpt3)
//	ON_BN_CLICKED(ID_DETAIL, OnDetail)
	ON_BN_CLICKED(IDC_COMM_PCE, OnCommPce)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CCommunicationDialog message handlers

void CCommunicationDialog::OnOK()
{
    // TODO: Add extra validation here
    UpdateData();                    
    
    DWORD dw;
    BOOL is = Str2Num(m_strAddr.GetBuffer(10), dw);
    m_strAddr.ReleaseBuffer();
    
    if(!is || dw > 0xFFF) {
        AfxMessageBox("Address Error!");
        return;
    }                                
                
                
    nCommType = m_nType>0?2:1;
    nPortAddr = int(dw);
    
    CDialog::OnOK();
}

void CCommunicationDialog::OnCommLpt1()
{
    // TODO: Add your control notification handler code here
    
    UpdateData(TRUE);                    
    m_nType=1;
    //m_strAddr = PortAddr[m_nType];              
    wsprintf(m_strAddr.GetBuffer(10), "0x%X", m_nPortAddr[1]);
    m_strAddr.ReleaseBuffer();
    UpdateData(FALSE);   
}

void CCommunicationDialog::OnCommLpt2()
{
    // TODO: Add your control notification handler code here
    UpdateData(TRUE);          
    m_nType=2;          
    //m_strAddr = PortAddr[m_nType];
    wsprintf(m_strAddr.GetBuffer(10), "0x%X", m_nPortAddr[2]);
    m_strAddr.ReleaseBuffer();
    UpdateData(FALSE);   
}

void CCommunicationDialog::OnCommLpt3()
{
    // TODO: Add your control notification handler code here
    UpdateData(TRUE);                    
    //m_strAddr = PortAddr[m_nType];
    m_nType=3;
    wsprintf(m_strAddr.GetBuffer(10), "0x%X", m_nPortAddr[3]);
    m_strAddr.ReleaseBuffer();
    UpdateData(FALSE);   
}

BOOL CCommunicationDialog::OnInitDialog()
{
    CDialog::OnInitDialog();
    
    // TODO: Add extra initialization here
    CenterWindow();
//    m_nType=nCommType;
    
    return TRUE;  // return TRUE  unless you set the focus to a control
}

//void CCommunicationDialog::OnDetail()
//{
	// TODO: Add your control notification handler code here
//	int nDummy;
//	nDummy = OpenAbiComDlg(0);
//}

void CCommunicationDialog::OnCommPce()
{
	// TODO: Add your control notification handler code here
    UpdateData(TRUE);                    
    m_nType=0;
    //m_strAddr = PortAddr[m_nType];
    wsprintf(m_strAddr.GetBuffer(10), "0x%X", m_nPortAddr[0]);
    m_strAddr.ReleaseBuffer();
    UpdateData(FALSE);   
}
