// hlistbox.cpp : implementation file
//

#include "stdafx.h"
//#include "epsld52f.h"
#include "hlistbox.h"      
#include "resource.h"
#include "control.h"
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif
extern COLORREF clrBtnFace,clrBtnShadow,clrBtnHilite,clrWindowFrame;
         
static void NEAR PASCAL PatB(HDC hDC, int x, int y, int dx, int dy, COLORREF rgb)
{
	SetBkColor(hDC, rgb);
	CRect rect(x, y, x+dx, y+dy);
	ExtTextOut(hDC, 0, 0, ETO_OPAQUE, &rect, NULL, 0, NULL);
}

static HBITMAP PASCAL CreateDitherBitmap()
{
	struct  // BITMAPINFO with 16 colors
	{
		BITMAPINFOHEADER bmiHeader;
		RGBQUAD      bmiColors[16];
	} bmi;
	memset(&bmi, 0, sizeof(bmi));

	bmi.bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
	bmi.bmiHeader.biWidth = 8;
	bmi.bmiHeader.biHeight = 8;
	bmi.bmiHeader.biPlanes = 1;
	bmi.bmiHeader.biBitCount = 1;
	bmi.bmiHeader.biCompression = BI_RGB;

	COLORREF clr = ::GetSysColor(COLOR_BTNFACE);
	bmi.bmiColors[0].rgbBlue = GetBValue(clr);
	bmi.bmiColors[0].rgbGreen = GetGValue(clr);
	bmi.bmiColors[0].rgbRed = GetRValue(clr);

	if (1)
		clr = ::GetSysColor(COLOR_BTNHIGHLIGHT);
	else
		clr = RGB(255, 255, 255);
	bmi.bmiColors[1].rgbBlue = GetBValue(clr);
	bmi.bmiColors[1].rgbGreen = GetGValue(clr);
	bmi.bmiColors[1].rgbRed = GetRValue(clr);

	// initialize the brushes
	long patGray[8];
	for (int i = 0; i < 8; i++)
	   patGray[i] = (i & 1) ? 0xAAAA5555L : 0x5555AAAAL;

	HDC hDC = GetDC(NULL);
	HBITMAP hbm = CreateDIBitmap(hDC, &bmi.bmiHeader, CBM_INIT,
		(LPBYTE)patGray, (LPBITMAPINFO)&bmi, DIB_RGB_COLORS);
	ReleaseDC(NULL, hDC);

	return hbm;
}                    

int CHListBox::PointToItem(CPoint pt)
{
	return (pt.x+m_nFirst)/26;
}           

CRect CHListBox::ItemToRect(int item)
{
	CRect rect;
	rect.top=0;
	rect.left=item*26-m_nFirst;
	rect.right=rect.left+26;
	rect.bottom=26;
	return rect;
}



   
/////////////////////////////////////////////////////////////////////////////
// CHListBox

CHListBox::CHListBox()
{                       
	m_pdcMem=new CDC;
	m_nFirst=0;
	m_nScroll=10*22;
	m_nActiveItem=0;
}

CHListBox::~CHListBox()
{             
   ReleaseDC(m_pdcMem);
   delete m_pdcMem;
}

BOOL CHListBox::Create(CWnd* pParentWnd,CRect rect,UINT nID)
{
	if(pParentWnd!=NULL)
        ASSERT_VALID(pParentWnd);
    DWORD csStyle=CS_DBLCLKS;    
    DWORD dwStyle=WS_VISIBLE|WS_HSCROLL|WS_CHILD|WS_BORDER|WS_TABSTOP;
    if(!CWnd::Create(AfxRegisterWndClass(csStyle,AfxGetApp()->LoadCursor(IDC_ARROW),(HBRUSH)::GetStockObject(WHITE_BRUSH)),NULL,dwStyle,rect,pParentWnd,nID)) 
          return 0;
	return 1;	    
}  
    
    
void CHListBox::DrawButton(CDC*pDC,CDC*pdcMem,CRect rect,int item)
{
	ASSERT(pDC != NULL);

	// make the coordinates the interior of the button
	int dx = 17 ;
	int dy = 16 ;
//Highlight the selected item
    if(item==m_nActiveItem+MAX_TOOLBAR_BUTTON+1)  
    {
    	
    	rect.bottom+=3;
    	rect.right+=3;
    	rect.left-=3;
    	rect.top-=3;
    	CBrush br(RGB(0,0,255));
        pDC->FillRect(&rect,&br);
    }                
    rect.bottom-=3;
    rect.right-=3;
	rect.left+=5;
	rect.top+=6;
	// border around button
	PatB(pDC->m_hDC, rect.left,rect.top-1,dx, 1,  clrWindowFrame);
	PatB(pDC->m_hDC, rect.left,rect.top+dy,dx, 1,  clrWindowFrame);
	PatB(pDC->m_hDC, rect.left-1,rect.top,1,dy, clrWindowFrame);
	PatB(pDC->m_hDC, rect.left+dx,rect.top,1,dy, clrWindowFrame);

	// interior grey
	PatB(pDC->m_hDC, rect.left,rect.top, dx, dy, clrBtnFace);

	CPoint ptOffset;
	ptOffset.x = (dx -16 - 1) >> 1;
	ptOffset.y = (dy -15) >> 1;
	// regular button look
	PatB(pDC->m_hDC, rect.left,rect.top, 1, dy - 1, clrBtnHilite);
	PatB(pDC->m_hDC, rect.left,rect.top, dx - 1, 1, clrBtnHilite);

	PatB(pDC->m_hDC, rect.left + dx - 1, rect.top, 1, dy, clrBtnShadow);
	PatB(pDC->m_hDC, rect.left,rect.top + dy-1, dx, 1,   clrBtnShadow);

	PatB(pDC->m_hDC, rect.left + 1 + dx - 3, rect.top + 1, 1, dy-2, clrBtnShadow);
	PatB(pDC->m_hDC, rect.left + 1, rect.top + dy - 2, dx - 2, 1, clrBtnShadow);
	
	
	pDC->BitBlt(rect.left+2,rect.top+2, 15, 14, pdcMem, 16*item,0,SRCCOPY);
	
/*	if(item==27) 
	  	pDC->DrawText("Search ComBox",13,rect+CPoint(20,0),DT_LEFT );			
	else if(item==-1)
	    pDC->DrawText("Separator",9,rect+CPoint(20,0),DT_LEFT );			
	else 
	{
		CString str;
		str.LoadString(buttons[item]);
		int n,m=str.Find('\n');
		n=str.GetLength();
		CString strText;
		strText=str.Mid(m+1,n-m);
		pDC->DrawText(strText.GetBuffer(n-m-1),n-m-1,rect+CPoint(20,0),DT_LEFT );			
		str.ReleaseBuffer();
	}	*/
} 
    
BEGIN_MESSAGE_MAP(CHListBox, CWnd)
	//{{AFX_MSG_MAP(CHListBox)
	ON_WM_HSCROLL()
	ON_WM_CREATE()
	ON_WM_PAINT()
	ON_WM_LBUTTONDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CHListBox message handlers


void CHListBox::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{                       int i;
	// TODO: Add your message handler code here and/or call default
	   switch(nSBCode) {
        case SB_LINELEFT:                 
            if(m_nFirst <= 0)  return;  
            i=26         ;
            m_nFirst -=i;   
            ScrollWindow(i, 0);
            SetScrollPos(SB_HORZ, m_nFirst);
            break;
        case SB_LINERIGHT:
            if(m_nFirst >= m_nScroll)    return;
            i=26          ;
            m_nFirst +=26;
            ScrollWindow(-i,0);
            SetScrollPos(SB_HORZ, m_nFirst);
            break;                        
       }     
	CWnd::OnHScroll(nSBCode, nPos, pScrollBar);
}

int CHListBox::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	clrBtnFace = ::GetSysColor(COLOR_BTNFACE);
	clrBtnShadow = ::GetSysColor(COLOR_BTNSHADOW);
	clrBtnHilite = ::GetSysColor(COLOR_BTNHIGHLIGHT);
	clrWindowFrame = ::GetSysColor(COLOR_WINDOWFRAME);    
///////////////////////////////////////////////////////////
    
    CBitmap * pBitmap=new CBitmap;
    pBitmap->LoadBitmap(IDR_MAINFRAME);  
    CDC *pDC;
	CBitmap *pbmpMyBitmap, *pbmpOld;
	pDC = GetDC();
	
	m_pdcMem->CreateCompatibleDC(pDC); 
	pbmpOld = m_pdcMem->SelectObject( pBitmap);
    ReleaseDC(pDC); 
    
    SetScrollRange(SB_HORZ,0,m_nScroll);
	return 0;
}

void CHListBox::OnPaint()
{
	CPaintDC dc(this); // device context for painting
	CRect rect(3,3,23,23);
	int nFirst=m_nFirst/26;
	nFirst+=36;//MAX_TOOLBAR_BUTTON;
	int i;
	for( i=nFirst;i<=MAX_TOOLBAR_ICON;i++)
	{
		DrawButton(&dc,m_pdcMem,rect,i);			
	    rect+=CPoint(26,0);
	}    
}

void CHListBox::OnLButtonDown(UINT nFlags, CPoint point)
{
	// TODO: Add your message handler code here and/or call default
    
    int nActive=PointToItem(point.x);
    CRect rect;
	if(m_nActiveItem!=nActive)
	{
	     rect=ItemToRect(m_nActiveItem);
	     InvalidateRect(&rect);
	     m_nActiveItem=nActive;	
	     rect=ItemToRect(m_nActiveItem);                        
	     CString strEdit;
	     strEdit=( (CCONTROL*)(AfxGetApp()->m_pMainWnd->\
	           GetDlgItem(AFX_IDW_TOOLBAR) ))->m_strUsrDefComm[m_nActiveItem];
	     GetParent()->GetDlgItem(IDC_COMM_EDIT)->SetWindowText((strEdit));
	     InvalidateRect(&rect);
	     UpdateWindow();
	}     
	
	CWnd::OnLButtonDown(nFlags, point);
}
