
/***************************************************************************
**
** File name : dadregtb.cpp
** Author:John Zhou
** Description:
**    This file contains register tables used in DAD.
**
**
**    Finished date: 1995.10
**
**
**    Copyright (C) 1995 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/
//#include "stdafx.h"

#include "ice_dad.h"

//POINT TO TABLE ADDED BY JOHN 96.1
SFRNAME* sByteTblPoint;
SFRNAME* sBitTblPoint;

/* Spe(unsigned char cial Function Register Table: must sort by Dir-Adr */
  SFRNAME SFRbyte[]={
        /* SFR-Name    Dir-Addr   SfrAttr      CPUmode */

        {(unsigned char*) "P0",         0x80,      1,
         C_H_M31|C_H_M51|C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M44|C_H_M8344|C_H_M154|C_H_M152A|C_H_M152B|C_H_M80C652|C_H_M83C652|C_H_M51FA
         |C_H_M8351FA|C_H_M752|C_H_M83C752|C_H_M552|C_H_M83C552|C_H_M562|C_H_M83C562|C_H_M750|C_H_M83C750|C_H_M751|C_H_M83C751  ,
         C_L_M31|C_L_M51|C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M44|C_L_M8344|C_L_M154|C_L_M152A|C_L_M152B|C_L_M80C652|C_L_M83C652|C_L_M51FA
         |C_L_M8351FA|C_L_M752|C_L_M83C752|C_L_M552|C_L_M83C552|C_L_M562|C_L_M83C562|C_L_M750|C_L_M83C750|C_L_M751|C_L_M83C751 },
        {(unsigned char*) "SP",         0x81,      0,
        C_H_M31|C_H_M51|C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M44|C_H_M8344|C_H_M154|C_H_M152A|C_H_M152B|C_H_M80C652|C_H_M83C652|C_H_M51FA|C_H_M8351FA|C_H_M752
        |C_H_M83C752|C_H_M552|C_H_M83C552|C_H_M562|C_H_M83C562|C_H_M750|C_H_M83C750|C_H_M751|C_H_M83C751  ,
        C_L_M31|C_L_M51|C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M44|C_L_M8344|C_L_M154|C_L_M152A|C_L_M152B|C_L_M80C652|C_L_M83C652|C_L_M51FA|C_L_M8351FA|C_L_M752
        |C_L_M83C752|C_L_M552|C_L_M83C552|C_L_M562|C_L_M83C562|C_L_M750|C_L_M83C750|C_L_M751|C_L_M83C751 },
        {(unsigned char*) "DPL",        0x82,      0,
        C_H_M31|C_H_M51|C_H_M32|C_H_M52|C_H_M52|C_H_M51|C_H_M528|C_H_M83C528|C_H_M44|C_H_M8344|C_H_M154|C_H_M152A|C_H_M152B|C_H_M80C652|C_H_M83C652|C_H_M51FA
        |C_H_M8351FA|C_H_M752|C_H_M83C752|C_H_M552|C_H_M83C552|C_H_M562|C_H_M83C562|C_H_M750|C_H_M83C750|C_H_M751|C_H_M83C751  ,
        C_L_M31|C_L_M51|C_L_M32|C_L_M52|C_L_M52|C_L_M51|C_L_M528|C_L_M83C528|C_L_M44|C_L_M8344|C_L_M154|C_L_M152A|C_L_M152B|C_L_M80C652|C_L_M83C652|C_L_M51FA
        |C_L_M8351FA|C_L_M752|C_L_M83C752|C_L_M552|C_L_M83C552|C_L_M562|C_L_M83C562|C_L_M750|C_L_M83C750|C_L_M751|C_L_M83C751 },
        {(unsigned char*) "DPH",        0x83,      0,
        C_H_M31|C_H_M51|C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M44|C_H_M8344|C_H_M154|C_H_M152A|C_H_M152B|C_H_M80C652|C_H_M83C652|C_H_M51FA|C_H_M8351FA
        |C_H_M752|C_H_M83C752|C_H_M552|C_H_M83C552|C_H_M562|C_H_M83C562|C_H_M750|C_H_M83C750|C_H_M751|C_H_M83C751  ,
        C_L_M31|C_L_M51|C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M44|C_L_M8344|C_L_M154|C_L_M152A|C_L_M152B|C_L_M80C652|C_L_M83C652|C_L_M51FA|C_L_M8351FA
        |C_L_M752|C_L_M83C752|C_L_M552|C_L_M83C552|C_L_M562|C_L_M83C562|C_L_M750|C_L_M83C750|C_L_M751|C_L_M83C751 },
        {(unsigned char*) "ADAT",        0x84,      0,
         C_H_M752|C_H_M83C752 ,C_L_M752|C_L_M83C752 },
        {(unsigned char*) "GMOD",        0x84,      0, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char*) "TFIFO",        0x85,      0, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char*) "PCON",       0x87,      0,
         C_H_M31|C_H_M51|C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M154|C_H_M152A|C_H_M152B|C_H_M80C652|C_H_M83C652|C_H_M51FA|C_H_M8351FA|C_H_M752
         |C_H_M83C752|C_H_M552|C_H_M83C552|C_H_M562|C_H_M83C562|C_H_M750|C_H_M83C750|C_H_M751|C_H_M83C751  ,
         C_L_M31|C_L_M51|C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M154|C_L_M152A|C_L_M152B|C_L_M80C652|C_L_M83C652|C_L_M51FA|C_L_M8351FA|C_L_M752
         |C_L_M83C752|C_L_M552|C_L_M83C552|C_L_M562|C_L_M83C562|C_L_M750|C_L_M83C750|C_L_M751|C_L_M83C751 },
        {(unsigned char*) "TCON",       0x88,      1,
        C_H_M31|C_H_M51|C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M44|C_H_M8344|C_H_M154|C_H_M152A|C_H_M152B|C_H_M80C652|C_H_M83C652|C_H_M51FA
        |C_H_M8351FA|C_H_M752|C_H_M83C752|C_H_M552|C_H_M83C552|C_H_M562|C_H_M83C562|C_H_M750|C_H_M83C750|C_H_M751|C_H_M83C751  ,
        C_L_M31|C_L_M51|C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M44|C_L_M8344|C_L_M154|C_L_M152A|C_L_M152B|C_L_M80C652|C_L_M83C652|C_L_M51FA
        |C_L_M8351FA|C_L_M752|C_L_M83C752|C_L_M552|C_L_M83C552|C_L_M562|C_L_M83C562|C_L_M750|C_L_M83C750|C_L_M751|C_L_M83C751 },
        {(unsigned char*) "TMOD",       0x89,      0,
        C_H_M31|C_H_M51|C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M44|C_H_M8344|C_H_M154|C_H_M152A|C_H_M152B|C_H_M80C652|C_H_M83C652|C_H_M51FA
        |C_H_M8351FA|C_H_M552|C_H_M83C552|C_H_M562|C_H_M83C562  ,
        C_L_M31|C_L_M51|C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M44|C_L_M8344|C_L_M154|C_L_M152A|C_L_M152B|C_L_M80C652|C_L_M83C652|C_L_M51FA
        |C_L_M8351FA|C_L_M552|C_L_M83C552|C_L_M562|C_L_M83C562 },
        {(unsigned char*) "TL",         0x8A,      0,
        C_H_M752|C_H_M83C752|C_H_M750|C_H_M83C750|C_H_M751|C_H_M83C751  ,
        C_L_M752|C_L_M83C752|C_L_M750|C_L_M83C750|C_L_M751|C_L_M83C751 },
        {(unsigned char*) "TL0",        0x8A,      0,
        C_H_M31|C_H_M51|C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M44|C_H_M8344|C_H_M154|C_H_M152A|C_H_M152B|C_H_M80C652|C_H_M83C652|C_H_M51FA
        |C_H_M8351FA|C_H_M552|C_H_M83C552|C_H_M562|C_H_M83C562  ,
        C_L_M31|C_L_M51|C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M44|C_L_M8344|C_L_M154|C_L_M152A|C_L_M152B|C_L_M80C652|C_L_M83C652|C_L_M51FA
        |C_L_M8351FA|C_L_M552|C_L_M83C552|C_L_M562|C_L_M83C562 },
        {(unsigned char*) "TL1",        0x8B,      0,
         C_H_M31|C_H_M51|C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M44|C_H_M8344|C_H_M154|C_H_M152A|C_H_M152B|C_H_M80C652|C_H_M83C652|C_H_M51FA
         |C_H_M8351FA|C_H_M552|C_H_M83C552|C_H_M562|C_H_M83C562  ,
         C_L_M31|C_L_M51|C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M44|C_L_M8344|C_L_M154|C_L_M152A|C_L_M152B|C_L_M80C652|C_L_M83C652|C_L_M51FA
         |C_L_M8351FA|C_L_M552|C_L_M83C552|C_L_M562|C_L_M83C562 },
        {(unsigned char*) "RTL",        0x8B,      0,
         C_H_M752|C_H_M83C752|C_H_M750|C_H_M83C750|C_H_M751|C_H_M83C751  ,
         C_L_M752|C_L_M83C752|C_L_M750|C_L_M83C750|C_L_M751|C_L_M83C751 },
        {(unsigned char*) "TH",         0x8C,      0,
         C_H_M752|C_H_M83C752|C_H_M750|C_H_M83C750|C_H_M751|C_H_M83C751  ,
         C_L_M752|C_L_M83C752|C_L_M750|C_L_M83C750|C_L_M751|C_L_M83C751 },
        {(unsigned char*) "TH0",        0x8C,      0,
        C_H_M31|C_H_M51|C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M44|C_H_M8344|C_H_M154|C_H_M152A|C_H_M152B|C_H_M80C652|C_H_M83C652|C_H_M51FA
        |C_H_M8351FA|C_H_M552|C_H_M83C552|C_H_M562|C_H_M83C562  ,
        C_L_M31|C_L_M51|C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M44|C_L_M8344|C_L_M154|C_L_M152A|C_L_M152B|C_L_M80C652|C_L_M83C652|C_L_M51FA
        |C_L_M8351FA|C_L_M552|C_L_M83C552|C_L_M562|C_L_M83C562 },
        {(unsigned char*) "RTH",        0x8D,      0,
        C_H_M752|C_H_M83C752|C_H_M750|C_H_M83C750|C_H_M751|C_H_M83C751  ,
        C_L_M752|C_L_M83C752|C_L_M750|C_L_M83C750|C_L_M751|C_L_M83C751 },
        {(unsigned char*) "TH1",        0x8D,      0,
        C_H_M31|C_H_M51|C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M44|C_H_M8344|C_H_M154|C_H_M152A|C_H_M152B|C_H_M80C652|C_H_M83C652|C_H_M51FA
        |C_H_M8351FA|C_H_M552|C_H_M83C552|C_H_M562|C_H_M83C562  ,
        C_L_M31|C_L_M51|C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M44|C_L_M8344|C_L_M154|C_L_M152A|C_L_M152B|C_L_M80C652|C_L_M83C652|C_L_M51FA
        |C_L_M8351FA|C_L_M552|C_L_M83C552|C_L_M562|C_L_M83C562 },
        {(unsigned char*) "AUXR",       0x8E,      0,
         C_H_M51FA|C_H_M8351FA  ,
         C_L_M51FA|C_L_M8351FA },
        {(unsigned char*) "PWCM",       0x8E,      0,
         C_H_M752|C_H_M83C752  ,
         C_L_M752|C_L_M83C752 },
        {(unsigned char*) "PWMP",       0x8F,      0,
         C_H_M752|C_H_M83C752  ,
         C_L_M752|C_L_M83C752 },
        {(unsigned char*) "P1",         0x90,      1,
         C_H_M31|C_H_M51|C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M44|C_H_M8344|C_H_M154|C_H_M152A|C_H_M152B|C_H_M80C652|C_H_M83C652|C_H_M51FA
         |C_H_M8351FA|C_H_M752|C_H_M83C752|C_H_M552|C_H_M83C552|C_H_M562|C_H_M83C562|C_H_M750|C_H_M83C750|C_H_M751|C_H_M83C751  ,
         C_L_M31|C_L_M51|C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M44|C_L_M8344|C_L_M154|C_L_M152A|C_L_M152B|C_L_M80C652|C_L_M83C652|C_L_M51FA
         |C_L_M8351FA|C_L_M752|C_L_M83C752|C_L_M552|C_L_M83C552|C_L_M562|C_L_M83C562|C_L_M750|C_L_M83C750|C_L_M751|C_L_M83C751 },
        {(unsigned char*) "P5",        0x91,      0, C_H_M152B , C_L_M152B },
        {(unsigned char*) "DCON0",     0x92,      0, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char*) "DCON1",     0x93,      0, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char*) "BAUD",      0x94,      0, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char*) "ADR0",      0x95,      0, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char*) "SCON",       0x98,      1,
         C_H_M31|C_H_M51|C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M154|C_H_M152A|C_H_M152B|C_H_M51FA|C_H_M8351FA|C_H_M562|C_H_M83C562  ,
         C_L_M31|C_L_M51|C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M154|C_L_M152A|C_L_M152B|C_L_M51FA|C_L_M8351FA|C_L_M562|C_L_M83C562 },
        {(unsigned char*) "S0CON",      0x98,      1,
         C_H_M80C652|C_H_M83C652|C_H_M552|C_H_M83C552  ,
         C_L_M80C652|C_L_M83C652|C_L_M552|C_L_M83C552 },
        {(unsigned char*) "I2CON",      0x98,      1,
        C_H_M752|C_H_M83C752|C_H_M751|C_H_M83C751  ,
        C_L_M752|C_L_M83C752|C_L_M751|C_L_M83C751 },
        {(unsigned char*) "SBUF",       0x99,      0,
          C_H_M31|C_H_M51|C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M154|C_H_M152A|C_H_M152B|C_H_M51FA|C_H_M8351FA|C_H_M562|C_H_M83C562  ,
          C_L_M31|C_L_M51|C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M154|C_L_M152A|C_L_M152B|C_L_M51FA|C_L_M8351FA|C_L_M562|C_L_M83C562 },
        {(unsigned char*) "S0BUF",      0x99,      0,
         C_H_M80C652|C_H_M83C652|C_H_M552|C_H_M83C552  ,
         C_L_M80C652|C_L_M83C652|C_L_M552|C_L_M83C552 },
        {(unsigned char*) "I2DAT",      0x99,      0,
          C_H_M752|C_H_M83C752|C_H_M751|C_H_M83C751  ,
          C_L_M752|C_L_M83C752|C_L_M751|C_L_M83C751 },
        {(unsigned char*) "P2",         0xA0,      1,
         C_H_M31|C_H_M51|C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M154|C_H_M44|C_H_M8344|C_H_M152A|C_H_M152B|C_H_M80C652|C_H_M83C652|C_H_M51FA
         |C_H_M8351FA|C_H_M552|C_H_M83C552|C_H_M562|C_H_M83C562  ,
         C_L_M31|C_L_M51|C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M154|C_L_M44|C_L_M8344|C_L_M152A|C_L_M152B|C_L_M80C652|C_L_M83C652|C_L_M51FA
         |C_L_M8351FA|C_L_M552|C_L_M83C552|C_L_M562|C_L_M83C562 },
        {(unsigned char*) "ADCON",      0xA0,      1,
         C_H_M752|C_H_M83C752  ,
         C_L_M752|C_L_M83C752 },
        {(unsigned char*) "P6",        0xA1,      0, C_H_M152B , C_L_M152B },
        {(unsigned char*) "SARL0",     0xA2,      0, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char*) "SARH0",     0xA3,      0, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char*) "IFS",       0xA4,      0, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char*) "ADR1",      0xA5,      0, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char*) "WDCON",      0xA5,      0,
          C_H_M528|C_H_M83C528  ,
          C_L_M528|C_L_M83C528 },
        {(unsigned char*) "IEN0",       0xA8,      1,
         C_H_M552|C_H_M83C552 , C_L_M552|C_L_M83C552 },
        {(unsigned char*) "IE",         0xA8,      1,
          C_H_M31|C_H_M51|C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M44|C_H_M8344|C_H_M154|C_H_M152A|C_H_M152B|C_H_M80C652|C_H_M83C652
          |C_H_M51FA|C_H_M8351FA|C_H_M752|C_H_M83C752|C_H_M750|C_H_M83C750|C_H_M751|C_H_M83C751   ,
          C_L_M31|C_L_M51|C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M44|C_L_M8344|C_L_M154|C_L_M152A|C_L_M152B|C_L_M80C652|C_L_M83C652
          |C_L_M51FA|C_L_M8351FA|C_L_M752|C_L_M83C752|C_L_M750|C_L_M83C750|C_L_M751|C_L_M83C751  },
        {(unsigned char*) "CML0",       0xA9,      0,
         C_H_M552|C_H_M83C552 , C_L_M552|C_L_M83C552 },
        {(unsigned char*) "SADDR",      0xA9,      0,
          C_H_M51FA|C_H_M8351FA  ,
          C_L_M51FA|C_L_M8351FA },
        {(unsigned char*) "CML1",       0xAA,      0,
         C_H_M552|C_H_M83C552 , C_L_M552|C_L_M83C552 },
        {(unsigned char*) "CML2",       0xAB,      0,
         C_H_M552|C_H_M83C552 , C_L_M552|C_L_M83C552 },
        {(unsigned char*) "CTL0",       0xAC,      0,
         C_H_M552|C_H_M83C552 , C_L_M552|C_L_M83C552 },
        {(unsigned char*) "CTL1",       0xAD,      0,
         C_H_M552|C_H_M83C552 , C_L_M552|C_L_M83C552 },
        {(unsigned char*) "CTL2",       0xAE,      0,
          C_H_M552|C_H_M83C552 , C_L_M552|C_L_M83C552 },
        {(unsigned char*) "CTL3",       0xAF,      0,
         C_H_M552|C_H_M83C552 , C_L_M552|C_L_M83C552 },


        {(unsigned char*) "P3",         0xB0,      1,
          C_H_M31|C_H_M51|C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M44|C_H_M8344|C_H_M154|C_H_M152A|C_H_M152B|C_H_M80C652|C_H_M83C652|C_H_M51FA
          |C_H_M8351FA|C_H_M752|C_H_M83C752|C_H_M552|C_H_M83C552|C_H_M562|C_H_M83C562|C_H_M750|C_H_M83C750|C_H_M751|C_H_M83C751  ,
          C_L_M31|C_L_M51|C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M44|C_L_M8344|C_L_M154|C_L_M152A|C_L_M152B|C_L_M80C652|C_L_M83C652|C_L_M51FA
          |C_L_M8351FA|C_L_M752|C_L_M83C752|C_L_M552|C_L_M83C552|C_L_M562|C_L_M83C562|C_L_M750|C_L_M83C750|C_L_M751|C_L_M83C751 },
        {(unsigned char*) "SARL1",      0xB2,      0, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char*) "SARH1",      0xB3,      0, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char*) "SLOTTM",     0xB4,      0, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char*) "ADR2",      0xB5,      0, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char*) "IP1",       0xB8,      1,
         C_H_M552|C_H_M83C552 , C_L_M552|C_L_M83C552 },
        {(unsigned char*) "IP",         0xB8,      1,
          C_H_M31|C_H_M51|C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M44|C_H_M8344|C_H_M154|C_H_M152A|C_H_M152B|C_H_M80C652|C_H_M83C652|C_H_M51FA
          |C_H_M8351FA  ,
          C_L_M31|C_L_M51|C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M44|C_L_M8344|C_L_M154|C_L_M152A|C_L_M152B|C_L_M80C652|C_L_M83C652|C_L_M51FA
          |C_L_M8351FA },
        {(unsigned char*) "SADEN",      0xB9,      0,
          C_H_M51FA|C_H_M8351FA  ,
          C_L_M51FA|C_L_M8351FA },
        {(unsigned char*) "P4",         0xC0,      0, C_H_M552|C_H_M83C552 ,C_L_M552|C_L_M83C552 },
        {(unsigned char*) "P4",         0xC0,      1, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char*) "DARL0",      0xC2,      0, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char*) "DARH0",      0xC3,      0, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char*) "P5",       0xC4,      0,
         C_H_M552|C_H_M83C552 , C_L_M552|C_L_M83C552 },
        {(unsigned char*) "BKOFF",      0xC4,      0, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char*) "ADCON",       0xC5,      0,
         C_H_M552|C_H_M83C552 , C_L_M552|C_L_M83C552 },
        {(unsigned char*) "ADR3",       0xC5,      0, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char*) "ADCH",       0xC6,      0,
         C_H_M552|C_H_M83C552 , C_L_M552|C_L_M83C552 },
        {(unsigned char*) "TM2IR",       0xC8,      0,
         C_H_M552|C_H_M83C552 , C_L_M552|C_L_M83C552 },
        {(unsigned char*) "IEN1",       0xC8,      1, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char*) "T2CON",      0xC8,      1,
            C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M154|C_H_M51FA|C_H_M8351FA  ,
            C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M154|C_L_M51FA|C_L_M8351FA },
        {(unsigned char*) "STS",        0xC8,      1,
         C_H_M44|C_H_M8344  ,
         C_L_M44|C_L_M8344 },
        {(unsigned char*) "CMH0",       0xC9,      0,
         C_H_M552|C_H_M83C552 , C_L_M552|C_L_M83C552 },
        {(unsigned char*) "SMD",        0xC9,      0,
        C_H_M44|C_H_M8344  ,
        C_L_M44|C_L_M8344 },
        {(unsigned char*) "T2MOD",      0xC9,      0,
        C_H_M51FA|C_H_M8351FA  ,
        C_L_M51FA|C_L_M8351FA },
        {(unsigned char*) "CMH1",       0xCA,      0,
         C_H_M552|C_H_M83C552 , C_L_M552|C_L_M83C552 },
        {(unsigned char*) "RACAP2L",       0xCA,      0,
         C_H_M51FA|C_H_M8351FA  ,
         C_L_M51FA|C_L_M8351FA },
        {(unsigned char*) "RCAP2L",     0xCA,      0,
        C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M154  ,
        C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M154 },
        {(unsigned char* )"RCB",        0xCA,      0,
        C_H_M44|C_H_M8344  ,
        C_L_M44|C_L_M8344 },
        {(unsigned char* )"RACAP2L",    0xCA,      0,
        C_H_M51FA|C_H_M8351FA  ,
        C_L_M51FA|C_L_M8351FA },
        {(unsigned char*) "CMH2",       0xCB,      0,
         C_H_M552|C_H_M83C552 , C_L_M552|C_L_M83C552 },
        {(unsigned char*) "RACAP2H",       0xCB,      0,
         C_H_M51FA|C_H_M8351FA  ,
         C_L_M51FA|C_L_M8351FA },
        {(unsigned char* )"RCAP2H",     0xCB,      0,
        C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M154  ,
        C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M154 },
        {(unsigned char* )"RBL",        0xCB,      0,
        C_H_M44|C_H_M8344  ,
        C_L_M44|C_L_M8344 },
        {(unsigned char* )"RACAP2H",    0xCB,      0,
        C_H_M51FA|C_H_M8351FA  ,
        C_L_M51FA|C_L_M8351FA },
        {(unsigned char*) "CTH0",       0xCC,      0,
         C_H_M552|C_H_M83C552 , C_L_M552|C_L_M83C552 },
        {(unsigned char* )"TL2",        0xCC,      0,
        C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M154|C_H_M51FA|C_H_M8351FA  ,
        C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M154|C_L_M51FA|C_L_M8351FA },
        {(unsigned char* )"RBS",        0xCC,      0,
        C_H_M44|C_H_M8344  ,
        C_L_M44|C_L_M8344 },
        {(unsigned char*) "CTH1",       0xCD,      0,
         C_H_M552|C_H_M83C552 , C_L_M552|C_L_M83C552 },
        {(unsigned char* )"TH2",        0xCD,      0,
        C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M154|C_H_M51FA|C_H_M8351FA  ,
        C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M154|C_L_M51FA|C_L_M8351FA },
        {(unsigned char* )"RFL",        0xCD,      0,
         C_H_M44|C_H_M8344  ,
         C_L_M44|C_L_M8344 },
        {(unsigned char*) "CTH2",       0xCE,      0,
         C_H_M552|C_H_M83C552 , C_L_M552|C_L_M83C552 },
        {(unsigned char* )"STAD",       0xCE,      0,
         C_H_M44|C_H_M8344  ,
         C_L_M44|C_L_M8344 },
        {(unsigned char*) "CTH3",       0xCF,      0,
         C_H_M552|C_H_M83C552 , C_L_M552|C_L_M83C552 },
        {(unsigned char* )"DMACNT",     0xCF,      0,
         C_H_M44|C_H_M8344  ,
         C_L_M44|C_L_M8344 },
        {(unsigned char* )"PSW",        0xD0,      1,
         C_H_M31|C_H_M51|C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M44|C_H_M8344|C_H_M154|C_H_M152A|C_H_M152B|C_H_M80C652|C_H_M83C652|C_H_M51FA
         |C_H_M8351FA|C_H_M752|C_H_M83C752|C_H_M552|C_H_M83C552|C_H_M562|C_H_M83C562|C_H_M750|C_H_M83C750|C_H_M751|C_H_M83C751  ,
         C_L_M31|C_L_M51|C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M44|C_L_M8344|C_L_M154|C_L_M152A|C_L_M152B|C_L_M80C652|C_L_M83C652|C_L_M51FA
         |C_L_M8351FA|C_L_M752|C_L_M83C752|C_L_M552|C_L_M83C552|C_L_M562|C_L_M83C562|C_L_M750|C_L_M83C750|C_L_M751|C_L_M83C751 },
        {(unsigned char*) "DARL1",      0xD2,      0, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char*) "DARH1",      0xD3,      0, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char*) "TCDCNT",     0xD4,      0, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char*) "AMSK0",      0xD5,      0, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char*) "TSTAT",      0xD8,      1, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char* )"NSNR",       0xD8,      1,
        C_H_M44|C_H_M8344  ,
        C_L_M44|C_L_M8344 },
        {(unsigned char* )"S1CON",      0xD8,      1,
        C_H_M80C652|C_H_M83C652|C_H_M552|C_H_M83C552  ,
        C_L_M80C652|C_L_M83C652|C_L_M552|C_L_M83C552 },
        {(unsigned char* )"S1SCS",      0xD8,      1,
        C_H_M528|C_H_M83C528  ,
        C_L_M528|C_L_M83C528 },
        {(unsigned char* )"CCON",       0xD8,      1,
        C_H_M51FA|C_H_M8351FA  ,
        C_L_M51FA|C_L_M8351FA },
        {(unsigned char* )"I2CFG",      0xD8,      1,
         C_H_M752|C_H_M83C752|C_H_M751|C_H_M83C751  ,
         C_L_M752|C_L_M83C752|C_L_M751|C_L_M83C751 },
        {(unsigned char* )"SIUST",      0xD9,      0,
         C_H_M44|C_H_M8344  ,
         C_L_M44|C_L_M8344 },
        {(unsigned char* )"S1STA",      0xD9,      0,
        C_H_M80C652|C_H_M83C652|C_H_M552|C_H_M83C552  ,
        C_L_M80C652|C_L_M83C652|C_L_M552|C_L_M83C552 },
        {(unsigned char* )"CMOD",       0xD9,      0,
        C_H_M51FA|C_H_M8351FA  ,
        C_L_M51FA|C_L_M8351FA },
        {(unsigned char* )"S1BIT",      0xD9,      0,
         C_H_M528|C_H_M83C528  ,
         C_L_M528|C_L_M83C528 },
        {(unsigned char* )"TCB",        0xDA,      0,
        C_H_M44|C_H_M8344  ,
        C_L_M44|C_L_M8344 },
        {(unsigned char* )"S1DAT",      0xDA,      0,
        C_H_M80C652|C_H_M83C652|C_H_M552|C_H_M83C552  ,
        C_L_M80C652|C_L_M83C652|C_L_M552|C_L_M83C552 },
        {(unsigned char* )"S1INT",      0xDA,      0,
         C_H_M528|C_H_M83C528  ,
         C_L_M528|C_L_M83C528 },
        {(unsigned char* )"CCAPM0",     0xDA,      0,
         C_H_M51FA|C_H_M8351FA  ,
         C_L_M51FA|C_L_M8351FA },
        {(unsigned char* )"TBL",        0xDB,      0,
         C_H_M44|C_H_M8344  ,
         C_L_M44|C_L_M8344 },
        {(unsigned char* )"S1ADR",      0xDB,      0,
        C_H_M80C652|C_H_M83C652|C_H_M552|C_H_M83C552  ,
        C_L_M80C652|C_L_M83C652|C_L_M552|C_L_M83C552 },
        {(unsigned char* )"CCAPM1",     0xDB,      0,
        C_H_M51FA|C_H_M8351FA  ,
        C_L_M51FA|C_L_M8351FA },
        {(unsigned char* )"TBS",        0xDC,      0,
         C_H_M44|C_H_M8344  ,
         C_L_M44|C_L_M8344 },
        {(unsigned char* )"CCAPM2",     0xDC,      0,
         C_H_M51FA|C_H_M8351FA  ,
         C_L_M51FA|C_L_M8351FA },
        {(unsigned char* )"FIFOL",      0xDD,      0,
        C_H_M44|C_H_M8344  ,
        C_L_M44|C_L_M8344 },
        {(unsigned char* )"CCAPM3",     0xDD,      0,
         C_H_M51FA|C_H_M8351FA  ,
         C_L_M51FA|C_L_M8351FA },
        {(unsigned char* )"FIFOM",      0xDE,      0,
         C_H_M44|C_H_M8344  ,
         C_L_M44|C_L_M8344 },
        {(unsigned char* )"CCAPM4",     0xDE,      0,
         C_H_M51FA|C_H_M8351FA  ,
         C_L_M51FA|C_L_M8351FA },
        {(unsigned char* )"FIFOH",      0xDF,      0,
        C_H_M44|C_H_M8344  ,
        C_L_M44|C_L_M8344 },
        {(unsigned char* )"A",          0xE0,      1,
         C_H_M31|C_H_M51|C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M44|C_H_M8344|C_H_M154|C_H_M152A|C_H_M152B|C_H_M80C652|C_H_M83C652|C_H_M51FA
         |C_H_M8351FA|C_H_M752|C_H_M83C752|C_H_M552|C_H_M83C552|C_H_M562|C_H_M83C562|C_H_M750|C_H_M83C750|C_H_M751|C_H_M83C751  ,
         C_L_M31|C_L_M51|C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M44|C_L_M8344|C_L_M154|C_L_M152A|C_L_M152B|C_L_M80C652|C_L_M83C652|C_L_M51FA
         |C_L_M8351FA|C_L_M752|C_L_M83C752|C_L_M552|C_L_M83C552|C_L_M562|C_L_M83C562|C_L_M750|C_L_M83C750|C_L_M751|C_L_M83C751 },
        {(unsigned char* )"ACC",          0xE0,      1,
         C_H_M31|C_H_M51|C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M44|C_H_M8344|C_H_M154|C_H_M152A|C_H_M152B|C_H_M80C652|C_H_M83C652|C_H_M51FA
         |C_H_M8351FA|C_H_M752|C_H_M83C752|C_H_M552|C_H_M83C552|C_H_M562|C_H_M83C562|C_H_M750|C_H_M83C750|C_H_M751|C_H_M83C751  ,
         C_L_M31|C_L_M51|C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M44|C_L_M8344|C_L_M154|C_L_M152A|C_L_M152B|C_L_M80C652|C_L_M83C652|C_L_M51FA
         |C_L_M8351FA|C_L_M752|C_L_M83C752|C_L_M552|C_L_M83C552|C_L_M562|C_L_M83C562|C_L_M750|C_L_M83C750|C_L_M751|C_L_M83C751 },
        {(unsigned char*) "BCRL0",      0xE2,      0, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char*) "BCRH0",      0xE3,      0, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char*) "PRBS",       0xE4,      0, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char*) "AMSK1",      0xE5,      0, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char*) "IEN1",       0xE8,      1,
         C_H_M552|C_H_M83C552 , C_L_M552|C_L_M83C552 },
        {(unsigned char*) "RSTAT",      0xE8,      1, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char* )"CL",         0xE9,      0,
        C_H_M51FA|C_H_M8351FA  ,
        C_L_M51FA|C_L_M8351FA },
        {(unsigned char*) "TM2CON",       0xEA,      0,
         C_H_M552|C_H_M83C552 , C_L_M552|C_L_M83C552 },
        {(unsigned char* )"CCAP0L",     0xEA,      0,
        C_H_M51FA|C_H_M8351FA  ,
        C_L_M51FA|C_L_M8351FA },
        {(unsigned char*) "CML1",       0xAA,      0,
         C_H_M552|C_H_M83C552 , C_L_M552|C_L_M83C552 },
        {(unsigned char* )"CCAP1L",     0xEB,      0,
        C_H_M51FA|C_H_M8351FA  ,
        C_L_M51FA|C_L_M8351FA },
        {(unsigned char* )"CTCON",     0xEB,      0,
        C_H_M552|C_H_M83C552 , C_L_M552|C_L_M83C552 },
        {(unsigned char*) "TML2",       0xEC,      0,
         C_H_M552|C_H_M83C552 , C_L_M552|C_L_M83C552 },
        {(unsigned char* )"CCAP2L",     0xEC,      0,
         C_H_M51FA|C_H_M8351FA  ,
         C_L_M51FA|C_L_M8351FA },
        {(unsigned char*) "TMH2",       0xED,      0,
         C_H_M552|C_H_M83C552 , C_L_M552|C_L_M83C552 },
        {(unsigned char* )"CCAP3L",     0xED,      0,
         C_H_M51FA|C_H_M8351FA  ,
         C_L_M51FA|C_L_M8351FA },
        {(unsigned char*) "STE",       0xEE,      0,
         C_H_M552|C_H_M83C552 , C_L_M552|C_L_M83C552 },
        {(unsigned char* )"CCAP4L",     0xEE,      0,
         C_H_M51FA|C_H_M8351FA  ,
         C_L_M51FA|C_L_M8351FA },
        {(unsigned char*) "RTE",       0xEF,      0,
         C_H_M552|C_H_M83C552 , C_L_M552|C_L_M83C552 },
        {(unsigned char* )"PWENA",      0xFE,      0,
         C_H_M752|C_H_M83C752  ,
         C_L_M752|C_L_M83C752 },
        {(unsigned char* )"B",          0xF0,      1,
        C_H_M31|C_H_M51|C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M44|C_H_M8344|C_H_M154|C_H_M152A|C_H_M152B|C_H_M80C652|C_H_M83C652|C_H_M51FA
        |C_H_M8351FA|C_H_M752|C_H_M83C752|C_H_M552|C_H_M83C552|C_H_M562|C_H_M83C562|C_H_M750|C_H_M83C750|C_H_M751|C_H_M83C751  ,
        C_L_M31|C_L_M51|C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M44|C_L_M8344|C_L_M154|C_L_M152A|C_L_M152B|C_L_M80C652|C_L_M83C652|C_L_M51FA
        |C_L_M8351FA|C_L_M752|C_L_M83C752|C_L_M552|C_L_M83C552|C_L_M562|C_L_M83C562|C_L_M750|C_L_M83C750|C_L_M751|C_L_M83C751 },
        {(unsigned char*) "BCRL1",      0xF2,      0, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char*) "BCRH1",      0xF3,      0, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char*) "RFIFO",      0xF4,      0, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char*) "MYSLOT",     0xF5,      0, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char*) "IP0",       0xF8,      1,
         C_H_M552|C_H_M83C552 , C_L_M552|C_L_M83C552 },
        {(unsigned char*) "IPN1",       0xF8,      1, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char* )"IOCON",      0xF8,      1,
         C_H_M154  ,
         C_L_M154 },
        {(unsigned char* )"I2STA",      0xF8,      1,
         C_H_M752|C_H_M83C752|C_H_M751|C_H_M83C751  ,
         C_L_M752|C_L_M83C752|C_L_M751|C_L_M83C751 },
        {(unsigned char* )"CH",         0xF9,      0,
         C_H_M51FA|C_H_M8351FA  ,
         C_L_M51FA|C_L_M8351FA },
        {(unsigned char* )"CCAP0H",     0xFA,      0,
         C_H_M51FA|C_H_M8351FA  ,
         C_L_M51FA|C_L_M8351FA },
        {(unsigned char* )"CCAP1H",     0xFB,      0,
         C_H_M51FA|C_H_M8351FA  ,
         C_L_M51FA|C_L_M8351FA },
        {(unsigned char*) "PWM0",       0xFC,      0,
         C_H_M552|C_H_M83C552 , C_L_M552|C_L_M83C552 },
        {(unsigned char* )"CCAP2H",     0xFC,      0,
         C_H_M51FA|C_H_M8351FA  ,
         C_L_M51FA|C_L_M8351FA },
        {(unsigned char*) "PWM1",       0xFD,      0,
         C_H_M552|C_H_M83C552 , C_L_M552|C_L_M83C552 },
        {(unsigned char* )"CCAP3H",     0xFD,      0,
         C_H_M51FA|C_H_M8351FA  ,
         C_L_M51FA|C_L_M8351FA },
        {(unsigned char*) "PWMP",       0xFE,      0,
         C_H_M552|C_H_M83C552 , C_L_M552|C_L_M83C552 },
        {(unsigned char* )"CCAP4H",     0xFE,      0,
         C_H_M51FA|C_H_M8351FA  ,
         C_L_M51FA|C_L_M8351FA },
        {(unsigned char* )"T3",         0xFF,      0,
         C_H_M528|C_H_M83C528|C_H_M552|C_H_M83C552|C_H_M562|C_H_M83C562  ,
         C_L_M528|C_L_M83C528|C_L_M552|C_L_M83C552|C_L_M562|C_L_M83C562 },
        {(unsigned char* )""  ,         0x00,      0,           0x00  } }; /* End of the table */

        /* SFR Bit Table): must sort by Addr-Base */
 SFRNAME SFRbit[]={
        /*                 Bit-Name    Addr-Base   SfrAttr     CPUmode */
        {(unsigned char* ) "IT0",       0x88,       0,
        C_H_M31|C_H_M51|C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M44|C_H_M8344|C_H_M154|C_H_M152A|C_H_M152B|C_H_M80C652|C_H_M83C652|C_H_M51FA
        |C_H_M8351FA|C_H_M552|C_H_M83C552|C_H_M562|C_H_M83C562  ,
        C_L_M31|C_L_M51|C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M44|C_L_M8344|C_L_M154|C_L_M152A|C_L_M152B|C_L_M80C652|C_L_M83C652|C_L_M51FA
        |C_L_M8351FA|C_L_M552|C_L_M83C552|C_L_M562|C_L_M83C562 },
        {(unsigned char* ) "IT1",       0x88,       0,
        C_H_M752|C_H_M83C752|C_H_M750|C_H_M83C750|C_H_M751|C_H_M83C751  ,
        C_L_M752|C_L_M83C752|C_L_M750|C_L_M83C750|C_L_M751|C_L_M83C751 },
        {(unsigned char* ) "IE0",       0x89,       0,
         C_H_M31|C_H_M51|C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M44|C_H_M8344|C_H_M154|C_H_M152A|C_H_M152B|C_H_M80C652|C_H_M83C652|C_H_M51FA
         |C_H_M8351FA|C_H_M552|C_H_M83C552|C_H_M562|C_H_M83C562  ,
         C_L_M31|C_L_M51|C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M44|C_L_M8344|C_L_M154|C_L_M152A|C_L_M152B|C_L_M80C652|C_L_M83C652|C_L_M51FA
         |C_L_M8351FA|C_L_M552|C_L_M83C552|C_L_M562|C_L_M83C562 },
        {(unsigned char* ) "IE1",       0x89,       0,
        C_H_M752|C_H_M83C752|C_H_M750|C_H_M83C750|C_H_M751|C_H_M83C751  ,
        C_L_M752|C_L_M83C752|C_L_M750|C_L_M83C750|C_L_M751|C_L_M83C751 },
        {(unsigned char* ) "IT1",       0x8A,       0,
         C_H_M31|C_H_M51|C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M44|C_H_M8344|C_H_M154|C_H_M152A|C_H_M152B|C_H_M80C652|C_H_M83C652|C_H_M51FA
         |C_H_M8351FA|C_H_M552|C_H_M83C552|C_H_M562|C_H_M83C562  ,
         C_L_M31|C_L_M51|C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M44|C_L_M8344|C_L_M154|C_L_M152A|C_L_M152B|C_L_M80C652|C_L_M83C652|C_L_M51FA
         |C_L_M8351FA|C_L_M552|C_L_M83C552|C_L_M562|C_L_M83C562 },
        {(unsigned char* ) "IT0",       0x8A,       0,
        C_H_M752|C_H_M83C752|C_H_M750|C_H_M83C750|C_H_M751|C_H_M83C751  ,
        C_L_M752|C_L_M83C752|C_L_M750|C_L_M83C750|C_L_M751|C_L_M83C751 },
        {(unsigned char* ) "IE1",       0x8B,       0,
        C_H_M31|C_H_M51|C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M44|C_H_M8344|C_H_M154|C_H_M152A|C_H_M152B|C_H_M80C652|C_H_M83C652|C_H_M51FA
        |C_H_M8351FA|C_H_M552|C_H_M83C552|C_H_M562|C_H_M83C562  ,
        C_L_M31|C_L_M51|C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M44|C_L_M8344|C_L_M154|C_L_M152A|C_L_M152B|C_L_M80C652|C_L_M83C652|C_L_M51FA
        |C_L_M8351FA|C_L_M552|C_L_M83C552|C_L_M562|C_L_M83C562 },
        {(unsigned char* ) "IE0",       0x8B,       0,
        C_H_M752|C_H_M83C752|C_H_M750|C_H_M83C750|C_H_M751|C_H_M83C751  ,
        C_L_M752|C_L_M83C752|C_L_M750|C_L_M83C750|C_L_M751|C_L_M83C751 },
        {(unsigned char* ) "TR0",       0x8C,       0,
        C_H_M31|C_H_M51|C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M44|C_H_M8344|C_H_M154|C_H_M152A|C_H_M152B|C_H_M80C652|C_H_M83C652|C_H_M51FA
        |C_H_M8351FA|C_H_M552|C_H_M83C552|C_H_M562|C_H_M83C562  ,
        C_L_M31|C_L_M51|C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M44|C_L_M8344|C_L_M154|C_L_M152A|C_L_M152B|C_L_M80C652|C_L_M83C652|C_L_M51FA
        |C_L_M8351FA|C_L_M552|C_L_M83C552|C_L_M562|C_L_M83C562 },
        {(unsigned char* ) "TR",        0x8C,       0,
        C_H_M752|C_H_M83C752|C_H_M750|C_H_M83C750|C_H_M751|C_H_M83C751  ,
        C_L_M752|C_L_M83C752|C_L_M750|C_L_M83C750|C_L_M751|C_L_M83C751 },
        {(unsigned char* ) "TF0",       0x8D,       0,
        C_H_M31|C_H_M51|C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M44|C_H_M8344|C_H_M154|C_H_M152A|C_H_M152B|C_H_M80C652|C_H_M83C652|C_H_M51FA
        |C_H_M8351FA|C_H_M552|C_H_M83C552|C_H_M562|C_H_M83C562  ,
        C_L_M31|C_L_M51|C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M44|C_L_M8344|C_L_M154|C_L_M152A|C_L_M152B|C_L_M80C652|C_L_M83C652|C_L_M51FA
        |C_L_M8351FA|C_L_M552|C_L_M83C552|C_L_M562|C_L_M83C562 },
        {(unsigned char* ) "TF",        0x8D,       0,
        C_H_M752|C_H_M83C752|C_H_M750|C_H_M83C750|C_H_M751|C_H_M83C751  ,
        C_L_M752|C_L_M83C752|C_L_M750|C_L_M83C750|C_L_M751|C_L_M83C751 },
        {(unsigned char* ) "TR1",       0x8E,       0,
        C_H_M31|C_H_M51|C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M44|C_H_M8344|C_H_M154|C_H_M152A|C_H_M152B|C_H_M80C652|C_H_M83C652|C_H_M51FA
        |C_H_M8351FA|C_H_M552|C_H_M83C552|C_H_M562|C_H_M83C562  ,
        C_L_M31|C_L_M51|C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M44|C_L_M8344|C_L_M154|C_L_M152A|C_L_M152B|C_L_M80C652|C_L_M83C652|C_L_M51FA
        |C_L_M8351FA|C_L_M552|C_L_M83C552|C_L_M562|C_L_M83C562 },
        {(unsigned char* ) "C/T",       0x8E,       0,
        C_H_M752|C_H_M83C752|C_H_M750|C_H_M83C750|C_H_M751|C_H_M83C751  ,
        C_L_M752|C_L_M83C752|C_L_M750|C_L_M83C750|C_L_M751|C_L_M83C751 },
        {(unsigned char* ) "TF1",       0x8F,       0,
        C_H_M31|C_H_M51|C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M44|C_H_M8344|C_H_M154|C_H_M152A|C_H_M152B|C_H_M80C652|C_H_M83C652|C_H_M51FA
        |C_H_M8351FA|C_H_M552|C_H_M83C552|C_H_M562|C_H_M83C562  ,
        C_L_M31|C_L_M51|C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M44|C_L_M8344|C_L_M154|C_L_M152A|C_L_M152B|C_L_M80C652|C_L_M83C652|C_L_M51FA
        |C_L_M8351FA|C_L_M552|C_L_M83C552|C_L_M562|C_L_M83C562 },
        {(unsigned char* ) "GATE",      0x8F,       0,
        C_H_M752|C_H_M83C752|C_H_M750|C_H_M83C750|C_H_M751|C_H_M83C751  ,
        C_L_M752|C_L_M83C752|C_L_M750|C_L_M83C750|C_L_M751|C_L_M83C751 },
        {(unsigned char* ) "GRXD",      0x90,       0,
        C_H_M152A|C_H_M152B  ,
        C_L_M152A|C_L_M152B },
        {(unsigned char* ) "GTXD",      0x91,       0,
        C_H_M152A|C_H_M152B  ,
        C_L_M152A|C_L_M152B },
        {(unsigned char* ) "DEN",       0x92,       0,
        C_H_M152A|C_H_M152B  ,
        C_L_M152A|C_L_M152B },
        {(unsigned char* ) "TXC",       0x93,       0,
        C_H_M152A|C_H_M152B  ,
        C_L_M152A|C_L_M152B },
        {(unsigned char* ) "RXC",       0x94,       0,
        C_H_M152A|C_H_M152B  ,
        C_L_M152A|C_L_M152B },
        {(unsigned char* ) "HLD",       0x95,       0,
        C_H_M152A|C_H_M152B  ,
        C_L_M152A|C_L_M152B },
        {(unsigned char* ) "HLDA",      0x96,       0,
        C_H_M152A|C_H_M152B  ,
        C_L_M152A|C_L_M152B },
        {(unsigned char* ) "RI",        0x98,       0,
        C_H_M31|C_H_M51|C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M154|C_H_M152A|C_H_M152B|C_H_M80C652|C_H_M83C652|C_H_M51FA|C_H_M8351FA
        |C_H_M552|C_H_M83C552|C_H_M562|C_H_M83C562  ,
        C_L_M31|C_L_M51|C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M154|C_L_M152A|C_L_M152B|C_L_M80C652|C_L_M83C652|C_L_M51FA|C_L_M8351FA
        |C_L_M552|C_L_M83C552|C_L_M562|C_L_M83C562 },
        {(unsigned char* ) "TI",        0x99,       0,
         C_H_M31|C_H_M51|C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M154|C_H_M152A|C_H_M152B|C_H_M80C652|C_H_M83C652|C_H_M51FA|C_H_M8351FA
         |C_H_M552|C_H_M83C552|C_H_M562|C_H_M83C562  ,
         C_L_M31|C_L_M51|C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M154|C_L_M152A|C_L_M152B|C_L_M80C652|C_L_M83C652|C_L_M51FA|C_L_M8351FA
         |C_L_M552|C_L_M83C552|C_L_M562|C_L_M83C562 },
        {(unsigned char* ) "MASTER",    0x99,       0,
        C_H_M752|C_H_M83C752|C_H_M751|C_H_M83C751  ,
        C_L_M752|C_L_M83C752|C_L_M751|C_L_M83C751 },
        {(unsigned char* ) "RB8",       0x9A,       0,
        C_H_M31|C_H_M51|C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M154|C_H_M152A|C_H_M152B|C_H_M80C652|C_H_M83C652|C_H_M51FA|C_H_M8351FA
        |C_H_M552|C_H_M83C552|C_H_M562|C_H_M83C562  ,
        C_L_M31|C_L_M51|C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M154|C_L_M152A|C_L_M152B|C_L_M80C652|C_L_M83C652|C_L_M51FA|C_L_M8351FA
        |C_L_M552|C_L_M83C552|C_L_M562|C_L_M83C562 },
        {(unsigned char* ) "STP",       0x9A,       0,
        C_H_M752|C_H_M83C752|C_H_M751|C_H_M83C751  ,
        C_L_M752|C_L_M83C752|C_L_M751|C_L_M83C751 },
        {(unsigned char* ) "TB8",       0x9B,       0,
         C_H_M31|C_H_M51|C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M154|C_H_M152A|C_H_M152B|C_H_M80C652|C_H_M83C652|C_H_M51FA|C_H_M8351FA
         |C_H_M552|C_H_M83C552|C_H_M562|C_H_M83C562  ,
         C_L_M31|C_L_M51|C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M154|C_L_M152A|C_L_M152B|C_L_M80C652|C_L_M83C652|C_L_M51FA|C_L_M8351FA
         |C_L_M552|C_L_M83C552|C_L_M562|C_L_M83C562 },
        {(unsigned char* ) "STR",       0x9B,       0,
        C_H_M752|C_H_M83C752|C_H_M751|C_H_M83C751  ,
        C_L_M752|C_L_M83C752|C_L_M751|C_L_M83C751 },
        {(unsigned char* ) "REN",       0x9C,       0,
        C_H_M31|C_H_M51|C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M154|C_H_M152A|C_H_M152B|C_H_M80C652|C_H_M83C652|C_H_M51FA|C_H_M8351FA
        |C_H_M552|C_H_M83C552|C_H_M562|C_H_M83C562  ,
        C_L_M31|C_L_M51|C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M154|C_L_M152A|C_L_M152B|C_L_M80C652|C_L_M83C652|C_L_M51FA|C_L_M8351FA
        |C_L_M552|C_L_M83C552|C_L_M562|C_L_M83C562 },
        {(unsigned char* ) "ARL",       0x9C,       0,
        C_H_M752|C_H_M83C752|C_H_M751|C_H_M83C751  ,
        C_L_M752|C_L_M83C752|C_L_M751|C_L_M83C751 },
        {(unsigned char* ) "SM2",       0x9D,       0,
         C_H_M31|C_H_M51|C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M154|C_H_M152A|C_H_M152B|C_H_M80C652|C_H_M83C652|C_H_M51FA|C_H_M8351FA
         |C_H_M552|C_H_M83C552|C_H_M562|C_H_M83C562  ,
         C_L_M31|C_L_M51|C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M154|C_L_M152A|C_L_M152B|C_L_M80C652|C_L_M83C652|C_L_M51FA|C_L_M8351FA
         |C_L_M552|C_L_M83C552|C_L_M562|C_L_M83C562 },
        {(unsigned char* ) "DRDY",      0x9D,       0,
        C_H_M752|C_H_M83C752|C_H_M751|C_H_M83C751  ,
        C_L_M752|C_L_M83C752|C_L_M751|C_L_M83C751 },
        {(unsigned char* ) "SM1",       0x9E,       0,
        C_H_M31|C_H_M51|C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M154|C_H_M152A|C_H_M152B|C_H_M80C652|C_H_M83C652|C_H_M51FA|C_H_M8351FA
        |C_H_M552|C_H_M83C552|C_H_M562|C_H_M83C562  ,
        C_L_M31|C_L_M51|C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M154|C_L_M152A|C_L_M152B|C_L_M80C652|C_L_M83C652|C_L_M51FA|C_L_M8351FA
        |C_L_M552|C_L_M83C552|C_L_M562|C_L_M83C562 },
        {(unsigned char* ) "ATN",       0x9E,       0,
        C_H_M752|C_H_M83C752|C_H_M751|C_H_M83C751  ,
        C_L_M752|C_L_M83C752|C_L_M751|C_L_M83C751 },
        {(unsigned char* ) "SM0",       0x9F,       0,
        C_H_M31|C_H_M51|C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M154|C_H_M152A|C_H_M152B|C_H_M80C652|C_H_M83C652|C_H_M51FA|C_H_M8351FA
        |C_H_M552|C_H_M83C552|C_H_M562|C_H_M83C562  ,
        C_L_M31|C_L_M51|C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M154|C_L_M152A|C_L_M152B|C_L_M80C652|C_L_M83C652|C_L_M51FA|C_L_M8351FA
        |C_L_M552|C_L_M83C552|C_L_M562|C_L_M83C562 },
        {(unsigned char* ) "RDAT",      0x9F,       0,
        C_H_M752|C_H_M83C752|C_H_M751|C_H_M83C751  ,
        C_L_M752|C_L_M83C752|C_L_M751|C_L_M83C751 },
        {(unsigned char*) "AADR0",        0xA0,      0,
         C_H_M752|C_H_M83C752 ,C_L_M752|C_L_M83C752 },
        {(unsigned char*) "AADR1",        0xA1,      0,
         C_H_M752|C_H_M83C752 ,C_L_M752|C_L_M83C752 },
        {(unsigned char*) "AADR2",        0xA2,      0,
         C_H_M752|C_H_M83C752 ,C_L_M752|C_L_M83C752 },
        {(unsigned char*) "ADCS",        0xA3,      0,
         C_H_M752|C_H_M83C752 ,C_L_M752|C_L_M83C752 },
        {(unsigned char*) "ADCI",        0xA4,      0,
         C_H_M752|C_H_M83C752 ,C_L_M752|C_L_M83C752 },
        {(unsigned char*) "ENADC",        0xA5,      0,
         C_H_M752|C_H_M83C752 ,C_L_M752|C_L_M83C752 },
        {(unsigned char* ) "EX0",       0xA8,       0,
         C_H_M31|C_H_M51|C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M44|C_H_M8344|C_H_M154|C_H_M152A|C_H_M152B|C_H_M80C652|C_H_M83C652
         |C_H_M51FA|C_H_M8351FA|C_H_M752|C_H_M83C752|C_H_M552|C_H_M83C552|C_H_M562|C_H_M83C562|C_H_M750|C_H_M83C750|C_H_M751
         |C_H_M83C751  ,
         C_L_M31|C_L_M51|C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M44|C_L_M8344|C_L_M154|C_L_M152A|C_L_M152B|C_L_M80C652|C_L_M83C652
         |C_L_M51FA|C_L_M8351FA|C_L_M752|C_L_M83C752|C_L_M552|C_L_M83C552|C_L_M562|C_L_M83C562|C_L_M750|C_L_M83C750|C_L_M751
         |C_L_M83C751 },
        {(unsigned char* ) "ET0",       0xA9,       0,
         C_H_M31|C_H_M51|C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M44|C_H_M8344|C_H_M154|C_H_M152A|C_H_M152B|C_H_M80C652|C_H_M83C652
         |C_H_M51FA|C_H_M8351FA|C_H_M752|C_H_M83C752|C_H_M552|C_H_M83C552|C_H_M562|C_H_M83C562|C_H_M750|C_H_M83C750|C_H_M751
         |C_H_M83C751   ,
         C_L_M31|C_L_M51|C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M44|C_L_M8344|C_L_M154|C_L_M152A|C_L_M152B|C_L_M80C652|C_L_M83C652
         |C_L_M51FA|C_L_M8351FA|C_L_M752|C_L_M83C752|C_L_M552|C_L_M83C552|C_L_M562|C_L_M83C562|C_L_M750|C_L_M83C750|C_L_M751
         |C_L_M83C751  },
        {(unsigned char* ) "EX1",       0xAA,       0,
        C_H_M31|C_H_M51|C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M44|C_H_M8344|C_H_M154|C_H_M152A|C_H_M152B|C_H_M80C652|C_H_M83C652
        |C_H_M51FA|C_H_M8351FA|C_H_M752|C_H_M83C752|C_H_M552|C_H_M83C552|C_H_M562|C_H_M83C562|C_H_M750|C_H_M83C750|C_H_M751
        |C_H_M83C751   ,
        C_L_M31|C_L_M51|C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M44|C_L_M8344|C_L_M154|C_L_M152A|C_L_M152B|C_L_M80C652|C_L_M83C652
        |C_L_M51FA|C_L_M8351FA|C_L_M752|C_L_M83C752|C_L_M552|C_L_M83C552|C_L_M562|C_L_M83C562|C_L_M750|C_L_M83C750|C_L_M751
        |C_L_M83C751  },
        {(unsigned char* ) "ET1",       0xAB,       0,
        C_H_M31|C_H_M51|C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M44|C_H_M8344|C_H_M154|C_H_M152A|C_H_M152B|C_H_M80C652|C_H_M83C652
        |C_H_M51FA|C_H_M8351FA|C_H_M552|C_H_M83C552|C_H_M562|C_H_M83C562  ,
        C_L_M31|C_L_M51|C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M44|C_L_M8344|C_L_M154|C_L_M152A|C_L_M152B|C_L_M80C652|C_L_M83C652
        |C_L_M51FA|C_L_M8351FA|C_L_M552|C_L_M83C552|C_L_M562|C_L_M83C562 },
        {(unsigned char* ) "EPWM",      0xAB,       0,
        C_H_M752|C_H_M83C752  ,
        C_L_M752|C_L_M83C752 },
        {(unsigned char* ) "ES",        0xAC,       0,
        C_H_M31|C_H_M51|C_H_M32|C_H_M52|C_H_M44|C_H_M8344|C_H_M154|C_H_M152A|C_H_M152B|C_H_M51FA|C_H_M8351FA|C_H_M752|C_H_M83C752|C_H_M562
        |C_H_M83C562  ,
        C_L_M31|C_L_M51|C_L_M32|C_L_M52|C_L_M44|C_L_M8344|C_L_M154|C_L_M152A|C_L_M152B|C_L_M51FA|C_L_M8351FA|C_L_M752|C_L_M83C752|C_L_M562
        |C_L_M83C562 },
        {(unsigned char* ) "ES0",       0xAC,       0,
        C_H_M80C652|C_H_M83C652|C_H_M552|C_H_M83C552|C_H_M528|C_H_M83C528  ,
        C_L_M80C652|C_L_M83C652|C_L_M552|C_L_M83C552|C_L_M528|C_L_M83C528 },
        {(unsigned char* ) "EI2",       0xAC,       0,
        C_H_M751|C_H_M83C751  ,
        C_L_M751|C_L_M83C751 },
        {(unsigned char* ) "ET2",       0xAD,       0,
        C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M154|C_H_M51FA|C_H_M8351FA  ,
        C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M154|C_L_M51FA|C_L_M8351FA },
        {(unsigned char* ) "ES1",       0xAD,       0,
        C_H_M80C652|C_H_M83C652|C_H_M552|C_H_M83C552  ,
        C_L_M80C652|C_L_M83C652|C_L_M552|C_L_M83C552 },
        {(unsigned char* ) "ET1",       0xAD,       0,
        C_H_M752|C_H_M83C752|C_H_M751|C_H_M83C751  ,
        C_L_M752|C_L_M83C752|C_L_M751|C_L_M83C751 },
        {(unsigned char*) "EAD",       0xAE,      0,
         C_H_M552|C_H_M83C552 , C_L_M552|C_L_M83C552 },
        {(unsigned char* ) "ES1",       0xAE,       0,
        C_H_M528|C_H_M83C528  ,
        C_L_M528|C_L_M83C528 },
        {(unsigned char* ) "EC",        0xAE,       0,
         C_H_M51FA|C_H_M8351FA  ,
         C_L_M51FA|C_L_M8351FA },
        {(unsigned char* ) "EAD",       0xAE,       0,
        C_H_M752|C_H_M83C752/*|C_H_M552|C_H_M83C552*/|C_H_M562|C_H_M83C562  ,
        C_L_M752|C_L_M83C752/*|C_L_M552|C_L_M83C552*/|C_L_M562|C_L_M83C562 },
        {(unsigned char* ) "EA",        0xAF,       0,
        C_H_M31|C_H_M51|C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M44|C_H_M8344|C_H_M154|C_H_M152A|C_H_M152B|C_H_M80C652|C_H_M83C652|C_H_M51FA
        |C_H_M8351FA|C_H_M752|C_H_M83C752|C_H_M552|C_H_M83C552|C_H_M562|C_H_M83C562|C_H_M750|C_H_M83C750|C_H_M751|C_H_M83C751  ,
        C_L_M31|C_L_M51|C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M44|C_L_M8344|C_L_M154|C_L_M152A|C_L_M152B|C_L_M80C652|C_L_M83C652|C_L_M51FA
        |C_L_M8351FA|C_L_M752|C_L_M83C752|C_L_M552|C_L_M83C552|C_L_M562|C_L_M83C562|C_L_M750|C_L_M83C750|C_L_M751|C_L_M83C751 },
        {(unsigned char* ) "PX0",       0xB8,       0,
         C_H_M31|C_H_M51|C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M44|C_H_M8344|C_H_M154|C_H_M152A|C_H_M152B|C_H_M80C652|C_H_M83C652
         |C_H_M552|C_H_M83C552|C_H_M562|C_H_M83C562|C_H_M51FA|C_H_M8351FA  ,
         C_L_M31|C_L_M51|C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M44|C_L_M8344|C_L_M154|C_L_M152A|C_L_M152B|C_L_M80C652|C_L_M83C652
         |C_L_M552|C_L_M83C552|C_L_M562|C_L_M83C562|C_L_M51FA|C_L_M8351FA },
        {(unsigned char* ) "PT0",       0xB9,       0,
         C_H_M31|C_H_M51|C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M44|C_H_M8344|C_H_M154|C_H_M152A|C_H_M152B|C_H_M80C652|C_H_M83C652|C_H_M552|C_H_M83C552
         |C_H_M562|C_H_M83C562|C_H_M51FA|C_H_M8351FA  ,
         C_L_M31|C_L_M51|C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M44|C_L_M8344|C_L_M154|C_L_M152A|C_L_M152B|C_L_M80C652|C_L_M83C652|C_L_M552|C_L_M83C552
         |C_L_M562|C_L_M83C562|C_L_M51FA|C_L_M8351FA },
        {(unsigned char* ) "PX1",       0xBA,       0,
         C_H_M31|C_H_M51|C_H_M32|C_H_M52,
         C_L_M31|C_L_M51|C_L_M32|C_L_M52},
        {(unsigned char* ) "PX1",       0xBA,       0,
         C_H_M528|C_H_M83C528|C_H_M44|C_H_M8344|C_H_M154|C_H_M152A|C_H_M152B|C_H_M80C652|C_H_M83C652|C_H_M552|C_H_M83C552
         |C_H_M562|C_H_M83C562|C_H_M51FA|C_H_M8351FA  ,
         C_L_M528|C_L_M83C528|C_L_M44|C_L_M8344|C_L_M154|C_L_M152A|C_L_M152B|C_L_M80C652|C_L_M83C652|C_L_M552|C_L_M83C552
         |C_L_M562|C_L_M83C562|C_L_M51FA|C_L_M8351FA },
        {(unsigned char* ) "PT1",       0xBB,       0,
         C_H_M31|C_H_M51|C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M44|C_H_M8344|C_H_M154|C_H_M152A|C_H_M152B|C_H_M80C652|C_H_M83C652|C_H_M552|C_H_M83C552
         |C_H_M562|C_H_M83C562|C_H_M51FA|C_H_M8351FA  ,
         C_L_M31|C_L_M51|C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M44|C_L_M8344|C_L_M154|C_L_M152A|C_L_M152B|C_L_M80C652|C_L_M83C652|C_L_M552|C_L_M83C552
         |C_L_M562|C_L_M83C562|C_L_M51FA|C_L_M8351FA },
        {(unsigned char* ) "PS",        0xBC,       0,
         C_H_M31|C_H_M51|C_H_M32|C_H_M52|C_H_M44|C_H_M8344|C_H_M154|C_H_M152A|C_H_M152B|C_H_M562|C_H_M83C562|C_H_M51FA|C_H_M8351FA  ,
         C_L_M31|C_L_M51|C_L_M32|C_L_M52|C_L_M44|C_L_M8344|C_L_M154|C_L_M152A|C_L_M152B|C_L_M562|C_L_M83C562|C_L_M51FA|C_L_M8351FA },
        {(unsigned char* ) "PS0",       0xBC,       0,
        C_H_M80C652|C_H_M83C652|C_H_M552|C_H_M83C552|C_H_M528|C_H_M83C528  ,
        C_L_M80C652|C_L_M83C652|C_L_M552|C_L_M83C552|C_L_M528|C_L_M83C528 },
        {(unsigned char* ) "PT2",       0xBD,       0,
         C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M154|C_H_M51FA|C_H_M8351FA  ,
         C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M154|C_L_M51FA|C_L_M8351FA },
        {(unsigned char* ) "PS1",       0xBD,       0,
        C_H_M80C652|C_H_M83C652|C_H_M552|C_H_M83C552  ,
        C_L_M80C652|C_L_M83C652|C_L_M552|C_L_M83C552 },
        {(unsigned char*) "PAD",       0xBE,      0,
         C_H_M552|C_H_M83C552 , C_L_M552|C_L_M83C552 },
        {(unsigned char* ) "PS1",       0xBE,       0,
        C_H_M528|C_H_M83C528  ,
        C_L_M528|C_L_M83C528 },
        {(unsigned char* ) "PPC",       0xBE,       0,
        C_H_M51FA|C_H_M8351FA  ,
        C_L_M51FA|C_L_M8351FA },
        {(unsigned char* ) "PCT",       0xBF,       0,
        C_H_M154  ,
        C_L_M154 },
        {(unsigned char*) "EGSRV",      0xC8,      0, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char* ) "CP/RL2",    0xC8,       0,
        C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M154|C_H_M51FA|C_H_M8351FA  ,
        C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M154|C_L_M51FA|C_L_M8351FA },
        {(unsigned char* ) "RBP",       0xC8,       0,
        C_H_M44|C_H_M8344  ,
        C_L_M44|C_L_M8344 },
        {(unsigned char*) "EGSRE",      0xC9,      0, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char* ) "C/T2",      0xC9,       0,
         C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M154|C_H_M51FA|C_H_M8351FA  ,
         C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M154|C_L_M51FA|C_L_M8351FA },
        {(unsigned char* ) "AM",        0xC9,       0,
        C_H_M44|C_H_M8344  ,
        C_L_M44|C_L_M8344 },
        {(unsigned char*) "EDMA0",      0xCA,      0, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char* ) "TR2",       0xCA,       0,
        C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M154|C_H_M51FA|C_H_M8351FA  ,
        C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M154|C_L_M51FA|C_L_M8351FA },
        {(unsigned char* ) "CPB",       0xCA,       0,
        C_H_M44|C_H_M8344  ,
        C_L_M44|C_L_M8344 },
        {(unsigned char*) "EGSTV",      0xCB,      0, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char* ) "EXEN2",     0xCB,       0,
         C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M154|C_H_M51FA|C_H_M8351FA  ,
         C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M154|C_L_M51FA|C_L_M8351FA },
        {(unsigned char* ) "BV",        0xCB,       0,
        C_H_M44|C_H_M8344  ,
        C_L_M44|C_L_M8344 },
        {(unsigned char*) "EDMA1",      0xCC,      0, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char* ) "TCLK",      0xCC,       0,
         C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M154|C_H_M51FA|C_H_M8351FA  ,
         C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M154|C_L_M51FA|C_L_M8351FA },
        {(unsigned char* ) "SI",        0xCC,       0,
        C_H_M44|C_H_M8344  ,
        C_L_M44|C_L_M8344 },
        {(unsigned char*) "EGSTE",      0xCD,      0, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char* ) "RCLK",      0xCD,       0,
        C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M154|C_H_M51FA|C_H_M8351FA  ,
        C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M154|C_L_M51FA|C_L_M8351FA },
        {(unsigned char* ) "RTS",       0xCD,       0,
        C_H_M44|C_H_M8344  ,
        C_L_M44|C_L_M8344 },
        {(unsigned char* ) "EXF2",      0xCE,       0,
        C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M154|C_H_M51FA|C_H_M8351FA  ,
        C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M154|C_L_M51FA|C_L_M8351FA },
        {(unsigned char* ) "RBE",        0xCE,       0,
        C_H_M44|C_H_M8344  ,
        C_L_M44|C_L_M8344 },
        {(unsigned char* ) "TF2",       0xCF,       0,
        C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M154|C_H_M51FA|C_H_M8351FA  ,
        C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M154|C_L_M51FA|C_L_M8351FA },
        {(unsigned char* ) "TBF",       0xCF,       0,
        C_H_M44|C_H_M8344  ,
        C_L_M44|C_L_M8344 },
        {(unsigned char* ) "P",         0xD0,       0,
         C_H_M31|C_H_M51|C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M44|C_H_M8344|C_H_M154|C_H_M152A|C_H_M152B|C_H_M80C652|C_H_M83C652|C_H_M51FA|C_H_M8351FA
         |C_H_M752|C_H_M83C752|C_H_M552|C_H_M83C552|C_H_M562|C_H_M83C562|C_H_M750|C_H_M83C750|C_H_M751|C_H_M83C751  ,
         C_L_M31|C_L_M51|C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M44|C_L_M8344|C_L_M154|C_L_M152A|C_L_M152B|C_L_M80C652|C_L_M83C652|C_L_M51FA|C_L_M8351FA
         |C_L_M752|C_L_M83C752|C_L_M552|C_L_M83C552|C_L_M562|C_L_M83C562|C_L_M750|C_L_M83C750|C_L_M751|C_L_M83C751 },
        {(unsigned char* ) "F1",        0xD1,       0,
        C_H_M154|C_H_M80C652|C_H_M83C652|C_H_M552|C_H_M83C552|C_H_M562|C_H_M83C562|C_H_M528|C_H_M83C528|C_H_M51FA|C_H_M8351FA   ,
        C_L_M154|C_L_M80C652|C_L_M83C652|C_L_M552|C_L_M83C552|C_L_M562|C_L_M83C562|C_L_M528|C_L_M83C528|C_L_M51FA|C_L_M8351FA  },
        {(unsigned char* ) "OV",        0xD2,       0,
        C_H_M31|C_H_M51|C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M44|C_H_M8344|C_H_M154|C_H_M152A|C_H_M152B|C_H_M80C652|C_H_M83C652|C_H_M51FA|C_H_M8351FA
        |C_H_M752|C_H_M83C752|C_H_M552|C_H_M83C552|C_H_M562|C_H_M83C562|C_H_M750|C_H_M83C750|C_H_M751|C_H_M83C751  ,
        C_L_M31|C_L_M51|C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M44|C_L_M8344|C_L_M154|C_L_M152A|C_L_M152B|C_L_M80C652|C_L_M83C652|C_L_M51FA|C_L_M8351FA
        |C_L_M752|C_L_M83C752|C_L_M552|C_L_M83C552|C_L_M562|C_L_M83C562|C_L_M750|C_L_M83C750|C_L_M751|C_L_M83C751 },
        {(unsigned char* ) "RS0",       0xD3,       0,
        C_H_M31|C_H_M51|C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M44|C_H_M8344|C_H_M154|C_H_M152A|C_H_M152B|C_H_M80C652|C_H_M83C652|C_H_M51FA|C_H_M8351FA
        |C_H_M752|C_H_M83C752|C_H_M552|C_H_M83C552|C_H_M562|C_H_M83C562|C_H_M750|C_H_M83C750|C_H_M751|C_H_M83C751  ,
        C_L_M31|C_L_M51|C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M44|C_L_M8344|C_L_M154|C_L_M152A|C_L_M152B|C_L_M80C652|C_L_M83C652|C_L_M51FA|C_L_M8351FA
        |C_L_M752|C_L_M83C752|C_L_M552|C_L_M83C552|C_L_M562|C_L_M83C562|C_L_M750|C_L_M83C750|C_L_M751|C_L_M83C751 },
        {(unsigned char* ) "RS1",       0xD4,       0,
         C_H_M31|C_H_M51|C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M44|C_H_M8344|C_H_M154|C_H_M152A|C_H_M152B|C_H_M80C652|C_H_M83C652|C_H_M51FA|C_H_M8351FA
         |C_H_M752|C_H_M83C752|C_H_M552|C_H_M83C552|C_H_M562|C_H_M83C562|C_H_M750|C_H_M83C750|C_H_M751|C_H_M83C751  ,
         C_L_M31|C_L_M51|C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M44|C_L_M8344|C_L_M154|C_L_M152A|C_L_M152B|C_L_M80C652|C_L_M83C652|C_L_M51FA|C_L_M8351FA
         |C_L_M752|C_L_M83C752|C_L_M552|C_L_M83C552|C_L_M562|C_L_M83C562|C_L_M750|C_L_M83C750|C_L_M751|C_L_M83C751 },
        {(unsigned char* ) "F0",        0xD5,       0,
        C_H_M31|C_H_M51|C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M44|C_H_M8344|C_H_M154|C_H_M152A|C_H_M152B|C_H_M80C652|C_H_M83C652|C_H_M51FA|C_H_M8351FA
        |C_H_M752|C_H_M83C752|C_H_M552|C_H_M83C552|C_H_M562|C_H_M83C562|C_H_M750|C_H_M83C750|C_H_M751|C_H_M83C751  ,
        C_L_M31|C_L_M51|C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M44|C_L_M8344|C_L_M154|C_L_M152A|C_L_M152B|C_L_M80C652|C_L_M83C652|C_L_M51FA|C_L_M8351FA
        |C_L_M752|C_L_M83C752|C_L_M552|C_L_M83C552|C_L_M562|C_L_M83C562|C_L_M750|C_L_M83C750|C_L_M751|C_L_M83C751 },
        {(unsigned char* ) "AC",        0xD6,       0,
        C_H_M31|C_H_M51|C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M44|C_H_M8344|C_H_M154|C_H_M152A|C_H_M152B|C_H_M80C652|C_H_M83C652|C_H_M51FA|C_H_M8351FA
        |C_H_M752|C_H_M83C752|C_H_M552|C_H_M83C552|C_H_M562|C_H_M83C562|C_H_M750|C_H_M83C750|C_H_M751|C_H_M83C751  ,
        C_L_M31|C_L_M51|C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M44|C_L_M8344|C_L_M154|C_L_M152A|C_L_M152B|C_L_M80C652|C_L_M83C652|C_L_M51FA|C_L_M8351FA
        |C_L_M752|C_L_M83C752|C_L_M552|C_L_M83C552|C_L_M562|C_L_M83C562|C_L_M750|C_L_M83C750|C_L_M751|C_L_M83C751 },
        {(unsigned char* ) "C",         0xD7,       0,
        C_H_M31|C_H_M51|C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M44|C_H_M8344|C_H_M154|C_H_M152A|C_H_M152B|C_H_M80C652|C_H_M83C652|C_H_M51FA|C_H_M8351FA
        |C_H_M752|C_H_M83C752|C_H_M552|C_H_M83C552|C_H_M562|C_H_M83C562|C_H_M750|C_H_M83C750|C_H_M751|C_H_M83C751  ,
        C_L_M31|C_L_M51|C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M44|C_L_M8344|C_L_M154|C_L_M152A|C_L_M152B|C_L_M80C652|C_L_M83C652|C_L_M51FA|C_L_M8351FA
        |C_L_M752|C_L_M83C752|C_L_M552|C_L_M83C552|C_L_M562|C_L_M83C562|C_L_M750|C_L_M83C750|C_L_M751|C_L_M83C751 },
        {(unsigned char* ) "CY",         0xD7,       0,
        C_H_M31|C_H_M51|C_H_M32|C_H_M52|C_H_M528|C_H_M83C528|C_H_M44|C_H_M8344|C_H_M154|C_H_M152A|C_H_M152B|C_H_M80C652|C_H_M83C652|C_H_M51FA|C_H_M8351FA
        |C_H_M752|C_H_M83C752|C_H_M552|C_H_M83C552|C_H_M562|C_H_M83C562|C_H_M750|C_H_M83C750|C_H_M751|C_H_M83C751  ,
        C_L_M31|C_L_M51|C_L_M32|C_L_M52|C_L_M528|C_L_M83C528|C_L_M44|C_L_M8344|C_L_M154|C_L_M152A|C_L_M152B|C_L_M80C652|C_L_M83C652|C_L_M51FA|C_L_M8351FA
        |C_L_M752|C_L_M83C752|C_L_M552|C_L_M83C552|C_L_M562|C_L_M83C562|C_L_M750|C_L_M83C750|C_L_M751|C_L_M83C751 },
        {(unsigned char*) "DMA",        0xD8,      0, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char* ) "SER",       0xD8,       0,
        C_H_M44|C_H_M8344  ,
        C_L_M44|C_L_M8344 },
        {(unsigned char* ) "CR0",       0xD8,       0,
        C_H_M80C652|C_H_M83C652|C_H_M552|C_H_M83C552|C_H_M562|C_H_M83C562  ,
        C_L_M80C652|C_L_M83C652|C_L_M552|C_L_M83C552|C_L_M562|C_L_M83C562 },
        {(unsigned char* ) "CCF0",      0xD8,       0,
        C_H_M51FA|C_H_M8351FA  ,
        C_L_M51FA|C_L_M8351FA },
        {(unsigned char* ) "ENS",       0xD8,       0,
        C_H_M528|C_H_M83C528  ,
        C_L_M528|C_L_M83C528 },
        {(unsigned char* ) "CT0",       0xD8,       0,
        C_H_M752|C_H_M83C752|C_H_M751|C_H_M83C751  ,
        C_L_M752|C_L_M83C752|C_L_M751|C_L_M83C751 },
        {(unsigned char*) "TEN",      0xD9,      0, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char* ) "NR0",       0xD9,       0,
        C_H_M44|C_H_M8344  ,
        C_L_M44|C_L_M8344 },
        {(unsigned char* ) "CR1",       0xD9,       0,
        C_H_M80C652|C_H_M83C652|C_H_M552|C_H_M83C552|C_H_M562|C_H_M83C562  ,
        C_L_M80C652|C_L_M83C652|C_L_M552|C_L_M83C552|C_L_M562|C_L_M83C562 },
        {(unsigned char* ) "CCF1",      0xD9,       0,
        C_H_M51FA|C_H_M8351FA  ,
        C_L_M51FA|C_L_M8351FA },
        {(unsigned char* ) "STR",       0xD9,       0,
        C_H_M528|C_H_M83C528  ,
        C_L_M528|C_L_M83C528 },
        {(unsigned char* ) "CT1",       0xD9,       0,
        C_H_M752|C_H_M83C752|C_H_M751|C_H_M83C751  ,
        C_L_M752|C_L_M83C752|C_L_M751|C_L_M83C751 },
        {(unsigned char*) "TFNF",       0xDA,      0, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char* ) "NR1",       0xDA,       0,
        C_H_M44|C_H_M8344  ,
        C_L_M44|C_L_M8344 },
        {(unsigned char* ) "AA",        0xDA,       0,
        C_H_M80C652|C_H_M83C652|C_H_M552|C_H_M83C552|C_H_M562|C_H_M83C562  ,
        C_L_M80C652|C_L_M83C652|C_L_M552|C_L_M83C552|C_L_M562|C_L_M83C562 },
        {(unsigned char* ) "CCF2",      0xDA,       0,
        C_H_M51FA|C_H_M8351FA  ,
        C_L_M51FA|C_L_M8351FA },
        {(unsigned char* ) "WBF",       0xDA,       0,
        C_H_M528|C_H_M83C528  ,
        C_L_M528|C_L_M83C528 },
        {(unsigned char*) "TDN",        0xDB,      0, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char* ) "NR2",       0xDB,       0,
        C_H_M44|C_H_M8344  ,
        C_L_M44|C_L_M8344 },
        {(unsigned char* ) "SI",        0xDB,       0,
        C_H_M80C652|C_H_M83C652|C_H_M552|C_H_M83C552|C_H_M562|C_H_M83C562  ,
        C_L_M80C652|C_L_M83C652|C_L_M552|C_L_M83C552|C_L_M562|C_L_M83C562 },
        {(unsigned char* ) "CCF3",      0xDB,       0,
        C_H_M51FA|C_H_M8351FA  ,
        C_L_M51FA|C_L_M8351FA },
        {(unsigned char* ) "RBF",       0xDB,       0,
        C_H_M528|C_H_M83C528  ,
        C_L_M528|C_L_M83C528 },
        {(unsigned char*) "TCDC",       0xDC,      0, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char* ) "SES",       0xDC,       0,
        C_H_M44|C_H_M8344  ,
        C_L_M44|C_L_M8344 },
        {(unsigned char* ) "STO",       0xDC,       0,
        C_H_M80C652|C_H_M83C652|C_H_M552|C_H_M83C552|C_H_M562|C_H_M83C562  ,
        C_L_M80C652|C_L_M83C652|C_L_M552|C_L_M83C552|C_L_M562|C_L_M83C562 },
        {(unsigned char* ) "CCF4",      0xDC,       0,
         C_H_M51FA|C_H_M8351FA  ,
         C_L_M51FA|C_L_M8351FA },
        {(unsigned char* ) "BB",        0xDC,       0,
        C_H_M528|C_H_M83C528  ,
        C_L_M528|C_L_M83C528 },
        {(unsigned char* ) "TIRUN",     0xDC,       0,
        C_H_M752|C_H_M83C752|C_H_M751|C_H_M83C751  ,
        C_L_M752|C_L_M83C752|C_L_M751|C_L_M83C751 },
        {(unsigned char*) "CLRTI",        0xDD,      0,
         C_H_M752|C_H_M83C752 ,C_L_M752|C_L_M83C752 },
        {(unsigned char*) "UR",         0xDD,      0, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char* ) "NS0",       0xDD,       0,
        C_H_M44|C_H_M8344  ,
        C_L_M44|C_L_M8344 },
        {(unsigned char* ) "STA",       0xDD,       0,
        C_H_M80C652|C_H_M83C652|C_H_M552|C_H_M83C552|C_H_M562|C_H_M83C562  ,
        C_L_M80C652|C_L_M83C652|C_L_M552|C_L_M83C552|C_L_M562|C_L_M83C562 },
        {(unsigned char* ) "CLH",       0xDD,       0,
        C_H_M528|C_H_M83C528  ,
        C_L_M528|C_L_M83C528 },
        {(unsigned char*) "NOACK",      0xDE,      0, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char* ) "NS1",       0xDE,       0,
        C_H_M44|C_H_M8344  ,
        C_L_M44|C_L_M8344 },
        {(unsigned char* ) "ENS1",      0xDE,       0,
        C_H_M80C652|C_H_M83C652|C_H_M552|C_H_M83C552|C_H_M562|C_H_M83C562  ,
        C_L_M80C652|C_L_M83C652|C_L_M552|C_L_M83C552|C_L_M562|C_L_M83C562 },
        {(unsigned char* ) "CR",        0xDE,       0,
        C_H_M51FA|C_H_M8351FA  ,
        C_L_M51FA|C_L_M8351FA },
        {(unsigned char* ) "MASTRQ",    0xDE,       0,
        C_H_M752|C_H_M83C752|C_H_M751|C_H_M83C751  ,
        C_L_M752|C_L_M83C752|C_L_M751|C_L_M83C751 },
        {(unsigned char*) "LNI",        0xDF,      0, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char* ) "NS2",       0xDF,       0,
        C_H_M44|C_H_M8344  ,
        C_L_M44|C_L_M8344 },
        {(unsigned char* ) "CR2",       0xDF,       0,
        C_H_M80C652|C_H_M83C652|C_H_M552|C_H_M83C552|C_H_M562|C_H_M83C562  ,
        C_L_M80C652|C_L_M83C652|C_L_M552|C_L_M83C552|C_L_M562|C_L_M83C562 },
        {(unsigned char* ) "CF",        0xDF,       0,
        C_H_M51FA|C_H_M8351FA  ,
        C_L_M51FA|C_L_M8351FA },
        {(unsigned char* ) "SDI",       0xDF,       0,
        C_H_M528|C_H_M83C528  ,
        C_L_M528|C_L_M83C528 },
        {(unsigned char* ) "SLAVEN",    0xDF,       0,
        C_H_M752|C_H_M83C752|C_H_M751|C_H_M83C751  ,
        C_L_M752|C_L_M83C752|C_L_M751|C_L_M83C751 },
        {(unsigned char*) "HABEN",      0xE8,      0, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char*) "GREN",       0xE9,      0, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char*) "RFNE",       0xEA,      0, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char*) "RDN",        0xEB,      0, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char*) "CRCE",       0xEC,      0, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char*) "AE",         0xED,      0, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char*) "RCABT",      0xEE,      0, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char*) "OVR",        0xEF,      0, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char*) "ECT0",       0xE8,      0,
         C_H_M552|C_H_M83C552 , C_L_M552|C_L_M83C552 },
        {(unsigned char*) "PGSRV",      0xE8,      0, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char*) "PCT0",       0xF8,      0,
         C_H_M552|C_H_M83C552 , C_L_M552|C_L_M83C552 },
        {(unsigned char* ) "ALF",       0xF8,       0,
        C_H_M154  ,
        C_L_M154 },
        {(unsigned char*) "PCT1",       0xF9,      0,
         C_H_M552|C_H_M83C552 , C_L_M552|C_L_M83C552 },
        {(unsigned char* ) "XSTP",      0xF8,       0,
        C_H_M752|C_H_M83C752|C_H_M751|C_H_M83C751  ,
        C_L_M752|C_L_M83C752|C_L_M751|C_L_M83C751 },
        {(unsigned char*) "PCT2",       0xFA,      0,
         C_H_M552|C_H_M83C552 , C_L_M552|C_L_M83C552 },
        {(unsigned char*) "PCT3",       0xFB,      0,
         C_H_M552|C_H_M83C552 , C_L_M552|C_L_M83C552 },
        {(unsigned char*) "PCM0",       0xFC,      0,
        C_H_M552|C_H_M83C552 , C_L_M552|C_L_M83C552 },
        {(unsigned char*) "PCM1",       0xFD,      0,
        C_H_M552|C_H_M83C552 , C_L_M552|C_L_M83C552 },
        {(unsigned char*) "PT2",       0xFF,      0,
        C_H_M552|C_H_M83C552 , C_L_M552|C_L_M83C552 },
        {(unsigned char*) "PCM0",       0xFC,      0,

         C_H_M552|C_H_M83C552 , C_L_M552|C_L_M83C552 },
        {(unsigned char*) "ECT1",       0xE9,      0,
         C_H_M552|C_H_M83C552 , C_L_M552|C_L_M83C552 },
        {(unsigned char*) "ECT2",       0xEA,      0,
         C_H_M552|C_H_M83C552 , C_L_M552|C_L_M83C552 },
        {(unsigned char*) "ECT3",       0xEB,      0,
         C_H_M552|C_H_M83C552 , C_L_M552|C_L_M83C552 },
        {(unsigned char*) "ECM0",       0xEC,      0,
         C_H_M552|C_H_M83C552 , C_L_M552|C_L_M83C552 },
        {(unsigned char*) "ECM1",       0xED,      0,
         C_H_M552|C_H_M83C552 , C_L_M552|C_L_M83C552 },
        {(unsigned char*) "ECM2",       0xEE,      0,
         C_H_M552|C_H_M83C552 , C_L_M552|C_L_M83C552 },
        {(unsigned char*) "ET2",       0xEF,      0,
         C_H_M552|C_H_M83C552 , C_L_M552|C_L_M83C552 },
        {(unsigned char*) "PGSRE",      0xF9,      0, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char* ) "XSTR",      0xF9,       0,
        C_H_M752|C_H_M83C752|C_H_M751|C_H_M83C751  ,
        C_L_M752|C_L_M83C752|C_L_M751|C_L_M83C751 },

        {(unsigned char*) "PDMA0",      0xFA,      0, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char* ) "P1HZ",      0xFA,       0,
        C_H_M154  ,
        C_L_M154 },
        {(unsigned char* ) "P2HZ",      0xFA,       0,
        C_H_M154  ,
        C_L_M154 },
        {(unsigned char* ) "MAKSTP",    0xFA,       0,
        C_H_M752|C_H_M83C752|C_H_M751|C_H_M83C751  ,
        C_L_M752|C_L_M83C752|C_L_M751|C_L_M83C751 },
        {(unsigned char*) "PGSTV",      0xFB,      0, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char* ) "P3HZ",      0xFB,       0,
        C_H_M154  ,
        C_L_M154 },
        {(unsigned char* ) "MAKSTR",    0xFB,       0,
        C_H_M752|C_H_M83C752|C_H_M751|C_H_M83C751  ,
        C_L_M752|C_L_M83C752|C_L_M751|C_L_M83C751 },
        {(unsigned char*) "PDMA1",      0xFC,      0, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char* ) "IZC",       0xFC,       0,
        C_H_M154  ,
        C_L_M154 },
        {(unsigned char* ) "XACTV",     0xFC,       0,
        C_H_M752|C_H_M83C752|C_H_M751|C_H_M83C751  ,
        C_L_M752|C_L_M83C752|C_L_M751|C_L_M83C751 },
        {(unsigned char*) "PGSTE",      0xFD,      0, C_H_M152A|C_H_M152B , C_L_M152A|C_L_M152B },
        {(unsigned char* ) "SERR",      0xFD,       0,
        C_H_M154  ,
        C_L_M154 },
        {(unsigned char* ) "XDATA",     0xFD,       0,
        C_H_M752|C_H_M83C752|C_H_M751|C_H_M83C751  ,
        C_L_M752|C_L_M83C752|C_L_M751|C_L_M83C751 },
        {(unsigned char*) "PCM2",       0xFE,      0,
         C_H_M552|C_H_M83C552 , C_L_M552|C_L_M83C552 },
        {(unsigned char* ) "T32",       0xFE,       0,
        C_H_M154  ,
        C_L_M154 },
        {(unsigned char* ) "WDT",       0xFF,       0,
        C_H_M154  ,
        C_L_M154 },
        {(unsigned char* ) "IDLE",      0xFE,       0,
        C_H_M752|C_H_M83C752|C_H_M751|C_H_M83C751  ,
        C_L_M752|C_L_M83C752|C_L_M751|C_L_M83C751 },
        {(unsigned char* )  "",         0x00,       0,
        0x0000} };    /* End of the table */

SFRNAME SFRbyteCL3151[]={
      /* SFR-Name    Dir-Addr   SfrAttr      CPUmode */
        {(unsigned char*) "DPL",        0x82,      0,
        C_H_M80CL31|C_H_M80CL51, C_L_M80CL31|C_L_M80CL51 } ,
        {(unsigned char*) "DPH",        0x83,      0,
        C_H_M80CL31|C_H_M80CL51, C_L_M80CL31|C_L_M80CL51 } ,
        {(unsigned char* )"A",          0xE0,      1,
        C_H_M80CL31|C_H_M80CL51, C_L_M80CL31|C_L_M80CL51 } ,
        {(unsigned char* )"ACC",          0xE0,      1,
        C_H_M80CL31|C_H_M80CL51, C_L_M80CL31|C_L_M80CL51 } ,
        {(unsigned char* )"B",          0xF0,      1,
        C_H_M80CL31|C_H_M80CL51, C_L_M80CL31|C_L_M80CL51 } ,
        {(unsigned char*) "SP",         0x81,      0,
        C_H_M80CL31|C_H_M80CL51, C_L_M80CL31|C_L_M80CL51 } ,
        {(unsigned char* )"PSW",        0xD0,      1,
        C_H_M80CL31|C_H_M80CL51, C_L_M80CL31|C_L_M80CL51 } ,
        {(unsigned char* )"IEN0",       0xA8,      1,
        C_H_M80CL31|C_H_M80CL51, C_L_M80CL31|C_L_M80CL51 } ,
        {(unsigned char* )"TCON",       0x88,      1,
        C_H_M80CL31|C_H_M80CL51, C_L_M80CL31|C_L_M80CL51 } ,
        {(unsigned char* )"IP0",        0xB8,      1,
        C_H_M80CL31|C_H_M80CL51, C_L_M80CL31|C_L_M80CL51 } ,
        {(unsigned char* )"IEN1",       0xE8,      1,
        C_H_M80CL31|C_H_M80CL51, C_L_M80CL31|C_L_M80CL51 } ,
        {(unsigned char* )"IP1",        0xF8,      1,
        C_H_M80CL31|C_H_M80CL51, C_L_M80CL31|C_L_M80CL51 } ,
        {(unsigned char* )"S0CON",      0x98,      1,
        C_H_M80CL31|C_H_M80CL51, C_L_M80CL31|C_L_M80CL51 } ,
        {(unsigned char* )"TMOD",       0x89,      0,
        C_H_M80CL31|C_H_M80CL51, C_L_M80CL31|C_L_M80CL51 } ,
        {(unsigned char* )"TH0",        0x8C,      0,
        C_H_M80CL31|C_H_M80CL51, C_L_M80CL31|C_L_M80CL51 } ,
        {(unsigned char* )"TL0",        0x8A,      0,
        C_H_M80CL31|C_H_M80CL51, C_L_M80CL31|C_L_M80CL51 } ,
        {(unsigned char* )"TH1",        0x8D,      0,
        C_H_M80CL31|C_H_M80CL51, C_L_M80CL31|C_L_M80CL51 } ,
        {(unsigned char* )"TL1",        0x8B,      0,
        C_H_M80CL31|C_H_M80CL51, C_L_M80CL31|C_L_M80CL51 } ,
        {(unsigned char* )"IRQ1",       0xC0,      1,
        C_H_M80CL31|C_H_M80CL51, C_L_M80CL31|C_L_M80CL51 } ,
        {(unsigned char* )"IX1",        0xE9,      0,
        C_H_M80CL31|C_H_M80CL51, C_L_M80CL31|C_L_M80CL51 } ,
        {(unsigned char*) "P0",         0x80,      1,
        C_H_M80CL31|C_H_M80CL51, C_L_M80CL31|C_L_M80CL51 } ,
        {(unsigned char*) "P1",         0x90,      1,
        C_H_M80CL31|C_H_M80CL51, C_L_M80CL31|C_L_M80CL51 } ,
        {(unsigned char*) "P2",         0xA0,      1,
        C_H_M80CL31|C_H_M80CL51, C_L_M80CL31|C_L_M80CL51 } ,
        {(unsigned char*) "P3",         0xB0,      1,
        C_H_M80CL31|C_H_M80CL51, C_L_M80CL31|C_L_M80CL51 } ,
        {(unsigned char* )  "",         0x00,       0,
        0x0000} };    /* End of the table */

SFRNAME SFRbyteCL410[]={
      /* SFR-Name    Dir-Addr   SfrAttr      CPUmode */
        {(unsigned char*) "DPL",        0x82,      0,
         C_H_M80CL410|C_H_M83CL410 , C_L_M80CL410|C_L_M83CL410 } ,
        {(unsigned char*) "DPH",        0x83,      0,
        C_H_M80CL410|C_H_M83CL410, C_L_M80CL410|C_L_M83CL410 } ,
        {(unsigned char* )"A",          0xE0,      1,
        C_H_M80CL410|C_H_M83CL410, C_L_M80CL410|C_L_M83CL410 } ,
        {(unsigned char* )"ACC",          0xE0,      1,
        C_H_M80CL410|C_H_M83CL410, C_L_M80CL410|C_L_M83CL410 } ,
        {(unsigned char* )"B",          0xF0,      1,
        C_H_M80CL410|C_H_M83CL410, C_L_M80CL410|C_L_M83CL410 } ,
        {(unsigned char*) "SP",         0x81,      0,
        C_H_M80CL410|C_H_M83CL410, C_L_M80CL410|C_L_M83CL410 } ,
        {(unsigned char* )"PSW",        0xD0,      1,
        C_H_M80CL410|C_H_M83CL410, C_L_M80CL410|C_L_M83CL410 } ,
        {(unsigned char*) "IEN0"   ,      0xA8   ,    1  ,
        C_H_M80CL410|C_H_M83CL410, C_L_M80CL410|C_L_M83CL410 } ,
        {(unsigned char*) "TCON"   ,      0x88   ,    1  ,
        C_H_M80CL410|C_H_M83CL410, C_L_M80CL410|C_L_M83CL410 } ,
        {(unsigned char*) "IP0"    ,      0xB8   ,    1  ,
        C_H_M80CL410|C_H_M83CL410, C_L_M80CL410|C_L_M83CL410 } ,
        {(unsigned char*) "IEN1"   ,      0xE8   ,    1  ,
        C_H_M80CL410|C_H_M83CL410, C_L_M80CL410|C_L_M83CL410 } ,
        {(unsigned char*) "IP1"    ,      0xF8   ,    1  ,
        C_H_M80CL410|C_H_M83CL410, C_L_M80CL410|C_L_M83CL410 } ,
        {(unsigned char*) "TMOD"   ,      0x89   ,    0  ,
        C_H_M80CL410|C_H_M83CL410, C_L_M80CL410|C_L_M83CL410 } ,
        {(unsigned char*) "TH0"    ,      0x8C   ,    0  ,
        C_H_M80CL410|C_H_M83CL410, C_L_M80CL410|C_L_M83CL410 } ,
        {(unsigned char*) "TL0"    ,      0x8A   ,    0  ,
        C_H_M80CL410|C_H_M83CL410, C_L_M80CL410|C_L_M83CL410 } ,
        {(unsigned char*) "TH1"    ,      0x8D   ,    0  ,
        C_H_M80CL410|C_H_M83CL410, C_L_M80CL410|C_L_M83CL410 } ,
        {(unsigned char*) "TL1"    ,      0x8B   ,    0  ,
        C_H_M80CL410|C_H_M83CL410, C_L_M80CL410|C_L_M83CL410 } ,
        {(unsigned char*) "S1CON"  ,      0xD8   ,    1  ,
        C_H_M80CL410|C_H_M83CL410, C_L_M80CL410|C_L_M83CL410 } ,
        {(unsigned char*) "S1STA"  ,      0xD9   ,    0  ,
        C_H_M80CL410|C_H_M83CL410, C_L_M80CL410|C_L_M83CL410 } ,
        {(unsigned char*) "S1ADR"  ,      0xDB   ,    0  ,
        C_H_M80CL410|C_H_M83CL410, C_L_M80CL410|C_L_M83CL410 } ,
        {(unsigned char*) "S1DAT"  ,      0xDA   ,    0  ,
        C_H_M80CL410|C_H_M83CL410, C_L_M80CL410|C_L_M83CL410 } ,
        {(unsigned char*) "IRQ1"   ,      0xC0   ,    1  ,
        C_H_M80CL410|C_H_M83CL410, C_L_M80CL410|C_L_M83CL410 } ,
        {(unsigned char*) "IX1"    ,      0xE9   ,    0  ,
        C_H_M80CL410|C_H_M83CL410, C_L_M80CL410|C_L_M83CL410 } ,
        {(unsigned char*) "P0",         0x80,      1,
        C_H_M80CL410|C_H_M83CL410, C_L_M80CL410|C_L_M83CL410 } ,
        {(unsigned char*) "P1",         0x90,      1,
        C_H_M80CL410|C_H_M83CL410, C_L_M80CL410|C_L_M83CL410 } ,
        {(unsigned char*) "P2",         0xA0,      1,
        C_H_M80CL410|C_H_M83CL410, C_L_M80CL410|C_L_M83CL410 } ,
        {(unsigned char*) "P3",         0xB0,      1,
        C_H_M80CL410|C_H_M83CL410, C_L_M80CL410|C_L_M83CL410 } ,
        {(unsigned char* )  "",         0x00,       0,
        0x0000} };    /* End of the table */

SFRNAME SFRbyteCL781782[]={
      /* SFR-Name    Dir-Addr   SfrAttr      CPUmode */
        {(unsigned char*) "DPL",        0x82,      0,
         C_H_M83CL781|C_H_M83CL782 , C_L_M83CL781|C_L_M83CL782 } ,
        {(unsigned char*) "DPH",        0x83,      0,
        C_H_M83CL781|C_H_M83CL782, C_L_M83CL781|C_L_M83CL782 } ,
        {(unsigned char* )"A",          0xE0,      1,
        C_H_M83CL781|C_H_M83CL782, C_L_M83CL781|C_L_M83CL782 } ,
        {(unsigned char* )"ACC",          0xE0,      1,
        C_H_M83CL781|C_H_M83CL782, C_L_M83CL781|C_L_M83CL782 } ,
        {(unsigned char* )"B",          0xF0,      1,
        C_H_M83CL781|C_H_M83CL782, C_L_M83CL781|C_L_M83CL782 } ,
        {(unsigned char*) "SP",         0x81,      0,
        C_H_M83CL781|C_H_M83CL782, C_L_M83CL781|C_L_M83CL782 } ,
        {(unsigned char* )"PSW",        0xD0,      1,
        C_H_M83CL781|C_H_M83CL782, C_L_M83CL781|C_L_M83CL782 } ,
        {(unsigned char*) "IEN0"    ,   0xA8  ,    1  ,
        C_H_M83CL781|C_H_M83CL782, C_L_M83CL781|C_L_M83CL782 } ,
        {(unsigned char*) "TCON"    ,   0x88  ,    1  ,
        C_H_M83CL781|C_H_M83CL782, C_L_M83CL781|C_L_M83CL782 } ,
        {(unsigned char*) "T2CON"   ,   0xC8  ,    1  ,
        C_H_M83CL781|C_H_M83CL782, C_L_M83CL781|C_L_M83CL782 } ,
        {(unsigned char*) "IP0"     ,   0xB8  ,    1  ,
        C_H_M83CL781|C_H_M83CL782, C_L_M83CL781|C_L_M83CL782 } ,
        {(unsigned char*) "IEN1"    ,   0xE8  ,    1  ,
        C_H_M83CL781|C_H_M83CL782, C_L_M83CL781|C_L_M83CL782 } ,
        {(unsigned char*) "IP1"     ,   0xF8  ,    1  ,
        C_H_M83CL781|C_H_M83CL782, C_L_M83CL781|C_L_M83CL782 } ,
        {(unsigned char*) "S0CON"   ,   0x98  ,    1  ,
        C_H_M83CL781|C_H_M83CL782, C_L_M83CL781|C_L_M83CL782 } ,
        {(unsigned char*) "TMOD"    ,   0x89  ,    0  ,
        C_H_M83CL781|C_H_M83CL782, C_L_M83CL781|C_L_M83CL782 } ,
        {(unsigned char*) "TH0"     ,   0x8C  ,    0  ,
        C_H_M83CL781|C_H_M83CL782, C_L_M83CL781|C_L_M83CL782 } ,
        {(unsigned char*) "TL0"     ,   0x8A  ,    0  ,
        C_H_M83CL781|C_H_M83CL782, C_L_M83CL781|C_L_M83CL782 } ,
        {(unsigned char*) "TH1"     ,   0x8D  ,    0  ,
        C_H_M83CL781|C_H_M83CL782, C_L_M83CL781|C_L_M83CL782 } ,
        {(unsigned char*) "TL1"     ,   0x8B  ,    0  ,
        C_H_M83CL781|C_H_M83CL782, C_L_M83CL781|C_L_M83CL782 } ,
        {(unsigned char*) "IRQ1"    ,   0xC0  ,    1  ,
        C_H_M83CL781|C_H_M83CL782, C_L_M83CL781|C_L_M83CL782 } ,
        {(unsigned char*) "IX1"     ,   0xE9  ,    0  ,
        C_H_M83CL781|C_H_M83CL782, C_L_M83CL781|C_L_M83CL782 } ,
        {(unsigned char*) "S1CON"   ,   0xD8  ,    1  ,
        C_H_M83CL781|C_H_M83CL782, C_L_M83CL781|C_L_M83CL782 } ,
        {(unsigned char*) "S1STA"   ,   0xD9  ,    0  ,
        C_H_M83CL781|C_H_M83CL782, C_L_M83CL781|C_L_M83CL782 } ,
        {(unsigned char*) "S1DAT"   ,   0xDA  ,    0  ,
        C_H_M83CL781|C_H_M83CL782, C_L_M83CL781|C_L_M83CL782 } ,
        {(unsigned char*) "S1ADR"   ,   0xDB  ,    0  ,
        C_H_M83CL781|C_H_M83CL782, C_L_M83CL781|C_L_M83CL782 } ,
        {(unsigned char*) "TH2"     ,   0xCD  ,    0  ,
        C_H_M83CL781|C_H_M83CL782, C_L_M83CL781|C_L_M83CL782 } ,
        {(unsigned char*) "TL2"     ,   0xCC  ,    0  ,
        C_H_M83CL781|C_H_M83CL782, C_L_M83CL781|C_L_M83CL782 } ,
        {(unsigned char*) "RCAP2H"  ,   0xCB  ,    0  ,
        C_H_M83CL781|C_H_M83CL782, C_L_M83CL781|C_L_M83CL782 } ,
        {(unsigned char*) "RCAP2L"  ,   0xCA  ,    0  ,
        C_H_M83CL781|C_H_M83CL782, C_L_M83CL781|C_L_M83CL782 } ,
        {(unsigned char*) "P0",         0x80,      1,
        C_H_M83CL781|C_H_M83CL782, C_L_M83CL781|C_L_M83CL782 } ,
        {(unsigned char*) "P1",         0x90,      1,
        C_H_M83CL781|C_H_M83CL782, C_L_M83CL781|C_L_M83CL782 } ,
        {(unsigned char*) "P2",         0xA0,      1,
        C_H_M83CL781|C_H_M83CL782, C_L_M83CL781|C_L_M83CL782 } ,
        {(unsigned char*) "P3",         0xB0,      1,
        C_H_M83CL781|C_H_M83CL782, C_L_M83CL781|C_L_M83CL782 } ,
        {(unsigned char* )  "",         0x00,       0,
        0x0000} };    /* End of the table */

SFRNAME SFRbyteCL580[]={
      /* SFR-Name    Dir-Addr   SfrAttr      CPUmode */
        {(unsigned char*) "DPL",        0x82,      0,
         C_H_M80CL580|C_H_M83CL580 , C_L_M80CL580|C_L_M83CL580 } ,
        {(unsigned char*) "DPH",        0x83,      0,
        C_H_M80CL580|C_H_M83CL580, C_L_M80CL580|C_L_M83CL580 } ,
        {(unsigned char* )"A",          0xE0,      1,
        C_H_M80CL580|C_H_M83CL580, C_L_M80CL580|C_L_M83CL580 } ,
        {(unsigned char* )"ACC",          0xE0,      1,
        C_H_M80CL580|C_H_M83CL580, C_L_M80CL580|C_L_M83CL580 } ,
        {(unsigned char* )"B",          0xF0,      1,
        C_H_M80CL580|C_H_M83CL580, C_L_M80CL580|C_L_M83CL580 } ,
        {(unsigned char*) "SP",         0x81,      0,
        C_H_M80CL580|C_H_M83CL580, C_L_M80CL580|C_L_M83CL580 } ,
        {(unsigned char* )"PSW",        0xD0,      1,
        C_H_M80CL580|C_H_M83CL580, C_L_M80CL580|C_L_M83CL580 } ,
        {(unsigned char*) "IEN0"    ,   0xA8   ,    1  ,
        C_H_M80CL580|C_H_M83CL580 , C_L_M80CL580|C_L_M83CL580 } ,
        {(unsigned char*) "TCON"    ,   0x88   ,    1  ,
        C_H_M80CL580|C_H_M83CL580 , C_L_M80CL580|C_L_M83CL580 } ,
        {(unsigned char*) "T2CON"   ,   0xC8   ,    1  ,
        C_H_M80CL580|C_H_M83CL580 , C_L_M80CL580|C_L_M83CL580 } ,
        {(unsigned char*) "IP0"     ,   0xB8   ,    1  ,
        C_H_M80CL580|C_H_M83CL580 , C_L_M80CL580|C_L_M83CL580 } ,
        {(unsigned char*) "IEN1"    ,   0xE8   ,    1  ,
        C_H_M80CL580|C_H_M83CL580 , C_L_M80CL580|C_L_M83CL580 } ,
        {(unsigned char*) "IP1"     ,   0xF8   ,    1  ,
        C_H_M80CL580|C_H_M83CL580 , C_L_M80CL580|C_L_M83CL580 } ,
        {(unsigned char*) "S0CON"   ,   0x98   ,    1  ,
        C_H_M80CL580|C_H_M83CL580 , C_L_M80CL580|C_L_M83CL580 } ,
        {(unsigned char*) "TMOD"    ,   0x89   ,    0  ,
        C_H_M80CL580|C_H_M83CL580 , C_L_M80CL580|C_L_M83CL580 } ,
        {(unsigned char*) "TH0"     ,   0x8C   ,    0  ,
        C_H_M80CL580|C_H_M83CL580 , C_L_M80CL580|C_L_M83CL580 } ,
        {(unsigned char*) "TL0"     ,   0x8A   ,    0  ,
        C_H_M80CL580|C_H_M83CL580 , C_L_M80CL580|C_L_M83CL580 } ,
        {(unsigned char*) "TH1"     ,   0x8D   ,    0  ,
        C_H_M80CL580|C_H_M83CL580 , C_L_M80CL580|C_L_M83CL580 } ,
        {(unsigned char*) "TL1"     ,   0x8B   ,    0  ,
        C_H_M80CL580|C_H_M83CL580 , C_L_M80CL580|C_L_M83CL580 } ,
        {(unsigned char*) "IRQ1"    ,   0xC0   ,    1  ,
        C_H_M80CL580|C_H_M83CL580 , C_L_M80CL580|C_L_M83CL580 } ,
        {(unsigned char*) "IX1"     ,   0xE9   ,    0  ,
        C_H_M80CL580|C_H_M83CL580 , C_L_M80CL580|C_L_M83CL580 } ,
        {(unsigned char*) "S1CON"   ,   0xD8   ,    1  ,
        C_H_M80CL580|C_H_M83CL580 , C_L_M80CL580|C_L_M83CL580 } ,
        {(unsigned char*) "S1STA"   ,   0xD9   ,    0  ,
        C_H_M80CL580|C_H_M83CL580 , C_L_M80CL580|C_L_M83CL580 } ,
        {(unsigned char*) "S1DAT"   ,   0xDA   ,    0  ,
        C_H_M80CL580|C_H_M83CL580 , C_L_M80CL580|C_L_M83CL580 } ,
        {(unsigned char*) "S1ADR"   ,   0xDB   ,    0  ,
        C_H_M80CL580|C_H_M83CL580 , C_L_M80CL580|C_L_M83CL580 } ,
        {(unsigned char*) "TH2"     ,   0xCD   ,    0  ,
        C_H_M80CL580|C_H_M83CL580 , C_L_M80CL580|C_L_M83CL580 } ,
        {(unsigned char*) "TL2"     ,   0xCC   ,    0  ,
        C_H_M80CL580|C_H_M83CL580 , C_L_M80CL580|C_L_M83CL580 } ,
        {(unsigned char*) "RCAP2H"  ,   0xCB   ,    0  ,
        C_H_M80CL580|C_H_M83CL580 , C_L_M80CL580|C_L_M83CL580 } ,
        {(unsigned char*) "RCAP2L"  ,   0xCA   ,    0  ,
        C_H_M80CL580|C_H_M83CL580 , C_L_M80CL580|C_L_M83CL580 } ,
        {(unsigned char*) "ADCON"   ,   0xC4   ,    0  ,
        C_H_M80CL580|C_H_M83CL580 , C_L_M80CL580|C_L_M83CL580 } ,
        {(unsigned char*) "ADCH"    ,   0xC5   ,    0  ,
        C_H_M80CL580|C_H_M83CL580 , C_L_M80CL580|C_L_M83CL580 } ,
        {(unsigned char*) "PWM0"    ,   0xFC   ,    0  ,
        C_H_M80CL580|C_H_M83CL580 , C_L_M80CL580|C_L_M83CL580 } ,
        {(unsigned char*) "PWMP"    ,   0xFE   ,    0  ,
        C_H_M80CL580|C_H_M83CL580 , C_L_M80CL580|C_L_M83CL580 } ,
        {(unsigned char*) "T3"      ,   0xFF   ,    0  ,
        C_H_M80CL580|C_H_M83CL580 , C_L_M80CL580|C_L_M83CL580 } ,
        {(unsigned char*) "P0",         0x80,      1,
        C_H_M80CL580|C_H_M83CL580 , C_L_M80CL580|C_L_M83CL580 } ,
        {(unsigned char*) "P1",         0x90,      1,
        C_H_M80CL580|C_H_M83CL580 , C_L_M80CL580|C_L_M83CL580 } ,
        {(unsigned char*) "P2",         0xA0,      1,
        C_H_M80CL580|C_H_M83CL580 , C_L_M80CL580|C_L_M83CL580 } ,
        {(unsigned char*) "P3",         0xB0,      1,
        C_H_M80CL580|C_H_M83CL580 , C_L_M80CL580|C_L_M83CL580 } ,
        {(unsigned char*) "P4",         0xC1,      0,
        C_H_M80CL580|C_H_M83CL580 , C_L_M80CL580|C_L_M83CL580 } ,
        {(unsigned char* )  "",         0x00,       0,
        0x0000} };    /* End of the table */

SFRNAME SFRbyteCL550[]={
      /* SFR-Name    Dir-Addr   SfrAttr      CPUmode */
        {(unsigned char*) "DPL",        0x82,      0,
         C_H_M80C550|C_H_M83C550 , C_L_M80C550|C_L_M83C550 } ,
        {(unsigned char*) "DPH",        0x83,      0,
        C_H_M80C550|C_H_M83C550, C_L_M80C550|C_L_M83C550 } ,
        {(unsigned char* )"A",          0xE0,      1,
        C_H_M80C550|C_H_M83C550, C_L_M80C550|C_L_M83C550 } ,
        {(unsigned char* )"ACC",          0xE0,      1,
        C_H_M80C550|C_H_M83C550, C_L_M80C550|C_L_M83C550 } ,
        {(unsigned char* )"B",          0xF0,      1,
        C_H_M80C550|C_H_M83C550, C_L_M80C550|C_L_M83C550 } ,
        {(unsigned char*) "SP",         0x81,      0,
        C_H_M80C550|C_H_M83C550, C_L_M80C550|C_L_M83C550 } ,
        {(unsigned char* )"PSW",        0xD0,      1,
        C_H_M80C550|C_H_M83C550, C_L_M80C550|C_L_M83C550 } ,
        {(unsigned char*) "IE"      ,  0xA8      ,    1  ,
        C_H_M80C550|C_H_M83C550, C_L_M80C550|C_L_M83C550 } ,
        {(unsigned char*) "TCON"    ,  0x88      ,    1  ,
        C_H_M80C550|C_H_M83C550, C_L_M80C550|C_L_M83C550 } ,
        {(unsigned char*) "IP"      ,  0xB8      ,    1  ,
        C_H_M80C550|C_H_M83C550, C_L_M80C550|C_L_M83C550 } ,
        {(unsigned char*) "TMOD"    ,  0x89      ,    0  ,
        C_H_M80C550|C_H_M83C550, C_L_M80C550|C_L_M83C550 } ,
        {(unsigned char*) "TH0"     ,  0x8C      ,    0  ,
        C_H_M80C550|C_H_M83C550, C_L_M80C550|C_L_M83C550 } ,
        {(unsigned char*) "TL0"     ,  0x8A      ,    0  ,
        C_H_M80C550|C_H_M83C550, C_L_M80C550|C_L_M83C550 } ,
        {(unsigned char*) "TH1"     ,  0x8D      ,    0  ,
        C_H_M80C550|C_H_M83C550, C_L_M80C550|C_L_M83C550 } ,
        {(unsigned char*) "TL1"     ,  0x8B      ,    0  ,
        C_H_M80C550|C_H_M83C550, C_L_M80C550|C_L_M83C550 } ,
        {(unsigned char*) "SCON"    ,  0x98      ,    1  ,
        C_H_M80C550|C_H_M83C550, C_L_M80C550|C_L_M83C550 } ,
        {(unsigned char*) "PCON"    ,  0x87      ,    0  ,
        C_H_M80C550|C_H_M83C550, C_L_M80C550|C_L_M83C550 } ,
        {(unsigned char*) "WDCON"   ,  0xC0      ,    1  ,
        C_H_M80C550|C_H_M83C550, C_L_M80C550|C_L_M83C550 } ,
        {(unsigned char*) "WDL"     ,  0xC1      ,    0  ,
        C_H_M80C550|C_H_M83C550, C_L_M80C550|C_L_M83C550 } ,
        {(unsigned char*) "WFEED1"  ,  0xC2      ,    0  ,
        C_H_M80C550|C_H_M83C550, C_L_M80C550|C_L_M83C550 } ,
        {(unsigned char*) "WFEED2"  ,  0xC3      ,    0  ,
        C_H_M80C550|C_H_M83C550, C_L_M80C550|C_L_M83C550 } ,
        {(unsigned char*) "ADCON"   ,  0xC5      ,    0  ,
        C_H_M80C550|C_H_M83C550, C_L_M80C550|C_L_M83C550 } ,
        {(unsigned char*) "ADAT"    ,  0xC6      ,    0  ,
        C_H_M80C550|C_H_M83C550, C_L_M80C550|C_L_M83C550 } ,
        {(unsigned char*) "P0",         0x80,      1,
        C_H_M80C550|C_H_M83C550, C_L_M80C550|C_L_M83C550 } ,
        {(unsigned char*) "P1",         0x90,      1,
        C_H_M80C550|C_H_M83C550, C_L_M80C550|C_L_M83C550 } ,
        {(unsigned char*) "P2",         0xA0,      1,
        C_H_M80C550|C_H_M83C550, C_L_M80C550|C_L_M83C550 } ,
        {(unsigned char*) "P3",         0xB0,      1,
        C_H_M80C550|C_H_M83C550, C_L_M80C550|C_L_M83C550 } ,
        {(unsigned char* )  "",         0x00,       0,
        0x0000} };    /* End of the table */

SFRNAME SFRbyte320[]={
      /* SFR-Name    Dir-Addr   SfrAttr      CPUmode */
        {(unsigned char*) "DPL",        0x82,      0, C_H_M320 , C_L_M320 } ,
        {(unsigned char*) "DPH",        0x83,      0, C_H_M320, C_L_M320 } ,
        {(unsigned char* )"A",          0xE0,    1, C_H_M320, C_L_M320 } ,
        {(unsigned char* )"ACC",          0xE0,    1, C_H_M320, C_L_M320 } ,
        {(unsigned char* )"B",          0xF0,      1, C_H_M320, C_L_M320 } ,
        {(unsigned char*) "SP",         0x81,      0, C_H_M320, C_L_M320 } ,
        {(unsigned char* )"PSW",        0xD0,      1, C_H_M320, C_L_M320 } ,
        {(unsigned char*) "IE"     ,      0xA8   ,    1  ,C_H_M320, C_L_M320 } ,
        {(unsigned char*) "TCON"   ,      0x88   ,    1  ,C_H_M320, C_L_M320 } ,
        {(unsigned char*) "T2CON"  ,      0xC8   ,    1  ,C_H_M320, C_L_M320 } ,
        {(unsigned char*) "IP"     ,      0xB8   ,    1  ,C_H_M320, C_L_M320 } ,
        {(unsigned char*) "SCON0"  ,      0x98   ,    1  ,C_H_M320, C_L_M320 } ,
        {(unsigned char*) "TMOD"   ,      0x89   ,    0  ,C_H_M320, C_L_M320 } ,
        {(unsigned char*) "TH0"    ,      0x8C   ,    0  ,C_H_M320, C_L_M320 } ,
        {(unsigned char*) "TL0"   ,       0x8A   ,    0  ,C_H_M320, C_L_M320 } ,
        {(unsigned char*) "TH1"    ,      0x8D   ,    0  ,C_H_M320, C_L_M320 } ,
        {(unsigned char*) "TL1"   ,       0x8B   ,    0  ,C_H_M320, C_L_M320 } ,
        {(unsigned char*) "DPH1"   ,      0x85   ,    0  ,C_H_M320, C_L_M320 } ,
        {(unsigned char*) "DPL1"   ,      0x84   ,    0  ,C_H_M320, C_L_M320 } ,
        {(unsigned char*) "DPS"    ,      0x86   ,    0  ,C_H_M320, C_L_M320 } ,
        {(unsigned char*) "CKCON"  ,      0x8E   ,    0  ,C_H_M320, C_L_M320 } ,
        {(unsigned char*) "EXIF"   ,      0x91   ,    0  ,C_H_M320, C_L_M320 } ,
        {(unsigned char*) "SADDR0" ,      0xA9   ,    0  ,C_H_M320, C_L_M320 } ,
        {(unsigned char*) "SADDR1" ,      0xAA   ,    0  ,C_H_M320, C_L_M320 } ,
        {(unsigned char*) "SADEN0" ,      0xB9   ,    0  ,C_H_M320, C_L_M320 } ,
        {(unsigned char*) "SADEN1" ,      0xBA   ,    0  ,C_H_M320, C_L_M320 } ,
        {(unsigned char*) "SCON1"  ,      0xC0   ,    1  ,C_H_M320, C_L_M320 } ,
        {(unsigned char*) "TA"     ,      0xC7   ,    0  ,C_H_M320, C_L_M320 } ,
        {(unsigned char*) "T2MOD"  ,      0xC9   ,    0  ,C_H_M320, C_L_M320 } ,
        {(unsigned char*) "RCAP2L" ,      0xCA   ,    0  ,C_H_M320, C_L_M320 } ,
        {(unsigned char*) "RCAP2H" ,      0xCB   ,    0  ,C_H_M320, C_L_M320 } ,
        {(unsigned char*) "WDCON"  ,      0xD8   ,    1  ,C_H_M320, C_L_M320 } ,
        {(unsigned char*) "EIE"    ,      0xE8   ,    0  ,C_H_M320, C_L_M320 } ,
        {(unsigned char*) "EIP"    ,      0XF8   ,    0  ,C_H_M320, C_L_M320 } ,
        {(unsigned char*) "P1",         0x90,      1, C_H_M320, C_L_M320 },
        {(unsigned char*) "P2",         0xA0,      1, C_H_M320, C_L_M320 },
        {(unsigned char*) "P3",         0xB0,      1, C_H_M320, C_L_M320 },
        {(unsigned char* )  "",         0x00,       0,
        0x0000} };    /* End of the table */

 SFRNAME SFRbitCL31_550[]={
 /*                 Bit-Name    Addr-Base   SfrAttr     CPUmode */
 { "IT0",       0x88,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80C550|C_H_M83C550|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410 ,
 C_L_M80CL580|C_L_M83CL580|C_L_M80C550|C_L_M83C550|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410 },
 { "IE0",       0x89,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80C550|C_H_M83C550|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410 ,
 C_L_M80CL580|C_L_M83CL580|C_L_M80C550|C_L_M83C550|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410 },
 { "IT1",       0x8A,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80C550|C_H_M83C550|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410 ,
 C_L_M80CL580|C_L_M83CL580|C_L_M80C550|C_L_M83C550|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410 },
 { "IE1",       0x8B,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80C550|C_H_M83C550|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410 ,
 C_L_M80CL580|C_L_M83CL580|C_L_M80C550|C_L_M83C550|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410 },
 { "TR0",       0x8C,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80C550|C_H_M83C550|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410 ,
 C_L_M80CL580|C_L_M83CL580|C_L_M80C550|C_L_M83C550|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410 },
 { "TF0",       0x8D,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80C550|C_H_M83C550|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410 ,
 C_L_M80CL580|C_L_M83CL580|C_L_M80C550|C_L_M83C550|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410 },
 { "TR1",       0x8E,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80C550|C_H_M83C550|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410 ,
 C_L_M80CL580|C_L_M83CL580|C_L_M80C550|C_L_M83C550|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410 },
 { "TF1",       0x8F,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80C550|C_H_M83C550|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410 ,
 C_L_M80CL580|C_L_M83CL580|C_L_M80C550|C_L_M83C550|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410 },
 { "RI",        0x98,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80C550|C_H_M83C550|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782,
 C_L_M80CL580|C_L_M83CL580|C_L_M80C550|C_L_M83C550|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782  },
 { "TI",        0x99,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80C550|C_H_M83C550|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782,
 C_L_M80CL580|C_L_M83CL580|C_L_M80C550|C_L_M83C550|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782  },
 { "RB8",       0x9A,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80C550|C_H_M83C550|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782,
 C_L_M80CL580|C_L_M83CL580|C_L_M80C550|C_L_M83C550|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782  },
 { "TB8",       0x9B,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80C550|C_H_M83C550|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782,
 C_L_M80CL580|C_L_M83CL580|C_L_M80C550|C_L_M83C550|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782  },
 { "REN",       0x9C,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80C550|C_H_M83C550|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782,
 C_L_M80CL580|C_L_M83CL580|C_L_M80C550|C_L_M83C550|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782  },
 { "SM2",       0x9D,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80C550|C_H_M83C550|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782,
 C_L_M80CL580|C_L_M83CL580|C_L_M80C550|C_L_M83C550|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782  },
 { "SM1",       0x9E,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80C550|C_H_M83C550|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782,
 C_L_M80CL580|C_L_M83CL580|C_L_M80C550|C_L_M83C550|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782  },
 { "SM0",       0x9F,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80C550|C_H_M83C550|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782,
 C_L_M80CL580|C_L_M83CL580|C_L_M80C550|C_L_M83C550|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782  },
 { "EX0",       0xA8,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80C550|C_H_M83C550|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410 ,
 C_L_M80CL580|C_L_M83CL580|C_L_M80C550|C_L_M83C550|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410 },
 { "ET0",       0xA9,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80C550|C_H_M83C550|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410 ,
 C_L_M80CL580|C_L_M83CL580|C_L_M80C550|C_L_M83C550|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410 },
 { "EX1",       0xAA,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80C550|C_H_M83C550|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410 ,
 C_L_M80CL580|C_L_M83CL580|C_L_M80C550|C_L_M83C550|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410 },
 { "ET1",       0xAB,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80C550|C_H_M83C550|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410 ,
 C_L_M80CL580|C_L_M83CL580|C_L_M80C550|C_L_M83C550|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410 },
 { "ES",        0xAC,   0 ,   C_H_M80C550|C_H_M83C550,
 C_L_M80C550|C_L_M83C550  },
 { "ES0",       0xAC,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782,
 C_L_M80CL580|C_L_M83CL580|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782  },
 { "EAD",       0xAD,   0 ,   C_H_M80C550|C_H_M83C550 ,
  C_L_M80C550|C_L_M83C550  },
 { "ES1",       0xAD,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410 ,
 C_L_M80CL580|C_L_M83CL580|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410 },
 { "EWD",       0xAE,   0 ,   C_H_M80C550|C_H_M83C550,
 C_L_M80C550|C_L_M83C550  },
 { "ET2",       0xAE,   0 ,   C_H_M83CL781|C_H_M83CL782|C_H_M80CL580|C_H_M83CL580,
 C_L_M83CL781|C_L_M83CL782|C_L_M80CL580|C_L_M83CL580  },
 { "EA",        0xAF,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80C550|C_H_M83C550|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410,
 C_L_M80CL580|C_L_M83CL580|C_L_M80C550|C_L_M83C550|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410 },
 { "PX0",       0xB8,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80C550|C_H_M83C550|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410,
 C_L_M80CL580|C_L_M83CL580|C_L_M80C550|C_L_M83C550|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410 },
 { "PT0",       0xB9,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80C550|C_H_M83C550|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410,
 C_L_M80CL580|C_L_M83CL580|C_L_M80C550|C_L_M83C550|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410 },
 { "PX1",       0xBA,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80C550|C_H_M83C550|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410,
 C_L_M80CL580|C_L_M83CL580|C_L_M80C550|C_L_M83C550|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410 },
 { "PT1",       0xBB,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80C550|C_H_M83C550|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410,
 C_L_M80CL580|C_L_M83CL580|C_L_M80C550|C_L_M83C550|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410 },
 { "PS",        0xBC,   0 ,   C_H_M80C550|C_H_M83C550 ,
  C_L_M80C550|C_L_M83C550   },
 { "PS0",       0xBC,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782,
 C_L_M80CL580|C_L_M83CL580|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782  },
 { "PS1",       0xBD,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410,
 C_L_M80CL580|C_L_M83CL580|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410 },
 { "PAD",       0xBD,   0 ,   C_H_M80C550|C_H_M83C550 ,
 C_L_M80C550|C_L_M83C550  },
 { "PT2",       0xBE,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M83CL781|C_H_M83CL782,
 C_L_M80CL580|C_L_M83CL580|C_L_M83CL781|C_L_M83CL782 },
 { "PWD",       0xBE,   0 ,   C_H_M80C550|C_H_M83C550,C_L_M80C550|C_L_M83C550 },
 { "WDMOD",     0xC0,   0 ,   C_H_M80C550|C_H_M83C550,C_L_M80C550|C_L_M83C550 },
 { "WDTOF",     0xC1,   0 ,   C_H_M80C550|C_H_M83C550,C_L_M80C550|C_L_M83C550 },
 { "WDRUN",     0xC2,   0 ,   C_H_M80C550|C_H_M83C550,C_L_M80C550|C_L_M83C550 },
 { "PRE0",      0xC5,   0 ,   C_H_M80C550|C_H_M83C550,C_L_M80C550|C_L_M83C550 },
 { "PRE1",      0xC6,   0 ,   C_H_M80C550|C_H_M83C550,C_L_M80C550|C_L_M83C550 },
 { "PRE2",      0xC7,   0 ,   C_H_M80C550|C_H_M83C550,C_L_M80C550|C_L_M83C550 },
 { "IQ2",       0xC0,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410,
 C_L_M80CL580|C_L_M83CL580|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410 },
 { "IQ3",       0xC1,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410,
 C_L_M80CL580|C_L_M83CL580|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410 },
 { "IQ4",       0xC2,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410,
 C_L_M80CL580|C_L_M83CL580|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410 },
 { "IQ5",       0xC3,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410,
 C_L_M80CL580|C_L_M83CL580|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410 },
 { "IQ6",       0xC4,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410,
 C_L_M80CL580|C_L_M83CL580|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410 },
 { "IQ7",       0xC5,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410,
 C_L_M80CL580|C_L_M83CL580|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410 },
 { "IQ8",       0xC6,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410,
 C_L_M80CL580|C_L_M83CL580|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410 },
 { "IQ9",       0xC7,   0 ,   C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410,
 C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410 },
 { "CP/RL2",    0xC8,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M83CL781|C_H_M83CL782,C_L_M80CL580|C_L_M83CL580|C_L_M83CL781|C_L_M83CL782  },
 { "C/T2",      0xC9,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M83CL781|C_H_M83CL782,C_L_M80CL580|C_L_M83CL580|C_L_M83CL781|C_L_M83CL782  },
 { "TR2",       0xCA,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M83CL781|C_H_M83CL782,C_L_M80CL580|C_L_M83CL580|C_L_M83CL781|C_L_M83CL782  },
 { "EXEN2",     0xCB,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M83CL781|C_H_M83CL782,C_L_M80CL580|C_L_M83CL580|C_L_M83CL781|C_L_M83CL782  },
 { "RTCLK",     0xCC,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M83CL781|C_H_M83CL782,C_L_M80CL580|C_L_M83CL580|C_L_M83CL781|C_L_M83CL782  },
 { "GF2",       0xCD,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M83CL781|C_H_M83CL782,C_L_M80CL580|C_L_M83CL580|C_L_M83CL781|C_L_M83CL782  },
 { "EXF2",      0xCE,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M83CL781|C_H_M83CL782,C_L_M80CL580|C_L_M83CL580|C_L_M83CL781|C_L_M83CL782  },
 { "TF2",       0xCF,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M83CL781|C_H_M83CL782,C_L_M80CL580|C_L_M83CL580|C_L_M83CL781|C_L_M83CL782  },
 { "P",         0xD0,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80C550|C_H_M83C550|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410,
 C_L_M80CL580|C_L_M83CL580|C_L_M80C550|C_L_M83C550|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410 },
 { "OV",        0xD2,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80C550|C_H_M83C550|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410,
 C_L_M80CL580|C_L_M83CL580|C_L_M80C550|C_L_M83C550|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410 },
 { "RS0",       0xD3,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80C550|C_H_M83C550|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410,
 C_L_M80CL580|C_L_M83CL580|C_L_M80C550|C_L_M83C550|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410 },
 { "RS1",       0xD4,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80C550|C_H_M83C550|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410,
 C_L_M80CL580|C_L_M83CL580|C_L_M80C550|C_L_M83C550|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410 },
 { "F0",        0xD5,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80C550|C_H_M83C550|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410,
 C_L_M80CL580|C_L_M83CL580|C_L_M80C550|C_L_M83C550|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410 },
 { "AC",        0xD6,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80C550|C_H_M83C550|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410,
 C_L_M80CL580|C_L_M83CL580|C_L_M80C550|C_L_M83C550|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410 },
 { "C",         0xD7,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80C550|C_H_M83C550|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410,
 C_L_M80CL580|C_L_M83CL580|C_L_M80C550|C_L_M83C550|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410 },
 { "CY",        0xD7,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80C550|C_H_M83C550|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410,
 C_L_M80CL580|C_L_M83CL580|C_L_M80C550|C_L_M83C550|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410 },
 { "CR0",       0xD8,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410,C_L_M80CL580|C_L_M83CL580|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410 },
 { "CR1",       0xD9,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410,C_L_M80CL580|C_L_M83CL580|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410 },
 { "AA",        0xDA,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410,C_L_M80CL580|C_L_M83CL580|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410 },
 { "SI",        0xDB,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410,C_L_M80CL580|C_L_M83CL580|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410 },
 { "STO",       0xDC,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410,C_L_M80CL580|C_L_M83CL580|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410 },
 { "STA",       0xDD,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410,C_L_M80CL580|C_L_M83CL580|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410 },
 { "ENS1",      0xDE,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410,C_L_M80CL580|C_L_M83CL580|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410 },
 { "CR2",       0xDF,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410,C_L_M80CL580|C_L_M83CL580|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410 },
 { "EX2",       0xE8,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410,
 C_L_M80CL580|C_L_M83CL580|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410 },
 { "EX3",       0xE9,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410,
 C_L_M80CL580|C_L_M83CL580|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410 },
 { "EX4",       0xEA,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410,
 C_L_M80CL580|C_L_M83CL580|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410 },
 { "EX5",       0xEB,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410,
 C_L_M80CL580|C_L_M83CL580|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410 },
 { "EX6",       0xEC,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410,
 C_L_M80CL580|C_L_M83CL580|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410 },
 { "EX7",       0xED,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410,
 C_L_M80CL580|C_L_M83CL580|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410 },
 { "EX8",       0xEE,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410,
 C_L_M80CL580|C_L_M83CL580|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410},
 { "EAD",       0xEF,   0 ,   C_H_M80CL580|C_H_M83CL580,
 C_L_M80CL580|C_L_M83CL580 },
 { "EX9",       0xEF,   0 ,   C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410,
 C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410 },
 { "PX2",       0xF8,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410, C_L_M80CL580|C_L_M83CL580|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410  },
 { "PX3",       0xF9,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410, C_L_M80CL580|C_L_M83CL580|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410  },
 { "PX4",       0xFA,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410, C_L_M80CL580|C_L_M83CL580|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410  },
 { "PX5",       0xFB,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410, C_L_M80CL580|C_L_M83CL580|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410  },
 { "PX6",       0xFC,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410, C_L_M80CL580|C_L_M83CL580|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410  },
 { "PX7",       0xFD,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410, C_L_M80CL580|C_L_M83CL580|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410  },
 { "PX8",       0xFE,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410, C_L_M80CL580|C_L_M83CL580|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410  },
 { "PX9",       0xFF,   0 ,   C_H_M80CL580|C_H_M83CL580|C_H_M80CL31|C_H_M80CL51|C_H_M83CL781|C_H_M83CL782|C_H_M80CL410|C_H_M83CL410, C_L_M80CL580|C_L_M83CL580|C_L_M80CL31|C_L_M80CL51|C_L_M83CL781|C_L_M83CL782|C_L_M80CL410|C_L_M83CL410  },
 {(unsigned char* )  "",         0x00,       0,
  0x0000} };    /* End of the table */

 SFRNAME SFRbitCL320[]={
 /*                 Bit-Name    Addr-Base   SfrAttr     CPUmode */
   { "IT0",       0x88,  0 ,      C_H_M320,C_L_M320},
   { "IE0",       0x89,  0 ,      C_H_M320,C_L_M320},
   { "IT1",       0x8A,  0 ,      C_H_M320,C_L_M320},
   { "IE1",       0x8B,  0 ,      C_H_M320,C_L_M320},
   { "TR0",       0x8C,  0 ,      C_H_M320,C_L_M320},
   { "TF0",       0x8D,  0 ,      C_H_M320,C_L_M320},
   { "TR1",       0x8E,  0 ,      C_H_M320,C_L_M320},
   { "TF1",       0x8F,  0 ,      C_H_M320,C_L_M320},
   { "RI",        0x98,  0 ,      C_H_M320,C_L_M320 },
   { "TI",        0x99,  0 ,      C_H_M320,C_L_M320 },
   { "RB8",       0x9A,  0 ,      C_H_M320,C_L_M320 },
   { "TB8",       0x9B,  0 ,      C_H_M320,C_L_M320 },
   { "REN",       0x9C,  0 ,      C_H_M320,C_L_M320 },
   { "SM2",       0x9D,  0 ,      C_H_M320,C_L_M320 },
   { "SM1",       0x9E,  0 ,      C_H_M320,C_L_M320 },
   { "SM0/FE",    0x9F,  0 ,      C_H_M320,C_L_M320 },
   { "EX0",       0xA8,  0 ,      C_H_M320,C_L_M320 },
   { "ET0",       0xA9,  0 ,      C_H_M320,C_L_M320 },
   { "EX1",       0xAA,  0 ,      C_H_M320,C_L_M320 },
   { "ET1",       0xAB,  0 ,      C_H_M320,C_L_M320 },
   { "ES0",       0xAC,  0 ,      C_H_M320,C_L_M320 },
   { "ET2",       0xAD,  0 ,      C_H_M320,C_L_M320 },
   { "ES1",       0xAE,  0 ,      C_H_M320,C_L_M320 },
   { "EA",        0xAF,  0 ,      C_H_M320,C_L_M320 },
   { "PX0",       0xB8,  0 ,      C_H_M320,C_L_M320 },
   { "PT0",       0xB9,  0 ,      C_H_M320,C_L_M320 },
   { "PX1",       0xBA,  0 ,      C_H_M320,C_L_M320 },
   { "PT1",       0xBB,  0 ,      C_H_M320,C_L_M320 },
   { "PS0",       0xBC,  0 ,      C_H_M320,C_L_M320 },
   { "PT2",       0xBD,  0 ,      C_H_M320,C_L_M320 },
   { "PS1",       0xBE,  0 ,      C_H_M320,C_L_M320 },
   { "CP/RL2",    0xC8,  0 ,      C_H_M320,C_L_M320 },
   { "C/T2",      0xC9,  0 ,      C_H_M320,C_L_M320 },
   { "TR2",       0xCA,  0 ,      C_H_M320,C_L_M320 },
   { "EXEN2",     0xCB,  0 ,      C_H_M320,C_L_M320 },
   { "TCLK",      0xCC,  0 ,      C_H_M320,C_L_M320 },
   { "RCLK",      0xCD,  0 ,      C_H_M320,C_L_M320 },
   { "EXF2",      0xCE,  0 ,      C_H_M320,C_L_M320 },
   { "TF2",       0xCF,  0 ,      C_H_M320,C_L_M320 },
   { "P",         0xD0,  0 ,      C_H_M320,C_L_M320 },
   { "FL",        0xD1,  0 ,      C_H_M320,C_L_M320 },
   { "OV",        0xD2,  0 ,      C_H_M320,C_L_M320 },
   { "RS0",       0xD3,  0 ,      C_H_M320,C_L_M320 },
   { "RS1",       0xD4,  0 ,      C_H_M320,C_L_M320 },
   { "F0",        0xD5,  0 ,      C_H_M320,C_L_M320 },
   { "AC",        0xD6,  0 ,      C_H_M320,C_L_M320 },
   { "C",         0xD7,  0 ,      C_H_M320,C_L_M320 },
   { "CY",        0xD7,  0 ,      C_H_M320,C_L_M320 },
   { "RWT",       0xD8,  0 ,      C_H_M320,C_L_M320 },
   { "EWT",       0xD9,  0 ,      C_H_M320,C_L_M320 },
   { "WTRF",      0xDA,  0 ,     C_H_M320,C_L_M320 },
   { "WDIF",      0xDB,  0 ,     C_H_M320,C_L_M320 },
   { "PFI",       0xDC,  0 ,     C_H_M320,C_L_M320 },
   { "EPFI",      0xDD,  0 ,     C_H_M320,C_L_M320 },
   { "POR",       0xDE,  0 ,     C_H_M320,C_L_M320 },
   { "SMOD",      0xDF,  0 ,     C_H_M320,C_L_M320 },
   { "EX2",       0xE8,  0 ,     C_H_M320,C_L_M320 },
   { "EX3",       0xE9,  0 ,     C_H_M320,C_L_M320 },
   { "EX4",       0xEA,  0 ,     C_H_M320,C_L_M320 },
   { "EX5",       0xEB,  0 ,     C_H_M320,C_L_M320 },
   { "EWDI",      0xEC,  0 ,     C_H_M320,C_L_M320 },
   { "PX2",       0xF8,  0 ,     C_H_M320,C_L_M320 },
   { "PX3",       0xF9,  0 ,     C_H_M320,C_L_M320 },
   { "PX4",       0xFA,  0 ,     C_H_M320,C_L_M320 },
   { "PX5",       0xFB,  0 ,     C_H_M320,C_L_M320 },
   { "PWDI",      0xFC,  0 ,     C_H_M320,C_L_M320 },
   {(unsigned char* )  "",         0x00,       0,
   0x0000} };    /* End of the table */

// this table is added by john 96.1.19 to support new trace of 320
   unsigned char CycleLen[256] = 
                                 {  1  ,   // instruction ff
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    2  ,
                                    1  ,
                                    3  ,
                                    3  ,
                                    3  ,
                                    3  ,
                                       
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    2  ,
                                    1  ,
                                    3  ,
                                    3  ,
                                    3  ,
                                    3  ,
                                       
                                    3  ,
                                    3  ,
                                    3  ,
                                    3  ,
                                    3  ,
                                    3  ,
                                    3  ,
                                    3  ,
                                    1  ,
                                    1  ,
                                    4  ,
                                    1  ,
                                    1  ,
                                    2  ,
                                    3  ,
                                    2  ,
                                       
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    2  ,
                                    1  ,
                                    1  ,
                                    2  ,
                                    3  ,
                                    2  ,
                                       
                                    4  ,
                                    4  ,
                                    4  ,
                                    4  ,
                                    4  ,
                                    4  ,
                                    4  ,
                                    4  ,
                                    4  ,
                                    4  ,
                                    4  ,
                                    4  ,
                                    1  ,
                                    2  ,
                                    3  ,
                                    2  ,
                                       
                                    2  ,
                                    2  ,
                                    2  ,
                                    2  ,
                                    2  ,
                                    2  ,
                                    2  ,
                                    2  ,
                                    2  ,
                                    2  ,
                                    1  ,
                                    5  ,
                                    3  ,
                                    2  ,
                                    3  ,
                                    2  ,
                                       
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    2  ,
                                    2  ,
                                    3  ,
                                    2  ,
                                    3  ,
                                    3  ,
                                       
                                    2  ,
                                    2  ,
                                    2  ,
                                    2  ,
                                    2  ,
                                    2  ,
                                    2  ,
                                    2  ,
                                    2  ,
                                    2  ,
                                    3  ,
                                    5  ,
                                    3  ,
                                    2  ,
                                    3  ,
                                    3  ,
                                       
                                    2  ,
                                    2  ,
                                    2  ,
                                    2  ,
                                    2  ,
                                    2  ,
                                    2  ,
                                    2  ,
                                    2  ,
                                    2  ,
                                    3  ,
                                    2  ,
                                    3  ,
                                    2  ,
                                    3  ,
                                    3  ,
                                       
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    2  ,
                                    1  ,
                                    3  ,
                                    1  ,
                                    3  ,
                                    3  ,
                                       
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    2  ,
                                    2  ,
                                    3  ,
                                    2  ,
                                    3  ,
                                    3  ,
                                       
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    2  ,
                                    2  ,
                                    3  ,
                                    2  ,
                                    2  ,
                                    3  ,
                                       
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    2  ,
                                    2  ,
                                    1  ,
                                    4  ,
                                    3  ,
                                    4  ,
                                       
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    2  ,
                                    2  ,
                                    1  ,
                                    4  ,
                                    3  ,
                                    4  ,
                                       
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    2  ,
                                    2  ,
                                    1  ,
                                    4  ,
                                    3  ,
                                    4  ,
                                       
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    1  ,
                                    2  ,
                                    1  ,
                                    1  ,
                                    4  ,
                                    3  ,
                                    1      };  //instruction 00



//this function return 0 if string x== string y
//it be sensitive to UP OR low characters
int StrCmpLib(unsigned char *x,unsigned char *y)
{
 int i;
 i=0;
 do{
   if(x[i]!=y[i]) return -1;
   i++;
   }while(x[i-1]!=0);
 return 0;
 }


//libmain
int WINAPI CALLBACK LibMain(HANDLE hModule,
                        WORD wDataSegment,
                        WORD wHeapSize,
                        LPSTR lpszCmdLine)

{
 return 1;
}

//decide which table to be used added by john 96.1
void TblSel(unsigned long Module_H,unsigned long Module_L)
{
 //ASSERT((Module_H == 0) || (Module_L ==0));
 //ASSERT(!((Module_H == 0) && (Module_L ==0)));
 unsigned int cpuId;
 unsigned int i;

 if (Module_H!=0)
  {
   i=0;
   do
    {
     Module_H >>=1;
     i++;
     } while(Module_H!=0);
   cpuId = 32 + i - 1;
   }
  else
   {
    i=0;
    do
     {
      Module_L >>=1;
      i++;
      } while(Module_L!=0);
    cpuId = i - 1;
    }

  switch (cpuId)
   {
     case 28 :   //=  EP80C550
     case 29 :   //=  EP83C550
              sByteTblPoint = SFRbyteCL550;
              sBitTblPoint = SFRbitCL31_550;
              break;
     case 34 :   //=  EP80CL31
     case 35 :   //=  EP80CL51    
              sByteTblPoint = SFRbyteCL3151;
              sBitTblPoint =  SFRbitCL31_550;
              break;
     case 42 :   //=  EP80CL410
     case 43 :   //=  EP83CL410
              sByteTblPoint = SFRbyteCL410;
              sBitTblPoint =  SFRbitCL31_550;
              break;
     case 45 :   //=  EP83CL781
     case 47 :   //=  EP83CL782
              sByteTblPoint =  SFRbyteCL781782;
              sBitTblPoint =   SFRbitCL31_550;
              break;
     case 48 :   //=  EP80CL580
     case 49 :   //=  EP83CL580
              sByteTblPoint = SFRbyteCL580;
              sBitTblPoint =  SFRbitCL31_550;
              break;
     case 50 :   //=  EP320 
              sByteTblPoint = SFRbyte320;
              sBitTblPoint = SFRbitCL320;
              break;
     default :              
              sByteTblPoint = SFRbyte;
              sBitTblPoint = SFRbit;
    }


 }



//This function get the SFR Symbol name's index in SFRbyte by
//absolute address
int WINAPI _export GetByteSFRSymbolIndex(unsigned char Addr,SFRNAME *SFRbitRet,
                                         unsigned long Module_H,unsigned long Module_L)
 {
   int i,GetOk;

   i=0;    GetOk=0; 
   
   TblSel(Module_H,Module_L);

   while (!GetOk && *(sByteTblPoint[i].Name)!=0)
    {
      if(((sByteTblPoint[i].AvailableCPU_H&Module_H)==Module_H)
        &&((sByteTblPoint[i].AvailableCPU_L&Module_L)==Module_L)
        && sByteTblPoint[i].DirAddr==Addr)
         GetOk=1;
      i++;
      }

   if(GetOk)
    {
     int iTmp=0;
     while(TRUE)
      {
       SFRbitRet->Name[iTmp]=sByteTblPoint[i-1].Name[iTmp];
       if(sByteTblPoint[i-1].Name[iTmp]==0) break;
       iTmp++;
       }
     SFRbitRet->DirAddr=sByteTblPoint[i-1].DirAddr;
     SFRbitRet->SfrAttr=sByteTblPoint[i-1].SfrAttr;
     SFRbitRet->AvailableCPU_H=sByteTblPoint[i-1].AvailableCPU_H;
     SFRbitRet->AvailableCPU_L=sByteTblPoint[i-1].AvailableCPU_L;
     return i-1;
     }
     else return -1;

   }
//return:>=0 refer to getting ok; return value refer to index based on 0
//       <0  refer to failure

//This function get the SFR Symbol name's index in SFRbit by
//absolute address
int WINAPI _export GetBitSFRSymbolIndex(unsigned char Addr,SFRNAME *SFRbitRet,
                                        unsigned long Module_H,unsigned long Module_L)
{
   int i,GetOk;

   i=0;    GetOk=0;          
   
   TblSel(Module_H,Module_L);

   while (!GetOk && *(sBitTblPoint[i].Name)!=0)
    {
      if(((sBitTblPoint[i].AvailableCPU_H&Module_H)==Module_H)
        &&((sBitTblPoint[i].AvailableCPU_L&Module_L)==Module_L)
        && sBitTblPoint[i].DirAddr==Addr)
         GetOk=1;
      i++;
      }

   if(GetOk)
    {
     int iTmp=0;
     while(TRUE)
      {
       SFRbitRet->Name[iTmp]=sBitTblPoint[i-1].Name[iTmp];
       if(sBitTblPoint[i-1].Name[iTmp]==0) break;
       iTmp++;
       }
     SFRbitRet->DirAddr=sBitTblPoint[i-1].DirAddr;
     SFRbitRet->SfrAttr=sBitTblPoint[i-1].SfrAttr;
     SFRbitRet->AvailableCPU_H=sBitTblPoint[i-1].AvailableCPU_H;
     SFRbitRet->AvailableCPU_L=sBitTblPoint[i-1].AvailableCPU_L;
     return i-1;
     }
     else return -1;

   }
//return: >=0 refer to getting ok; return value refer to index based on 0
//        <0  refer to failure

//This function get the SFR absolute address's index in SFRbyte by
//symbol name
int WINAPI _export GetByteSFRAddrIndex(unsigned char *SFRNameBuf,SFRNAME *SFRbitRet,
                                       unsigned long Module_H,unsigned long Module_L)
                                        //SFRName need not to be in CAPS
{
  int i,GetOk;
  unsigned char SFRName[255];
  i=0;    GetOk=0;
                             
  TblSel(Module_H,Module_L);                             
                             
  //convert Low characters to UPCASE
  while (*SFRNameBuf!=0)
   {
    SFRName[i]=(*SFRNameBuf>=(unsigned char)'a' && *SFRNameBuf<=(unsigned char)'z')
    ? (unsigned char)(*SFRNameBuf-'a'+'A')
    : (unsigned char)(*SFRNameBuf);
    i++;  SFRNameBuf++;
    if(i>250) return -2;//refer to too long string;
    }
  SFRName[i]=0;
  i=0;

  while (!GetOk && *(sByteTblPoint[i].Name)!=0)
   {
     if(((sByteTblPoint[i].AvailableCPU_H&Module_H)==Module_H)
        &&((sByteTblPoint[i].AvailableCPU_L&Module_L)==Module_L)
        && StrCmpLib(sByteTblPoint[i].Name,SFRName)==0)
        GetOk=1;
     i++;
     }

   if(GetOk)
    {
     int iTmp=0;
     while(TRUE)
      {
       SFRbitRet->Name[iTmp]=sByteTblPoint[i-1].Name[iTmp];
       if(sByteTblPoint[i-1].Name[iTmp]==0) break;
       iTmp++;
       }
     SFRbitRet->DirAddr=sByteTblPoint[i-1].DirAddr;
     SFRbitRet->SfrAttr=sByteTblPoint[i-1].SfrAttr;
     SFRbitRet->AvailableCPU_H=sByteTblPoint[i-1].AvailableCPU_H;
     SFRbitRet->AvailableCPU_L=sByteTblPoint[i-1].AvailableCPU_L;
     return i-1;
     }
     else return -1;


  }
//return: >=0 refer to getting ok; return value refer to index based on 0
//        <0  refer to failure

//This function get the SFR absolute address's index in SFRbit by
//symbol name
int WINAPI _export GetBitSFRAddrIndex(unsigned char *SFRNameBuf,SFRNAME *SFRbitRet,
                                      unsigned long Module_H,unsigned long Module_L)
                                        //SFRName need not to be in CAPS
{
  int i,GetOk;
  unsigned char SFRName[255];

  i=0;    GetOk=0;          
  
  TblSel(Module_H,Module_L);

  //convert Low characters to UPCASE
  while (*SFRNameBuf!=0)
   {
    SFRName[i]=(*SFRNameBuf>=(unsigned char)'a' && *SFRNameBuf<=(unsigned char)'z')
    ? (unsigned char)(*SFRNameBuf-'a'+'A')
    : (unsigned char)(*SFRNameBuf);
    i++; SFRNameBuf++;
    if(i>250) return -2;//refer to too long string;
    }
  SFRName[i]=0;
  i=0;

  while (!GetOk && *(sBitTblPoint[i].Name)!=0)
   {
     if(((sBitTblPoint[i].AvailableCPU_H&Module_H)==Module_H)
        &&((sBitTblPoint[i].AvailableCPU_L&Module_L)==Module_L)
        && StrCmpLib(sBitTblPoint[i].Name,SFRName)==0)
        GetOk=1;
     i++;
     }

   if(GetOk)
    {
     int iTmp=0;
     while(TRUE)
      {
       SFRbitRet->Name[iTmp]=sBitTblPoint[i-1].Name[iTmp];
       if(sBitTblPoint[i-1].Name[iTmp]==0) break;
       iTmp++;
       }
     SFRbitRet->DirAddr=sBitTblPoint[i-1].DirAddr;
     SFRbitRet->SfrAttr=sBitTblPoint[i-1].SfrAttr;
     SFRbitRet->AvailableCPU_H=sBitTblPoint[i-1].AvailableCPU_H;
     SFRbitRet->AvailableCPU_L=sBitTblPoint[i-1].AvailableCPU_L;
     return i-1;
     }
     else return -1;

   }
//return: >=0 refer to getting ok; return value refer to index based on 0
//        <0  refer to failure

unsigned char WINAPI _export TRCGetCycleLen320(unsigned char instruction)
{ 
 return CycleLen[0xff-instruction];
 }


/************************ END OF FILE ***********************************/
