
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/LDRUBROF.CPP   1.8   20 Jun 1996 09:30:46   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/LDRUBROF.CPP  $
** 
**    Rev 1.8   20 Jun 1996 09:30:46   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.6   10 Jun 1996 10:25:26   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.4   29 May 1996 09:38:22   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:00:40   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:15:06   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:22:58   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 13:02:46   Shirley
** EasyPack/SLD Version 1.91
** 
**    Rev 1.30   12 Apr 1996 10:36:50   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:49:50   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:02:18   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:27:32   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:43:10   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:16:04   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:12:54   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:13:34   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:39:20   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:28:10   Shirley
** EasypPack/SLD Version 0.34c
** 
**    Rev 1.19   18 Jan 1996 10:10:06   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:17:20   Shirley
** EasyPack/SLD Version 0.34a
** 
**    Rev 1.17   04 Jan 1996 11:11:54   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:08:32   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:35:04   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:24:20   Shirley
** EasyPack/SLD Version 0.31
** 
**    Rev 1.13   13 Nov 1995 09:25:02   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:29:28   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:32:54   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:42:16   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:06:34   Shirley
** EasyPack/SLD Version 0.21
** 
**    Rev 1.8   27 Oct 1995 16:50:10   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:44:32   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:28:12   Shirley
** EasyPack/SLD Version 0.1f
** 
**    Rev 1.5   18 Oct 1995 14:52:24   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:21:52   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:52:10   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:53:36   Shirley
** EasyPack/SLD Version 0.1b
** 
**    Rev 1.1   15 Sep 1995 09:48:18   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:54:34   Shirley
** Initial revision.
**
****************************************************************************/

/****************************************************************************
**
**  Name:  LDRUBROF.C
**
**  Description:
**      Entry points for UBROF 8051 Loader.
**
**  Status:  CODED
**
**    Rev 1.0   1 Sept. 1995 8:30:00am   Gates Hua
** Initial revision.
**
**  Copyright (C) 1995 Microtek International.  All rights reserved.
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#include "stdafx.h"
#include <ctype.h>
#include <io.h>
#include <sys\timeb.h>
#include <time.h>
#include <fcntl.h>
#include <sys\stat.h>

#include "symblsvr.h"
#include "ldr.h"           
#include "ldrubrof.h"
#include "uicom.h"
#include "abibase.h"

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/
struct attrCC {
    unsigned int num ;
    unsigned long attr ;
    unsigned int type ;
    struct attrCC *next;
    
public :
    attrCC() {
        num = 0;
        attr = 0;
        type = 0;
        next = 0;
    }
};

typedef struct {
    SEGMENTTYPE type;
    U32 addr;
} ORG_ADDRESS;

typedef struct {
    ORG_ADDRESS start;
    ORG_ADDRESS end;
    int flag;
} STATE_ADDR;

STATE_ADDR stat_addr ;
U32 start , end;
ORG_ADDRESS curAddr;
U8 LineNumInfo[16] , SymDefInfo[51] , OldKey;
struct BlockBlock far *curBlock ;
struct StoreExtendVar *varExtHdrPtr = 0 , *varExtPtr = 0;
struct attrCC *attrExtHdrPtr = 0 , *attrExtPtr = 0;

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/
extern SYM_DESCRIPTOR curModDesc;
extern U32 uLoadBytes;

                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/
void UbrofSegIdToEnum(U8 ui , SEGMENTTYPE* type);
void UbrofTypeConv(U16& ui);                            
void InitVarExtendLink( void );
void MatchFuncType( char *str , TYPE_INDEX& typeIndex );

                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/
extern STATUS AbiFill(ADDR addr1, ADDR addr2,char* pchBuff,UINT uPatternLen);

/***************************************************************************
*                                                                          *
*  LdrUbrofLoadProcess - Ubrof Loader main process routine                 *
*  parameter :                                                             *
*       None                                                               *
*  return value :                                                          *
*       0  ---  OK                 -1  ---  failure                        *
*                                                                          *
***************************************************************************/
int LoaderServer::LdrUbrofLoadProcess(void)
{       
    int err;       
    U8 key;

    if (m_lpModuleName) {
/* load module only */
/* Get the module descriptor from moduleName and moduleReference */
        err = LdrUbrofLoadModuleOnly() ;
    }
    else {
        m_startaddress = 0;                                                   
/* load UBROF file all information */
                              
        if ( (err = TestKey(VK_ESCAPE)) == 1 ) {
            m_dwErrorNum = ER_LDR_ABORT;  // 0x4010;
            return( -1 );
        } 
        if ( (m_window == LOAD_FROM_DIALOG)&&(m_ldrFlags & LDR_STATUS) ) {
            if ( IsLoadCanceled() ) {
                m_dwErrorNum = ER_LDR_ABORT; // 0x4010;
                return( -1 );
            }                  
            TestMessage();
        }
        if ( (err = LdrUbrofLoadStarter()) == -1 ) {
            return( -1 );
        }
        if ( (err = LdrUbrofLoadTypes()) == -1 ) {
            return( -1 );
        }
         
        if ( (err = GetOneByte(&key)) == -1 ) {
            m_dwErrorNum = ER_LDR_READ_FILE; // 0x400F;
            return(-1);
        }
        while (key != t_ubrof_eof) {
            switch ( key ) {
            case t_beg_lib :
            case t_beg_pgm :
                err = LdrUbrofGetModule( key , FALSE );
                if (err == -1) return(err);
                break;
            default :
#ifdef _DUMP_
            Message("\r\n???Unknown record at file %lx",GetFileCurPos()-1);
#endif
                m_dwErrorNum = ER_LDR_READ_FILE;   // 0x400F;
                return(-1);
                break;
            }
            if ( (err = GetOneByte(&key)) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;   // 0x400F;
                return(-1);
            }
        }   
    } 
    return (err);
}

/***************************************************************************
*                                                                          *
*  LdrUbrofLoadModuleOnly - Ubrof Loader a module only                     *
*  parameter :                                                             *
*       None                                                               *
*  return value :                                                          *
*       0  ---  OK                 -1  ---  failure                        *
*                                                                          *
***************************************************************************/
int LoaderServer::LdrUbrofLoadModuleOnly(void)
{
    int err;                                                       
    char *lpStr;                           
    char *lpModule;                    
    U32 moduleOffset , ul;    
    U8 key;
    RETCODE retCode ;
    
    err = lstrlen(m_lpModuleName);
    lpModule = new char[err+1];
    ASSERT( lpModule );
    if ( lpModule == 0 ) {
        m_dwErrorNum = ER_LDR_MEMORY_ALLOC;     // 0x4000;
        return(-1);
    }
        
    lstrcpy(lpModule , m_lpModuleName);
//    lpStr = strstr("." , lpModule);
    lpStr = strstr(lpModule , ".");
    if (lpStr) *lpStr = '\0';        

    retCode = SymAddLoadStart(
            m_lpFileName,
            TRUE,
            &m_time );
    if ( retCode != GOOD ) {
        m_dwErrorNum = ER_LDR_SYM_SERVER; // 0x4025;
        return( FAILURE );
    }
    err = (U16) SymAddModuleOpenByDesc( curModDesc , &moduleOffset , &ul );
    if ( err != GOOD ) {
        m_dwErrorNum = ER_LDR_LOAD_MODULE;   // 0x4021;
        return(-1);
    }
    if ( m_onDemand == FALSE ) {
        m_dwErrorNum = ER_LDR_MOD_INFO_LOADED;  // 0x4022;
        return 0;
    }
    if ( SeekLoadFile( moduleOffset , 0 )   != 0 ) {
        m_dwErrorNum = ER_LDR_READ_FILE;  // 0x400F;
        return(-1);
    }
    if ( (err = GetOneByte(&key)) == -1 ) {
        m_dwErrorNum = ER_LDR_READ_FILE;  // 0x400F;
        return(-1);
    }      
    err = LdrUbrofGetModule( key , TRUE );
    return(err);               
}

/***************************************************************************
*                                                                          *
*  LdrUbrofLoadModuleByDesc - Load a module local information for OnDemand *
*                   load Only loader block,symbol and linenum information  *
*  parameter :                                                             *
*       offset  --  this module in load file position .                    *
*  return value :                                                          *
*       0  ---  OK                 -1  ---  failure                        *
*                                                                          *
***************************************************************************/
int LoaderServer::LdrUbrofLoadModuleByDesc( U32 offset ) 
{                    
    int err;                                                       
    U8 key;
    int nOldFlags;
    
    nOldFlags = m_ldrFlags;
    m_ldrFlags = 0x1;
    if ( SeekLoadFile( offset , 0 ) != 0 ) {
        m_dwErrorNum = ER_LDR_READ_FILE;  // 0x400F;
        return(-1);
    }
    if ( (err = GetOneByte(&key)) == -1 ) {
        m_dwErrorNum = ER_LDR_READ_FILE;  // 0x400F;
        return(-1);
    }      
    err = LdrUbrofGetModule( key , TRUE );
    m_ldrFlags = nOldFlags;
    return(err);               
}
                        
/***************************************************************************
*                                                                          *
*  LdrUbrofLoadModule - Load a module information by ldrFlags and onDemand *
*  parameter :                                                             *
*       None (Information all in class LoaderServer)                       *
*  return value :                                                          *
*       0  ---  OK                 -1  ---  failure                        *
*                                                                          *
***************************************************************************/
int LoaderServer::LdrUbrofLoadModule(void)
{           
    return 0;
}
                                            
/***************************************************************************
*                                                                          *
*  LdrUbrofLoadStarter - Load UBROF start section                          *
*  parameter :                                                             *
*       None (Information all in class LoaderServer)                       *
*  return value :                                                          *
*       0  ---  OK                 -1  ---  failure                        *
*                                                                          *
***************************************************************************/
int LoaderServer::LdrUbrofLoadStarter(void)
{       
    U8 ch;           
    U8 data[7];     
    RETCODE retCode;
    
    if ( GetOneByte(&ch) == -1 ) {
        m_dwErrorNum = ER_LDR_READ_FILE;  // 0x4014;
        return(FAILURE);                        
    }
    switch ( ch ) {
    case t_beg_file :
        if ( GetBytes(data , 3) == -1 ) {
            m_dwErrorNum = ER_LDR_READ_FILE; // 0x400F;
            return(-1);
        }
        m_time.day = data[0];
        m_time.month = data[1];                
        m_time.year = 1900 ;
        m_time.year +=  ( (U16) data[2] ) ; 
        m_time.hour = -1;
        break;
    case t_beg_file1 :
        if ( GetBytes(data , 6) == -1 ) {
            m_dwErrorNum = ER_LDR_READ_FILE; // 0x400F;
            return(FAILURE);
        }      
        m_time.second = data[0];
        m_time.minute = data[1];
        m_time.hour = data[2];
        m_time.day = data[3];
        m_time.month = data[4];                
        m_time.year = 1900 ;
        m_time.year +=  ( (U16) data[5] ) ; 
        m_time.hour = -1;
        break;
    default :
#ifdef _DUMP_
      Message("\r\n???Unknown record in STARTER at file %lx",
            GetFileCurPos()-1);
#endif
        m_dwErrorNum = ER_LDR_FILE_FORMAT;   // 0x4014;
        return(FAILURE);
        break;
    }   
    if ( LOAD_SYM( m_ldrFlags ) ) {
        CString filename;
        
        filename = m_lpFileName;
        retCode = SymAddLoadStart(
                        filename.GetBuffer(filename.GetLength()) ,
                        FALSE,
                        &m_time );
        if ( retCode != GOOD ) {
            m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025 ;
            return( FAILURE );
        }
    }
                        
    return(GOOD);       
}

/***************************************************************************
*                                                                          *
*  LdrUbrofLoadTypes - Load UBROF types record information                 *
*  parameter :                                                             *
*       None (Information add in symbol server)                            *
*  return value :                                                          *
*       0  ---  OK                 -1  ---  failure                        *
*                                                                          *
***************************************************************************/
int LoaderServer::LdrUbrofLoadTypes(void)
{                                           
    TYPE_HEADER_TYPE typeHdrInfo;
    int i , k , err;
    U8 ch , j;           
    U8 data[LDR_BUFSIZE];
    int flag , symFlag;           
    U16 ui , uj;
    U32 ul;              
    char *nullPtr = "\0";
    RETCODE retCode;
                    
    typeHdrInfo.typeChoice = (TYPE_CLASS) COMPLEX_TYPE_CLASS;
    
    flag = 1;
    m_absflag = 0;    
    symFlag = LOAD_SYM(m_ldrFlags);
    while ( flag ) {
        typeHdrInfo.typeName = nullPtr;                    
        typeHdrInfo.sizeInMAUs = 0;      
        typeHdrInfo.sizeCalculated = FALSE;

        if ( (err = TestKey(VK_ESCAPE)) == 1 ) {
            m_dwErrorNum = ER_LDR_ABORT;  // 0x4010;
            return( -1 );
        } 
        if ( (m_window == LOAD_FROM_DIALOG)&&(m_ldrFlags & LDR_STATUS) ) {
            if ( IsLoadCanceled() ) {
                m_dwErrorNum = ER_LDR_ABORT; // 0x4010;
                return( -1 );
            }                  
            TestMessage();
        }
        if ( GetOneByte(&ch) == -1 ) {
            m_dwErrorNum = ER_LDR_READ_FILE; // 0x4014;
            return(-1);                        
        }                            
        
        switch ( ch ) {
        case t_end :
            if ( GetBytes(data , 2) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;   // 0x400F;
                return(-1);
            }     
            flag = 0;
            break;
        case t_type : /* 0x4A */
            if ( GetBytes(data , 3) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;   // 0x400F;
                return(-1);
            }
            ui = BinToU16(data) + 156;

            j = data[2];
            switch( j ) {
            case t_type_pointer : /* 0x0F */ 
                if ( GetBytes(data , 2) == -1 ) {
                    m_dwErrorNum = ER_LDR_READ_FILE;  // 0x400F;
                    return(-1);
                }
                uj = BinToU16(data);
                UbrofMatchAttrType( uj );
                UbrofTypeConv( uj );
                if ( symFlag ) {
                    typeHdrInfo.sizeCalculated = TRUE;
                    typeHdrInfo.sizeInMAUs = 0x03L;
                    typeHdrInfo.t.complexType = TY_SMALL_PTR;
                    retCode = SymAddTypeHeader(ui , &typeHdrInfo);
                    if ( retCode != GOOD ) {
                        m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                        return( FAILURE );
                    }
                    retCode = SymAddTypePointerTypeIndex(ui , uj);
                    if ( retCode != GOOD ) {
                        m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                        return( FAILURE );
                    }
                }
                break;
            case t_type_array : /* 0x10 */
                if ( GetBytes(data , 8) == -1 ) {
                    m_dwErrorNum = ER_LDR_READ_FILE;  // 0x400F;
                    return(-1);
                }
                uj = BinToU16(data);
                UbrofMatchAttrType( uj );
                UbrofTypeConv( uj );

                ul = BinToU32(&data[2]);
                if ( symFlag ) {
                    TYPE_C_ARRAY_STRUCT arr;

                    typeHdrInfo.sizeCalculated = TRUE;
                    typeHdrInfo.sizeInMAUs = ul;
                    typeHdrInfo.t.complexType = TY_C_ARRAY;
                    arr.typeIndex = uj;
                    uj = BinToU16(&data[6]);
//  Gates Hua , 7/04/95 Array Type Size is 0 , HighBound is 0 .
//                    if ( uj == 0 ) {     
//                      m_dwErrorNum = 0x4023;
//                       return(-1);
//                    }
                    arr.highBound = uj - 1;
                    retCode = SymAddTypeHeader(ui , &typeHdrInfo);
                    if ( retCode != GOOD ) {
                        m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                        return( FAILURE );
                    }
                    retCode = SymAddTypeCArray(ui , &arr);
                    if ( retCode != GOOD ) {
                        m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                        return( FAILURE );
                    }
                }
                break;
            case t_type_struct : /* 0x11 */
                typeHdrInfo.typeName = (LPSTR) GetName();
                if ( GetBytes(data , 6) == -1 ) {
                    m_dwErrorNum = ER_LDR_READ_FILE;  // 0x400F;
                    return(-1);
                }
                ul = BinToU32(data);
                uj = BinToU16(&data[4]);
                if ( symFlag ) {
                    typeHdrInfo.sizeCalculated = TRUE;
                    typeHdrInfo.sizeInMAUs = ul;
                    typeHdrInfo.t.complexType = TY_STRUCT;
                    retCode = SymAddTypeHeader(ui , &typeHdrInfo);
                    if ( retCode != GOOD ) {
                        m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                        return( FAILURE );
                    }
                }                   
                for( i=0 ; ((unsigned int)i )<uj ; i++) {
                    TYPE_S_U_STRUCT s;
                    U16 uu;
                    
                    if ( GetBytes(data , 4) == -1 ) { 
                        m_dwErrorNum = ER_LDR_READ_FILE; // 0x400F;
                        return(-1);
                    }
                    ul = BinToU32(data);
                    s.offset = (U16) ul;
                    s.name = (LPSTR) GetName();
                    if ( GetBytes(data , 2) == -1 ) {
                        m_dwErrorNum = ER_LDR_READ_FILE; // 0x400F;
                        return(-1);
                    }
                    uu = BinToU16(data);
                    UbrofMatchAttrType( uu );
                    UbrofTypeConv( uu );
                    s.typeIndex = uu;
                    
                    if ( symFlag ) {
                        retCode = SymAddTypeStructUnion(ui , &s);
                        if ( retCode != GOOD ) {
                            m_dwErrorNum = ER_LDR_SYM_SERVER;  // 0x4025;
                            return( FAILURE );
                        }
                    }
                    if ( s.name ) {
                        delete s.name ;
                        s.name = 0;
                    }
                }
                break;
            case t_type_union : /* 0x12 */              
                typeHdrInfo.typeName = (LPSTR) GetName();
                if ( GetBytes(data , 6) == -1 ) {
                    m_dwErrorNum = ER_LDR_READ_FILE;  // 0x400F;
                    return(-1);
                }
                ul = BinToU32(data);
                uj = BinToU16(&data[4]);
                if ( symFlag ) {
                    typeHdrInfo.sizeCalculated = TRUE;
                    typeHdrInfo.sizeInMAUs = ul;
                    typeHdrInfo.t.complexType = TY_UNION;
                    retCode = SymAddTypeHeader(ui , &typeHdrInfo);
                    if ( retCode != GOOD ) {
                        m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                        return( FAILURE );
                    }
                }                   
                for( i=0 ; ((unsigned int)i)<uj ; i++) {
                    TYPE_S_U_STRUCT s;           
                    U16 uu;
                    
                    s.name = (LPSTR) GetName();
                    if ( GetBytes(data , 2) == -1 ) {
                        m_dwErrorNum = ER_LDR_READ_FILE; // 0x400F;
                        return(-1);
                    }
                    uu = BinToU16(data);
                    UbrofMatchAttrType( uu );
                    UbrofTypeConv( uu );
                    s.typeIndex = uu;
                    s.offset = 0;
                    
                    if ( symFlag ) {
                        retCode = SymAddTypeStructUnion(ui , &s);
                        if ( retCode != GOOD ) {
                            m_dwErrorNum = ER_LDR_SYM_SERVER;  // 0x4025;
                            return( FAILURE );
                        }
                    }
                    if ( s.name ) {
                        delete s.name ;
                        s.name = 0;
                    }
                }
                break;
            case t_type_bits : /* 0x13 */
                if ( GetBytes(data , 4) == -1 ) {
                    m_dwErrorNum = ER_LDR_READ_FILE;  // 0x400F;
                    return(-1);
                }
                uj = BinToU16(&data[2]);
                UbrofMatchAttrType( uj );
                UbrofTypeConv( uj );
                if ( symFlag ) {
                    TYPE_BITFIELD_STRUCT bit;
                    
                    typeHdrInfo.sizeCalculated = FALSE;
                    typeHdrInfo.t.complexType = TY_BITFIELD;
                    retCode = SymAddTypeHeader(ui , &typeHdrInfo);
                    if ( retCode != GOOD ) {
                        m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                        return( FAILURE );
                    }
                    bit.bitfieldSigned = 1;
                    bit.size = data[0];
                    bit.offset = data[1];
                    bit.baseTypeIndex = uj;
                    retCode = SymAddTypeBitfield(ui , &bit);
                    if ( retCode != GOOD ) {
                        m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                        return( FAILURE );
                    }
                }
                break;
            case t_type_func : /* 0x20 */
            case t_type_func1 : /* 0x23 */
                if ( symFlag ) {
                    U8 frameType, argCount;
                    U32 attr;
                                  
                    attr = 0xFFFFFFFF;                                
                    typeHdrInfo.t.complexType = TY_FUNC_DEP;
                    retCode = SymAddTypeHeader(ui , &typeHdrInfo);
                    if ( retCode != GOOD ) {
                        m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                        return( FAILURE );
                    }
                    if ( GetBytes(data , 3) == -1 ) {
                        m_dwErrorNum = ER_LDR_READ_FILE; // 0x400F;
                        return(-1);
                    }
                    uj = BinToU16(data);
                    UbrofMatchAttrType( uj );
                    UbrofTypeConv( uj );
                    frameType = data[2];
                    if ( j == t_type_func ) {
                        if ( GetOneByte(data) == -1 ) {
                            m_dwErrorNum = ER_LDR_READ_FILE;   // 0x400F;
                            return(-1);
                        }
                        argCount = data[0];
                    }
                    else {
                        if ( GetBytes(data , 5) == -1 ) {
                            m_dwErrorNum = ER_LDR_READ_FILE;   // 0x400F;
                            return(-1);
                        }
                        argCount = data[4];
                        attr = BinToU32(data);
                    }
                    retCode = SymAddTypeFunc(ui,attr,frameType,0L,uj,argCount,0,"");
                    if ( retCode != GOOD ) {
                        m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                        return( FAILURE );
                    }
                    for (i=0 ; i < argCount ; i++) {
                        if ( GetBytes(data , 2) == -1 ) {
                            m_dwErrorNum = ER_LDR_READ_FILE;   // 0x400F;
                            return(-1);
                        }
                        uj = BinToU16(data);
                        UbrofMatchAttrType( uj );
                        UbrofTypeConv( uj );
                        retCode = SymAddTypeFuncParam(ui,uj);
                        if ( retCode != GOOD ) {
                            m_dwErrorNum = ER_LDR_SYM_SERVER;  // 0x4025;
                            return( FAILURE );
                        }
                    }                       
                }
                else {
                    if ( j == t_type_func ) {
                        if ( GetBytes(data , 4) == -1 ) {
                            m_dwErrorNum = ER_LDR_READ_FILE;   // 0x400F;
                            return(-1);
                        } 
                        uj = data[3];
                    }
                    else {
                        if ( GetBytes(data , 8) == -1 ) {
                            m_dwErrorNum = ER_LDR_READ_FILE;   // 0x400F;
                            return(-1);
                        } 
                        uj = data[7];
                    }
                    if ( GetBytes(data , 2*uj) == -1 ) {
                        m_dwErrorNum = ER_LDR_READ_FILE; // 0x400F;
                        return(-1);
                    } 
                }
                break;
            case t_type_attr : /* 0x15 */
                if ( GetBytes(data , 3) == -1 ) {
                    m_dwErrorNum = ER_LDR_READ_FILE;  // 0x400F;
                    return(-1);
                }
                if ( symFlag ) {
                    if ( attrExtHdrPtr ) {
                        attrExtPtr->next = new attrCC;
                        if ( attrExtPtr->next == 0 ) {
                            m_dwErrorNum = ER_LDR_MEMORY_ALLOC;      // 0x4000;
                            return( FAILURE );
                        }
                        attrExtPtr = attrExtPtr->next;
                        attrExtPtr->num = ui - 156;
                        attrExtPtr->attr = ( unsigned long ) data[0];
                        uj = BinToU16(&data[1]);
                        UbrofMatchAttrType( uj );
                        attrExtPtr->type = uj;
                    }
                    else {
                        attrExtHdrPtr = attrExtPtr = new attrCC;
                        if ( attrExtPtr == 0 ) {
                            m_dwErrorNum = ER_LDR_MEMORY_ALLOC;      // 0x4000;
                            return( FAILURE );
                        }
                        attrExtPtr->num = ui - 156;
                        attrExtPtr->attr = ( unsigned long ) data[0];
                        uj = BinToU16(&data[1]);
                        UbrofMatchAttrType( uj );
                        attrExtPtr->type = uj;
                    }
                }
                break;
            case t_type_attr1 : /* 0x24 */
                if ( GetBytes(data , 6) == -1 ) {
                    m_dwErrorNum = ER_LDR_READ_FILE;  // 0x400F;
                    return(-1);
                }
                if ( symFlag ) {
                    if ( attrExtHdrPtr ) {
                        attrExtPtr->next = new attrCC;
                        if ( attrExtPtr->next == 0 ) {
                            m_dwErrorNum = ER_LDR_MEMORY_ALLOC;      // 0x4000;
                            return( FAILURE );
                        }
                        attrExtPtr = attrExtPtr->next;
                        attrExtPtr->num = ui - 156;
                        attrExtPtr->attr = BinToU32( data );
                        uj = BinToU16(&data[4]);
                        UbrofMatchAttrType( uj );
                        attrExtPtr->type = uj;
                    }
                    else {
                        attrExtHdrPtr = attrExtPtr = new attrCC;
                        if ( attrExtPtr == 0 ) {
                            m_dwErrorNum = ER_LDR_MEMORY_ALLOC;      // 0x4000;
                            return( FAILURE );
                        }
                        attrExtPtr->num = ui - 156;
                        attrExtPtr->attr = BinToU32( data );
                        uj = BinToU16(&data[4]);
                        UbrofMatchAttrType( uj );
                        attrExtPtr->type = uj;
                    }
                }
                break;
            case t_type_dptr0 : /* 0x17 */
            case t_type_dptr1 : /* 0x18 */
            case t_type_dptr2 : /* 0x19 */
            case t_type_dptr3 : /* 0x1A */
            case t_type_dptr4 : /* 0x1B */
            case t_type_dptr5 : /* 0x1C */
            case t_type_dptr6 : /* 0x1D */
            case t_type_dptr7 : /* 0x1E */
            case t_type_cptr0 : /* 0x1F */
            case t_type_cptr1 : /* 0x20 */
            case t_type_cptr2 : /* 0x21 */
            case t_type_cptr3 : /* 0x22 */
                k = j - t_type_dptr0 ;
                if ( GetBytes(data , 2) == -1 ) {
                    m_dwErrorNum = ER_LDR_READ_FILE;  // 0x400F;
                    return(-1);
                }
                uj = BinToU16(data);
                UbrofMatchAttrType( uj );
                UbrofTypeConv( uj );
                if ( symFlag ) {
                    typeHdrInfo.sizeCalculated = TRUE;
                    typeHdrInfo.sizeInMAUs = 0x02L;
                    typeHdrInfo.t.complexType = (COMPLEX_TYPE) (TY_DPTR0 + k);
                    retCode = SymAddTypeHeader(ui , &typeHdrInfo);
                    if ( retCode != GOOD ) {
                        m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                        return( FAILURE );
                    }
                    retCode = SymAddTypePointerTypeIndex(ui , uj);
                    if ( retCode != GOOD ) {
                        m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                        return( FAILURE );
                    }
                }
                break;
            default :
#ifdef _DUMP_
            Message("\r\n???Unknown type record at file %lx",GetFileCurPos()-4);
#endif
                m_dwErrorNum = ER_LDR_TYPE;     // 0x4016;
                return (-1);            
            }
            break;
        case t_size_type : /* 0x4F */
            if ( GetBytes(data , 2) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;   // 0x400F;
                return(-1);
            }
            if ( symFlag ) {
                uj = data[0];
                UbrofTypeConv( uj );
                retCode = SymAddTypeOverwriteSize( (U8) uj , data[1] );
                if ( retCode != GOOD ) {
                    m_dwErrorNum = ER_LDR_SYM_SERVER; // 0x4025;
                    return( FAILURE );
                }
            }
            break;
        default :
#ifdef _DUMP_
         Message("\r\n???Unknown type record at file %lx",GetFileCurPos()-1);
#endif
            m_dwErrorNum = ER_LDR_TYPE;      // 0x4016;
            return(-1);
        }
    }
    return(0);
}

/***************************************************************************
*                                                                          *
*  LdrUbrofGetModule - Load UBROF one module information                   *
*  parameter :                                                             *
*       keyword  --  module first record keyword                           *
*       onDemandFlag -- on demand load flag                                *
*  return value :                                                          *
*       0  ---  OK                 -1  ---  failure                        *
*                                                                          *
***************************************************************************/
int LoaderServer::LdrUbrofGetModule(U8 keyword , BOOL onDemandFlag) 
{
    SYM_DESCRIPTOR moduleDesc;
    int flag , symFlag , codeFlag ;
    int i , err;
    U8 ch , j;           
    U8 data[LDR_BUFSIZE];
    U16 ui , uj;
    U32 ul; 
    char *tmpFileName;           
    RETCODE retCode;
    
    ClearUpModuleBlock();
    curBlock = 0;
    symFlag = LOAD_SYM(m_ldrFlags);
    codeFlag = LOAD_CODE(m_ldrFlags);
    start = DEFAULT_START_ADDR;
    end = DEFAULT_END_ADDR;
    flag = 1;       
    ModuleNodeInit();
    
    ch = keyword;   
    m_modNode.offset = m_uBufInFilePos + m_uBufPos - 1 ;
    if ( GetBytes(data , 3) == -1 ) {
        m_dwErrorNum = ER_LDR_READ_FILE;  // 0x4014;
        return(-1);                        
    }                            
    m_version = data[0];
//    m_absflag = data[2] & 0x01;
    m_absflag = data[1] & 0x01;
    if ( GetBytes(data , 3) == -1 ) {
        m_dwErrorNum = ER_LDR_READ_FILE;  // 0x400F;
        return(-1);
    }
    m_modNode.time.day = data[0];
    m_modNode.time.month = data[1];                
    m_modNode.time.year = 1900 ;
    m_modNode.time.year +=  ( (U16) data[2] ) ; 
    m_modNode.time.hour = -1;
    m_modNode.name = (LPSTR) GetName();
    stat_addr.flag = 0;           

    symFlag = LOAD_SYM(m_ldrFlags);
    codeFlag = LOAD_CODE(m_ldrFlags);

    if ( m_modNode.name ) {
        if ( m_modNode.name[0] == '?' && !m_bSpecSymbol ) symFlag = 0;
    }
    
    curAddr.type = SEG_CODE;
    curAddr.addr = 0;
    
    if ( symFlag ) {   
        if ( onDemandFlag == TRUE ) {
            moduleDesc = curModDesc;
        }
        else {
            retCode = SymAddModuleCreate(
                m_modNode.name ,
                &m_modNode.time ,
                &m_modNode.codeaddr ,
                m_modNode.offset ,
                (BOOLEAN) m_onDemand ,
                0,
                &moduleDesc );
            if ( retCode != GOOD ) {
                m_dwErrorNum = ER_LDR_SYM_SERVER;  // 0x4025;
                return( FAILURE );
            }
            curModDesc = moduleDesc;
        }
    }

    if ( GetOneByte(&ch) == -1 ) {
        m_dwErrorNum = ER_LDR_READ_FILE;  // 0x4014;
        return(-1);                        
    }                            

    while ( flag ) {
        if ( (err = TestKey(VK_ESCAPE)) == 1 ) {
            m_dwErrorNum = ER_LDR_ABORT;  // 0x4010;
            return( -1 );
        } 
        if ( (m_window == LOAD_FROM_DIALOG)&&(m_ldrFlags & LDR_STATUS) ) {
            if ( IsLoadCanceled() ) {
                m_dwErrorNum = ER_LDR_ABORT; // 0x4010;
                return( -1 );
            }                  
            TestMessage();
        }
        switch( ch ) {
        case t_end : /* 0x3F */
        case t_end_abs : /* 0x3D */
            if ( ch == t_end_abs ) {
                if ( GetBytes(data , 6) == -1 ) {
                    m_dwErrorNum = ER_LDR_READ_FILE;  // 0x4014;
                    return(-1);                        
                }                            
                ui = BinToU16(data);
                ul = BinToU32(&data[2]);
                m_startaddress = ul;
            }
            if ( m_modNode.scope != 0 ) {
                m_dwErrorNum = ER_LDR_MODULE_FORMAT;  // 0x401A;
                return (-1);
            }
            if ( GetBytes(data , 2) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;   // 0x4014;
                return(-1);                        
            }                            
            flag = 0;            

            if ( stat_addr.flag == 1 ) {  
                if ( m_modNode.linecnt == 0 ) {
                    retCode = SymAddLinenumStart(moduleDesc);
                    if ( retCode != GOOD ) {
                        m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                        return( FAILURE );
                    }
                }
                
                SOURCE_RANGE_TYPE srcState;
                ADDR_RANGE_TYPE addrState;
                srcState.lineNumStart=BinToU16(LineNumInfo);
                srcState.columnStart=BinToU16(&LineNumInfo[2]);
                srcState.lineNumEnd=BinToU16(&LineNumInfo[4]);
                srcState.columnEnd=BinToU16(&LineNumInfo[6]);
                addrState.startAddr=stat_addr.start.addr;
                addrState.endAddr=stat_addr.end.addr;
                addrState.segType=SEG_CODE;
                retCode = SymAddSourceState(&srcState , &addrState);
                if ( retCode != GOOD ) {
                    m_dwErrorNum = ER_LDR_SYM_SERVER; // 0x4025;
                    return( FAILURE );
                }

                m_modNode.linecnt++;
                if ( curBlock ) {
                    if (curBlock->codeaddr.startAddr > 
                        stat_addr.start.addr ) 
                        curBlock->codeaddr.startAddr = 
                        stat_addr.start.addr;
                    if (curBlock->codeaddr.endAddr < 
                        stat_addr.end.addr ) 
                        curBlock->codeaddr.endAddr = 
                        stat_addr.end.addr;
                }         

// Add by Gates Hua 1/10/96                                  
                if ( start > stat_addr.start.addr ) 
                    start = stat_addr.start.addr;
                if ( end < stat_addr.end.addr ) 
                    end = stat_addr.end.addr;
//                    
                
                stat_addr.start.addr = DEFAULT_START_ADDR;
                stat_addr.end.addr = DEFAULT_END_ADDR;
                stat_addr.flag = 0;
            }
            if ( symFlag ) {   
                QUAL_ADDR_RANGE_TYPE qaddr;
                m_modNode.codeaddr.segType = (SEGMENTTYPE) SEG_CODE;
                m_modNode.codeaddr.startAddr = start;
                m_modNode.codeaddr.endAddr = end;
                qaddr.startAddr = start;
                qaddr.endAddr = end;
                qaddr.startValid = TRUE;
                qaddr.endValid = TRUE;                      
                if ( start > end ) {
                    qaddr.startValid = FALSE;
                    qaddr.endValid = FALSE;
                }
                    
                if ( m_modNode.linecnt > 0 ) {
                    retCode = SymAddLinenumEnd();
                    if ( retCode != GOOD ) {
                        m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                        return( FAILURE );
                    }
                }
                
                ClearUpModuleBlock();
                if ( onDemandFlag == FALSE ) {
                    retCode = SymAddModuleClose( 
                        (BOOLEAN) (!m_onDemand) );
                    if ( retCode != GOOD ) {
                        m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025 ;
                        return( FAILURE );
                    }
                }
                else {
                    retCode = SymAddModuleClose( TRUE );
                    if ( retCode != GOOD ) {
                        m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025 ;
                        return( FAILURE );
                    }
                }            
                if ( qaddr.startValid || qaddr.endValid ) {
                    retCode = SymAddSymbolSetAddr( &qaddr );
                    if ( retCode != GOOD ) {
                        m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025 ;
                        return( FAILURE );
                    }
                }
            }              
            return 0;
        case t_debug : /* 0x52 */
            if ( GetOneByte(data) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;   // 0x4014;
                return(-1);                        
            }                            
            break;
        case t_aux : /* 0x53 */
            if ( GetBytes(data , 2) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;   // 0x4014;
                return(-1);                        
            }                            
            break;
        case t_aux_1 : /* 0x54 */
            if ( GetBytes(data , 2) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;   // 0x4014;
                return(-1);                        
            }                            
            if ( GetOneByte(&j) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;   // 0x4014;
                return(-1);                        
            }                            
            if ( GetBytes(data , j) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;   // 0x4014;
                return(-1);                        
            }                            
            break;
        case t_file : /* 0x46 */
            m_modNode.tfileoffset = m_uBufInFilePos + m_uBufPos - 1;
            if ( GetBytes(data , 2) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;   // 0x4014;
                return(-1);                        
            }                            
            ui = BinToU16(data);
            if ( GetOneByte(&j) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;   // 0x4014;
                return(-1);                        
            }                            
            if ( GetBytes(data , j) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;   // 0x4014;
                return(-1);                        
            }                            
            for( i=0;((unsigned int)i)<ui;i++ ) {
                if ( GetBytes(data , 2) == -1 ) {
                    m_dwErrorNum = ER_LDR_READ_FILE;  // 0x4014;
                    return(-1);                        
                }                            
                uj = BinToU16( data );
                if ( GetBytes(data , uj) == -1 ) {
                    m_dwErrorNum = ER_LDR_READ_FILE;  // 0x4014;
                    return(-1);                        
                }                            
            }
            if ( symFlag && !onDemandFlag) {    
                retCode = SymAddModuleSourceFilePosition( moduleDesc ,
                                    m_modNode.tfileoffset );
                if ( retCode != GOOD ) {
                    m_dwErrorNum = ER_LDR_SYM_SERVER; // 0x4025;
                    return( FAILURE );
                }
            }
            break;
        // next case added by Jamoon 4/18/96
        case t_file_ref    : // 0xB9   
         if ( GetBytes(data, 5) == FAILURE ) {
                m_dwErrorNum = ER_LDR_READ_FILE;   // 0x4014;
                return(-1);                        
            }
            ui = BinToU16(data+3);                            
         if ( GetBytes(data, ui+6) == FAILURE ) {
                m_dwErrorNum = ER_LDR_READ_FILE;   // 0x4014;
                return(-1);                        
            }
         break;
        case t_symbol_def : /* 0x4C */
        case t_symbol_def1 : /* 0xA6 */
            if ( GetBytes(data , 7) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;   // 0x4014;
                return(-1);                        
            }                            
            tmpFileName = (LPSTR) GetName();
            lstrcpy( (LPSTR) &SymDefInfo[10] , (LPSTR) tmpFileName);
            if ( tmpFileName ) delete tmpFileName;
            tmpFileName = 0;
            memcpy( (LPSTR) SymDefInfo , (LPSTR) data , 7);
            if ( GetBytes(&SymDefInfo[8] , 2) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;   // 0x4014;
                return(-1);                        
            }
            if ( ch == t_symbol_def1 ) {
                if ( GetBytes(data , 2) == -1 ) {
                    m_dwErrorNum = ER_LDR_READ_FILE;  // 0x4014;
                    return(-1);                        
                }                     
                ui = BinToU16(data);       
                if ( GetBytes(data , ui*13) == -1 ) {
                    m_dwErrorNum = ER_LDR_READ_FILE;  // 0x4014;
                    return(-1);                        
                }       
                SymDefInfo[7] = 1;                     
            }                   
            else SymDefInfo[7] = 0;     
            if ( GetOneByte(&j) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;   // 0x4014;
                return(-1);                        
            }                            
            if ( GetBytes(data , j) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;   // 0x4014;
                return(-1);                        
            }                            
            if ( symFlag && !onDemandFlag) {    
                j = SymDefInfo[0];
//              if ( j==2 || j==4 || j==9 ) {
                if ( j==2 || j==4 ) {
                    m_modNode.symno++;
                    if ( UbrofProcessModSym() != GOOD )
                        return( FAILURE );
                }
            }                   
            break;
        case t_macro : /* 4E */
            if ( GetOneByte(&j) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;   // 0x4014;
                return(-1);                        
            }                            
            if ( GetBytes(data , j) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;   // 0x4014;
                return(-1);                        
            }                            
            if ( GetBytes(data , 2) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;   // 0x4014;
                return(-1);                        
            }                            
            uj = BinToU16(data);
            if ( GetBytes(data , uj) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;   // 0x4014;
                return(-1);                        
            }                            
            break;
        case t_func_begin : /* 0x50 */
        case t_func_begin1 : /* 0xA7 */     
            if ( m_modNode.scope != 0 ) {
                m_dwErrorNum = ER_LDR_SCOPE; // 0x4019;
                return(-1);
            }
            m_modNode.scope++;
            if ( symFlag && (onDemandFlag || !m_onDemand) ) {
                curBlock = new BlockBlock;
                
                if ( curBlock == 0 ) {
                    m_dwErrorNum = ER_LDR_MEMORY_ALLOC;     // 0x4000;
                    return(FAILURE);
                }
                curBlock->scope = m_modNode.scope;
                curBlock->codeaddr.segType=(SEGMENTTYPE)SEG_CODE;
                curBlock->codeaddr.startAddr = DEFAULT_START_ADDR ;
                curBlock->codeaddr.endAddr = DEFAULT_END_ADDR ;
            }
            tmpFileName = (LPSTR) GetName();
            if ( GetBytes(data , 10) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;   // 0x4014;
                return(-1);                        
            }                            
            if ( symFlag && (!m_onDemand || onDemandFlag) ) {
                curBlock->funcName = tmpFileName;
                tmpFileName = 0;
                curBlock->srcRange.lineNumStart = BinToU16(data);
                curBlock->srcRange.columnStart = BinToU16(&data[2]);
                curBlock->srcRange.lineNumEnd = BinToU16(&data[4]);
                curBlock->srcRange.columnEnd = BinToU16(&data[6]);

                FUNC_CLASS funcClass;
                if ( curBlock->scope != 1 ) funcClass = FUNC_LOCAL ;
                else funcClass = FUNC_GLOBAL;
                UbrofMatchFuncType( curBlock->funcName , curBlock->typeIndex );
                retCode = SymAddFuncCreate(     
                                    curBlock->funcName ,
                                    funcClass ,
                                    curBlock->stacksize ,
                                    &curBlock->codeaddr ,
                                    curBlock->typeIndex );
                if ( retCode != GOOD ) {
                    m_dwErrorNum = ER_LDR_SYM_SERVER; // 0x4025;
                    return( FAILURE );
                }
            }
            ui = BinToU16(&data[8]);
            for( i = 0; ((unsigned int)i) < ui; i++ ) {
                if ( GetBytes(SymDefInfo , 7) == -1 ) {
                    m_dwErrorNum = ER_LDR_READ_FILE;  // 0x4014;
                    return(-1);                        
                }                            
                tmpFileName = (LPSTR) GetName();
                lstrcpy( (LPSTR) &SymDefInfo[10] , (LPSTR) tmpFileName);
                if ( tmpFileName ) delete tmpFileName;
                tmpFileName = 0;
                if ( GetBytes(&SymDefInfo[8] , 2) == -1 ) {
                    m_dwErrorNum = ER_LDR_READ_FILE;  // 0x4014;
                    return(-1);                        
                }
                if ( ch == t_func_begin1 ) {
                    if ( GetBytes(data , 2) == -1 ) {
                        m_dwErrorNum = ER_LDR_READ_FILE; // 0x4014;
                        return(-1);                        
                    }
                    uj = BinToU16(data);
                    if ( GetBytes(data , uj*13) == -1 ) {
                        m_dwErrorNum = ER_LDR_READ_FILE; // 0x4014;
                        return(-1);                        
                    }
                }
                if ( symFlag && (!m_onDemand || onDemandFlag) ) {    
                    j = SymDefInfo[0];
//                  if ( j==7 || j==4 || j==8 || j==9 ) {
                    if ( j==7 || j==4 || j==8 ) {
                        curBlock->localsymno++;
                        if ( GOOD != UbrofProcessBlockSym() )
                            return( FAILURE );
                    }
                }                   
            }
            break;
        case t_block_begin : /* 0x48 */
        case t_block_begin1 : /* 0xA8 */
            if ( m_modNode.scope < 1 ) { 
                m_dwErrorNum = ER_LDR_SCOPE; // 0x4019;
                return(-1);
            }
            else if ( symFlag && (!m_onDemand || onDemandFlag) ) {
                curBlock->son = new BlockBlock;
                ASSERT( curBlock->son );                        
                if ( curBlock->son == 0 ) {
                    m_dwErrorNum = ER_LDR_MEMORY_ALLOC;     // 0x4000;
                    return (FAILURE);
                }
                curBlock->son->father = curBlock ;
                curBlock = curBlock->son;

                m_modNode.scope++;
                curBlock->scope = m_modNode.scope;
                curBlock->codeaddr.segType = (SEGMENTTYPE) SEG_CODE;
                curBlock->codeaddr.startAddr = DEFAULT_START_ADDR ;
                curBlock->codeaddr.endAddr = DEFAULT_END_ADDR ;

                FUNC_CLASS funcClass;
                if ( curBlock->scope != 1 ) funcClass = FUNC_LOCAL ;
                else funcClass = FUNC_GLOBAL;
                retCode = SymAddFuncCreate(     
                                    "",
                                    funcClass ,
                                    curBlock->stacksize ,
                                    &curBlock->codeaddr ,
                                    curBlock->typeIndex );
                if ( retCode != GOOD ) {
                    m_dwErrorNum = ER_LDR_SYM_SERVER; // 0x4025;
                    return( FAILURE );
                }
            }               
            else m_modNode.scope++;
            if ( GetBytes(data , 2) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;   // 0x4014;
                return(-1);                        
            }                            
            ui = BinToU16(data);
            for(i=0;((unsigned int)i)<ui;i++) {
                if ( GetBytes(SymDefInfo , 7) == -1 ) {
                    m_dwErrorNum = ER_LDR_READ_FILE;  // 0x4014;
                    return(-1);                        
                }                            
                tmpFileName = (LPSTR) GetName();
                lstrcpy( (LPSTR) &SymDefInfo[10] , (LPSTR) tmpFileName);
                if ( tmpFileName ) delete tmpFileName;
                tmpFileName = 0;
                if ( GetBytes(&SymDefInfo[8] , 2) == -1 ) {
                    m_dwErrorNum = ER_LDR_READ_FILE;  // 0x4014;
                    return(-1);                        
                }
                if ( ch == t_block_begin1 ) {
                    if ( GetBytes(data , 2) == -1 ) {
                        m_dwErrorNum = ER_LDR_READ_FILE; // 0x4014;
                        return(-1);                        
                    }
                    uj = BinToU16(data);
                    if ( GetBytes(data , uj*13) == -1 ) {
                        m_dwErrorNum = ER_LDR_READ_FILE; // 0x4014;
                        return(-1);                        
                    }
                }
                if ( symFlag && (!m_onDemand || onDemandFlag) ) {    
                    j = SymDefInfo[0];
//                  if ( j==7 || j==4 || j==8 || j==9 ) {
                    if ( j==7 || j==4 || j==8 ) {
                        curBlock->localsymno++;
                        if ( GOOD != UbrofProcessBlockSym() )
                            return( FAILURE );
                    }
                }                   
            }
            break;
        case t_src_stat : /* 0x47 */
            if ( stat_addr.flag == 1 ) {
                if ( m_modNode.linecnt == 0 ) {
                    retCode = SymAddLinenumStart(moduleDesc);
                    if ( retCode != GOOD ) {
                        m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                        return( FAILURE );
                    }
                }
                
                SOURCE_RANGE_TYPE srcState;
                ADDR_RANGE_TYPE addrState;
                srcState.lineNumStart=BinToU16(LineNumInfo);
                srcState.columnStart=BinToU16(&LineNumInfo[2]);
                srcState.lineNumEnd=BinToU16(&LineNumInfo[4]);
                srcState.columnEnd=BinToU16(&LineNumInfo[6]);
                addrState.startAddr=stat_addr.start.addr;
                addrState.endAddr=stat_addr.end.addr;
                addrState.segType=SEG_CODE;
                retCode = SymAddSourceState(&srcState , &addrState);
                if ( retCode != GOOD ) {
                    m_dwErrorNum = ER_LDR_SYM_SERVER; // 0x4025;
                    return( FAILURE );
                }

                m_modNode.linecnt++;
                if ( curBlock ) {
                    if (curBlock->codeaddr.startAddr > 
                        stat_addr.start.addr ) 
                        curBlock->codeaddr.startAddr = 
                        stat_addr.start.addr;
                    if (curBlock->codeaddr.endAddr < 
                        stat_addr.end.addr ) 
                        curBlock->codeaddr.endAddr = 
                        stat_addr.end.addr;
                }                           
// Add by Gates Hua 1/10/96                                  
                if ( start > stat_addr.start.addr ) 
                    start = stat_addr.start.addr;
                if ( end < stat_addr.end.addr ) 
                    end = stat_addr.end.addr;
//                    
                stat_addr.start.addr = DEFAULT_START_ADDR;
                stat_addr.end.addr = DEFAULT_END_ADDR;
                stat_addr.flag = 0;
            }
            if ( GetBytes(data , 9) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;   // 0x4014;
                return(-1);                        
            }                            
            if ( symFlag && (!m_onDemand || onDemandFlag) ) {
                memcpy((LPSTR) LineNumInfo , (LPSTR) data , 8);
                stat_addr.flag = 1;
                stat_addr.start.addr = DEFAULT_START_ADDR;
                stat_addr.end.addr = DEFAULT_END_ADDR;
            }
            break;
        // next case added by Jamoon 4/18/96
        case t_new_file    :  // 0xBA
            if ( GetBytes(data , 3) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;   // 0x4014;
                return(-1);                        
            }                            
         break;
        case t_block_end : /* 0x49 */
            if ( m_modNode.scope == 0 ) {
                m_dwErrorNum = ER_LDR_SCOPE; // 0x4019;
                return(-1);
            }
            if ( stat_addr.flag == 1 ) {  

                if ( m_modNode.linecnt == 0 ) {
                    retCode = SymAddLinenumStart(moduleDesc);
                    if ( retCode != GOOD ) {
                        m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                        return( FAILURE );
                    }
                }
                
                SOURCE_RANGE_TYPE srcState;
                ADDR_RANGE_TYPE addrState;
                srcState.lineNumStart=BinToU16(LineNumInfo);
                srcState.columnStart=BinToU16(&LineNumInfo[2]);
                srcState.lineNumEnd=BinToU16(&LineNumInfo[4]);
                srcState.columnEnd=BinToU16(&LineNumInfo[6]);
                addrState.startAddr=stat_addr.start.addr;
                addrState.endAddr=stat_addr.end.addr;
                addrState.segType=SEG_CODE;
                retCode = SymAddSourceState(&srcState , &addrState);
                if ( retCode != GOOD ) {
                    m_dwErrorNum = ER_LDR_SYM_SERVER; // 0x4025;
                    return( FAILURE );
                }

                m_modNode.linecnt++;
                if ( curBlock ) {
                    if (curBlock->codeaddr.startAddr > 
                        stat_addr.start.addr ) 
                        curBlock->codeaddr.startAddr = 
                        stat_addr.start.addr;
                    if (curBlock->codeaddr.endAddr < 
                        stat_addr.end.addr ) 
                        curBlock->codeaddr.endAddr = 
                        stat_addr.end.addr;
                }                           
// Add by Gates Hua 1/10/96                                  
                if ( start > stat_addr.start.addr ) 
                    start = stat_addr.start.addr;
                if ( end < stat_addr.end.addr ) 
                    end = stat_addr.end.addr;
//                    
                stat_addr.start.addr = DEFAULT_START_ADDR;
                stat_addr.end.addr = DEFAULT_END_ADDR;
                stat_addr.flag = 0;
            }
            if ( symFlag && (!m_onDemand || onDemandFlag) ) {
                if ( curBlock ) {

                    QUAL_ADDR_RANGE_TYPE qaddr;
                    
                    if ( curBlock->father ) {
                        if (curBlock->father->codeaddr.startAddr
                            > curBlock->codeaddr.startAddr) {
                            curBlock->father->codeaddr.startAddr =
                                curBlock->codeaddr.startAddr;
                        }
                        if (curBlock->father->codeaddr.endAddr
                            < curBlock->codeaddr.endAddr) {
                            curBlock->father->codeaddr.endAddr =
                                curBlock->codeaddr.endAddr;
                        }                   
                    }
// Add by Gates Hua , 1/10/96
                    else {
                        if ( start > curBlock->codeaddr.startAddr )
                            start = curBlock->codeaddr.startAddr;
                        if ( end < curBlock->codeaddr.endAddr) {
                            end = curBlock->codeaddr.endAddr;
                        }                   
                    }
                            
                    qaddr.startAddr = curBlock->codeaddr.startAddr;
                    qaddr.endAddr = curBlock->codeaddr.endAddr;
                    qaddr.startValid = TRUE;
                    qaddr.endValid = TRUE;                      
                    if ( qaddr.startAddr > qaddr.endAddr ) {
                        qaddr.startValid = FALSE;
                        qaddr.endValid = FALSE;
                    }
                        
                    retCode = SymAddFuncClose();
                    if ( retCode != GOOD ) {
                        m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                        return( FAILURE );
                    }      
                    if ( qaddr.startValid || qaddr.endAddr ) {
                        retCode = SymAddSymbolSetAddr( &qaddr );
                        if ( retCode != GOOD ) {
                            m_dwErrorNum = ER_LDR_SYM_SERVER;  // 0x4025;
                            return( FAILURE );
                        }
                    }
                        
                    if ( curBlock->father ) {
                        curBlock = curBlock->father;
                        delete curBlock->son;
                        curBlock->son = 0;
                    }
                    else {
                        delete curBlock ;
                        curBlock = 0;
                    }
                }
                else {    
                    m_dwErrorNum = ER_LDR_BLOCK_INFO;    // 0x401C;
                    return(-1);
                }
            }
            m_modNode.scope--;
            break;
        case t_abs_var : /* 0x39 */
            if ( GetOneByte(&j) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;   // 0x4014;
                return(-1);                        
            }                            
            if ( GetBytes(data , j) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;   // 0x4014;
                return(-1);                        
            }                            
            if ( codeFlag ) {
                ADDR stAddr , endAddr;
//                if ( curAddr.type == SEG_CODE ) {
                if ( curAddr.type == SEG_CODE ||
                  curAddr.type == SEG_UNTYPED ) {
                    stAddr.addrType = endAddr.addrType = 1;
                    stAddr.addr = (unsigned short) curAddr.addr;
                    endAddr.addr = (unsigned short) (curAddr.addr + j - 1);

#ifdef _ZLR_                    
                    err=AbiFill(stAddr , endAddr , (char *)data , j);
                    if ( err != ICE_OK ) {
                        m_dwErrorNum = ER_ICE_FAIL_MEM_WRITE;  // 0x4020;
                        return(-1);
                    }
#endif                  
                    uLoadBytes += (U32)j;
                }                  
                else {
//                    Warning("Download code not in code segment!");
                    Warning( ER_CODE_NOT_IN_CODESEG );
                    return(-1);
                }
            }
            if ( symFlag ) {
//                if ( curAddr.type == SEG_CODE ) {
                if ( curAddr.type == SEG_CODE ||
                  curAddr.type == SEG_UNTYPED ) {
// Modify by Gates Hua , 1\10\96
//                    if ( start > curAddr.addr ) start = curAddr.addr;
//                    if ( end < (curAddr.addr+j-1) ) end = curAddr.addr+j-1;
                    if ( stat_addr.flag ) {
                        U32 address;
                        address = curAddr.addr;
                        if (stat_addr.start.addr>address)
                            stat_addr.start.addr = address; 
                        address += j - 1;
                        if (stat_addr.end.addr<address)
                            stat_addr.end.addr = address;
                    }
                }
                else {
//                    Warning("Download code not in code segment!");
                    Warning( ER_CODE_NOT_IN_CODESEG );
                    return(-1);
                }
            }
            curAddr.addr += j;                  
            break;
        case t_org : /* 0x51 */
            if ( GetBytes(data , 5) == -1 ) {  
                m_dwErrorNum = ER_LDR_READ_FILE;   // 0x4014;
                return(-1);                        
            }                            
            UbrofSegIdToEnum( data[0] , &curAddr.type );
            curAddr.addr = BinToU32(&data[1]);
            break;
        default :
#ifdef _DUMP_
         Message("\r\n???Unknown MOD record at file %lx",
               GetFileCurPos()-1);
#endif
            m_dwErrorNum = ER_LDR_UBROF_FORMAT;    // 0x4024;
            return(-1);
            break;
        }        
        if ( GetOneByte(&ch) == -1 ) {
            m_dwErrorNum = ER_LDR_READ_FILE; // 0x4014;
            return(-1);                        
        }                            
    }
    
    return 0;
}   

/***************************************************************************
*                                                                          *
*  UbrofProcessModSym - Load UBROF module symbol information               *
*  parameter :                                                             *
*       None                                                               *
*  return value :                                                          *
*       0  ---  OK                 -1  ---  failure                        *
*                                                                          *
***************************************************************************/
int LoaderServer::UbrofProcessModSym(void)
{
    U32 address;     
    U16 ui;
    
    VAR_STORAGE_CLASS varStorage;
    VAR_REGISTER_CLASS registerClass;
//    BOOL isConst , isValid ;
    BOOLEAN isConst , isValid ;
    ADD_VAR_ADDR_UNION addr;
    SYM_DESCRIPTOR symDesc;
    
    varStorage = GLOBAL_VAR_CLASS;                     
    registerClass = NOT_REG;
    ui = BinToU16(&SymDefInfo[1]);
    address = BinToU32(&SymDefInfo[3]);
    if ( ui == 6 ) isValid = FALSE ;
    else isValid = TRUE;
    if ( ui == 7 ) isConst = TRUE;
    else isConst = FALSE;
    if ( isValid ) {
        UbrofSegIdToEnum( (U8) ui , &addr.addr.segType );
        addr.addr.addr = address;
    }
    else {
        registerClass = LIVING_REG;
        addr.registerIndex = (U16) address;
    }
    ui = BinToU16(&SymDefInfo[8]);
    UbrofMatchAttrType( ui );
    UbrofTypeConv( ui );                     
    if ( SymDefInfo[10] == '?' && !m_bSpecSymbol ) return GOOD;
    if ( GOOD != SymAddVar((LPSTR)&SymDefInfo[10],ui,
        varStorage,registerClass,&addr,isConst,
        isValid,&symDesc) ) {
        if ( varExtHdrPtr ) {
            varExtPtr->next = new StoreExtendVar;
            if ( varExtPtr->next == 0 ) {
                m_dwErrorNum = ER_LDR_MEMORY_ALLOC;      // 0x4000;
                return( FAILURE );
            }
            varExtPtr = varExtPtr->next;
            memcpy( varExtPtr->SymDefInfo , SymDefInfo , 51 );
        }
        else {          
            varExtHdrPtr = varExtPtr = new StoreExtendVar;
            if ( varExtPtr == 0 ) {
                m_dwErrorNum = ER_LDR_MEMORY_ALLOC;      // 0x4000;
                return( FAILURE );
            }
            memcpy( varExtPtr->SymDefInfo , SymDefInfo , 51 );
        }
    }   
    return GOOD;
}

/***************************************************************************
*                                                                          *
*  UbrofProcessBlockSym - Load UBROF local symbol information              *
*  parameter :                                                             *
*       None                                                               *
*  return value :                                                          *
*       0  ---  OK                 -1  ---  failure                        *
*                                                                          *
***************************************************************************/
int LoaderServer::UbrofProcessBlockSym(void)
{
    U32 address;     
    U16 ui;
    
    VAR_STORAGE_CLASS varStorage;
    VAR_REGISTER_CLASS registerClass;
//    BOOL isConst , isValid ;
    BOOLEAN isConst , isValid ;
    ADD_VAR_ADDR_UNION addr;
    SYM_DESCRIPTOR symDesc;
    
    registerClass = NOT_REG;
    if ( SymDefInfo[0] == 7 ) varStorage = AUTO_VAR_CLASS ;
    else if ( SymDefInfo[0] == 4 ) varStorage = STATIC_VAR_CLASS ;
    else if ( SymDefInfo[0] == 8 ) {
        varStorage = AUTO_VAR_CLASS ;
        registerClass = LIVING_REG;
    }
    else {
        varStorage = UNKNOWN_VAR_CLASS ;
        return GOOD;
    }
    ui = BinToU16(&SymDefInfo[1]);
    address = BinToU32(&SymDefInfo[3]);
    if ( ui == 6 ) isValid = FALSE ;
    else isValid = TRUE;
    if ( ui == 7 ) isConst = TRUE;
    else isConst = FALSE;
    if ( isValid ) {
        UbrofSegIdToEnum( (U8) ui , &addr.addr.segType );
        addr.addr.addr = address;
    }
    else {
        registerClass = LIVING_REG;
        addr.registerIndex = (U16) address;
    }
    ui = BinToU16(&SymDefInfo[8]);
    UbrofMatchAttrType( ui );
    UbrofTypeConv( ui );
    if ( SymDefInfo[10] == '?' && !m_bSpecSymbol ) return GOOD;
    if ( GOOD != SymAddVar((LPSTR)&SymDefInfo[10],ui,varStorage,
        registerClass,&addr,isConst,isValid,&symDesc) ) {
        m_dwErrorNum = ER_LDR_SYM_SERVER; // 0x4025;
        return ( FAILURE );
    }
    return GOOD;
}

/***************************************************************************
*                                                                          *
*  UbrofSegIdToEnum - convert ubrof segment ID to symbol server enum       *
*  parameter :                                                             *
*       ui     ---     ubrof segment ID                                    *
*       type   ---     symbol server segment enum                          *
*  return value :                                                          *
*       0  ---  OK                 -1  ---  failure                        *
*                                                                          *
***************************************************************************/
void UbrofSegIdToEnum(U8 ui , SEGMENTTYPE* type)
{
    switch (ui) {
    case 0:
        *type = SEG_UNTYPED ;
        break;
    case 1:         
        *type = SEG_CODE ;
        break;
    case 2:
    case 4:
        *type = SEG_DATA ;
        break;
    case 3:
        *type = SEG_XDATA ;
        break;
    case 5:
        *type = SEG_BIT ;
        break;
    case 6:
        *type = SEG_REGISTER ;
        break;
    case 7:
        *type = SEG_CONST ;
        break;
    default :
        *type = SEG_UNTYPED ;
        break;
    }
}

/***************************************************************************
*                                                                          *
*  UbrofTypeConv - convert ubrof symbol type to symbol server type         *
*  parameter :                                                             *
*       ui     ---     ubrof type                                          *
*  return value :                                                          *
*       0  ---  OK                 -1  ---  failure                        *
*                                                                          *
***************************************************************************/
void UbrofTypeConv(U16& ui)
{
    if ( ui >= 0x64 ) {
        ui += 156;
    }
    else {
        switch( ui ) {
        case 0 :
            ui = BI_UNKNOWN;
            break;
        case 1 :
            ui = BI_U8_UCHAR;
            break;
        case 2 :    /* signed char */
            ui = BI_S8_CHAR;            
            break;             
        case 3 :
            ui = BI_S16_USHORT;
            break;
        case 4 :
            ui = BI_S16_SHORT;
            break;
        case 5 :
            ui = BI_U16_UINT;
            break;
        case 6 :             
            ui = BI_S16_SINT;
            break;
        case 8 :
            ui = BI_S32_LONG;
            break;
        case 7 :             
            ui = BI_U32_ULONG;
            break;
        case 9 :
            ui = BI_F32;
            break;
        case 10 :
        case 0x0B :
            ui = BI_F64;
            break;
        case 0x0C :
            ui = BI_VOID;
            break;
        default :
            ui = BI_UNKNOWN;
            break;
        }
    }
}           

/***************************************************************************
*                                                                          *
*  InitVarExtendLink - initialize StoreExtendVar Link                      *
*  parameter :                                                             *
*       None                                                               *
*  return value :                                                          *
*       0  ---  OK                 -1  ---  failure                        *
*                                                                          *
***************************************************************************/
void InitVarExtendLink( void )
{
struct StoreExtendVar *ttt;
struct attrCC *tttt;

    varExtPtr = varExtHdrPtr ;
    while ( varExtPtr ) {
        ttt = varExtPtr->next ;
        delete varExtPtr ;
        varExtPtr = ttt;
    }
    varExtPtr = varExtHdrPtr = 0;

    attrExtPtr = attrExtHdrPtr ;
    while ( attrExtPtr ) {
        tttt = attrExtPtr->next ;
        delete attrExtPtr ;
        attrExtPtr = tttt;
    }
    attrExtPtr = attrExtHdrPtr = 0;
}

/***************************************************************************
*                                                                          *
*  UbrofMatchFuncType - match function type in StoreExtendVar Link         *
*  parameter :                                                             *
*       str  --  function name                                             *
*       typeIndex  --  function type                                       *
*  return value :                                                          *
*       0  ---  OK                 -1  ---  failure                        *
*                                                                          *
***************************************************************************/
void LoaderServer::UbrofMatchFuncType(char *str , TYPE_INDEX& typeIndex)
{
struct StoreExtendVar *ttt;

    ttt = varExtHdrPtr ;
    while ( ttt ) {
        if ( 0 == strcmp( (LPSTR)(&ttt->SymDefInfo[10]) , str ) ) {
            break;
        }
        ttt = ttt->next;
    }
    if ( ttt ) {
        U16 ui ;
        
        ui = BinToU16(&ttt->SymDefInfo[8]);
        UbrofMatchAttrType( ui );
        UbrofTypeConv( ui );
        typeIndex = (U32) ui;
    }
    else typeIndex = 0;
}

/***************************************************************************
*                                                                          *
*  UbrofMatchAttrType - match attribute type in attrCC Link                *
*  parameter :                                                             *
*       uType  --  attribute type                                          *
*  return value :                                                          *
*       0  ---  OK                 -1  ---  failure                        *
*                                                                          *
***************************************************************************/
void LoaderServer::UbrofMatchAttrType(U16& uType)
{
struct attrCC *ttt;

    ttt = attrExtHdrPtr ;
    while ( ttt ) {
        if ( uType == ttt->num ) {
            break;
        }
        ttt = ttt->next;
    }
    if ( ttt ) {
        uType = (U16) ttt->type;
    }
}

/******************************** E O F ***********************************/
