
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/MEMBIT.CPP   1.8   20 Jun 1996 09:28:30   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/MEMBIT.CPP  $
** 
**    Rev 1.8   20 Jun 1996 09:28:30   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.6   10 Jun 1996 10:23:08   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.4   29 May 1996 09:34:14   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:02:50   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:14:24   ZJRD
** EasyPack/SLD Version 1.93
** 
**    Rev 1.1   02 May 1996 10:29:14   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 12:58:28   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:42:10   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:57:12   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:08:32   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:34:58   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:49:18   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:15:18   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:18:42   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:18:36   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:34:48   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:25:36   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:07:42   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:16:34   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:08:42   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:09:28   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:30:20   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:20:00   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:22:42   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:33:12   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:29:42   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:43:50   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:04:46   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:47:40   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:48:50   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:28:28   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:52:38   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:18:46   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:52:24   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:58:18   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:45:14   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:54:42   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: MEMBIT.CPP
//
//  Description: The implementation file for the class: CMemoryBit.
//
//  Author: Chen Jun
//
//  Date: 06/22/95
//
//  Modification:
//      1. 06/22/95, Initial version of the class: CMemoryBit.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"

#include "membit.h"
#include "hosterrs.h"
extern RETCODE EXPORT ErrGetErrorText(U32 errorCode, LPSTR lpszError ...);
extern RETCODE EXPORT ErrGetErrorText(U32 errorCode, CString& strError ...);


/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Type definitions.


/////////////////////////////////////////////////////////////////////////////
// Macro definitions.


/////////////////////////////////////////////////////////////////////////////
// Global variables.


/////////////////////////////////////////////////////////////////////////////
// Static variables.


/////////////////////////////////////////////////////////////////////////////
// External variables.


/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.
void BitCmd(int nArgc, char* pszArgv[]);


/////////////////////////////////////////////////////////////////////////////
// Local function prototypes.


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.
#ifndef _SERVER_NO_ABI
    extern STATUS AbiSetMemN(ADDR addr, char* pchBuff, UINT uPatternLen);
#endif  // _SERVER_NO_ABI
extern BOOL GetCpuStatus(unsigned char &);
extern void ShowLine(char *);



/////////////////////////////////////////////////////////////////////////////
// Executable codes.

/////////////////////////////////////////////////////////////////////////////
// Public functions.

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   BitCmd().
//
//  Description: The main control routine of Bit command.
//
//  Input:  nArgc - Number of input parameters.
//          pszArgv - Input parameters.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void BitCmd(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 3 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
     
    char error[128];    
    // Bit to EMM.
    CMemoryBit* pMemoryBit = new CMemoryBit;
    if ( !pMemoryBit ) {
        AfxMessageBox("Insufficient Memory !");
        ASSERT( FALSE );
        return;
    }
    else {
       unsigned char result;         
       if ( ::GetCpuStatus(result) ) {
          if ( 1/*STATUS_GO*/ == result ) {
            //::ShowLine ("EP running. Stop EP first");
            ::ErrGetErrorText(ER_GOFLY_ERR_MSG, error);
            ::ShowLine (error);
          }    
          else {
            pMemoryBit->BitAction(nArgc, pszArgv);
            
          }           
       }   
       delete pMemoryBit;
    }

//    CMemoryBit objBit;
//    objBit.BitAction(nArgc, pszArgv);

}   // End of BitCmd().



/////////////////////////////////////////////////////////////////////////////
// Implementation codes of class: CMemoryBit.

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryBit::CMemoryBit().
//
//  Description: The construction of the class: CMemoryBit.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
CMemoryBit::CMemoryBit()
{

}   // End of CMemoryBit::CMemoryBit().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryBit::~CMemoryBit().
//
//  Description: The destruction of the class: CMemoryBit.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
CMemoryBit::~CMemoryBit()
{

}   // End of CMemoryBit::~CMemoryBit().



/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryBit::BitAction().
//
//  Description: Set Bit value to EMM.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void CMemoryBit::BitAction(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 3 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    
    // Set address & pattern.
    if ( 3 == nArgc ) {
        // Bit adr data.
        SetAddrVar(pszArgv[1], m_Addr);
        SetPattern(pszArgv[2]);
    }
    else {
        ASSERT( FALSE );
        return;
    }
    
    // Set the default memory space.
    if ( ':' != pszArgv[1][1] ) {
        m_Addr.m_uchType = MEM_BIT;
    }
    
    // Memory Bit kernel routine.
    MemoryBitKernel();
        
}   // End of CMemoryBit::BitAction().


void CMemoryBit::SetPattern(char* pszPattern)
{
    // Assertion of the input parameters.
    ASSERT( pszPattern );
    
    // Set the pattern buffer.
    m_uPatternLen = 0;
    while ( *pszPattern ) {
        char pszData[2];
        memset(pszData, 0, sizeof(pszData));
        for ( int i = 0; i <= 1; i++ ) {
            if ( ' ' != *pszPattern ) {
                pszData[i] = *pszPattern++;
            }
            else {
                pszPattern++;
                break;
            }
        }
        StrToVar(pszData);
        ((BYTE*) m_pchByte)[m_uPatternLen/1] = (BYTE) m_ulVar;
        m_uPatternLen += 1;
    }

}   // End of CMemoryBit::SetPattern().


void CMemoryBit::MemoryBitKernel(void)
{
    // Assertion of the input parameters.
    
    // Call Abi routine.
    ASSERT( MEM_BIT == m_Addr.m_uchType );
    m_nErrorID = AbiSetMemN((ADDR&) m_Addr, m_pchByte, m_uPatternLen);
    if ( 0 != m_nErrorID ) {
        DisplayErrorMessage();
    }
        
}   // End of CMemoryBit::MemoryDumpKernel().


//////////////////////////////// End of File ////////////////////////////////
