
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/MEMLONG.CPP   1.8   20 Jun 1996 09:26:18   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/MEMLONG.CPP  $
** 
**    Rev 1.8   20 Jun 1996 09:26:18   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.6   10 Jun 1996 10:20:56   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.4   29 May 1996 09:30:52   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:04:08   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:13:00   ZJRD
** EasyPack/SLD Version 1.93
** 
**    Rev 1.1   02 May 1996 10:27:54   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 13:01:38   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:38:38   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:51:34   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:06:02   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:32:34   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:46:48   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:13:20   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:17:32   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:17:28   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:36:52   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:27:24   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:10:38   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:11:42   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:12:38   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:11:56   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:33:58   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:19:44   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:22:26   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:34:00   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:34:28   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:44:24   Shirley
** EasyPack/SLD Version 0.22
** 
**    Rev 1.9   02 Nov 1995 10:05:52   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:48:02   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:46:04   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:30:16   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:51:40   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:20:16   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:49:34   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:55:50   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:46:00   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:54:50   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: MEMLONG.CPP
//
//  Description: The implementation file for the class: CMemoryLong.
//
//  Author: Chen Jun
//
//  Date: 06/20/95
//
//  Modification:
//      1. 06/20/95, Initial version of the class: CMemoryLong.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"

#include "memlong.h"
#include "hosterrs.h"
extern RETCODE EXPORT ErrGetErrorText(U32 errorCode, LPSTR lpszError ...);
extern RETCODE EXPORT ErrGetErrorText(U32 errorCode, CString& strError ...);


/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Type definitions.


/////////////////////////////////////////////////////////////////////////////
// Macro definitions.


/////////////////////////////////////////////////////////////////////////////
// Global variables.


/////////////////////////////////////////////////////////////////////////////
// Static variables.


/////////////////////////////////////////////////////////////////////////////
// External variables.


/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.
void LongCmd(int nArgc, char* pszArgv[]);


/////////////////////////////////////////////////////////////////////////////
// Local function prototypes.


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.
#ifndef _SERVER_NO_ABI
    extern STATUS AbiSetMemN(ADDR addr, char* pchBuff, UINT uPatternLen);
#endif  // _SERVER_NO_ABI

void SrcUpdate(void);
extern BOOL GetCpuStatus(unsigned char &);
extern void ShowLine(char *);



/////////////////////////////////////////////////////////////////////////////
// Executable codes.

/////////////////////////////////////////////////////////////////////////////
// Public functions.

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   LongCmd().
//
//  Description: The main control routine of Long command.
//
//  Input:  nArgc - Number of input parameters.
//          pszArgv - Input parameters.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void LongCmd(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 3 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    
    // Long to EMM.
    char error[128];
    CMemoryLong* pMemoryLong = new CMemoryLong;
    if ( !pMemoryLong ) {
        AfxMessageBox("Insufficient Memory !");
        ASSERT( FALSE );
        return;
    }
    else {
       unsigned char result;         
       if ( ::GetCpuStatus(result) ) {
          if ( 1/*STATUS_GO*/ == result ) {
            //::ShowLine ("EP running. Stop EP first");
            ::ErrGetErrorText(ER_GOFLY_ERR_MSG, error);
            ::ShowLine (error);
          }    
          else {
            pMemoryLong->LongAction(nArgc, pszArgv);
            
          }           
       }   
       delete pMemoryLong;
    }

//    CMemoryLong objLong;
//    objLong.SetLong(nArgc, pszArgv);

}   // End of LongCmd().



/////////////////////////////////////////////////////////////////////////////
// Implementation codes of class: CMemoryLong.

// The construction of the class: CMemoryLong.
CMemoryLong::CMemoryLong()
{

}   // End of CMemoryLong::CMemoryLong().


// The destruction of the class: CMemoryLong.
CMemoryLong::~CMemoryLong()
{

}   // End of CMemoryLong::~CMemoryLong().


// Set the Long value to EMM.
void CMemoryLong::LongAction(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 3 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    
    // Set address & pattern.
    if ( 3 == nArgc ) {
        // Long adr data.
        SetAddrVar(pszArgv[1], m_Addr);
        SetPattern(pszArgv[2]);
    }
    else {
        ASSERT( FALSE );
        return;
    }
    
    // Set the default memory space.
    if ( ':' != pszArgv[1][1] ) {
        m_Addr.m_uchType = MEM_EXTERNAL;
    }
    
    // Memory Long kernel routine.
    MemoryLongKernel();
        
}   // End of CMemoryLong::LongAction().


void CMemoryLong::SetPattern(char* pszPattern)
{
    // Assertion of the input parameters.
    ASSERT( pszPattern );
    
    // Set the pattern buffer.
    m_uPatternLen = 0;
    while ( *pszPattern ) {
        char pszData[9];
        memset(pszData, 0, sizeof(pszData));
        for ( int i = 0; i <= 8; i++ ) {
            if ( ' ' != *pszPattern ) {
                pszData[i] = *pszPattern++;
            }
            else {
                pszPattern++;
                break;
            }
        }
        StrToVar(pszData);
        ((LONG*) m_pchByte)[m_uPatternLen/4] = (LONG) m_ulVar;
        m_uPatternLen += 4;
    }

}   // End of CMemoryLong::SetPattern().


void CMemoryLong::MemoryLongKernel(void)
{
    // Assertion of the input parameters.
    
    // Call Abi routine.
    m_nErrorID = AbiSetMemN((ADDR&) m_Addr, m_pchByte, m_uPatternLen);

    // Update Source window.
    if ( MEM_PROGRAM == m_Addr.m_uchType ) {
        ::SrcUpdate();
    }

    if ( 0 != m_nErrorID ) {
        DisplayErrorMessage();
    }
        
}   // End of CMemoryLong::MemoryDumpKernel().


//////////////////////////////// End of File ////////////////////////////////
