
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/MYEDIT.CPP   1.8   20 Jun 1996 09:30:38   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/MYEDIT.CPP  $
** 
**    Rev 1.8   20 Jun 1996 09:30:38   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.6   10 Jun 1996 10:25:16   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.4   29 May 1996 09:38:10   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:00:28   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:14:54   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:22:46   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 13:02:30   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:41:24   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:56:22   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:07:40   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:34:08   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:44:36   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:20:10   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:17:02   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:16:56   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:38:00   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:25:06   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:09:28   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:12:28   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:14:58   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:10:10   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:31:00   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:24:04   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:24:42   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:28:58   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:32:00   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:45:52   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:08:02   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:45:20   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:47:38   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:30:28   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:51:52   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:22:50   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:49:48   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:52:50   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:48:30   Shirley
** EasyPack/SLDV0.1a 
** 
**    Rev 1.0   07 Sep 1995 09:53:50   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  MYEDIT.CPP
//
//  Description:The implement file for the class: CMyEdit
//
//  Author:     Lane Li
//
//  Date:       09/10/95
//
//  Modification:
//
//      1. 09/10/95, Initial version
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////
// myedit.cpp
// Lane Li
// 95/7
///////////////////////////////////////////
#include "stdafx.h"
#include "resource.h"
                                   
#include "myedit.h"

CEdit* CMyEdit::m_edit1 = NULL;
CEdit* CMyEdit::m_edit2 = NULL;

/////////////////////////////////////////////////////////////////////////////
// MyEdit

CMyEdit::CMyEdit()
: m_wParseStyle(0), m_nMin(0), m_nMax(0)
{
}

BEGIN_MESSAGE_MAP(CMyEdit, CEdit)
    //{{AFX_MSG_MAP(CMyEdit)
    ON_WM_CHAR()
    ON_WM_VSCROLL()     // for associated spin controls
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// Creating from C++ code

BOOL CMyEdit::Create(DWORD dwStyle, const RECT& rect,
        CWnd* pParentWnd, UINT nID)
{
    m_wParseStyle = LOWORD(dwStyle);
    // figure out edit control style
    DWORD dwEditStyle = MAKELONG(ES_LEFT, HIWORD(dwStyle));
    return CWnd::Create("EDIT", NULL, dwEditStyle, rect, pParentWnd, nID);
}

/////////////////////////////////////////////////////////////////////////////
// Aliasing on top of an existing Edit control

BOOL CMyEdit::SubclassEdit(UINT nID, CWnd* pParent, WORD wParseStyle)
{
    m_wParseStyle = wParseStyle;

    // SubclassWindow requires an HWND so we call the Windows GetDlgItem
    // and avoid creating a tempory CWnd and then calling GetSafeHwnd
    HWND hWndEdit = ::GetDlgItem(pParent->m_hWnd, nID);
    if (hWndEdit == NULL)   return FALSE;
    return SubclassWindow(hWndEdit);
}

BOOL CMyEdit::SubclassEdit2(UINT nID, CWnd* pParent, WORD wParseStyle)
{           
	static int count = 0;
	count++;
	if (count == 1) CMyEdit::m_edit1=this;
	if (count == 2) 
	{
		CMyEdit::m_edit2=this;
		count = 0;
	}
    m_wParseStyle = wParseStyle;

    // SubclassWindow requires an HWND so we call the Windows GetDlgItem
    // and avoid creating a tempory CWnd and then calling GetSafeHwnd
    HWND hWndEdit = ::GetDlgItem(pParent->m_hWnd, nID);
    if (hWndEdit == NULL)   return FALSE;
    return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// Input character filter

void CMyEdit::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags)
{
    WORD type;
    char buf[20];
    
    GetParent()->GetDlgItemText(GetDlgCtrlID(),buf,10);
    if(nChar < 0x20)    type = PES_ALL;     // always allow control chars
    else if(nChar >= '0' && nChar <= '9')   type = PES_NUMBERS;
    else if(nChar >= 'A' && nChar <= 'Z')   type = PES_LETTERS;
    else if(nChar >= 'a' && nChar <= 'z')   type = PES_LETTERS;
    else                                    type = PES_OTHERCHARS;
                      
	if ((buf[0]=='0')&&(buf[1]!='x')&&(buf[1]!='X'))
	{
		if ((nChar =='x')||(nChar =='X')) type = PES_NUMBERS;
	}
	                      
	if ((buf[0]=='0')&&((buf[1]=='x')||(buf[1]=='X')))
	{
		if (nChar >= 'a' && nChar <= 'f') type = PES_NUMBERS;
		if (nChar >= 'A' && nChar <= 'F') type = PES_NUMBERS;
	}
    
    if (m_wParseStyle & type)
        CEdit::OnChar(nChar, nRepCnt, nFlags);  // permitted
    else        // illegal character - inform parent
        OnBadInput();
}

/////////////////////////////////////////////////////////////////////////////
// Spin controls will send scroll messages

void CMyEdit::OnVScroll(UINT nSBCode, UINT, CScrollBar*)
{       
	char buf[20];
	long value;
	int nOld,nNew;
    int nDelta = 0;
    if(nSBCode == SB_LINEDOWN)        nDelta = -1;
    else if(nSBCode == SB_LINEUP)     nDelta = +1;
    else        return; // nothing special

    // set the focus to this edit item and select it all
    SetFocus();

    //Get the number in the control.
    BOOL bOk;
//    int nOld = GetParent()->GetDlgItemInt(GetDlgCtrlID(), &bOk);
	bOk=TRUE;
	GetParent()->GetDlgItemText(GetDlgCtrlID(),buf,10);
	buf[10]='\0';
	if ((buf[0]=='0')&&((buf[1]=='x')||(buf[1]=='X')))
	{
		value = strtol(buf,NULL,16);
		nOld = (int)value;
	}                     
	else
	{
		nOld = GetParent()->GetDlgItemInt(GetDlgCtrlID(), &bOk);
	}
    if(bOk) {                             
        // The MuScroll control also supports range checking
        // for this example, we just prevent overflow
        nNew = nOld + nDelta;
        if(nNew >= m_nMin && nNew <= m_nMax)
//            GetParent()->SetDlgItemInt(GetDlgCtrlID(), nNew);
		{   
			if ((buf[0]=='0')&&((buf[1]=='x')||(buf[1]=='X')))
			{   
				_itoa(nNew,buf+2,16);
				GetParent()->SetDlgItemText(GetDlgCtrlID(),buf);
			}   
			else 
				GetParent()->SetDlgItemInt(GetDlgCtrlID(), nNew);
		}
        else    bOk = FALSE;
    }

    if (!bOk)   OnBadInput();
    SetSel(0, -1);
    
    if ((m_edit1!=NULL)&&(m_edit2!=NULL)&&bOk)
    {
    	if (m_edit1==this)
    	{    
    		bOk=TRUE;
			(m_edit2->GetParent())->GetDlgItemText(GetDlgCtrlID()+1,buf,10);
			if ((buf[0]=='0')&&((buf[1]=='x')||(buf[1]=='X')))
			{
				value = strtol(buf,NULL,16);
				nOld = (int)value;
			}                     
			else
			{
				nOld = (m_edit2->GetParent())->GetDlgItemInt(GetDlgCtrlID()+1, &bOk);
			}
		    if(bOk) 
		    {                             
		    	if (nNew>nOld) 
		    	{
					if ((buf[0]=='0')&&((buf[1]=='x')||(buf[1]=='X')))
					{   
						_itoa(nNew,buf+2,16);
						(m_edit2->GetParent())->SetDlgItemText(GetDlgCtrlID()+1,buf);
					}   
					else 
						(m_edit2->GetParent())->SetDlgItemInt(GetDlgCtrlID()+1, nNew);
		    	}
		    }
		    else
				(m_edit2->GetParent())->SetDlgItemInt(GetDlgCtrlID()+1, nNew);
    	}
    	if (m_edit2==this)
    	{
    		bOk=TRUE;
			(m_edit1->GetParent())->GetDlgItemText(GetDlgCtrlID()-1,buf,10);
			if ((buf[0]=='0')&&((buf[1]=='x')||(buf[1]=='X')))
			{
				value = strtol(buf,NULL,16);
				nOld = (int)value;
			}                     
			else
			{
				nOld = (m_edit1->GetParent())->GetDlgItemInt(GetDlgCtrlID()-1, &bOk);
			}
		    if(bOk) 
		    {                             
		    	if (nNew<nOld) 
		    	{
					if ((buf[0]=='0')&&((buf[1]=='x')||(buf[1]=='X')))
					{   
						_itoa(nNew,buf+2,16);
						(m_edit1->GetParent())->SetDlgItemText(GetDlgCtrlID()-1,buf);
					}   
					else 
						(m_edit1->GetParent())->SetDlgItemInt(GetDlgCtrlID()-1, nNew);
		    	}
		    }
		    else
				(m_edit1->GetParent())->SetDlgItemInt(GetDlgCtrlID()-1, nNew);
    	}
    }
    SetSel(0, -1);
}

/////////////////////////////////////////////////////////////////////////////
// default bad input handler, beep (unless parent notification
//    returns -1.  Most parent dialogs will return 0 or 1 for command
//    handlers (i.e. Beep is the default)

void CMyEdit::OnBadInput()
{
    if (GetParent()->SendMessage(WM_COMMAND,
        GetDlgCtrlID(), MAKELONG(m_hWnd, PEN_ILLEGALCHAR)) != -1)
        MessageBeep(-1);
}

/////////////////////////////////////////////////////////////////////////////
