         
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/MYLIST.CPP   1.8   20 Jun 1996 09:28:44   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/MYLIST.CPP  $
** 
**    Rev 1.8   20 Jun 1996 09:28:44   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.6   10 Jun 1996 10:23:22   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.5   05 Jun 1996 14:57:46   ZJRD
** EasyPack/SLD Version 1.96
** 
**    Rev 1.3   16 May 1996 09:00:02   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:16:36   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:30:56   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.29   18 Apr 1996 12:56:04   Shirley
** No change.
** 
**    Rev 1.28   12 Apr 1996 10:35:06   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.26   15 Feb 1996 08:49:32   Shirley
** No change.
** 
**    Rev 1.25   12 Feb 1996 14:05:00   Shirley
** No change.
** 
**    Rev 1.24   06 Feb 1996 15:31:34   Shirley
** No change.
** 
**    Rev 1.23   06 Feb 1996 13:46:26   Shirley
** No change.
** 
**    Rev 1.22   01 Feb 1996 10:19:56   Shirley
** No change.
** 
**    Rev 1.21   26 Jan 1996 09:16:48   Shirley
** No change.
** 
**    Rev 1.20   25 Jan 1996 13:16:42   Shirley
** No change.
** 
**    Rev 1.19   24 Jan 1996 10:34:36   Shirley
** No change.
** 
**    Rev 1.18   23 Jan 1996 11:25:24   Shirley
** EasypPack/SLD Version 0.34c
** 
**    Rev 1.16   15 Jan 1996 16:16:24   Shirley
** No change.
** 
**    Rev 1.15   04 Jan 1996 11:08:30   Shirley
** EasyPack/SLD Version 0.34
** 
**    Rev 1.11   13 Nov 1995 09:24:10   Shirley
** No change.
** 
**    Rev 1.10   12 Nov 1995 11:32:20   Shirley
** EasyPack/SLD Version 0.24
** 
**    Rev 1.9   08 Nov 1995 16:30:44   Shirley
** No change.
** 
**    Rev 1.8   08 Nov 1995 12:45:20   Shirley
** No change.
** 
**    Rev 1.7   02 Nov 1995 10:05:42   Shirley
** EasyPack/SLD Version 0.21
** 
**    Rev 1.1   29 Sep 1995 09:53:14   Shirley
** No change.
** 
**    Rev 1.0   20 Sep 1995 10:56:42   Shirley
** Initial revision.
** 
**    
** 
** 
**
**
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  MYLIST.CPP
//
//  Description:The implementation file of main list for Peripheral window
//
//  Author:     Jerry Yan
//
//  Date:       09/18/95
//
//  Modification:
//
//      1. 09/18/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////


#include "stdafx.h" 
#include "malloc.h"
#include "resource.h"
#include "xview.h"
#include "mylist.h" 
#include "flddlg.h" 
#include "listcol.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif
                                 
extern UINT cpuid;  
extern  int Hex2Dec(char* reg_value);  
extern STATUS AbiGetCpuId(UINT*);
extern REGISTER RegVal[MAXRANGE];  
extern int ITEMRANGE;
extern int START_ID;  
extern HINSTANCE hPerLib;
/////////////////////////////////////////////////////////////////////////////
// CMyList

CMyList::CMyList(CWnd* parent):CListBox()
{ 
    m_pCloseBmp=new CBitmap;
	m_pOpenBmp=new CBitmap;    
    CRect rect(1,1,100,100);  
    Create(WS_VSCROLL|WS_HSCROLL|LBS_NOINTEGRALHEIGHT|WS_VISIBLE|\
    	LBS_NOTIFY|WS_CHILD|LBS_OWNERDRAWFIXED,rect, parent, IDC_LIST1); 
    
    HFONT hFont;
    hFont=(HFONT)GetStockObject(ANSI_FIXED_FONT);
    CFont Font; 
    SetFont(Font.FromHandle(hFont));
 
    InitList();
    SetHorizontalExtent(1400);          
}      


void CMyList::MeasureItem(LPMEASUREITEMSTRUCT lpMIS)
{
	// all items are of fixed size
	// must use LBS_OWNERDRAWVARIABLE for this to work
	lpMIS->itemHeight = 16;
}
  
void CMyList::DrawLine(CDC *pDC,PERI_DRAWDATA*lpData,CRect rect,BOOL flag)
{
	CDC*  pdcMemory=new CDC;
	BITMAP bm;          
	CBitmap*pbmpOld ;
    pdcMemory->CreateCompatibleDC(pDC);
    
	if(!(lpData->isBit))
		if(lpData->isExpanded)
		{
	    	m_pOpenBmp->GetObject(sizeof(BITMAP), &bm);
    		pbmpOld =pdcMemory->SelectObject(m_pOpenBmp);
	    	pDC->BitBlt(rect.left+1,rect.top+1,bm.bmWidth,bm.bmHeight,pdcMemory,0,0,SRCCOPY);
			pdcMemory->SelectObject(pbmpOld);
        	pdcMemory->DeleteDC();  
        	delete pdcMemory;
    	}
    	else 
		{
		    m_pCloseBmp->GetObject(sizeof(BITMAP), &bm);
    		pbmpOld =pdcMemory->SelectObject(m_pCloseBmp);
	    	pDC->BitBlt(rect.left+1,rect.top+1,bm.bmWidth,bm.bmHeight,pdcMemory,0,0,SRCCOPY);
			pdcMemory->SelectObject(pbmpOld);
    	    pdcMemory->DeleteDC();
    	    delete pdcMemory;
    	}
    if(flag)        
    	pDC->SetTextColor(RGB(0,0,255));
    else 	pDC->SetTextColor(RGB(255,255,255));
    if(lpData->isBit)
    {
    	lpData->Addr[1]=0;
        pDC->TextOut(rect.left+42,rect.top,lpData->Addr);
    }
    else
    {	    
    	lpData->Addr[3]=0;
    	pDC->TextOut(rect.left+40,rect.top,lpData->Addr);
    }
    if(flag)
		pDC->SetTextColor(RGB(255,0,0));      
	else 		                              
		pDC->SetTextColor(RGB(255,255,255));      
	char text[5]=""; 
	if(lpData->isBit)
	{
		 wsprintf(text,"%X",lpData->chVal);
		 text[1]=0;
	}
	else
	{
	    if((lpData->chVal)<='\xf')
		 	wsprintf(text,"0x0%X",lpData->chVal);
		else wsprintf(text,"0x%X",lpData->chVal);	
		text[4]=0;
	}		
	pDC->TextOut(rect.left+80,rect.top,text);     
	char sztemp[256]="";
	::LoadString(hPerLib,lpData->StringID,sztemp,255); 
    if(flag)
		pDC->SetTextColor(RGB(0,0,0));      
	else
		pDC->SetTextColor(RGB(255,255,255));	
	pDC->TextOut(rect.left+150,rect.top,sztemp); 
	if(!flag)                               
		pDC->SetTextColor(RGB(0,0,0));      
		      
}  
  
  
void CMyList::DrawItem(LPDRAWITEMSTRUCT lpDIS)
{
	CDC* pDC = CDC::FromHandle(lpDIS->hDC);
	PERI_DRAWDATA *lpData=(PERI_DRAWDATA *)(lpDIS->itemData); 
    pDC->SetBkMode(TRANSPARENT);
    CRect rect=lpDIS->rcItem;
//    rect.InflateRect(0,-1);
	if ((lpDIS->itemState & ODS_SELECTED) &&
		(lpDIS->itemAction & (ODA_SELECT | ODA_DRAWENTIRE)))
	{
		// item has been selected - hilite frame
		COLORREF crHilite = RGB(0,0,255);
		CBrush br(crHilite);
        pDC->FillRect(&lpDIS->rcItem,&br);
		DrawLine(pDC,lpData,rect,0);			
	}

	if (!(lpDIS->itemState & ODS_SELECTED) &&
		(lpDIS->itemAction & ODA_SELECT))
	{
		// Item has been de-selected -- remove frame
		CBrush br(RGB(255,255,255));
        pDC->FillRect(&lpDIS->rcItem,&br);
		DrawLine(pDC,lpData,rect,1);			
	}

	if ( (lpDIS->itemAction & ODA_DRAWENTIRE)&&!(lpDIS->itemState&ODS_SELECTED))
	{
		// Paint the color item in the color requested
		DrawLine(pDC,lpData,rect,1);
	}

}






BOOL CMyList::InitList()
{

    int   index;
    DWORD i;
    int   addrid=START_ID+1000; 

    if(!m_pCloseBmp->LoadBitmap(IDB_VAR_CLOSE_RED)) 
    {	AfxMessageBox("Can not load Bitmap");
        return 0;
    }    
    if(!m_pOpenBmp->LoadBitmap(IDB_VAR_OPEN_RED))
    {
    	AfxMessageBox("Can not load Bitmap");
    	return 0;
    }		
    PERI_DRAWDATA * lpDrawData;
    char sztemp[256];
    for(index=0;index<ITEMRANGE; index++)
    { 
    	lpDrawData=new PERI_DRAWDATA;
        i=START_ID+index*32;
        lpDrawData->Index=index;
        lpDrawData->offset=0; 
        ::LoadString(hPerLib,addrid,sztemp,255);   
        char *szaddr;
        szaddr=strtok(sztemp,",");
        strncpy(lpDrawData->Addr,szaddr,3);
         //GetRegValue();     
          
        lpDrawData->chVal=(char) RegVal[index].value;
        lpDrawData->StringID=(UINT)i;
        strncpy(lpDrawData->Addr,szaddr,3);
        lpDrawData->isBit=0;
        lpDrawData->isExpanded=0;
        
        AddString((LPSTR)lpDrawData); 
        SetItemDataPtr(index, lpDrawData); 
        addrid++;  
         
       }
   return 1;                      
}      


CMyList::~CMyList()
{     
	delete  m_pCloseBmp;
	delete m_pOpenBmp;    
	ResetContent();
} 


void CMyList::ResetContent()
{
	PERI_DRAWDATA *lpData;   
	int count;
	count=GetCount();
	while(count!=0)
	{
		lpData=(PERI_DRAWDATA*)GetItemDataPtr(count-1);
		delete lpData;
		DeleteString(count-1);                
		count=GetCount();
	}
}

BEGIN_MESSAGE_MAP(CMyList, CListBox)
    //{{AFX_MSG_MAP(CMyList)
    ON_WM_LBUTTONUP()   
	ON_WM_LBUTTONDBLCLK()
	ON_WM_RBUTTONDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMyList message handlers

     
void CMyList::OnLButtonUp(UINT nFlags,CPoint point)
{
    CWnd::OnLButtonUp(nFlags,point);
    PERI_DRAWDATA * lpDrawData;
    if((1<point.x) &&(point.x<40))
       { 
         int cursel;
         cursel=GetCurSel();   
         lpDrawData=(PERI_DRAWDATA*)GetItemDataPtr(cursel);
         
         if ( !lpDrawData->isBit )        
            { 
              if(!lpDrawData->isExpanded) 
              { 
                  lpDrawData->isExpanded=1;
                  DeleteString(cursel);
                  InsertString(cursel,(LPSTR)lpDrawData);
                  SetItemDataPtr(cursel,lpDrawData);
                  InsertBitItem(cursel,lpDrawData);
                 }
              else
                { 
                  lpDrawData->isExpanded=0;
                  DeleteString(cursel);
                  InsertString(cursel,(LPSTR)lpDrawData);
                  SetItemDataPtr(cursel,lpDrawData);
                  DeleteBitItem(cursel,lpDrawData);   
                }             
            } 
          SetCurSel(cursel);      
       }
      //////////modify by jerry/11/9/95/////////////       

} 



void CMyList::InsertBitItem(int reg_index,PERI_DRAWDATA* lpDrawData)
{
    char sztemp[64]="";  
    char szBuff[256]="";
    int regval; 
    int Addrid;
//    Addrid=LOWORD(dw);
    Addrid=lpDrawData->Index;
    regval=RegVal[Addrid].value ; 
    
        
    if( (cpuid==2) || (cpuid==3) )
        Addrid+=START_ID+1100;
    else
        Addrid+=START_ID+1000;
                                   
    ::LoadString(hPerLib,Addrid,sztemp,255); 

    //set field listbox        
    char *szaddr;
    szaddr=strtok(sztemp,",");  
    szaddr=strtok(NULL,",");
    
    int len;
    int n; 
    int i,m=reg_index+1; 
    int id=lpDrawData->StringID;
    
    char szval[256]="";
    
    PERI_DRAWDATA *lpData;
    for(i=0;i<255;i++)
       szval[i]=' '; 

    int curid,power=1;   
    int  regvaltemp; 
    
    while( szaddr)
    {  
	   lpData=new PERI_DRAWDATA ;
	   lpData->isBit=1;		   	                               
       n=0;                       
       id++;
       curid=id;

       len=strlen(szaddr);   
       strncpy(lpData->Addr,szaddr,len);
       regvaltemp=regval>>(atoi(szaddr));  
       power=1;
       for(i=0;i<(len+1)/2;i++)
       { 
            n+=(regvaltemp&(0x1))*power;
            regvaltemp=regvaltemp>>1;
            power=power*2;
       }
       id=id+power;                            
       regvaltemp=regval ; 

       lpData->chVal=(char)n;
       lpData->Index=lpDrawData->Index;
	   lpData->StringID=curid+1+n;
       lpData->offset=(char)(m-reg_index);
       InsertString(m,(LPSTR)lpData); 
       SetItemDataPtr(m,lpData);
       szaddr=strtok(NULL,",");  
       m++;              
     }       
}        



void CMyList::DeleteBitItem(int reg_index,PERI_DRAWDATA* lpDrawData)
{      
    char sztemp[256]="" ;
    int Addrid; 
//    Addrid=LOWORD(dw);
//    Addrid=HIBYTE(Addrid);
	Addrid=lpDrawData->Index;
/////////////////////////////////////////    
//    Addrid+=START_ID+1000;           //
///////////////////////////////////////// 
    PERI_DRAWDATA* lpData;
    if( (cpuid==2) || (cpuid==3) )
        Addrid+=START_ID+1100;
    else
        Addrid+=START_ID+1000;  
///////////////////////////////////////////
        
    ::LoadString(hPerLib,Addrid,sztemp,255); 
     
    char *szaddr;
    szaddr=strtok(sztemp,",");  
    int i=0;
    while(szaddr)
    {
        szaddr=strtok(NULL,",");
        i++;
     } 
    int n;     
    for (n=reg_index+1;n<reg_index+i;n++)
    {
       lpData=(PERI_DRAWDATA*)GetItemDataPtr(reg_index+1);
       delete lpData;
       DeleteString(reg_index+1);  
    }
}


//////////////////Modified by Jerry  5/10/95  //////////////
       
void CMyList::OnLButtonDblClk(UINT nFlags, CPoint point)
{
	OnLButtonUp(nFlags,point);	
	//CListBox::OnLButtonDblClk(nFlags, point);
}

void CMyList::OnRButtonDown(UINT, CPoint point)
{
    GetParent()->SendMessage(WM_RBUTTONDOWN,0,MAKELONG(point.x,point.y));
}    