
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/NWMEM.CPP   1.8   20 Jun 1996 09:27:32   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/NWMEM.CPP  $
** 
**    Rev 1.8   20 Jun 1996 09:27:32   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.6   10 Jun 1996 10:22:10   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.5   05 Jun 1996 14:51:28   ZJRD
** EasyPack/SLD Version 1.96
** 
**    Rev 1.4   29 May 1996 09:32:46   ZJRD
** EasyPack/SLD Version 1.95
** 
**    Rev 1.3   16 May 1996 09:04:54   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:13:46   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:24:18   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 12:53:34   Shirley
** EasyPack/SLD Version 1.91
** 
**    Rev 1.30   12 Apr 1996 10:40:24   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:56:32   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:07:52   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:34:20   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:48:38   Shirley
** EasyPack/SLD Version 0.36
** 
**    Rev 1.24   01 Feb 1996 10:13:00   Shirley
** EasyPack/SLD Version 0.35b
** 
**    Rev 1.23   26 Jan 1996 09:17:14   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:17:10   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:38:12   Shirley
** EasyPack/SLD Version 0.34d
** 
**    Rev 1.20   23 Jan 1996 11:23:24   Shirley
** EasypPack/SLD Version 0.34c
** 
**    Rev 1.19   18 Jan 1996 10:12:52   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:10:20   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:09:36   Shirley
** EasyPack/SLD Version 0.34
** 
**    Rev 1.16   30 Nov 1995 09:13:00   Shirley
** EasyPack/SLD Version 0.33
** 
**    Rev 1.15   28 Nov 1995 15:35:20   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:24:32   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:25:26   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:28:22   Shirley
** EasyPack/SLD Version 0.24
**
**    Rev 1.11   08 Nov 1995 16:29:10   Shirley
** No change.
**
**    Rev 1.10   08 Nov 1995 12:39:40   Shirley
** EasyPack/SLD Version 0.22
**
**    Rev 1.4   13 Oct 1995 13:22:52   Shirley
** EasyPack/SLD Version 0.1d
**
**    Rev 1.3   29 Sep 1995 09:49:50   Shirley
** No change.
**
**    Rev 1.2   20 Sep 1995 10:52:52   Shirley
** No change.
**
**    Rev 1.1   15 Sep 1995 09:48:34   Shirley
** EasyPack/SLDV0.1a
**
**    Rev 1.0   07 Sep 1995 09:53:50   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  NWMEM.CPP
//
//  Description:The implement file for the class: CNewMemory
//
//  Author:     Lane Li & Daniel Lin
//
//
//  Modification:
//      7. 03/12/1996--03/26/1996   1.0 Version    Daniel Lin
//              modify function
//               OnPaint()
//               OnSize()
//               OnKeyDown()
//               GetMemory()
//               OnVScroll()
//               OnHScroll()
//               Left()
//               Right()
//               Tab()
//               Tab1()
//               Home()
//               End()
//               OnEditGoto()
//
//
//      6. 1/29/96, 0.35 version       Daniel Lin
//              modified function   GetMemory() 
//
//      5. 10/31/95, 0.1h version               Daniel Lin
//              modified function   ShowAddress()
//              modified function   Up()
//              modified function   Down()
//              modified function   OnKeyDown()
//
//      4. 10/30/95, 0.1h version               Daniel Lin
//              modified function   ShowAddress()
//              modified function   NewMemoryOpenWindow()
//              modified function   GetMemory();
//
//      3. 10/20/95, 0.1d version       Daniel Lin
//              modified function   OnMDIActivate()
//
//      2. 10/19/95, 0.1d version       Daniel Lin
//              modified function   GetMemory();
//              modified function   ShowAddress();
//              modified function   OnKeyDown();
//              modified function   OnRButtonDown()
//
//
//  Modification:
//
//      1. 09/10/95, Initial version
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

//
// nwmem.cpp : implementation file
//

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include "stdafx.h"
#include "resource.h"

#include "uicom.h"

#include "zqueue.h"
#include "srccom.h"

#include "xview.h"
#include "grid.h"
#include "nwmem.h"
#include "ctype.h"
#include "errno.h"
#include "myedit2.h"
#include "spin.h"
#include "mapdlg.h"
#include "tabdll11.h"
#include "tabvbmfc.h"
#include "mempage.h"          // Add by Daniel
#include "memdlg.h"
#include "memgtdlg.h"
#include "dsmgtdlg.h"
#include "dad.h"
#include "dsmedit1.h"
#include "dsmedit2.h"
#include "memschdg.h"
#include "cpucom.h"
#include "abibase.h"
#include "cpuserve.h"

#include "address.h"
#include "addrapi.h"
#include "btnbar.h"
#include "mainfrm.h"

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/
extern ADDR_SIZE  dwpMax;        // program  max address
extern ADDR_SIZE  dwpMin;        // program  min address
extern ADDR_SIZE  dwxMax;        // external max address
extern ADDR_SIZE  dwxMin;        // external min address
extern ADDR_SIZE  dwiMax;        // external max address
extern ADDR_SIZE  dwiMin;        // external min address


                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/
extern long MemServerDump(BYTE*,long,long,int);
extern int MemServerFill(long,BYTE,int);
extern int GetDsm (long, int, DADMEMSTRU*, int);
extern BOOL MemServerSearch(unsigned short uStart, unsigned short uEnd,
                            unsigned char uchType, char* pszPattern,
                            int nInsensitive, unsigned short& uRetAddr);
extern int GetMemoryRange(CPUMEMORYRANGE *stRange);
extern void SrcUpdate(void);

/*
    Output : uchStatus = the current cpu status
             STATUS_HALT  == 0
             STATUS_GO    == 1
             STATUS_GORUN == 2
    returN : TRUE ==> GET OK
             FALSE ==> GET FAIL
*/
extern BOOL GetCpuStatus(unsigned char & uchStatus);

                       /****************************
                        *                          *
                        *       GLOBAL VARS        *
                        *                          *
                        ****************************/
long linLastStartAddr = 0;
unsigned char   linLastCheck = 1;
long LastMem1Address = 0;
long LastMem2Address = 0;
long LastMem3Address = 0;

long LastSet1Address = 0;
long LastSet2Address = 0;
long LastSet3Address = 0;

unsigned char LastMem1Space = 1;
unsigned char LastMem2Space = 1;
unsigned char LastMem3Space = 1;

int LastMem1View1 = 1;
int LastMem2View1 = 1;
int LastMem3View1 = 1;

int LastMem1View2 = 3;
int LastMem2View2 = 3;
int LastMem3View2 = 3;

BOOL Mem1;
BOOL Mem2;
BOOL Mem3;

BOOL Cur1;
BOOL Cur2;
BOOL Cur3;

static int nOldCy = 0;
int   gRedraw = 0;         // Add on 5.21.96

                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/
                        
////////////////////////////////////////////////////////////////////////
// Minimize all memory window include the three memory window and the 
//  bit memory window
//       Only for when the CPU at GO status, the memory window can not
//       do anything
//                        
void MinAllMemWnd(void)
{   
/*
    if(isMemOn[0]) pMemWnd[0]->ShowWindow(SW_SHOWMINIMIZED);
    if(isMemOn[1]) pMemWnd[1]->ShowWindow(SW_SHOWMINIMIZED);
    if(isMemOn[2]) pMemWnd[2]->ShowWindow(SW_SHOWMINIMIZED);
    if(isBMemOn) pBMemWnd->ShowWindow(SW_SHOWMINIMIZED);
*/    
}

//////////////////////////////////////////////////////////////////////////
// Open the memory window
//    Called by Mainframe
//                        
void NewMemoryOpenWindow(CMDIFrameWnd *pParent,int no)
{
    if (isMemOn[no])
      return;

    pMemWnd[no] = new CNewMemory;
    ((CNewMemory *)(pMemWnd[no]))->m_nWndNo = no;
    switch (no) {
      case 0:
           Mem1 = 1;
           Cur1 = 1;
           ((CNewMemory *)(pMemWnd[no]))->m_lStartAddress = LastMem1Address;
           ((CNewMemory *)(pMemWnd[no]))->m_nSpaceType = LastMem1Space;
           ((CNewMemory *)(pMemWnd[no]))->m_nViewMode1 = LastMem1View1;
           ((CNewMemory *)(pMemWnd[no]))->m_nViewMode2 = LastMem1View2;
           break;
      case 1:
           Mem2 = 1;
           Cur2 = 1;
           ((CNewMemory *)(pMemWnd[no]))->m_lStartAddress = LastMem2Address;
           ((CNewMemory *)(pMemWnd[no]))->m_nSpaceType = LastMem2Space;
           ((CNewMemory *)(pMemWnd[no]))->m_nViewMode1 = LastMem2View1;
           ((CNewMemory *)(pMemWnd[no]))->m_nViewMode2 = LastMem2View2;
           break;
      case 2:
           Mem3 = 1;
           Cur3 = 1;
           ((CNewMemory *)(pMemWnd[no]))->m_lStartAddress = LastMem3Address;
           ((CNewMemory *)(pMemWnd[no]))->m_nSpaceType = LastMem3Space;
           ((CNewMemory *)(pMemWnd[no]))->m_nViewMode1 = LastMem3View1;
           ((CNewMemory *)(pMemWnd[no]))->m_nViewMode2 = LastMem3View2;
           break;
    }
    if(!((CNewMemory *)pMemWnd[no])->Create("Memory",
        WS_CHILD|WS_VISIBLE|WS_OVERLAPPEDWINDOW|WS_VSCROLL|WS_HSCROLL,
        CFrameWnd::rectDefault, pParent))
      ASSERT(0);
    else
      isMemOn[no]=TRUE;
}

CMenu NEAR CNewMemory::m_menu;

char CNewMemory::m_searchStr[200] = "";

/////////////////////////////////////////////////////////////////////////////
// CNewMemory
//
//
IMPLEMENT_DYNCREATE(CNewMemory, CMDIChildWnd)

BOOL CNewMemory::Create(LPCSTR szTitle, LONG style,
                        const RECT& rect, CMDIFrameWnd * pParent)
{
    // Setup the shared m_menu
    if(m_menu.m_hMenu == NULL)  m_menu.LoadMenu(IDR_MEMORY);
    m_hMenuShared = m_menu.m_hMenu;

    const char * pszMemoryClass =
        AfxRegisterWndClass(CS_HREDRAW|CS_VREDRAW|CS_DBLCLKS,NULL,
                           (HBRUSH)(COLOR_WINDOW + 1),
                           AfxGetApp()->LoadIcon(IDR_MEMORY));
    if (!(CMDIChildWnd::Create(pszMemoryClass, szTitle,
                         style, rect, pParent)))
      return FALSE;                         
    else
      return TRUE;      
}                         

void CNewMemory::SetWindowTitle()
{
    switch (m_nSpaceType) {
        case 1:
            switch(m_nWndNo) {
                case 0:
                    SetWindowText("Program Memory:1");
                    break;
                case 1:
                    SetWindowText("Program Memory:2");
                    break;
                case 2:
                    SetWindowText("Program Memory:3");
                    break;
                default:
                    SetWindowText("Program Memory");
                    break;
            }
            break;
        case 2:
            switch(m_nWndNo) {
                case 0:
                    SetWindowText("Data Memory:1");
                    break;
                case 1:
                    SetWindowText("Data Memory:2");
                    break;
                case 2:
                    SetWindowText("Data Memory:3");
                    break;
                default:
                    SetWindowText("Data Memory");
                    break;
            }
            break;
        case 3:
            switch(m_nWndNo) {
                case 0:
                    SetWindowText("On_Chip Data Memory:1");
                    break;
                case 1:
                    SetWindowText("On_Chip Data Memory:2");
                    break;
                case 2:
                    SetWindowText("On_Chip Data Memory:3");
                    break;
                default:
                    SetWindowText("On_Chip Data Memory");
                    break;
            }
            break;
        default:
            switch(m_nWndNo) {
                case 0:
                    SetWindowText("Data Memory:1");
                    break;
                case 1:
                    SetWindowText("Data Memory:2");
                    break;
                case 2:
                    SetWindowText("Data Memory:3");
                    break;
                default:
                    SetWindowText("Data Memory");
                    break;
            }
            break;
    }
}

void CNewMemory::FillText(LPCSTR lpszText,UINT nCount,RECT rect,CDC* dc)
{
    SIZE size;

    dc->SelectStockObject(ANSI_FIXED_FONT);
    size = dc->GetOutputTextExtent(lpszText, nCount);
    int addx = 1;
    int addy = (rect.bottom - rect.top - size.cy) / 2 + 1;
    dc->ExtTextOut(rect.left+addx, rect.top+addy,
        ETO_CLIPPED,
        &rect,
        lpszText,
        nCount,
        NULL);
}

void CNewMemory::FillText2(LPCSTR lpszText,UINT nCount,RECT rect,CDC* dc)
{
    SIZE size;
    char text[256];

    memset(text,' ',255);
    text[255]='\0';
    dc->SelectStockObject(ANSI_FIXED_FONT);
    size = dc->GetOutputTextExtent(lpszText, nCount);
    int addx = 1;
    int addy = (rect.bottom - rect.top - size.cy) / 2 + 1;
    dc->ExtTextOut(rect.left+addx, rect.top+addy,
                   ETO_CLIPPED,
                   &rect,
                   text,
                   255,
                   NULL);
    dc->ExtTextOut(rect.left+addx, rect.top+addy,
                   ETO_CLIPPED,
                   &rect,
                   lpszText,
                   nCount,
                   NULL);
}

void CNewMemory::FillText3(LPCSTR lpszText,UINT nCount,RECT rect,CDC* dc)
{
    SIZE size;
    char text[256];

    memset(text,' ',255);
    text[255]='\0';
    dc->SelectStockObject(ANSI_FIXED_FONT);
    size = dc->GetOutputTextExtent(lpszText, nCount);
    if (size.cx>m_gridInstruction.m_nGridWidth) {
        m_nInstructionWidth = size.cx+10;
        InvalidateRect(NULL,TRUE);
        return;
    }
    int addx = 1;
    int addy = (rect.bottom - rect.top - size.cy) / 2 + 1;
    dc->ExtTextOut(rect.left+addx, rect.top+addy,
                   ETO_CLIPPED, &rect, text, 255, NULL);
    dc->ExtTextOut(rect.left+addx, rect.top+addy,
                   ETO_CLIPPED, &rect, lpszText, nCount, NULL);
}

void CNewMemory::SetScrollBar()
{
    RECT rect1,rect2;
    BOOL bBar;

    GetClientRect(&rect2);
    bBar = FALSE;

    if (m_nViewMode2 != 4) {
        if (m_bShowAscii) {
            rect1 = m_gridAscii.GetGridRect(0,0);
            if (rect1.right > rect2.right) bBar = TRUE;
        }
        else {
            rect1 = m_gridMem.GetGridRect(m_gridMem.m_nRows-1,0);
            if (rect1.right > rect2.right) bBar = TRUE;
        }
    }
    else {
        rect1 = m_gridInstruction.GetGridRect(0,0);
        if (rect1.right > rect2.right) bBar = TRUE;
    }

    if (m_nPosX<0) {
        if (rect2.right>rect1.right) {
            m_nPosX = m_nPosX + (rect2.right-rect1.right);
            if (m_nPosX>0) m_nPosX = 0;
        }
    }
    else 
      m_nPosX = 0;

    if (m_nPosX<0) 
      bBar = TRUE;

    ShowScrollBar(SB_HORZ, bBar);
    if (bBar) {
        SetScrollRange(SB_HORZ, 0, (rect1.right-rect2.right-m_nPosX),TRUE);
        SetScrollPos(SB_HORZ, -m_nPosX, TRUE);
    }
}

void CNewMemory::ScrollMemWnd(int nFlags)
{
    CRect rect1,rect2;

    GetClientRect(&rect1);
    rect1.top = m_gridAddr.m_nGridHeight+1;
    if (-1 == nFlags) {
        rect2 = rect1;
        ScrollWindowEx(0, -(m_gridAddr.m_nGridHeight), &rect1, &rect2,
                       NULL, NULL, SW_INVALIDATE);
    }

    if (1 == nFlags) {
        rect2 = rect1;
        ScrollWindowEx(0, m_gridAddr.m_nGridHeight, &rect1, &rect2,
                       NULL, NULL, SW_INVALIDATE);
    }
}

void CNewMemory::SetAddress()
{
    m_gridAddr.SetPos(m_nPosX,0);
    m_gridAddr.SetLines(m_nLines);
    m_gridAddr.SetRows(1);
    m_gridAddr.SetGridWidth(AddressWidth);
    memcpy(m_gridAddr.m_lpszTitle,"Addr\0",8);
    m_gridAddr.DoRect();
}

void CNewMemory::SetAscii()
{
    m_gridMem.DoRect();
    m_gridAscii.SetPos(m_gridMem.m_rectPos.right,0);
    m_gridAscii.SetLines(m_nLines);
    m_gridAscii.SetRows(1);
    m_gridAscii.SetGridWidth(AsciiWidth);
    memcpy(m_gridAscii.m_lpszTitle,"ASCII\0",6);
    m_gridAscii.DoRect();
}

void CNewMemory::SetInstruction()
{
    m_gridMem.DoRect();
    m_gridInstruction.SetPos(m_gridMem.m_rectPos.right,0);
    m_gridInstruction.SetLines(m_nLines);
    m_gridInstruction.SetRows(1);
    m_gridInstruction.SetGridWidth(m_nInstructionWidth);
    memcpy(m_gridInstruction.m_lpszTitle,"Instruction\0",12);
    m_gridInstruction.DoRect();
}

void CNewMemory::SetByteSignedDecimal()
{
    m_gridAddr.DoRect();
    m_gridMem.SetPos(m_gridAddr.m_rectPos.right,0);
    m_gridMem.SetLines(m_nLines);
    m_gridMem.SetRows(16);
    m_gridMem.SetGridWidth(ByteSignedDecimalWidth);
    m_gridMem.m_lpszTitle[0]='0';
    m_gridMem.m_lpszTitle[1]='\0';
    m_gridMem.m_lpszTitle[2]='1';
    m_gridMem.m_lpszTitle[3]='\0';
    m_gridMem.m_lpszTitle[4]='2';
    m_gridMem.m_lpszTitle[5]='\0';
    m_gridMem.m_lpszTitle[6]='3';
    m_gridMem.m_lpszTitle[7]='\0';
    m_gridMem.m_lpszTitle[8]='4';
    m_gridMem.m_lpszTitle[9]='\0';
    m_gridMem.m_lpszTitle[10]='5';
    m_gridMem.m_lpszTitle[11]='\0';
    m_gridMem.m_lpszTitle[12]='6';
    m_gridMem.m_lpszTitle[13]='\0';
    m_gridMem.m_lpszTitle[14]='7';
    m_gridMem.m_lpszTitle[15]='\0';
    m_gridMem.m_lpszTitle[16]='8';
    m_gridMem.m_lpszTitle[17]='\0';
    m_gridMem.m_lpszTitle[18]='9';
    m_gridMem.m_lpszTitle[19]='\0';
    m_gridMem.m_lpszTitle[20]='A';
    m_gridMem.m_lpszTitle[21]='\0';
    m_gridMem.m_lpszTitle[22]='B';
    m_gridMem.m_lpszTitle[23]='\0';
    m_gridMem.m_lpszTitle[24]='C';
    m_gridMem.m_lpszTitle[25]='\0';
    m_gridMem.m_lpszTitle[26]='D';
    m_gridMem.m_lpszTitle[27]='\0';
    m_gridMem.m_lpszTitle[28]='E';
    m_gridMem.m_lpszTitle[29]='\0';
    m_gridMem.m_lpszTitle[30]='F';
    m_gridMem.m_lpszTitle[31]='\0';
    m_gridMem.DoRect();
}

void CNewMemory::SetWordSignedDecimal()
{
    m_gridAddr.DoRect();
    m_gridMem.SetPos(m_gridAddr.m_rectPos.right,0);
    m_gridMem.SetLines(m_nLines);
    m_gridMem.SetRows(8);
    m_gridMem.SetGridWidth(WordSignedDecimalWidth);
    m_gridMem.m_lpszTitle[0]='0';
    m_gridMem.m_lpszTitle[1]='\0';
    m_gridMem.m_lpszTitle[2]='2';
    m_gridMem.m_lpszTitle[3]='\0';
    m_gridMem.m_lpszTitle[4]='4';
    m_gridMem.m_lpszTitle[5]='\0';
    m_gridMem.m_lpszTitle[6]='6';
    m_gridMem.m_lpszTitle[7]='\0';
    m_gridMem.m_lpszTitle[8]='8';
    m_gridMem.m_lpszTitle[9]='\0';
    m_gridMem.m_lpszTitle[10]='A';
    m_gridMem.m_lpszTitle[11]='\0';
    m_gridMem.m_lpszTitle[12]='C';
    m_gridMem.m_lpszTitle[13]='\0';
    m_gridMem.m_lpszTitle[14]='E';
    m_gridMem.m_lpszTitle[15]='\0';
    m_gridMem.DoRect();
}

void CNewMemory::SetLongSignedDecimal()
{
    m_gridAddr.DoRect();
    m_gridMem.SetPos(m_gridAddr.m_rectPos.right,0);
    m_gridMem.SetLines(m_nLines);
    m_gridMem.SetRows(4);
    m_gridMem.SetGridWidth(LongSignedDecimalWidth);
    m_gridMem.m_lpszTitle[0]='0';
    m_gridMem.m_lpszTitle[1]='\0';
    m_gridMem.m_lpszTitle[2]='4';
    m_gridMem.m_lpszTitle[3]='\0';
    m_gridMem.m_lpszTitle[4]='8';
    m_gridMem.m_lpszTitle[5]='\0';
    m_gridMem.m_lpszTitle[6]='C';
    m_gridMem.m_lpszTitle[7]='\0';
    m_gridMem.DoRect();
}

void CNewMemory::SetByteUnsignedDecimal()
{
    m_gridAddr.DoRect();
    m_gridMem.SetPos(m_gridAddr.m_rectPos.right,0);
    m_gridMem.SetLines(m_nLines);
    m_gridMem.SetRows(16);
    m_gridMem.SetGridWidth(ByteUnsignedDecimalWidth);
    m_gridMem.m_lpszTitle[0]='0';
    m_gridMem.m_lpszTitle[1]='\0';
    m_gridMem.m_lpszTitle[2]='1';
    m_gridMem.m_lpszTitle[3]='\0';
    m_gridMem.m_lpszTitle[4]='2';
    m_gridMem.m_lpszTitle[5]='\0';
    m_gridMem.m_lpszTitle[6]='3';
    m_gridMem.m_lpszTitle[7]='\0';
    m_gridMem.m_lpszTitle[8]='4';
    m_gridMem.m_lpszTitle[9]='\0';
    m_gridMem.m_lpszTitle[10]='5';
    m_gridMem.m_lpszTitle[11]='\0';
    m_gridMem.m_lpszTitle[12]='6';
    m_gridMem.m_lpszTitle[13]='\0';
    m_gridMem.m_lpszTitle[14]='7';
    m_gridMem.m_lpszTitle[15]='\0';
    m_gridMem.m_lpszTitle[16]='8';
    m_gridMem.m_lpszTitle[17]='\0';
    m_gridMem.m_lpszTitle[18]='9';
    m_gridMem.m_lpszTitle[19]='\0';
    m_gridMem.m_lpszTitle[20]='A';
    m_gridMem.m_lpszTitle[21]='\0';
    m_gridMem.m_lpszTitle[22]='B';
    m_gridMem.m_lpszTitle[23]='\0';
    m_gridMem.m_lpszTitle[24]='C';
    m_gridMem.m_lpszTitle[25]='\0';
    m_gridMem.m_lpszTitle[26]='D';
    m_gridMem.m_lpszTitle[27]='\0';
    m_gridMem.m_lpszTitle[28]='E';
    m_gridMem.m_lpszTitle[29]='\0';
    m_gridMem.m_lpszTitle[30]='F';
    m_gridMem.m_lpszTitle[31]='\0';
    m_gridMem.DoRect();
}

void CNewMemory::SetWordUnsignedDecimal()
{
    m_gridAddr.DoRect();
    m_gridMem.SetPos(m_gridAddr.m_rectPos.right,0);
    m_gridMem.SetLines(m_nLines);
    m_gridMem.SetRows(8);
    m_gridMem.SetGridWidth(WordUnsignedDecimalWidth);
    m_gridMem.m_lpszTitle[0]='0';
    m_gridMem.m_lpszTitle[1]='\0';
    m_gridMem.m_lpszTitle[2]='2';
    m_gridMem.m_lpszTitle[3]='\0';
    m_gridMem.m_lpszTitle[4]='4';
    m_gridMem.m_lpszTitle[5]='\0';
    m_gridMem.m_lpszTitle[6]='6';
    m_gridMem.m_lpszTitle[7]='\0';
    m_gridMem.m_lpszTitle[8]='8';
    m_gridMem.m_lpszTitle[9]='\0';
    m_gridMem.m_lpszTitle[10]='A';
    m_gridMem.m_lpszTitle[11]='\0';
    m_gridMem.m_lpszTitle[12]='C';
    m_gridMem.m_lpszTitle[13]='\0';
    m_gridMem.m_lpszTitle[14]='E';
    m_gridMem.m_lpszTitle[15]='\0';
    m_gridMem.DoRect();
}

void CNewMemory::SetLongUnsignedDecimal()
{
    m_gridAddr.DoRect();
    m_gridMem.SetPos(m_gridAddr.m_rectPos.right,0);
    m_gridMem.SetLines(m_nLines);
    m_gridMem.SetRows(4);
    m_gridMem.SetGridWidth(LongUnsignedDecimalWidth);
    m_gridMem.m_lpszTitle[0]='0';
    m_gridMem.m_lpszTitle[1]='\0';
    m_gridMem.m_lpszTitle[2]='4';
    m_gridMem.m_lpszTitle[3]='\0';
    m_gridMem.m_lpszTitle[4]='8';
    m_gridMem.m_lpszTitle[5]='\0';
    m_gridMem.m_lpszTitle[6]='C';
    m_gridMem.m_lpszTitle[7]='\0';
    m_gridMem.DoRect();
}

void CNewMemory::SetByteHexadecimal()
{
    m_gridAddr.DoRect();
    m_gridMem.SetPos(m_gridAddr.m_rectPos.right,0);
    m_gridMem.SetLines(m_nLines);
    m_gridMem.SetRows(16);
    m_gridMem.SetGridWidth(ByteHexadecimalWidth);
    m_gridMem.m_lpszTitle[0]='0';
    m_gridMem.m_lpszTitle[1]='\0';
    m_gridMem.m_lpszTitle[2]='1';
    m_gridMem.m_lpszTitle[3]='\0';
    m_gridMem.m_lpszTitle[4]='2';
    m_gridMem.m_lpszTitle[5]='\0';
    m_gridMem.m_lpszTitle[6]='3';
    m_gridMem.m_lpszTitle[7]='\0';
    m_gridMem.m_lpszTitle[8]='4';
    m_gridMem.m_lpszTitle[9]='\0';
    m_gridMem.m_lpszTitle[10]='5';
    m_gridMem.m_lpszTitle[11]='\0';
    m_gridMem.m_lpszTitle[12]='6';
    m_gridMem.m_lpszTitle[13]='\0';
    m_gridMem.m_lpszTitle[14]='7';
    m_gridMem.m_lpszTitle[15]='\0';
    m_gridMem.m_lpszTitle[16]='8';
    m_gridMem.m_lpszTitle[17]='\0';
    m_gridMem.m_lpszTitle[18]='9';
    m_gridMem.m_lpszTitle[19]='\0';
    m_gridMem.m_lpszTitle[20]='A';
    m_gridMem.m_lpszTitle[21]='\0';
    m_gridMem.m_lpszTitle[22]='B';
    m_gridMem.m_lpszTitle[23]='\0';
    m_gridMem.m_lpszTitle[24]='C';
    m_gridMem.m_lpszTitle[25]='\0';
    m_gridMem.m_lpszTitle[26]='D';
    m_gridMem.m_lpszTitle[27]='\0';
    m_gridMem.m_lpszTitle[28]='E';
    m_gridMem.m_lpszTitle[29]='\0';
    m_gridMem.m_lpszTitle[30]='F';
    m_gridMem.m_lpszTitle[31]='\0';
    m_gridMem.DoRect();
}

void CNewMemory::SetWordHexadecimal()
{
    m_gridAddr.DoRect();
    m_gridMem.SetPos(m_gridAddr.m_rectPos.right,0);
    m_gridMem.SetLines(m_nLines);
    m_gridMem.SetRows(8);
    m_gridMem.SetGridWidth(WordHexadecimalWidth);
    m_gridMem.m_lpszTitle[0]='0';
    m_gridMem.m_lpszTitle[1]='\0';
    m_gridMem.m_lpszTitle[2]='2';
    m_gridMem.m_lpszTitle[3]='\0';
    m_gridMem.m_lpszTitle[4]='4';
    m_gridMem.m_lpszTitle[5]='\0';
    m_gridMem.m_lpszTitle[6]='6';
    m_gridMem.m_lpszTitle[7]='\0';
    m_gridMem.m_lpszTitle[8]='8';
    m_gridMem.m_lpszTitle[9]='\0';
    m_gridMem.m_lpszTitle[10]='A';
    m_gridMem.m_lpszTitle[11]='\0';
    m_gridMem.m_lpszTitle[12]='C';
    m_gridMem.m_lpszTitle[13]='\0';
    m_gridMem.m_lpszTitle[14]='E';
    m_gridMem.m_lpszTitle[15]='\0';
    m_gridMem.DoRect();
}

void CNewMemory::SetLongHexadecimal()
{
    m_gridAddr.DoRect();
    m_gridMem.SetPos(m_gridAddr.m_rectPos.right,0);
    m_gridMem.SetLines(m_nLines);
    m_gridMem.SetRows(4);
    m_gridMem.SetGridWidth(LongHexadecimalWidth);
    m_gridMem.m_lpszTitle[0]='0';
    m_gridMem.m_lpszTitle[1]='\0';
    m_gridMem.m_lpszTitle[2]='4';
    m_gridMem.m_lpszTitle[3]='\0';
    m_gridMem.m_lpszTitle[4]='8';
    m_gridMem.m_lpszTitle[5]='\0';
    m_gridMem.m_lpszTitle[6]='C';
    m_gridMem.m_lpszTitle[7]='\0';
    m_gridMem.DoRect();
}

void CNewMemory::SetDisassemble()
{
    m_gridAddr.DoRect();
    m_gridMem.SetPos(m_gridAddr.m_rectPos.right,0);
    m_gridMem.SetLines(m_nLines);
    m_gridMem.SetRows(1);
    m_gridMem.SetGridWidth(DisassembleWidth);
    m_gridMem.m_lpszTitle[0]='O';
    m_gridMem.m_lpszTitle[1]='P';
    m_gridMem.m_lpszTitle[2]=' ';
    m_gridMem.m_lpszTitle[3]='c';
    m_gridMem.m_lpszTitle[4]='o';
    m_gridMem.m_lpszTitle[5]='d';
    m_gridMem.m_lpszTitle[6]='e';
    m_gridMem.m_lpszTitle[7]='\0';
    m_gridMem.DoRect();
}

void CNewMemory::SetMemoryWindow()
{
    SetAddress();

    switch (m_nViewMode2) {
        case 4:
            SetDisassemble();
            break;
        case 3:
            switch (m_nViewMode1) {
                case 1:
                    SetByteHexadecimal();
                    break;
                case 2:
                    SetWordHexadecimal();
                    break;
                case 3:
                    SetLongHexadecimal();
                    break;
                default:
                    break;
            }
            break;
        case 2:
            switch (m_nViewMode1) {
                case 1:
                    SetByteUnsignedDecimal();
                    break;
                case 2:
                    SetWordUnsignedDecimal();
                    break;
                case 3:
                    SetLongUnsignedDecimal();
                    break;
                default:
                    break;
            }
            break;
        case 1:
            switch (m_nViewMode1) {
                case 1:
                    SetByteSignedDecimal();
                    break;
                case 2:
                    SetWordSignedDecimal();
                    break;
                case 3:
                    SetLongSignedDecimal();
                    break;
                default:
                    break;
            }
            break;
        default:
            break;
    }

    if (m_nViewMode2!=4) {
        if (m_bShowAscii) SetAscii();
    }
    else
      SetInstruction();
}

void CNewMemory::ShowAddress(CDC *dc)
{
        RECT rect;
        int i;
        char buf[20];
        long addr/*, lEndAddress*/;
        int nScrollFlags;

        if (m_nViewMode2!=4) {
            nScrollFlags = m_nScrollFlags;

            switch (m_nWndNo) {
              case 0:
                   if (Mem1) {
                      m_lStartAddress = LastMem1Address;
                      Mem1 = 0;
                   }
                   break;

              case 1:
                   if (Mem2) {
                      m_lStartAddress = LastMem2Address;
                      Mem2 = 0;
                   }
                   break;

              case 2:
                   if (Mem3) {
                      m_lStartAddress = LastMem3Address;
                      Mem3 = 0;
                   }
                   break;
            }

            m_lStartAddress &= 0xFFF0;
            addr = m_lStartAddress;
            for( i = 1; i < m_nLines; i++ ) {
                if (nScrollFlags!=0) {
                    if (nScrollFlags == 1) {
                        if ( i != 1 ) {
                            addr+=0x10;
                            continue;
                        }
                    }
                    else if (nScrollFlags ==-1) {
                        if (i<(m_nLines-2)) {
                            addr+=0x10;
                            continue;
                        }
                    }
                    else nScrollFlags=0;
                }
                rect = m_gridAddr.GetGridRect(0,i);
                sprintf(buf,"%04X",addr);       // modified by Daniel
                FillText(buf,4,rect,dc);        // modified by Daniel
                addr+=0x10;
            }
        }
        else {
                for(i=1;i<m_nLines;i++) {
                   addr = m_dsm[i-1].address;
                   rect = m_gridAddr.GetGridRect(0,i);
                   sprintf(buf,"%04X",addr);       // modified by Daniel
                   FillText(buf,4,rect,dc);        // modified by Daniel
                }
        }
}

void CNewMemory::ShowAscii(CDC *dc)
{
    RECT rect;
    int i,j,pos;
    BYTE value;
    BYTE *p;
    char buf[20];
    int nScrollFlags;

    nScrollFlags = m_nScrollFlags;
    p = (BYTE *)m_byMem;
    for ( i = 1; i < m_nLines; i++ ) {
        if ( nScrollFlags != 0 ) {
            if ( nScrollFlags == 1 ) {
                if (i!=1) continue;
            }
            else if ( nScrollFlags == -1 ) {
                if (i<(m_nLines-2)) continue;
            }
            else nScrollFlags=0;
        }
        rect = m_gridAscii.GetGridRect(0, i);
        for (j = 0; j < 16; j++ ) {
            pos = (i-1) * 16 + j;
            value = p[pos];
            if ((0x20 < value) && (value <= 0x7e))
               buf[j]=value;
            else
               buf[j]='.';
        }
        FillText(buf,16,rect,dc);
    }
    m_nScrollFlags = 0;
}

void CNewMemory::ShowInstruction(CDC *dc)
{
        RECT rect;
        int i;
        int j;

        for(i=1;i<m_nLines;i++) {
            rect = m_gridInstruction.GetGridRect(0,i);
            j = strlen(m_dsm[i-1].instruction);
            FillText3(m_dsm[i-1].instruction,j,rect,dc);
        }
}

void CNewMemory::ShowByteSignedDecimal(CDC *dc)
{
    RECT rect;
    int i,j,pos;
    BYTE value;
    BYTE *p;
    char buf[20];
    int nScrollFlags;

    nScrollFlags = m_nScrollFlags;
    p = (BYTE *)m_byMem;
    for(i=1;i<m_nLines;i++) {
        if (nScrollFlags!=0) {
            if (nScrollFlags == 1) {
                if (i!=1) continue;
            }
            else if (nScrollFlags ==-1) {
                if (i<(m_nLines-2)) continue;
            }
            else nScrollFlags=0;
        }
        for(j=0;j<16;j++) {
            rect = m_gridMem.GetGridRect(j,i);
            pos = (i-1)*16 + j;
            value = p[pos];
            sprintf(buf,"%+04d",value);
            FillText(buf,4,rect,dc);
        }
    }
    if (!m_bShowAscii) m_nScrollFlags = 0;
}

void CNewMemory::ShowWordSignedDecimal(CDC *dc)
{
   RECT rect;
   int i,j,pos;
   WORD value;
   WORD *p;
   char buf[20];
   int nScrollFlags;

    nScrollFlags = m_nScrollFlags;
    p = (WORD *)m_byMem;
    for(i=1;i<m_nLines;i++)
    {
        if (nScrollFlags!=0)
        {
            if (nScrollFlags == 1)
            {
                if (i!=1) continue;
            }
            else if (nScrollFlags ==-1)
            {
                if (i<(m_nLines-2)) continue;
            }
            else nScrollFlags=0;
        }
        for(j=0;j<8;j++)
        {
            rect = m_gridMem.GetGridRect(j,i);
            pos = (i-1)*8 + j;
            value = p[pos];
            sprintf(buf,"%+06d",value);
            FillText(buf,6,rect,dc);
        }
    }
    if (!m_bShowAscii) m_nScrollFlags = 0;
}

void CNewMemory::ShowLongSignedDecimal(CDC *dc)
{
   RECT rect;
   int i,j,pos;
   long value;
   long *p;
   char buf[20];
   int nScrollFlags;

    nScrollFlags = m_nScrollFlags;
    p = (long *)m_byMem;
    for(i=1;i<m_nLines;i++)
    {
        if (nScrollFlags!=0)
        {
            if (nScrollFlags == 1)
            {
                if (i!=1) continue;
            }
            else if (nScrollFlags ==-1)
            {
                if (i<(m_nLines-2)) continue;
            }
            else nScrollFlags=0;
        }
        for(j=0;j<4;j++)
        {
            rect = m_gridMem.GetGridRect(j,i);
            pos = (i-1)*4 + j;
            value = p[pos];
            sprintf(buf,"%+011ld",value);
            FillText(buf,11,rect,dc);
        }
    }
    if (!m_bShowAscii) m_nScrollFlags = 0;
}

void CNewMemory::ShowByteUnsignedDecimal(CDC *dc)
{
   RECT rect;
   int i,j,pos;
   BYTE value;
   BYTE *p;
   char buf[20];
   int nScrollFlags;

    nScrollFlags = m_nScrollFlags;
    p = (BYTE *)m_byMem;
    for(i=1;i<m_nLines;i++)
    {
        if (nScrollFlags!=0)
        {
            if (nScrollFlags == 1)
            {
                if (i!=1) continue;
            }
            else if (nScrollFlags ==-1)
            {
                if (i<(m_nLines-2)) continue;
            }
            else nScrollFlags=0;
        }
        for(j=0;j<16;j++)
        {
            rect = m_gridMem.GetGridRect(j,i);
            pos = (i-1)*16 + j;
            value = p[pos];
            sprintf(buf,"%03u",value);
            FillText(buf,3,rect,dc);
        }
    }
    if (!m_bShowAscii) m_nScrollFlags = 0;
}

void CNewMemory::ShowWordUnsignedDecimal(CDC *dc)
{
   RECT rect;
   int i,j,pos;
   WORD value;
   WORD *p;
   char buf[20];
   int nScrollFlags;

    nScrollFlags = m_nScrollFlags;
    p = (WORD *)m_byMem;
    for(i=1;i<m_nLines;i++)
    {
        if (nScrollFlags!=0)
        {
            if (nScrollFlags == 1)
            {
                if (i!=1) continue;
            }
            else if (nScrollFlags ==-1)
            {
                if (i<(m_nLines-2)) continue;
            }
            else nScrollFlags=0;
        }
        for(j=0;j<8;j++)
        {
            rect = m_gridMem.GetGridRect(j,i);
            pos = (i-1)*8 + j;
            value = p[pos];
            sprintf(buf,"%05u",value);
            FillText(buf,5,rect,dc);
        }
    }
    if (!m_bShowAscii) m_nScrollFlags = 0;
}

void CNewMemory::ShowLongUnsignedDecimal(CDC *dc)
{
   RECT rect;
   int i,j,pos;
   long value;
   long *p;
   char buf[20];
   int nScrollFlags;

    nScrollFlags = m_nScrollFlags;
    p = (long *)m_byMem;
    for(i=1;i<m_nLines;i++)
    {
        if (nScrollFlags!=0)
        {
            if (nScrollFlags == 1)
            {
                if (i!=1) continue;
            }
            else if (nScrollFlags ==-1)
            {
                if (i<(m_nLines-2)) continue;
            }
            else nScrollFlags=0;
        }
        for(j=0;j<4;j++)
        {
            rect = m_gridMem.GetGridRect(j,i);
            pos = (i-1)*4 + j;
            value = p[pos];
            sprintf(buf,"%010lu",value);
            FillText(buf,10,rect,dc);
        }
    }
    if (!m_bShowAscii) m_nScrollFlags = 0;
}

void CNewMemory::ShowByteHexadecimal(CDC *dc)
{
   RECT rect;
   int i,j;
   BYTE value;
   int pos;
   char buf[20];
   int nScrollFlags;

    nScrollFlags = m_nScrollFlags;
    for(i=1;i<m_nLines;i++)
    {
        if (nScrollFlags!=0)
        {
            if (nScrollFlags == 1)
            {
                if (i!=1) continue;
            }
            else if (nScrollFlags ==-1)
            {
                if (i<(m_nLines-2)) continue;
            }
            else nScrollFlags=0;
        }
        for(j=0;j<16;j++)
        {
            rect = m_gridMem.GetGridRect(j,i);
            pos = (i-1)*16 + j;
            value = m_byMem[pos];
            sprintf(buf,"%02X",value);
            FillText(buf,2,rect,dc);
        }
    }
    if (!m_bShowAscii) m_nScrollFlags = 0;
}

void CNewMemory::ShowWordHexadecimal(CDC *dc)
{
   RECT rect;
   int i,j,pos;
   WORD value;
   WORD *p;
   char buf[20];
   int nScrollFlags;

    nScrollFlags = m_nScrollFlags;
    p = (WORD *)m_byMem;
    for(i=1;i<m_nLines;i++)
    {
        if (nScrollFlags!=0)
        {
            if (nScrollFlags == 1)
            {
                if (i!=1) continue;
            }
            else if (nScrollFlags ==-1)
            {
                if (i<(m_nLines-2)) continue;
            }
            else nScrollFlags=0;
        }
        for(j=0;j<8;j++)
        {
            rect = m_gridMem.GetGridRect(j,i);
            pos = (i-1)*8 + j;
            value = p[pos];
            sprintf(buf,"%04X",value);
            FillText(buf,4,rect,dc);
        }
    }
    if (!m_bShowAscii) m_nScrollFlags = 0;
}

void CNewMemory::ShowLongHexadecimal(CDC *dc)
{
   RECT rect;
   int i,j,pos;
   long value;
   long *p;
   char buf[20];
   int nScrollFlags;

    nScrollFlags = m_nScrollFlags;
    p = (long *)m_byMem;
    for(i=1;i<m_nLines;i++)
    {
        if (nScrollFlags!=0)
        {
            if (nScrollFlags == 1)
            {
                if (i!=1) continue;
            }
            else if (nScrollFlags ==-1)
            {
                if (i<(m_nLines-2)) continue;
            }
            else nScrollFlags=0;
        }
        for(j=0;j<4;j++)
        {
            rect = m_gridMem.GetGridRect(j,i);
            pos = (i-1)*4 + j;
            value = p[pos];
            sprintf(buf,"%08lX",value);
            FillText(buf,8,rect,dc);
        }
    }
    if (!m_bShowAscii) m_nScrollFlags = 0;
}

void CNewMemory::ShowDisassemble(CDC *dc)
{
        RECT rect;
        int i;
        int j;
        int nScrollFlags;       // Added by Daniel Lin

        nScrollFlags = m_nScrollFlags;

        //
        for(i=1;i<m_nLines;i++) {
        // Modified by Daniel Lin
          if (nScrollFlags!=0) {
            if (nScrollFlags == 1) {
              if (i!=1)
                continue;
            }
            else
            if (nScrollFlags ==-1) {
              if (i<(m_nLines-2))
                continue;
            }
            else
              nScrollFlags=0;
          }
          rect = m_gridMem.GetGridRect(0,i);
          j = strlen(m_dsm[i-1].code);
          FillText2(m_dsm[i-1].code,j,rect,dc);
       }
}

void CNewMemory::ShowMemoryWindow(CDC *dc)
{
    ShowAddress(dc);

    switch (m_nViewMode2)
    {
        case 4:
            ShowDisassemble(dc);
            break;
        case 3:
            switch (m_nViewMode1)
            {
                case 1:
                    ShowByteHexadecimal(dc);
                    break;
                case 2:
                    ShowWordHexadecimal(dc);
                    break;
                case 3:
                    ShowLongHexadecimal(dc);
                    break;
                default:
                    break;
            }
            break;
        case 2:
            switch (m_nViewMode1)
            {
                case 1:
                    ShowByteUnsignedDecimal(dc);
                    break;
                case 2:
                    ShowWordUnsignedDecimal(dc);
                    break;
                case 3:
                    ShowLongUnsignedDecimal(dc);
                    break;
                default:
                    break;
            }
            break;
        case 1:
            switch (m_nViewMode1)
            {
                case 1:
                    ShowByteSignedDecimal(dc);
                    break;
                case 2:
                    ShowWordSignedDecimal(dc);
                    break;
                case 3:
                    ShowLongSignedDecimal(dc);
                    break;
                default:
                    break;
            }
            break;
        default:
            break;
    }

    if (m_nViewMode2!=4)
    {
        if (m_bShowAscii) ShowAscii(dc);
    }
    else ShowInstruction(dc);
}

void CNewMemory::GetMemory()
{
  UINT i = 0;                   // Add by Daniel
  int nByte = 256;

  switch (m_nWndNo) {
    case 0:
         if (Cur1) {
           m_lStartAddress = LastMem1Address;
           Cur1 = 0;
         }
         break;
    case 1:
         if (Cur2) {
           m_lStartAddress = LastMem2Address;
           Cur2 = 0;
         }
         break;
    case 2:
         if (Cur3) {
           m_lStartAddress = LastMem3Address;
           Cur3 = 0;
         }
         break;
  }

#ifdef _LANE
        if  (m_nViewMode2!=4) {        // Not assembly
            if (!m_bGetMemory) {
                m_bGetMemory=TRUE;
                return;
            }
            long  dwTempAddress = 0;

            // ??????????????????????
            //            
            dwTempAddress = (m_lStartAddress+(m_nLines-3)*16);
            int nLines = 0;
                        
            switch( m_nSpaceType ) {
              case      1:
                    // Add by Daniel Lin 
                    if (dwTempAddress > ((long)pMax&0xFFF0)) {
                       m_lStartAddress = (long)pMax-(m_nLines-3)*16;
                       m_lStartAddress &= 0xFFF0;
                    }                       
                    nLines = int((pMax - pMin) >> 4);
                    if ( nLines < (m_nLines-2)) {
                       m_lStartAddress = (long)pMin & 0xFFF0;
                       m_nLines = nLines + 2;
                    }   
                    break;
                    
              case      2:
                    if (dwTempAddress > ((long)xMax&0xFFF0)) {
                       m_lStartAddress = (long)xMax-(m_nLines-3)*16;
                       m_lStartAddress &= 0xFFF0;
                    }                       
                    nLines = int((xMax - xMin) >> 4);
                    if ( nLines < (m_nLines-2)) {
                       m_lStartAddress = (long)xMin & 0xFFF0;
                       m_nLines = nLines + 2;                    
                    }   
                    break;                                    
                    
              case      3:
                    if (dwTempAddress > ((long)iMax&0xFFF0)) {
                       m_lStartAddress = (long)iMax-(m_nLines-3)*16;
                       m_lStartAddress &= 0xFFF0;
                    }                       
                    nLines = int((iMax - iMin) >> 4);
                    if ( nLines < (m_nLines-2)) {
                       m_lStartAddress = (long)iMin & 0xFFF0;
                       m_nLines = nLines + 2;
                    }                                                
                    break;
                    
               default:
                    break;
            }

            //            
            // Memory dump 1024 byte
            //
            MemServerDump(m_byMem, m_lStartAddress, 256, m_nSpaceType);
            MemServerDump(m_byMem+256, m_lStartAddress+256, 256, m_nSpaceType);
            MemServerDump(m_byMem+512, m_lStartAddress+512, 256, m_nSpaceType);
            MemServerDump(m_byMem+768, m_lStartAddress+768, 256, m_nSpaceType);
            
            /*
            if (m_nLines>17)
                MemServerDump(m_byMem+256, m_lStartAddress+256,
                              256, m_nSpaceType);
            if (m_nLines>33)
               MemServerDump(m_byMem+nByte+nByte,
                             m_lStartAddress+nByte+nByte,
                             nByte,m_nSpaceType);
            if (m_nLines>49)
               MemServerDump(m_byMem+nByte+nByte+nByte,
                             m_lStartAddress+nByte+nByte+nByte,
                             nByte,m_nSpaceType);
            */
                                         
        }
        else {
          long address;
          int line;

          address = m_lStartAddress & (long)0x0000FFFF;
          if (m_nLines <= 25) line = 25;
          else line =50;
          GetDsm(address, line, (DADMEMSTRU*)m_dsm, m_nSpaceType);
        }

#else       // No ABI server
    int i;
    BYTE addr;
    if (!m_bGetMemory) {
        m_bGetMemory=TRUE;
        return;
    }
    addr = (BYTE)m_lStartAddress;
    for(i=0;i<1024;i++) {
        m_byMem[i]=(BYTE)(addr+i%16);
        if ((i%16)==15) addr += 0x10;
    }
#endif

}

void CNewMemory::SetMyCaretPos()
{
    long lValue;
    UINT nValue;
    int i;
    RECT rect;
    POINT pos;

    if (!m_bFocus) return;
    
    if (m_nViewMode2==4) {
       pos.x = -30;
       pos.y = -30;
       SetCaretPos(pos);
    }
    else {
      switch (m_nCaretArea) {
        case 2:
            lValue = m_lStartAddress;
            lValue>>=4;
            nValue = (UINT)lValue;
            if ((m_nCaretPosY>=nValue)&&(m_nCaretPosY<=(nValue+m_nLines))) {
                i = m_nCaretPosY - nValue;
                rect = m_gridAscii.GetGridRect(0,i+1);
                pos.x = rect.left+m_nCaretPosX2*m_nCharWidth+1;
                pos.y = rect.top + 3;
                SetCaretPos(pos);
                ShowCaret();
            }
            else {
                pos.x = -30;
                pos.y = -30;
                SetCaretPos(pos);
            }
            break;
            
        default:
            lValue = m_lStartAddress;
            lValue>>=4;
            nValue = (UINT)lValue;
            if ((m_nCaretPosY>=nValue)&&(m_nCaretPosY<=(nValue+m_nLines))) {
                i = m_nCaretPosY - nValue;
                rect = m_gridMem.GetGridRect(m_nCaretPosX1,i+1);
                pos.x = rect.left+m_nCaretPosX2*m_nCharWidth+1;
                pos.y = rect.top + 3;
                SetCaretPos(pos);
                ShowCaret();
            }
            else {
                pos.x = -30;
                pos.y = -30;
                SetCaretPos(pos);
            }
            break;
      }
    }  
}

void CNewMemory::GotoCursor()
{
    m_lStartAddress = (unsigned short)(m_nCaretPosY*0x10);
    InvalidateRect(NULL,FALSE);
}

BOOL CNewMemory::InWnd()
{
    UINT i;
    
    i = (UINT)(m_lStartAddress>>4);
    if ((m_nCaretPosY>=i)&&(m_nCaretPosY<(i+m_nLines-2))) 
      return TRUE;
    else
      return FALSE;
}

void CNewMemory::Right()
{
    if (m_nCaretArea == 2) {
        if (m_nCaretPosX2==15) {
            m_nCaretPosX2=0;
            Down();
        }
        else
            m_nCaretPosX2++;
    }
    else
      switch(m_nViewMode2) {
        case 4:            // Disassembly
            break;
            
        case 3:            // Hexdecimal
            switch(m_nViewMode1) {
                case 1:             // Byte
                    if ((m_nCaretPosX1==15)&&(m_nCaretPosX2==1)) {
                        m_nCaretPosX1 = 0;
                        m_nCaretPosX2 = 0;
                        Down();
                        break;
                    }
                    if (m_nCaretPosX2==1) {
                        m_nCaretPosX1++;
                        m_nCaretPosX2=0;
                    }
                    else m_nCaretPosX2++;
                    break;
                    
                case 2:             // Word
                    if ((m_nCaretPosX1==7)&&(m_nCaretPosX2==3)) {
                        m_nCaretPosX1 = 0;
                        m_nCaretPosX2 = 0;
                        Down();
                        break;
                    }
                    if (m_nCaretPosX2==3) {
                        m_nCaretPosX1++;
                        m_nCaretPosX2=0;
                    }
                    else m_nCaretPosX2++;
                    break;
                    
                case 3:             // Long
                    if ((m_nCaretPosX1==3)&&(m_nCaretPosX2==7)) {
                        m_nCaretPosX1 = 0;
                        m_nCaretPosX2 = 0;
                        Down();
                        break;
                    }
                    if (m_nCaretPosX2==7) {
                        m_nCaretPosX1++;
                        m_nCaretPosX2=0;
                    }
                    else m_nCaretPosX2++;
                    break;
                    
                default:
                    break;
            }
            break;
            
        case 2:            // Unsigned Decimal
            switch(m_nViewMode1)
            {
                case 1:          // Byte
                    if ((m_nCaretPosX1==15)&&(m_nCaretPosX2==2))
                    {
                        Down();
                        //if (FALSE == m_bEndOfMem) {
                           m_nCaretPosX1 = 0;
                           m_nCaretPosX2 = 0;
                        //}   
                        break;
                    }
                    if (m_nCaretPosX2==2)
                    {
                        m_nCaretPosX1++;
                        m_nCaretPosX2=0;
                    }
                    else m_nCaretPosX2++;
                    break;        
                    
                case 2:           // Word
                    if ((m_nCaretPosX1==7)&&(m_nCaretPosX2==4))
                    {
                        Down();
                        //if (FALSE == m_bEndOfMem) {
                           m_nCaretPosX1 = 0;
                           m_nCaretPosX2 = 0;
                        //}   
                        break;
                    }
                    if (m_nCaretPosX2==4)
                    {
                        m_nCaretPosX1++;
                        m_nCaretPosX2=0;
                    }
                    else m_nCaretPosX2++;
                    break;
                    
                case 3:          // Long
                    if ((m_nCaretPosX1==3)&&(m_nCaretPosX2==9)) {
                        Down();
                        //if (FALSE == m_bEndOfMem) {
                           m_nCaretPosX1 = 0;
                           m_nCaretPosX2 = 0;
                        //}   
                        break;
                    }
                    if (m_nCaretPosX2==9) {
                        m_nCaretPosX1++;
                        m_nCaretPosX2=0;
                    }
                    else m_nCaretPosX2++;
                    break;
                    
                default:
                    break;
            }
            break;
            
        case 1:         // Signed Decimal
            switch(m_nViewMode1) {
                case 1:          // Byte
                    if ((m_nCaretPosX1==15)&&(m_nCaretPosX2==3)) {
                        Down();
                        //if (FALSE == m_bEndOfMem) {
                           m_nCaretPosX1 = 0;
                           m_nCaretPosX2 = 0;
                        //}   
                        break;
                    }
                    if (m_nCaretPosX2==3) {
                        m_nCaretPosX1++;
                        m_nCaretPosX2=0;
                    }
                    else m_nCaretPosX2++;
                    break;
                    
                case 2:       // Word
                    if ((m_nCaretPosX1==7)&&(m_nCaretPosX2==5)) {
                        Down();
                        //if (FALSE == m_bEndOfMem) {
                           m_nCaretPosX1 = 0;
                           m_nCaretPosX2 = 0;
                        //}   
                        break;
                    }
                    
                    if (m_nCaretPosX2==5) {
                        m_nCaretPosX1++;
                        m_nCaretPosX2=0;
                    }
                    else m_nCaretPosX2++;
                    break;
                    
                case 3:       // Long
                    if ((m_nCaretPosX1==3)&&(m_nCaretPosX2==10)) {
                        Down();
                        //if (FALSE == m_bEndOfMem) {
                           m_nCaretPosX1 = 0;
                           m_nCaretPosX2 = 0;
                        //}   
                        break;
                    }
                    if (m_nCaretPosX2==10) {
                        m_nCaretPosX1++;
                        m_nCaretPosX2=0;
                    }
                    else m_nCaretPosX2++;
                    break;
                    
                default:
                    break;
            }
            break;  
            
        default:
            break;
    }            

    if (m_nCaretArea != 2) {        // Not in Ascii area    
       //          
       // Add by Daniel Lin      03/14/1996
       //
       // Process the following status:
       //  Press Right key, the caret is out of window, the window must scroll
       //  If caret at the end of the line, press the key again, scroll to begin
       //  and memory scroll up one line(the client scroll down one line)
       //
       //             
       RECT clientRect;
       GetClientRect(&clientRect);
       int xWidth = 0;
       if (0 != m_nCaretPosX1) {
         xWidth = m_nCaretPosX1*m_gridMem.m_nGridWidth+m_gridAddr.m_nGridWidth; 
         if (xWidth > clientRect.right)
             SendMessage(WM_HSCROLL, SB_LINEDOWN, 0L);
       }      
       else {
         if (0 == m_nCaretPosX2) {
           
           /*ScrollWindow(-m_nPosX, 0, NULL, NULL);
           m_nPosX = 0;                        
           SetScrollPos(SB_HORZ, 0, TRUE);      
           */
           m_nPosX = 0;
           InvalidateRect(NULL, TRUE);
         }      
       }  
    }   
    
    SetMyCaretPos();
}

void CNewMemory::Left()
{
    BOOL bEnd = FALSE;
    
    if (m_nCaretArea == 2) {
        if (m_nCaretPosX2==0) {
            if (m_nCaretPosY != 0) {
                m_nCaretPosX2=15;
                Up();
            }
        }
        else
            m_nCaretPosX2--;
    }
    else
      switch(m_nViewMode2) {
        case 4:            // Disassembly
            break;                       
            
        case 3:            // Hexdecimal
            switch(m_nViewMode1) {
                case 1:             // Byte
                    if ((m_nCaretPosX1==0)&&(m_nCaretPosX2==0)) {
                        if (m_nCaretPosY == 0) break;
                        m_nCaretPosX1 = 15;
                        m_nCaretPosX2 = 1;
                        bEnd = TRUE;
                        Up();
                        break;
                    }
                    if (m_nCaretPosX2==0) {
                        m_nCaretPosX1--;
                        m_nCaretPosX2=1;
                    }
                    else
                        m_nCaretPosX2--;
                    break;
                    
                case 2:             // Word
                    if ((m_nCaretPosX1==0)&&(m_nCaretPosX2==0)) {
                        if (m_nCaretPosY == 0) break;
                        m_nCaretPosX1 = 7;
                        m_nCaretPosX2 = 3;
                        bEnd = TRUE;
                        Up();
                        break;
                    }
                    if (m_nCaretPosX2==0) {
                        m_nCaretPosX1--;
                        m_nCaretPosX2=3;
                    }
                    else
                        m_nCaretPosX2--;
                    break;
                    
                case 3:             // Long   
                    if ((m_nCaretPosX1==0)&&(m_nCaretPosX2==0)) {
                        if (m_nCaretPosY == 0) break;
                        m_nCaretPosX1 = 3;
                        m_nCaretPosX2 = 7;
                        bEnd = TRUE;
                        Up();
                        break;
                    }
                    if (m_nCaretPosX2==0) {
                        m_nCaretPosX1--;
                        m_nCaretPosX2=7;
                    }
                    else
                        m_nCaretPosX2--;
                    break;
                default:
                    break;
            }
            break;
            
        case 2:         // Unsigned decimal
            switch(m_nViewMode1) {
                case 1:       // Byte
                    if ((m_nCaretPosX1==0)&&(m_nCaretPosX2==0)) {
                        if (m_nCaretPosY == 0) break;
                        m_nCaretPosX1 = 15;
                        m_nCaretPosX2 = 2;
                        bEnd = TRUE;
                        Up();
                        break;
                    }
                    if (m_nCaretPosX2==0) {
                        m_nCaretPosX1--;
                        m_nCaretPosX2=2;
                    }
                    else
                        m_nCaretPosX2--;
                    break;
                    
                case 2:       // Word
                    if ((m_nCaretPosX1==0)&&(m_nCaretPosX2==0)) {
                        if (m_nCaretPosY == 0) break;
                        m_nCaretPosX1 = 7;
                        m_nCaretPosX2 = 4;
                        bEnd = TRUE;
                        Up();
                        break;
                    }
                    if (m_nCaretPosX2==0) {
                        m_nCaretPosX1--;
                        m_nCaretPosX2=4;
                    }
                    else
                        m_nCaretPosX2--;
                    break;
                    
                case 3:       // Long
                    if ((m_nCaretPosX1==0)&&(m_nCaretPosX2==0)) {
                        if (m_nCaretPosY == 0) break;
                        m_nCaretPosX1 = 3;
                        m_nCaretPosX2 = 9;
                        bEnd = TRUE;
                        Up();
                        break;
                    }
                    if (m_nCaretPosX2==0) {
                        m_nCaretPosX1--;
                        m_nCaretPosX2=9;
                    }
                    else
                        m_nCaretPosX2--;
                    break;
                default:
                    break;
            }
            break;
            
        case 1:            // Hexdecimal
            switch(m_nViewMode1) {
                case 1:       // Byte
                    if ((m_nCaretPosX1==0)&&(m_nCaretPosX2==0)) {
                        if (m_nCaretPosY == 0) break;
                        m_nCaretPosX1 = 15;
                        m_nCaretPosX2 = 3;
                        bEnd = TRUE;
                        Up();
                        break;
                    }
                    if (m_nCaretPosX2==0) {
                        m_nCaretPosX1--;
                        m_nCaretPosX2=3;
                    }
                    else
                        m_nCaretPosX2--;
                    break;
                    
                case 2:       // Word
                    if ((m_nCaretPosX1==0)&&(m_nCaretPosX2==0)) {
                        if (m_nCaretPosY == 0) break;
                        m_nCaretPosX1 = 7;
                        m_nCaretPosX2 = 5;
                        bEnd = TRUE;
                        Up();
                        break;
                    }
                    if (m_nCaretPosX2==0) {
                        m_nCaretPosX1--;
                        m_nCaretPosX2=5;
                    }
                    else
                        m_nCaretPosX2--;
                    break;
                    
                case 3:       // Long
                    if ((m_nCaretPosX1==0)&&(m_nCaretPosX2==0)) {
                        if (m_nCaretPosY == 0) break;
                        m_nCaretPosX1 = 3;
                        m_nCaretPosX2 = 10;
                        bEnd = TRUE;
                        Up();
                        break;
                    }
                    if (m_nCaretPosX2==0) {
                        m_nCaretPosX1--;
                        m_nCaretPosX2=10;
                    }
                    else
                        m_nCaretPosX2--;
                    break;
                default:
                    break;
            }
            break;
            
        default:
            break;
    }
    
    if (m_nCaretArea != 2) {        // Not in Ascii area
       // Add by Daniel Lin      03/15/1996
       //
       // Process the following status:
       //  Press Left key, the caret is out of window, the window must scroll
       //  If caret at the begin of the line, press the key again, scroll to 
       //  end and the memory scroll down one line(the client scroll up one line)
       //             
       RECT clientRect;
       GetClientRect(&clientRect);
       int xWidth = 0;
       int memWidth  = 0;
       if (!bEnd) {      
         memWidth = 16*m_gridMem.m_nGridWidth+m_gridAddr.m_nGridWidth*4; 
         xWidth = m_nCaretPosX1*m_gridMem.m_nGridWidth+m_gridAddr.m_nGridWidth; 
         if (xWidth < (memWidth-clientRect.right))
             SendMessage(WM_HSCROLL, SB_LINEUP, 0L);
       }      
       else {
         if (0 != m_nCaretPosX2) {
           int nMin = 0, nMax = 0;
           
           GetScrollRange(SB_HORZ, &nMin, &nMax);
           m_nPosX = -nMax;                        
           InvalidateRect(NULL, TRUE);
           bEnd = FALSE;    
         }      
       }  
    }
       
    SetMyCaretPos();
}

void CNewMemory::Up()
{
    if (0 == m_nCaretPosY) {
      MessageBeep(-1);
      return;
    }
    m_nCaretPosY--;
    if (!InWnd()) {
        if (m_lStartAddress <= 0) 
            return;;
        m_lStartAddress -= 0x10;

        ScrollMemWnd(1);
    }
    
    SetMyCaretPos();
}

void CNewMemory::Down()
{
    long dwTempAddress2 = 0;
    UINT oldCaretY = 0;
    
    oldCaretY = m_nCaretPosY;
    m_nCaretPosY++;
    if (!InWnd()) {
        m_lStartAddress+=0x10;
        dwTempAddress2 = m_lStartAddress+(m_nLines-3)*16;
        switch( m_nSpaceType ) {
           case 1:
              // Add by Daniel Lin 
              if (dwTempAddress2 > ((long)pMax&0xFFF0)) {               
                  MessageBeep(-1);
                  m_lStartAddress = (long)pMax-(m_nLines-3)*16;
                  m_lStartAddress &= 0xFFF0;
                  m_nCaretPosY = oldCaretY;
                  goto out;
              }    
              break;    
                       
           case 2:
              // Add by Daniel Lin 
              if (dwTempAddress2 > ((long)xMax&0xFFF0)) {
                 MessageBeep(-1); 
                 m_lStartAddress = (long)xMax-(m_nLines-3)*16;
                 m_lStartAddress &= 0xFFF0;
                 m_nCaretPosY = oldCaretY;
                 goto out;
              }   
              break;   
                       
           case 3:
              // Add by Daniel Lin 
              if (dwTempAddress2 > ((long)iMax&0xFFF0)) {
                 MessageBeep(-1); 
                 m_lStartAddress = (long)iMax-(m_nLines-3)*16;
                 m_lStartAddress &= 0xFFF0;
                 m_nCaretPosY = oldCaretY;
                 goto out;
              }   
              break;   
        }                          
        
        ScrollMemWnd(-1);
    }
    
    out:
    SetMyCaretPos();
}

void CNewMemory::Home()
{   
    if (m_nCaretArea != 2) {        // Not in Ascii area
      m_nPosX = 0;
      InvalidateRect(NULL, TRUE);
    }  
    m_nCaretPosX1=0;
    m_nCaretPosX2=0;
    SetMyCaretPos();
}

void CNewMemory::End()
{
    if (m_nCaretArea == 2) {
        m_nCaretPosX2=15;
    }
    else
      switch(m_nViewMode2) {
        case 4:         // Disassembly
            break;
            
        case 3:         // Hexdeciaml
            switch(m_nViewMode1) {
                case 1:          // Byte
                    m_nCaretPosX1=15;
                    m_nCaretPosX2=1;
                    break;
                    
                case 2:          // Word
                    m_nCaretPosX1=7;
                    m_nCaretPosX2=3;
                    break;
                    
                case 3:          // Long
                    m_nCaretPosX1=3;
                    m_nCaretPosX2=7;
                    break;
                    
                default:         
                    break;
            }
            break;
            
        case 2:         // Unsigned decimal
            switch(m_nViewMode1) {
                case 1:          // Byte
                    m_nCaretPosX1=15;
                    m_nCaretPosX2=2;
                    break;
                    
                case 2:          // Word
                    m_nCaretPosX1=7;
                    m_nCaretPosX2=4;
                    break;
                    
                case 3:          // Long
                    m_nCaretPosX1=3;
                    m_nCaretPosX2=9;
                    break;
                    
                default:
                    break;
            }
            break;
            
        case 1:         // Signed decimal   
            switch(m_nViewMode1) {
                case 1:       // Byte
                    m_nCaretPosX1=15;
                    m_nCaretPosX2=3;
                    break;
                    
                case 2:       // Word
                    m_nCaretPosX1=7;
                    m_nCaretPosX2=5;
                    break;
                    
                case 3:       // Long
                    m_nCaretPosX1=3;
                    m_nCaretPosX2=10;
                    break;
                    
                default:
                    break;
            }
            break;
            
        default:
            break;
    }

    if (m_nCaretArea != 2) {        // Not in Ascii area
       int nMin, nMax;
       RECT clientRect;
       
       GetClientRect(&clientRect);
       GetScrollRange(SB_HORZ, &nMin, &nMax);
       m_nPosX = -nMax;                        
       InvalidateRect(NULL, TRUE);
    }
           
    SetMyCaretPos();
}

void CNewMemory::Tab()
{
/*
    if (m_nCaretArea == 2)
        Down();
    else
*/    
    switch(m_nViewMode2) {
        case 4:
            break;
            
        case 3:
            switch(m_nViewMode1) {
                case 1:
//                  if (m_nCaretPosX1==15) break;
                    if (m_nCaretPosX1==15) {
                        m_nCaretPosX1=0;
                        Down();
                        break;
                    }
                    m_nCaretPosX1++;
                    break;
                    
                case 2:
//                  if (m_nCaretPosX1==7) break;
                    if (m_nCaretPosX1==7) {
                        m_nCaretPosX1=0;
                        Down();
                        break;
                    }
                    m_nCaretPosX1++;
                    break;
                    
                case 3:
//                  if (m_nCaretPosX1==3) break;
                    if (m_nCaretPosX1==3) {
                        m_nCaretPosX1=0;
                        Down();
                        break;
                    }
                    m_nCaretPosX1++;
                    break;
                    
                default:
                    break;
            }
            break;
            
        case 2:
            switch(m_nViewMode1) {
                case 1:
//                  if (m_nCaretPosX1==15) break;
                    if (m_nCaretPosX1==15) {
                        m_nCaretPosX1=0;
                        Down();
                        break;
                    }
                    m_nCaretPosX1++;
                    break;
                    
                case 2:
//                  if (m_nCaretPosX1==7) break;
                    if (m_nCaretPosX1==7) {
                        m_nCaretPosX1=0;
                        Down();
                        break;
                    }
                    m_nCaretPosX1++;
                    break;
                    
                case 3:
//                  if (m_nCaretPosX1==3) break;
                    if (m_nCaretPosX1==3) {
                        m_nCaretPosX1=0;
                        Down();
                        break;
                    }
                    m_nCaretPosX1++;
                    break;
                    
                default:
                    break;
            }
            break;
            
        case 1:
            switch(m_nViewMode1) {
                case 1:
//                  if (m_nCaretPosX1==15) break;
                    if (m_nCaretPosX1==15) {
                        m_nCaretPosX1=0;
                        Down();
                        break;
                    }
                    m_nCaretPosX1++;
                    break;
                    
                case 2:
//                  if (m_nCaretPosX1==7) break;
                    if (m_nCaretPosX1==7) {
                        m_nCaretPosX1=0;
                        Down();
                        break;
                    }
                    m_nCaretPosX1++;
                    break;
                    
                case 3:
//                  if (m_nCaretPosX1==3) break;
                    if (m_nCaretPosX1==3) {
                        m_nCaretPosX1=0;
                        Down();
                        break;
                    }
                    m_nCaretPosX1++;
                    break;
                    
                default:
                    break;
            }
            break;
            
        default:
            break;
    }

    if (m_nCaretArea != 2) {        // Not in Ascii area    
       // Add by Daniel Lin      03/15/1996
       //
       // Process the following status:
       //  Press Tab key, the caret is out of window, the window must scroll
       //  If caret at the end of the line, press the key again, scroll to begin
       //  and memory scroll up one line(the client scroll down one line)
       //
       //             
       RECT clientRect;
       GetClientRect(&clientRect);
       int xWidth = 0;
       if (0 != m_nCaretPosX1) {
         xWidth = m_nCaretPosX1*m_gridMem.m_nGridWidth+m_gridAddr.m_nGridWidth; 
         if (xWidth > clientRect.right)
             SendMessage(WM_HSCROLL, SB_LINEDOWN, 0L);
       }      
       else {
           m_nPosX = 0;                        
           InvalidateRect(NULL, TRUE);
       }  
    }   
    
    SetMyCaretPos();
}

void CNewMemory::Tab2()          // Shift_Tab
{
    BOOL bEnd = FALSE;
/*    
    if (m_nCaretArea == 2) 
      Up();
    else
*/    
      switch(m_nViewMode2) {
        case 4:
            break;
            
        case 3:
            switch(m_nViewMode1) {
                case 1:
//                  if (m_nCaretPosX1==0) break;
                    if (m_nCaretPosX1==0) {
                        if (m_nCaretPosY==0) break;
                        m_nCaretPosX1=15;
                        bEnd = TRUE;
                        Up();
                        break;
                    }
                    m_nCaretPosX1--;
                    break;
                    
                case 2:
//                  if (m_nCaretPosX1==0) break;
                    if (m_nCaretPosX1==0) {
                        if (m_nCaretPosY==0) break;
                        m_nCaretPosX1=7;
                        bEnd = TRUE;
                        Up();
                        break;
                    }
                    m_nCaretPosX1--;
                    break;
                    
                case 3:
//                  if (m_nCaretPosX1==0) break;
                    if (m_nCaretPosX1==0) {
                        if (m_nCaretPosY==0) break;
                        m_nCaretPosX1=3;
                        bEnd = TRUE;
                        Up();
                        break;
                    }
                    m_nCaretPosX1--;
                    break;
                    
                default:
                    break;
            }
            break;
            
        case 2:
            switch(m_nViewMode1) {
                case 1:
//                  if (m_nCaretPosX1==0) break;
                    if (m_nCaretPosX1==0) {
                        if (m_nCaretPosY==0) break;
                        m_nCaretPosX1=15;
                        bEnd = TRUE;
                        Up();
                        break;
                    }
                    m_nCaretPosX1--;
                    break;
                    
                case 2:
//                  if (m_nCaretPosX1==0) break;
                    if (m_nCaretPosX1==0) {
                        if (m_nCaretPosY==0) break;
                        m_nCaretPosX1=7;
                        bEnd = TRUE;
                        Up();
                        break;
                    }
                    m_nCaretPosX1--;
                    break;
                    
                case 3:
//                  if (m_nCaretPosX1==0) break;
                    if (m_nCaretPosX1==0) {
                        if (m_nCaretPosY==0) break;
                        m_nCaretPosX1=3;
                        bEnd = TRUE;
                        Up();
                        break;
                    }
                    m_nCaretPosX1--;
                    break;
                    
                default:
                    break;
            }
            break;
            
        case 1:
            switch(m_nViewMode1) {
                case 1:
//                  if (m_nCaretPosX1==0) break;
                    if (m_nCaretPosX1==0) {
                        if (m_nCaretPosY==0) break;
                        m_nCaretPosX1=15;
                        bEnd = TRUE;
                        Up();
                        break;
                    }
                    m_nCaretPosX1--;
                    break;
                    
                case 2:
//                  if (m_nCaretPosX1==0) break;
                    if (m_nCaretPosX1==0) {
                        if (m_nCaretPosY==0) break;
                        m_nCaretPosX1=7;
                        bEnd = TRUE;
                        Up();
                        break;
                    }
                    m_nCaretPosX1--;
                    break;
                    
                case 3:
//                  if (m_nCaretPosX1==0) break;
                    if (m_nCaretPosX1==0) {
                        if (m_nCaretPosY==0) break;
                        m_nCaretPosX1=3;
                        bEnd = TRUE;
                        Up();
                        break;
                    }
                    m_nCaretPosX1--;
                    break;
                    
                default:
                    break;
            }
            break;
            
        default:
            break;
    }
    
    if (m_nCaretArea != 2) {        // Not in Ascii area    
       // Add by Daniel Lin      03/15/1996
       //
       // Process the following status:
       //  Press Shift_Tab key, the caret is out of window, the window must 
       //  scroll.If caret at the begin of the line, press the key again, scroll 
       //  to the end and the memory scroll down one line(the client scroll up one 
       //  line)
       //             
       
       RECT clientRect;
       GetClientRect(&clientRect);
       int xWidth = 0;
       if (bEnd) {
         xWidth = m_nCaretPosX1*m_gridMem.m_nGridWidth+m_gridAddr.m_nGridWidth; 
         if (xWidth < clientRect.left)
             SendMessage(WM_HSCROLL, SB_LINEUP, 0L);
         bEnd = FALSE;    
       }      
       else {
         int nMin, nMax;
              
         GetScrollRange(SB_HORZ, &nMin, &nMax);
         m_nPosX = -nMax;
         InvalidateRect(NULL, TRUE);
       }  
    }   
    
    SetMyCaretPos();
}

void CNewMemory::Back()
{
}

void CNewMemory::Space()
{
}

BOOL CNewMemory::InputCheck(UINT nChar)
{
    BOOL bOk;

    bOk = FALSE;

    if (m_nCaretArea == 2) {
        if (isprint(nChar) != 0) bOk = TRUE;
        if (bOk) {
            GetValue();
        }
    }
    else {
        switch(m_nViewMode2) {
            case 4:
                break;
                
            case 3:
                if (('0'<=nChar)&&(nChar<='9')) bOk=TRUE;
                if (('a'<=nChar)&&(nChar<='f')) bOk=TRUE;
                if (('A'<=nChar)&&(nChar<='F')) bOk=TRUE;
                if (bOk) {
                    GetValue();
                    ValueToStr();
                    m_lpszValue[m_nCaretPosX2]=(char)nChar;
                    bOk = StrToValue();
                }
                break;
                
            case 2:
                if (('0'<=nChar)&&(nChar<='9')) bOk=TRUE;
                if (bOk) {
                    GetValue();
                    ValueToStr();
                    m_lpszValue[m_nCaretPosX2]=(char)nChar;
                    bOk = StrToValue();
                }
                break;
                
            case 1:
                if (m_nCaretPosX2==0) {
                    if (('+'==nChar)||((nChar=='-')&&(m_nViewMode1!=1))) bOk=TRUE;
                }
                else
                    if (('0'<=nChar)&&(nChar<='9')) bOk=TRUE;
                if (bOk) {
                    GetValue();
                    ValueToStr();
                    m_lpszValue[m_nCaretPosX2]=(char)nChar;
                    bOk = StrToValue();
                }
                break;
                
            default:
                break;
        }
    }

    if (!bOk) 
       MessageBeep(-1);
       
    return bOk;
}

void CNewMemory::WriteMemory(UINT nChar)
{
   long* l;
   WORD* w;
   BYTE* b;
   int  pos;
   BYTE value;
   UINT i;
   long addr;
   BYTE* f;
   RECT rect;

   b = (BYTE *)m_byMem;
   w = (WORD *)m_byMem;
   l = (long *)m_byMem;
   i = m_nCaretPosY - (UINT)(m_lStartAddress>>4);

   if (m_nCaretArea==2) {
      b = b + i*16 + m_nCaretPosX2;

      addr = m_nCaretPosY*16 + m_nCaretPosX2;
      value = (BYTE)nChar;

//#ifdef _LANE
      MemServerFill(addr,value,m_nSpaceType);
      MemServerDump(&value,addr,1,m_nSpaceType);
//#endif

      *b = value;
   }
   else {
     switch(m_nViewMode1) {
        case 3:
            l = l + i*4 + m_nCaretPosX1;
            f = (BYTE *)(&m_lValue);
            addr = m_nCaretPosY*16 + m_nCaretPosX1*4;

//#ifdef _LANE
            MemServerFill(addr,*f,m_nSpaceType);
            MemServerDump(&value,addr,1,m_nSpaceType);
            *f = value;

            f++;
            addr++;
            MemServerFill(addr,*f,m_nSpaceType);
            MemServerDump(&value,addr,1,m_nSpaceType);
            *f = value;

            f++;
            addr++;
            MemServerFill(addr,*f,m_nSpaceType);
            MemServerDump(&value,addr,1,m_nSpaceType);
            *f = value;

            f++;
            addr++;
            MemServerFill(addr,*f,m_nSpaceType);
            MemServerDump(&value,addr,1,m_nSpaceType);
            *f = value;
//#endif

            *l = m_lValue;
            break;
            
        case 2:
            w = w + i*8 + m_nCaretPosX1;
            f = (BYTE *)(&m_wValue);
            addr = m_nCaretPosY*16 + m_nCaretPosX1*2;

//#ifdef _LANE
            MemServerFill(addr,*f,m_nSpaceType);
            MemServerDump(&value,addr,1,m_nSpaceType);
            *f = value;

            f++;
            addr++;
            MemServerFill(addr,*f,m_nSpaceType);
            MemServerDump(&value,addr,1,m_nSpaceType);
            *f = value;
//#endif

            *w = m_wValue;
            break;
            
        case 1:
            b = b + i*16 + m_nCaretPosX1;

            f = &m_byValue;
            addr = m_nCaretPosY*16 + m_nCaretPosX1;

//#ifdef _LANE
            MemServerFill(addr,*f,m_nSpaceType);
            MemServerDump(&value,addr,1,m_nSpaceType);
            *f = value;
//#endif

            *b = m_byValue;
            break;
            
        default:
            break;
     }
    }
    
    if (m_nCaretArea==2) {
        pos = (int)(m_nCaretPosY-m_lStartAddress/0x10+1);
        int aaa;
        switch (m_nViewMode1) {
            case 1:
                aaa = m_nCaretPosX2;
                break;
                
            case 2:
                aaa = m_nCaretPosX2/2;
                break;
                
            case 3:
                aaa = m_nCaretPosX2/4;
                break;
                
            default:
                aaa = m_nCaretPosX2;
        }
        rect = m_gridMem.GetGridRect(aaa,(UINT)pos);
        if (m_nCaretPosX2<15) 
            m_bGetMemory=FALSE;
        else 
            m_bGetMemory=TRUE;
        m_bGridRedraw = FALSE;
        InvalidateRect(&rect, FALSE);
        rect = m_gridAscii.GetGridRect(0,(UINT)pos);
        if (m_nCaretPosX2<15) 
            m_bGetMemory=FALSE;
        else 
            m_bGetMemory=TRUE;
        m_bGridRedraw=FALSE;
        InvalidateRect(&rect,FALSE);
    }
    else {
        pos = (int)(m_nCaretPosY-m_lStartAddress/0x10+1);
        rect = m_gridMem.GetGridRect(m_nCaretPosX1,(UINT)pos);
        switch(m_nViewMode2) {
            case 3:
                switch(m_nViewMode1) {
                    case 1:
                        if ((m_nCaretPosX1==15)&&(m_nCaretPosX2==1))
                            m_bGetMemory=TRUE;
                        else
                            m_bGetMemory=FALSE;
                        break;
                    case 2:
                        if ((m_nCaretPosX1==7)&&(m_nCaretPosX2==3))
                            m_bGetMemory=TRUE;
                        else
                            m_bGetMemory=FALSE;
                        break;
                    case 3:
                        if ((m_nCaretPosX1==3)&&(m_nCaretPosX2==7))
                            m_bGetMemory=TRUE;
                        else
                            m_bGetMemory=FALSE;
                        break;
                    default:
                        break;
                }
                break;
                
            case 2:
                switch(m_nViewMode1) {
                    case 1:
                        if ((m_nCaretPosX1==15)&&(m_nCaretPosX2==2))
                            m_bGetMemory=TRUE;
                        else
                            m_bGetMemory=FALSE;
                        break;
                    case 2:
                        if ((m_nCaretPosX1==7)&&(m_nCaretPosX2==4))
                            m_bGetMemory=TRUE;
                        else
                            m_bGetMemory=FALSE;
                        break;
                    case 3:
                        if ((m_nCaretPosX1==3)&&(m_nCaretPosX2==9))
                            m_bGetMemory=TRUE;
                        else
                            m_bGetMemory=FALSE;
                        break;
                    default:
                        break;
                }
                break;              
                
            case 1:
                switch(m_nViewMode1) {
                    case 1:
                        if ((m_nCaretPosX1==15)&&(m_nCaretPosX2==3))
                            m_bGetMemory=TRUE;
                        else
                            m_bGetMemory=FALSE;
                        break;
                    case 2:
                        if ((m_nCaretPosX1==7)&&(m_nCaretPosX2==5))
                            m_bGetMemory=TRUE;
                        else
                            m_bGetMemory=FALSE;
                        break;
                    case 3:
                        if ((m_nCaretPosX1==3)&&(m_nCaretPosX2==10))
                            m_bGetMemory=TRUE;
                        else
                            m_bGetMemory=FALSE;
                        break;
                    default:
                        break;
                }
                break;
            default:
                break;
        }

        m_bGridRedraw=FALSE;
        InvalidateRect(&rect,FALSE);
        rect = m_gridAscii.GetGridRect(0,(UINT)pos);
        switch(m_nViewMode2) {
            case 3:
                switch(m_nViewMode1) {
                    case 1:
                        if ((m_nCaretPosX1==15)&&(m_nCaretPosX2==1))
                            m_bGetMemory=TRUE;
                        else
                            m_bGetMemory=FALSE;
                        break;
                        
                    case 2:
                        if ((m_nCaretPosX1==7)&&(m_nCaretPosX2==3))
                            m_bGetMemory=TRUE;
                        else
                            m_bGetMemory=FALSE;
                        break;
                        
                    case 3:
                        if ((m_nCaretPosX1==3)&&(m_nCaretPosX2==7))
                            m_bGetMemory=TRUE;
                        else
                            m_bGetMemory=FALSE;
                        break;
                        
                    default:
                        break;
                }
                break;
                
            case 2:
                switch(m_nViewMode1) {
                    case 1:
                        if ((m_nCaretPosX1==15)&&(m_nCaretPosX2==2))
                            m_bGetMemory=TRUE;
                        else
                            m_bGetMemory=FALSE;
                        break;
                        
                    case 2:
                        if ((m_nCaretPosX1==7)&&(m_nCaretPosX2==4))
                            m_bGetMemory=TRUE;
                        else
                            m_bGetMemory=FALSE;
                        break;
                        
                    case 3:
                        if ((m_nCaretPosX1==3)&&(m_nCaretPosX2==9))
                            m_bGetMemory=TRUE;
                        else
                            m_bGetMemory=FALSE;
                        break;
                        
                    default:
                        break;
                }
                break;
                
            case 1:
                switch(m_nViewMode1) {
                    case 1:
                        if ((m_nCaretPosX1==15)&&(m_nCaretPosX2==3))
                            m_bGetMemory=TRUE;
                        else
                            m_bGetMemory=FALSE;
                        break;
                        
                    case 2:
                        if ((m_nCaretPosX1==7)&&(m_nCaretPosX2==5))
                            m_bGetMemory=TRUE;
                        else
                            m_bGetMemory=FALSE;
                        break;
                        
                    case 3:
                        if ((m_nCaretPosX1==3)&&(m_nCaretPosX2==10))
                            m_bGetMemory=TRUE;
                        else
                            m_bGetMemory=FALSE;
                        break;
                        
                    default:
                        break;
                }
                break;
            default:
                break;
        }

        m_bGridRedraw=FALSE;
        InvalidateRect(&rect,FALSE);
    }
}

void CNewMemory::GetValue()
{
    long* l;
    WORD* w;
    BYTE* b;
    int j,pos;
    BYTE value;
    UINT i;

    b = (BYTE *)m_byMem;
    w = (WORD *)m_byMem;
    l = (long *)m_byMem;
    i = m_nCaretPosY - (UINT)(m_lStartAddress>>4);

    if (m_nCaretArea==2) {
        b = b + i*16;
        for(j=0;j<16;j++) {
            pos = j;
            value = b[pos];
            if ((0x20<value)&&(value<=0x7e)) m_lpszValue[j]=value;
            else m_lpszValue[j]='.';
        }
        m_lpszValue[j]='\0';
    }
    else {
        switch(m_nViewMode1) {
            case 3:
                l = l + i*4 + m_nCaretPosX1;
                m_lValue = *l;
                break;
            case 2:
                w = w + i*8 + m_nCaretPosX1;
                m_wValue = *w;
                break;
            case 1:
                b = b + i*16 + m_nCaretPosX1;
                m_byValue = *b;
                break;
            default:
                break;
        }
    }
}

void CNewMemory::ValueToStr()
{
    switch (m_nViewMode2) {
        case 3:
            switch(m_nViewMode1) {
                case 3:
                    sprintf(m_lpszValue,"%08lX",m_lValue);
                    break;
                case 2:
                    sprintf(m_lpszValue,"%04X",m_wValue);
                    break;
                case 1:
                    sprintf(m_lpszValue,"%02X",m_byValue);
                    break;
                default:
                    break;
            }
            break;
        case 2:
            switch(m_nViewMode1) {
                case 3:
                    sprintf(m_lpszValue,"%010lu",m_lValue);
                    break;
                case 2:
                    sprintf(m_lpszValue,"%05u",m_wValue);
                    break;
                case 1:
                    sprintf(m_lpszValue,"%03u",m_byValue);
                    break;
                default:
                    break;
            }
            break;
        case 1:
            switch(m_nViewMode1) {
                case 3:
                    sprintf(m_lpszValue,"%+011ld",m_lValue);
                    break;
                case 2:
                    sprintf(m_lpszValue,"%+06d",m_wValue);
                    break;
                case 1:
                    sprintf(m_lpszValue,"%+04d",m_byValue);
                    break;
                default:
                    break;
            }
            break;
        default:
            break;
    }
}

BOOL CNewMemory::StrToValue()
{
    long value;
    BOOL bOk;

    bOk=TRUE;
    switch (m_nViewMode2) {
        case 3:
            switch(m_nViewMode1) {
                case 3:
                    value=strtoul(m_lpszValue,NULL,16);
                    m_lValue = value;
                    break;
                case 2:
                    value=strtol(m_lpszValue,NULL,16);
                    m_wValue = (WORD)value;
                    break;
                case 1:
                    value=strtol(m_lpszValue,NULL,16);
                    m_byValue = (BYTE)value;
                    break;
                default:
                    break;
            }
            break;
        case 2:
            switch(m_nViewMode1) {
                case 3:
                    value=strtoul(m_lpszValue,NULL,10);
                    if (errno==ERANGE) bOk = FALSE;
                    else bOk=TRUE;
                    errno=0;
                    m_lValue = value;
                    break;
                case 2:
                    value=strtol(m_lpszValue,NULL,10);
                    if ((value>=0)&&(value<=0xffff)) bOk = TRUE;
                    else bOk=FALSE;
                    m_wValue = (WORD)value;
                    break;
                case 1:
                    value=strtol(m_lpszValue,NULL,10);
                    if ((value>=0)&&(value<=0xff)) bOk = TRUE;
                    else bOk=FALSE;
                    m_byValue = (BYTE)value;
                    break;
                default:
                    break;
            }
            break;
            
        case 1:
            switch(m_nViewMode1) {
                case 3:
                    value=strtol(m_lpszValue,NULL,10);
                    if (errno==ERANGE) bOk = FALSE;
                    else bOk=TRUE;
                    errno=0;
                    m_lValue = value;
                    break;
                case 2:
                    value=strtol(m_lpszValue,NULL,10);
                    if ((value>=(long)(-32768))&&(value<=0x7fff)) bOk = TRUE;
                    else bOk=FALSE;
                    m_wValue = (WORD)value;
                    break;
                case 1:
                    value=strtol(m_lpszValue,NULL,10);
                    if ((value>=0)&&(value<=0xff)) bOk = TRUE;
                    else bOk=FALSE;
                    m_byValue = (BYTE)value;
                    break;
                default:
                    break;
            }
            break;
        default:
            break;
    }
    
    return bOk;
}

CNewMemory::CNewMemory()
{
    CPUMEMORYRANGE stRange;
    CMemGtDlg   dlg(this);

    GetMemoryRange( &stRange );         // Get the current cpu memory
    pMin = stRange.pMin;
    pMax = stRange.pMax;
    xMin = stRange.xMin;
    xMax = stRange.xMax;
    iMin = stRange.iMin;
    iMax = stRange.iMax;

    m_nIDHelp = IDR_MEMORY;
    m_nInstructionWidth = InstructionWidth;
    m_nLines = 15;             // modify by Daniel Lin on 1996.7.3
    m_nViewMode1=1;
    m_nViewMode2=3;
    m_bShowAscii=TRUE;
    m_bGridRedraw = TRUE;
    m_bGridDrawn = FALSE;
    m_nScrollFlags = 0;

    m_nSpaceType = linLastCheck;        //2;

    m_nPosX = 0;

    m_byMem = new BYTE[1024];
//  ASSERT(m_byMem != NULL);
    m_lpszValue = new char[20];
//  ASERT(m_lpszValue != NULL);
    m_dsm= new struct dsm[128];  
//  ASSERT(m_dsm != NULL);
    ASSERT(m_byMem!=NULL);
    ASSERT(m_lpszValue!=NULL);
    ASSERT(m_dsm!=NULL);
    m_lStartAddress = linLastStartAddr;         //0;
    m_nCaretPosX1 = 0;
    m_nCaretPosX2 = 0;
    m_nCaretPosY = 0;
    m_nCaretArea = 1;
    m_nCharWidth = 8;
    m_nCursor = 0;
    m_nKeyFlag = 0;
    m_bGetMemory=TRUE;
    /*
    ASSERT(NULL != m_searchStr);
    memset(m_searchStr, 0, sizeof(m_searchStr));
    */
    //GetMemory();
}

CNewMemory::~CNewMemory()
{
    isMemOn[m_nWndNo] = FALSE;
    //LastMemAddress[m_nWndNo] =
    if (m_byMem!=NULL) delete m_byMem;
    switch (m_nWndNo) {
      case 0:
           Mem1 = 1;
           Cur1 = 1;
           break;
      case 1:
           Mem2 = 1;
           Cur2 = 1;
           break;
      case 2:
           Mem3 = 1;
           Cur3 = 1;
           break;
    }
/*
   int no = m_nWndNo;   
   if (pMemWnd[no] != NULL) {
      delete pMemWnd[no];
      pMemWnd[no] = NULL;
   }      
*/   
}



/////////////////////////////////////////////////////////////////////////////
// CNewMemory message handlers
//

int CNewMemory::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
    if (CMDIChildWnd::OnCreate(lpCreateStruct) == -1)
        return -1;
    SetWindowTitle();
    int nScrollMax = int(dwpMax >> 4);
    SetScrollRange(SB_VERT, 0, nScrollMax, TRUE);

    SetMemoryWindow();
    SetMyCaretPos();
    SetFocus();      // Add on 1996.4.12

    return 0;
}

void CNewMemory::OnPaint()
{
    CPaintDC dc(this); // device context for painting

    // TODO: Add your message handler code here
    SetMemoryWindow();
    SetScrollBar();
    m_gridAddr.Show(&dc,TRUE);
    m_gridMem.Show(&dc,TRUE);
    if (m_nViewMode2!=4) {
        if (m_bShowAscii)
           m_gridAscii.Show(&dc,TRUE);
    }
    else m_gridInstruction.Show(&dc,TRUE);
    m_bGridDrawn = TRUE;
    
    // for the GO status
    unsigned char uchCpuStatus;
    if (GetCpuStatus(uchCpuStatus)) {
      if ( 1 != uchCpuStatus ) {       // Is on GO status (STATUS_GO)
          GetMemory();
      }    
      else  {
         if ( SrcEmu.m_isRunAccess ) {       // GO and Run Access
            GetMemory();                     // memory dump from ICE
         }
         else {                  // GO and No Run Access
                                 // Do nothing, memory dump from m_bBuf         
         }
      }     
    }      
    
    ShowMemoryWindow(&dc);
    SetMyCaretPos();
    SetScrollPos(SB_VERT, (UINT)(m_lStartAddress/0x10), TRUE);    

    // Do not call CMDIChildWnd::OnPaint() for painting messages
}

void CNewMemory::OnRButtonDown(UINT nFlags, CPoint point)
{
    // TODO: Add your message handler code here and/or call default
    CMenu * pLocalMenu = new CMenu;

    ASSERT(pLocalMenu!=NULL);
    pLocalMenu->CreatePopupMenu();
    
    pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_REFRESH, "&Refresh");
    pLocalMenu->AppendMenu(MF_SEPARATOR);
   
    pLocalMenu->AppendMenu(MF_STRING, ID_GROUP_MEMORY, "&Memory...");
    pLocalMenu->AppendMenu(MF_STRING, ID_MAP, "Ma&p...");
    pLocalMenu->AppendMenu(MF_STRING, ID_EDIT_GOTO, "&Goto...");
    pLocalMenu->AppendMenu(MF_SEPARATOR);
   
    pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_ASCII, "Show &ASCII");
    pLocalMenu->AppendMenu(MF_SEPARATOR);
   
    pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_HEXADECIMAL, "&Hexadecimal");
    pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_SIGNEDDECIMAL, "&Signed Decimal");
    pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_UNSIGNEDDECIMAL, "&Unsigned Decimal");
    pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_DISASSEMBLE, "&Disassemble");
    pLocalMenu->AppendMenu(MF_SEPARATOR);
   
    pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_BYTE, "&Byte");
    pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_WORD, "&Word");
    pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_LONG, "&Long");
       
    ClientToScreen(&point);
    pLocalMenu->TrackPopupMenu(TPM_CENTERALIGN, point.x, point.y, this);
    
    delete pLocalMenu;

    CMDIChildWnd::OnRButtonDown(nFlags, point);
}

BOOL CNewMemory::OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message)
{
    // TODO: Add your message handler code here and/or call default
    if (message==WM_RBUTTONDOWN)
        return FALSE;

    return CMDIChildWnd::OnSetCursor(pWnd, nHitTest, message);
}

void CNewMemory::OnViewByte()
{
    // TODO: Add your command handler code here
    if (m_nViewMode1==1) return;
    m_nViewMode1 = 1;

    switch (m_nWndNo) {
      case 0:
           LastMem1View1 = 1;
           break;

      case 1:
           LastMem2View1 = 1;
           break;

      case 2:
           LastMem3View1 = 1;
           break;
    }
    SetMemoryWindow();
    SetScrollBar();
    m_nCaretPosX1=0;
    m_nCaretPosX2=0;
    InvalidateRect(FALSE);
}

void CNewMemory::OnUpdateViewByte(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    unsigned char uchCpuStatus;
    
    if (GetCpuStatus(uchCpuStatus)) {
      if ( 1 == uchCpuStatus ) {       // Is on GO status (STATUS_GO)
         pCmdUI->Enable(FALSE);
      }
      else         
        pCmdUI->Enable(TRUE);
    }
        
    if (m_nViewMode1==1) pCmdUI->SetRadio(TRUE);
    else pCmdUI->SetRadio(FALSE);
}

void CNewMemory::OnViewWord()
{
    // TODO: Add your command handler code here
    if (m_nViewMode1==2) return;
    m_nViewMode1 = 2;
    switch (m_nWndNo) {
      case 0:
           LastMem1View1 = 2;
           break;

      case 1:
           LastMem2View1 = 2;
           break;

      case 2:
           LastMem3View1 = 2;
           break;
    }
    SetMemoryWindow();
    SetScrollBar();
    m_nCaretPosX1=0;
    m_nCaretPosX2=0;
    InvalidateRect(FALSE);
}

void CNewMemory::OnUpdateViewWord(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    unsigned char uchCpuStatus;
    
    if (GetCpuStatus(uchCpuStatus)) {
      if ( 1 == uchCpuStatus ) {       // Is on GO status (STATUS_GO)
         pCmdUI->Enable(FALSE);
      }
      else          
         pCmdUI->Enable(TRUE);
    }
             
    if (m_nViewMode1==2) pCmdUI->SetRadio(TRUE);
    else pCmdUI->SetRadio(FALSE);
}

void CNewMemory::OnViewLong()
{
    // TODO: Add your command handler code here
    if (m_nViewMode1==3) return;
    m_nViewMode1=3;
    switch (m_nWndNo) {
      case 0:
           LastMem1View1 = 3;
           break;

      case 1:
           LastMem2View1 = 3;
           break;

      case 2:
           LastMem3View1 = 3;
           break;
    }
    SetMemoryWindow();
    SetScrollBar();
    m_nCaretPosX1=0;
    m_nCaretPosX2=0;
    InvalidateRect(FALSE);
}

void CNewMemory::OnUpdateViewLong(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    unsigned char uchCpuStatus;
    
    if (GetCpuStatus(uchCpuStatus)) {
      if ( 1 == uchCpuStatus ) {       // Is on GO status (STATUS_GO)
         pCmdUI->Enable(FALSE);
      }
      else          
         pCmdUI->Enable(TRUE);
    }
    
    if (m_nViewMode1==3) pCmdUI->SetRadio(TRUE);
    else pCmdUI->SetRadio(FALSE);
}

void CNewMemory::OnViewFloat()
{
    // TODO: Add your command handler code here
}

void CNewMemory::OnUpdateViewFloat(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    pCmdUI->Enable(FALSE);
}

void CNewMemory::OnViewDouble()
{
    // TODO: Add your command handler code here
}

void CNewMemory::OnUpdateViewDouble(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    unsigned char uchCpuStatus;
    
    if (GetCpuStatus(uchCpuStatus)) {
      if ( 1 == uchCpuStatus ) {       // Is on GO status (STATUS_GO)
         pCmdUI->Enable(FALSE);
      }
      else          
         pCmdUI->Enable(TRUE);
    }
}

void CNewMemory::OnViewSigneddecimal()
{
    // TODO: Add your command handler code here
    if (m_nViewMode2==1) return;
    m_lStartAddress &=(long)0xFFFFFFF0;
    m_nViewMode2=1;
    switch (m_nWndNo) {
      case 0:
           LastMem1View2 = 1;
           break;

      case 1:
           LastMem2View2 = 1;
           break;

      case 2:
           LastMem3View2 = 1;
           break;
    }
    SetMemoryWindow();
    SetScrollBar();
    m_nCaretPosX1=0;
    m_nCaretPosX2=0;
    InvalidateRect(FALSE);
}

void CNewMemory::OnUpdateViewSigneddecimal(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    unsigned char uchCpuStatus;
    
    if (GetCpuStatus(uchCpuStatus)) {
      if ( 1 == uchCpuStatus ) {       // Is on GO status (STATUS_GO)
         pCmdUI->Enable(FALSE);
      }
      else          
         pCmdUI->Enable(TRUE);
    }
    if (m_nViewMode2==1) pCmdUI->SetRadio(TRUE);
    else pCmdUI->SetRadio(FALSE);
}

void CNewMemory::OnViewHexadecimal()
{
    // TODO: Add your command handler code here
    if (m_nViewMode2==3) return;
    m_lStartAddress &=(long)0xFFFFFFF0;
    m_nViewMode2=3;
    switch (m_nWndNo) {
      case 0:
           LastMem1View2 = 3;
           break;

      case 1:
           LastMem2View2 = 3;
           break;

      case 2:
           LastMem3View2 = 3;
           break;
    }
    SetMemoryWindow();
    SetScrollBar();
    m_nCaretPosX1=0;
    m_nCaretPosX2=0;
    InvalidateRect(FALSE);
}

void CNewMemory::OnUpdateViewHexadecimal(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    //pCmdUI->Enable(TRUE);
    unsigned char uchCpuStatus;
    
    if (GetCpuStatus(uchCpuStatus)) {
      if ( 1 == uchCpuStatus ) {       // Is on GO status (STATUS_GO)
         pCmdUI->Enable(FALSE);
      }
      else          
         pCmdUI->Enable(TRUE);
    }
    
    if (m_nViewMode2==3) pCmdUI->SetRadio(TRUE);
    else pCmdUI->SetRadio(FALSE);
}

void CNewMemory::OnViewDisassemble()
{
    // TODO: Add your command handler code here
    if (m_nViewMode2==4) return;
    m_nViewMode2=4;
    switch (m_nWndNo) {
      case 0:
           LastMem1View2 = 4;
           break;

      case 1:
           LastMem2View2 = 4;
           break;

      case 2:
           LastMem3View2 = 4;
           break;
    }
    m_nInstructionWidth = InstructionWidth;
    InvalidateRect(FALSE);
    UpdateWindow();
    OnViewRefresh();
}

void CNewMemory::OnUpdateViewDisassemble(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    unsigned char uchCpuStatus;
    
    if (GetCpuStatus(uchCpuStatus)) {
      if ( 1 == uchCpuStatus ) {       // Is on GO status (STATUS_GO)
         pCmdUI->Enable(FALSE);
      }
      else {
       if (m_nSpaceType!=3) pCmdUI->Enable(TRUE);
       else pCmdUI->Enable(FALSE);
      }      
    }
    
    if (m_nViewMode2 == 4) pCmdUI->SetRadio(TRUE);
    else pCmdUI->SetRadio(FALSE);
}

void CNewMemory::OnViewAscii()    
{
    // TODO: Add your command handler code here
    m_bShowAscii = !m_bShowAscii;
    SetMemoryWindow();
    SetScrollBar();
    m_nCaretPosX1=0;
    m_nCaretPosX2=0;
    if (!m_bShowAscii&&(m_nViewMode2!=4)) m_nCaretArea = 1;
    InvalidateRect(FALSE);
}

void CNewMemory::OnUpdateViewAscii(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    //pCmdUI->Enable(TRUE);
    unsigned char uchCpuStatus;
    
    if (GetCpuStatus(uchCpuStatus)) {
      if ( 1 == uchCpuStatus ) {       // Is on GO status (STATUS_GO)
         pCmdUI->Enable(FALSE);
      }
      else {
       pCmdUI->Enable(TRUE);
      }      
    }
    
    if (m_bShowAscii) pCmdUI->SetCheck(TRUE);
    else pCmdUI->SetCheck(FALSE);
}

void CNewMemory::OnViewUnsigneddecimal()
{
    // TODO: Add your command handler code here
    if (m_nViewMode2==2) return;
    m_lStartAddress &=(long)0xFFFFFFF0;
    m_nViewMode2 = 2;
    switch (m_nWndNo) {
      case 0:
           LastMem1View2 = 2;
           break;

      case 1:
           LastMem2View2 = 2;
           break;

      case 2:
           LastMem3View2 = 2;
           break;
    }
    SetMemoryWindow();
    SetScrollBar();
    m_nCaretPosX1=0;
    m_nCaretPosX2=0;
    InvalidateRect(FALSE);
}

void CNewMemory::OnUpdateViewUnsigneddecimal(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    //pCmdUI->Enable(TRUE);
    unsigned char uchCpuStatus;
    
    if (GetCpuStatus(uchCpuStatus)) {
      if ( 1 == uchCpuStatus ) {       // Is on GO status (STATUS_GO)
         pCmdUI->Enable(FALSE);
      }
      else {
       pCmdUI->Enable(TRUE);
      }      
    }
    
    if (m_nViewMode2==2) pCmdUI->SetRadio(TRUE);
    else pCmdUI->SetRadio(FALSE);
}

BOOL bRedraw = FALSE;
int gnLines1 = 0;

void CNewMemory::OnSize(UINT nType, int cx, int cy)
{   
    RECT rect1, rect2;
    //int nretLines = 0;
    //unsigned char uchCpuStatus;

    CMDIChildWnd::OnSize(nType, cx, cy);
   
    m_bGridRedraw = TRUE;
    GetClientRect(&rect1);
    
    if (bRedraw==FALSE) {
       gnLines1 = (rect1.bottom - rect1.top) / m_gridAddr.m_nGridHeight+1;
        
       int nLines = 0;
       switch (m_nSpaceType) {
         case  1:    // Code area
               nLines = int((dwpMax - dwpMin) >> 4);
               if ( (gnLines1-2) > nLines ) {
                  m_nLines = nLines;
                  bRedraw = TRUE;
               }
               else
                  m_nLines = gnLines1;               
               break;
                  
         case  2:    // Data area
               nLines = int((dwxMax - dwxMin) >> 4);
               if ( (gnLines1-2) > nLines ) {
                  m_nLines = nLines;
                  bRedraw = TRUE;
               }
               else
                  m_nLines = gnLines1;               
               break;
                  
         case  3:    // On chip area
               nLines = int((dwiMax - dwiMin) >> 4);
               if ( (gnLines1-2) > nLines ) {
                  m_nLines = nLines;
                  bRedraw = TRUE;
               }
               else
                  m_nLines = gnLines1;               
               break;
       }
    }       
    else
       bRedraw = FALSE;
             

    //       
    // Reset the variable of memory window; 
    // Add at 1996.4.2 by Daniel Lin
    //
    SetMemoryWindow();
       
    if (bRedraw) {
       GetWindowRect(&rect2);
       rect2.bottom = m_nLines * m_gridAddr.m_nGridHeight;
       SetWindowPos(NULL, 
                    rect2.left, rect2.top, 
                    rect2.right-rect2.left,
                    rect2.bottom-rect2.top, 
                    SWP_NOMOVE);
       bRedraw = TRUE;
    }      
    
    if ((rect1.bottom%m_gridAddr.m_nGridHeight) == 0) 
       m_bModeLine = FALSE;
    else //{
       m_bModeLine = TRUE;
   
    if (m_bModeLine) {
       GetWindowRect(&rect2);
      //rect2.bottom += m_gridAddr.m_nGridHeight-
      //                (rect1.bottom%m_gridAddr.m_nGridHeight);
       rect2.bottom -= rect1.bottom%m_gridAddr.m_nGridHeight;
       SetWindowPos(NULL, rect2.left,
                    rect2.top, rect2.right-rect2.left,
                    rect2.bottom-rect2.top, SWP_NOMOVE);
       bRedraw = FALSE;                         
       SetScrollBar();
       OnViewRefresh();
   }       
}

void CNewMemory::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
     // TODO: Add your message handler code here and/or call default
    long dwTempAddress = 0, dwTempAddress2 = 0;
    unsigned char uchCpuStatus;
    
    if ( GetCpuStatus(uchCpuStatus) ) {
      if ( 1 != uchCpuStatus ) {        // CPU not at GO
          InvalidateRect(NULL,FALSE);                                
          switch (nSBCode) {
              case SB_LINEUP:
                  if (m_lStartAddress <= 0 ) break;
                  if (m_nViewMode2 != 4) {     // Disassembly
                    m_lStartAddress-=0x10;
                    SetScrollPos(SB_VERT,(UINT)(m_lStartAddress/0x10),TRUE);
                    ScrollMemWnd(1);
                    if (m_bGridDrawn) m_bGridRedraw = FALSE;
                    else m_bGridRedraw = TRUE;
                    m_nScrollFlags = 1;
                    InvalidateRect(NULL,FALSE);
                  }
                  else {
                    m_lStartAddress--;
                    SetScrollPos(SB_VERT,(UINT)(m_lStartAddress/0x10),TRUE);
                    if (m_bGridDrawn) m_bGridRedraw = FALSE;
                    else m_bGridRedraw = TRUE;
                    InvalidateRect(NULL,FALSE);
                  }
                  break;
                     
              case SB_LINEDOWN:  
                   if (m_nViewMode2 != 4) {
                       m_lStartAddress += 0x10;
                       dwTempAddress2 = m_lStartAddress+(m_nLines-3)*16;
                       switch( m_nSpaceType ) {
                          case 1:
                             // Add by Daniel Lin 
                             if (dwTempAddress2 > ((long)pMax&0xFFF0)) {
                                 m_lStartAddress = (long)pMax-(m_nLines-3)*16;
                                 m_lStartAddress &= 0xFFF0;
                                 goto out; 
                             }    
                             break;    
                                
                          case 2:
                             // Add by Daniel Lin 
                             if (dwTempAddress2 > ((long)xMax&0xFFF0)) {
                                m_lStartAddress = (long)xMax-(m_nLines-3)*16;
                                m_lStartAddress &= 0xFFF0;
                                goto out;
                             }   
                             break;   
                                
                          case 3:
                             // Add by Daniel Lin 
                             if (dwTempAddress2 > ((long)iMax&0xFFF0)) {
                                m_lStartAddress = (long)iMax-(m_nLines-3)*16;
                                m_lStartAddress &= 0xFFF0;
                                goto out;                       
                             }   
                             break;   
                       }
                           
                       SetScrollPos(SB_VERT,(UINT)(m_lStartAddress/0x10),TRUE);
                       ScrollMemWnd(-1);
                       m_nScrollFlags = -1;
                       if (m_bGridDrawn) m_bGridRedraw = FALSE;
                       else m_bGridRedraw = TRUE;
                   }
                   else {
                       m_lStartAddress++;
                       dwTempAddress2 = m_lStartAddress;
                       switch( m_nSpaceType ) {
                          case 1:         // Code area
                             // Add by Daniel Lin 
                             if (dwTempAddress2 > ((long)pMax&0xFFF0)) {
                                 m_lStartAddress = (long)pMax-m_nLines;
                                 m_lStartAddress &= 0xFFF0;
                                 goto out; 
                             }    
                             break;    
                                
                          case 2:         // Data area
                             // Add by Daniel Lin 
                             if (dwTempAddress2 > ((long)xMax&0xFFF0)) {
                                m_lStartAddress = (long)xMax-m_nLines;
                                m_lStartAddress &= 0xFFF0;
                                goto out;
                             }   
                             break;   
                       }                          
                       
                       SetScrollPos(SB_VERT,(UINT)(m_lStartAddress), TRUE);
                       if (m_bGridDrawn) m_bGridRedraw = FALSE;
                       else m_bGridRedraw = TRUE;
                   }
                      
                   InvalidateRect(NULL,FALSE);                            
                  
                   out:    
                   break;
                  
              case SB_PAGEUP:
                  if (m_nViewMode2 != 4) 
                     m_lStartAddress=m_lStartAddress - (m_nLines - 2 ) * 0x10;
                  else 
                     m_lStartAddress = m_lStartAddress - (m_nLines - 2);
                  if (m_lStartAddress < 0) 
                     m_lStartAddress = 0;
                  SetScrollPos(SB_VERT,(UINT)(m_lStartAddress/0x10), TRUE);
                  if (m_bGridDrawn) 
                     m_bGridRedraw = FALSE;
                  else 
                     m_bGridRedraw = TRUE;
                  InvalidateRect(NULL, FALSE);
                  break;
                  
              case SB_PAGEDOWN:
                  if (m_nViewMode2 != 4) {     // Not assemble
                     m_lStartAddress = m_lStartAddress + (m_nLines - 2) * 0x10;
                     dwTempAddress = m_lStartAddress+(m_nLines-3)*16;
                     switch( m_nSpaceType ) {
                          case      1:
                             // Add by Daniel Lin 
                             if (dwTempAddress > ((long)pMax&0xFFF0)) {
                                m_lStartAddress = (long)pMax-(m_nLines-2)*16;
                                m_lStartAddress &= 0xFFF0;
                                goto out1;
                             }                       
                             break;      
                             
                          case      2:
                             // Add by Daniel Lin 
                             if (dwTempAddress > ((long)xMax&0xFFF0)) {
                                m_lStartAddress = (long)xMax-(m_nLines-2)*16;                    
                                m_lStartAddress &= 0xFFF0;
                                goto out1;                       
                             }                       
                             break;   
                             
                          case      3:
                             // Add by Daniel Lin 
                             if (dwTempAddress > ((long)iMax&0xFFF0)) {
                                m_lStartAddress = (long)iMax-(m_nLines-2)*16;                    
                                m_lStartAddress &= 0xFFF0;
                                goto out1;
                             }                       
                             break;   
                     }                          
                 
                     SetScrollPos(SB_VERT,(UINT)(m_lStartAddress/0x10),TRUE);
                     if (m_bGridDrawn) 
                        m_bGridRedraw = FALSE;
                     else 
                        m_bGridRedraw = TRUE;
                  }               
                  else {
                     m_lStartAddress = m_lStartAddress + (m_nLines - 2);
                     dwTempAddress = m_lStartAddress+m_nLines;
                     switch( m_nSpaceType ) {
                          case      1:
                             // Add by Daniel Lin 
                             if (dwTempAddress > ((long)pMax&0xFFF0)) {
                                m_lStartAddress = (long)pMax-m_nLines;
                                m_lStartAddress &= 0xFFF0;
                                goto out1;
                             }                       
                             break;      
                             
                          case      2:
                             // Add by Daniel Lin 
                             if (dwTempAddress > ((long)xMax&0xFFF0)) {
                                m_lStartAddress = (long)xMax-m_nLines;                    
                                m_lStartAddress &= 0xFFF0;
                                goto out1;                       
                             }                       
                             break;   
                     }                          
                 
                     SetScrollPos(SB_VERT,(UINT)(m_lStartAddress),TRUE);
                     if (m_bGridDrawn) 
                        m_bGridRedraw = FALSE;
                     else 
                        m_bGridRedraw = TRUE;
                  }   
                  
                  InvalidateRect(NULL,FALSE);
                  
                  out1:
                  break;
                  
              case SB_THUMBPOSITION:
                  m_lStartAddress=(unsigned short)nPos*0x10;        
                  dwTempAddress2 = m_lStartAddress+(m_nLines-3)*16;
                  switch( m_nSpaceType ) {
                       case      1:
                          // Add by Daniel Lin 
                          if (dwTempAddress > ((long)pMax&0xFFF0)) {
                             m_lStartAddress = (long)pMax-(m_nLines-3)*16;                       
                             m_lStartAddress &= 0xFFF0;
                             goto out2;
                          }
                          break;
                                
                       case      2:
                          // Add by Daniel Lin 
                          if (dwTempAddress > ((long)xMax&0xFFF0)) {
                             m_lStartAddress = (long)xMax-(m_nLines-3)*16;                       
                             m_lStartAddress &= 0xFFF0;
                             goto out2;
                          }   
                          break;
                                
                       case      3:
                          // Add by Daniel Lin 
                          if (dwTempAddress > ((long)iMax&0xFFF0)) {
                             m_lStartAddress = (long)iMax-(m_nLines-3)*16;                       
                             m_lStartAddress &= 0xFFF0;
                             goto out2;
                          }
                          break;   
                  }                          
      
                  //ShowScrollBar(SB_VERT, TRUE);        // Add on 1996.4.12
                  SetScrollPos(SB_VERT,(UINT)(m_lStartAddress/0x10),TRUE);
                  if (m_bGridDrawn) m_bGridRedraw = FALSE;
                  else m_bGridRedraw = TRUE;
                  
                  InvalidateRect(NULL, TRUE);            
                  RedrawWindow();
                  
                  out2:
                  break;
              
              case SB_THUMBTRACK:
                  m_lStartAddress=(unsigned short)nPos*0x10;        
                  dwTempAddress2 = m_lStartAddress+(m_nLines-3)*16;
                  switch( m_nSpaceType ) {
                       case      1:
                          // Add by Daniel Lin 
                          if (dwTempAddress > ((long)pMax&0xFFF0)) {
                             m_lStartAddress = (long)pMax-(m_nLines-3)*16;                       
                             m_lStartAddress &= 0xFFF0;
                             goto out22;
                          }
                          break;
                                   
                       case      2:
                          // Add by Daniel Lin 
                          if (dwTempAddress > ((long)xMax&0xFFF0)) {
                             m_lStartAddress = (long)xMax-(m_nLines-3)*16;                       
                             m_lStartAddress &= 0xFFF0;
                             goto out22;
                          }   
                          break;
                                   
                       case      3:
                          // Add by Daniel Lin 
                          if (dwTempAddress > ((long)iMax&0xFFF0)) {
                             m_lStartAddress = (long)iMax-(m_nLines-3)*16;                       
                             m_lStartAddress &= 0xFFF0;
                             goto out22;
                          }
                          break;   
                  }                          
         
                  //ShowScrollBar(SB_VERT, TRUE);        // Add on 1996.4.12
                  
              EnableScrollBar( SB_VERT, ESB_DISABLE_BOTH );
              EnableScrollBar( SB_VERT, ESB_ENABLE_BOTH );
                          
                  SetScrollPos(SB_VERT,(UINT)(m_lStartAddress/0x10),TRUE);
                  if (m_bGridDrawn) m_bGridRedraw = FALSE;
                  else m_bGridRedraw = TRUE;
/*                  
                  if (gRedraw == 20) {
                     InvalidateRect(NULL, TRUE);            
                     RedrawWindow();
                     gRedraw =  0;
                  }
                  else
                     gRedraw ++;
*/                     
                     
                  out22:
                  break;
                  
              default:
                  break;
          }
      
          SetMyCaretPos();
      }          
      else
         ShowStatusGo();
         
      CMDIChildWnd::OnVScroll(nSBCode, nPos, pScrollBar);
    }
    
    //OnViewRefresh();
}

void CNewMemory::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
    // TODO: Add your message handler code here and/or call default
    int nInt1,nInt2;
    unsigned char uchCpuStatus;
    
    if ( GetCpuStatus(uchCpuStatus) ) {
      if ( 1 != uchCpuStatus ) {        // CPU not at GO
          GetScrollRange(SB_HORZ,&nInt1,&nInt2);
          switch (nSBCode) {
              case SB_LINEUP:
                  if (m_nPosX > 0) break;
                  if ((m_nPosX+m_gridMem.m_nGridWidth) > 0) {
                      ScrollWindowEx(-m_nPosX, 0, NULL,
                                     NULL, NULL, NULL, SW_INVALIDATE|SW_ERASE);
                      m_nPosX = 0;
                  }
                  else {
                      m_nPosX += m_gridMem.m_nGridWidth;
                      ScrollWindowEx(m_gridMem.m_nGridWidth, 0, NULL,
                                     NULL, NULL, NULL, SW_INVALIDATE|SW_ERASE);
                  }
                  break;
                  
              case SB_LINEDOWN:
                  if ((m_nPosX+nInt2) <= 0) break;
                  if ((m_nPosX+nInt2) < m_gridMem.m_nGridWidth) {
                      ScrollWindowEx(-(m_nPosX+nInt2), 0, NULL,
                                     NULL, NULL, NULL, SW_INVALIDATE|SW_ERASE);
                      m_nPosX = -nInt2;
                  }
                  else {
                      m_nPosX -= m_gridMem.m_nGridWidth;
                      ScrollWindowEx(-(m_gridMem.m_nGridWidth), 0, NULL,
                                     NULL, NULL, NULL, SW_INVALIDATE|SW_ERASE);
                  }
                  break;
                  
              case SB_PAGEUP:
                  if (m_nPosX > 0) break;
                  if ((m_nPosX+m_gridMem.m_nGridWidth) > 0) {
                      ScrollWindowEx(-m_nPosX, 0, NULL, NULL, NULL,
                                     NULL,SW_INVALIDATE|SW_ERASE);
                     m_nPosX = 0;
                  }
                  else {
                      m_nPosX += m_gridMem.m_nGridWidth;
                      ScrollWindowEx(m_gridMem.m_nGridWidth, 0,
                                     NULL, NULL, NULL, NULL, SW_INVALIDATE|SW_ERASE);
                  }
                  break;
                  
              case SB_PAGEDOWN:
                  if ((m_nPosX+nInt2) <= 0) break;
                  if ((m_nPosX+nInt2) < m_gridMem.m_nGridWidth) {
                      ScrollWindowEx(-(m_nPosX+nInt2), 0, NULL,
                                     NULL, NULL, NULL, SW_INVALIDATE|SW_ERASE);
                      m_nPosX = -nInt2;
                  }
                  else {
                      m_nPosX -= m_gridMem.m_nGridWidth;
                      ScrollWindowEx(-(m_gridMem.m_nGridWidth), 0,
                                     NULL, NULL, NULL, NULL, SW_INVALIDATE|SW_ERASE);
                  }
                  break;
                  
              case SB_THUMBTRACK:
                  m_nPosX = 0-nPos;
                  RedrawWindow();
                  break;
              
              case SB_THUMBPOSITION:
                  m_nPosX = 0-nPos;
                  InvalidateRect(NULL, TRUE);
                  RedrawWindow();
                  break;
               
              default:
                  break;
          }
      
          CMDIChildWnd::OnHScroll(nSBCode, nPos, pScrollBar);
      }          
      else {
         ShowStatusGo();
      }
   }      
}

void CNewMemory::OnSetFocus(CWnd* pOldWnd)
{
    CMDIChildWnd::OnSetFocus(pOldWnd);

    // TODO: Add your message handler code here
    m_bFocus = TRUE;
    m_bGridRedraw = TRUE;
    m_bGridDrawn = FALSE;
        CreateSolidCaret(2,m_gridMem.m_nGridHeight-4);
    if (!InWnd())
        GotoCursor();
    SetMyCaretPos();
}

void CNewMemory::OnLButtonDown(UINT nFlags, CPoint point)
{
    // TODO: Add your message handler code here and/or call default
    BOOL bOk;
    CRect rect;
    RECT rect2;
    int i,j;

    bOk = FALSE;

    if (m_nViewMode2!=4) {
        if (m_bShowAscii) {
            rect.left = m_gridAscii.m_rectPos.left;
            rect.right = m_gridAscii.m_rectPos.right;
            rect.top = m_gridAscii.m_rectPos.top+m_gridAscii.m_nGridHeight;
            rect.bottom = m_gridAscii.m_rectPos.bottom;
            bOk = rect.PtInRect(point);
            if (bOk) m_nCaretArea = 2;
            if (bOk) {
                i = point.x - m_gridAscii.m_rectPos.left;
                if (i>1) i--;
                m_nCaretPosX1 = 0;
                m_nCaretPosX2 = (i+m_nCharWidth/2-1) / m_nCharWidth;
                if (m_nCaretPosX2>15) m_nCaretPosX2 = 15;
                i = point.y - rect.top;
                m_nCaretPosY = i / m_gridAscii.m_nGridHeight + (UINT)(m_lStartAddress/0x10);;
            }
        }
        if (!bOk) {
            rect.left = m_gridMem.m_rectPos.left;
            rect.right = m_gridMem.m_rectPos.right;
            rect.top = m_gridMem.m_rectPos.top+m_gridMem.m_nGridHeight;
            rect.bottom = m_gridMem.m_rectPos.bottom;
            bOk = rect.PtInRect(point);
            if (bOk) m_nCaretArea = 1;
            if (bOk) {
                i = point.y - rect.top;
                m_nCaretPosY = i / m_gridMem.m_nGridHeight + (UINT)(m_lStartAddress/0x10);
                for(j=0;j<m_gridMem.m_nRows;j++) {
                    rect2 = m_gridMem.GetGridRect(j,(i/m_gridMem.m_nGridHeight+1));
                    rect.CopyRect(&rect2);
                    bOk = rect.PtInRect(point);
                    if (bOk) break;
                }

                i = point.x - rect.left;
                m_nCaretPosX1 = j;
                if (i>1) i--;
                m_nCaretPosX2 = (i+m_nCharWidth/2-1) / m_nCharWidth;
                switch (m_nViewMode2) {
                    case 1:
                        switch (m_nViewMode1) {
                            case 1:
                                if (m_nCaretPosX2>3) m_nCaretPosX2 = 3;
                                break;
                            case 2:
                                if (m_nCaretPosX2>5) m_nCaretPosX2 = 5;
                                break;
                            case 3:
                                if (m_nCaretPosX2>10) m_nCaretPosX2 = 10;
                                break;
                            default:
                                break;
                        }
                        break;
                    case 2:
                        switch (m_nViewMode1) {
                            case 1:
                                if (m_nCaretPosX2>2) m_nCaretPosX2 = 2;
                                break;
                            case 2:
                                if (m_nCaretPosX2>4) m_nCaretPosX2 = 4;
                                break;
                            case 3:
                                if (m_nCaretPosX2>9) m_nCaretPosX2 = 9;
                                break;
                            default:
                                break;
                        }
                        break;
                    case 3:
                        switch (m_nViewMode1) {
                            case 1:
                                if (m_nCaretPosX2>1) m_nCaretPosX2 = 1;
                                break;
                            case 2:
                                if (m_nCaretPosX2>3) m_nCaretPosX2 = 3;
                                break;
                            case 3:
                                if (m_nCaretPosX2>7) m_nCaretPosX2 = 7;
                                break;
                            default:
                                break;
                        }
                        break;
                    default:
                        break;
                }
            }
        }
    }
    if (bOk) {
        SetMyCaretPos();
    }

    CMDIChildWnd::OnLButtonDown(nFlags, point);
}

void CNewMemory::OnMouseMove(UINT nFlags, CPoint point)
{
    // TODO: Add your message handler code here and/or call default
    CRect rect1;
    BOOL bOk;

    bOk = FALSE;
    if (m_nViewMode2!=4) {
        rect1.left = m_gridMem.m_rectPos.left;
        rect1.right = m_gridMem.m_rectPos.right;
        rect1.top = m_gridMem.m_rectPos.top+m_gridMem.m_nGridHeight;
        rect1.bottom = m_gridMem.m_rectPos.bottom;
        if (m_bShowAscii) {
            rect1.right = m_gridAscii.m_rectPos.right;
            rect1.bottom = m_gridAscii.m_rectPos.bottom;
        }
        bOk = rect1.PtInRect(point);
    }
    if (bOk)
       SetCursor(::LoadCursor(NULL,IDC_IBEAM));
    else
       SetCursor(::LoadCursor(NULL,IDC_ARROW));

    CMDIChildWnd::OnMouseMove(nFlags, point);
}

void CNewMemory::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
    // TODO: Add your message handler code here and/or call default
    long l;
    BOOL Up_Flag = 1;
    BOOL Down_Flag = 1;
    long dwTempAddress2 = 0;
    unsigned char uchCpuStatus;
    
    if ( GetCpuStatus(uchCpuStatus) ) {
      if ( 1 != uchCpuStatus ) {        // CPU not at GO
       switch (nChar) {
          case VK_RIGHT:
               Right();
               if (!InWnd())
                  GotoCursor();
               break;
   
          case VK_LEFT:
               Left();
               if (!InWnd())
                  GotoCursor();
               break;
               
          case VK_UP:
               if (!InWnd())
                  GotoCursor();
               Up();
               break;
               
          case VK_DOWN:
               if (!InWnd())
                  GotoCursor();
               else   
                  Down();
               if (m_nViewMode2 ==4)
                  OnViewRefresh();
               break;
               
          case VK_PRIOR:
               if (!InWnd()) 
                  GotoCursor();
               l = m_lStartAddress;
               m_lStartAddress = m_lStartAddress - (m_nLines - 2 )*0x10;
               if (m_lStartAddress < 0) 
                  m_lStartAddress = 0;
               SetScrollPos(SB_VERT, (UINT)(m_lStartAddress/0x10), TRUE);
               m_bGridRedraw = FALSE;
               l = l-m_lStartAddress;
               m_nCaretPosY -= (UINT)(l>>4);
               InvalidateRect(NULL,FALSE);
               break;         
               
          case VK_NEXT:
               if (!InWnd())  
                  GotoCursor();
               l = m_lStartAddress;
               m_lStartAddress = m_lStartAddress + (m_nLines - 2)*0x10;
               dwTempAddress2 = m_lStartAddress+(m_nLines-3)*16;
               switch( m_nSpaceType ) {
                 case 1:
                    // Add by Daniel Lin 
                    if (dwTempAddress2 > ((long)pMax&0xFFF0)) {
                        m_lStartAddress = (long)pMax-(m_nLines-3)*16;
                        goto out; 
                    }    
                    break;    
                             
                 case 2:
                    // Add by Daniel Lin 
                    if (dwTempAddress2 > ((long)xMax&0xFFF0)) {
                       m_lStartAddress = (long)xMax-(m_nLines-3)*16;
                       goto out;
                    }   
                    break;   
                             
                 case 3:
                    // Add by Daniel Lin 
                    if (dwTempAddress2 > ((long)iMax&0xFFF0)) {
                       m_lStartAddress = (long)iMax-(m_nLines-3)*16;
                       goto out;                       
                    }   
                    break;   
               }                          
               
               out:
               SetScrollPos(SB_VERT,(UINT)(m_lStartAddress/0x10),TRUE);
               m_bGridRedraw = FALSE;
               l=m_lStartAddress-l;
               m_nCaretPosY+=(UINT)(l>>4);
               InvalidateRect(NULL,FALSE);
               break;
               
          case VK_HOME:
               if (!InWnd()) GotoCursor();
               Home();
               break;
               
          case VK_END:
               if (!InWnd()) GotoCursor();
               End();
               break;
               
          case VK_TAB:
               if (!InWnd()) GotoCursor();
               if (m_nKeyFlag==1) 
                  Tab2();
               else 
                  Tab();
               break;
               
          case VK_BACK:
               Back();
               break;
               
          case VK_SPACE:
               Space();
               break;
               
          case VK_SHIFT:
               m_nKeyFlag = 1;
               break;
               
          default:
               break;
       }
    }
    else
      ShowStatusGo();
  }  
  CMDIChildWnd::OnKeyDown(nChar, nRepCnt, nFlags);
}

void CNewMemory::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags)
{
    // TODO: Add your message handler code here and/or call default
    unsigned char uchCpuStatus;
    
    BeginWaitCursor();   
    if ( GetCpuStatus(uchCpuStatus) ) {
      if ( 1 != uchCpuStatus ) {        // CPU not at GO
       if (m_nViewMode2!=4) {
            if (nChar!=9) {
               if (InputCheck(nChar)) {
                   WriteMemory(nChar);
                   Right();
                   if (isMemOn[0]&&(m_nWndNo!=0)) {
                      if (m_nSpaceType==(((CNewMemory *)pMemWnd[0])->m_nSpaceType)){
                         ((CNewMemory *)pMemWnd[0])->m_bGridRedraw=FALSE;
                         pMemWnd[0]->InvalidateRect(NULL,FALSE);
                         pMemWnd[0]->UpdateWindow();
                      }
                   }
                   if (isMemOn[1]&&(m_nWndNo!=1)) {
                      if (m_nSpaceType==(((CNewMemory *)pMemWnd[1])->m_nSpaceType)){
                         ((CNewMemory *)pMemWnd[1])->m_bGridRedraw=FALSE;
                         pMemWnd[1]->InvalidateRect(NULL,FALSE);
                         pMemWnd[1]->UpdateWindow();
                      }
                   }
                   if (isMemOn[2]&&(m_nWndNo!=2)) {
                      if (m_nSpaceType==(((CNewMemory *)pMemWnd[2])->m_nSpaceType)) {
                         ((CNewMemory *)pMemWnd[2])->m_bGridRedraw=FALSE;
                         pMemWnd[2]->InvalidateRect(NULL,FALSE);
                         pMemWnd[2]->UpdateWindow();
                      }
                   }
                   if ((m_nSpaceType==3)&&(isBMemOn)) {
                      pBMemWnd->SendMessage(WM_COMMAND,ID_VIEW_REFRESH);
                   }
                   ::RepaintStack();
                   ::RepaintVariable();
                   // Added by Chen only for the stack window
                   SetFocus();
               }
            }   
       }
      }
      else
         ShowStatusGo();
    }
        
    CMDIChildWnd::OnChar(nChar, nRepCnt, nFlags);
    EndWaitCursor();
}

void CNewMemory::OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags)
{
    // TODO: Add your message handler code here and/or call default
    if (nChar==VK_SHIFT) m_nKeyFlag = 0;
    CMDIChildWnd::OnKeyUp(nChar, nRepCnt, nFlags);
}

void CNewMemory::OnGroupMemory()
{
    // TODO: Add your command handler code here
    BOOL focus;
    
    focus = m_bFocus;
    m_bFocus = FALSE;
    CMemDlg dlg(NULL);
    dlg.DoModal();
    if (focus) m_bFocus = TRUE;
    InvalidateRect(NULL, TRUE);
}

void CNewMemory::OnUpdateGroupMemory(CCmdUI* pCmdUI)
{
   // TODO: Add your command update UI handler code here
   unsigned char uchCpuStatus;
    
   if (GetCpuStatus(uchCpuStatus)) {
     if ( 1 == uchCpuStatus ) {       // Is on GO status (STATUS_GO)
        pCmdUI->Enable(FALSE);
     }
     else {
      pCmdUI->Enable(TRUE);
     }      
   }
}

void CNewMemory::OnMap()
{
    // TODO: Add your command handler code here
    // Open Map dialog.
    HINSTANCE hLib;
    if ( (hLib = LoadLibrary("MUSCROLL.DLL")) < HINSTANCE_ERROR ) {
        AfxMessageBox("MUSCROLL.DLL loading error.");
        // ::ErrGetErrorText(....);
        return;
    }
    
    CMapDlg dlg;
    dlg.DoModal();
    
    if ( hLib >= HINSTANCE_ERROR ) FreeLibrary(hLib);
}

void CNewMemory::OnUpdateMap(CCmdUI* pCmdUI)
{
   // TODO: Add your command update UI handler code here
   unsigned char uchCpuStatus;
    
   if (GetCpuStatus(uchCpuStatus)) {
     if ( 1 == uchCpuStatus ) {       // Is on GO status (STATUS_GO)
        pCmdUI->Enable(FALSE);
     }
     else {
      pCmdUI->Enable(TRUE);
     }      
   }
}

long CNewMemory::OnXMRepaint(UINT /*wParam*/,LONG /*lParam*/)
{
    m_bGridRedraw = FALSE;
    InvalidateRect(NULL,FALSE);
    return 0;
}                        

void CNewMemory::OnKillFocus(CWnd* pNewWnd)
{
    CMDIChildWnd::OnKillFocus(pNewWnd);

    // TODO: Add your message handler code here
    m_bFocus = FALSE;
    m_bGridDrawn = FALSE;
}

void CNewMemory::OnEditGoto()
{
    // TODO: Add your command handler code here
    if (IsIconic())
      ShowWindow( SW_RESTORE );
      //return;
      
    int i;
    BOOL focus;

    focus = m_bFocus;
    m_bFocus = FALSE;
    if (m_nViewMode2 != 4) {             // not assembly mode
            CMemGtDlg dlg(this);
            switch (m_nWndNo) {
              case 0:
                   dlg.m_nSpace = LastMem1Space;
                   dlg.m_lAddress = LastSet1Address;
                   break;
                   
              case 1:
                   dlg.m_nSpace = LastMem2Space;
                   dlg.m_lAddress = LastSet2Address;
                   break;
                   
              case 2:
                   dlg.m_nSpace = LastMem3Space;
                   dlg.m_lAddress = LastSet3Address;
                   break;
            }
            
            int nScrollMax = 0;
            i=dlg.DoModal();     // Do goto dialog
            if (i) {             // goto dialog return OK
                long dwTempAddress = 0;
                int nLines = 0, nretLines = 0;
                RECT rectWindow/*, rectClient*/;
                
                m_nSpaceType = dlg.m_nSpace;
                m_lStartAddress = dlg.m_lAddress & 0xFFFFFFF0;
                dwTempAddress = (m_lStartAddress+(m_nLines-2)*16);
                switch( m_nSpaceType ) {
                    case      1:                // Program area
                       // Add by Daniel Lin 
                       //
                       if (dwTempAddress >= ((long)pMax&0xFFF0)) {
                           m_lStartAddress = pMax-(m_nLines-7)*16;
                           m_lStartAddress &= 0xFFF0;
                           //m_nLines = 10;    // Add on 5.22.1996
                       }
                       
                       //
                       // Remarked by Daniel Lin on 1996.7.3.
                       // the same as follow
                       //
                       
                       
                       nLines = int((pMax - pMin) >> 4);
                       if ( nLines < (m_nLines-2)) {
                           //m_lStartAddress = (long)pMin & 0xFFF0;
                           //nretLines = m_nLines-nLines-2;
                           m_nLines = nLines;
                           
                           GetWindowRect(&rectWindow);
                           //rectWindow.bottom -= nretLines * m_gridAddr.m_nGridHeight;
                           rectWindow.bottom -= 1;
                           SetWindowPos(NULL, rectWindow.left,
                                        rectWindow.top, 
                                        rectWindow.right-rectWindow.left,
                                        rectWindow.bottom-rectWindow.top, 
                                        SWP_NOMOVE);
                       }
                       /*    
                       else {
                           GetWindowRect(&rectWindow);
                           rectWindow.bottom += 10 * m_gridAddr.m_nGridHeight;
                           SetWindowPos(NULL, rectWindow.left,
                                        rectWindow.top, 
                                        rectWindow.right-rectWindow.left,
                                        rectWindow.bottom-rectWindow.top, 
                                        SWP_NOMOVE);
                       }                                        
                       */
                       
                       nScrollMax = int(dwpMax >> 4);
                       SetScrollRange(SB_VERT, 0, nScrollMax, TRUE);
                       break;
                       
                    case      2:                // Data area
                       // Add by Daniel Lin 
                       //
                       if (dwTempAddress > ((long)xMax&0xFFF0)) {
                           m_lStartAddress = xMax-(m_nLines-7)*16;
                           m_lStartAddress &= 0xFFF0;
                       }
                       
                       nLines = int((xMax - xMin) >> 4);
                       if ( nLines < (m_nLines-1)) {
                           //m_lStartAddress = (long)xMin & 0xFFF0;
                           //nretLines = m_nLines-nLines-2;
                           m_nLines = nLines;
                           
                           GetWindowRect(&rectWindow);
                           //GetClientRect(&rectClient);
                           //rectWindow.bottom = nretLines * m_gridAddr.m_nGridHeight;
                           rectWindow.bottom -= 1;
                           SetWindowPos(NULL, rectWindow.left,
                                        rectWindow.top, 
                                        rectWindow.right-rectWindow.left,
                                        rectWindow.bottom-rectWindow.top, 
                                        SWP_NOMOVE);
                       }    
                       /*
                       else {
                           GetWindowRect(&rectWindow);
                           rectWindow.bottom += 10 * m_gridAddr.m_nGridHeight;
                           SetWindowPos(NULL, rectWindow.left,
                                        rectWindow.top, 
                                        rectWindow.right-rectWindow.left,
                                        rectWindow.bottom-rectWindow.top, 
                                        SWP_NOMOVE);
                       }                                        
                       */
                       nScrollMax = int(dwxMax >> 4);
                       SetScrollRange(SB_VERT, 0, nScrollMax, TRUE);
                       break;
                       
                    case      3:                // On chip area
                       // Add by Daniel Lin 
                       //
                       if (dwTempAddress > ((long)iMax&0xFFF0)) {
                           m_lStartAddress = iMax-(m_nLines-7)*16;
                           m_lStartAddress &= 0xFFF0;
                       }
                       
                       nLines = int((iMax - iMin) >> 4);
                       if ( nLines < (m_nLines-1)) {
                           //m_lStartAddress = (long)iMin & 0xFFF0;
                           //nretLines = m_nLines-nLines-2;
                           m_nLines = nLines;
                           
                           GetWindowRect(&rectWindow);
                           //GetClientRect(&rectClient);
                           //rectWindow.bottom = nretLines * m_gridAddr.m_nGridHeight;
                           rectWindow.bottom -= 1;
                           SetWindowPos(NULL, rectWindow.left,
                                        rectWindow.top, 
                                        rectWindow.right-rectWindow.left,
                                        rectWindow.bottom-rectWindow.top, 
                                        SWP_NOMOVE);
                                       
                       }    
                       /*
                       else {
                           GetWindowRect(&rectWindow);
                           rectWindow.bottom += 10 * m_gridAddr.m_nGridHeight;
                           SetWindowPos(NULL, rectWindow.left,
                                        rectWindow.top, 
                                        rectWindow.right-rectWindow.left,
                                        rectWindow.bottom-rectWindow.top, 
                                        SWP_NOMOVE);
                       }                                        
                       */
                       
                       nScrollMax = int(dwiMax >> 4);
                       SetScrollRange(SB_VERT, 0, nScrollMax, TRUE);
                       break;
                }                          
                
                switch (m_nWndNo) {
                  case 0:
                       LastMem1Address = m_lStartAddress;
                       LastMem1Space   = m_nSpaceType;
                       LastSet1Address = dlg.m_lAddress;
                       break;
                       
                  case 1:
                       LastMem2Address = m_lStartAddress;
                       LastMem2Space   = m_nSpaceType;
                       LastSet2Address = dlg.m_lAddress;
                       break;
                       
                  case 2:
                       LastMem3Address = m_lStartAddress;
                       LastMem3Space   = m_nSpaceType;
                       LastSet3Address = dlg.m_lAddress;
                       break;
                }

                i = (int)(dlg.m_lAddress&0x0000000F);
                SetWindowTitle();
                m_nCaretPosY = (unsigned short)(dlg.m_lAddress/*m_lStartAddress*/>>4);
                switch(m_nViewMode1) {
                    case 1:
                        m_nCaretPosX1=i;
                        m_nCaretPosX2=0;
                        break;
                        
                    case 2:
                        m_nCaretPosX1=i/2;
                        m_nCaretPosX2=0;
                        break;
                        
                    case 3:
                        m_nCaretPosX1=i/4;
                        m_nCaretPosX2=0;
                        break;
                        
                    default:
                        break;
                }

                InvalidateRect(NULL,TRUE);                         
                SetScrollPos(SB_VERT,
                             (unsigned short)(m_lStartAddress/0x10),
                             TRUE);
            }    
        }
        else {          // Assembly mode
            CDsmGtDlg dlg(this);

            dlg.m_nSpace = m_nSpaceType;
            dlg.m_lAddress = m_lStartAddress;
            i=dlg.DoModal();
            if (i) {
                m_nSpaceType = dlg.m_nSpace;
                m_lStartAddress = dlg.m_lAddress;
                SetWindowTitle();
                InvalidateRect(NULL,TRUE);
                SetScrollPos(SB_VERT,(UINT)(m_lStartAddress/0x10),TRUE);
                m_nCaretPosY = (unsigned short)(m_lStartAddress>>4);
            }
            switch (m_nWndNo) {
              case 0:
                   LastMem1Space   = m_nSpaceType;
                   break;
                   
              case 1:
                   LastMem2Space   = m_nSpaceType;
                   break;
                   
              case 2:
                   LastMem3Space   = m_nSpaceType;
                   break;
                   
              default:
                   break;     
            }
        }
        
        if (focus) m_bFocus = TRUE;
}                                                             

void CNewMemory::OnUpdateEditGoto(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    //pCmdUI->Enable(TRUE);
    unsigned char uchCpuStatus;
    if (IsIconic())
       pCmdUI->Enable(FALSE);
    else
       pCmdUI->Enable(TRUE);
        
    if (GetCpuStatus(uchCpuStatus)) {
      if ( 1 == uchCpuStatus ) {       // Is on GO status (STATUS_GO)
        pCmdUI->Enable(FALSE);
      }
      else {
        pCmdUI->Enable(TRUE);
      }      
    }
}

void CNewMemory::OnMDIActivate(BOOL bActivate, CWnd* pActivateWnd,
                               CWnd* pDeactivateWnd)
{
    CMDIChildWnd::OnMDIActivate(bActivate, pActivateWnd, pDeactivateWnd);

    // TODO: Add your message handler code here
    if(bActivate && pActivateWnd == this) {
        /*AfxGetApp()->m_pMainWnd*/
        GetMDIFrame()->SendMessage(XM_MDIACTIVE, WORD(bActivate),
            LONG(WID_MEMORY));
        //GotoCursor();
    }
    else if(!bActivate && !pActivateWnd)
        /*AfxGetApp()->m_pMainWnd*/
        GetMDIFrame()->SendMessage(XM_MDIACTIVE, WORD(bActivate));
    m_bFocus = bActivate;
    m_bGridDrawn = FALSE;

    if (bActivate) {
       CreateSolidCaret(2,m_gridMem.m_nGridHeight-4);
    }
    SetMyCaretPos();    // Add it by Daniel Lin
}

void CNewMemory::OnLButtonDblClk(UINT nFlags, CPoint point)
{
        // TODO: Add your message handler code here and/or call default
        long address;
        long address2;
        int i;
        CRect rect1;
        CRect rect2;

        if (m_nViewMode2==4) {
                m_gridMem.DoRect();
                m_gridInstruction.DoRect();

                rect1.left = m_gridMem.m_rectPos.left;
                rect1.top = m_gridMem.m_rectPos.top+m_gridMem.m_nGridHeight;
                rect1.right = m_gridMem.m_rectPos.right;
                rect1.bottom = m_gridMem.m_rectPos.bottom;

                rect2.left = m_gridInstruction.m_rectPos.left;
                rect2.top = m_gridInstruction.m_rectPos.top+m_gridInstruction.m_nGridHeight;
                rect2.right = m_gridInstruction.m_rectPos.right;
                rect2.bottom = m_gridInstruction.m_rectPos.bottom;

                if (rect1.PtInRect(point)) {
                        for(i=1;i<m_nLines;i++) {
                                rect1 = m_gridMem.GetGridRect(0,i);
                                if (rect1.PtInRect(point)) {
                                        address = (unsigned short)m_dsm[i-1].address;
                                        break;
                                }
                        }
                        CDsmEdit1 dlg(this);
                        dlg.m_lAddress = address;
                        dlg.m_nSpaceType = m_nSpaceType;
                        address2 = m_lStartAddress;
                        dlg.DoModal();
                        m_lStartAddress = address2;
                        InvalidateRect(NULL,FALSE);
                        ::RepaintMemory();
                }
                else if (rect2.PtInRect(point)) {
                        for(i=1;i<m_nLines;i++) {
                                rect1 = m_gridInstruction.GetGridRect(0,i);
                                if (rect1.PtInRect(point)) {
                                        address = (unsigned short)m_dsm[i-1].address;
                                        break;
                                }
                        }
                        CDsmEdit2 dlg(this);
                        dlg.m_lAddress = address;
                        dlg.m_nSpaceType = m_nSpaceType;
                        address2 = m_lStartAddress;
                        dlg.DoModal();
                        m_lStartAddress = address2;
                        InvalidateRect(NULL,FALSE);
                        ::RepaintMemory();
                }
        }

        CMDIChildWnd::OnLButtonDblClk(nFlags, point);
}

void CNewMemory::OnViewRefresh()
{
     // TODO: Add your command handler code here
/*     
    RECT rect1, rect2;
    int temp = 0;
    
    GetClientRect(&rect1);
    rect1.left += 35;
    rect2 = rect1;
*/
    InvalidateRect(/*&rect2*/NULL, TRUE);
    //UpdateWindow();
}

void CNewMemory::OnUpdateViewRefresh(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    unsigned char uchCpuStatus;
    
    if (GetCpuStatus(uchCpuStatus)) {
      if ( 1 == uchCpuStatus ) {       // Is on GO status (STATUS_GO)
         pCmdUI->Enable(FALSE);
      }
      else {
       pCmdUI->Enable(TRUE);
      }      
    }
}

void CNewMemory::OnEditSearch()
{
    // TODO: Add your command handler code here
    CMemSearchDlg dlg(this);
    int i;

    dlg.m_nSpaceType = m_nSpaceType;
    dlg.m_StartAddress = (unsigned short)m_lStartAddress;
    dlg.m_StartAddress += (unsigned short)(m_nCaretPosY-m_lStartAddress/16)*16;
    if (m_nCaretArea==1) {
      switch(m_nViewMode1) {
        case 1:
            dlg.m_StartAddress += (unsigned short)m_nCaretPosX1;
            break;
            
        case 2:
            dlg.m_StartAddress += (unsigned short)m_nCaretPosX1*2;
            break;
            
        case 3:
            dlg.m_StartAddress += (unsigned short)m_nCaretPosX1*4;
            break;
            
        default:
            break;
      }
    }  
    if (m_nCaretArea==2) {
        dlg.m_StartAddress += (unsigned short)m_nCaretPosX2;
    }
    strcpy(dlg.m_str, m_searchStr);
    i = dlg.DoModal();
    if (i) {
        strcpy(m_searchStr, dlg.m_str);
        if (dlg.m_lFindAddress == -1) {
           MessageBox("Not Found!",NULL, MB_OK);
           return;
        }
        m_lStartAddress = (dlg.m_lFindAddress&0xFFFFFFF0);
        LONG   dwTempAddress = 0;
        dwTempAddress = (m_lStartAddress+(m_nLines-4)*16);
        switch( m_nSpaceType ) {
           case      1:
              // Add by Daniel Lin 
              if (dwTempAddress >= ((long)pMax&0xFFF0)) {
                  m_lStartAddress = pMax-(m_nLines-3)*16;
                  m_lStartAddress &= 0xFFF0;
              }
              break;
                       
           case      2:
              // Add by Daniel Lin 
              if (dwTempAddress > ((long)xMax&0xFFF0)) {
                  m_lStartAddress = xMax-(m_nLines-3)*16;
                  m_lStartAddress &= 0xFFF0;
              }
              break;
                       
           case      3:
              // Add by Daniel Lin 
              if (dwTempAddress > ((long)iMax&0xFFF0)) {
                  m_lStartAddress = iMax-(m_nLines-3)*16;
                  m_lStartAddress &= 0xFFF0;
              }
              break;
        }                          
        
        i = (int)(dlg.m_lFindAddress&0x0000000F);
        m_nCaretPosY = (UINT)(dlg.m_lFindAddress>>4);
        if (m_nCaretArea==1) {
          switch(m_nViewMode1) {
            case 1:
                m_nCaretPosX1=i;
                m_nCaretPosX2=0;
                break;
                
            case 2:
                m_nCaretPosX1=i/2;
                m_nCaretPosX2=0;
                break;
                
            case 3:
                m_nCaretPosX1=i/4;
                m_nCaretPosX2=0;
                break;
                
            default:
                break;
          }
        }  
        if (m_nCaretArea==2) {
           m_nCaretPosX2 = i;
        }
        InvalidateRect(NULL,TRUE);
        SetScrollPos(SB_VERT,(UINT)(m_lStartAddress/0x10),TRUE);
    }
}

void CNewMemory::OnUpdateEditSearch(CCmdUI* pCmdUI)
{
     // TODO: Add your command update UI handler code here
     unsigned char uchCpuStatus;
     
     if (m_nViewMode2!=4)  {
       if (GetCpuStatus(uchCpuStatus)) {
         if ( 1 == uchCpuStatus ) {       // Is on GO status (STATUS_GO)
            pCmdUI->Enable(FALSE);
         }
         else {
          pCmdUI->Enable(TRUE);
         }      
       }
     }     
     else 
       pCmdUI->Enable(FALSE);
}

void CNewMemory::OnEditSearchnext()
{
        // TODO: Add your command handler code here
    int i;
    unsigned short startAddress;
    unsigned short addr;
    long FindAddress;
    BOOL bFind;
    char *text;

    text = new char [200];
    ASSERT(NULL != text);
    i = strlen(m_searchStr);
    if (i<=0) {
       OnEditSearch();
    }
    else {
         BeginWaitCursor();
         startAddress = (unsigned short)m_lStartAddress;
         startAddress += (unsigned short)(m_nCaretPosY-m_lStartAddress/16)*16;
         if (m_nCaretArea==1)
         switch(m_nViewMode1) {
             case 1:
                 startAddress += (unsigned short)(m_nCaretPosX1+1);
                 break;
             case 2:
                 startAddress += (unsigned short)(m_nCaretPosX1*2+2);
                 break;
             case 3:
                 startAddress += (unsigned short)(m_nCaretPosX1*4+4);
                 break;
             default:
                 break;
         }
         if (m_nCaretArea==2) {
             startAddress += (unsigned short)(m_nCaretPosX2+1);
         }

         strcpy(text, m_searchStr+2);
         bFind = MemServerSearch(startAddress,(unsigned short)0xFFFF,
                                 m_nSpaceType,text,0,addr);
         EndWaitCursor();
         if (!bFind) {
             MessageBox("Not Found!",NULL, MB_OK);
             return;
         }
         else {
             FindAddress = (long)addr;
             m_lStartAddress = (unsigned short)(FindAddress&(long)0xFFFFFFF0);
             LONG   dwTempAddress = 0;
             dwTempAddress = (m_lStartAddress+(m_nLines-2)*16);
             switch( m_nSpaceType ) {
               case      1:
                 // Add by Daniel Lin 
                 if (dwTempAddress >= ((long)pMax&0xFFF0)) {
                     m_lStartAddress = pMax-(m_nLines-3)*16;
                     m_lStartAddress &= 0xFFF0;
                 }
                 break;
                          
               case      2:
                 // Add by Daniel Lin 
                 if (dwTempAddress > ((long)xMax&0xFFF0)) {
                     m_lStartAddress = xMax-(m_nLines-3)*16;
                     m_lStartAddress &= 0xFFF0;
                 }
                 break;
                          
               case      3:
                 // Add by Daniel Lin 
                 if (dwTempAddress > ((long)iMax&0xFFF0)) {
                     m_lStartAddress = iMax-(m_nLines-3)*16;
                     m_lStartAddress &= 0xFFF0;
                 }
                 break;
             }                          
             
             i = (int)(FindAddress&(long)0x0000000F);
             m_nCaretPosY = (UINT)(/*m_lStartAddress*/FindAddress>>4);
             if (m_nCaretArea==1)
             switch(m_nViewMode1) {
                 case 1:
                     m_nCaretPosX1=i;
                     m_nCaretPosX2=0;
                     break;
                     
                 case 2:
                     m_nCaretPosX1=i/2;
                     m_nCaretPosX2=0;
                     break;
                     
                 case 3:
                     m_nCaretPosX1=i/4;
                     m_nCaretPosX2=0;
                     break;
                     
                 default:
                     break;
             }
             if (m_nCaretArea==2) {
                     m_nCaretPosX2 = i;
             }
             m_bGridRedraw=FALSE;
             InvalidateRect(NULL, FALSE);
             SetScrollPos(SB_VERT, (UINT)(m_lStartAddress/0x10), TRUE);
        }
    }
    
    delete []text;
}

void CNewMemory::OnUpdateEditSearchnext(CCmdUI* pCmdUI)
{
  // TODO: Add your command update UI handler code here
  unsigned char uchCpuStatus;
  
  if (m_nViewMode2!=4) {
    if (GetCpuStatus(uchCpuStatus)) {
      if ( 1 == uchCpuStatus ) {       // Is on GO status (STATUS_GO)
         pCmdUI->Enable(FALSE);
      }
      else {
       pCmdUI->Enable(TRUE);
      }      
    }
  }  
  else pCmdUI->Enable(FALSE);
}

void CNewMemory::OnStkTab()
{
    // TODO: Add your command handler code here
    if (!InWnd()) GotoCursor();
    if (m_nKeyFlag==1) Tab2();
    else Tab();
}

void CNewMemory::OnShiftreturn()
{
    // TODO: Add your command handler code here
    CMenu * pLocalMenu = new CMenu;

    ASSERT(pLocalMenu!=NULL);

    pLocalMenu->CreatePopupMenu();
    pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_REFRESH, "&Refresh");
    pLocalMenu->AppendMenu(MF_SEPARATOR);

    pLocalMenu->AppendMenu(MF_STRING, ID_GROUP_MEMORY, "&Memory...");
    pLocalMenu->AppendMenu(MF_STRING, ID_MAP, "Ma&p...");
    pLocalMenu->AppendMenu(MF_STRING, ID_EDIT_GOTO, "&Goto...");
    pLocalMenu->AppendMenu(MF_SEPARATOR);

    pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_ASCII, "Show &ASCII");
    pLocalMenu->AppendMenu(MF_SEPARATOR);

    pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_HEXADECIMAL, "&Hexadecimal");
    pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_SIGNEDDECIMAL, "&Signed Decimal");
    pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_UNSIGNEDDECIMAL, "&Unsigned Decimal");
    pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_DISASSEMBLE, "&Disassemble");
    pLocalMenu->AppendMenu(MF_SEPARATOR);

    pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_BYTE, "&Byte");
    pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_WORD, "&Word");
    pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_LONG, "&Long");
    
    CPoint point(20, 20);
    ClientToScreen(&point);
    pLocalMenu->TrackPopupMenu(TPM_LEFTALIGN, point.x, point.y, this);
              
    delete pLocalMenu;
}

void CNewMemory::OnGetMinMaxInfo(MINMAXINFO FAR* lpMMI)
{
   // TODO: Add your message handler code here and/or call default
/*   
   unsigned char uchCpuStatus;
   
   if (GetCpuStatus(uchCpuStatus)) {
     if ( 1 == uchCpuStatus ) {       // Is on GO status (STATUS_GO)
      lpMMI->ptMaxSize.x = 15;
      lpMMI->ptMaxSize.y = 15;
      lpMMI->ptMaxTrackSize.x = 15;   
      lpMMI->ptMaxTrackSize.y = 15;   
      return;      
     }
   }     
*/   
         
   CMDIChildWnd::OnGetMinMaxInfo(lpMMI);
}

void CNewMemory::OnSysCommand(UINT nID, LPARAM lParam)
{
   // TODO: Add your message handler code here and/or call default
   unsigned char uchCpuStatus;
   
   if (GetCpuStatus(uchCpuStatus)) {
     if ( 1 == uchCpuStatus ) {       // Is on GO status (STATUS_GO)
      if ( SC_ZOOM == nID ) {
         ShowStatusGo();
         return;          // Zoomed
      }         
      if ( SC_MAXIMIZE == nID ) {
         ShowStatusGo();
         return;      // Zoomed
      }         
      if ( SC_RESTORE == nID ) {
         ShowStatusGo();
         return;       // Restore
      }         
      if ( SC_SIZE == nID ) {
         ShowStatusGo();
         return;       // Restore
      }         
      //if ( SC_MOVE == nID ) return;       // Restore      
     }
   }        
      
   CMDIChildWnd::OnSysCommand(nID, lParam);
}

void   
CNewMemory::ShowStatusGo()
{
   CString str = "Running. Halt CPU first.";
   ((CMainFrame*)((CXviewApp *)AfxGetApp()->m_pMainWnd))->m_wndStatusBar.UpdateStatusBar(0, str);
   //MessageBeep( -1 );
}

BEGIN_MESSAGE_MAP(CNewMemory, CMDIChildWnd)
    //{{AFX_MSG_MAP(CNewMemory)
    ON_WM_CREATE()
    ON_WM_PAINT()
    ON_WM_RBUTTONDOWN()
    ON_WM_SETCURSOR()
    ON_COMMAND(ID_VIEW_BYTE, OnViewByte)
    ON_UPDATE_COMMAND_UI(ID_VIEW_BYTE, OnUpdateViewByte)
    ON_COMMAND(ID_VIEW_WORD, OnViewWord)
    ON_UPDATE_COMMAND_UI(ID_VIEW_WORD, OnUpdateViewWord)
    ON_COMMAND(ID_VIEW_LONG, OnViewLong)
    ON_UPDATE_COMMAND_UI(ID_VIEW_LONG, OnUpdateViewLong)
    ON_COMMAND(ID_VIEW_FLOAT, OnViewFloat)
    ON_UPDATE_COMMAND_UI(ID_VIEW_FLOAT, OnUpdateViewFloat)
    ON_COMMAND(ID_VIEW_DOUBLE, OnViewDouble)
    ON_UPDATE_COMMAND_UI(ID_VIEW_DOUBLE, OnUpdateViewDouble)
    ON_COMMAND(ID_VIEW_SIGNEDDECIMAL, OnViewSigneddecimal)
    ON_UPDATE_COMMAND_UI(ID_VIEW_SIGNEDDECIMAL, OnUpdateViewSigneddecimal)
    ON_COMMAND(ID_VIEW_HEXADECIMAL, OnViewHexadecimal)
    ON_UPDATE_COMMAND_UI(ID_VIEW_HEXADECIMAL, OnUpdateViewHexadecimal)
    ON_COMMAND(ID_VIEW_DISASSEMBLE, OnViewDisassemble)
    ON_UPDATE_COMMAND_UI(ID_VIEW_DISASSEMBLE, OnUpdateViewDisassemble)
    ON_COMMAND(ID_VIEW_ASCII, OnViewAscii)
    ON_UPDATE_COMMAND_UI(ID_VIEW_ASCII, OnUpdateViewAscii)
    ON_COMMAND(ID_VIEW_UNSIGNEDDECIMAL, OnViewUnsigneddecimal)
    ON_UPDATE_COMMAND_UI(ID_VIEW_UNSIGNEDDECIMAL, OnUpdateViewUnsigneddecimal)
    ON_WM_SIZE()
    ON_WM_VSCROLL()
    ON_WM_HSCROLL()
    ON_WM_SETFOCUS()
    ON_WM_LBUTTONDOWN()
    ON_WM_MOUSEMOVE()
    ON_WM_KEYDOWN()
    ON_WM_CHAR()
    ON_WM_KEYUP()
    ON_MESSAGE(XM_REPAINT,OnXMRepaint)
    ON_WM_KILLFOCUS()
    ON_COMMAND(ID_EDIT_GOTO, OnEditGoto)
    ON_UPDATE_COMMAND_UI(ID_EDIT_GOTO, OnUpdateEditGoto)
    ON_WM_MDIACTIVATE()
    ON_WM_LBUTTONDBLCLK()
    ON_COMMAND(ID_VIEW_REFRESH, OnViewRefresh)
    ON_UPDATE_COMMAND_UI(ID_VIEW_REFRESH, OnUpdateViewRefresh)
    ON_COMMAND(ID_EDIT_SEARCH, OnEditSearch)
    ON_UPDATE_COMMAND_UI(ID_EDIT_SEARCH, OnUpdateEditSearch)
    ON_COMMAND(ID_EDIT_SEARCHNEXT, OnEditSearchnext)
    ON_UPDATE_COMMAND_UI(ID_EDIT_SEARCHNEXT, OnUpdateEditSearchnext)
    ON_COMMAND(ID_STK_TAB, OnStkTab)
    ON_COMMAND(ID_SHIFTRETURN, OnShiftreturn)
    ON_COMMAND(ID_GROUP_MEMORY, OnGroupMemory)
    ON_COMMAND(ID_MAP, OnMap)
    ON_UPDATE_COMMAND_UI(ID_MAP, OnUpdateMap)    
    ON_UPDATE_COMMAND_UI(ID_GROUP_MEMORY, OnUpdateGroupMemory)
    ON_WM_GETMINMAXINFO()
    ON_WM_SYSCOMMAND()
   ON_WM_NCCALCSIZE()
   ON_WM_NCHITTEST()
   ON_WM_CLOSE()
   //}}AFX_MSG_MAP
END_MESSAGE_MAP()


void CNewMemory::OnNcCalcSize(BOOL bCalcValidRects, NCCALCSIZE_PARAMS FAR* lpncsp)
{
   // TODO: Add your message handler code here and/or call default
/*   
   unsigned char uchCpuStatus;
   
   if (GetCpuStatus(uchCpuStatus)) {
      if ( 1 != uchCpuStatus ) {       // Is on GO status (STATUS_GO)
         CMDIChildWnd::OnNcCalcSize(bCalcValidRects, lpncsp);
      }
      else
         return;
   }          
*/   
   CMDIChildWnd::OnNcCalcSize(bCalcValidRects, lpncsp);   
}



UINT CNewMemory::OnNcHitTest(CPoint point)
{
   // TODO: Add your message handler code here and/or call default
   unsigned char uchCpuStatus;
   UINT nHitTest = 0;
   nHitTest = CMDIChildWnd::OnNcHitTest(point);          
   
   if (GetCpuStatus(uchCpuStatus)) {
      if ( 1 != uchCpuStatus ) {       // Is not on GO status (STATUS_GO)
         return nHitTest; /*CMDIChildWnd::OnNcHitTest(point);*/
      }
      else {            // On GO
         //if ( SrcEmu.m_isRunAccess ) {       // GO and Run Access
         //   return CMDIChildWnd::OnNcHitTest(point);
         //}
         //else {         // Go and Run access off
         switch ( nHitTest ) {
               /*
            case HTBORDER     :
            case HTBOTTOM       :
            case HTBOTTOMLEFT   : 
            case HTBOTTOMRIGHT  :  
            case HTHSCROLL      :
            case HTLEFT         :
            case HTRIGHT        :
            case HTTOP          :
            case HTTOPLEFT      :
            case HTTOPRIGHT     :
            case HTVSCROLL      :
                ShowStatusGo();
                return HTERROR;
            */                      
            case HTZOOM         :
            case HTSYSMENU      :            
            case HTCAPTION      :
            //case HTCLIENT       :
            case HTMINBUTTON    :            
                return nHitTest;
                
            default:
                ShowStatusGo();
                 return HTERROR;   
                   
         }
         //}   
      }         
   }
   else
      return HTERROR;
}

void CNewMemory::OnClose()
{
   // TODO: Add your message handler code here and/or call default
   switch(m_nWndNo) {
      case  0:
            LastMem1Address = m_lStartAddress;
            LastMem1Space = m_nSpaceType;
            break;
            
      case  1:
            LastMem2Address = m_lStartAddress;
            LastMem2Space = m_nSpaceType;
            break;
            
      case  2:      
            LastMem3Address = m_lStartAddress;
            LastMem3Space = m_nSpaceType;
            break;
   }
   
   CMDIChildWnd::OnClose();
}


BOOL
ReadMemWndIni()
{
    CString defaultini = "1 0 1 0 1 0";        
    int mem1area, mem2area, mem3area, mem1addr, mem2addr, mem3addr;

    CString strBuffer = AfxGetApp()->
        GetProfileString("MemWindow", "MemWindow", defaultini); 
           
    int nRval = sscanf(strBuffer, "%d %d %d %d %d %d", 
                       &mem1area, &mem1addr, 
                       &mem2area, &mem2addr,
                       &mem3area, &mem3addr);
    if(nRval != 6)  return FALSE;
    
    LastMem1Address = (long)mem1addr;
    LastMem2Address = (long)mem2addr;
    LastMem3Address = (long)mem3addr;

    LastMem1Space = (unsigned char)mem1area;
    LastMem2Space = (unsigned char)mem2area;
    LastMem3Space = (unsigned char)mem3area;
    
    return TRUE;
}

BOOL
WriteMemWndIni()
{
    char szBuffer[100];
    int mem1area, mem2area, mem3area, mem1addr, mem2addr, mem3addr;
    
    mem1addr = (int)LastMem1Address;
    mem2addr = (int)LastMem2Address;
    mem3addr = (int)LastMem3Address;

    mem1area = LastMem1Space;
    mem2area = LastMem2Space;
    mem3area = LastMem3Space;

    int nRval = sprintf(szBuffer, "%d %d %d %d %d %d", 
                        mem1area, mem1addr, 
                        mem2area, mem2addr,
                        mem3area, mem3addr);
    if(nRval == -1) return FALSE;                 
    
    AfxGetApp()->WriteProfileString("MemWindow", "MemWindow", szBuffer);
    
    return TRUE;
}


/////////////////////(EOF of NWMEM.CPP)/////////////////////////////


