/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/PROJMGR.H__   1.6   20 Jun 1996 09:30:26   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/PROJMGR.H__  $
** 
**    Rev 1.6   20 Jun 1996 09:30:26   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.4   10 Jun 1996 10:25:04   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.2   29 May 1996 09:37:48   ZJRD
** EasyPack/SLD Version 1.95
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
// projmgr.h
//
// Roger Zhang
//
// 4/30/96
/////////////////////////////////////////////////////////////////////////////
#ifndef _PROJMGR_
#define _PROJMGR_

class CProjectManager
{
// constructor/destructor
public:
    CProjectManager();
    ~CProjectManager();     
    
// attribute
public:
    enum { BSO, IAR, AD2500, OMF51 };
    int     m_nCompilerType;    
    CStringList m_FileList;
    CString m_strProjName;
    CString m_strFileName;
    BOOL    m_fValid;
    BOOL    m_fEditorValid;
    
// implementation
public:
    FILE    * m_fp; 
    CProjectOption  * m_pOption;        
                           
    BOOL SaveCompilerType(void);
    BOOL LoadCompilerType(void);                           
    BOOL SaveFileList(void);
    BOOL LoadFileList(void);
    BOOL SaveOption(void);
    BOOL LoadOption(void);
    BOOL SaveProject(void);
    BOOL LoadProject(void); 
    void NewOption(void);      
    
// operation
public:     
    BOOL NewProject(CWnd *pParent);
    BOOL EditProject(CWnd *pParent);
    BOOL OpenProject(CWnd *pParent);
    BOOL CloseProject(void);
    void SetOption(CWnd *pParent);
    void Build(void);
    void Editor(void);
};

#endif // _PROJMGR_
///////////////////////////////(EOF)/////////////////////////////////////////
