
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/SHLBUF.H__   1.8   20 Jun 1996 09:25:20   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/SHLBUF.H__  $
** 
**    Rev 1.8   20 Jun 1996 09:25:20   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.6   10 Jun 1996 10:19:58   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.4   29 May 1996 09:29:20   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:06:36   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:11:06   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:28:44   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 12:57:50   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:41:30   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:56:30   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:07:48   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:36:00   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:50:16   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:14:44   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:18:08   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:18:04   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:33:50   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:28:24   Shirley
** EasypPack/SLD Version 0.34c
** 
**    Rev 1.19   18 Jan 1996 10:08:56   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:11:56   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:14:26   Shirley
** EasyPack/SLD Version 0.34
** 
**    Rev 1.16   30 Nov 1995 09:09:38   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:30:30   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:20:08   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:22:50   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:33:22   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:29:52   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:44:00   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:04:54   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:47:50   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:45:52   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:27:26   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:51:34   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:24:24   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:48:18   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:53:04   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:48:44   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:53:56   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  SHLBUF.H
//
//  Description:The header file for the class: ShellBuffer
//
//  Author:     Roger Zhang
//
//  Date:       03/22/95
//
//  Modification:
//
//      1. 03/22/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#ifndef _SHLBUF_
#define _SHLBUF_

/////////////////////////////////////////////////////////////////////////////    
const int  MAX_SHELL_LINES = 1000;//4096;  // lines of shell

/////////////////////////////////////////////////////////////////////////////
//  Line of the shell buffer
/////////////////////////////////////////////////////////////////////////////
class ShellBufLine
{
// attributes
public:
    int m_nLength;
    char * m_pchLine;   //  Not end with '\0'    
    BOOL m_isOK;

// constructor/destructor    
public:
    ShellBufLine();       
    ShellBufLine(char * pch, int nLen);
    ~ShellBufLine();
                         
// operations                         
public:
    void Shrink(void);
    int operator ! () const { return !m_isOK; }
};

/////////////////////////////////////////////////////////////////////////////
//  Shell Buffer
/////////////////////////////////////////////////////////////////////////////    
class ShellBuffer
{
// attributes
public:
    ShellBufLine * m_LinePtr[MAX_SHELL_LINES];
    int m_nLines;             
    BOOL m_isOK;

// constructor/destructor    
public:
    ShellBuffer();
    ~ShellBuffer();                       
                                     
// operations                         
public:
    BOOL AddLine(char * pch, int nLen);
    BOOL AddDispLine(char * pch, int nLen, BOOL isWS = TRUE);
    BOOL OvrDispLine(char * pch, int nLen);
    BOOL AddInputLine(void);
    void Shrink(void) { m_LinePtr[m_nLines - 1]->Shrink(); }
    int operator ! () const { return !m_isOK; }
};

#endif
///////////////////////(EOF)/////////////////////////////////////////////////
