
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/SHLHIST.H__   1.8   20 Jun 1996 09:24:54   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/SHLHIST.H__  $
** 
**    Rev 1.8   20 Jun 1996 09:24:54   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.6   10 Jun 1996 10:19:32   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.4   29 May 1996 09:28:40   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:05:54   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:11:56   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:23:46   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 12:57:34   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:43:04   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:55:08   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:03:20   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:29:50   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:44:12   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:17:10   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:19:46   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:19:40   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:32:46   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:26:32   Shirley
** EasypPack/SLD Version 0.34c
** 
**    Rev 1.19   18 Jan 1996 10:11:20   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:12:56   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:11:00   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:14:48   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:29:20   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:21:34   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:27:18   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:31:54   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:33:58   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:44:44   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:04:30   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:47:24   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:45:16   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:26:36   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:49:32   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:24:28   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:48:22   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:53:08   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:48:48   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:54:00   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  SHLHIST.H
//
//  Description:The header file for the class: HistoryList
//
//  Author:     Roger Zhang
//
//  Date:       03/16/95
//
//  Modification:
//
//      1. 03/16/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#ifndef _SHLHIST_
#define _SHLHIST_               

/////////////////////////////////////////////////////////////////////////////
//  HistoryElement
/////////////////////////////////////////////////////////////////////////////

class HistoryElement
{
// attributes
public:
    int m_nLength;
    char * m_pchElem;                    
    BOOL m_isOK;
             
// constructor/destructors             
public:
    HistoryElement() : m_nLength(0), m_isOK(TRUE) {}
    HistoryElement(char * pch, int nLen);
    ~HistoryElement();
                          
// operations                          
public:
    int operator ! () const { return !m_isOK; }
};

typedef HistoryElement * PHistoryElement;

/////////////////////////////////////////////////////////////////////////////
//  HistoryList
/////////////////////////////////////////////////////////////////////////////

class HistoryList 
{
// constructor/destructors             
public:
    HistoryList(void);
    ~HistoryList();

// operations                          
public:
    BOOL AddTail(char * pch, int nLen);
    void DelHead(void);
    
    HistoryElement * GetPrev(void);
    HistoryElement * GetNext(void);
    
    BOOL SetMaxSize(int nMax);
    
    int IsEmpty(void) const { return !m_nElem; }
    int IsFull(void) const { return m_nElem == m_nMaxSize; } 
    int IsHead(void) const { return m_nPos == 0; }
    int IsTail(void) const { return m_nPos == m_nElem - 1; }
    
    int operator ! () const { return !m_isOK; }

// attributes
public:
    int m_nMaxSize;           
    int m_nElem;
    int m_nPos;
    PHistoryElement * m_Elem;
    BOOL m_isOK;
    BOOL m_isRecall;
};

#endif
/////////////////////////////(EOF)///////////////////////////////////////////
