/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/SPABROW.CPP   1.6   20 Jun 1996 09:28:48   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/SPABROW.CPP  $
** 
**    Rev 1.6   20 Jun 1996 09:28:48   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.4   10 Jun 1996 10:23:26   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.2   29 May 1996 09:34:42   ZJRD
** EasyPack/SLD Version 1.95
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: SPABROW.CPP
//
//  Description: The implementation file for the class: CSpaBrowseDlg.
//
//  Author: Chen Jun
//
//  Date: 05/08/96
//
//  Modification:
//      1. 05/08/96, Initial version of the class: CSpaBrowseDlg.
//
//  Copyright (C) 1996 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "resource.h"

#include "spagrp.h"
#include "spabrow.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// External variables.
int SpaGetModule(CStringList* &pList);
int SpaGetFunction(const CString& strModule, CStringList* &pList);
int SpaGetRangeEnd(const CString& strSymbol, CString& strEnd);

/////////////////////////////////////////////////////////////////////////////
// CSpaBrowseDlg dialog

CSpaBrowseDlg::CSpaBrowseDlg(CSpaGroupSheet* pSheet, const CString& strName, CWnd* pParent)
	: CDialog(CSpaBrowseDlg::IDD, pParent),
	m_pSheet(pSheet)
{
	//{{AFX_DATA_INIT(CSpaBrowseDlg)
	m_nModule = -1;
	m_nFunction = -1;
	m_strRange = strName;
	//}}AFX_DATA_INIT

	pSheet->m_nErrorID = pSheet->errOK;
}

void CSpaBrowseDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSpaBrowseDlg)
	DDX_Control(pDX, IDC_LIST_SPA_BROWSE_FUNCTION, m_listFunction);
	DDX_Control(pDX, IDC_LIST_SPA_BROWSE_MODULE, m_listModule);
	DDX_LBIndex(pDX, IDC_LIST_SPA_BROWSE_MODULE, m_nModule);
	DDX_LBIndex(pDX, IDC_LIST_SPA_BROWSE_FUNCTION, m_nFunction);
	DDX_Text(pDX, IDC_EDIT_SPA_BROWSE, m_strRange);
	DDV_MaxChars(pDX, m_strRange, 80);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSpaBrowseDlg, CDialog)
	//{{AFX_MSG_MAP(CSpaBrowseDlg)
	ON_LBN_SELCHANGE(IDC_LIST_SPA_BROWSE_MODULE, OnSelchangeListSpaBrowseModule)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CSpaBrowseDlg common routines

void CSpaBrowseDlg::UpdateModuleInfo(void)
{
	// Get the module info from Symbol server.
	m_nModule = 0;
	m_listModule.ResetContent();

	CStringList* pList = new CStringList;
	if ( 0 == ::SpaGetModule(pList) ) {
	    if ( !pList->IsEmpty() ) {
	        POSITION posHead = pList->GetHeadPosition();
	        while ( posHead ) {
	            m_listModule.AddString(pList->GetNext(posHead));
	        }
	    }
			
		if ( m_listModule.GetCount() > 0 ) {
			m_nModule = 0;
			m_listModule.SetCurSel(m_nModule);
		}
	}

	delete pList;
}

void CSpaBrowseDlg::UpdateFunctionInfo(void)
{
	// Get the current module.
	if ( m_listModule.GetCount() > 0 ) {
		CString strModule;
		m_listModule.GetText(m_nModule, strModule);

		// Get the function info from Symbol server.
		m_nFunction = 0;
		m_listFunction.ResetContent();
	
		CStringList* pList = new CStringList;
		if ( 0 == ::SpaGetFunction(strModule, pList) ) {
		    if ( !pList->IsEmpty() ) {
		        POSITION posHead = pList->GetHeadPosition();
		        while ( posHead ) {
		            m_listFunction.AddString(pList->GetNext(posHead));
		        }
		    }
				
			if ( m_listFunction.GetCount() > 0 ) {
				m_nFunction = 0;
				m_listFunction.SetCurSel(m_nFunction);
			}
		}
		delete pList;
	}
}

void CSpaBrowseDlg::CheckInputSyntax(void)
{
	// No any error now.
	ASSERT(m_pSheet->errOK == m_pSheet->m_nErrorID);

	// Check Define Range.
	m_strRange.TrimLeft();
	m_strRange.TrimRight();
	if ( m_strRange.IsEmpty() || m_strRange.GetLength() > 80 ) {
		m_pSheet->m_nErrorID = m_pSheet->errInput;
	}
}

/////////////////////////////////////////////////////////////////////////////
// CSpaBrowseDlg message handlers

BOOL CSpaBrowseDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	
    // Centering dialog box.
    CenterWindow();
    const int cxExtent = 200;
    m_listModule.SetHorizontalExtent(cxExtent);
    m_listFunction.SetHorizontalExtent(cxExtent);

    HFONT hFont = (HFONT)::GetStockObject(ANSI_FIXED_FONT);
    CFont font;
	m_listModule.SetFont(font.FromHandle(hFont));
	m_listFunction.SetFont(font.FromHandle(hFont));

	// Get the module info from Symbol server.
	UpdateModuleInfo();
	UpdateFunctionInfo();
		
    UpdateData(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CSpaBrowseDlg::OnOK() 
{
	// TODO: Add extra validation here

	// Check input syntax.
	UpdateData();
	CheckInputSyntax();
	if ( m_pSheet->errOK != m_pSheet->m_nErrorID ) {
		m_pSheet->DisplayErrorMessage();
		return;
	}

	// Connect with symbol server.
	m_strStart = _T("");
	m_strEnd = _T("");
	if ( m_listModule.GetCount() > 0 && m_listFunction.GetCount() > 0 ) {
		// Get the start address of the function.
		CString str;
		m_listModule.GetText(m_nModule, str);
		m_strStart += '#';
		m_strStart += str;

		m_listFunction.GetText(m_nFunction, str);
		m_strStart += '#';
		m_strStart += str;
		
		// Get the end address of the function.
		if ( 0 != ::SpaGetRangeEnd(m_strStart, m_strEnd) ) {
			m_pSheet->m_nErrorID = m_pSheet->errAbi;
			m_pSheet->DisplayErrorMessage();
			return;
		}
	}
	else {
		m_pSheet->m_nErrorID = m_pSheet->errInput;
		m_pSheet->DisplayErrorMessage();
		return;
	}

	CDialog::OnOK();
}

void CSpaBrowseDlg::OnSelchangeListSpaBrowseModule() 
{
	// TODO: Add your control notification handler code here

	// Get the function info according to the module ID.
	UpdateData();
	UpdateFunctionInfo();
	UpdateData(FALSE);
}
