/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/SPAGRP.CPP   1.8   20 Jun 1996 09:29:46   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/SPAGRP.CPP  $
** 
**    Rev 1.8   20 Jun 1996 09:29:46   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.6   10 Jun 1996 10:24:24   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.4   29 May 1996 09:36:24   ZJRD
** EasyPack/SLD Version 1.95
** 
**    Rev 1.3   16 May 1996 09:09:04   ZJRD
** EasyPack/SLD Version 1.94
** 
**    Rev 1.2   10 May 1996 09:08:42   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:26:18   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.1   18 Apr 1996 12:54:08   Shirley
** EasyPack/SLD Version 1.91
** 
**    Rev 1.0   12 Apr 1996 10:36:14   Shirley
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: SPAGRP.CPP
//
//  Description: The implementation file fore class: CSpaGroupSheet.
//
//  Author: Chen Jun
//
//  Date: 03/20/96
//
//  Modification:
//      1. 03/20/96, Initial version of the class: CSpaGroupSheet with VBX.
//      2. 03/29/96, CSpaGroupSheet without VBX.
//
//  Copyright (C) 1996 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "resource.h"

#include "xview.h"
#include "spagrp.h"
#include "hosterrs.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// External variables.
STATUS AbiGetOneReg(int iRegId, UINT* uRegValue);
STATUS AbiSetReg(int iRegId, UINT uRegValue);

/////////////////////////////////////////////////////////////////////////////
// CSpaGroupSheet dialog

IMPLEMENT_DYNAMIC(CSpaGroupSheet, CPropertySheet)

CSpaGroupSheet::CSpaGroupSheet(CWnd* pParent /*=NULL*/)
    : CPropertySheet(IDS_SPA_GROUP, pParent),
    m_nErrorID(errOK)
{
    // Add pages to the property sheet.
    AddPage(&m_pageEntry);
    AddPage(&m_pageTime);
    AddPage(&m_pageCode);
}

BEGIN_MESSAGE_MAP(CSpaGroupSheet, CPropertySheet)
	//{{AFX_MSG_MAP(CSpaGroupSheet)
	ON_WM_CREATE()
	ON_WM_CLOSE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CSpaGroupSheet common routines

void CSpaGroupSheet::DisplayErrorMessage()
{
	// Get the error string from the Error handling server.
	CString strError;
	::ErrGetErrorText(ER_SPA_BASE + m_nErrorID, strError);
	AfxMessageBox(strError);

/*
	strError.Format("Error ID: %d", m_nErrorID);
	AfxMessageBox(strError);
	MessageBeep(-1);
*/
	
	m_nErrorID = errOK;
}

BOOL CSpaGroupSheet::IsValidAddr(const CString& strAddr)
{
	// Check C-conversion.
	::ADDRESS Addr;
	if ( ::ADR_OK != ::AdrTextToAddr(strAddr, Addr) ) {
		return FALSE;
	}
	
	// Check space.
	if ( ::SPACE_PROGRAME != Addr.adrSpace && ::SPACE_UNDEFINE != Addr.adrSpace ) {
		return FALSE;
	}
	
	// Check range.
	Addr.adrSpace = ::SPACE_PROGRAME;
	return (::AdrCheckAddrRange(Addr));

/*
	// The follows will be marked if linking with Address server.
	AfxMessageBox(strAddr);
	return TRUE;
*/
}

void CSpaGroupSheet::SplitRecord(const CString& strLine)
{
	// Get DEFINE token.
	int nFirst = strLine.Find(';');
	if ( -1 == nFirst ) {
		return;
	}
	m_strDefine = strLine.Left(nFirst);

	// Get END token.
	int nLen = strLine.GetLength();
	int nNext = strLine.ReverseFind(';');
	if ( -1 == nNext ) {
		return;
	}
	else if ( nFirst == nNext ) {
		m_strStart = strLine.Right(nLen-nNext-1);
		return;
	}
	else {
		m_strEnd = strLine.Right(nLen-nNext-1);
	}
	
	// Get START token.
	m_strStart = (strLine.Left(nNext)).Right(nNext-nFirst-1);
}

void CSpaGroupSheet::BindRecord(const CString& strLine)
{
	// Get DEFINE token.
	int nFirst = strLine.Find(' ');
	if ( -1 == nFirst ) {
		return;
	}
	m_strDefine = strLine.Left(nFirst);
	
	// Get END token.
	int nLen = strLine.GetLength();
	int nNext = strLine.ReverseFind(' ');
	if ( -1 == nNext ) {
		return;
	}
	else if ( nFirst == nNext ) {
		m_strStart = strLine.Right(nLen-nNext-1);
		m_strEnd = "";
		return;
	}
	else {
		m_strEnd = strLine.Right(nLen-nNext-1);
	}
	
	// Get START token.
	m_strStart = (strLine.Left(nNext)).Right(nNext-nFirst-1);
}

void CSpaGroupSheet::EmptyBuffer(void)
{
	// Empty defined buffer.
	m_strDefine.Empty();
	m_strStart.Empty();
	m_strEnd.Empty();
}


/////////////////////////////////////////////////////////////////////////////
// CSpaGroupSheet message handlers

int CSpaGroupSheet::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
    if (CPropertySheet::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// TODO: Add your specialized creation code here
	
    // Centering dialog box.
    CenterWindow();
    
    // Disable 4 standard buttons.
	GetDlgItem(ID_APPLY_NOW)->DestroyWindow();
	GetDlgItem(IDOK)->DestroyWindow();
	GetDlgItem(IDCANCEL)->DestroyWindow();
	GetDlgItem(ID_HELP)->DestroyWindow();
	
	// Resize the sheet.
	m_sizeButton = CSize(0, 0);
	RecalcLayout();

	// Get the current PC 
	if ( ::ICE_OK != ::AbiGetOneReg(0, &m_uPC) ) {
		m_nErrorID = errAbi;
		DisplayErrorMessage();
		return -1;
	}

	return 0;
}

void CSpaGroupSheet::OnClose() 
{
	// TODO: Add your message handler code here and/or call default

	// Restore to the old PC.
	if ( ::ICE_OK != ::AbiSetReg(0, m_uPC) ) {
		m_nErrorID = errAbi;
		DisplayErrorMessage();
	}

	CPropertySheet::OnClose();
}
