/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/SPAGRP.H__   1.8   20 Jun 1996 09:27:52   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/SPAGRP.H__  $
** 
**    Rev 1.8   20 Jun 1996 09:27:52   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.6   10 Jun 1996 10:22:30   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.4   29 May 1996 09:33:16   ZJRD
** EasyPack/SLD Version 1.95
** 
**    Rev 1.3   16 May 1996 09:05:22   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:11:24   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:23:16   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.1   18 Apr 1996 12:56:58   Shirley
** EasyPack/SLD Version 1.91
** 
**    Rev 1.0   12 Apr 1996 10:42:22   Shirley
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: SPAGRP.H
//
//  Description: The header file for the class: CSpaGroupSheet.
//
//  Author: Chen Jun
//
//  Date: 03/20/96
//
//  Modification:
//      1. 03/20/96, Initial version of the class: CSpaGroupDlg with VBX.
//      2. 03/29/96, CSpaGroupSheet without VBX.
//
//  Copyright (C) 1996 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////
#ifndef _SPAGRP_H_
#define _SPAGRP_H_

#include "abitype.h"
#include "abispa.h"
#include "address.h"
#include "addrapi.h"

#include "spaentry.h"
#include "spatime.h"
#include "spacode.h"

/////////////////////////////////////////////////////////////////////////////
// CSpaGroupSheet dialog

class CSpaGroupSheet : public CPropertySheet
{
// Construction
public:
    DECLARE_DYNAMIC(CSpaGroupSheet)
	CSpaGroupSheet(CWnd* pParent = NULL);	// standard constructor

// Attributes
public:
	CSpaModuleEntryPage m_pageEntry;
	CSpaExecutionTimePage m_pageTime;
	CSpaCodeCoveragePage m_pageCode;

public:
	enum { 
		errOK = 0,		// SPA command is OK.
		errDebug,		// SPA is in debug mode.
		errEmpty,		// User's input is empty.
		errNoDelimit,	// The module range setting is invalid.
		errInput,		// The user's input is invalid.
		errExist,		// The same module range setting exists.
		errFile,		// Cannot open the data file.
		errMemory,		// Insufficient memory.
		errRange,		// Module range is invalid.
		errTimer,       // System timer setting is invalid.
		errAbi,			// Communication failure.
		errNoCoverage	// No coverage information about the current setting.
	};
	int m_nErrorID;

    CString m_strStart, m_strEnd, m_strDefine;

	UINT m_uPC;

// Implementation
public:
	BOOL IsValidAddr(const CString& strAddr);
	void DisplayErrorMessage(void);

	void SplitRecord(const CString& strLine);
	void BindRecord(const CString& strLine);
	void EmptyBuffer(void);

protected:
	// Generated message map functions
	//{{AFX_MSG(CSpaGroupSheet)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnClose();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#endif
