/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/SPATIME.H__   1.8   20 Jun 1996 09:28:48   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/SPATIME.H__  $
** 
**    Rev 1.8   20 Jun 1996 09:28:48   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.6   10 Jun 1996 10:23:24   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.4   29 May 1996 09:34:42   ZJRD
** EasyPack/SLD Version 1.95
** 
**    Rev 1.3   16 May 1996 09:00:08   ZJRD
** EasyPack/SLD Version 1.94
** 
**    Rev 1.2   10 May 1996 09:16:40   ZJRD
** EasyPack/SLD Version 1.93
** 
**    Rev 1.1   02 May 1996 10:31:02   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.1   18 Apr 1996 12:57:46   Shirley
** No change.
** 
**    Rev 1.0   12 Apr 1996 10:41:28   Shirley
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: SPATIME.H
//
//  Description: The header file for the class: CSpaExecutionTimePage.
//
//  Author: Chen Jun
//
//  Date: 03/21/96
//
//  Modification:
//      1. 03/21/96, Initial version of the class: CSpaExecutionTimeDlg.
//      2. 03/29/96, CSpaExecutionTimePage with CPropertyPage.
//
//  Copyright (C) 1996 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////
#ifndef _SPATIME_H_
#define _SPATIME_H_

/////////////////////////////////////////////////////////////////////////////
// CSpaExecutionTimePage dialog

class CSpaExecutionTimePage : public CPropertyPage
{
// Construction
public:
	CSpaExecutionTimePage();

// Dialog Data
	//{{AFX_DATA(CSpaExecutionTimePage)
	enum { IDD = IDD_SPA_TIME };
	CEdit	m_editBp;
	CButton	m_btnBp;
	CButton	m_btnRestart;
	CEdit	m_editShort;
	CEdit	m_editLong;
	CStatic	m_staticCountBar1;
	CStatic	m_staticCountBar2;
	CStatic	m_staticCountBar3;
	CStatic	m_staticCountBar4;
	CStatic	m_staticCountBar5;
	CStatic	m_staticCountBar6;
	CStatic	m_staticCountBar7;
	CStatic	m_staticCountBar8;
	CStatic	m_staticCountBar9;
	CStatic	m_staticCountBar10;
	CButton	m_btnEdit;
	CButton	m_btnStop;
	CButton	m_btnStart;
	CComboBox	m_comboRange1;
	CString	m_strRange1;
	int		m_nCount1;
	int		m_nCount2;
	int		m_nCount3;
	int		m_nCount4;
	int		m_nCount5;
	int		m_nCount6;
	int		m_nCount7;
	int		m_nCount8;
	int		m_nCount9;
	int		m_nCount10;
	int		m_nTotal;
	CString	m_strLong;
	CString m_strShort;
	CString	m_strRange0;
	//}}AFX_DATA

private:
	const DWORD m_cdwMaxTime;
	const int m_cnMaxCount;

	DWORD	m_dwTime;

	int		m_nCountPer1;
	int		m_nCountPer2;
	int		m_nCountPer3;
	int		m_nCountPer4;
	int		m_nCountPer5;
	int		m_nCountPer6;
	int		m_nCountPer7;
	int		m_nCountPer8;
	int		m_nCountPer9;
	int		m_nCountPer10;

	enum { executionRange = 0, entryRange };
	enum { combo0 = 0, combo1 };
	enum { defineLen = 80, startLen = 80, endLen = 80 };

	enum { tmEvent = 1, tmElapse = 100 };
    UINT m_uTimerID;
    
    BOOL m_bStop;
    
    enum { stop = 0, pause, running, failure };

	enum { module0 = 0, module1 };
    int m_nWhichModule;
    
    ::ADDR m_Addr[2];

    enum { btnStart = 0, btnRestart };
    int m_nWhichBtn;

private:
	SPABPSETINFO m_EntryInfo;

// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CSpaExecutionTimePage)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual BOOL OnKillActive();
	virtual BOOL OnSetActive();
	//}}AFX_VIRTUAL

// Implementation
private:
	void ClearResult(void);
	void CheckInputSyntax(void);

    BOOL SetEntryData(void);
    int GetEntryData(void);

	BOOL CalcResult(void);
    BOOL CalcCount(void);
    BOOL CalcLimit(void);

	void UpdateCombo(void);

    void ReadRecord(int nWhichFile, int nWhichCombo);
    void ReadRecord(int nWhichFile, const CString& strDefine);

	void GetExecuteRange(void);

    void UpdateBar(void);
    void UpdateCountBar(int nWhich, BOOL bRedraw = TRUE);

	void StopTimerAction(void);
    void DisableControl(void);

	void AssignTimeCount(void);

protected:
	// Generated message map functions
	//{{AFX_MSG(CSpaExecutionTimePage)
	afx_msg void OnHelp();
	afx_msg void OnButtonSpaTimeEdit();
	afx_msg void OnButtonSpaTimeStart();
	afx_msg void OnButtonSpaTimeStop();
	virtual void OnCancel();
	afx_msg void OnShowWindow(BOOL bShow, UINT nStatus);
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnButtonSpaTimeRestart();
	afx_msg void OnButtonSpaBp();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#endif
