
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/SRCCOM.CPP   1.8   20 Jun 1996 09:26:32   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/SRCCOM.CPP  $
** 
**    Rev 1.8   20 Jun 1996 09:26:32   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.6   10 Jun 1996 10:21:12   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.4   29 May 1996 09:31:16   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:04:32   ZJRD
** EasyPack/SLD Version 1.94
** 
**    Rev 1.1   02 May 1996 10:23:22   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 12:57:04   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:42:28   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:54:30   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:02:46   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:36:48   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:51:04   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:12:20   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:12:04   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:12:44   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:36:22   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:24:46   Shirley
** EasypPack/SLD Version 0.34c
** 
**    Rev 1.19   18 Jan 1996 10:09:08   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:12:08   Shirley
** EasyPack/SLD Version 0.34a
** 
**    Rev 1.17   04 Jan 1996 11:14:38   Shirley
** EasyPack/SLD Version 0.34
** 
**    Rev 1.16   30 Nov 1995 09:09:50   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:30:42   Shirley
** EasyPack/SLD Version 0.32
** 
**    Rev 1.14   21 Nov 1995 11:20:20   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:23:02   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:32:06   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:34:10   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:44:04   Shirley
** EasyPack/SLD Version 0.22
** 
**    Rev 1.9   02 Nov 1995 10:05:00   Shirley
** EasyPack/SLD Version 0.21
** 
**    Rev 1.8   27 Oct 1995 16:47:58   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:46:00   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:30:12   Shirley
** EasyPack/SLD Version 0.1f
** 
**    Rev 1.5   18 Oct 1995 14:49:46   Shirley
** EasyPack/SLD Version 0.1e
** 
**    Rev 1.4   13 Oct 1995 13:20:26   Shirley
** EasyPack/SLD Version 0.1d
** 
**    Rev 1.3   29 Sep 1995 09:48:32   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:53:16   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:48:00   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:54:24   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  SRCCOM.CPP
//
//  Description:The implement file for the class:
//              BrowseModuleList
//              SourceSearchData
//              JumpDataClass
//              LoadOptionClass
//              LoadInfoClass
//              SourceOptionClass
//              ExtNameList
//              SourceEmulation
//
//  Author:     Roger Zhang
//
//  Date:       05/12/95
//
//  Modification:
//
//      1. 05/12/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"

#include <ctype.h>
#include "zqueue.h"
#include "uicom.h"
#include "srccom.h"
#include "zlist.h"
#include "srcList.h"
#include "srcmdl.h"
#include "srcfile.h"

/////////////////////////////////////////////////////////////////////////////
//  BrowseModuleList
/////////////////////////////////////////////////////////////////////////////

BrowseModuleList BrsMdl;
BrowseModuleList bwsBrsMdl;
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void BrowseModuleList::GotoHead(void) 
{
    ASSERT(!IsEmpty());
    
    m_nIndex = 0;
}                           
                           
                           
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void BrowseModuleList::GotoTail(void) 
{
    ASSERT(!IsEmpty());
    
    m_nIndex = m_nCount - 1;
}                           
                           
                           
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void BrowseModuleList::GotoPrev(void) 
{
    ASSERT(!IsEmpty());
    
    if(!IsHead())   -- m_nIndex;
}                           
                           
                           
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void BrowseModuleList::GotoNext(void) 
{
    ASSERT(!IsEmpty());
    
    if(!IsTail())    ++ m_nIndex;
}                           
                               
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL BrowseModuleList::AddTail(unsigned long dwModule)
{   
	// check wether the new module already in the tail of the list
	if(!IsEmpty() && m_dwModule[m_nCount - 1] == dwModule) {
		return TRUE;	
	}
	
    if(IsFull()) {     
        -- m_nCount;
        for(int i = 0; i < m_nCount; i ++) 
            m_dwModule[i] = m_dwModule[i + 1];
    }
    
    m_dwModule[m_nCount++] = dwModule;
    m_nIndex = m_nCount - 1;
    return TRUE;
}                               

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL BrowseModuleList::MoveIndex(unsigned long dwModule)
{
    ASSERT(!IsEmpty());
    
    for(int i = 0; i < m_nCount; i ++) {
        if(dwModule == m_dwModule[i]) {   
            m_nIndex = i;
            return TRUE;
        }
    }                                               
    return FALSE;    
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void BrowseModuleList::SetSize(int nMax)
{
    if(nMax <= 0 || nMax >= MAX_MODULES) return;
    if(nMax < m_nCount) {
        for(int i = 0; i < nMax; i ++) 
            m_dwModule[i] = m_dwModule[i+m_nCount-nMax];
        m_nCount = nMax;    
    }
    m_nMax = nMax;
}
                           
/////////////////////////////////////////////////////////////////////////////
//  SourceSearchData
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void SourceSearchData::AddNew(const char * psz)
{
    if(m_StrList.GetCount() && m_StrList.GetTail() == psz)
        return;
    if(m_StrList.GetCount() == 20)  m_StrList.RemoveHead();
    m_StrList.AddTail(psz);
}                          
                          
SourceSearchData SrcSrchData;
BOOL isSrcSrchDlg = FALSE;

/////////////////////////////////////////////////////////////////////////////            
int         nBrowseLine = 1;
unsigned    uBrowseAddr = 0;

/////////////////////////////////////////////////////////////////////////////
JumpDataClass JumpData;

/////////////////////////////////////////////////////////////////////////////
//  LoadOptionClass
/////////////////////////////////////////////////////////////////////////////

LoadOptionClass LoadOpt;

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL LoadOptionClass::ReadIni(void)
{
    CString strBuffer = AfxGetApp()->
        GetProfileString("LoadOption", "LoadOption");
    int nCode, nCpp, nDemand, nStatus, nSymbol, nWarnings;
    int nRval = sscanf(strBuffer, "%d %d %d %d %d %d", 
        &nCode, &nCpp, &nDemand, &nStatus, &nSymbol, &nWarnings);
    if(nRval != 6)  return FALSE;
    m_isCode     = nCode;
    m_isCpp      = nCpp;
    m_isDemand   = nDemand;
    m_isStatus   = nStatus;
    m_isSymbol   = nSymbol;
    m_isWarnings = nWarnings;
    return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL LoadOptionClass::WriteIni(void)
{
    char szBuffer[100];

    int nRval = sprintf(szBuffer, "%d %d %d %d %d %d", 
        m_isCode, m_isCpp, m_isDemand, m_isStatus, m_isSymbol, m_isWarnings);
    if(nRval == -1) return FALSE;                 
    AfxGetApp()->WriteProfileString("LoadOption", "LoadOption", szBuffer);
    return TRUE;
}              

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL ReadLoadOption(void)
{
    return LoadOpt.ReadIni();
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL WriteLoadOption(void)
{
    return LoadOpt.WriteIni();
}

/////////////////////////////////////////////////////////////////////////////
LoadInfoClass LoadInfo;

/////////////////////////////////////////////////////////////////////////////
//  SourceOptionClass
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
int SourceOptionClass::Str2Tab(const CString &str) const
{
    int i = atoi(str);
    if(i < MIN_TABWIDTH || i > MAX_TABWIDTH)    return  -1;
    else    return  i;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
int SourceOptionClass::Str2Hist(const CString &str) const
{
    int i = atoi(str);
    if(i < MIN_BROWSE || i > MAX_BROWSE)    return  -1;
    else    return  i;
}

SourceOptionClass SrcOpt;                                                   
                                                   
/////////////////////////////////////////////////////////////////////////////
//  ExtNameList
/////////////////////////////////////////////////////////////////////////////

ExtNameList ExtList;

/////////////////////////////////////////////////////////////////////////////
CStringQueue SrcPathList(20);

/////////////////////////////////////////////////////////////////////////////
BOOL isLineNo = TRUE;
BOOL isBwsLineNo = TRUE;
BOOL isSymDsm = TRUE;

/////////////////////////////////////////////////////////////////////////////
//  SourceEmulation
/////////////////////////////////////////////////////////////////////////////
SourceEmulation SrcEmu;

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////

BOOL SourceEmulation::GetPC(void) 
{ 
    m_lPCAddr = SrcGetPC(); 
    if(m_lPCAddr > 0xFFFFL) {	// error
        m_nPCLine = -1;	// indicates error PC address
        return FALSE;
    } else return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Get PC Module & PC line from PC address
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL SourceEmulation::GetModule(void)
{                                
    ASSERT(m_lPCAddr <= 0xFFFFL);
                                 
    unsigned short uFirst, uLast;	// statement position                       
              
    if(m_nStepOpt != 1 && !SrcEmu.m_isStatement) { // not step statement
        if(SrcAddr2Linenum(m_lPCAddr, (unsigned short &)m_nPCLine, 
            m_dwPCModule) == 0) {     
            
            ASSERT(m_nPCLine > 0);
            
            -- m_nPCLine;
            return TRUE;
        } else {
            m_nPCLine = -1;
            return FALSE;
        }                                 
    } else {
        if(SrcAddr2Statement(m_lPCAddr, (unsigned short &)m_nPCLine, 
            uFirst, uLast, m_dwPCModule) == 0) {
            
            ASSERT(m_nPCLine > 0);          
            ASSERT(uLast >= uFirst);
            
            -- m_nPCLine;         
            if(uLast == 0xFFFF) m_nPCLast = 32767;
            else m_nPCLast = uLast - 1;
            if(uFirst == 0xFFFF) m_nPCFirst = 32767;
            else m_nPCFirst = uFirst - 1;
            return TRUE;
        } else {
            m_nPCLine = -1;
            return FALSE;
        }                                 
    }
}                   

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL SourceEmulation::IsPCModule(unsigned long dwModule) const
{
    if(m_nPCLine >= 0 && m_dwPCModule == dwModule)
        return TRUE;
    else return FALSE;
}
        
/////////////////////////////////////////////////////////////////////////////
//  Global functions
/////////////////////////////////////////////////////////////////////////////
        
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL IsRunAccess(void)
{
    return  SrcEmu.m_isRunAccess;
}


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void SetStepOption(int nStepOption)
{
    if(SrcDispMode() != MODE_SOURCE || 
        (nStepOption == STEP_STATEMENT && !SrcEmu.m_isStatement))
        return;

    SrcEmu.m_nStepOpt = nStepOption;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
int GetStepOption(void)
{
    return SrcEmu.m_nStepOpt;
}                           

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
static BOOL TestModulePath(const char * pszModulePath)
{             
    FILE * fp;
    
    fp = fopen(pszModulePath, "rb");
    if(!fp) return FALSE; 

    fclose(fp);    
    return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
CString SrcGetModuleFullName(const char * pszModuleName)
{   
	CString strModulePath;
	
    ASSERT(pszModuleName);
    if(!pszModuleName) {
        return CString("");
    }
 
    POSITION posExt, posPath;
    CString strExt;
    
    posExt = ExtList.GetHeadPosition();
    while(posExt) {
        strExt = ExtList.GetNext(posExt);
        posPath = SrcPathList.GetHeadPosition();
        while(posPath) {
            strModulePath = SrcPathList.GetNext(posPath);
            if(strModulePath.Right(1) != "\\")    strModulePath += "\\";
            strModulePath += pszModuleName;
            strModulePath += strExt;
            if(TestModulePath(strModulePath)) return strModulePath;
        }                
    }

    // No extension
    posPath = SrcPathList.GetHeadPosition();
    while(posPath) {
        strModulePath = SrcPathList.GetNext(posPath);
        if(strModulePath.Right(1) != "\\")    strModulePath += "\\";
        strModulePath += pszModuleName;
        if(TestModulePath(strModulePath)) return strModulePath;
    }                
                 
    return CString("");                 
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   Str2Addr
//
//  Description: 
//
//  Input:  
//
//  Output: None
//
//  Return: 0->0xFFFFL -- the address
//          0x10000L   -- convert error
//
/////////////////////////////////////////////////////////////////////////////
long Str2Addr(const char * psz)
{
    char s[256];
    strncpy(s, psz, 256);
    s[255] = '\0';
    for(int n = 0; isspace(s[n]); n++) ;
    if(s[n] == '\0')  return  0x10000L;
    DWORD dwNum;
    BYTE  byTmp;
    if(SymToAddr(s+n, &byTmp, &dwNum) == 0) {
        ;
    } else if(!Str2Num(s, dwNum)) {
        return  0x10000L;
    }                      
    return dwNum;    
}                      

/////////////////////////////////////////////////////////////////////////////

static BOOL TestModule(DWORD dwModule)
{
    char psz[41];                                           
    
    for(int i = 0; i < 41; i ++)    psz[i] = 0;
    if(SrcGetModuleName(dwModule, psz) == -1)    return  FALSE;
    if(SrcGetModuleFullName(psz)=="")	return FALSE;
	return TRUE; 	
}

void SrcPreStep(void)
{
	if(!isSourceOn)	return;
	
/*	if(MdlInfo.IsModuleOn() && SrcEmu.IsPCModule(MdlInfo.CurModule()))	
		return;*/
	
	else if(SrcEmu.GetPC() && SrcEmu.GetModule()) {
		if(!TestModule(SrcEmu.m_dwPCModule)) 
			SrcEmu.m_nStepOpt = STEP_INSTRUCTION;
		else if(SrcEmu.m_nStepOpt != STEP_INSTRUCTION)
			return;	
		else if(SrcDispMode() != MODE_SOURCE)	
			SrcEmu.m_nStepOpt = STEP_INSTRUCTION;
		else if(SrcEmu.m_isStatement)
			SrcEmu.m_nStepOpt = STEP_STATEMENT;
		else	
			SrcEmu.m_nStepOpt = STEP_LINE;
	} else SrcEmu.m_nStepOpt = STEP_INSTRUCTION;
}   

/////////////////////////////////////////////////////////////////////////////
                        
BOOL IsDelimit(char ch)
{
 	return BOOL(strchr("~`!@$%^&*()-+=|\\}]{[\"\':;<,>.?/ \t\n\r", ch) 
 		!= NULL);
}

/////////////////////////////////////////////////////////////////////////////                        
// for cpu server
unsigned short GetLoadPC(void)
{
	return (unsigned short)(LoadInfo.m_lPC);
}
                             
// for loader, called after load a file in the shell window                             
void SrcSetLoadFileName(const char * str)
{
 	LoadInfo.m_strFile = str;
}

////////////////////////////////(EOF)////////////////////////////////////////
                                                           
                                                           