
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/SRCGRP.CPP   1.7   11 Jun 1996 10:25:24   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/SRCGRP.CPP  $
** 
**    Rev 1.7   11 Jun 1996 10:25:24   ZJRD
** EasyPack/SLD Version 1.97
** 
**    Rev 1.5   05 Jun 1996 14:53:12   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:31:46   ZJRD
** EasyPack/SLD Version 1.95
** 
**    Rev 1.1   02 May 1996 10:30:46   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 12:55:54   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:34:54   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:49:20   Shirley
** EasyPack/SLD Version 1.01
** 
**    Rev 1.27   12 Feb 1996 14:04:48   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:31:22   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:46:14   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:19:46   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:16:36   Shirley
** EasyPack/SLD Version 0.35a
** 
**    Rev 1.22   25 Jan 1996 13:16:30   Shirley
** EasyPack/SLD Version 0.35
** 
**    Rev 1.21   24 Jan 1996 10:34:26   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:28:54   Shirley
** EasypPack/SLD Version 0.34c
** 
**    Rev 1.19   18 Jan 1996 10:13:46   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:10:36   Shirley
** EasyPack/SLD Version 0.34a
** 
**    Rev 1.17   04 Jan 1996 11:09:54   Shirley
** EasyPack/SLD Version 0.34
** 
**    Rev 1.16   30 Nov 1995 09:13:16   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:35:36   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:23:42   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:26:02   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:29:42   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:31:32   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:43:06   Shirley
** EasyPack/SLD Version 0.22
** 
**    Rev 1.9   02 Nov 1995 10:03:56   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:50:34   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:46:58   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:29:56   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:48:26   Shirley
** EasyPack/SLD Version 0.1e
** 
**    Rev 1.4   13 Oct 1995 13:20:30   Shirley
** EasyPack/SLD Version 0.1d
** 
**    Rev 1.3   29 Sep 1995 09:48:36   Shirley
** EasyPack/SLD Version 0.1c
** 
**    Rev 1.2   20 Sep 1995 10:55:12   Shirley
** EasyPack/SLD Version 0.1b
** 
**    Rev 1.1   15 Sep 1995 09:47:34   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:55:00   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  SRCGRP.CPP
//
//  Description:The implement file for the class: CSourceGroup
//
//  Author:     HuWei
//
//  Date:       05/4/96
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"                      
#include "resource.h"
#include "xview.h"   

#include <io.h>
#include <fcntl.h>
#include <time.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <ctype.h>
#include <direct.h>

#include "zqueue.h"
#include "uicom.h"
#include "srccom.h"
#include "srcgrp.h" 
#include "zlist.h"
#include "srclist.h"
#include "srcmdl.h"
#include "bwsmdl.h"
#include <direct.h>
#include <stdio.h>
#include <dos.h>


#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif         

BOOL g_bBrowse=0;
int  g_nbDoBpPage=0;
extern void SrcSetText();
extern void BwsSetText();    
extern void DoBwsBrowseModule(CSrcBrowse &dlg);
extern void DoBrowseModule(CSrcBrowse &dlg);
//CPropertySheet *g_pPropertySheet=NULL;

#define IDCLOSE IDCANCEL+1
#define XM_SHOWDIR WM_USER+10

/////////////////////////////////////////////////////////////////////////////
//  BP Symbol 

// Node struct for BP symbol list
typedef struct tagBPSym
{
    unsigned short uAddr;
    CString str;
} BPSym;
                              
// the BP symbol list                              
static CPtrList lstBPSym;
                     
// Delete the list                     
void BPClrSym(void)
{                               
    BPSym * p;
    while(!lstBPSym.IsEmpty()) {
        p = (BPSym *)(lstBPSym.RemoveTail());
        delete p;
    }
}
                  
// Delete one node                  
void BPClrSym(unsigned short uAddr)
{
    BPSym * p;
    POSITION pos = lstBPSym.GetHeadPosition();
    POSITION pos1;
    while(pos) {  
        pos1 = pos;
        p = (BPSym *)(lstBPSym.GetNext(pos));
        if(p->uAddr == uAddr) {
            lstBPSym.RemoveAt(pos1);
            delete p;
            return;
        }
    }                                         
}
                  
// search in the list                  
CString BPAddr2Sym(unsigned short uAddr)
{                                 
    BPSym * p;
    POSITION pos = lstBPSym.GetHeadPosition();
    while(pos) {
        p = (BPSym *)(lstBPSym.GetNext(pos));
        if(p->uAddr == uAddr)   return p->str;
    }                                         
    return "";
}             
                     
// add node to the list                     
void BPAddSym(unsigned short uAddr, const char * str)
{                
    ASSERT(str);
    
    BPSym * p = new BPSym;
    if(!p)  return;
    p->uAddr = uAddr;
    p->str = str;
    lstBPSym.AddTail(p);
}


/////////////////////////////////////////////////////////////////////////////
// CSourceGroup dialog
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CSourceGroup::CSourceGroup
//
//  Description: Constructor of the class CSourceGroup
//
//  Input:  
//      nTab -- 0->5, initial tab to show
//      pParent -- the parent window
//
//  Output: None
//
//  Return: None
//
/////////////////////////////////////////////////////////////////////////////
CSourceGroup::CSourceGroup(int nTab, CWnd* pParent /*=NULL*/, BOOL bBrowse)
    : CDialog(CSourceGroup::IDD, pParent), m_nTab(nTab), m_bBrowse(bBrowse)
{                 
    //{{AFX_DATA_INIT(CSourceGroup)
    m_vbxTab = NULL;
    m_isCode_1     = LoadOpt.m_isCode;
    m_isCpp_1      = LoadOpt.m_isCpp;
    m_isDemand_1   = LoadOpt.m_isDemand;
    m_isStatus_1   = LoadOpt.m_isStatus;
    m_isSymbol_1   = LoadOpt.m_isSymbol;
    m_isWarn_1     = LoadOpt.m_isWarnings;
    m_strInfo_2 = "";
    m_strMdl_2 = "";
    m_strPath_3 = "";
    m_vbxDir_3 = NULL;
    m_nCR_4 = SrcOpt.m_nLineDelimit;
    m_strAddr_6 = "";
    m_strList_6 = "";
    m_strMdl_6 = "";
    //}}AFX_DATA_INIT
    char psz[10];
//    wsprintf(psz, "%d", SrcOpt.m_nTabWidth);
//    m_strTab_4 = psz;
    wsprintf(psz, "%d", SrcOpt.m_nBrowseHist);
    m_strHist_4 = psz;
    m_nCRSave_4 = m_nCR_4;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CSourceGroup::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CSourceGroup)
    DDX_Control(pDX, IDC_SRCGRP3_DRV1, m_cmbDrv_3);
    DDX_Control(pDX, IDC_SRCGRP6_ADDR1, m_edAddr1_6);
    DDX_VBControl(pDX, IDC_SRCTAB, m_vbxTab);
    DDX_Check(pDX, IDC_SRCGRP1_CODE, m_isCode_1);
    DDX_Check(pDX, IDC_SRCGRP1_CPP, m_isCpp_1);
    DDX_Check(pDX, IDC_SRCGRP1_DEMAND, m_isDemand_1);
    DDX_Check(pDX, IDC_SRCGRP1_STATUS, m_isStatus_1);
    DDX_Check(pDX, IDC_SRCGRP1_SYMBOL, m_isSymbol_1);
    DDX_Check(pDX, IDC_SRCGRP1_WARN, m_isWarn_1);
    DDX_LBString(pDX, IDC_SRCGRP2_INFO, m_strInfo_2);
    DDX_LBString(pDX, IDC_SRCGRP2_MDL, m_strMdl_2);
    DDX_Control(pDX, IDC_SRCGRP2_MDL, m_ListMdl_2);
    DDX_Control(pDX, IDC_SRCGRP2_INFO, m_ListInfo_2);
    DDX_Text(pDX, IDC_SRCGRP3_PATH, m_strPath_3);
    DDX_Control(pDX, IDC_SRCGRP3_LIST, m_ListPath_3);
    DDX_VBControl(pDX, IDC_SRCGRP3_DIR, m_vbxDir_3);
    DDX_Radio(pDX, IDC_SRCGRP4_CR, m_nCR_4);
    DDX_Text(pDX, IDC_SRCGRP4_HIST, m_strHist_4);
    DDX_Control(pDX, IDC_SRCGRP5_LIST, m_List_5);
    DDX_CBString(pDX, IDC_SRCGRP6_ADDR, m_strAddr_6);
    DDX_LBString(pDX, IDC_SRCGRP6_LIST, m_strList_6);
    DDX_CBString(pDX, IDC_SRCGRP6_MDL, m_strMdl_6);
    DDX_Control(pDX, IDC_SRCGRP6_MDL, m_cmbMdl_6);
    DDX_Control(pDX, IDC_SRCGRP6_LIST, m_List_6);
    DDX_Control(pDX, IDC_SRCGRP6_ADDR, m_CmbAddr_6);
    //}}AFX_DATA_MAP
}                           

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CSourceGroup::ShowTabCtrl
//
//  Description: Show or hide the specified tab card
//
//  Input:  
//      nTab -- 0->5, the selected tab card
//      isShow -- True : Show, False : Hide
//
//  Output: None
//
//  Return: None
//
/////////////////////////////////////////////////////////////////////////////
void CSourceGroup::ShowTabCtrl(int nTab, BOOL isShow)
{                                  
    int nCmdShow = isShow ? SW_SHOW : SW_HIDE;
    switch(nTab) {
        case    0:
            if(isShow)  m_nIDHelp = IDD_SRCGRP_LOADOPTION;
            GetDlgItem(IDC_SRCGRP1_CODE)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP1_SYMBOL)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP1_DEMAND)->ShowWindow(nCmdShow);
            //GetDlgItem(IDC_SRCGRP1_CPP)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP1_STATUS)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP1_WARN)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP1_STC1)->ShowWindow(nCmdShow);
            GetDlgItem(IDCANCEL)->ShowWindow(nCmdShow);
            SetDlgItemText(IDOK, "OK");
            GetDlgItem(IDC_SRCGRP1_DEMAND)->EnableWindow(m_isSymbol_1);
            GetDlgItem(IDC_SRCGRP1_CPP)->EnableWindow(m_isSymbol_1);
            break;
        case    1:
            if(isShow)  m_nIDHelp = IDD_SRCGRP_BROWSEMODULE;
            if(m_bBrowse&&nCmdShow != SW_SHOW)
               break;               
            GetDlgItem(IDC_SRCGRP2_MDL)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP2_INFO)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP2_STC1)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP2_STC2)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP2_STC3)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP2_STC5)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP2_STC6)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP2_STC7)->ShowWindow(nCmdShow);
            GetDlgItem(IDCANCEL)->ShowWindow(nCmdShow);
            SetDlgItemText(IDOK, "OK");
            break;
        case    2:
            if(isShow)  m_nIDHelp = IDD_SRCGRP_SOURCEPATH;
            GetDlgItem(IDC_SRCGRP3_DIR)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP3_DRV1)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP3_ADD)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP3_REMOVE)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP3_LIST)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP3_STC1)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP3_STC2)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP3_STC3)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP3_PATH)->ShowWindow(nCmdShow);
            GetDlgItem(IDCANCEL)->ShowWindow(nCmdShow);
            SetDlgItemText(IDOK, "OK");                      
            m_strPath_3 = m_vbxDir_3->GetStrProperty("Path");
            break;
        case    3:
            if(isShow)  m_nIDHelp = IDD_SRCGRP_SOURCEOPTION;
            GetDlgItem(IDC_SRCGRP4_CR)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP4_LF)->ShowWindow(nCmdShow);
//            GetDlgItem(IDC_SRCGRP4_STC1)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP4_STC2)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP4_STC3)->ShowWindow(nCmdShow);
//            GetDlgItem(IDC_SRCGRP4_TAB)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP4_HIST)->ShowWindow(nCmdShow);
            GetDlgItem(IDCANCEL)->ShowWindow(nCmdShow);
            SetDlgItemText(IDOK, "OK");
            break;
        case    4:
            if(isShow)  m_nIDHelp = IDD_SRCGRP_EXTENSION;
            GetDlgItem(IDC_SRCGRP5_LIST)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP5_ADD)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP5_REMOVE)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP5_EDIT)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP5_STC1)->ShowWindow(nCmdShow);
            GetDlgItem(IDCANCEL)->ShowWindow(nCmdShow);
            SetDlgItemText(IDOK, "OK");
            break;
        case    5:
            if(isShow)  m_nIDHelp = IDD_SRCGRP_BREAKPOINT;
            GetDlgItem(IDC_SRCGRP6_ADD)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP6_STC1)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP6_STC4)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP6_ENABLE)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP6_DISABLE)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP6_DEL)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP6_DELALL)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP6_SAVE)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP6_RESTORE)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP6_STC2)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP6_STC3)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP6_STC5)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP6_STC6)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP6_STC7)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP6_ADDR)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP6_ADDR1)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP6_MDL)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP6_LIST)->ShowWindow(nCmdShow);
            SetDlgItemText(IDOK, "&Close");
            break;
    }
}     

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:      
//      nTab    -- 0->5 for tab card number
//      isEnable -- Enable the card or not
//
//  Output: NULL
//
//  Return: NULL
//
/////////////////////////////////////////////////////////////////////////////
void CSourceGroup::EnableTabCtrl(int nTab, BOOL isEnable)
{                                  
    switch(nTab) {
        case    0:
            GetDlgItem(IDC_SRCGRP1_CODE)->EnableWindow(isEnable);
            GetDlgItem(IDC_SRCGRP1_SYMBOL)->EnableWindow(isEnable);
            GetDlgItem(IDC_SRCGRP1_DEMAND)->EnableWindow(isEnable);
            //GetDlgItem(IDC_SRCGRP1_CPP)->EnableWindow(isEnable);
            GetDlgItem(IDC_SRCGRP1_STATUS)->EnableWindow(isEnable);
            GetDlgItem(IDC_SRCGRP1_WARN)->EnableWindow(isEnable);
            GetDlgItem(IDC_SRCGRP1_STC1)->EnableWindow(isEnable);
            GetDlgItem(IDC_SRCGRP1_DEMAND)->
                EnableWindow(m_isSymbol_1 && isEnable);
            GetDlgItem(IDC_SRCGRP1_CPP)->
                EnableWindow(m_isSymbol_1 && isEnable);
            break;
        case    1:
            GetDlgItem(IDC_SRCGRP2_MDL)->EnableWindow(isEnable);
            GetDlgItem(IDC_SRCGRP2_INFO)->EnableWindow(isEnable);
            GetDlgItem(IDC_SRCGRP2_STC1)->EnableWindow(isEnable);
            GetDlgItem(IDC_SRCGRP2_STC2)->EnableWindow(isEnable);
            GetDlgItem(IDC_SRCGRP2_STC3)->EnableWindow(isEnable);
            GetDlgItem(IDC_SRCGRP2_STC5)->EnableWindow(isEnable);
            GetDlgItem(IDC_SRCGRP2_STC6)->EnableWindow(isEnable);
            GetDlgItem(IDC_SRCGRP2_STC7)->EnableWindow(isEnable);
            break;
        case    2:
            GetDlgItem(IDC_SRCGRP3_DIR)->EnableWindow(isEnable);
            GetDlgItem(IDC_SRCGRP3_DRV1)->EnableWindow(isEnable);
            GetDlgItem(IDC_SRCGRP3_ADD)->EnableWindow(isEnable);
            GetDlgItem(IDC_SRCGRP3_REMOVE)->EnableWindow(isEnable);
            GetDlgItem(IDC_SRCGRP3_LIST)->EnableWindow(isEnable);
            GetDlgItem(IDC_SRCGRP3_STC1)->EnableWindow(isEnable);
            GetDlgItem(IDC_SRCGRP3_STC2)->EnableWindow(isEnable);
            GetDlgItem(IDC_SRCGRP3_STC3)->EnableWindow(isEnable);
            GetDlgItem(IDC_SRCGRP3_PATH)->EnableWindow(isEnable);
            m_strPath_3 = m_vbxDir_3->GetStrProperty("Path");
            break;
        case    3:
            GetDlgItem(IDC_SRCGRP4_CR)->EnableWindow(isEnable);
            GetDlgItem(IDC_SRCGRP4_LF)->EnableWindow(isEnable);
//            GetDlgItem(IDC_SRCGRP4_STC1)->EnableWindow(isEnable);
            GetDlgItem(IDC_SRCGRP4_STC2)->EnableWindow(isEnable);
            GetDlgItem(IDC_SRCGRP4_STC3)->EnableWindow(isEnable);
//            GetDlgItem(IDC_SRCGRP4_TAB)->EnableWindow(isEnable);
            GetDlgItem(IDC_SRCGRP4_HIST)->EnableWindow(isEnable);
            break;
        case    4:
            GetDlgItem(IDC_SRCGRP5_LIST)->EnableWindow(isEnable);
            GetDlgItem(IDC_SRCGRP5_ADD)->EnableWindow(isEnable);
            GetDlgItem(IDC_SRCGRP5_REMOVE)->EnableWindow(isEnable);
            GetDlgItem(IDC_SRCGRP5_EDIT)->EnableWindow(isEnable);
            GetDlgItem(IDC_SRCGRP5_STC1)->EnableWindow(isEnable);
            break;
        case    5:
            GetDlgItem(IDC_SRCGRP6_ADD)->EnableWindow(isEnable);
            GetDlgItem(IDC_SRCGRP6_STC1)->EnableWindow(isEnable);
            GetDlgItem(IDC_SRCGRP6_STC4)->EnableWindow(isEnable);
            GetDlgItem(IDC_SRCGRP6_ENABLE)->EnableWindow(isEnable);
            GetDlgItem(IDC_SRCGRP6_DISABLE)->EnableWindow(isEnable);
            GetDlgItem(IDC_SRCGRP6_DEL)->EnableWindow(isEnable);
            GetDlgItem(IDC_SRCGRP6_DELALL)->EnableWindow(isEnable);
            GetDlgItem(IDC_SRCGRP6_SAVE)->EnableWindow(isEnable);
            GetDlgItem(IDC_SRCGRP6_RESTORE)->EnableWindow(isEnable);
            GetDlgItem(IDC_SRCGRP6_STC2)->EnableWindow(isEnable);
            GetDlgItem(IDC_SRCGRP6_STC3)->EnableWindow(isEnable);
            GetDlgItem(IDC_SRCGRP6_STC5)->EnableWindow(isEnable);
            GetDlgItem(IDC_SRCGRP6_STC6)->EnableWindow(isEnable);
            GetDlgItem(IDC_SRCGRP6_STC7)->EnableWindow(isEnable);
            GetDlgItem(IDC_SRCGRP6_ADDR)->EnableWindow(isEnable);
            GetDlgItem(IDC_SRCGRP6_ADDR1)->EnableWindow(isEnable);
            GetDlgItem(IDC_SRCGRP6_MDL)->EnableWindow(isEnable);
            GetDlgItem(IDC_SRCGRP6_LIST)->EnableWindow(isEnable);
            break;
    }
}                    

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CSourceGroup::ShowModuleInfo
//
//  Description: Show the module name, time, address range & path
//
//  Input:  
//      nIdx -- the module index of the module list box
//
//  Output: None 
//
//  Return: None
//
/////////////////////////////////////////////////////////////////////////////
void CSourceGroup::ShowModuleInfo(int nIdx)
{
    if(MdlInfo.m_uModules == 0) return;

    // Get Module Path    
    CString str, strModulePath;
    m_ListMdl_2.GetText(nIdx, str);
    if(str == "")   return;                              
    strModulePath = SrcGetModuleFullName(str);
    
    // Get Module Time           
    struct _stat buf;
    int nRval1 = _stat(strModulePath, &buf);         

    // Get Module Addr Range              
    unsigned long dwModule;
    int nRval2 = -1;                              
    unsigned long dwStart, dwEnd;
    char szBuf[50];  
    if(SrcModuleName2Index(str, dwModule) == 0) {
        nRval2 = SrcGetModuleRange(dwModule, dwStart, dwEnd);                                   
        if(nRval2 == 0)
            wsprintf(szBuf, "%04Xh..%04Xh", unsigned(dwStart), unsigned(dwEnd));
    }
                                           
    m_ListInfo_2.ResetContent();
    m_ListInfo_2.AddString(LoadInfo.m_strFile);                                           
    if(nRval1 == 0) {     
        char * cp = ctime(&buf.st_mtime);
        int l = strlen(cp);
        if(l && (cp[l-1] == '\r' || cp[l-1] == '\n'))
            cp[l-1] = '\0';
        m_ListInfo_2.AddString(cp);      
    } else m_ListInfo_2.AddString(" ");
    if(nRval2 == 0)
        m_ListInfo_2.AddString(szBuf);      
    else m_ListInfo_2.AddString(" ");
    m_ListInfo_2.AddString(strModulePath);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Set the text of the editor control of BP card, the text is 
//               built by the module name and the function name
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CSourceGroup::SetBPEditText(void)
{
    char pszName[256];
    CString str, str1;             
    int i, nSel;

    
    // Get module name
    nSel = m_cmbMdl_6.GetCurSel();
    if(nSel == LB_ERR) str = "";
    else {
        m_cmbMdl_6.GetLBText(nSel, str); 
        if(str.GetLength() > 0) {
            strcpy(pszName, str);
            for(i = 0; isspace(pszName[i]); i++) ;
            if(pszName[i] != '\0') {
                str = "#";
                str += pszName + i;
            }
            else str = "";                   
        }                
    }
                          
    // Get function name                      
    nSel = m_CmbAddr_6.GetCurSel();
    if(nSel == LB_ERR) str1 = "";
    else {
        m_CmbAddr_6.GetLBText(nSel, str1); 
        if(str1.GetLength() > 0) {
            strcpy(pszName, str1);
            for(i = 0; isspace(pszName[i]); i++) ;
            if(pszName[i] != '\0') {
                str1 = "#";
                str1 += pszName + i;
            }
            else str1 = "";                   
        }                   
    }
        
    // Set editor text
    str += str1;
    m_edAddr1_6.SetWindowText(str);    
}

BEGIN_MESSAGE_MAP(CSourceGroup, CDialog)
    //{{AFX_MSG_MAP(CSourceGroup)
    ON_VBXEVENT(VBN_TABPAGEACTIVATE, IDC_SRCTAB, OnTabpageactivateSrctab)
    ON_VBXEVENT(VBN_TABPAGESHOWN, IDC_SRCTAB, OnTabpageshownSrctab)
    ON_VBXEVENT(VBN_CHANGE, IDC_SRCGRP3_DIR, OnChangeSrcgrp3Dir)
    ON_BN_CLICKED(IDC_SRCGRP3_ADD, OnSrcgrp3Add)
    ON_BN_CLICKED(IDC_SRCGRP3_REMOVE, OnSrcgrp3Remove)
    ON_BN_CLICKED(IDC_SRCGRP1_SYMBOL, OnSrcgrp1Symbol)
    ON_BN_CLICKED(IDC_SRCGRP5_REMOVE, OnSrcgrp5Remove)
    ON_BN_CLICKED(IDC_SRCGRP5_ADD, OnSrcgrp5Add)
    ON_BN_CLICKED(IDC_SRCGRP5_EDIT, OnSrcgrp5Edit)
    ON_LBN_SELCHANGE(IDC_SRCGRP2_MDL, OnSelchangeSrcgrp2Mdl)
    ON_BN_CLICKED(IDC_SRCGRP6_ADD, OnSrcgrp6Add)
    ON_BN_CLICKED(IDC_SRCGRP6_DEL, OnSrcgrp6Del)
    ON_BN_CLICKED(IDC_SRCGRP6_DELALL, OnSrcgrp6Delall)
    ON_CBN_SELCHANGE(IDC_SRCGRP6_MDL, OnSelchangeSrcgrp6Mdl)
    ON_BN_CLICKED(IDC_SRCGRP6_ENABLE, OnSrcgrp6Enable)
    ON_BN_CLICKED(IDC_SRCGRP6_DISABLE, OnSrcgrp6Disable)
    ON_LBN_SELCHANGE(IDC_SRCGRP6_LIST, OnSelchangeSrcgrp6List)
    ON_CBN_SELCHANGE(IDC_SRCGRP6_ADDR, OnSelchangeSrcgrp6Addr)
    ON_BN_CLICKED(IDC_SRCGRP6_SAVE, OnSrcgrp6Save)
    ON_BN_CLICKED(IDC_SRCGRP6_RESTORE, OnSrcgrp6Restore)
    ON_CBN_SELCHANGE(IDC_SRCGRP3_DRV1, OnSelchangeSrcgrp3Drv1)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CSourceGroup message handlers

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL CSourceGroup::OnInitDialog()
{
    CDialog::OnInitDialog();
    
    // TODO: Add extra initialization here    
    CenterWindow();
    
    int i;
    char pszName[256];           
    
    GetDlgItem(IDC_SRCGRP1_STC1)->ShowWindow(SW_HIDE);
    GetDlgItem(IDC_SRCGRP2_STC2)->ShowWindow(SW_HIDE);
    GetDlgItem(IDC_SRCGRP3_DIR)->ShowWindow(SW_HIDE);
    GetDlgItem(IDC_SRCGRP4_STC3)->ShowWindow(SW_HIDE);
    GetDlgItem(IDC_SRCGRP6_STC1)->ShowWindow(SW_HIDE);
    GetDlgItem(IDC_SRCGRP6_STC4)->ShowWindow(SW_HIDE);
    
    m_vbxTab->SetNumProperty("ActiveTab", m_nTab);    
     
    if(MdlInfo.m_uModules > 0) {
        for(i = 0; i < int(MdlInfo.m_uModules); i ++) {
    		if(SrcCheckModuleHasLineInfo(MdlInfo.m_pModule[i]) != 0)	
    			continue;
            if(SrcGetModuleName(MdlInfo.m_pModule[i], pszName) == 0) {           
                if(pszName[0] != '?')
                    m_ListMdl_2.AddString(pszName);                      
            }             
        }                                    
        if(m_ListMdl_2.GetCount()) {    
            m_ListMdl_2.SetCurSel(0);
            ShowModuleInfo(0);           
        }    
    }
    m_ListInfo_2.SetHorizontalExtent(1000);
    
    i = _getdrive();                                   
    CString str(char(i - 1 + int('a')));
    str += ':';
    
    m_cmbDrv_3.Dir(DDL_EXCLUSIVE|DDL_DRIVES, str);
    str = "[-";
    str += char(i - 1 + int('a'));
    m_cmbDrv_3.SelectString(-1, str);

    POSITION pos = SrcPathList.GetHeadPosition();
    while(pos) {
        m_ListPath_3.AddString(SrcPathList.GetNext(pos));
    }
    m_ListPath_3.SetHorizontalExtent(1000);

    pos = ExtList.GetHeadPosition();
    while(pos) {
        m_List_5.AddString(ExtList.GetNext(pos));
    }
    
    if(MdlInfo.m_uModules > 0) {
        // Fill module combobox
        for(i = 0; i < int(MdlInfo.m_uModules); i ++) {
            if(SrcGetModuleName(MdlInfo.m_pModule[i], pszName) == 0)
                m_cmbMdl_6.AddString(pszName);            
        }    
        m_cmbMdl_6.SetCurSel(0);
        
        // Fill function combobox
        char szFunc[100];
        unsigned long dwFunc1, dwFunc2;
        if(SrcGetFirstFuncIndex(MdlInfo.m_pModule[0], dwFunc1) == 0) {   
            for( ;;dwFunc1 = dwFunc2) {
                if(SrcGetNextFunc(dwFunc1, szFunc, dwFunc2) != 0)   break;
                m_CmbAddr_6.AddString(szFunc);        
            }   
            m_CmbAddr_6.SetCurSel(0);
        }
    
        // Fill address editor
        SetBPEditText();
    }               
    
    unsigned short uAddr;
    unsigned short uLine;
    unsigned long dwModule;
    CString str1;           
    BYTE eFlag;
    for(i = 0; ;i++) {
        if(!BptGetOneBpt((short)i, &uAddr)) break;
        BptSearchBpt(uAddr, eFlag);
        if(eFlag)   str = "+";
        else str = "-";
        wsprintf(pszName, "   %04X  ", uAddr);
        str += pszName;
                     
        str1 = BPAddr2Sym(uAddr);
        if(str1 != "")  str += str1;                     
        else if(SrcAddr2Linenum(uAddr, uLine, dwModule) == 0) {
            if(SrcGetModuleName(dwModule, pszName) == 0) {
                str += "#";
                str += pszName;                           
            }
            wsprintf(pszName, "#%u", uLine);
            str += pszName;
        }                       
        m_List_6.AddString(str);
    }
    m_List_6.SetHorizontalExtent(1000);
    GetDlgItem(IDC_SRCGRP6_ENABLE)->EnableWindow(FALSE);
    GetDlgItem(IDC_SRCGRP6_DISABLE)->EnableWindow(FALSE);
    GetDlgItem(IDC_SRCGRP6_DEL)->EnableWindow(FALSE);
    if(m_List_6.GetCount() == 0) {
        GetDlgItem(IDC_SRCGRP6_DELALL)->EnableWindow(FALSE);
    }
    
    return TRUE;  // return TRUE  unless you set the focus to a control
}
                                    
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CSourceGroup::OnOK()
{
    // TODO: Add extra validation here
    UpdateData(TRUE);
    
/*    if(SrcOpt.Str2Tab(m_strTab_4) == -1) {
        AfxMessageBox("Entered Tab Width Error");   
//      m_vbxTab->SetNumProperty("ActiveTab", 3);    
        return; 
    } else */if(SrcOpt.Str2Hist(m_strHist_4) == -1) {
        AfxMessageBox("Entered Browser History Depth Error");   
//      m_vbxTab->SetNumProperty("ActiveTab", 3);    
        return; 
    }                       
    
    int n, i;
    CString str;
    
    LoadOpt.m_isCode = m_isCode_1;
    //LoadOpt.m_isCpp = m_isCpp_1;
    LoadOpt.m_isDemand = m_isDemand_1;
    LoadOpt.m_isStatus = m_isStatus_1;
    LoadOpt.m_isSymbol = m_isSymbol_1;
    LoadOpt.m_isWarnings = m_isWarn_1;

    SrcPathList.RemoveAll();
    n = m_ListPath_3.GetCount();
    for(i = 0; i < n; i ++) {
        m_ListPath_3.GetText(i, str);
        SrcPathList.AddTail(str);   
    }   
                                    
    long l = m_vbxTab->GetNumProperty("ActiveTab");    
    if(l == 3)  SrcOpt.m_nLineDelimit = m_nCR_4;
    else    SrcOpt.m_nLineDelimit = m_nCRSave_4;
    n = SrcOpt.m_nTabWidth;
    //SrcOpt.m_nTabWidth = SrcOpt.Str2Tab(m_strTab_4);
    SrcOpt.m_isTabChanged = BOOL(n != SrcOpt.m_nTabWidth);
    SrcOpt.m_nBrowseHist = SrcOpt.Str2Hist(m_strHist_4);
    BrsMdl.SetSize(SrcOpt.m_nBrowseHist);

    ExtList.RemoveAll();
    n = m_List_5.GetCount();    
    for(i = 0; i < n; i ++) {
        m_List_5.GetText(i, str);
        ExtList.AddTail(str);   
    }   

    CDialog::OnOK();
} 

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Old tab page                                    
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CSourceGroup::OnTabpageactivateSrctab(UINT, int, CWnd*, LPVOID)
{
    // TODO: Add your VBX event notification handler code here
    long l = m_vbxTab->GetNumProperty("ActiveTab");    
    if(m_bBrowse && l!=1L)
    { 
      l=1;
      m_vbxTab->SetNumProperty("ActiveTab",l);    
      MessageBeep(-1);
      return;
    }
    if(l == 3) {    
        UpdateData(TRUE);
        m_nCRSave_4 = m_nCR_4;
    }
    ShowTabCtrl(int(l), FALSE);
}
               
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: New tab page               
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CSourceGroup::OnTabpageshownSrctab(UINT, int, CWnd*, LPVOID)
{
    // TODO: Add your VBX event notification handler code here
    long l = m_vbxTab->GetNumProperty("ActiveTab");    
    if(m_bBrowse && l!=1L)
    { 
      l=1;
      m_vbxTab->SetNumProperty("ActiveTab",l);    
      MessageBeep(-1);
    }
    
    m_nTab = int(l);
    ShowTabCtrl(m_nTab, TRUE);                              
    if(m_nTab == 1 && MdlInfo.m_uModules == 0) {
        EnableTabCtrl(m_nTab, FALSE);           
    }    
    else if(m_nTab == 2) {
    }
    else if(m_nTab == 5) {
        if(m_List_6.GetCount() == 0) {
            GetDlgItem(IDC_SRCGRP6_DEL)->EnableWindow(FALSE);
            GetDlgItem(IDC_SRCGRP6_DELALL)->EnableWindow(FALSE);
        } else {
            GetDlgItem(IDC_SRCGRP6_DEL)->EnableWindow(FALSE);
            GetDlgItem(IDC_SRCGRP6_DELALL)->EnableWindow(TRUE);
        }    
        SetBPEditText();
        m_edAddr1_6.SetFocus();
        m_edAddr1_6.SetSel(0, -1);
    }
    m_nCR_4 = m_nCRSave_4;
    UpdateData(FALSE);
}

////////////////////////// Tab 1 ////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CSourceGroup::OnSrcgrp1Symbol()
{
    // TODO: Add your control notification handler code here
    UpdateData(TRUE);        
    GetDlgItem(IDC_SRCGRP1_DEMAND)->EnableWindow(m_isSymbol_1);
    //GetDlgItem(IDC_SRCGRP1_CPP)->EnableWindow(m_isSymbol_1);
}

////////////////////////// Tab 2 ////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CSourceGroup::OnSelchangeSrcgrp2Mdl()
{
    // TODO: Add your control notification handler code here
    int i = m_ListMdl_2.GetCurSel();
    if(i == LB_ERR) return;
                              
    ShowModuleInfo(i);
}

////////////////////////// Tab 3 ////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CSourceGroup::OnChangeSrcgrp3Dir(UINT, int, CWnd*, LPVOID)
{
    // TODO: Add your VBX event notification handler code here
    
    m_strPath_3 = m_vbxDir_3->GetStrProperty("Path");
    UpdateData(FALSE);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CSourceGroup::OnSelchangeSrcgrp3Drv1()
{
    // TODO: Add your control notification handler code here
    int i = m_cmbDrv_3.GetCurSel();
    if(i == CB_ERR) return;
    
    CString str;      
    m_cmbDrv_3.GetLBText(i, str);
    
    CString str1 = str.Mid(2, 1);
    str1 += ':';
    
    m_vbxDir_3->SetStrProperty("Path", str1);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CSourceGroup::OnSrcgrp3Add()
{
    // TODO: Add your control notification handler code here
    int nCnt, i;
    CString str;
    
    nCnt = m_ListPath_3.GetCount();
    for(i = 0; i < nCnt; i ++) {
        m_ListPath_3.GetText(i, str);
        if(str.CompareNoCase(m_strPath_3) == 0) {
            ::MessageBeep(-1);
            return;
        }
    }
    
    m_ListPath_3.AddString(m_strPath_3);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CSourceGroup::OnSrcgrp3Remove()
{
    // TODO: Add your control notification handler code here
    int i = m_ListPath_3.GetCurSel();
    if(i == LB_ERR) MessageBeep(-1);
    else    m_ListPath_3.DeleteString(i);   
}

////////////////////////// Tab 5 ////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CSourceGroup::OnSrcgrp5Remove()
{
    // TODO: Add your control notification handler code here
    int i = m_List_5.GetCurSel();
    if(i == LB_ERR) MessageBeep(-1);
    else    m_List_5.DeleteString(i);   
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CSourceGroup::OnSrcgrp5Add()
{
    // TODO: Add your control notification handler code here
    int nCnt, i;
    CString str;
    
    CExtNameDialog  dlg(FALSE, "", NULL);
    if(dlg.DoModal() == IDOK) { 
        nCnt = m_List_5.GetCount();
        for(i = 0; i < nCnt; i ++) {
            m_List_5.GetText(i, str);
            if(str.CompareNoCase(dlg.m_strEdit) == 0) {
                AfxMessageBox("The extension name already added");
                return;
            }
        }
        m_List_5.AddString(dlg.m_strEdit);
    }
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CSourceGroup::OnSrcgrp5Edit()
{
    // TODO: Add your control notification handler code here
    int n = m_List_5.GetCurSel();
    if(n == LB_ERR) {
        MessageBeep(-1);
        return;
    }                   
    CString str;
    m_List_5.GetText(n, str);
    CExtNameDialog  dlg(TRUE, str, NULL);
    if(dlg.DoModal() == IDOK) {
        dlg.m_strEdit.MakeUpper();
        m_List_5.DeleteString(n);
        m_List_5.InsertString(n, dlg.m_strEdit);
    }
}

////////////////////////// Tab 6 ////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CSourceGroup::OnSelchangeSrcgrp6Mdl()
{
     // TODO: Add your control notification handler code here
    int nSel = m_cmbMdl_6.GetCurSel();
    if(nSel == LB_ERR) {
        MessageBeep(-1);
        return;
    }                  
                                                       
    m_CmbAddr_6.ResetContent();                                                       
    CString str;                   
    unsigned long dwModule;
    m_cmbMdl_6.GetLBText(nSel, str); 
    if(SrcModuleName2Index(str, dwModule) != 0) return;
    
    char szFunc[100];
    unsigned long dwFunc1, dwFunc2;
    
    if(SrcGetFirstFuncIndex(dwModule, dwFunc1) == 0) {
        for( ;;dwFunc1 = dwFunc2) {
            if(SrcGetNextFunc(dwFunc1, szFunc, dwFunc2) != 0) break;;
            m_CmbAddr_6.AddString(szFunc);        
        }                                                 
    }                                                               
    m_CmbAddr_6.SetCurSel(0);
    
    SetBPEditText();
    m_edAddr1_6.SetFocus();
    m_edAddr1_6.SetSel(0, -1);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CSourceGroup::OnSelchangeSrcgrp6Addr()
{
    // TODO: Add your control notification handler code here
    SetBPEditText();
    m_edAddr1_6.SetFocus();
    m_edAddr1_6.SetSel(0, -1);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CSourceGroup::OnSrcgrp6Add()
{
    // TODO: Add your control notification handler code here
    GetDlgItem(IDC_SRCGRP6_ENABLE)->EnableWindow(FALSE);
    GetDlgItem(IDC_SRCGRP6_DISABLE)->EnableWindow(FALSE);
    GetDlgItem(IDC_SRCGRP6_DEL)->EnableWindow(FALSE);

    CString str, str1;
    char psz[256]; 
    BYTE eFlag;
    
    m_edAddr1_6.GetWindowText(str);
    int n = str.GetLength();
    if(n == 0) {
        MessageBeep(-1);
        return;
    }                   
                
    strncpy(psz, str, 255); 
    
    // skip head white space
    for(n = 0; isspace(psz[n]); n++) ;
    if(psz[n] == '\0') {
        MessageBeep(-1);
        return;
    }                   
                    
    // Parse psz -> Address
    DWORD dwNum;
    char pszTmp[256];    
    unsigned char byTmp;
    
    if(psz[n] == '#')   strcpy(pszTmp, psz+n);
    else {
        pszTmp[0] = '#';
        strcpy(pszTmp+1, psz+n);       
    }                         
    
/*    if(SymToAddr(pszTmp, &byTmp, &dwNum) == 0) {
        str1 = str;
    } else if(!Str2Num(psz, dwNum)) {
        MessageBeep(-1);
        return;
    }*/                    

    if(!Str2Num(psz, dwNum)) {
        if(SymToAddr(pszTmp, &byTmp, &dwNum) == 0) 
            str1 = str;
        else {
            MessageBeep(-1);
            return;
        }    
    }
    
    
    // check valid addr
    if(dwNum > DWORD(0xFFFF)) {  
        MessageBeep(-1);
        return;
    }                 
    
    if(BptSearchBpt((unsigned short)dwNum, eFlag)) {
        MessageBeep(-1);
        return;
    }                 
                                       
    if(!BptAddBptfromWnd((unsigned short)dwNum)) {
        MessageBeep(-1);
        return;
    }                 
    
    unsigned short uLine;
    unsigned long dwModule;
             
    str = "+";
    wsprintf(psz, "   %04X  ", (unsigned short)dwNum);
    str += psz;                       
    if(str1 != "") {
        str += str1;
        BPAddSym(WORD(dwNum), str1);
    } else if(SrcAddr2Linenum(dwNum, uLine, dwModule) == 0) {
        if(SrcGetModuleName(dwModule, psz) == 0) {
            str += "#";
            str += psz;                           
        }
        wsprintf(psz, "#%u", uLine);
        str += psz;
    }                       
    m_List_6.AddString(str);
                                       
    GetDlgItem(IDC_SRCGRP6_DELALL)->EnableWindow(TRUE);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CSourceGroup::OnSrcgrp6Del()
{
    // TODO: Add your control notification handler code here
    GetDlgItem(IDC_SRCGRP6_ENABLE)->EnableWindow(FALSE);
    GetDlgItem(IDC_SRCGRP6_DISABLE)->EnableWindow(FALSE);
    GetDlgItem(IDC_SRCGRP6_DEL)->EnableWindow(FALSE);

    int nSel = m_List_6.GetCurSel();
    if(nSel == LB_ERR) {
        MessageBeep(-1);
        return;
    }                         
    
    unsigned short uAddr;
    if(!BptGetOneBpt((short)nSel, &uAddr)) {
        MessageBeep(-1);
        return;
    }
    if(!BptClrOneBptfromWnd(uAddr)) {    
        MessageBeep(-1);
        return;
    }
    m_List_6.DeleteString(nSel);
    BPClrSym(uAddr);
    
    if(m_List_6.GetCount() == 0) {
        GetDlgItem(IDC_SRCGRP6_DELALL)->EnableWindow(FALSE);
    }
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CSourceGroup::OnSrcgrp6Delall()
{
    // TODO: Add your control notification handler code here
    GetDlgItem(IDC_SRCGRP6_ENABLE)->EnableWindow(FALSE);
    GetDlgItem(IDC_SRCGRP6_DISABLE)->EnableWindow(FALSE);
    GetDlgItem(IDC_SRCGRP6_DEL)->EnableWindow(FALSE);

    if(!BptClrAllBptfromWnd()) {
        MessageBeep(-1);
        return;
    }
    m_List_6.ResetContent();
    BPClrSym();

    GetDlgItem(IDC_SRCGRP6_DELALL)->EnableWindow(FALSE);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CSourceGroup::OnSrcgrp6Enable()
{
    // TODO: Add your control notification handler code here
    GetDlgItem(IDC_SRCGRP6_ENABLE)->EnableWindow(FALSE);
    GetDlgItem(IDC_SRCGRP6_DISABLE)->EnableWindow(FALSE);
    GetDlgItem(IDC_SRCGRP6_DEL)->EnableWindow(FALSE);

    int nSel = m_List_6.GetCurSel();
    if(nSel == LB_ERR) {
        MessageBeep(-1);
        return;
    }          

    unsigned short uAddr;
    if(!BptGetOneBpt((short)nSel, &uAddr)) {
        MessageBeep(-1);
        return;
    }
    BYTE eFlag;
    BptSearchBpt(uAddr, eFlag);
    if(eFlag)   return;
    
    BptEnableBpt(uAddr);
                  
    CString str;                  
    m_List_6.GetText(nSel, str);
    m_List_6.DeleteString(nSel);
    str.SetAt(0, '+');
    m_List_6.InsertString(nSel, str);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CSourceGroup::OnSrcgrp6Disable()
{
    // TODO: Add your control notification handler code here
    GetDlgItem(IDC_SRCGRP6_ENABLE)->EnableWindow(FALSE);
    GetDlgItem(IDC_SRCGRP6_DISABLE)->EnableWindow(FALSE);
    GetDlgItem(IDC_SRCGRP6_DEL)->EnableWindow(FALSE);

    int nSel = m_List_6.GetCurSel();
    if(nSel == LB_ERR) {
        MessageBeep(-1);
        return;
    }          

    unsigned short uAddr;
    if(!BptGetOneBpt((short)nSel, &uAddr)) {
        MessageBeep(-1);
        return;
    }
    BYTE eFlag;
    BptSearchBpt(uAddr, eFlag);
    if(!eFlag)   return;
    
    BptDisableBpt(uAddr);
                  
    CString str;                  
    m_List_6.GetText(nSel, str);
    m_List_6.DeleteString(nSel);
    str.SetAt(0, '-');
    m_List_6.InsertString(nSel, str);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CSourceGroup::OnSelchangeSrcgrp6List()
{
    // TODO: Add your control notification handler code here
    int nSel = m_List_6.GetCurSel();
    if(nSel == LB_ERR) {
        GetDlgItem(IDC_SRCGRP6_ENABLE)->EnableWindow(FALSE);
        GetDlgItem(IDC_SRCGRP6_DISABLE)->EnableWindow(FALSE);
        GetDlgItem(IDC_SRCGRP6_DEL)->EnableWindow(FALSE);
        return;
    }    

    unsigned short uAddr;
    if(!BptGetOneBpt((short)nSel, &uAddr)) {
        GetDlgItem(IDC_SRCGRP6_ENABLE)->EnableWindow(FALSE);
        GetDlgItem(IDC_SRCGRP6_DISABLE)->EnableWindow(FALSE);
        GetDlgItem(IDC_SRCGRP6_DEL)->EnableWindow(FALSE);
        return;
    }

    BYTE eFlag;
    BptSearchBpt(uAddr, eFlag);
    GetDlgItem(IDC_SRCGRP6_ENABLE)->EnableWindow(!eFlag);
    GetDlgItem(IDC_SRCGRP6_DISABLE)->EnableWindow(eFlag);
    GetDlgItem(IDC_SRCGRP6_DEL)->EnableWindow(TRUE);
}

/////////////////////////////////////////////////////////////////////////////
class CFileCenterDialog : public CFileDialog
{
public:                         
    CFileCenterDialog( BOOL bOpenFileDialog, LPCSTR lpszDefExt = NULL, 
        LPCSTR lpszFileName = NULL, 
        DWORD dwFlags = OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, 
        LPCSTR lpszFilter = NULL, CWnd* pParentWnd = NULL )
    : CFileDialog(bOpenFileDialog, lpszDefExt, lpszFileName, dwFlags,
        lpszFilter, pParentWnd)
    {}        

    virtual BOOL OnInitDialog()
    {
        CFileDialog::OnInitDialog();
        CenterWindow();
        return TRUE;  // return TRUE  unless you set the focus to a control
    }
    
    void SetHelp(int nIDHelp) { m_nIDHelp = nIDHelp; }
};
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CSourceGroup::OnSrcgrp6Save()
{
    // TODO: Add your control notification handler code here
    CFileCenterDialog dlg(FALSE, NULL, "*.*");
    dlg.m_ofn.lpstrTitle = "Save Breakpoint";
    dlg.SetHelpID(IDD_SAVE_BP);
    if(dlg.DoModal() == IDOK) {
        CString str = dlg.GetPathName();
        //AfxMessageBox(str);
        
        extern BOOL SaveBpt(const char *);
        SaveBpt(str);
    }
    
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CSourceGroup::OnSrcgrp6Restore()
{
    // TODO: Add your control notification handler code here
    CFileCenterDialog dlg(TRUE, NULL, "*.*");
    dlg.m_ofn.lpstrTitle = "Restore Breakpoint";
    dlg.SetHelpID(IDD_RESTORE_BP);
    if(dlg.DoModal() == IDOK) {
        CString str = dlg.GetPathName();
        //AfxMessageBox(str);

        extern BOOL RestoreBpt(const char *);
        if(RestoreBpt(str)) {
            BPClrSym();
            m_List_6.ResetContent();
        
            unsigned short uAddr;
            unsigned short uLine;
            unsigned long dwModule;
            char pszName[256];
            BYTE eFlag;
            for(int i = 0; ;i++) {
                if(!BptGetOneBpt((short)i, &uAddr)) break;
                BptSearchBpt(uAddr, eFlag);
                if(eFlag)   str = "+";
                else str = "-";
                wsprintf(pszName, "   %04X  ", uAddr);
                str += pszName;
                if(SrcAddr2Linenum(uAddr, uLine, dwModule) == 0) {
                    if(SrcGetModuleName(dwModule, pszName) == 0) {
                        str += "#";
                        str += pszName;                           
                    }
                    wsprintf(pszName, "#%u", uLine);
                    str += pszName;
                }                       
                m_List_6.AddString(str);
            }
        } 
    }
}
/////////////////////////////////////////////////////////////////////////////
// CExtNameDialog dialog
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
CExtNameDialog::CExtNameDialog(BOOL isEdit, const char * str, CWnd* pParent /*=NULL*/)
    : CDialog(CExtNameDialog::IDD, NULL)
{                                           
    m_isEdit = isEdit;
    
    m_nIDHelp = m_isEdit ? IDD_EDIT_EXT : IDD_ADD_EXT;
    //{{AFX_DATA_INIT(CExtNameDialog)
    m_strEdit = str;
    //}}AFX_DATA_INIT
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CExtNameDialog::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CExtNameDialog)
    DDX_Text(pDX, IDC_EXTNAME_EDIT, m_strEdit);
    //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CExtNameDialog, CDialog)
    //{{AFX_MSG_MAP(CExtNameDialog)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CExtNameDialog message handlers

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL CExtNameDialog::OnInitDialog()
{
    CDialog::OnInitDialog();
    
    // TODO: Add extra initialization here
    CenterWindow();   
       
    if(m_isEdit)       
        SetWindowText("Edit Extension Name");
    else    
        SetWindowText("Add Extension Name");
    
    return TRUE;  // return TRUE  unless you set the focus to a control
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL IsFileNameChar(char ch)
{
    return (ch >= '0' && ch <= '9') || (ch >= 'a' && ch <= 'z') ||
        (ch >= 'A' && ch <= 'Z') || strchr("-_`@$%#&!~(){}^\'", ch);
}

void CExtNameDialog::OnOK()
{
    // TODO: Add extra validation here
    UpdateData(TRUE);
    m_strEdit.MakeUpper();     
    int nLen = m_strEdit.GetLength();
    if(nLen <= 1 || nLen > 4 || m_strEdit[0] != '.') {
        AfxMessageBox("Extension name error");
        return;
    }
    for(int i = 1; i < nLen; i ++) {
        if(!::IsFileNameChar(m_strEdit[i])) {
            AfxMessageBox("Extension name error");
            return;
        }
    }   
    
    CDialog::OnOK();
}


/////////////////////////////////////////////////////////////////////////////
// CSrcGrpDlg            
#include <afxpriv.h>
/////////////////////////////////////////////////////////////////////////////
CSrcGrpDlg::CSrcGrpDlg(int tab, CWnd* pParent, BOOL bBrowse)
    : CPropertySheet("Source Group", NULL, tab),m_bBrowse(bBrowse)
{    
   g_bBrowse=m_bBrowse; 
//   g_pPropertySheet=0;
/*
    if(m_bBrowse)
    {
       AddPage(&m_SrcBrowse);
    }   
    else
*/    
    {                  
       AddPage(&m_SrcLoadOpt);
       AddPage(&m_SrcExtName);
       AddPage(&m_SrcOpt);
       AddPage(&m_SrcBrowse);
       AddPage(&m_SrcPath);
	   AddPage(&m_SrcSetBp);
	}   
}

BEGIN_MESSAGE_MAP(CSrcGrpDlg, CPropertySheet)
    //{{AFX_MSG_MAP(CSrcGrpDlg)
    ON_WM_CREATE()
    ON_WM_SIZE()                        
	ON_MESSAGE(TCM_TABCHANGED, OnTabChanged)
	ON_COMMAND(IDCLOSE, OnClose)
	ON_COMMAND(IDOK, OnOK)
    ON_COMMAND(IDC_SRCGRP6_SAVE, OnSrcgrp6Save)
    ON_COMMAND(IDC_SRCGRP6_RESTORE, OnSrcgrp6Restore)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()
void CSrcGrpDlg::OnSrcgrp6Save()
{
  m_SrcSetBp.OnSrcgrp6Save();
}
void CSrcGrpDlg::OnSrcgrp6Restore()
{
  m_SrcSetBp.OnSrcgrp6Restore();
}

void CSrcGrpDlg::OnClose()
{ 
 OnCancel();
}

LRESULT CSrcGrpDlg::OnTabChanged(WPARAM wParam, LPARAM lParam)
{        
  LRESULT b=CPropertySheet::OnTabChanged(wParam, lParam);                          
  if(GetActivePage()==&m_SrcSetBp) 
  {
    g_nbDoBpPage=1;   
    ShowBtn(1); 
  }     
  else   
  {         
    ShowBtn(0);
    g_nbDoBpPage--;
  }     
       
  return  b;
  
}                 

/////////////////////////////////////////////////////////////////////////////
// CSrcGrpDlg message handlers

void CSrcGrpDlg::OnSize(UINT nType, int cx, int cy)    
{
    CPropertySheet::OnSize(nType, cx, cy);
      
}

void CSrcGrpDlg::OnOK()
{
	ASSERT_VALID(this);
                       
    if(((CPropertyDlg *)GetActivePage())->ExitDlg())                   
	if (GetActivePage()->OnKillActive())
	{
		GetActivePage()->OnOK();
		if (!m_bModeless)
			EndDialog(IDOK);
	}
}

int CSrcGrpDlg::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
    // Add the preview window to the property sheet.

    int nReturn;
    if ((nReturn = CPropertySheet::OnCreate(lpCreateStruct))
        != 0)
        return nReturn;          

    if(GetDlgItem(ID_APPLY_NOW))
       GetDlgItem(ID_APPLY_NOW)->ShowWindow(SW_HIDE);
       
    CenterWindow();
    
//    g_pPropertySheet=this;
//    ASSERT_VALID(g_pPropertySheet); 
    if(GetActivePage()==&m_SrcSetBp) 
    {   
       g_nbDoBpPage=1;
       ShowBtn(1);
    }   
    
    return 0;
}

void CSrcGrpDlg::ShowBtn(BOOL bShow)
{     
    CString str;                
    if(g_nbDoBpPage<0)  
       return;
       
    CWnd *pWnd=GetDescendantWindow(bShow?IDCANCEL:IDC_SRCGRP6_SAVE);
    if(pWnd)
    {
      str=bShow?"Save...":"Cancel";
      SetWindowWord(pWnd->GetSafeHwnd(), GWW_ID, (WORD)(bShow?IDC_SRCGRP6_SAVE:IDCANCEL));
      pWnd->SetWindowText(str);
    }    

    pWnd=GetDescendantWindow(bShow?IDOK:IDCLOSE);
    if(pWnd)
    {   
      str=bShow?"Close":"Ok";
      SetWindowWord(pWnd->GetSafeHwnd(), GWW_ID, (WORD)(bShow?IDCLOSE:IDOK));
      pWnd->SetWindowText(str);
    }    

    pWnd=GetDescendantWindow(bShow?ID_APPLY_NOW:IDC_SRCGRP6_RESTORE);
    if(pWnd)
    {
      str=bShow?"Restore...":"Apply";
      SetWindowWord(pWnd->GetSafeHwnd(), GWW_ID, (WORD)(bShow?IDC_SRCGRP6_RESTORE:ID_APPLY_NOW));
      pWnd->SetWindowText(str);      
      pWnd->ShowWindow(bShow?SW_SHOW:SW_HIDE);
      pWnd->EnableWindow(bShow);
    }    
}

/////////////////////////////////////////////////////////////////////////////
// CProperty dialog

CPropertyDlg::CPropertyDlg(UINT IDD)
: CPropertyPage(IDD)
{
};                 

BOOL CPropertyDlg::ExitDlg()
{
  return 1;
};

CPropertyDlg::~CPropertyDlg()
{};

/////////////////////////////////////////////////////////////////////////////
// CSrcLoadOpt dialog


CSrcLoadOpt::CSrcLoadOpt()
	: CPropertyDlg(CSrcLoadOpt::IDD)
{
	//{{AFX_DATA_INIT(CSrcLoadOpt)
		// NOTE: the ClassWizard will add member initialization here
    m_isCode_1     = LoadOpt.m_isCode;
//    m_isCpp_1      = LoadOpt.m_isCpp;
    m_isDemand_1   = LoadOpt.m_isDemand;
    m_isStatus_1   = LoadOpt.m_isStatus;
    m_isSymbol_1   = LoadOpt.m_isSymbol;
    m_isWarn_1     = LoadOpt.m_isWarnings;
		
	//}}AFX_DATA_INIT
}

void CSrcLoadOpt::DoDataExchange(CDataExchange* pDX)
{
	CPropertyDlg::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSrcLoadOpt)
		// NOTE: the ClassWizard will add DDX and DDV calls here
    DDX_Check(pDX, IDC_SRCGRP1_CODE, m_isCode_1);
 //   DDX_Check(pDX, IDC_SRCGRP1_CPP, m_isCpp_1);
    DDX_Check(pDX, IDC_SRCGRP1_DEMAND, m_isDemand_1);
    DDX_Check(pDX, IDC_SRCGRP1_STATUS, m_isStatus_1);
    DDX_Check(pDX, IDC_SRCGRP1_SYMBOL, m_isSymbol_1);
    DDX_Check(pDX, IDC_SRCGRP1_WARN, m_isWarn_1);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSrcLoadOpt, CPropertyDlg)
	//{{AFX_MSG_MAP(CSrcLoadOpt)
		// NOTE: the ClassWizard will add message map macros here
    ON_BN_CLICKED(IDC_SRCGRP1_SYMBOL, OnSrcgrp1Symbol)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSrcLoadOpt message handlers                   
BOOL CSrcLoadOpt::OnSetActive()
{                 
   m_nIDHelp = IDD_SRCGRP_LOADOPTION;
   return CPropertyDlg::OnSetActive();
}
/* OnInitDialog ---------------------------------------------------*/
/*-----------------------------------------------------------------*/
BOOL CSrcLoadOpt::OnInitDialog()
{
	return CPropertyDlg::OnInitDialog();
}

void CSrcLoadOpt::OnSrcgrp1Symbol()
{
    // TODO: Add your control notification handler code here
    UpdateData(TRUE);        
    CWnd *pWnd=GetDlgItem(IDC_SRCGRP1_DEMAND);
    if(pWnd)
       pWnd->EnableWindow(m_isSymbol_1);
}


void CSrcLoadOpt::OnOK()
{
  UpdateData(TRUE);
  LoadOpt.m_isCode = m_isCode_1;
  //LoadOpt.m_isCpp = m_isCpp_1;
  LoadOpt.m_isDemand = m_isDemand_1;
  LoadOpt.m_isStatus = m_isStatus_1;
  LoadOpt.m_isSymbol = m_isSymbol_1;
  LoadOpt.m_isWarnings = m_isWarn_1;
  CPropertyDlg::OnOK();
}
/////////////////////////////////////////////////////////////////////////////
// CSrcExtName dialog


CSrcExtName::CSrcExtName()
	: CPropertyDlg(CSrcExtName::IDD)
{
	//{{AFX_DATA_INIT(CSrcExtName)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}

void CSrcExtName::DoDataExchange(CDataExchange* pDX)
{
	CPropertyDlg::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSrcExtName)
		// NOTE: the ClassWizard will add DDX and DDV calls here
    DDX_Control(pDX, IDC_SRCGRP5_LIST, m_List_5);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSrcExtName, CPropertyDlg)
	//{{AFX_MSG_MAP(CSrcExtName)
		// NOTE: the ClassWizard will add message map macros here
    ON_COMMAND(IDC_SRCGRP5_REMOVE, OnSrcgrp5Remove)
    ON_COMMAND(IDC_SRCGRP5_ADD, OnSrcgrp5Add)
    ON_COMMAND(IDC_SRCGRP5_EDIT, OnSrcgrp5Edit)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CSrcExtName message handlers

BOOL CSrcExtName::OnSetActive()
{                 
   m_nIDHelp = IDD_SRCGRP_EXTENSION;
   return CPropertyDlg::OnSetActive();
}
/* OnInitDialog ---------------------------------------------------*/
/*-----------------------------------------------------------------*/
BOOL CSrcExtName::OnInitDialog()
{
	CPropertyDlg::OnInitDialog();
    // TODO: Add extra initialization here    
    POSITION pos = ExtList.GetHeadPosition();
    while(pos) {
        m_List_5.AddString(ExtList.GetNext(pos));
    }
    
    return TRUE;  // return TRUE  unless you set the focus to a control
}

/* OnSrcgrp5Remove ------------------------------------------------*/
/*-----------------------------------------------------------------*/
void CSrcExtName::OnSrcgrp5Remove()
{
    // TODO: Add your control notification handler code here
    int i = m_List_5.GetCurSel();
    if(i == LB_ERR) MessageBeep(-1);
    else    m_List_5.DeleteString(i);   
}                  

/* OnSrcgrp5Add ---------------------------------------------------*/
/*-----------------------------------------------------------------*/
void CSrcExtName::OnSrcgrp5Add()
{ 
    int nCnt, i;
    CString str;
    
    CExtNameDialog  dlg(FALSE, "", this);
    if(dlg.DoModal() == IDOK) { 
        nCnt = m_List_5.GetCount();
        for(i = 0; i < nCnt; i ++) {
            m_List_5.GetText(i, str);
            if(str.CompareNoCase(dlg.m_strEdit) == 0) {
                AfxMessageBox("The extension name already added");
                return;
            }
        }
        m_List_5.AddString(dlg.m_strEdit);
    }

}

/* OnSrcgrp5Edit --------------------------------------------------*/
/*-----------------------------------------------------------------*/
void CSrcExtName::OnSrcgrp5Edit()
{
    int n = m_List_5.GetCurSel();
    if(n == LB_ERR) {
        MessageBeep(-1);
        return;
    }                   
    CString str;
    m_List_5.GetText(n, str);
    CExtNameDialog  dlg(TRUE, str, this);
    if(dlg.DoModal() == IDOK) {
        int nCnt = m_List_5.GetCount();
        for(int i = 0; i < nCnt; i ++) {
            m_List_5.GetText(i, str);
            if(str.CompareNoCase(dlg.m_strEdit) == 0) {
                MessageBeep(-1);
                AfxMessageBox("The extension name already added");
                return;
            }   
        }    
        dlg.m_strEdit.MakeUpper();
        m_List_5.DeleteString(n);
        m_List_5.InsertString(n, dlg.m_strEdit);
    }
}

/* OnSrcgrp5Ok ----------------------------------------------------*/
/*-----------------------------------------------------------------*/
void CSrcExtName::OnOK()
{
    UpdateData(TRUE);     
    CString str;
    ExtList.RemoveAll();
    int n = m_List_5.GetCount();    
    for(int i = 0; i < n; i ++) {
        m_List_5.GetText(i, str);
        ExtList.AddTail(str);   
    }                   
    CPropertyDlg::OnOK();
}

/////////////////////////////////////////////////////////////////////////////
// CSrcOpt dialog


CSrcOpt::CSrcOpt()
	: CPropertyDlg(CSrcOpt::IDD)
{
	//{{AFX_DATA_INIT(CSrcOpt)
		// NOTE: the ClassWizard will add member initialization here
    m_nCR_4 = SrcOpt.m_nLineDelimit;
	//}}AFX_DATA_INIT
    char psz[10];
//    wsprintf(psz, "%d", SrcOpt.m_nTabWidth);
//    m_strTab_4 = psz;
    wsprintf(psz, "%d", SrcOpt.m_nBrowseHist);
    m_strHist_4 = psz;
    m_nCRSave_4 = m_nCR_4;
}

void CSrcOpt::DoDataExchange(CDataExchange* pDX)
{
	CPropertyDlg::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSrcOpt)
		// NOTE: the ClassWizard will add DDX and DDV calls here
    DDX_Radio(pDX, IDC_SRCGRP4_CR, m_nCR_4);
    DDX_Text(pDX, IDC_SRCGRP4_HIST, m_strHist_4);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSrcOpt, CPropertyDlg)
	//{{AFX_MSG_MAP(CSrcOpt)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CSrcOpt message handlers
BOOL CSrcOpt::OnSetActive()
{                 
   m_nIDHelp = IDD_SRCGRP_SOURCEOPTION;
   return CPropertyDlg::OnSetActive();
}
/* OnInitDialog ---------------------------------------------------*/
/*-----------------------------------------------------------------*/
BOOL CSrcOpt::OnInitDialog()
{
	return CPropertyDlg::OnInitDialog();
}             

BOOL CSrcOpt::ExitDlg()
{
    UpdateData(TRUE);           

    SrcOpt.m_nLineDelimit = m_nCR_4;

    int nBrowseHist=SrcOpt.Str2Hist(m_strHist_4);
    if(nBrowseHist<0) 
    {  
       MessageBeep(-1);
       AfxMessageBox("\"Browse History Depth\" vaule input error!");
       CWnd *pWnd=GetDlgItem(IDC_SRCGRP4_HIST);
       if(pWnd)
          pWnd->SetFocus();
       return 0;   
    }   
       
    SrcOpt.m_nBrowseHist = nBrowseHist;
    BrsMdl.SetSize(SrcOpt.m_nBrowseHist);
    return 1;
}
void CSrcOpt::OnOK()
{
/*
    // TODO: Add extra validation here
    UpdateData(TRUE);           

    SrcOpt.m_nLineDelimit = m_nCR_4;

    int nBrowseHist=SrcOpt.Str2Hist(m_strHist_4);
    if(nBrowseHist<0) 
       AfxMessageBox("\"Browse History Depth\" vaule input error!");
       
    SrcOpt.m_nBrowseHist = nBrowseHist;
    BrsMdl.SetSize(SrcOpt.m_nBrowseHist);
*/    
    CPropertyDlg::OnOK();
} 

/////////////////////////////////////////////////////////////////////////////
// CSrcBrowse dialog


CSrcBrowse::CSrcBrowse()
	: CPropertyDlg(CSrcBrowse::IDD)
{
	//{{AFX_DATA_INIT(CSrcBrowse)
		// NOTE: the ClassWizard will add member initialization here
    m_strInfo_2 = "";
    m_strMdl_2 = "";
		
	//}}AFX_DATA_INIT
}

void CSrcBrowse::DoDataExchange(CDataExchange* pDX)
{
	CPropertyDlg::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSrcBrowse)
		// NOTE: the ClassWizard will add DDX and DDV calls here
    DDX_LBString(pDX, IDC_SRCGRP2_INFO, m_strInfo_2);
    DDX_LBString(pDX, IDC_SRCGRP2_MDL, m_strMdl_2);
    DDX_Control(pDX, IDC_SRCGRP2_MDL, m_ListMdl_2);
    DDX_Control(pDX, IDC_SRCGRP2_INFO, m_ListInfo_2);
	//}}AFX_DATA_MAP
}    

BOOL CSrcBrowse::OnSetActive()
{                 
   m_nIDHelp = IDD_SRCGRP_BROWSEMODULE;
   return CPropertyDlg::OnSetActive();
}

BOOL CSrcBrowse::OnInitDialog()
{
	CPropertyDlg::OnInitDialog();
	char pszName[256];
	// TODO: Add extra initialization here
    if((g_bBrowse ? bwsMdlInfo.m_uModules :MdlInfo.m_uModules) > 0) {
        for(int i = 0; 
            i < int(g_bBrowse ? bwsMdlInfo.m_uModules :MdlInfo.m_uModules); 
            i ++) {
    		if(SrcCheckModuleHasLineInfo(
    		      (g_bBrowse ? bwsMdlInfo.m_pModule[i]:MdlInfo.m_pModule[i]) != 0
    		      	                     ))
    			continue;
            if(SrcGetModuleName(
                (g_bBrowse ? bwsMdlInfo.m_pModule[i]:MdlInfo.m_pModule[i]),
                pszName) == 0) {           
                if(pszName[0] != '?')
                    m_ListMdl_2.AddString(pszName);                      
            }             
        }                                    
        if(m_ListMdl_2.GetCount()) {    
            m_ListMdl_2.SetCurSel(0);
            ShowModuleInfo(0);           
        }    
    }
    m_ListInfo_2.SetHorizontalExtent(1000);
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CSrcBrowse::ShowModuleInfo(int nIdx)
{
	
    if((g_bBrowse ? bwsMdlInfo.m_uModules:MdlInfo.m_uModules) == 0) return;

    // Get Module Path    
    CString str, strModulePath;
    m_ListMdl_2.GetText(nIdx, str);
    if(str == "")   return;                              
    strModulePath = SrcGetModuleFullName(str);
    
    // Get Module Time           
    struct _stat buf;
    int nRval1 = _stat(strModulePath, &buf);         

    // Get Module Addr Range              
    unsigned long dwModule;
    int nRval2 = -1;                              
    unsigned long dwStart, dwEnd;
    char szBuf[50];  
    if(SrcModuleName2Index(str, dwModule) == 0) {
        nRval2 = SrcGetModuleRange(dwModule, dwStart, dwEnd);                                   
        if(nRval2 == 0)
            wsprintf(szBuf, "%04Xh..%04Xh", unsigned(dwStart), unsigned(dwEnd));
    }
                                           
    m_ListInfo_2.ResetContent();
    m_ListInfo_2.AddString(LoadInfo.m_strFile);                                           
    if(nRval1 == 0) {     
        char * cp = ctime(&buf.st_mtime);
        int l = strlen(cp);
        if(l && (cp[l-1] == '\r' || cp[l-1] == '\n'))
            cp[l-1] = '\0';
        m_ListInfo_2.AddString(cp);      
    } else m_ListInfo_2.AddString(" ");
    if(nRval2 == 0)
        m_ListInfo_2.AddString(szBuf);      
    else m_ListInfo_2.AddString(" ");
    m_ListInfo_2.AddString(strModulePath);
}                                
           
           
void CSrcBrowse::OnOK()
{
  UpdateData(TRUE);
  
  if(g_bBrowse)
  {                      
     BwsSetText();
     DoBwsBrowseModule(*this);
  }   
  else               
  {               
     SrcSetText();
     DoBrowseModule(*this);
  }                 
  
  CPropertyDlg::OnOK();
}



BEGIN_MESSAGE_MAP(CSrcBrowse,CPropertyDlg)
	//{{AFX_MSG_MAP(CSrcBrowse)
		// NOTE: the ClassWizard will add message map macros here
	    ON_LBN_SELCHANGE(IDC_SRCGRP2_MDL, OnSelchangeSrcgrp2Mdl)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CSrcBrowse message handlers
void CSrcBrowse::OnSelchangeSrcgrp2Mdl()
{
    // TODO: Add your control notification handler code here
    int i = m_ListMdl_2.GetCurSel();
    if(i == LB_ERR) return;
                              
    ShowModuleInfo(i);
}

/////////////////////////////////////////////////////////////////////////////
// CSrcPath dialog


CSrcPath::CSrcPath()
	: CPropertyDlg(CSrcPath::IDD)
{
	//{{AFX_DATA_INIT(CSrcPath)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}

void CSrcPath::DoDataExchange(CDataExchange* pDX)
{
	CPropertyDlg::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSrcPath)
		// NOTE: the ClassWizard will add DDX and DDV calls here
    //DDX_Text(pDX, IDC_SRCGRP3_PATH, m_strPath_3);
    DDX_Control(pDX, IDC_SRCGRP3_PATH, m_Path);
    DDX_Control(pDX, IDC_SRCGRP3_DRV1, m_Drv);
    DDX_Control(pDX, IDC_SRCGRP3_DIR,  m_List_Dir);
    DDX_Control(pDX, IDC_LIST,  m_List);

    DDX_Control(pDX, IDC_SRCGRP3_LIST, m_ListPath_3);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSrcPath, CPropertyDlg)
	//{{AFX_MSG_MAP(CSrcPath)
		// NOTE: the ClassWizard will add message map macros here
//	ON_MESSAGE(XM_SHOWDIR,OnShowDir)
	ON_CBN_SELCHANGE(IDC_SRCGRP3_DRV1, OnSelchangeComboDrv)
	ON_LBN_DBLCLK(IDC_SRCGRP3_DIR, OnDblclkListDir)

    ON_BN_CLICKED(IDC_SRCGRP3_ADD, OnSrcgrp3Add)
    ON_BN_CLICKED(IDC_SRCGRP3_REMOVE, OnSrcgrp3Remove)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CSrcPath message handlers

BOOL CSrcPath::OnSetActive()
{                 
   m_nIDHelp = IDD_SRCGRP_SOURCEPATH;
   return CPropertyDlg::OnSetActive();
}

BOOL CSrcPath::OnInitDialog()
{
    CPropertyDlg::OnInitDialog();
    POSITION pos = SrcPathList.GetHeadPosition();
    while(pos) {
        m_ListPath_3.AddString(SrcPathList.GetNext(pos));
    }
    m_ListPath_3.SetHorizontalExtent(1000);


	m_nDrv = _getdrive();                                   

	char szPath[256];
    _getdcwd(m_nDrv,szPath,255);
    GetDrv();
    OnShowDir(szPath);
  
//    PostMessage(XM_SHOWDIR);
    

    return TRUE;
}
    
/* GetDrv ---------------------------------------------------------*/
/*-----------------------------------------------------------------*/
void CSrcPath::GetDrv()
{
	CString str; 

    str=char(m_nDrv - 1 + int('a'));
    str += ':';
    
    m_Drv.Dir(DDL_EXCLUSIVE|DDL_DRIVES, str);
    str = "[-";
    str += char(m_nDrv - 1 + int('a'));
    m_Drv.SelectString(-1, str);
}            

/* OnShowDir ------------------------------------------------------*/
/*-----------------------------------------------------------------*/
void CSrcPath::OnShowDir(LPCSTR szPath)
{    
  if(szPath==NULL)
     return;
  int nLen=lstrlen(szPath);                   
  if(szPath[nLen-1]=='\\')
     nLen--;
  CString strPath(szPath, nLen);
  strPath.MakeUpper();
  m_Path.SetWindowText(strPath);  
                                           
  LPSTR token=_fstrtok((LPSTR)(LPCSTR)strPath,"\\"); 
  m_nSpec=0;
  m_List_Dir.ResetContent();
  while(token!=NULL)
  {         
    CString str(' ',m_nSpec*2);
    str+=token ;
    if(m_nSpec==0)
       str+='\\';
    m_List_Dir.AddString(str);
    m_nSpec++;                   
    token=_fstrtok(NULL,"\\"); 
  }
//////////////////////////////////////
// add to list box
  struct _find_t c_file;
  CString strSpec(' ',m_nSpec*2);
  CString strOld;
  if(   _chdrive(toupper(szPath[0])-'A'+1)!=0
     || _chdir(szPath)!=0
     || _dos_findfirst("*", _A_SUBDIR, &c_file)!=0)
     return;
  strOld=strPath;   
  strPath.Empty();
  strPath=strSpec;
  strPath+=c_file.name;
  if(c_file.name[0]!='.' && c_file.name[1]!='.')
     m_List_Dir.AddString(strPath);
  int nCount=0;

  while(_dos_findnext(&c_file)==0&&nCount<256)
  {   
      nCount++;   
      CString path(szPath, nLen);
	  strPath=strSpec+c_file.name;      
	  path+='\\';
	  path+=c_file.name;
	  if(_chdir(path)!=0)
	     continue;
	  if(c_file.name[0]!='.' && c_file.name[1]!='.')
	     m_List_Dir.AddString(strPath);
  }
  
}
/* OnSelchangeComboDrv --------------------------------------------*/
/*-----------------------------------------------------------------*/
void CSrcPath::OnSelchangeComboDrv()
{
	// TODO: Add your control notification handler code here
	AfxGetApp()->DoWaitCursor(0);
	AfxGetApp()->DoWaitCursor(1);
	int nIndex=m_Drv.GetCurSel();
	CString str;
	
	if(nIndex!=CB_ERR)
	{
	  m_Drv.GetLBText(nIndex,str);
	  int nDrv=str[2]-'a'+1;
	  if((nDrv)!=m_nDrv)
	  {           
	    char szPath[256];
	    if(_getdcwd(nDrv,szPath,255)==NULL)
	    {                        
	      MessageBeep(-1);    
	      CString strErr;
	      strErr.Format("Can not read drive %c:\nMake sure drive door ids closed and that the disk is formatted and free of errors!",
	                    str[2]);
	      MessageBox(strErr, NULL, MB_OK|MB_ICONEXCLAMATION);
          str = "[-";
          str += char(m_nDrv - 1 + int('a'));
          m_Drv.SelectString(-1, str);
	    }               
	    else
	    {               
			m_nDrv = nDrv;                                   
			char szPath[256];
		    _getdcwd(m_nDrv,szPath,255);
		    OnShowDir(szPath);
	    }              
	    
	  }                          
	}                            
	AfxGetApp()->DoWaitCursor(-1);
}

/* OnDblclkListDir ------------------------------------------------*/
/*-----------------------------------------------------------------*/
void CSrcPath::OnDblclkListDir()
{
	// TODO: Add your control notification handler code here
	char szPath[256];
	int nIndex=m_List_Dir.GetCurSel();
	if(nIndex==LB_ERR)
	   return;
	   
	CString strPath;  
	if(nIndex!=LB_ERR)
	{
	   if(nIndex==0) 
	   {  
	     CString str=char(m_nDrv+'a'-1);
	     str+=":\\";        
	     OnShowDir(str);
	     /*
		 GetDir((LPSTR)(LPCSTR)str);
		 PostMessage(XM_SHOWDIR);
	     */
	   }
       else if(m_nSpec<=nIndex)
       {
         m_Path.GetWindowText(strPath);
         m_List_Dir.GetText(nIndex, szPath);
         if(strPath[strPath.GetLength()-1]!='\\')
            strPath+="\\";
         strPath+=&szPath[m_nSpec*2];
         OnShowDir(strPath);
         /*
		 GetDir((LPSTR)(LPCSTR)strPath);
		 PostMessage(XM_SHOWDIR);
         */
       }
       else if(m_nSpec>nIndex && nIndex>0)
       {
         m_Path.GetWindowText(strPath);
         m_List_Dir.GetText(nIndex, szPath);
         int i=0;
         while(szPath[i++]==' ');
         
         int nIndex=strPath.Find((LPCSTR)&szPath[i-1]);
         CString str=strPath.Mid(0,nIndex+lstrlen(szPath)-i+1);
         str+='\\';
         OnShowDir(str);
         /*
   		 GetDir((LPSTR)(LPCSTR)str);
		 PostMessage(XM_SHOWDIR);
         */
       }
	}
}


/* OnChangeSrcgrp3Dir ---------------------------------------------*/
/*-----------------------------------------------------------------*/
/*
void CSrcPath::OnChangeSrcgrp3Dir(UINT, int, CWnd*, LPVOID)
{
    // TODO: Add your VBX event notification handler code here

    if(m_vbxDir_3)
       m_strPath_3 = m_vbxDir_3->GetStrProperty("Path");    
    UpdateData(FALSE);
}
*/

/* OnSrcgrp3Add ---------------------------------------------------*/
/*-----------------------------------------------------------------*/
void CSrcPath::OnSrcgrp3Add()
{
    // TODO: Add your control notification handler code here
    int nCnt, i;
    CString str;
    CString strPath;
    m_Path.GetWindowText(strPath);
    if(strPath[strPath.GetLength()-1]!='\\')
       strPath+='\\';
    
    nCnt = m_ListPath_3.GetCount();
    for(i = 0; i < nCnt; i ++) {
        m_ListPath_3.GetText(i, str);
        if(str.CompareNoCase(strPath) == 0) {
            ::MessageBeep(-1);
            return;
        }
    }      
    
    strPath.MakeUpper();
    m_ListPath_3.AddString(strPath);
}

/* OnSrcgrp3Remove ------------------------------------------------*/
/*-----------------------------------------------------------------*/
void CSrcPath::OnSrcgrp3Remove()
{
    // TODO: Add your control notification handler code here
    int i = m_ListPath_3.GetCurSel();
    if(i == LB_ERR) MessageBeep(-1);
    else    m_ListPath_3.DeleteString(i);   
}

/* OnSelchangeSrcgrp3Drv1 -----------------------------------------*/
/*-----------------------------------------------------------------*/
/*
void CSrcPath::OnSelchangeSrcgrp3Drv1()
{
    // TODO: Add your control notification handler code here
    int i = m_cmbDrv_3.GetCurSel();
    if(i == CB_ERR) return;
    
    CString str;      
    m_cmbDrv_3.GetLBText(i, str);
    
    CString str1 = str.Mid(2, 1);
    str1 += ':';
    
    if(m_vbxDir_3)    
       m_vbxDir_3->SetStrProperty("Path", str1);
}
*/
/////////////////////////////////////////////////////////////////////////////
// CSrcPath message handlers

/* OnOk ----------------------------------------------------------*/
/*-----------------------------------------------------------------*/

void CSrcPath::OnOK()
{   
    UpdateData(TRUE); 
    CString str;
    SrcPathList.RemoveAll();
    int n = m_ListPath_3.GetCount();
    for(int i = 0; i < n; i ++) {
        m_ListPath_3.GetText(i, str);
        SrcPathList.AddTail(str);   
    }  
    CPropertyDlg::OnOK();
}     

/////////////////////////////////////////////////////////////////////////////
// CSrcSetBP dialog


CSrcSetBP::CSrcSetBP()
	: CPropertyDlg(CSrcSetBP::IDD)
{
	//{{AFX_DATA_INIT(CSrcSetBP)
		// NOTE: the ClassWizard will add member initialization here
    m_strAddr_6 = "";
    m_strList_6 = "";
    m_strMdl_6 = "";
	//}}AFX_DATA_INIT
}

void CSrcSetBP::DoDataExchange(CDataExchange* pDX)
{
	CPropertyDlg::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSrcSetBP)
		// NOTE: the ClassWizard will add DDX and DDV calls here
    DDX_CBString(pDX, IDC_SRCGRP6_ADDR, m_strAddr_6);
    DDX_LBString(pDX, IDC_SRCGRP6_LIST, m_strList_6);
    DDX_CBString(pDX, IDC_SRCGRP6_MDL, m_strMdl_6);
    DDX_Control(pDX, IDC_SRCGRP6_MDL, m_cmbMdl_6);
    DDX_Control(pDX, IDC_SRCGRP6_LIST, m_List_6);
    DDX_Control(pDX, IDC_SRCGRP6_ADDR, m_CmbAddr_6);
    DDX_Control(pDX, IDC_SRCGRP6_ADDR1, m_edAddr1_6);
	//}}AFX_DATA_MAP
}

/* SetBPEditText --------------------------------------------------*/
/*-----------------------------------------------------------------*/                          
void CSrcSetBP::SetBPEditText(void)
{
    char pszName[256];
    CString str, str1;             
    int i, nSel;

    
    // Get module name
    nSel = m_cmbMdl_6.GetCurSel();
    if(nSel == LB_ERR) str = "";
    else {
        m_cmbMdl_6.GetLBText(nSel, str); 
        if(str.GetLength() > 0) {
            strcpy(pszName, str);
            for(i = 0; isspace(pszName[i]); i++) ;
            if(pszName[i] != '\0') {
                str = "#";
                str += pszName + i;
            }
            else str = "";                   
        }                
    }
                          
    // Get function name                      
    nSel = m_CmbAddr_6.GetCurSel();
    if(nSel == LB_ERR) str1 = "";
    else {
        m_CmbAddr_6.GetLBText(nSel, str1); 
        if(str1.GetLength() > 0) {
            strcpy(pszName, str1);
            for(i = 0; isspace(pszName[i]); i++) ;
            if(pszName[i] != '\0') {
                str1 = "#";
                str1 += pszName + i;
            }
            else str1 = "";                   
        }                   
    }
        
    // Set editor text
    str += str1;
    m_edAddr1_6.SetWindowText(str);    
}
                         
BEGIN_MESSAGE_MAP(CSrcSetBP, CPropertyDlg)
	//{{AFX_MSG_MAP(CSrcSetBP)
		// NOTE: the ClassWizard will add message map macros here
    ON_BN_CLICKED(IDC_SRCGRP6_ADD, OnSrcgrp6Add)
    ON_BN_CLICKED(IDC_SRCGRP6_DEL, OnSrcgrp6Del)
    ON_BN_CLICKED(IDC_SRCGRP6_DELALL, OnSrcgrp6Delall)
    ON_CBN_SELCHANGE(IDC_SRCGRP6_MDL, OnSelchangeSrcgrp6Mdl)
    ON_BN_CLICKED(IDC_SRCGRP6_ENABLE, OnSrcgrp6Enable)
    ON_BN_CLICKED(IDC_SRCGRP6_DISABLE, OnSrcgrp6Disable)
    ON_LBN_SELCHANGE(IDC_SRCGRP6_LIST, OnSelchangeSrcgrp6List)
    ON_CBN_SELCHANGE(IDC_SRCGRP6_ADDR, OnSelchangeSrcgrp6Addr)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CSrcSetBP message handlers        

BOOL CSrcSetBP::OnInitDialog()
{
    CPropertyDlg::OnInitDialog();
    // TODO: Add extra initialization here    
    char pszName[256];
    if(MdlInfo.m_uModules > 0) {
        // Fill module combobox
        for(int i = 0; i < int(MdlInfo.m_uModules); i ++) {
            if(SrcGetModuleName(MdlInfo.m_pModule[i], pszName) == 0)
                m_cmbMdl_6.AddString(pszName);            
        }    
        m_cmbMdl_6.SetCurSel(0);
        
        // Fill function combobox
        char szFunc[100];
        unsigned long dwFunc1, dwFunc2;
        if(SrcGetFirstFuncIndex(MdlInfo.m_pModule[0], dwFunc1) == 0) {   
            for( ;;dwFunc1 = dwFunc2) {
                if(SrcGetNextFunc(dwFunc1, szFunc, dwFunc2) != 0)   break;
                m_CmbAddr_6.AddString(szFunc);        
            }   
            m_CmbAddr_6.SetCurSel(0);
        }
    
        // Fill address editor
        SetBPEditText();
    }               
    
    unsigned short uAddr;
    unsigned short uLine;
    unsigned long dwModule;
    CString str1;   
    CString str;        
    BYTE eFlag;
    for(int i = 0; ;i++) {
        if(!BptGetOneBpt((short)i, &uAddr)) break;
        BptSearchBpt(uAddr, eFlag);
        if(eFlag)   str = "+";
        else str = "-";
        wsprintf(pszName, "   %04X  ", uAddr);
        str += pszName;
                     
        str1 = BPAddr2Sym(uAddr);
        if(str1 != "")  str += str1;                     
        else if(SrcAddr2Linenum(uAddr, uLine, dwModule) == 0) {
            if(SrcGetModuleName(dwModule, pszName) == 0) {
                str += "#";
                str += pszName;                           
            }
            wsprintf(pszName, "#%u", uLine);
            str += pszName;
        }                       
        m_List_6.AddString(str);
    }
    m_List_6.SetHorizontalExtent(1000);
    GetDlgItem(IDC_SRCGRP6_ENABLE)->EnableWindow(FALSE);
    GetDlgItem(IDC_SRCGRP6_DISABLE)->EnableWindow(FALSE);
    GetDlgItem(IDC_SRCGRP6_DEL)->EnableWindow(FALSE);
    if(m_List_6.GetCount() == 0) {
        GetDlgItem(IDC_SRCGRP6_DELALL)->EnableWindow(FALSE);
    }
    
    return TRUE;  // return TRUE  unless you set the focus to a control
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CSrcSetBP::OnSelchangeSrcgrp6Mdl()
{
     // TODO: Add your control notification handler code here
    int nSel = m_cmbMdl_6.GetCurSel();
    if(nSel == LB_ERR) {
        MessageBeep(-1);
        return;
    }                  
                                                       
    m_CmbAddr_6.ResetContent();                                                       
    CString str;                   
    unsigned long dwModule;
    m_cmbMdl_6.GetLBText(nSel, str); 
    if(SrcModuleName2Index(str, dwModule) != 0) return;
    
    char szFunc[100];
    unsigned long dwFunc1, dwFunc2;
    
    if(SrcGetFirstFuncIndex(dwModule, dwFunc1) == 0) {
        for( ;;dwFunc1 = dwFunc2) {
            if(SrcGetNextFunc(dwFunc1, szFunc, dwFunc2) != 0) break;;
            m_CmbAddr_6.AddString(szFunc);        
        }                                                 
    }                                                               
    m_CmbAddr_6.SetCurSel(0);
    
    SetBPEditText();
    m_edAddr1_6.SetFocus();
    m_edAddr1_6.SetSel(0, -1);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CSrcSetBP::OnSelchangeSrcgrp6Addr()
{
    // TODO: Add your control notification handler code here
    SetBPEditText();
    m_edAddr1_6.SetFocus();
    m_edAddr1_6.SetSel(0, -1);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CSrcSetBP::OnSrcgrp6Add()
{
    // TODO: Add your control notification handler code here
    GetDlgItem(IDC_SRCGRP6_ENABLE)->EnableWindow(FALSE);
    GetDlgItem(IDC_SRCGRP6_DISABLE)->EnableWindow(FALSE);
    GetDlgItem(IDC_SRCGRP6_DEL)->EnableWindow(FALSE);

    CString str, str1;
    char psz[256]; 
    BYTE eFlag;
    
    m_edAddr1_6.GetWindowText(str);
    int n = str.GetLength();
    if(n == 0) {
        MessageBeep(-1);
        return;
    }                   
                
    strncpy(psz, str, 255); 
    
    // skip head white space
    for(n = 0; isspace(psz[n]); n++) ;
    if(psz[n] == '\0') {
        MessageBeep(-1);
        return;
    }                   
                    
    // Parse psz -> Address
    DWORD dwNum;
    char pszTmp[256];    
    unsigned char byTmp;
    
    if(psz[n] == '#')   strcpy(pszTmp, psz+n);
    else {
        pszTmp[0] = '#';
        strcpy(pszTmp+1, psz+n);       
    }                         
    
/*    if(SymToAddr(pszTmp, &byTmp, &dwNum) == 0) {
        str1 = str;
    } else if(!Str2Num(psz, dwNum)) {
        MessageBeep(-1);
        return;
    }*/                    

    if(!Str2Num(psz, dwNum)) {
        if(SymToAddr(pszTmp, &byTmp, &dwNum) == 0) 
            str1 = str;
        else {
            MessageBeep(-1);
            return;
        }    
    }
    
    
    // check valid addr
    if(dwNum > DWORD(0xFFFF)) {  
        MessageBeep(-1);
        return;
    }                 
    
    if(BptSearchBpt((unsigned short)dwNum, eFlag)) {
        MessageBeep(-1);
        return;
    }                 
                                       
    if(!BptAddBptfromWnd((unsigned short)dwNum)) {
        MessageBeep(-1);
        return;
    }                 
    
    unsigned short uLine;
    unsigned long dwModule;
             
    str = "+";
    wsprintf(psz, "  %04X  ", (unsigned short)dwNum);
    str += psz;                       
    if(str1 != "") {
        str += str1;
        BPAddSym(WORD(dwNum), str1);
    } else if(SrcAddr2Linenum(dwNum, uLine, dwModule) == 0) {
        if(SrcGetModuleName(dwModule, psz) == 0) {
            str += "#";
            str += psz;                           
        }
        wsprintf(psz, "#%u", uLine);
        str += psz;
    }                       
    m_List_6.AddString(str);
                                       
    GetDlgItem(IDC_SRCGRP6_DELALL)->EnableWindow(TRUE);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CSrcSetBP::OnSrcgrp6Del()
{
    // TODO: Add your control notification handler code here
    GetDlgItem(IDC_SRCGRP6_ENABLE)->EnableWindow(FALSE);
    GetDlgItem(IDC_SRCGRP6_DISABLE)->EnableWindow(FALSE);
    GetDlgItem(IDC_SRCGRP6_DEL)->EnableWindow(FALSE);

    int nSel = m_List_6.GetCurSel();
    if(nSel == LB_ERR) {
        MessageBeep(-1);
        return;
    }                         
    
    unsigned short uAddr;
    if(!BptGetOneBpt((short)nSel, &uAddr)) {
        MessageBeep(-1);
        return;
    }
    if(!BptClrOneBptfromWnd(uAddr)) {    
        MessageBeep(-1);
        return;
    }
    m_List_6.DeleteString(nSel);
    BPClrSym(uAddr);
    
    if(m_List_6.GetCount() == 0) {
        GetDlgItem(IDC_SRCGRP6_DELALL)->EnableWindow(FALSE);
    }
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CSrcSetBP::OnSrcgrp6Delall()
{
    // TODO: Add your control notification handler code here
    GetDlgItem(IDC_SRCGRP6_ENABLE)->EnableWindow(FALSE);
    GetDlgItem(IDC_SRCGRP6_DISABLE)->EnableWindow(FALSE);
    GetDlgItem(IDC_SRCGRP6_DEL)->EnableWindow(FALSE);

    if(!BptClrAllBptfromWnd()) {
        MessageBeep(-1);
        return;
    }
    m_List_6.ResetContent();
    BPClrSym();

    GetDlgItem(IDC_SRCGRP6_DELALL)->EnableWindow(FALSE);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CSrcSetBP::OnSrcgrp6Enable()
{
    // TODO: Add your control notification handler code here
    GetDlgItem(IDC_SRCGRP6_ENABLE)->EnableWindow(FALSE);
    GetDlgItem(IDC_SRCGRP6_DISABLE)->EnableWindow(FALSE);
    GetDlgItem(IDC_SRCGRP6_DEL)->EnableWindow(FALSE);

    int nSel = m_List_6.GetCurSel();
    if(nSel == LB_ERR) {
        MessageBeep(-1);
        return;
    }          

    unsigned short uAddr;
    if(!BptGetOneBpt((short)nSel, &uAddr)) {
        MessageBeep(-1);
        return;
    }
    BYTE eFlag;
    BptSearchBpt(uAddr, eFlag);
    if(eFlag)   return;
    
    BptEnableBpt(uAddr);
                  
    CString str;                  
    m_List_6.GetText(nSel, str);
    m_List_6.DeleteString(nSel);
    str.SetAt(0, '+');
    m_List_6.InsertString(nSel, str);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CSrcSetBP::OnSrcgrp6Disable()
{
    // TODO: Add your control notification handler code here
    GetDlgItem(IDC_SRCGRP6_ENABLE)->EnableWindow(FALSE);
    GetDlgItem(IDC_SRCGRP6_DISABLE)->EnableWindow(FALSE);
    GetDlgItem(IDC_SRCGRP6_DEL)->EnableWindow(FALSE);

    int nSel = m_List_6.GetCurSel();
    if(nSel == LB_ERR) {
        MessageBeep(-1);
        return;
    }          

    unsigned short uAddr;
    if(!BptGetOneBpt((short)nSel, &uAddr)) {
        MessageBeep(-1);
        return;
    }
    BYTE eFlag;
    BptSearchBpt(uAddr, eFlag);
    if(!eFlag)   return;
    
    BptDisableBpt(uAddr);
                  
    CString str;                  
    m_List_6.GetText(nSel, str);
    m_List_6.DeleteString(nSel);
    str.SetAt(0, '-');   
    m_List_6.InsertString(nSel, str);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CSrcSetBP::OnSelchangeSrcgrp6List()
{
    // TODO: Add your control notification handler code here
    int nSel = m_List_6.GetCurSel();
    if(nSel == LB_ERR) {
        GetDlgItem(IDC_SRCGRP6_ENABLE)->EnableWindow(FALSE);
        GetDlgItem(IDC_SRCGRP6_DISABLE)->EnableWindow(FALSE);
        GetDlgItem(IDC_SRCGRP6_DEL)->EnableWindow(FALSE);
        return;
    }    

    unsigned short uAddr;
    if(!BptGetOneBpt((short)nSel, &uAddr)) {
        GetDlgItem(IDC_SRCGRP6_ENABLE)->EnableWindow(FALSE);
        GetDlgItem(IDC_SRCGRP6_DISABLE)->EnableWindow(FALSE);
        GetDlgItem(IDC_SRCGRP6_DEL)->EnableWindow(FALSE);
        return;
    }

    BYTE eFlag;
    BptSearchBpt(uAddr, eFlag);
    GetDlgItem(IDC_SRCGRP6_ENABLE)->EnableWindow(!eFlag);
    GetDlgItem(IDC_SRCGRP6_DISABLE)->EnableWindow(eFlag);
    GetDlgItem(IDC_SRCGRP6_DEL)->EnableWindow(TRUE);
}              

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CSrcSetBP::OnSrcgrp6Save()
{
    // TODO: Add your control notification handler code here
    CFileCenterDialog dlg(FALSE, NULL, "*.*");
    dlg.m_ofn.lpstrTitle = "Save Breakpoint";
    dlg.SetHelpID(IDD_SAVE_BP);
    if(dlg.DoModal() == IDOK) {
        CString str = dlg.GetPathName();
        //AfxMessageBox(str);
        
        extern BOOL SaveBpt(const char *);
        SaveBpt(str);
    }
    
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CSrcSetBP::OnSrcgrp6Restore()
{
    // TODO: Add your control notification handler code here
    CFileCenterDialog dlg(TRUE, NULL, "*.*");
    dlg.m_ofn.lpstrTitle = "Restore Breakpoint";
    dlg.SetHelpID(IDD_RESTORE_BP);
    if(dlg.DoModal() == IDOK) {
        CString str = dlg.GetPathName();
        //AfxMessageBox(str);

        extern BOOL RestoreBpt(const char *);
        if(RestoreBpt(str)) {
            BPClrSym();
            m_List_6.ResetContent();
        
            unsigned short uAddr;
            unsigned short uLine;
            unsigned long dwModule;
            char pszName[256];
            BYTE eFlag;
            for(int i = 0; ;i++) {
                if(!BptGetOneBpt((short)i, &uAddr)) break;
                BptSearchBpt(uAddr, eFlag);
                if(eFlag)   str = "+";
                else str = "-";
                wsprintf(pszName, "   %04X  ", uAddr);
                str += pszName;
                if(SrcAddr2Linenum(uAddr, uLine, dwModule) == 0) {
                    if(SrcGetModuleName(dwModule, pszName) == 0) {
                        str += "#";
                        str += pszName;                           
                    }
                    wsprintf(pszName, "#%u", uLine);
                    str += pszName;
                }                       
                m_List_6.AddString(str);
            }
        } 
    }
}

BOOL CSrcSetBP::OnSetActive()
{  
  m_nIDHelp = IDD_SRCGRP_BREAKPOINT;
  return CPropertyDlg::OnSetActive();
}

BOOL CSrcSetBP::OnKillActive()
{ 
  return CPropertyDlg::OnKillActive();
}
