
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/STKSELE.CPP   1.8   20 Jun 1996 09:24:32   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/STKSELE.CPP  $
** 
**    Rev 1.8   20 Jun 1996 09:24:32   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.6   10 Jun 1996 10:19:10   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.4   29 May 1996 09:28:04   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 08:59:44   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:08:06   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:22:36   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 12:53:04   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:33:52   Shirley
** No change.
** 
**    Rev 1.29   02 Apr 1996 09:22:32   Shirley
** No change.
** 
**    Rev 1.28   15 Feb 1996 08:48:14   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:02:04   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:33:44   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:47:38   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:18:54   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:14:08   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:14:00   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:35:20   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:26:08   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:14:46   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:16:52   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:13:58   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:14:14   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:33:08   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:19:02   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:23:16   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:34:12   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:32:08   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:46:00   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:07:06   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:49:14   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:43:50   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:26:52   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:51:00   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:19:06   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:48:58   Shirley
** EasyPack/SLD Version 0.1c
** 
**    Rev 1.2   20 Sep 1995 10:57:18   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:46:56   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:53:40   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: STKSELE.CPP
//
//  Description: The implementation file fore class: CStackSelectLocalDialog.
//
//  Author: Chen Jun
//
//  Date: 08/22/95
//
//  Modification:
//      1. 08/22/95, Initial version of the class: CStackSelectLocalDialog.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"

#include "symblsvr.h"
#include "stkinit.h"
#include "varinit.h"

#include "stkobj.h"

#include "stkdoc.h"

#include "stklocal.h"

#include "stksele.h"


/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Global variables.
CPtrList* pStkAddLocalList;
CPtrList* pStkRemoveLocalList;


/////////////////////////////////////////////////////////////////////////////
// External variables.
extern class VarServer stkObject;


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.
void StkSimpleUpdateLocalWindow(void);


/////////////////////////////////////////////////////////////////////////////
// CStackSelectLocalDialog dialog

void CStackSelectLocalDialog::AllocateSpace(void)
{
    // Allocate m_pAddLocalList & m_pRemoveLocalList.
    m_pStkAddLocalList = new CPtrList;
    ASSERT( m_pStkAddLocalList );

    m_pStkRemoveLocalList = new CPtrList;
    ASSERT( m_pStkRemoveLocalList );

    if ( !m_pStkAddLocalList || !m_pStkRemoveLocalList ) {
        AfxMessageBox("Insufficient memory.");
    }
}

void CStackSelectLocalDialog::ReleaseSpace(void)
{
    // Release m_pAddLocalList & m_pRemoveLocalList.
    if ( m_pStkAddLocalList ) {
        delete m_pStkAddLocalList;
    }

    if ( m_pStkRemoveLocalList ) {
        delete m_pStkRemoveLocalList;
    }
}

void CStackSelectLocalDialog::SetGlobalList(void)
{
    // Reset the global list.
    ::pStkAddLocalList->RemoveAll();
    ::pStkRemoveLocalList->RemoveAll();

    // Add contents from m_pStkAddLocalList to ::pStkAddLocalList.
    if ( !m_pStkAddLocalList->IsEmpty() ) {
        ::pStkAddLocalList->AddTail(m_pStkAddLocalList);
    }
        
    // Add contents from m_pStkRemoveLocalList to ::pStkRemoveLocalList.
    if ( !m_pStkRemoveLocalList->IsEmpty() ) {
        ::pStkRemoveLocalList->AddTail(m_pStkRemoveLocalList);
    }
}

void CStackSelectLocalDialog::RemoveAllLocal(void)
{
    // Delete from Local window.
    if ( !m_pStkRemoveLocalList->IsEmpty() ) {
        POSITION posHead = m_pStkRemoveLocalList->GetHeadPosition();
        while ( posHead ) {
            CStkObject* pObj = 
                (CStkObject* )(m_pStkRemoveLocalList->GetNext(posHead));
            ::stkObject.DeleteLocal(pObj->GetDest());
        }
    }

    if ( !m_pStkAddLocalList->IsEmpty() ) {
        POSITION posHead = m_pStkAddLocalList->GetHeadPosition();
        while ( posHead ) {
            CStkObject* pObj = 
                (CStkObject* )(m_pStkAddLocalList->GetNext(posHead));
            ::stkObject.DeleteLocal(pObj->GetDest());
        }
    }
}

void CStackSelectLocalDialog::AddLocal(void)
{
    // Add to Local window.
    if ( !m_pStkAddLocalList->IsEmpty() ) {
        POSITION posHead = m_pStkAddLocalList->GetHeadPosition();
        while ( posHead ) {
            CStkObject* pObj = 
                (CStkObject* )(m_pStkAddLocalList->GetNext(posHead));
            ::stkObject.AddLocalVar(pObj->GetDest(), pObj->GetName());
        }
    }
}


CStackSelectLocalDialog::CStackSelectLocalDialog(CWnd* pParent /*=NULL*/)
    : CDialog(CStackSelectLocalDialog::IDD, pParent)
{
    //{{AFX_DATA_INIT(CStackSelectLocalDialog)
    //}}AFX_DATA_INIT

    // Allocate m_pAddLocalList & m_pRemoveLocalList.
    AllocateSpace();
}

void CStackSelectLocalDialog::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CStackSelectLocalDialog)
    DDX_Control(pDX, IDC_LIST_VARSELECTLOCAL_ONDISPLAY, m_lstOnDisplay);
    DDX_Control(pDX, IDC_LIST_VARSELECTLOCAL_NOTONDISPLAY, m_lstNotOnDisplay);
    DDX_Control(pDX, IDC_BUTTON_VARSELECTLOCAL_REMOVE, m_btnRemove);
    DDX_Control(pDX, IDC_BUTTON_VARSELECTLOCAL_ADD, m_btnAdd);
    //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CStackSelectLocalDialog, CDialog)
    //{{AFX_MSG_MAP(CStackSelectLocalDialog)
    ON_LBN_SETFOCUS(IDC_LIST_VARSELECTLOCAL_NOTONDISPLAY, OnSetfocusNotondisplay)
    ON_LBN_SETFOCUS(IDC_LIST_VARSELECTLOCAL_ONDISPLAY, OnSetfocusOndisplay)
    ON_BN_CLICKED(IDC_BUTTON_VARSELECTLOCAL_ADD, OnButtonAdd)
    ON_BN_CLICKED(IDC_BUTTON_VARSELECTLOCAL_REMOVE, OnButtonRemove)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CStackSelectLocalDialog message handlers

BOOL CStackSelectLocalDialog::OnInitDialog()
{
    CDialog::OnInitDialog();
    
    // TODO: Add extra initialization here
    
    // Central the dialog position.
    CenterWindow();
        
    // Add contents to the left list box.
    if ( !::pStkRemoveLocalList->IsEmpty() ) {
        m_lstNotOnDisplay.ResetContent();
        POSITION posHead = ::pStkRemoveLocalList->GetHeadPosition();
        while ( posHead ) {
            CStkObject* pObj = 
                (CStkObject* )(::pStkRemoveLocalList->GetNext(posHead));
            m_lstNotOnDisplay.AddString(pObj->GetName());
        }
        // Add contents from ::pStkRemoveLocalList to m_pStkRemoveLocalList.
        ASSERT ( m_pStkRemoveLocalList->IsEmpty() );
        m_pStkRemoveLocalList->AddTail(::pStkRemoveLocalList);
    }
    
    // Add contents to the right list box.
    if ( !::pStkAddLocalList->IsEmpty() ) {
        m_lstOnDisplay.ResetContent();
        POSITION posHead = ::pStkAddLocalList->GetHeadPosition();
        while ( posHead ) {
            CStkObject* pObj = 
                (CStkObject* )(::pStkAddLocalList->GetNext(posHead));
            m_lstOnDisplay.AddString(pObj->GetName());
        }
        // Add contents from ::pStkAddLocalList to m_pStkAddLocalList.
        ASSERT ( m_pStkAddLocalList->IsEmpty() );
        m_pStkAddLocalList->AddTail(::pStkAddLocalList);
    }
    
    // Set the first focus.
    m_lstOnDisplay.SendMessage(WM_SETFOCUS);
    //GotoDlgCtrl(GetDlgItem(IDC_LIST_VARSELECTLOCAL_ONDISPLAY));
    
    // Set the initial value.
    UpdateData(FALSE);
    
    return TRUE;  // return TRUE  unless you set the focus to a control
}

void CStackSelectLocalDialog::OnSetfocusNotondisplay()
{
    // TODO: Add your control notification handler code here
    
    // Select the first string.
    if ( m_lstNotOnDisplay.GetCount() >= 0 ) {
        m_lstNotOnDisplay.SetCurSel(0);
    }
    if ( m_lstOnDisplay.GetCount() >= 0 ) {
        m_lstOnDisplay.SetCurSel(-1);
    }

    // Enable "Add" button.
    m_btnAdd.EnableWindow();

    // Disable "Remove" button.
    m_btnRemove.EnableWindow(FALSE);
}

void CStackSelectLocalDialog::OnSetfocusOndisplay()
{
    // TODO: Add your control notification handler code here
    
    // Select the first string.
    if ( m_lstOnDisplay.GetCount() >= 0 ) {
        m_lstOnDisplay.SetCurSel(0);
    }
    if ( m_lstNotOnDisplay.GetCount() >= 0 ) {
        m_lstNotOnDisplay.SetCurSel(-1);
    }

    // Enable "Remove" button.
    m_btnRemove.EnableWindow();

    // Disable "Add" button.
    m_btnAdd.EnableWindow(FALSE);
}

void CStackSelectLocalDialog::OnOK()
{
    // TODO: Add extra validation here
    
    // Global list operation.
    SetGlobalList();
    
    // Remove local variables.
    RemoveAllLocal();
    
    // Add local variables.
    AddLocal();
    
    // Update Stack local window.
    ::StkSimpleUpdateLocalWindow();

    // Release m_pAddLocalList & m_pRemoveLocalList.
    ReleaseSpace();

    CDialog::OnOK();
}

void CStackSelectLocalDialog::OnCancel()
{
    // TODO: Add extra cleanup here
    
    // Release m_pAddLocalList & m_pRemoveLocalList.
    ReleaseSpace();

    CDialog::OnCancel();
}

void CStackSelectLocalDialog::OnButtonAdd()
{
    // TODO: Add your control notification handler code here
    
    // Get the contents from the list control.
    UpdateData();
    
    // List operation.
    int nNotOnDisplayIndex = m_lstNotOnDisplay.GetCurSel();
    if ( LB_ERR == nNotOnDisplayIndex ) {
        return;
    }
    POSITION pos = m_pStkRemoveLocalList->FindIndex(nNotOnDisplayIndex);
    CStkObject* pObj = (CStkObject* )m_pStkRemoveLocalList->GetAt(pos);
    m_pStkAddLocalList->AddTail(pObj);
    m_pStkRemoveLocalList->RemoveAt(pos);
    
    // Remove from the left list box.
    m_lstNotOnDisplay.DeleteString(nNotOnDisplayIndex);
    
    // Add to the right list box.
    pObj = (CStkObject* )(m_pStkAddLocalList->GetTail());
    m_lstOnDisplay.AddString(pObj->GetName());

    // Select the first string.
    //m_lstOnDisplay.SendMessage(WM_SETFOCUS);
    GotoDlgCtrl(GetDlgItem(IDC_LIST_VARSELECTLOCAL_ONDISPLAY));
}

void CStackSelectLocalDialog::OnButtonRemove()
{
    // TODO: Add your control notification handler code here

    // Get the contents from the list control.
    UpdateData();
    
    // List operation.
    int nOnDisplayIndex = m_lstOnDisplay.GetCurSel();
    if ( LB_ERR == nOnDisplayIndex ) {
        return;
    }
    POSITION pos = m_pStkAddLocalList->FindIndex(nOnDisplayIndex);
    CStkObject* pObj = (CStkObject* )m_pStkAddLocalList->GetAt(pos);
    m_pStkRemoveLocalList->AddTail(pObj);
    m_pStkAddLocalList->RemoveAt(pos);
    
    // Remove from the right list box.
    m_lstOnDisplay.DeleteString(nOnDisplayIndex);
    
    // Add to the left list box.
    pObj = (CStkObject* )(m_pStkRemoveLocalList->GetTail());
    m_lstNotOnDisplay.AddString(pObj->GetName());

    // Select the first string.
    //m_lstNotOnDisplay.SendMessage(WM_SETFOCUS);
    GotoDlgCtrl(GetDlgItem(IDC_LIST_VARSELECTLOCAL_NOTONDISPLAY));
}
