
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/SYMCLIPR.H__   1.8   20 Jun 1996 09:25:56   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/SYMCLIPR.H__  $
** 
**    Rev 1.8   20 Jun 1996 09:25:56   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.6   10 Jun 1996 10:20:34   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.4   29 May 1996 09:30:16   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:07:32   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:09:06   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:25:02   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 12:59:42   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:39:48   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:53:26   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:10:12   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:36:34   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:50:50   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:12:06   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:15:10   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:15:04   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:38:40   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:23:50   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:08:34   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:13:28   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:07:50   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:10:22   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:31:12   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:18:36   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:24:18   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:32:26   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:30:50   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:45:28   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:07:38   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:50:50   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:47:14   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:31:28   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:49:02   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:22:26   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:49:26   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:57:02   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:49:42   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:53:32   Shirley
** Initial revision.
**
****************************************************************************/

/****************************************************************************
**
**  Name:  symclipr.h
**
**  Description:
**     Prototypes for the routines that print the symbol table to the cli.
**
**  Status:  PRELIMINARY
**
**  $Log$
** 
**  $Header:   D:/EPSLDV1/SRC/LOG/SYMCLIPR.H__   1.8   20 Jun 1996 09:25:56   ZJRD  $
**
**  Copyright (C) 1995 Microtek International.  All rights reserved.
**
*****************************************************************************/

#ifndef _SYMCLIPR_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#include "basewind.h"
#include "memmanag.h"
#include "symblsvr.h"

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

#define SYMCLIPR_ADDR_TEXT_WIDTH 40

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

#ifdef __cplusplus
extern "C" {
#endif

RETCODE EXPORT
SymPrintSymbol(TABLE_OFFSET symbol, 
               SYM_DISPLAY_TYPE displayType,
               U16 indentLevel);

RETCODE EXPORT
SymPrintSymbols(SYM_DISPLAY_TYPE displayType);

RETCODE SymPrintLines(SYM_DESCRIPTOR modDesc);

//--------------------------------------------------------------------------
// SymConvSymAddrToText
//
// Output format:
//    Fixed addresses:
//       Displays fixed address as xxx-yyy where xxx is the start address and
//       yyy is the end address; then displays the range as [rrr].
//       Start and end addresses are is hex, the range is in decimal
//    Stack-based addresses:
//       Displays as a single signed decimal number followed by [sss] size.
//
// Input Parameter:
//    symbol: symbol being printed
//
// Output Parameter:
//    str: alloc'ed by caller using size SYMCLIPR_ADDR_TEXT_WIDTH
//--------------------------------------------------------------------------
RETCODE SymConvSymAddrToText(SYM_DESCRIPTOR symbol, LPSTR str);

#ifdef __cplusplus
}
#endif

RETCODE SymPrintBases(SYM_DISPLAY_TYPE displayType);

#define _SYMCLIPR_
#endif
/******************************** E O F ***********************************/
