
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/SYMGET.H__   1.8   20 Jun 1996 09:27:56   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/SYMGET.H__  $
** 
**    Rev 1.8   20 Jun 1996 09:27:56   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.6   10 Jun 1996 10:22:34   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.4   29 May 1996 09:33:22   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:05:26   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:11:30   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:23:22   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 12:57:04   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:42:28   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:54:30   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:02:46   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:36:48   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:43:38   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:16:32   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:19:10   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:19:04   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:34:46   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:25:34   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:07:40   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:16:32   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:08:40   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:09:26   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:30:18   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:19:58   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:22:40   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:33:10   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:29:40   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:43:48   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:02:44   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:48:40   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:46:42   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:30:48   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:46:52   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:20:22   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:51:08   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:53:52   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:46:44   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:53:34   Shirley
** Initial revision.
**
****************************************************************************/

/****************************************************************************
**
**  Name:  symget.h
**
**  Description:
**     Prototype info for the routines that get entries from the symbol table.
**
**  Status:  PRELIMINARY
**
**  $Log$
** 
**  $Header:   D:/EPSLDV1/SRC/LOG/SYMGET.H__   1.8   20 Jun 1996 09:27:56   ZJRD  $
**
**  Copyright (C) 1995 Microtek International.  All rights reserved.
**
*****************************************************************************/

#ifndef _SYMGET_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#include "basewind.h"
#include "memmanag.h"
#include "symblsvr.h"
                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/
#ifdef __cplusplus

/***************************************************************************
** SymGetVarLifetimeInfo
**
** Description: Gets the alive/dead status of a register variable
**
** Input Parameters:
**    inputSymbol:   the descriptor to a register var
** Output Parameters:
**    lifetimeState: returns LIVE or DEAD
** Errors:
**    ER_SYMBOL_NOT_A_REG: the descriptor does not point to a register
**                         variable.
***************************************************************************/
RETCODE SymGetVarLifetimeInfo(SYM_DESCRIPTOR inputSymbol,
                              VAR_LIFETIME_STATE &lifetimeState);


//--------------------------------------------------------------------------
// SymGetSymbolBasicType
//
// Input parameter:
//    inputSymbol: symbol descriptor of symbol's basic type desired
//
// Output parameter:
//    basicType: code, data, or unknown.  Unknown types are:
//       SYM_PUBLIC_UNKNOWN:
//       SYM_MISCELLANEOUS:
//       SYM_CONSTANT:
//       SYM_TYPE:
//       SYM_UNDEFINED:
//--------------------------------------------------------------------------
RETCODE SymGetSymbolBasicType(SYM_DESCRIPTOR      inputSymbol, 
                              BASIC_SYM_ADDR_TYPE *basicType);


//--------------------------------------------------------------------------
// SymGetParentModule
//
// Description:
//    given and input symbol descriptor, this function checks that the
//    symbol is a module and returns that descriptor.
//    If not, it gets the parent symbol descriptor and loops.
//    If the symbol type is SYM_ROOT, the function terminates and sets
//    the output descriptor to NULL_SYMBOL.
//
// Input parameter:
//    inputSymbol: starting point for check for module type
//
// Output parameter:
//    moduleSymbol: return symbol descriptor pointing to module symbol
//                  or NULL_SYMBOL if not found
//--------------------------------------------------------------------------
RETCODE SymGetParentModule(SYM_DESCRIPTOR inputSymbol, 
                           SYM_DESCRIPTOR *moduleSymbol);


#endif

#define _SYMGET_
#endif
/******************************** E O F ***********************************/
