
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/SYMMGR.H__   1.8   20 Jun 1996 09:27:42   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/SYMMGR.H__  $
** 
**    Rev 1.8   20 Jun 1996 09:27:42   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.6   10 Jun 1996 10:22:20   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.4   29 May 1996 09:32:58   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:05:04   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:13:56   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:24:30   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 12:53:48   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:40:36   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:54:06   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:09:24   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:35:48   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:50:04   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:14:32   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:20:26   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:20:20   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:37:38   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:23:06   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:12:34   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:15:32   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:09:20   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:12:56   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:35:16   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:24:30   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:25:22   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:28:20   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:29:06   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:41:40   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:07:22   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:47:00   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:48:12   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:29:28   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:49:14   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:23:16   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:51:04   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:58:10   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:46:40   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:55:26   Shirley
** Initial revision.
**
****************************************************************************/

/****************************************************************************
**
**  Name:  symmgr.h
**
**  Description:
**     Prototypes for the functions to manage the symbol memory pool
**
**  Status:  PRELIMINARY
**
**  $Log$
** 
**  $Header:   D:/EPSLDV1/SRC/LOG/SYMMGR.H__   1.8   20 Jun 1996 09:27:42   ZJRD  $
**
**  Copyright (C) 1995 Microtek International.  All rights reserved.
**
*****************************************************************************/

#ifndef _SYMMGR_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#include "symblsvr.h"
#include "memmanag.h"
#include "symutil.h"

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

typedef union {
   OFFSET_ADDR_TYPE startAddr;      // code symbol address
   AUTO_VAR_OFFSET  autoVarOffset;  // var offset from stack frame
   STATIC_VAR_ADDR  staticVarAddr;  // static (not global) variable address
   GLOBAL_VAR_ADDR  globalVarAddr;  // global variable
   REG_INDEX        registerIndex;  // for ATN2 and ATN10 register vars
} BEGIN_ADDR_INFO;

typedef union {
   OFFSET_ADDR_TYPE endAddr;     // for code symbols and fixed address vars
   U32          varSize;         // for auto vars and register vars
} END_ADDR_INFO;

typedef struct {
   VAR_LIFETIME_INFO lifetimeInfo;
   TABLE_OFFSET nextLifetimeInfo;
} SYM_LIFETIME_INFO;

typedef struct {
   TABLE_OFFSET firstEntry;
   TABLE_OFFSET lastEntry;
} SYM_LIFETIME_START_INFO;

// defines action preformed on the last symbol
typedef enum {
   SYM_OPEN,
   SYM_CLOSE,
} SYM_ACTION;

typedef struct {
   SYM_TYPE_TYPE symType:4;
   BASE_INDEX baseIndex:12;  // must change MAX_BASE_INDEX_SIZE if more bits
} PACKED_TYPE_INDEX;         // are allowed for BASE_INDEX

// All variable symbols use this as their common header.
typedef struct {
   PACKED_TYPE_INDEX typeIndex;
   TABLE_OFFSET symbolNameOffset;
   TABLE_OFFSET symParentOffset;
   TABLE_OFFSET symSiblingOffset;
   BEGIN_ADDR_INFO beginAddrInfo;
   END_ADDR_INFO endAddrInfo;
   U32 ordinalVal;
} COMMON_SYMBOL_HEADER;

typedef struct {
   TABLE_OFFSET varListOffset;
   TABLE_OFFSET labelListOffset;
   TABLE_OFFSET constListOffset;
   TABLE_OFFSET miscListOffset;
} COMMON_LIST_HEADER;

// All block/function/module symbols use this as their common header.
typedef struct {
   COMMON_SYMBOL_HEADER symHeader;
   TABLE_OFFSET child;
   COMMON_LIST_HEADER list;
} COMMON_BLOCK_HEADER;

typedef struct {
   COMMON_BLOCK_HEADER symHeader;
   TABLE_OFFSET        linenumOffsetStart;
   TABLE_OFFSET        linenumOffsetEnd;
   TABLE_OFFSET        srcFilenameOffset;
   TIMESTAMP_TYPE      timestamp;
   U32                 fileOffset;
      /* offset to start of module record when onDemand state is TRUE;
         a value of 0 ==> all symbols are loaded for this module */ 
   U32                 srcFilePosition;
   U32                 typeDelta;
} SYM_TYPE_MODULE;

typedef struct {
   COMMON_BLOCK_HEADER symHeader;
   FUNC_CLASS funcClass;
   U32 stackSpace;
   U32 typeIndex;    /* temporary type cast */
} SYM_TYPE_FUNCTION;


typedef struct {
   COMMON_BLOCK_HEADER symHeader;
   U32 stackSpace;
} SYM_TYPE_BLOCK;

typedef struct {
   TABLE_OFFSET baseNameOffset;
   TABLE_OFFSET nextBaseOffset;
   U32 addressMin;
   U32 addressMax;
   U32 addressCount;
   U32 addrTable;
   BASE_ADDRESS baseAddress;
   U8 baseType;
   U8 addrTableDirty;
} SYM_BASE_ENTRY;

typedef struct {
   COMMON_SYMBOL_HEADER symHeader;
   TABLE_OFFSET         typeIndex;
   VAR_STORAGE_CLASS    storageClass;
   VAR_REGISTER_CLASS   registerClass;
   BOOLEAN              isConstant;    /* TRUE ==> read-only constant;   */
                                       /* FALSE==> read-write access     */
   BOOLEAN              isValidAddr;   /* TRUE ==> address is valid;     */
                                       /* FALSE==> address not known yet */
} SYM_TYPE_VARIABLE;

typedef struct {
    U16        recordSize;   /* bytes making up the entire type record */
    U16        memberCount;
    TYPE_CLASS typeChoice;   /* determines access to union */
    union {
        SIMPLE_TYPE simpleType;
        COMPLEX_TYPE complexType;
    } t;
    U32 sizeInMAUs;           /* number of MAUs making up type template */
    TABLE_OFFSET typeName;    /* empty string if type doesn't have name */
    BOOLEAN sizeCalculated;   /* Flag to indicates MAU calculated */
} TYPE_HEADER_TYPE2;

typedef struct {
   U32 attribute;
   U8 frameType;
   U32 pushMask;
   TYPE_INDEX returnType;     
   U8 argCount;
   U8 level;
   TABLE_OFFSET fatherName;
} FUNC_TYPE_HEADER;
   
typedef struct {
    TABLE_OFFSET nameOffset;
    TYPE_INDEX typeIndex;      
    U16 offset;
} TYPE_STRUCT_HEADER;

typedef struct {
   U32 enumValue;
   TABLE_OFFSET enumName;
} ENUM_TYPE_STRUCT;

#define _SYMMGR_
#endif
/******************************** E O F ***********************************/
