
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/SYMORDTB.CPP   1.8   20 Jun 1996 09:28:30   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/SYMORDTB.CPP  $
** 
**    Rev 1.8   20 Jun 1996 09:28:30   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.6   10 Jun 1996 10:23:08   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.4   29 May 1996 09:34:14   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:02:48   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:14:22   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:29:12   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 12:58:28   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:42:08   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:57:10   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:08:32   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:34:58   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:49:16   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:15:18   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:18:42   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:18:36   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:34:48   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:25:36   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:07:42   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:16:34   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:08:40   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:09:26   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:30:20   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:19:58   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:22:40   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:33:12   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:29:42   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:43:48   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:04:44   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:47:40   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:48:48   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:28:26   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:52:38   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:18:44   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:52:22   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:53:48   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:46:42   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:55:28   Shirley
** Initial revision.
**
****************************************************************************/

/*----------------------------------------------------------------------------
** Name: SYMORDTB.cpp
**
** Title: Ord Table
**
** Purpose:
**  Create and manage the table that holds offsets to symbols in the order
**    they were loaded.  Provides:
**       PutU32 (inherited from MemPool)
**       GetOffset
**       GetOrdinalFromPercent
**
**  Base class = MemPool
**
** Status: PRELIMINARY
**
** $Log$
** 
** $Header:   D:/EPSLDV1/SRC/LOG/SYMORDTB.CPP   1.8   20 Jun 1996 09:28:30   ZJRD  $
**
** Copyright (C) 1995 Microtek International.  All rights reserved.
**
**--------------------------------------------------------------------------*/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include "stdafx.h"                      
#include "mempool.h"
#include "ordtbl.h"

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

#define ORDTABLE_INIT_SIZE      (4L * 1024L)
#define ORDTABLE_EXPANSION_SIZE (4L * 1024L)

                       /****************************
                        *                          *
                        *     EXECUTABLE CODE      *
                        *                          *
                        ****************************/

//member functions for OrdinalTable

//------------------------------------------------------------------------
// OrdinalTable::OrdinalTable()     constructor
//------------------------------------------------------------------------
OrdinalTable::OrdinalTable():MemPool()  {

   initialSize = ORDTABLE_INIT_SIZE;
   expandSize  = ORDTABLE_EXPANSION_SIZE;
};  // end of OrdinalTable constructor


//------------------------------------------------------------------------
// OrdinalTable::AddSymOffsetToOT
//------------------------------------------------------------------------
RETCODE
OrdinalTable::AddSymOffsetToOT(TABLE_OFFSET symOffset,
                               ORDINAL_INDEX& ordIndex) {

   RETCODE retCode;
   TABLE_OFFSET offset;
   
   if ((retCode = AllocBytes(sizeof(symOffset), offset)) == SUCCESS) {
      *(TABLE_OFFSET *)GetHugeDataPtr(offset) = symOffset;
      ordIndex = GetOrdinalCount();
   }
   return retCode;
}  // end of AddSymOffsetToOT


//------------------------------------------------------------------------
// OrdinalTable::GetOffset
//
// Purpose:
//    Retrieve offset to symbol table item given the index to the ordinal
//    table.
//
// Input parameters:
//    ordIndex:
//       ORDINAL_INDEX index into ordinal table; the index is an even size
//       of a TABLE_OFFSET
//
// Output parameters:
//    itemOffset:
//       offset into symbol table of item
//
// Error:
//    Reports ER_INDEX_NOT_IN_TABLE if the index field is NULL or
//    Reports ER_INDEX_OUT_OF_BOUNDS if the requested index is larger than
//       last item in the table or larger than the table size
//------------------------------------------------------------------------
RETCODE OrdinalTable::GetOffset(ORDINAL_INDEX ordIndex,
                                TABLE_OFFSET& itemOffset)  {

   if ( ((ordIndex + 1) > (tableSize / (sizeof(TABLE_OFFSET))))
       || (ordIndex + 1 > GetOrdinalCount()) ) {
      return ER_INDEX_OUT_OF_BOUNDS;
   } else {
      itemOffset =
         *(HP_TABLE_OFFSET)GetHugeDataPtr(ordIndex * (sizeof(TABLE_OFFSET)));
      if (!itemOffset)  // if NULL then item not in table
         return ER_INDEX_NOT_IN_TABLE;
      else
         return SUCCESS;
   }
}   // end of OrdinalTable::GetOffset


//------------------------------------------------------------------------
// OrdinalTable::GetOrdinalFromPercent
//------------------------------------------------------------------------
U32 OrdinalTable::GetOrdinalFromPercent(U8 percent)  {

   return ((GetOrdinalCount() * (U32)(min(percent, 100))) / 100L);
}  // end of OrdinalTable::GetOrdinalFromPercent

//------------------------------------------------------------------------
// OrdinalTable::ObliterateTable
//------------------------------------------------------------------------
VOID OrdinalTable::ObliterateTable(VOID) {

   MemPool::ObliterateTable();
   initialSize = ORDTABLE_INIT_SIZE;
   expandSize  = ORDTABLE_EXPANSION_SIZE;
}

/******************************** E O F *************************************/
