/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/SYMSTACK.CPP   1.8   20 Jun 1996 09:30:14   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/SYMSTACK.CPP  $
** 
**    Rev 1.8   20 Jun 1996 09:30:14   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.6   10 Jun 1996 10:24:52   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.4   29 May 1996 09:37:30   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:02:06   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:16:56   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:31:16   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.1   18 Apr 1996 12:56:42   Shirley
** No change.
** 
**    Rev 1.0   12 Apr 1996 10:36:06   Shirley
** Initial revision.
** 
****************************************************************************/
/****************************************************************************
**
**  Name:  SYMSTACK.CPP
**
**  Description:
**      member function of class CSymStack
**
**  Status:  CODED
**
**    Rev 1.0   13 March 1996 10:00:00pm   Gates Hua
** Initial revision.
**
**  Copyright (C) 1996 Microtek International.  All rights reserved.
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#include "stdafx.h"
#include "symblsvr.h"
#include "symstack.h"

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/


                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/


                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/

/***************************************************************************
*                                                                          *
*  IsEmpty  --  check stack status                                         *
*  parameter :                                                             *
*       None                                                               *
*  return value :                                                          *
*       GOOD -- stack is empty                                             *
*       FAILURE -- stack is not empty                                      *
*                                                                          *
***************************************************************************/
int CSymStack::IsEmpty(void)
{
	if ( m_pBottom == 0 ) return GOOD;
    return FAILURE;
}

/***************************************************************************
*                                                                          *
*  DeleteStack  --  free stack memory                                      *
*  parameter :                                                             *
*       None                                                               *
*  return value :                                                          *
*       GOOD -- free memory OK                                             *
*       FAILURE -- free memory FAILURE                                     *
*                                                                          *
***************************************************************************/
int CSymStack::DeleteStack(void)
{
	struct StackNode *temp;
	
	temp = m_pTop;
	while( m_pTop ) {
		m_pTop = m_pTop->next;
		delete temp;
		temp = m_pTop;
	}
	m_pBottom = 0;
	m_pTop = 0;
		
    return GOOD;
}

/***************************************************************************
*                                                                          *
*  Push  --  push one data to stack                                        *
*  parameter :                                                             *
*       pNode  --  data pointer                                            *
*  return value :                                                          *
*       GOOD -- OK                                                         *
*       FAILURE -- FAILURE                                                 *
*                                                                          *
***************************************************************************/
int CSymStack::Push(void* pNode)
{
	struct StackNode *temp;
	
	if ( pNode == 0 ) return FAILURE;
	temp = new struct StackNode;
	if ( temp == 0 ) return FAILURE;
	temp->pNode = pNode;
	if ( m_pBottom == 0 ) {
		m_pTop = temp;
	}                    
	else {
		temp->prev = m_pBottom;
		m_pBottom->next = temp;
	}
	m_pBottom = temp;
	
    return GOOD;
}

/***************************************************************************
*                                                                          *
*  Pop  --  pop one data from stack                                        *
*  parameter :                                                             *
*       pNode  --  data pointer                                            *
*  return value :                                                          *
*       GOOD -- OK                                                         *
*       FAILURE -- FAILURE                                                 *
*                                                                          *
***************************************************************************/
int CSymStack::Pop(void*& pNode)
{
	struct StackNode *temp;
	
	if ( m_pBottom == 0 ) return FAILURE;
	pNode = m_pBottom->pNode;
	if ( pNode == 0 ) return FAILURE;
	temp = m_pBottom;
	m_pBottom = m_pBottom->prev;
	if ( m_pBottom == 0 ) {
		m_pTop = 0;
	}                    
	else {
		m_pBottom->next = 0;
	}
	delete temp;
	
    return GOOD;
}

/******************************** E O F ***********************************/
