/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/SYMUSER1.H__   1.8   20 Jun 1996 09:25:30   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/SYMUSER1.H__  $
** 
**    Rev 1.8   20 Jun 1996 09:25:30   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.6   10 Jun 1996 10:20:08   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.4   29 May 1996 09:29:34   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:06:50   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:09:52   ZJRD
** EasyPack/SLD Version 1.93
** 
**    Rev 1.1   02 May 1996 10:27:58   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.0   18 Apr 1996 12:58:48   Shirley
** Initial revision.
** 
****************************************************************************/

/****************************************************************************
**
**  Name:  SYMUSER1.H
**
**  Description:
**      All user defined variable API's have the prefix: SymUserVar
**      Major header file used by user defined variable.
**
**  Status:  CODED
**
**    Rev 1.0   12 April 1995 13:00:00   Gates Hua
** Initial revision.
**
**  Copyright (C) 1995 Microtek International.  All rights reserved.
**
*****************************************************************************/
#ifndef _SYMUSER1_H_
#define _SYMUSER1_H_
                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/


                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

/////////////////////////////////////////////////////////////////
// User defined symbol node frame
/////////////////////////////////////////////////////////////////
struct SymUserVarNode {        
    char *name; 	// symbol name
    short nValue;   // symbol value
    struct SymUserVarNode *next;    // pointer to next name ; sort by name
public :
    SymUserVarNode() {
        name = 0;
		nValue = 0;
        next = 0;
    };  
};
    
struct SymUserVarNodeIndex {
    int num;                         
    struct SymUserVarNode *node;       
    struct SymUserVarNodeIndex *next;  
public :
    SymUserVarNodeIndex() {
        num = 0;
        node = 0;
        next = 0;
    };  
};
  
/////////////////////////////////////////////////////////////////
// User defined symbol Server main frame
/////////////////////////////////////////////////////////////////
class SymUserVarTable {
private :
    U32 symno;
    struct SymUserVarNode *namePtr;
    struct SymUserVarNodeIndex *nameIndexPtr;

    struct SymUserVarNode *matchPtr;
    struct SymUserVarNode *preMatchPtr;
public :
    SymUserVarTable() {
        symno = 0;
        namePtr = 0;
        nameIndexPtr = 0;
        
        matchPtr = 0;
        preMatchPtr = 0;
    };
    ~SymUserVarTable(); 
             
public :
    int SymUserVarCreate(char *str);
    int SymUserVarDelete(char *str);
    void SymUserVarDeleteAll(void);
    int SymUserVarList( void );
    int SymUserVarGetValue(char *str,short& value);
    int SymUserVarSetValue(char *str,short value);
	int IsPC(char *str);    

private :   
    int SymUserVarAddNode(struct SymUserVarNode *node);
    void SymUserVarSearchNodeByName( char *str );
    void SymUserVarRejustNameIndex(void);
    void SymUserVarClearUpNode();
    void SymUserVarClearUpIndex();
	int SetPC(short value);
	int GetPC(short& value);
    
};              

extern void ShowLine(char *);
extern void ShlReShowLine(char * , int);

#endif
/******************************** E O F ***********************************/
