
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/SYNCORE.CPP   1.8   20 Jun 1996 09:27:22   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/SYNCORE.CPP  $
** 
**    Rev 1.8   20 Jun 1996 09:27:22   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.6   10 Jun 1996 10:22:00   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.4   29 May 1996 09:32:30   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:03:42   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:12:34   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:27:28   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 13:01:12   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:38:10   Shirley
** No change.
** 
**    Rev 1.29   02 Apr 1996 09:23:14   Shirley
** No change.
** 
**    Rev 1.28   15 Feb 1996 08:51:08   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:03:34   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:30:04   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:44:24   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:17:22   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:15:32   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:15:26   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:37:22   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:22:50   Shirley
** EasypPack/SLD Version 0.34c
** 
**    Rev 1.19   18 Jan 1996 10:12:18   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:15:18   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:09:04   Shirley
** EasyPack/SLD Version 0.34
** 
**    Rev 1.16   30 Nov 1995 09:12:42   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:29:44   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:19:18   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:22:00   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:33:36   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:30:04   Shirley
** EasyPack/SLD Version 0.23
** 
**    Rev 1.10   08 Nov 1995 12:40:28   Shirley
** EasyPack/SLD Version 0.22
** 
**    Rev 1.9   02 Nov 1995 10:04:08   Shirley
** EasyPack/SLD Version 0.21
** 
**    Rev 1.8   27 Oct 1995 16:46:08   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:48:26   Shirley
** EasyPack/SLD Version 0.1g
** 
**    Rev 1.6   25 Oct 1995 14:29:42   Shirley
** EasyPack/SLD Version 0.1f
** 
**    Rev 1.5   18 Oct 1995 14:48:14   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:22:10   Shirley
** EasyPack/SLD Version 0.1d
** 
**    Rev 1.3   29 Sep 1995 09:51:12   Shirley
** EasyPack/SLD Version 0.1c
** 
**    Rev 1.2   20 Sep 1995 10:53:56   Shirley
** EasyPack/SLD Version 0.1b
** 
**    Rev 1.1   15 Sep 1995 09:45:22   Shirley
** EasyPack/SLDV0.1a 
** 
**    Rev 1.0   07 Sep 1995 09:55:32   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: SYNCORE.CPP
//
//  Description: The implementation file for the class: CSyntaxCore.
//
//  Author: Chen Jun
//
//  Date: 05/17/95
//
//  Modification:
//      1. 05/17/95, Initial version of the class: CSyntaxCore.
//      2. 10/10/95, Remove Stepoption command.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"

#include "syncore.h"


/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Type definitions.


/////////////////////////////////////////////////////////////////////////////
// Macro definitions.


/////////////////////////////////////////////////////////////////////////////
// Global variables.


/////////////////////////////////////////////////////////////////////////////
// Static variables.


/////////////////////////////////////////////////////////////////////////////
// External variables.


/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.


/////////////////////////////////////////////////////////////////////////////
// Local function prototypes.


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.


/////////////////////////////////////////////////////////////////////////////
// Executable codes.

/////////////////////////////////////////////////////////////////////////////
// Public functions.

 
/////////////////////////////////////////////////////////////////////////////
// Implementation codes of class: CSyntaxCore.

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CSyntaxCore::CSyntaxCore().
//
//  Description: The construction of the class: CSyntaxCore.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
CSyntaxCore::CSyntaxCore()
{
    // Command parsing varibles initialization.
    m_nArgc = 0;
    for ( int i = 0; i < MAX_ARGV; i++ ) {
        m_pszArgv[i] = 0;
    }

    // Syntax error ID initialization.
    m_nErrorID = 0;

}   // End of CSyntaxCore::CSyntaxCore().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CSyntaxCore::~CSyntaxCore().
//
//  Description: The destruction of the class: CSyntaxCore.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
CSyntaxCore::~CSyntaxCore()
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc >= 0 && m_nArgc <= MAX_ARGV );

    // Release the allocated space.
    for ( int i = 0; i < m_nArgc; i++ ) {
        if ( m_pszArgv[i] ) {
            delete []m_pszArgv[i];
            m_pszArgv[i] = 0;
        }
    }

}   // End of CSyntaxCore::~CSyntaxCore().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CSyntaxCore::PreStringData().
//
//  Description: Pre-process the "string" & data.
//
//  Input:  nArgc - Subscribution of the "string"/data argument.
//          nDigit - bit:1; byte:2; word:4; long:8
//
//  Output: m_nArgc & m_nArgv.
//
//  Return: FALSE - syntax error; TRUE - OK.
//
/////////////////////////////////////////////////////////////////////////////
BOOL CSyntaxCore::PreStringData(int nArgc, unsigned uDigit)
{
    // Assertion of the input parameters.
    ASSERT( 1 == uDigit || 2 == uDigit ||
            4 == uDigit || 8 == uDigit );

    // Pre-process the "string" & data.
    BOOL isString = FALSE;
    char pszArgv[256];
    memset(pszArgv, 0, sizeof(pszArgv));

    if ( '\"' == *m_pszArgv[nArgc] ) {
        isString = TRUE;
    }

    for ( int i = nArgc; i < m_nArgc; i++ ) {
        if ( m_pszArgv[i] ) {
            if ( FALSE == isString ) {
                if ( strlen(m_pszArgv[i]) > uDigit ) {
                    m_nErrorID = SYNTAX_ERROR;
                    return (FALSE);
                }
            }
            strcat(pszArgv, m_pszArgv[i]);
            delete []m_pszArgv[i];
            m_pszArgv[i] = 0;
            if ( FALSE == isString ) {
                strcat(pszArgv, " ");
            }
            else {
                pszArgv[strlen(pszArgv)-1] = 0;
            }
        }
    }
    m_nArgc = nArgc + 1;

    m_pszArgv[m_nArgc-1] = new char[MAX_CMDLINE+1];
    if ( !m_pszArgv[m_nArgc-1] ) {
        AfxMessageBox("Insufficient Memory !");
        ASSERT( FALSE );
        return (FALSE);
    }
    else {
        memset(m_pszArgv[m_nArgc-1], 0, sizeof(m_pszArgv[m_nArgc-1]));
        for ( i = strlen(pszArgv)-1; i >= 0; i-- ) {
            if ( ' ' != pszArgv[i] ) {
                break;
            }
            else {
                pszArgv[i] = 0;
            }
        }
        if ( !isString ) {
            strcat(pszArgv, " ");
        }
        strcpy(m_pszArgv[m_nArgc-1], pszArgv);
        //DumpText(m_pszArgv[m_nArgc-1]);
    }
    
    return (TRUE);

}   // End of CSyntaxCore::PreStringData().


// Convert all the symbolic parameters to the standard address format.
void CSyntaxCore::SymToAddr(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Convert the parameters.
    for ( i = 1; i < m_nArgc; i++ ) {
        if ( '#' == m_pszArgv[i][0] ) {
            char szAddr[256];
            SymbolToAddr(m_pszArgv[i], szAddr);
            if ( 0 != strcmp(m_pszArgv[i], szAddr) ) {
                delete []m_pszArgv[i];
                m_pszArgv[i] = new char[strlen(szAddr)+1];
                strcpy(m_pszArgv[i], szAddr);
            }
        }
    }

}   // End of CSyntaxCore::SymToAddr().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CSyntaxCore::SyntaxDispatch().
//
//  Description: Invoke the syntax checking routine.
//
//  Input:  nCommandID - ID of the command.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void CSyntaxCore::SyntaxDispatch(const int nCommandID)
{
    // Assertion of the input parameters.
    ASSERT( nCommandID >= MIN_CMDID && nCommandID <= MAX_CMDID );

    // Reset the error ID.
    m_nErrorID = 0;
        
    // Dispatch the syntax checking routine.
    switch ( nCommandID ) {
        case CMDID_ASSEMBLE:
            SymToAddr();
            SyntaxCheckAssemble();
            break;
        case CMDID_BIT:
            SymToAddr();
            SyntaxCheckBit();
            break;
        case CMDID_BREAKPOINT:
            SymToAddr();
            SyntaxCheckBreakpoint();
            break;
        case CMDID_BYTE:
            SymToAddr();
            SyntaxCheckByte();
            break;
        case CMDID_CHECKSUM:
            SymToAddr();
            SyntaxCheckChecksum();
            break;
        case CMDID_CLEAR:
            SymToAddr();
            SyntaxCheckClear();
            break;
        case CMDID_COMPARE:
            SymToAddr();
            SyntaxCheckCompare();
            break;
        case CMDID_CONTROL:
            SyntaxCheckControl();
            break;
        case CMDID_COPY:
            SymToAddr();
            SyntaxCheckCopy();
            break;
//        case CMDID_CPU:
//            SyntaxCheckCpu();
//            break;
        case CMDID_CYCLE:
            SyntaxCheckCycle();
            break;
        case CMDID_DISASSEMBLE:
            SymToAddr();
            SyntaxCheckDisassemble();
            break;
        case CMDID_EVENT:
            SymToAddr();
            SyntaxCheckEvent();
            break;
        case CMDID_EV1:
            SymToAddr();
            SyntaxCheckEv1();
            break;
        case CMDID_EV2:
            SymToAddr();
            SyntaxCheckEv2();
            break;
        case CMDID_EV3:
            SyntaxCheckEv3();
            break;
        case CMDID_FILL:
            SymToAddr();
            SyntaxCheckFill();
            break;
        case CMDID_GO:
            SymToAddr();
            SyntaxCheckGo();
            break;
        case CMDID_HALT:
            SyntaxCheckHalt();
            break;
        case CMDID_HELP:
            SyntaxCheckHelp();
            break;
        case CMDID_IDENTIFY:
            SyntaxCheckIdentify();
            break;
        case CMDID_INCLUDE:
            SyntaxCheckInclude();                      
            break;
        case CMDID_INPORT:
            SyntaxCheckInport();
            break;
        case CMDID_JUMP:
            SymToAddr();
            SyntaxCheckJump();
            break;
        case CMDID_LEVEL:
            SyntaxCheckLevel();
            break;
        case CMDID_LV1:
            SyntaxCheckLv1();
            break;
        case CMDID_LV2:
            SyntaxCheckLv2();
            break;
        case CMDID_LIST:
            SymToAddr();
            SyntaxCheckList();
            break;
        case CMDID_LOG:
            SyntaxCheckLog();
            break;
        case CMDID_LONG:
            SymToAddr();
            SyntaxCheckLong();
            break;
        case CMDID_MAP:
            SymToAddr();
            SyntaxCheckMap();
            break;
        case CMDID_MEMORY:
            SymToAddr();
            SyntaxCheckMemory();
            break;
        case CMDID_OUTPORT:
            SyntaxCheckOutport();
            break;
//        case CMDID_PATCH:
//            SymToAddr();
//            SyntaxCheckPatch();
//            break;
        case CMDID_PORT:
            SyntaxCheckPort();
            break;
        case CMDID_QUALIFY:
            SymToAddr();
            SyntaxCheckQualify();
            break;
//        case CMDID_QUIT:
//            SyntaxCheckQuit();
//            break;
        case CMDID_REGISTER:
            SyntaxCheckRegister();
            break;
        case CMDID_RESET:
            SymToAddr();
            SyntaxCheckReset();
            break;
        case CMDID_SEARCH:
            SymToAddr();
            SyntaxCheckSearch();
            break;
        case CMDID_STEP:
            SymToAddr();
            SyntaxCheckStep();
            break;
//        case CMDID_STEPOPTION:
//            SyntaxCheckStepoption();
//            break;
        case CMDID_TEST:
            SymToAddr();
            SyntaxCheckTest();
            break;
        case CMDID_TIMER:
            SyntaxCheckTimer();
            break;
        case CMDID_TRACE:
            SyntaxCheckTrace();
            break;
        case CMDID_TRIGGER:
            SyntaxCheckTrigger();
            break;
        case CMDID_UPLOAD:
            SymToAddr();
            SyntaxCheckUpload();
            break;
        case CMDID_VERIFY:
            SyntaxCheckVerify();
            break;
        case CMDID_WORD:
            SymToAddr();
            SyntaxCheckWord();
            break;
//        case CMDID_BACK:
//            SyntaxCheckBack();
//            break;
        case CMDID_CREATE:
            SyntaxCheckCreate();
            break;
        case CMDID_DELETE:
            SyntaxCheckDelete();
            break;
        case CMDID_LOAD:
            SyntaxCheckLoad();
            break;
//        case CMDID_MODULE:
//            SyntaxCheckModule();
//            break;
        case CMDID_QUERY:
            SyntaxCheckQuery();
            break;
        case CMDID_SSAVE:
            SyntaxCheckSsave();
            break;
        case CMDID_SRECALL:
            SyntaxCheckSrecall();
            break;
        case CMDID_SYMBOL:
            SyntaxCheckSymbol();
            break;
//        case CMDID_WATCH:
//            SyntaxCheckWatch();
//            break;
    
    #ifdef _CHEN_
        case CMDID_CALCULATE:
            SyntaxCheckCalculate();
            break;
    #endif  // _CHEN_

    #ifdef _GATES
        case CMDID_COUNT:
            SyntaxCheckCount();
            break;
        case CMDID_LINE:
            SyntaxCheckLine();
            break;
        case CMDID_STATEMENT:
            SyntaxCheckStatement();
            break;
        case CMDID_VOID:
            SyntaxCheckVoid();
            break;
        case CMDID_TYPE:
            SyntaxCheckType();
            break;
    #endif  // _GATES
                        
        default:
            ASSERT( FALSE );
            break;
    }
    
}   // End of CSyntaxCore::SyntaxDispatch().



/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CSyntaxCore::SyntaxCheck***().
//
//  Description: Syntax check kernel routine. 58 routines.
//
//  Input:  m_nArgc - The number of the command parameters.
//          m_pszArgv[nArgc] - The contents of the command parameters.
//
//  Output: m_nErrorID - ID of the syntax error.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////

// Assemble     [adr]
void CSyntaxCore::SyntaxCheckAssemble(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    // Check command syntax.
    switch ( m_nArgc ) {
        case 1:
            break;
        case 2:
            if ( !IsPAddr(m_pszArgv[1]) &&
                 !IsPAddrDefault(m_pszArgv[1]) &&
                 !IsXAddr(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }
    
}   // End of CSyntaxCore::SyntaxCheckAssemble().


// Bit          bit-adr {0|1} [..{0|1}]
void CSyntaxCore::SyntaxCheckBit(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Pre-process the field: "string" & Data.
    if ( m_nArgc < 3 ) {
        m_nErrorID = SYNTAX_ERROR;
        return;
    }
    
    int nArgc = 2;
    if ( !PreStringData(nArgc, 1) ) {
        return;
    }

    // Check command syntax.
    switch ( m_nArgc ) {
        case 3:
            if ( !IsBAddr(m_pszArgv[1]) &&
                 !IsBAddrDefault(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsDataBit(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsBitRange(m_pszArgv[1], m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckBit().


// BReakpoint   [adr]
void CSyntaxCore::SyntaxCheckBreakpoint(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    // Check command syntax.
    switch ( m_nArgc ) {
        case 1:
            break;
        case 2:
            if ( !IsPAddr(m_pszArgv[1]) &&
                 !IsPAddrDefault(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }
    
}   // End of CSyntaxCore::SyntaxCheckBreakpoint().


// Byte         adr data1 [.. data32]
void CSyntaxCore::SyntaxCheckByte(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Pre-process the field: "string" & Data.
    if ( m_nArgc < 3 ) {
        m_nErrorID = SYNTAX_ERROR;
        return;
    }
    
    int nArgc = 2;
    if ( !PreStringData(nArgc, 2) ) {
        return;
    }

    // Check command syntax.
    switch ( m_nArgc ) {
        case 3:
            if ( !IsPAddr(m_pszArgv[1]) &&
                 !IsXAddr(m_pszArgv[1]) &&
                 !IsIAddr(m_pszArgv[1]) &&
                 !IsRAddr(m_pszArgv[1]) &&
                 !IsBAddr(m_pszArgv[1]) &&
                 !IsXAddrDefault(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsData(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsDataRange(m_nArgc, m_pszArgv, 1) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckByte().


// CHecksum     adr1 {adr2|Length length}
void CSyntaxCore::SyntaxCheckChecksum(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Check command syntax.
    switch ( m_nArgc ) {
        case 3:
            if ( !IsPAddr(m_pszArgv[1]) &&
                 !IsXAddr(m_pszArgv[1]) &&
                 !IsIAddr(m_pszArgv[1]) &&
                 !IsXAddrDefault(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
                break;
            }
            else if ( !IsPAddr(m_pszArgv[2]) &&
                      !IsXAddr(m_pszArgv[2]) &&
                      !IsIAddr(m_pszArgv[2]) &&
                      !IsXAddrDefault(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
                break;
            }
            else if ( IsXAddrDefault(m_pszArgv[1]) ) {
                if ( !IsXAddr(m_pszArgv[2]) &&
                     !IsXAddrDefault(m_pszArgv[2]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                    break;
                }
            }
            if ( ':' == m_pszArgv[2][1] ) {
                if ( 'X' == toupper(m_pszArgv[2][0]) ) {
                    if ( !IsXAddr(m_pszArgv[1]) &&
                         !IsXAddrDefault(m_pszArgv[1]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        break;
                    }
                }
                else if ( toupper(m_pszArgv[1][0]) != 
                          toupper(m_pszArgv[2][0]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                    break;
                }
            }
            else {
                if ( IsXAddr(m_pszArgv[1]) || IsXAddrDefault(m_pszArgv[1]) ) {
                    if ( !IsXAddrDefault(m_pszArgv[2]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        break;
                    }
                }
                else if ( IsPAddr(m_pszArgv[1]) ) {
                    if ( !IsPAddrDefault(m_pszArgv[2]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        break;
                    }
                }
                else if ( IsIAddr(m_pszArgv[1]) ) {
                    if ( !IsIAddrDefault(m_pszArgv[2]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        break;
                    }
                }
                else {
                    m_nErrorID = SYNTAX_ERROR;
                    break;
                }
            }
            if ( !IsAddrRange(m_pszArgv[1], m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
                break;
            }
            break;
        case 4:
            if ( !IsPAddr(m_pszArgv[1]) &&
                 !IsXAddr(m_pszArgv[1]) &&
                 !IsIAddr(m_pszArgv[1]) &&
                 !IsXAddrDefault(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsKeywordLength(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsAddrLen(m_pszArgv[3]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsLengthRange(m_pszArgv[1], m_pszArgv[3]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // CSyntaxCore::SyntaxCheckChecksum().


// CLear        {All|adr}
void CSyntaxCore::SyntaxCheckClear(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    // Check command syntax.
    switch ( m_nArgc ) {
        case 2:
            if ( !IsPAddr(m_pszArgv[1]) && 
                 !IsPAddrDefault(m_pszArgv[1]) &&
                 !IsKeywordAll(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckClear().


// COMpare      adr1 {adr2|Length length} adr3
void CSyntaxCore::SyntaxCheckCompare(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Check command syntax.
    switch ( m_nArgc ) {
        case 4:
            if ( !IsPAddr(m_pszArgv[1]) &&
                 !IsXAddr(m_pszArgv[1]) &&
                 !IsXAddrDefault(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
                break;
            }
            else if ( !IsPAddr(m_pszArgv[2]) &&
                      !IsXAddr(m_pszArgv[2]) &&
                      !IsXAddrDefault(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
                break;
            }
            else if ( !IsPAddr(m_pszArgv[3]) &&
                      !IsXAddr(m_pszArgv[3]) &&
                      !IsXAddrDefault(m_pszArgv[3]) ) {
                m_nErrorID = SYNTAX_ERROR;
                break;
            }
            else if ( IsXAddrDefault(m_pszArgv[1]) ) {
                if ( !IsXAddr(m_pszArgv[2]) &&
                     !IsXAddrDefault(m_pszArgv[2]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                    break;
                }
            }
            if ( ':' == m_pszArgv[2][1] ) {
                if ( 'X' == toupper(m_pszArgv[2][0]) ) {
                    if ( !IsXAddr(m_pszArgv[1]) &&
                         !IsXAddrDefault(m_pszArgv[1]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        break;
                    }
                }
                else if ( toupper(m_pszArgv[1][0]) != 
                          toupper(m_pszArgv[2][0]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                    break;
                }
            }
            else {
                if ( IsXAddr(m_pszArgv[1]) || IsXAddrDefault(m_pszArgv[1]) ) {
                    if ( !IsXAddrDefault(m_pszArgv[2]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        break;
                    }
                }
                else if ( IsPAddr(m_pszArgv[1]) ) {
                    if ( !IsPAddrDefault(m_pszArgv[2]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        break;
                    }
                }
                else {
                    m_nErrorID = SYNTAX_ERROR;
                    break;
                }
            }
            if ( !IsAddrRange(m_pszArgv[1], m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
                break;
            }
            if ( !IsAddrRange(m_pszArgv[1], m_pszArgv[2], m_pszArgv[3]) ) {
                m_nErrorID = SYNTAX_ERROR;
                break;
            }
            break;
        case 5:
            if ( !IsPAddr(m_pszArgv[1]) &&
                 !IsXAddr(m_pszArgv[1]) &&
                 !IsXAddrDefault(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsPAddr(m_pszArgv[4]) &&
                      !IsXAddr(m_pszArgv[4]) &&
                      !IsXAddrDefault(m_pszArgv[4]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsKeywordLength(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsAddrLen(m_pszArgv[3]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsLengthRange(m_pszArgv[1], m_pszArgv[3]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsLengthRange(m_pszArgv[1], m_pszArgv[3], m_pszArgv[4]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckCompare().


// CONtrol      [ {Reset|Ea|Eben} {Enable|Disable} ]
void CSyntaxCore::SyntaxCheckControl(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    // Check command syntax.
    switch ( m_nArgc ) {
        case 1:
            break;
        case 3:
            /*
            if ( !IsKeywordReset(m_pszArgv[1]) && 
                 !IsKeywordEa(m_pszArgv[1]) &&
                 !IsKeywordEben(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            */
            if ( !IsKeywordControlOption(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsKeywordEnable(m_pszArgv[2]) && 
                      !IsKeywordDisable(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckControl().


// Copy         adr1 {adr2|Length length} adr3
void CSyntaxCore::SyntaxCheckCopy(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Check command syntax.
    switch ( m_nArgc ) {
        case 4:
            if ( !IsPAddr(m_pszArgv[1]) &&
                 !IsXAddr(m_pszArgv[1]) &&
                 !IsXAddrDefault(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
                break;
            }
            else if ( !IsPAddr(m_pszArgv[2]) &&
                      !IsXAddr(m_pszArgv[2]) &&
                      !IsXAddrDefault(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
                break;
            }
            else if ( !IsPAddr(m_pszArgv[3]) &&
                      !IsXAddr(m_pszArgv[3]) &&
                      !IsXAddrDefault(m_pszArgv[3]) ) {
                m_nErrorID = SYNTAX_ERROR;
                break;
            }
            else if ( IsXAddrDefault(m_pszArgv[1]) ) {
                if ( !IsXAddr(m_pszArgv[2]) &&
                     !IsXAddrDefault(m_pszArgv[2]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                    break;
                }
            }
            if ( ':' == m_pszArgv[2][1] ) {
                if ( 'X' == toupper(m_pszArgv[2][0]) ) {
                    if ( !IsXAddr(m_pszArgv[1]) &&
                         !IsXAddrDefault(m_pszArgv[1]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        break;
                    }
                }
                else if ( toupper(m_pszArgv[1][0]) != 
                          toupper(m_pszArgv[2][0]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                    break;
                }
            }
            else {
                if ( IsXAddr(m_pszArgv[1]) || IsXAddrDefault(m_pszArgv[1]) ) {
                    if ( !IsXAddrDefault(m_pszArgv[2]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        break;
                    }
                }
                else if ( IsPAddr(m_pszArgv[1]) ) {
                    if ( !IsPAddrDefault(m_pszArgv[2]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        break;
                    }
                }
                else {
                    m_nErrorID = SYNTAX_ERROR;
                    break;
                }
            }
            if ( !IsAddrRange(m_pszArgv[1], m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
                break;
            }
            if ( !IsAddrRange(m_pszArgv[1], m_pszArgv[2], m_pszArgv[3]) ) {
                m_nErrorID = SYNTAX_ERROR;
                break;
            }
            break;
        case 5:
            if ( !IsPAddr(m_pszArgv[1]) &&
                 !IsXAddr(m_pszArgv[1]) &&
                 !IsXAddrDefault(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsPAddr(m_pszArgv[4]) &&
                      !IsXAddr(m_pszArgv[4]) &&
                      !IsXAddrDefault(m_pszArgv[4]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsKeywordLength(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsAddrLen(m_pszArgv[3]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsLengthRange(m_pszArgv[1], m_pszArgv[3]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsLengthRange(m_pszArgv[1], m_pszArgv[3], m_pszArgv[4]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckCopy().


// CPu          [cpuModule]
void CSyntaxCore::SyntaxCheckCpu(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Check command syntax.
    switch ( m_nArgc ) {
        case 1:
            break;
        case 2:
            if ( !IsCpuModule(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckCpu().


// CYcle
void CSyntaxCore::SyntaxCheckCycle(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Check command syntax.
    switch ( m_nArgc ) {
        case 1:
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckCycle().

        
// Disassemble  [adr1 [adr2|Length length]]
void CSyntaxCore::SyntaxCheckDisassemble(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Check command syntax.
    switch ( m_nArgc ) {
        case 1:
            break;
        case 2:
            if ( !IsPAddr(m_pszArgv[1]) &&
                 !IsPAddrDefault(m_pszArgv[1]) &&
                 !IsXAddr(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        case 3:
            if ( !IsPAddr(m_pszArgv[1]) &&
                 !IsPAddrDefault(m_pszArgv[1]) &&
                 !IsXAddr(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
                break;
            }
            else if ( !IsPAddr(m_pszArgv[2]) &&
                      !IsPAddrDefault(m_pszArgv[2]) &&
                      !IsXAddr(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
                break;
            }
            else if ( IsPAddrDefault(m_pszArgv[1]) ) {
                if ( !IsPAddr(m_pszArgv[2]) &&
                     !IsPAddrDefault(m_pszArgv[2]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                    break;
                }
            }
            if ( ':' == m_pszArgv[2][1] ) {
                if ( 'P' == toupper(m_pszArgv[2][0]) ) {
                    if ( !IsPAddr(m_pszArgv[1]) &&
                         !IsPAddrDefault(m_pszArgv[1]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        break;
                    }
                }
                else if ( toupper(m_pszArgv[1][0]) != 
                          toupper(m_pszArgv[2][0]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                    break;
                }
            }
            else {
                if ( IsXAddr(m_pszArgv[1]) || IsXAddrDefault(m_pszArgv[1]) ) {
                    if ( !IsXAddrDefault(m_pszArgv[2]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        break;
                    }
                }
                else if ( IsPAddr(m_pszArgv[1]) ) {
                    if ( !IsPAddrDefault(m_pszArgv[2]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        break;
                    }
                }
                else {
                    m_nErrorID = SYNTAX_ERROR;
                    break;
                }
            }
            if ( !IsAddrRange(m_pszArgv[1], m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
                break;
            }
            break;
        case 4:
            if ( !IsPAddr(m_pszArgv[1]) &&
                 !IsPAddrDefault(m_pszArgv[1]) &&
                 !IsXAddr(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsKeywordLength(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsAddrLen(m_pszArgv[3]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsLengthRange(m_pszArgv[1], m_pszArgv[3]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckDisassemble().


// Event        [CLear]
// Event 1 ... = EV1 ...
// Event 2 ... = EV2 ...
// Event 3 ... = EV3 ...
void CSyntaxCore::SyntaxCheckEvent(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Check command syntax.
    if ( m_nArgc < 1 ) {
        m_nErrorID = SYNTAX_ERROR;
        return;
    }
    else if ( 1 == m_nArgc ) {
        return;
    }
    else if ( 2 == m_nArgc ) {
        if ( !IsKeywordClear(m_pszArgv[1]) && 
             !IsEventID(m_pszArgv[1]) ) {
            m_nErrorID = SYNTAX_ERROR;
        }
        return;
    }
    else if ( 3 == m_nArgc ) {
        if ( !IsEventID(m_pszArgv[1]) ) {
            m_nErrorID = SYNTAX_ERROR;
        }
        else if ( 0 == stricmp(m_pszArgv[1],"3") ) {
            if ( !IsKeywordHigh(m_pszArgv[2]) &&
                 !IsKeywordLow(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
        }
        else {
            if ( !IsKeywordClear(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
        }
        return;
    }
    else {
        if ( 0 == stricmp(m_pszArgv[1], "1") ) {
            // Event 1 ...
            // Check m_pszArgv[2].
            if ( 0 != stricmp(m_pszArgv[2], "ADDRESS") &&
                 0 != stricmp(m_pszArgv[2], "DATUM") &&
                 0 != stricmp(m_pszArgv[2], "STATUS") &&
                 0 != stricmp(m_pszArgv[2], "COUNT") ) {
                m_nErrorID = SYNTAX_ERROR;
                return;
            }
            
            // Initial flag.
            BOOL isA = FALSE;
            BOOL isD = FALSE;
            BOOL isS = FALSE;
            BOOL isC = FALSE;
            int nIndex = 2;
    
            // Check m_pszArgv[].
            while ( nIndex < m_nArgc ) {
                if ( 0 == stricmp(m_pszArgv[nIndex], "ADDRESS") ) {
                    // "ADDRESS...".
                    if ( isA ) {
                        m_nErrorID = SYNTAX_ERROR;
                        return;
                    }
                    else {
                        isA = TRUE;
                    }
                    nIndex++;
                    if ( nIndex >= m_nArgc ) {
                        m_nErrorID = SYNTAX_ERROR;
                        return;
                    }
                    if ( IsKeywordRange(m_pszArgv[nIndex]) ) {
                        nIndex++;
                        if ( nIndex >= m_nArgc ) {
                            m_nErrorID = SYNTAX_ERROR;
                            return;
                        }
                        if ( !IsPAddr(m_pszArgv[nIndex]) &&
                             !IsPAddrDefault(m_pszArgv[nIndex]) ) {
                            m_nErrorID = SYNTAX_ERROR;
                            return;
                        }
                        else {
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                                m_nErrorID = SYNTAX_ERROR;
                                return;
                            }
                            if ( !IsPAddr(m_pszArgv[nIndex]) &&
                                 !IsPAddrDefault(m_pszArgv[nIndex]) ) {
                                m_nErrorID = SYNTAX_ERROR;
                                return;
                            }
                            else {
                                nIndex++;
                            }
                        }
                    }
                    else if ( IsWildcardAddr(m_pszArgv[nIndex]) ) {
                        nIndex++;
                    }
                    else if ( IsPAddr(m_pszArgv[nIndex]) ||
                              IsPAddrDefault(m_pszArgv[nIndex]) ) {
                        nIndex++;
                        if ( nIndex >= m_nArgc ) {
                            return;
                        }
                        for ( int i = 2; i <= 10; i++ ) {
                            if ( IsPAddr(m_pszArgv[nIndex]) ||
                                 IsPAddrDefault(m_pszArgv[nIndex]) ) {
                                nIndex++;
                                if ( nIndex >= m_nArgc ) {
                                    return;
                                }
                            }
                            else {
                                break;
                            }
                        }
                    }
                    else {
                        m_nErrorID = SYNTAX_ERROR;
                        return;
                    }
                }   // End of "ADDRESS...".
    
                else if ( 0 == stricmp(m_pszArgv[nIndex], "DATUM") ) {
                    // "DATUM...".
                    if ( isD ) {
                        m_nErrorID = SYNTAX_ERROR;
                        return;
                    }
                    else {
                        isD = TRUE;
                    }
                    nIndex++;
                    if ( nIndex >= m_nArgc ) {
                        m_nErrorID = SYNTAX_ERROR;
                        return;
                    }
                    if ( IsKeywordRange(m_pszArgv[nIndex]) ) {
                        nIndex++;
                        if ( nIndex >= m_nArgc ) {
                            m_nErrorID = SYNTAX_ERROR;
                            return;
                        }
                        if ( !IsEventData(m_pszArgv[nIndex]) ) {
                            m_nErrorID = SYNTAX_ERROR;
                            return;
                        }
                        else {
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                                m_nErrorID = SYNTAX_ERROR;
                                return;
                            }
                            if ( !IsEventData(m_pszArgv[nIndex]) ) {
                                m_nErrorID = SYNTAX_ERROR;
                                return;
                            }
                            else {
                                nIndex++;
                                if ( nIndex >= m_nArgc ) {
                                    return;
                                }
                            }
                        }
                    }
                    else if ( IsWildcardData(m_pszArgv[nIndex]) ) {
                        nIndex++;
                        if ( nIndex >= m_nArgc ) {
                            return;
                        }
                    }
                    else if ( IsEventData(m_pszArgv[nIndex]) ) {
                        nIndex++;
                        if ( nIndex >= m_nArgc ) {
                            return;
                        }
                    }
                    else {
                        m_nErrorID = SYNTAX_ERROR;
                        return;
                    }
                }   // End of "DATUM...".
    
                else if ( 0 == stricmp(m_pszArgv[nIndex], "STATUS") ) {
                    // "STATUS...".
                    if ( isS ) {
                        m_nErrorID = SYNTAX_ERROR;
                        return;
                    }
                    else {
                        isS = TRUE;
                    }
                    nIndex++;
                    if ( nIndex >= m_nArgc ) {
                        m_nErrorID = SYNTAX_ERROR;
                        return;
                    }
                    // Is "S", "F", "R", "W" or "AK".
                    BOOL isStatusS = FALSE;
                    BOOL isStatusF = FALSE;
                    BOOL isStatusR = FALSE;
                    BOOL isStatusW = FALSE;
                    BOOL isStatusAK = FALSE;
    
                    if ( !stricmp(m_pszArgv[nIndex],"S") && !isStatusS ) {
                        isStatusS = TRUE;
                    }
                    else if ( !stricmp(m_pszArgv[nIndex],"F") && !isStatusF ) {
                        isStatusF = TRUE;
                    }
                    else if ( !stricmp(m_pszArgv[nIndex],"R") && !isStatusR ) {
                        isStatusR = TRUE;
                    }
                    else if ( !stricmp(m_pszArgv[nIndex],"W") && !isStatusW ) {
                        isStatusW = TRUE;
                    }
                    else if ( !stricmp(m_pszArgv[nIndex],"AK") && !isStatusAK ) {
                        isStatusAK = TRUE;
                    }
                    else {
                        m_nErrorID = SYNTAX_ERROR;
                        return;
                    }
    
                    nIndex++;
                    if ( nIndex >= m_nArgc ) {
                        return;
                    }
                    for ( int j = 2; j <= 5; j++ ) {
                        if ( 0 == stricmp(m_pszArgv[nIndex], "S") ) {
                            if ( !isStatusS ) {
                                isStatusS = TRUE;
                                nIndex++;
                                if ( nIndex >= m_nArgc ) {
                                    return;
                                }
                            }
                            else {
                                m_nErrorID = SYNTAX_ERROR;
                                return;
                            }
                        }
                        else if ( 0 == stricmp(m_pszArgv[nIndex], "F") ) {
                            if ( !isStatusF ) {
                                isStatusF = TRUE;
                                nIndex++;
                                if ( nIndex >= m_nArgc ) {
                                    return;
                                }
                            }
                            else {
                                m_nErrorID = SYNTAX_ERROR;
                                return;
                            }
                        }
                        else if ( 0 == stricmp(m_pszArgv[nIndex], "R") ) {
                            if ( !isStatusR ) {
                                isStatusR = TRUE;
                                nIndex++;
                                if ( nIndex >= m_nArgc ) {
                                    return;
                                }
                            }
                            else {
                                m_nErrorID = SYNTAX_ERROR;
                                return;
                            }
                        }
                        else if ( 0 == stricmp(m_pszArgv[nIndex], "W") ) {
                            if ( !isStatusW ) {
                                isStatusW = TRUE;
                                nIndex++;
                                if ( nIndex >= m_nArgc ) {
                                    return;
                                }
                            }
                            else {
                                m_nErrorID = SYNTAX_ERROR;
                                return;
                            }
                        }
                        else if ( 0 == stricmp(m_pszArgv[nIndex], "AK") ) {
                            if ( !isStatusAK ) {
                                isStatusAK = TRUE;
                                nIndex++;
                                if ( nIndex >= m_nArgc ) {
                                    return;
                                }
                            }
                            else {
                                m_nErrorID = SYNTAX_ERROR;
                                return;
                            }
                        }
                        else {
                            break;
                        }
                    }
                }   // End of "STATUS...".
                
                else if ( 0 == stricmp(m_pszArgv[nIndex], "COUNT") ) {
                    // "COUNT...".
                    if ( isC ) {
                        m_nErrorID = SYNTAX_ERROR;
                        return;
                    }
                    else {
                        isC = TRUE;
                    }
                    nIndex++;
                    if ( nIndex >= m_nArgc ) {
                        m_nErrorID = SYNTAX_ERROR;
                        return;
                    }
                    if ( IsAddrData(m_pszArgv[nIndex]) ) {
                        nIndex++;
                        if ( nIndex >= m_nArgc ) {
                            return;
                        }
                    }
                    else {
                        m_nErrorID = SYNTAX_ERROR;
                        return;
                    }
                }   // End of "COUNT...".
                
                else {
                    // Not "A", "D", "S" or "C".
                    m_nErrorID = SYNTAX_ERROR;
                    return;
                }
                
            }   // End of while()...
        }   // End of Event 1.
        
        else if ( 0 == stricmp(m_pszArgv[1], "2") ) {
            // Event 2 ...    
            // Check m_pszArgv[1].
            if ( 0 != stricmp(m_pszArgv[2], "ADDRESS") &&
                 0 != stricmp(m_pszArgv[2], "DATUM") &&
                 0 != stricmp(m_pszArgv[2], "STATUS") ) {
                m_nErrorID = SYNTAX_ERROR;
                return;
            }
            
            // Initial flag.
            BOOL isA = FALSE;
            BOOL isD = FALSE;
            BOOL isS = FALSE;
            int nIndex = 2;
    
            // Check m_pszArgv[].
            while ( nIndex < m_nArgc ) {
                if ( 0 == stricmp(m_pszArgv[nIndex], "ADDRESS") ) {
                    // "ADDRESS...".
                    if ( isA ) {
                        m_nErrorID = SYNTAX_ERROR;
                        return;
                    }
                    else {
                        isA = TRUE;
                    }
                    nIndex++;
                    if ( nIndex >= m_nArgc ) {
                        m_nErrorID = SYNTAX_ERROR;
                        return;
                    }
                    if ( IsKeywordRange(m_pszArgv[nIndex]) ) {
                        nIndex++;
                        if ( nIndex >= m_nArgc ) {
                            m_nErrorID = SYNTAX_ERROR;
                            return;
                        }
                        if ( !IsPAddr(m_pszArgv[nIndex]) &&
                             !IsPAddrDefault(m_pszArgv[nIndex]) ) {
                            m_nErrorID = SYNTAX_ERROR;
                            return;
                        }
                        else {
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                                m_nErrorID = SYNTAX_ERROR;
                                return;
                            }
                            if ( !IsPAddr(m_pszArgv[nIndex]) &&
                                 !IsPAddrDefault(m_pszArgv[nIndex]) ) {
                                m_nErrorID = SYNTAX_ERROR;
                                return;
                            }
                            else {
                                nIndex++;
                            }
                        }
                    }
                    else if ( IsWildcardAddr(m_pszArgv[nIndex]) ) {
                        nIndex++;
                    }
                    else if ( IsPAddr(m_pszArgv[nIndex]) ||
                              IsPAddrDefault(m_pszArgv[nIndex]) ) {
                        nIndex++;
                        if ( nIndex >= m_nArgc ) {
                            return;
                        }
                        for ( int i = 2; i <= 10; i++ ) {
                            if ( IsPAddr(m_pszArgv[nIndex]) ||
                                 IsPAddrDefault(m_pszArgv[nIndex]) ) {
                                nIndex++;
                                if ( nIndex >= m_nArgc ) {
                                    return;
                                }
                            }
                            else {
                                break;
                            }
                        }
                    }
                    else {
                        m_nErrorID = SYNTAX_ERROR;
                        return;
                    }
                }   // End of "ADDRESS...".
    
                else if ( 0 == stricmp(m_pszArgv[nIndex], "DATUM") ) {
                    // "DATUM...".
                    if ( isD ) {
                        m_nErrorID = SYNTAX_ERROR;
                        return;
                    }
                    else {
                        isD = TRUE;
                    }
                    nIndex++;
                    if ( nIndex >= m_nArgc ) {
                        m_nErrorID = SYNTAX_ERROR;
                        return;
                    }
                    if ( IsKeywordRange(m_pszArgv[nIndex]) ) {
                        nIndex++;
                        if ( nIndex >= m_nArgc ) {
                            m_nErrorID = SYNTAX_ERROR;
                            return;
                        }
                        if ( !IsEventData(m_pszArgv[nIndex]) ) {
                            m_nErrorID = SYNTAX_ERROR;
                            return;
                        }
                        else {
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                                m_nErrorID = SYNTAX_ERROR;
                                return;
                            }
                            if ( !IsEventData(m_pszArgv[nIndex]) ) {
                                m_nErrorID = SYNTAX_ERROR;
                                return;
                            }
                            else {
                                nIndex++;
                                if ( nIndex >= m_nArgc ) {
                                    return;
                                }
                            }
                        }
                    }
                    else if ( IsWildcardData(m_pszArgv[nIndex]) ) {
                        nIndex++;
                        if ( nIndex >= m_nArgc ) {
                            return;
                        }
                    }
                    else if ( IsEventData(m_pszArgv[nIndex]) ) {
                        nIndex++;
                        if ( nIndex >= m_nArgc ) {
                            return;
                        }
                    }
                    else {
                        m_nErrorID = SYNTAX_ERROR;
                        return;
                    }
                }   // End of "DATUM...".
    
                else if ( 0 == stricmp(m_pszArgv[nIndex], "STATUS") ) {
                    // "STATUS...".
                    if ( isS ) {
                        m_nErrorID = SYNTAX_ERROR;
                        return;
                    }
                    else {
                        isS = TRUE;
                    }
                    nIndex++;
                    if ( nIndex >= m_nArgc ) {
                        m_nErrorID = SYNTAX_ERROR;
                        return;
                    }
                    // Is "S", "F", "R", "W" or "AK".
                    BOOL isStatusS = FALSE;
                    BOOL isStatusF = FALSE;
                    BOOL isStatusR = FALSE;
                    BOOL isStatusW = FALSE;
                    BOOL isStatusAK = FALSE;
    
                    if ( !stricmp(m_pszArgv[nIndex],"S") && !isStatusS ) {
                        isStatusS = TRUE;
                    }
                    else if ( !stricmp(m_pszArgv[nIndex],"F") && !isStatusF ) {
                        isStatusF = TRUE;
                    }
                    else if ( !stricmp(m_pszArgv[nIndex],"R") && !isStatusR ) {
                        isStatusR = TRUE;
                    }
                    else if ( !stricmp(m_pszArgv[nIndex],"W") && !isStatusW ) {
                        isStatusW = TRUE;
                    }
                    else if ( !stricmp(m_pszArgv[nIndex],"AK") && !isStatusAK ) {
                        isStatusAK = TRUE;
                    }
                    else {
                        m_nErrorID = SYNTAX_ERROR;
                        return;
                    }
    
                    nIndex++;
                    if ( nIndex >= m_nArgc ) {
                        return;
                    }
                    for ( int j = 2; j <= 5; j++ ) {
                        if ( 0 == stricmp(m_pszArgv[nIndex], "S") ) {
                            if ( !isStatusS ) {
                                isStatusS = TRUE;
                                nIndex++;
                                if ( nIndex >= m_nArgc ) {
                                    return;
                                }
                            }
                            else {
                                m_nErrorID = SYNTAX_ERROR;
                                return;
                            }
                        }
                        else if ( 0 == stricmp(m_pszArgv[nIndex], "F") ) {
                            if ( !isStatusF ) {
                                isStatusF = TRUE;
                                nIndex++;
                                if ( nIndex >= m_nArgc ) {
                                    return;
                                }
                            }
                            else {
                                m_nErrorID = SYNTAX_ERROR;
                                return;
                            }
                        }
                        else if ( 0 == stricmp(m_pszArgv[nIndex], "R") ) {
                            if ( !isStatusR ) {
                                isStatusR = TRUE;
                                nIndex++;
                                if ( nIndex >= m_nArgc ) {
                                    return;
                                }
                            }
                            else {
                                m_nErrorID = SYNTAX_ERROR;
                                return;
                            }
                        }
                        else if ( 0 == stricmp(m_pszArgv[nIndex], "W") ) {
                            if ( !isStatusW ) {
                                isStatusW = TRUE;
                                nIndex++;
                                if ( nIndex >= m_nArgc ) {
                                    return;
                                }
                            }
                            else {
                                m_nErrorID = SYNTAX_ERROR;
                                return;
                            }
                        }
                        else if ( 0 == stricmp(m_pszArgv[nIndex], "AK") ) {
                            if ( !isStatusAK ) {
                                isStatusAK = TRUE;
                                nIndex++;
                                if ( nIndex >= m_nArgc ) {
                                    return;
                                }
                            }
                            else {
                                m_nErrorID = SYNTAX_ERROR;
                                return;
                            }
                        }
                        else {
                            break;
                        }
                    }
                }   // End of "STATUS...".
                
                else {
                    // Not "A", "D", or "S".
                    m_nErrorID = SYNTAX_ERROR;
                    return;
                }
                
            }   // End of while()...
        }   // End of Event 2.
        
        else {
            m_nErrorID = SYNTAX_ERROR;
            return;
        }
    }

}   // CSyntaxCore::SyntaxCheckEvent().


// EV1          [ [ADDRESS {Range adr1 adr2|xadr|badrs..}] 
//              [DATUM {Range data1 data2|xdata|bdatum}] 
//              [STATUS status..] 
//              [COUNT datum] ] |
//              [CLear]
//
//              Note: where <status> is: S, F, R, W, AK; 10 badrs.
void CSyntaxCore::SyntaxCheckEv1(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Check command syntax.
    if ( m_nArgc < 1 ) {
        m_nErrorID = SYNTAX_ERROR;
        return;
    }
    else if ( 1 == m_nArgc ) {
        return;
    }
    else if ( 2 == m_nArgc ) {
        if ( !IsKeywordClear(m_pszArgv[1]) ) {
            m_nErrorID = SYNTAX_ERROR;
        }
        return;
    }
    else {  // m_nArgc >= 3.
        // Check m_pszArgv[1].
        if ( 0 != stricmp(m_pszArgv[1], "ADDRESS") &&
             0 != stricmp(m_pszArgv[1], "DATUM") &&
             0 != stricmp(m_pszArgv[1], "STATUS") &&
             0 != stricmp(m_pszArgv[1], "COUNT") ) {
            m_nErrorID = SYNTAX_ERROR;
            return;
        }
        
        // Initial flag.
        BOOL isA = FALSE;
        BOOL isD = FALSE;
        BOOL isS = FALSE;
        BOOL isC = FALSE;
        int nIndex = 1;

        // Check m_pszArgv[].
        while ( nIndex < m_nArgc ) {
            if ( 0 == stricmp(m_pszArgv[nIndex], "ADDRESS") ) {
                // "ADDRESS...".
                if ( isA ) {
                    m_nErrorID = SYNTAX_ERROR;
                    return;
                }
                else {
                    isA = TRUE;
                }
                nIndex++;
                if ( nIndex >= m_nArgc ) {
                    m_nErrorID = SYNTAX_ERROR;
                    return;
                }
                if ( IsKeywordRange(m_pszArgv[nIndex]) ) {
                    nIndex++;
                    if ( nIndex >= m_nArgc ) {
                        m_nErrorID = SYNTAX_ERROR;
                        return;
                    }
                    if ( !IsPAddr(m_pszArgv[nIndex]) &&
                         !IsPAddrDefault(m_pszArgv[nIndex]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        return;
                    }
                    else {
                        nIndex++;
                        if ( nIndex >= m_nArgc ) {
                            m_nErrorID = SYNTAX_ERROR;
                            return;
                        }
                        if ( !IsPAddr(m_pszArgv[nIndex]) &&
                             !IsPAddrDefault(m_pszArgv[nIndex]) ) {
                            m_nErrorID = SYNTAX_ERROR;
                            return;
                        }
                        else {
                            nIndex++;
                        }
                    }
                }
                else if ( IsWildcardAddr(m_pszArgv[nIndex]) ) {
                    nIndex++;
                }
                else if ( IsPAddr(m_pszArgv[nIndex]) ||
                          IsPAddrDefault(m_pszArgv[nIndex]) ) {
                    nIndex++;
                    if ( nIndex >= m_nArgc ) {
                        return;
                    }
                    for ( int i = 2; i <= 10; i++ ) {
                        if ( IsPAddr(m_pszArgv[nIndex]) ||
                             IsPAddrDefault(m_pszArgv[nIndex]) ) {
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                                return;
                            }
                        }
                        else {
                            break;
                        }
                    }
                }
                else {
                    m_nErrorID = SYNTAX_ERROR;
                    return;
                }
            }   // End of "ADDRESS...".

            else if ( 0 == stricmp(m_pszArgv[nIndex], "DATUM") ) {
                // "DATUM...".
                if ( isD ) {
                    m_nErrorID = SYNTAX_ERROR;
                    return;
                }
                else {
                    isD = TRUE;
                }
                nIndex++;
                if ( nIndex >= m_nArgc ) {
                    m_nErrorID = SYNTAX_ERROR;
                    return;
                }
                if ( IsKeywordRange(m_pszArgv[nIndex]) ) {
                    nIndex++;
                    if ( nIndex >= m_nArgc ) {
                        m_nErrorID = SYNTAX_ERROR;
                        return;
                    }
                    if ( !IsEventData(m_pszArgv[nIndex]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        return;
                    }
                    else {
                        nIndex++;
                        if ( nIndex >= m_nArgc ) {
                            m_nErrorID = SYNTAX_ERROR;
                            return;
                        }
                        if ( !IsEventData(m_pszArgv[nIndex]) ) {
                            m_nErrorID = SYNTAX_ERROR;
                            return;
                        }
                        else {
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                                return;
                            }
                        }
                    }
                }
                else if ( IsWildcardData(m_pszArgv[nIndex]) ) {
                    nIndex++;
                    if ( nIndex >= m_nArgc ) {
                        return;
                    }
                }
                else if ( IsEventData(m_pszArgv[nIndex]) ) {
                    nIndex++;
                    if ( nIndex >= m_nArgc ) {
                        return;
                    }
                }
                else {
                    m_nErrorID = SYNTAX_ERROR;
                    return;
                }
            }   // End of "DATUM...".

            else if ( 0 == stricmp(m_pszArgv[nIndex], "STATUS") ) {
                // "STATUS...".
                if ( isS ) {
                    m_nErrorID = SYNTAX_ERROR;
                    return;
                }
                else {
                    isS = TRUE;
                }
                nIndex++;
                if ( nIndex >= m_nArgc ) {
                    m_nErrorID = SYNTAX_ERROR;
                    return;
                }
                // Is "S", "F", "R", "W" or "AK".
                BOOL isStatusS = FALSE;
                BOOL isStatusF = FALSE;
                BOOL isStatusR = FALSE;
                BOOL isStatusW = FALSE;
                BOOL isStatusAK = FALSE;

                if ( !stricmp(m_pszArgv[nIndex],"S") && !isStatusS ) {
                    isStatusS = TRUE;
                }
                else if ( !stricmp(m_pszArgv[nIndex],"F") && !isStatusF ) {
                    isStatusF = TRUE;
                }
                else if ( !stricmp(m_pszArgv[nIndex],"R") && !isStatusR ) {
                    isStatusR = TRUE;
                }
                else if ( !stricmp(m_pszArgv[nIndex],"W") && !isStatusW ) {
                    isStatusW = TRUE;
                }
                else if ( !stricmp(m_pszArgv[nIndex],"AK") && !isStatusAK ) {
                    isStatusAK = TRUE;
                }
                else {
                    m_nErrorID = SYNTAX_ERROR;
                    return;
                }

                nIndex++;
                if ( nIndex >= m_nArgc ) {
                    return;
                }
                for ( int j = 2; j <= 5; j++ ) {
                    if ( 0 == stricmp(m_pszArgv[nIndex], "S") ) {
                        if ( !isStatusS ) {
                            isStatusS = TRUE;
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                                return;
                            }
                        }
                        else {
                            m_nErrorID = SYNTAX_ERROR;
                            return;
                        }
                    }
                    else if ( 0 == stricmp(m_pszArgv[nIndex], "F") ) {
                        if ( !isStatusF ) {
                            isStatusF = TRUE;
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                                return;
                            }
                        }
                        else {
                            m_nErrorID = SYNTAX_ERROR;
                            return;
                        }
                    }
                    else if ( 0 == stricmp(m_pszArgv[nIndex], "R") ) {
                        if ( !isStatusR ) {
                            isStatusR = TRUE;
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                                return;
                            }
                        }
                        else {
                            m_nErrorID = SYNTAX_ERROR;
                            return;
                        }
                    }
                    else if ( 0 == stricmp(m_pszArgv[nIndex], "W") ) {
                        if ( !isStatusW ) {
                            isStatusW = TRUE;
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                                return;
                            }
                        }
                        else {
                            m_nErrorID = SYNTAX_ERROR;
                            return;
                        }
                    }
                    else if ( 0 == stricmp(m_pszArgv[nIndex], "AK") ) {
                        if ( !isStatusAK ) {
                            isStatusAK = TRUE;
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                                return;
                            }
                        }
                        else {
                            m_nErrorID = SYNTAX_ERROR;
                            return;
                        }
                    }
                    else {
                        break;
                    }
                }
            }   // End of "STATUS...".
            
            else if ( 0 == stricmp(m_pszArgv[nIndex], "COUNT") ) {
                // "COUNT...".
                if ( isC ) {
                    m_nErrorID = SYNTAX_ERROR;
                    return;
                }
                else {
                    isC = TRUE;
                }
                nIndex++;
                if ( nIndex >= m_nArgc ) {
                    m_nErrorID = SYNTAX_ERROR;
                    return;
                }
                if ( IsAddrData(m_pszArgv[nIndex]) ) {
                    nIndex++;
                    if ( nIndex >= m_nArgc ) {
                        return;
                    }
                }
                else {
                    m_nErrorID = SYNTAX_ERROR;
                    return;
                }
            }   // End of "COUNT...".
            
            else {
                // Not "A", "D", "S" or "C".
                m_nErrorID = SYNTAX_ERROR;
                return;
            }
            
        }   // End of while()...
        
    }   // End of else...

}   // End of CSyntaxCore::SyntaxCheckEv1().


// EV2          [ [ADDRESS {Range adr1 adr2|xadr|badrs..}] 
//              [DATUM {Range data1 data2|xdata|bdatum}] 
//              [STATUS status..] ] |
//              [CLear]
//
//              Note: where <status> is: S, F, R, W, AK; 10 badrs.
void CSyntaxCore::SyntaxCheckEv2(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Check command syntax.
    if ( m_nArgc < 1 ) {
        m_nErrorID = SYNTAX_ERROR;
        return;
    }
    else if ( 1 == m_nArgc ) {
        return;
    }
    else if ( 2 == m_nArgc ) {
        if ( !IsKeywordClear(m_pszArgv[1]) ) {
            m_nErrorID = SYNTAX_ERROR;
        }
        return;
    }
    else {  // m_nArgc >= 3.
        // Check m_pszArgv[1].
        if ( 0 != stricmp(m_pszArgv[1], "ADDRESS") &&
             0 != stricmp(m_pszArgv[1], "DATUM") &&
             0 != stricmp(m_pszArgv[1], "STATUS") ) {
            m_nErrorID = SYNTAX_ERROR;
            return;
        }
        
        // Initial flag.
        BOOL isA = FALSE;
        BOOL isD = FALSE;
        BOOL isS = FALSE;
        int nIndex = 1;

        // Check m_pszArgv[].
        while ( nIndex < m_nArgc ) {
            if ( 0 == stricmp(m_pszArgv[nIndex], "ADDRESS") ) {
                // "ADDRESS...".
                if ( isA ) {
                    m_nErrorID = SYNTAX_ERROR;
                    return;
                }
                else {
                    isA = TRUE;
                }
                nIndex++;
                if ( nIndex >= m_nArgc ) {
                    m_nErrorID = SYNTAX_ERROR;
                    return;
                }
                if ( IsKeywordRange(m_pszArgv[nIndex]) ) {
                    nIndex++;
                    if ( nIndex >= m_nArgc ) {
                        m_nErrorID = SYNTAX_ERROR;
                        return;
                    }
                    if ( !IsPAddr(m_pszArgv[nIndex]) &&
                         !IsPAddrDefault(m_pszArgv[nIndex]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        return;
                    }
                    else {
                        nIndex++;
                        if ( nIndex >= m_nArgc ) {
                            m_nErrorID = SYNTAX_ERROR;
                            return;
                        }
                        if ( !IsPAddr(m_pszArgv[nIndex]) &&
                             !IsPAddrDefault(m_pszArgv[nIndex]) ) {
                            m_nErrorID = SYNTAX_ERROR;
                            return;
                        }
                        else {
                            nIndex++;
                        }
                    }
                }
                else if ( IsWildcardAddr(m_pszArgv[nIndex]) ) {
                    nIndex++;
                }
                else if ( IsPAddr(m_pszArgv[nIndex]) ||
                          IsPAddrDefault(m_pszArgv[nIndex]) ) {
                    nIndex++;
                    if ( nIndex >= m_nArgc ) {
                        return;
                    }
                    for ( int i = 2; i <= 10; i++ ) {
                        if ( IsPAddr(m_pszArgv[nIndex]) ||
                             IsPAddrDefault(m_pszArgv[nIndex]) ) {
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                                return;
                            }
                        }
                        else {
                            break;
                        }
                    }
                }
                else {
                    m_nErrorID = SYNTAX_ERROR;
                    return;
                }
            }   // End of "ADDRESS...".

            else if ( 0 == stricmp(m_pszArgv[nIndex], "DATUM") ) {
                // "DATUM...".
                if ( isD ) {
                    m_nErrorID = SYNTAX_ERROR;
                    return;
                }
                else {
                    isD = TRUE;
                }
                nIndex++;
                if ( nIndex >= m_nArgc ) {
                    m_nErrorID = SYNTAX_ERROR;
                    return;
                }
                if ( IsKeywordRange(m_pszArgv[nIndex]) ) {
                    nIndex++;
                    if ( nIndex >= m_nArgc ) {
                        m_nErrorID = SYNTAX_ERROR;
                        return;
                    }
                    if ( !IsEventData(m_pszArgv[nIndex]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        return;
                    }
                    else {
                        nIndex++;
                        if ( nIndex >= m_nArgc ) {
                            m_nErrorID = SYNTAX_ERROR;
                            return;
                        }
                        if ( !IsEventData(m_pszArgv[nIndex]) ) {
                            m_nErrorID = SYNTAX_ERROR;
                            return;
                        }
                        else {
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                                return;
                            }
                        }
                    }
                }
                else if ( IsWildcardData(m_pszArgv[nIndex]) ) {
                    nIndex++;
                    if ( nIndex >= m_nArgc ) {
                        return;
                    }
                }
                else if ( IsEventData(m_pszArgv[nIndex]) ) {
                    nIndex++;
                    if ( nIndex >= m_nArgc ) {
                        return;
                    }
                }
                else {
                    m_nErrorID = SYNTAX_ERROR;
                    return;
                }
            }   // End of "DATUM...".

            else if ( 0 == stricmp(m_pszArgv[nIndex], "STATUS") ) {
                // "STATUS...".
                if ( isS ) {
                    m_nErrorID = SYNTAX_ERROR;
                    return;
                }
                else {
                    isS = TRUE;
                }
                nIndex++;
                if ( nIndex >= m_nArgc ) {
                    m_nErrorID = SYNTAX_ERROR;
                    return;
                }
                // Is "S", "F", "R", "W" or "AK".
                BOOL isStatusS = FALSE;
                BOOL isStatusF = FALSE;
                BOOL isStatusR = FALSE;
                BOOL isStatusW = FALSE;
                BOOL isStatusAK = FALSE;

                if ( !stricmp(m_pszArgv[nIndex],"S") && !isStatusS ) {
                    isStatusS = TRUE;
                }
                else if ( !stricmp(m_pszArgv[nIndex],"F") && !isStatusF ) {
                    isStatusF = TRUE;
                }
                else if ( !stricmp(m_pszArgv[nIndex],"R") && !isStatusR ) {
                    isStatusR = TRUE;
                }
                else if ( !stricmp(m_pszArgv[nIndex],"W") && !isStatusW ) {
                    isStatusW = TRUE;
                }
                else if ( !stricmp(m_pszArgv[nIndex],"AK") && !isStatusAK ) {
                    isStatusAK = TRUE;
                }
                else {
                    m_nErrorID = SYNTAX_ERROR;
                    return;
                }

                nIndex++;
                if ( nIndex >= m_nArgc ) {
                    return;
                }
                for ( int j = 2; j <= 5; j++ ) {
                    if ( 0 == stricmp(m_pszArgv[nIndex], "S") ) {
                        if ( !isStatusS ) {
                            isStatusS = TRUE;
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                                return;
                            }
                        }
                        else {
                            m_nErrorID = SYNTAX_ERROR;
                            return;
                        }
                    }
                    else if ( 0 == stricmp(m_pszArgv[nIndex], "F") ) {
                        if ( !isStatusF ) {
                            isStatusF = TRUE;
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                                return;
                            }
                        }
                        else {
                            m_nErrorID = SYNTAX_ERROR;
                            return;
                        }
                    }
                    else if ( 0 == stricmp(m_pszArgv[nIndex], "R") ) {
                        if ( !isStatusR ) {
                            isStatusR = TRUE;
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                                return;
                            }
                        }
                        else {
                            m_nErrorID = SYNTAX_ERROR;
                            return;
                        }
                    }
                    else if ( 0 == stricmp(m_pszArgv[nIndex], "W") ) {
                        if ( !isStatusW ) {
                            isStatusW = TRUE;
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                                return;
                            }
                        }
                        else {
                            m_nErrorID = SYNTAX_ERROR;
                            return;
                        }
                    }
                    else if ( 0 == stricmp(m_pszArgv[nIndex], "AK") ) {
                        if ( !isStatusAK ) {
                            isStatusAK = TRUE;
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                                return;
                            }
                        }
                        else {
                            m_nErrorID = SYNTAX_ERROR;
                            return;
                        }
                    }
                    else {
                        break;
                    }
                }
            }   // End of "STATUS...".
            
            else {
                // Not "A", "D", or "S".
                m_nErrorID = SYNTAX_ERROR;
                return;
            }
            
        }   // End of while()...
        
    }   // End of else...

}   // End of CSyntaxCore::SyntaxCheckEv2().


// EV3          [High|Low]
void CSyntaxCore::SyntaxCheckEv3(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Check command syntax.
    switch ( m_nArgc ) {
        case 1:
            break;
        case 2:
            if ( !IsKeywordHigh(m_pszArgv[1]) &&
                 !IsKeywordLow(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckEv3().


// Fill         adr1 {adr2|Length length} {"string"|data..}
void CSyntaxCore::SyntaxCheckFill(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Pre-process the field: "string" & Data.
    if ( m_nArgc < 4 ) {
        m_nErrorID = SYNTAX_ERROR;
        return;
    }
    
    int nArgc;
    if ( IsKeywordLength(m_pszArgv[2]) ) {
        if ( m_nArgc < 5 ) {
            m_nErrorID = SYNTAX_ERROR;
            return;
        }
        nArgc = 4;
    }
    else {
        nArgc = 3;
    }

    if ( !PreStringData(nArgc, 2) ) {
        m_nErrorID = SYNTAX_ERROR;
        return;
    }

    // Check command syntax.
    switch ( m_nArgc ) {
        case 4:
            if ( !IsPAddr(m_pszArgv[1]) &&
                 !IsXAddr(m_pszArgv[1]) &&
                 !IsIAddr(m_pszArgv[1]) &&
                 !IsRAddr(m_pszArgv[1]) &&
                 !IsBAddr(m_pszArgv[1]) &&
                 !IsXAddrDefault(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
                break;
            }
            else if ( !IsPAddr(m_pszArgv[2]) &&
                      !IsXAddr(m_pszArgv[2]) &&
                      !IsIAddr(m_pszArgv[2]) &&
                      !IsRAddr(m_pszArgv[2]) &&
                      !IsBAddr(m_pszArgv[2]) &&
                      !IsXAddrDefault(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
                break;
            }
            else if ( IsXAddrDefault(m_pszArgv[1]) ) {
                if ( !IsXAddr(m_pszArgv[2]) &&
                     !IsXAddrDefault(m_pszArgv[2]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                    break;
                }
            }
            if ( ':' == m_pszArgv[2][1] ) {
                if ( 'X' == toupper(m_pszArgv[2][0]) ) {
                    if ( !IsXAddr(m_pszArgv[1]) &&
                         !IsXAddrDefault(m_pszArgv[1]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        break;
                    }
                }
                else if ( toupper(m_pszArgv[1][0]) != 
                          toupper(m_pszArgv[2][0]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                    break;
                }
            }
            else {
                if ( IsXAddr(m_pszArgv[1]) || IsXAddrDefault(m_pszArgv[1]) ) {
                    if ( !IsXAddrDefault(m_pszArgv[2]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        break;
                    }
                }
                else if ( IsPAddr(m_pszArgv[1]) ) {
                    if ( !IsPAddrDefault(m_pszArgv[2]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        break;
                    }
                }
                else if ( IsIAddr(m_pszArgv[1]) ) {
                    if ( !IsIAddrDefault(m_pszArgv[2]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        break;
                    }
                }
                else if ( IsBAddr(m_pszArgv[1]) ) {
                    if ( !IsBAddrDefault(m_pszArgv[2]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        break;
                    }
                }
                else if ( IsRAddr(m_pszArgv[1]) ) {
                    if ( !IsRAddrDefault(m_pszArgv[2]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        break;
                    }
                }
                else {
                    m_nErrorID = SYNTAX_ERROR;
                    break;
                }
            }
            if ( !IsAddrRange(m_pszArgv[1], m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
                break;
            }
            else if ( !IsData(m_pszArgv[3]) && !IsString(m_pszArgv[3]) ) {
                m_nErrorID = SYNTAX_ERROR;
                break;
            }
            else if ( IsData(m_pszArgv[3]) ) {
                if ( !IsDataRange(m_nArgc, m_pszArgv) ) {
                    m_nErrorID = SYNTAX_ERROR;
                    break;
                }
            }
            else if ( IsString(m_pszArgv[3]) ) {
                if ( !IsStringRange(m_nArgc, m_pszArgv) ) {
                    m_nErrorID = SYNTAX_ERROR;
                    break;
                }
            }
            break;
        case 5:
            if ( !IsPAddr(m_pszArgv[1]) &&
                 !IsXAddr(m_pszArgv[1]) &&
                 !IsIAddr(m_pszArgv[1]) &&
                 !IsRAddr(m_pszArgv[1]) &&
                 !IsBAddr(m_pszArgv[1]) &&
                 !IsXAddrDefault(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
                break;
            }
            else if ( !IsKeywordLength(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
                break;
            }
            else if ( !IsAddrLen(m_pszArgv[3]) ) {
                m_nErrorID = SYNTAX_ERROR;
                break;
            }
            else if ( !IsLengthRange(m_pszArgv[1], m_pszArgv[3]) ) {
                m_nErrorID = SYNTAX_ERROR;
                break;
            }
            else if ( !IsData(m_pszArgv[4]) && !IsString(m_pszArgv[4]) ) {
                m_nErrorID = SYNTAX_ERROR;
                break;
            }
            else if ( IsData(m_pszArgv[4]) ) {
                if ( !IsDataRange(m_nArgc, m_pszArgv) ) {
                    m_nErrorID = SYNTAX_ERROR;
                    break;
                }
            }
            else if ( IsString(m_pszArgv[4]) ) {
                if ( !IsStringRange(m_nArgc, m_pszArgv) ) {
                    m_nErrorID = SYNTAX_ERROR;
                    break;
                }
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckFill().

    
// Go           [[Run][From adr1]|[From adr1][Till adr2]|Monitor timer]
void CSyntaxCore::SyntaxCheckGo(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    // Check command syntax.
    switch ( m_nArgc ) {
        case 1:
            break;
        case 2:
            if ( !IsKeywordRun(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        case 3:
            if ( IsKeywordFrom(m_pszArgv[1]) ||
                 IsKeywordTill(m_pszArgv[1]) ) {
                if ( !IsPAddr(m_pszArgv[2]) &&
                     !IsPAddrDefault(m_pszArgv[2]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                break;
            }
            else if ( !IsKeywordMonitor(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsGoMonitorTimer(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        case 4:
            if ( !IsKeywordRun(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsKeywordFrom(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsPAddr(m_pszArgv[3]) &&
                      !IsPAddrDefault(m_pszArgv[3]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        case 5:
            if ( !IsKeywordFrom(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsPAddr(m_pszArgv[2]) &&
                      !IsPAddrDefault(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsKeywordTill(m_pszArgv[3]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsPAddr(m_pszArgv[4]) &&
                      !IsPAddrDefault(m_pszArgv[4]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckGo().


// Halt
void CSyntaxCore::SyntaxCheckHalt(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Check command syntax.
    switch ( m_nArgc ) {
        case 1:
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckHalt().


// Help         [command]
void CSyntaxCore::SyntaxCheckHelp(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Check command syntax.
    switch ( m_nArgc ) {
        case 1:
            break;
        case 2:
            if ( !IsCommand(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckHelp().


// IDentify
void CSyntaxCore::SyntaxCheckIdentify(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Check command syntax.
    switch ( m_nArgc ) {
        case 1:
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckIdentify().


// INclude      filename 
//              [[ arg0][ argv1][ argv2][ argv3][ argv4][ argv5]
//              [ argv6][ argv7][ argv8][ argv9]]
void CSyntaxCore::SyntaxCheckInclude(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    // Check command syntax.
    switch ( m_nArgc ) {
        case 2:
            if ( !IsFilename(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
/*            
        case 3:
        case 4:
        case 5:
        case 6:
        case 7:
        case 8:
        case 9:
        case 10:
        case 11:
        case 12:
            if ( !IsFilename(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else {
                for ( i = 2; i < m_nArgc; i++ ) {
                    if ( !IsArgument(m_pszArgv[i]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        break;
                    }
                }
            }
            break;
*/            
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckInclude().


// Inport       port [Bit bit_no|BYte]
//          ( port = 0, 1, 2, 3; bit_no = 0 - 7 )
void CSyntaxCore::SyntaxCheckInport(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    // Check command syntax.
    switch ( m_nArgc ) {
        case 2:
            if ( !IsPort(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        case 3:
            if ( !IsPort(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsKeywordByte(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        case 4:
            if ( !IsPort(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsKeywordBit(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsBitNo(m_pszArgv[3]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckInport().


// Jump         adr
void CSyntaxCore::SyntaxCheckJump(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    // Check command syntax.
    switch ( m_nArgc ) {
        case 2:
            if ( !IsPAddr(m_pszArgv[1]) && 
                 !IsPAddrDefault(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }
    
}   // End of CSyntaxCore::SyntaxCheckJump().


// LEvel        [ {1|2} [ eventlogic  [TRace On|OFf]  [TImer On|OFf] ] ]
void CSyntaxCore::SyntaxCheckLevel(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // check command syntax.
    if ( m_nArgc < 1 ) {
        m_nErrorID = SYNTAX_ERROR;
        return;
    }
    else if ( 1 == m_nArgc ) {
        return;
    }
    else if ( 2 == m_nArgc ) {
        if ( 0 != stricmp(m_pszArgv[1], "1") &&
             0 != stricmp(m_pszArgv[1], "2") ) {
            m_nErrorID = SYNTAX_ERROR;
            return;
        }
        else {
            return;
        }
    }
    else {
        // m_nArgc >= 3.
        char pszEventSeq[255];
        int nIndex = 2;
        memset(pszEventSeq, 0, sizeof(pszEventSeq));
        for ( int i = 2; i < m_nArgc; i++ ) {
            if ( 0 != stricmp(m_pszArgv[i], "TRACE") &&
                 0 != stricmp(m_pszArgv[i], "TIMER") ) {
                strcat(pszEventSeq, m_pszArgv[i]);
                strcat(pszEventSeq, " ");
                nIndex++;
            }
            else {
                break;
            }
        }
        if ( 2 == nIndex ) {
            m_nErrorID = SYNTAX_ERROR;
            return;
        }
        
        // Check Event Sequence.
        if ( !IsEventSequence(pszEventSeq) ) {
            m_nErrorID = SYNTAX_ERROR;
            return;
        }
        
        // Check Trace or Timer.
        switch ( m_nArgc - nIndex ) {
            case 0:
                break;
            case 2:
                if ( IsKeywordTrace(m_pszArgv[nIndex]) ||
                     IsKeywordTimer(m_pszArgv[nIndex]) ) {
                    nIndex++;
                    if ( !IsKeywordOn(m_pszArgv[nIndex]) &&
                         !IsKeywordOff(m_pszArgv[nIndex]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                    }
                }
                else {
                    m_nErrorID = SYNTAX_ERROR;
                }
                break;
            case 4:
                if ( !IsKeywordTrace(m_pszArgv[nIndex]) &&
                     !IsKeywordTimer(m_pszArgv[nIndex]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                else if ( IsKeywordTrace(m_pszArgv[nIndex]) ) {
                    if ( !IsKeywordTimer(m_pszArgv[nIndex+2]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                    }
                }
                else if ( IsKeywordTimer(m_pszArgv[nIndex]) ) {
                    if ( !IsKeywordTrace(m_pszArgv[nIndex+2]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                    }
                }
                else if ( !IsKeywordOn(m_pszArgv[nIndex+1]) &&
                          !IsKeywordOff(m_pszArgv[nIndex+1]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                else if ( !IsKeywordOn(m_pszArgv[nIndex+3]) &&
                          !IsKeywordOff(m_pszArgv[nIndex+3]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                break;
            default:
                m_nErrorID = SYNTAX_ERROR;
                break;
        }
    }

}   // End of CSyntaxCore::SyntaxCheckLevel().


// LV1          [ eventlogic  [TRace On|OFf]  [TImer On|OFf] ]
void CSyntaxCore::SyntaxCheckLv1(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // check command syntax.
    if ( m_nArgc < 1 ) {
        m_nErrorID = SYNTAX_ERROR;
        return;
    }
    else if ( 1 == m_nArgc ) {
        return;
    }
    else {
        char pszEventSeq[255];
        int nIndex = 1;
        memset(pszEventSeq, 0, sizeof(pszEventSeq));
        for ( int i = 1; i < m_nArgc; i++ ) {
            if ( 0 != stricmp(m_pszArgv[i], "TRACE") &&
                 0 != stricmp(m_pszArgv[i], "TIMER") ) {
                strcat(pszEventSeq, m_pszArgv[i]);
                strcat(pszEventSeq, " ");
                nIndex++;
            }
            else {
                break;
            }
        }
        if ( 1 == nIndex ) {
            m_nErrorID = SYNTAX_ERROR;
            return;
        }
        
        // Check Event Sequence.
        if ( !IsEventSequence(pszEventSeq) ) {
            m_nErrorID = SYNTAX_ERROR;
            return;
        }
        
        // Check Trace or Timer.
        switch ( m_nArgc - nIndex ) {
            case 0:
                break;
            case 2:
                if ( IsKeywordTrace(m_pszArgv[nIndex]) ||
                     IsKeywordTimer(m_pszArgv[nIndex]) ) {
                    nIndex++;
                    if ( !IsKeywordOn(m_pszArgv[nIndex]) &&
                         !IsKeywordOff(m_pszArgv[nIndex]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                    }
                }
                else {
                    m_nErrorID = SYNTAX_ERROR;
                }
                break;
            case 4:
                if ( !IsKeywordTrace(m_pszArgv[nIndex]) &&
                     !IsKeywordTimer(m_pszArgv[nIndex]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                else if ( IsKeywordTrace(m_pszArgv[nIndex]) ) {
                    if ( !IsKeywordTimer(m_pszArgv[nIndex+2]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                    }
                }
                else if ( IsKeywordTimer(m_pszArgv[nIndex]) ) {
                    if ( !IsKeywordTrace(m_pszArgv[nIndex+2]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                    }
                }
                else if ( !IsKeywordOn(m_pszArgv[nIndex+1]) &&
                          !IsKeywordOff(m_pszArgv[nIndex+1]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                else if ( !IsKeywordOn(m_pszArgv[nIndex+3]) &&
                          !IsKeywordOff(m_pszArgv[nIndex+3]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                break;
            default:
                m_nErrorID = SYNTAX_ERROR;
                break;
        }
    }

}   // End of CSyntaxCore::SyntaxCheckLv1().


// LV2          [ eventlogic  [TRace On|OFf]  [TImer On|OFf] ]
void CSyntaxCore::SyntaxCheckLv2(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // check command syntax.
    if ( m_nArgc < 1 ) {
        m_nErrorID = SYNTAX_ERROR;
        return;
    }
    else if ( 1 == m_nArgc ) {
        return;
    }
    else {
        char pszEventSeq[255];
        int nIndex = 1;
        memset(pszEventSeq, 0, sizeof(pszEventSeq));
        for ( int i = 1; i < m_nArgc; i++ ) {
            if ( 0 != stricmp(m_pszArgv[i], "TRACE") &&
                 0 != stricmp(m_pszArgv[i], "TIMER") ) {
                strcat(pszEventSeq, m_pszArgv[i]);
                strcat(pszEventSeq, " ");
                nIndex++;
            }
            else {
                break;
            }
        }
        if ( 1 == nIndex ) {
            m_nErrorID = SYNTAX_ERROR;
            return;
        }
        
        // Check Event Sequence.
        if ( !IsEventSequence(pszEventSeq) ) {
            m_nErrorID = SYNTAX_ERROR;
            return;
        }
        
        // Check Trace or Timer.
        switch ( m_nArgc - nIndex ) {
            case 0:
                break;
            case 2:
                if ( IsKeywordTrace(m_pszArgv[nIndex]) ||
                     IsKeywordTimer(m_pszArgv[nIndex]) ) {
                    nIndex++;
                    if ( !IsKeywordOn(m_pszArgv[nIndex]) &&
                         !IsKeywordOff(m_pszArgv[nIndex]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                    }
                }
                else {
                    m_nErrorID = SYNTAX_ERROR;
                }
                break;
            case 4:
                if ( !IsKeywordTrace(m_pszArgv[nIndex]) &&
                     !IsKeywordTimer(m_pszArgv[nIndex]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                else if ( IsKeywordTrace(m_pszArgv[nIndex]) ) {
                    if ( !IsKeywordTimer(m_pszArgv[nIndex+2]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                    }
                }
                else if ( IsKeywordTimer(m_pszArgv[nIndex]) ) {
                    if ( !IsKeywordTrace(m_pszArgv[nIndex+2]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                    }
                }
                else if ( !IsKeywordOn(m_pszArgv[nIndex+1]) &&
                          !IsKeywordOff(m_pszArgv[nIndex+1]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                else if ( !IsKeywordOn(m_pszArgv[nIndex+3]) &&
                          !IsKeywordOff(m_pszArgv[nIndex+3]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                break;
            default:
                m_nErrorID = SYNTAX_ERROR;
                break;
        }
    }

}   // End of CSyntaxCore::SyntaxCheckLv2().


// List         [Source|ASsemble|MIxed|MOdule] [frame] 
//              [ADDRESS Range adr1 adr2|xadr|<10 badrs>] 
//              [DATUM Range data1 data2|xdata|<1 bdata>] 
//              [STATUS <status..>]
//
//              Note: (where <status> is: S, F, R, W, AK)
void CSyntaxCore::SyntaxCheckList(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    // Check command syntax.
    if ( m_nArgc < 1 ) {
        m_nErrorID = SYNTAX_ERROR;
        return;
    }
    else if ( 1 == m_nArgc ) {
        return;
    }
    else if ( 2 == m_nArgc ) {
        if ( !IsListOption(m_pszArgv[1]) &&
             !IsListFrame(m_pszArgv[1]) ) {
            m_nErrorID = SYNTAX_ERROR;
            return;
        }
    }
    else {  // m_nArgc >= 3.
        if ( 3 == m_nArgc ) {
            if ( IsListOption(m_pszArgv[1]) &&
                 IsListFrame(m_pszArgv[2]) ) {
                // List Source frame 
                return;
            }
            else if ( IsListOption(m_pszArgv[2]) &&
                      IsListFrame(m_pszArgv[1]) ) {
                // List frame Source
                return;
            }
        }
        // Check m_pszArgv[1].
        int nIndex = 0;
        int nPos = ( m_nArgc > 3 ) ? 3 : 2;
        for ( int k = 1; k <= nPos; k++ ) {
            if ( 0 == stricmp(m_pszArgv[k],"ADDRESS") ||
                 0 == stricmp(m_pszArgv[k],"DATUM") ||
                 0 == stricmp(m_pszArgv[k],"STATUS") ) {
                nIndex = k;
                break;
            }
        }
        // Check List Option & List Frame.
        if ( 0 == nIndex ) {
            m_nErrorID = SYNTAX_ERROR;
            return;
        }
        else if ( 2 == nIndex ) {
            if ( !IsListOption(m_pszArgv[1]) &&
                 !IsListFrame(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
                return;
            }
        }
        else if ( 3 == nIndex ) {
            if ( !IsListOption(m_pszArgv[1]) ||
                 !IsListFrame(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
                return;
            }
            else if ( 3 == m_nArgc ) {
                return;
            }
        }
    
        // Check List Qualifier.
        // Initial flag.
        BOOL isA = FALSE;
        BOOL isD = FALSE;
        BOOL isS = FALSE;

        // Check m_pszArgv[].
        while ( nIndex < m_nArgc ) {
            if ( 0 == stricmp(m_pszArgv[nIndex], "ADDRESS") ) {
                // "ADDRESS...".
                if ( isA ) {
                    m_nErrorID = SYNTAX_ERROR;
                    return;
                }
                else {
                    isA = TRUE;
                }
                nIndex++;
                if ( nIndex >= m_nArgc ) {
                    m_nErrorID = SYNTAX_ERROR;
                    return;
                }
                if ( IsKeywordRange(m_pszArgv[nIndex]) ) {
                    nIndex++;
                    if ( nIndex >= m_nArgc ) {
                        m_nErrorID = SYNTAX_ERROR;
                        return;
                    }
                    if ( !IsPAddr(m_pszArgv[nIndex]) &&
                         !IsPAddrDefault(m_pszArgv[nIndex]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        return;
                    }
                    else {
                        nIndex++;
                        if ( nIndex >= m_nArgc ) {
                            m_nErrorID = SYNTAX_ERROR;
                            return;
                        }
                        if ( !IsPAddr(m_pszArgv[nIndex]) &&
                             !IsPAddrDefault(m_pszArgv[nIndex]) ) {
                            m_nErrorID = SYNTAX_ERROR;
                            return;
                        }
                        else {
                            nIndex++;
                        }
                    }
                }
                else if ( IsWildcardAddr(m_pszArgv[nIndex]) ) {
                    nIndex++;
                }
                else if ( IsPAddr(m_pszArgv[nIndex]) ||
                          IsPAddrDefault(m_pszArgv[nIndex]) ) {
                    nIndex++;
                    if ( nIndex >= m_nArgc ) {
                        return;
                    }
                    for ( int i = 2; i <= 10; i++ ) {
                        if ( IsPAddr(m_pszArgv[nIndex]) ||
                             IsPAddrDefault(m_pszArgv[nIndex]) ) {
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                                return;
                            }
                        }
                        else {
                            break;
                        }
                    }
                }
                else {
                    m_nErrorID = SYNTAX_ERROR;
                    return;
                }
            }   // End of "ADDRESS...".

            else if ( 0 == stricmp(m_pszArgv[nIndex], "DATUM") ) {
                // "DATUM...".
                if ( isD ) {
                    m_nErrorID = SYNTAX_ERROR;
                    return;
                }
                else {
                    isD = TRUE;
                }
                nIndex++;
                if ( nIndex >= m_nArgc ) {
                    m_nErrorID = SYNTAX_ERROR;
                    return;
                }
                if ( IsKeywordRange(m_pszArgv[nIndex]) ) {
                    nIndex++;
                    if ( nIndex >= m_nArgc ) {
                        m_nErrorID = SYNTAX_ERROR;
                        return;
                    }
                    if ( !IsEventData(m_pszArgv[nIndex]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        return;
                    }
                    else {
                        nIndex++;
                        if ( nIndex >= m_nArgc ) {
                            m_nErrorID = SYNTAX_ERROR;
                            return;
                        }
                        if ( !IsEventData(m_pszArgv[nIndex]) ) {
                            m_nErrorID = SYNTAX_ERROR;
                            return;
                        }
                        else {
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                                return;
                            }
                        }
                    }
                }
                else if ( IsWildcardData(m_pszArgv[nIndex]) ) {
                    nIndex++;
                    if ( nIndex >= m_nArgc ) {
                        return;
                    }
                }
                else if ( IsEventData(m_pszArgv[nIndex]) ) {
                    nIndex++;
                    if ( nIndex >= m_nArgc ) {
                        return;
                    }
                }
                else {
                    m_nErrorID = SYNTAX_ERROR;
                    return;
                }
            }   // End of "DATUM...".

            else if ( 0 == stricmp(m_pszArgv[nIndex], "STATUS") ) {
                // "STATUS...".
                if ( isS ) {
                    m_nErrorID = SYNTAX_ERROR;
                    return;
                }
                else {
                    isS = TRUE;
                }
                nIndex++;
                if ( nIndex >= m_nArgc ) {
                    m_nErrorID = SYNTAX_ERROR;
                    return;
                }
                // Is "S", "F", "R", "W" or "AK".
                BOOL isStatusS = FALSE;
                BOOL isStatusF = FALSE;
                BOOL isStatusR = FALSE;
                BOOL isStatusW = FALSE;
                BOOL isStatusAK = FALSE;

                if ( !stricmp(m_pszArgv[nIndex],"S") && !isStatusS ) {
                    isStatusS = TRUE;
                }
                else if ( !stricmp(m_pszArgv[nIndex],"F") && !isStatusF ) {
                    isStatusF = TRUE;
                }
                else if ( !stricmp(m_pszArgv[nIndex],"R") && !isStatusR ) {
                    isStatusR = TRUE;
                }
                else if ( !stricmp(m_pszArgv[nIndex],"W") && !isStatusW ) {
                    isStatusW = TRUE;
                }
                else if ( !stricmp(m_pszArgv[nIndex],"AK") && !isStatusAK ) {
                    isStatusAK = TRUE;
                }
                else {
                    m_nErrorID = SYNTAX_ERROR;
                    return;
                }

                nIndex++;
                if ( nIndex >= m_nArgc ) {
                    return;
                }
                for ( int j = 2; j <= 5; j++ ) {
                    if ( 0 == stricmp(m_pszArgv[nIndex], "S") ) {
                        if ( !isStatusS ) {
                            isStatusS = TRUE;
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                                return;
                            }
                        }
                        else {
                            m_nErrorID = SYNTAX_ERROR;
                            return;
                        }
                    }
                    else if ( 0 == stricmp(m_pszArgv[nIndex], "F") ) {
                        if ( !isStatusF ) {
                            isStatusF = TRUE;
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                                return;
                            }
                        }
                        else {
                            m_nErrorID = SYNTAX_ERROR;
                            return;
                        }
                    }
                    else if ( 0 == stricmp(m_pszArgv[nIndex], "R") ) {
                        if ( !isStatusR ) {
                            isStatusR = TRUE;
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                                return;
                            }
                        }
                        else {
                            m_nErrorID = SYNTAX_ERROR;
                            return;
                        }
                    }
                    else if ( 0 == stricmp(m_pszArgv[nIndex], "W") ) {
                        if ( !isStatusW ) {
                            isStatusW = TRUE;
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                                return;
                            }
                        }
                        else {
                            m_nErrorID = SYNTAX_ERROR;
                            return;
                        }
                    }
                    else if ( 0 == stricmp(m_pszArgv[nIndex], "AK") ) {
                        if ( !isStatusAK ) {
                            isStatusAK = TRUE;
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                                return;
                            }
                        }
                        else {
                            m_nErrorID = SYNTAX_ERROR;
                            return;
                        }
                    }
                    else {
                        break;
                    }
                }
            }   // End of "STATUS...".
            
            else {
                // Not "A", "D", or "S".
                m_nErrorID = SYNTAX_ERROR;
                return;
            }
            
        }   // End of while()...
        
    }   // End of else...

}   // End of CSyntaxCore::SyntaxCheckList().


// LOG          {filename [Command] [Append]} | {ON|OFf|Close}
void CSyntaxCore::SyntaxCheckLog(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Check command syntax.
    switch ( m_nArgc ) {
        case 2:
            if ( !IsFilename(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        case 3:
            if ( IsKeywordOn(m_pszArgv[1]) ||
                 IsKeywordOff(m_pszArgv[1]) ||
                 IsKeywordClose(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsFilename(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsKeywordCommand(m_pszArgv[2]) &&
                      !IsKeywordAppend(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        case 4:
            if ( IsKeywordOn(m_pszArgv[1]) ||
                 IsKeywordOff(m_pszArgv[1]) ||
                 IsKeywordClose(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsFilename(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( IsKeywordCommand(m_pszArgv[2]) &&
                      IsKeywordAppend(m_pszArgv[3]) ) {
                break;
            }
            else if ( IsKeywordAppend(m_pszArgv[2]) &&
                      IsKeywordCommand(m_pszArgv[3]) ) {
                break;
            }
            else {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckLog().


// LONG         adr data1 [.. data8]
void CSyntaxCore::SyntaxCheckLong(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Pre-process the field: "string" & Data.
    if ( m_nArgc < 3 ) {
        m_nErrorID = SYNTAX_ERROR;
        return;
    }
    
    int nArgc = 2;
    if ( !PreStringData(nArgc, 8) ) {
        return;
    }

    // Check command syntax.
    switch ( m_nArgc ) {
        case 3:
            if ( !IsPAddr(m_pszArgv[1]) &&
                 !IsXAddr(m_pszArgv[1]) &&
                 !IsIAddr(m_pszArgv[1]) &&
                 !IsRAddr(m_pszArgv[1]) &&
                 !IsBAddr(m_pszArgv[1]) &&
                 !IsXAddrDefault(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsDataLong(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsDataRange(m_nArgc, m_pszArgv, 4) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckLong().


// MAp          [{All adrtype}|{adr1 {adr2|Length length}} map-attribute]
void CSyntaxCore::SyntaxCheckMap(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Check command syntax.
    switch ( m_nArgc ) {
        case 1:
            break;
        case 4:
            if ( IsKeywordAll(m_pszArgv[1]) ) {
                if ( !IsMapMemType(m_pszArgv[2]) ||
                     !IsMapAttr(m_pszArgv[2][0], m_pszArgv[3]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                    break;
                }
            }
            else {
                if ( !IsMapStartAddr(m_pszArgv[1]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                    break;
                }
                if ( !IsMapEndAddr(m_pszArgv[2]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                    break;
                }
                if ( IsXAddrDefault(m_pszArgv[1]) ) {
                    if ( !IsXAddr(m_pszArgv[2]) &&
                         !IsXAddrDefault(m_pszArgv[2]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        break;
                    }
                }
                if ( ':' == m_pszArgv[2][1] ) {
                    if ( 'X' == toupper(m_pszArgv[2][0]) ) {
                        if ( !IsXAddr(m_pszArgv[1]) &&
                             !IsXAddrDefault(m_pszArgv[1]) ) {
                            m_nErrorID = SYNTAX_ERROR;
                            break;
                        }
                    }
                    else if ( toupper(m_pszArgv[1][0]) != 
                              toupper(m_pszArgv[2][0]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        break;
                    }
                }
                /*
                else {
                    if ( IsXAddr(m_pszArgv[1]) || IsXAddrDefault(m_pszArgv[1]) ) {
                        if ( !IsXAddrDefault(m_pszArgv[2]) ) {
                            m_nErrorID = SYNTAX_ERROR;
                            break;
                        }
                    }
                    else if ( IsPAddr(m_pszArgv[1]) ) {
                        if ( !IsPAddrDefault(m_pszArgv[2]) ) {
                            m_nErrorID = SYNTAX_ERROR;
                            break;
                        }
                    }
                    else {
                        m_nErrorID = SYNTAX_ERROR;
                        break;
                    }
                }
                */
                if ( !IsAddrRange(m_pszArgv[1], m_pszArgv[2]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                    break;
                }
                if ( IsXAddrDefault(m_pszArgv[1]) ) {
                    if ( !IsMapAttr('X', m_pszArgv[3]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        break;
                    }
                }
                else if ( !IsMapAttr(m_pszArgv[1][0], m_pszArgv[3]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                    break;
                }
            }
            break;
        case 5:
            if ( !IsMapStartAddr(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
                break;
            }
            if ( !IsKeywordLength(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
                break;
            }
            if ( !IsMapAddrLen(m_pszArgv[3]) ) {
                m_nErrorID = SYNTAX_ERROR;
                break;
            }
            if ( !IsLengthRange(m_pszArgv[1], m_pszArgv[3]) ) {
                m_nErrorID = SYNTAX_ERROR;
                break;
            }
            if ( IsXAddrDefault(m_pszArgv[1]) ) {
                if ( !IsMapAttr('X', m_pszArgv[4]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                    break;
                }
                break;
            }
            else if ( !IsMapAttr(m_pszArgv[1][0], m_pszArgv[4]) ) {
                m_nErrorID = SYNTAX_ERROR;
                break;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckMap().


// Memory       adr1 [adr2|Length length]
void CSyntaxCore::SyntaxCheckMemory(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Check command syntax.
    switch ( m_nArgc ) {
        case 2:
            if ( !IsPAddr(m_pszArgv[1]) &&
                 !IsXAddr(m_pszArgv[1]) &&
                 !IsIAddr(m_pszArgv[1]) &&
                 !IsBAddr(m_pszArgv[1]) &&
                 !IsRAddr(m_pszArgv[1]) &&
                 !IsXAddrDefault(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        case 3:
            if ( !IsPAddr(m_pszArgv[1]) &&
                 !IsXAddr(m_pszArgv[1]) &&
                 !IsIAddr(m_pszArgv[1]) &&
                 !IsBAddr(m_pszArgv[1]) &&
                 !IsRAddr(m_pszArgv[1]) &&
                 !IsXAddrDefault(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
                break;
            }
            else if ( !IsPAddr(m_pszArgv[2]) &&
                      !IsXAddr(m_pszArgv[2]) &&
                      !IsIAddr(m_pszArgv[2]) &&
                      !IsBAddr(m_pszArgv[2]) &&
                      !IsRAddr(m_pszArgv[2]) &&
                      !IsXAddrDefault(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
                break;
            }
            else if ( IsXAddrDefault(m_pszArgv[1]) ) {
                if ( !IsXAddr(m_pszArgv[2]) &&
                     !IsXAddrDefault(m_pszArgv[2]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                    break;
                }
            }
            if ( ':' == m_pszArgv[2][1] ) {
                if ( 'X' == toupper(m_pszArgv[2][0]) ) {
                    if ( !IsXAddr(m_pszArgv[1]) &&
                         !IsXAddrDefault(m_pszArgv[1]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        break;
                    }
                }
                else if ( toupper(m_pszArgv[1][0]) != 
                          toupper(m_pszArgv[2][0]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                    break;
                }
            }
            else {
                if ( IsXAddr(m_pszArgv[1]) || IsXAddrDefault(m_pszArgv[1]) ) {
                    if ( !IsXAddrDefault(m_pszArgv[2]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        break;
                    }
                }
                else if ( IsPAddr(m_pszArgv[1]) ) {
                    if ( !IsPAddrDefault(m_pszArgv[2]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        break;
                    }
                }
                else if ( IsIAddr(m_pszArgv[1]) ) {
                    if ( !IsIAddrDefault(m_pszArgv[2]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        break;
                    }
                }
                else if ( IsBAddr(m_pszArgv[1]) ) {
                    if ( !IsBAddrDefault(m_pszArgv[2]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        break;
                    }
                }
                else if ( IsRAddr(m_pszArgv[1]) ) {
                    if ( !IsRAddrDefault(m_pszArgv[2]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        break;
                    }
                }
                else {
                    m_nErrorID = SYNTAX_ERROR;
                    break;
                }
            }
            if ( !IsAddrRange(m_pszArgv[1], m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
                break;
            }
            break;
        case 4:
            if ( !IsPAddr(m_pszArgv[1]) &&
                 !IsXAddr(m_pszArgv[1]) &&
                 !IsIAddr(m_pszArgv[1]) &&
                 !IsBAddr(m_pszArgv[1]) &&
                 !IsRAddr(m_pszArgv[1]) &&
                 !IsXAddrDefault(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsKeywordLength(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsAddrLen(m_pszArgv[3]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsLengthRange(m_pszArgv[1], m_pszArgv[3]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckMemory().


// Outport      port { Bit bit data1 | BYte data2 }
//          ( data1 = 0, 1; data2 =  0 - FF ) 
void CSyntaxCore::SyntaxCheckOutport(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Check command syntax.
    switch ( m_nArgc ) {
        case 4:
            if ( !IsPort(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsKeywordByte(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsByteData(m_pszArgv[3]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        case 5:
            if ( !IsPort(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsKeywordBit(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsBitNo(m_pszArgv[3]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsBitData(m_pszArgv[4]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckOutport().


// Patch        [adr1 {[adr2] [With adr3 adr4]}|CLear]
void CSyntaxCore::SyntaxCheckPatch(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Check command syntax.
    switch ( m_nArgc ) {
        case 1:
            break;
        case 2:
            if ( !IsKeywordClear(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        case 3:
            if ( !IsPAddr(m_pszArgv[1]) && 
                 !IsPAddrDefault(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsPAddr(m_pszArgv[2]) && 
                      !IsPAddrDefault(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsAddrRange(m_pszArgv[1], m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        case 5:
            if ( !IsPAddr(m_pszArgv[1]) && 
                 !IsPAddrDefault(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsKeywordWith(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsPAddr(m_pszArgv[3]) && 
                 !IsPAddrDefault(m_pszArgv[3]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsPAddr(m_pszArgv[4]) && 
                      !IsPAddrDefault(m_pszArgv[4]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsAddrRange(m_pszArgv[3], m_pszArgv[4]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        case 6:
            if ( !IsPAddr(m_pszArgv[1]) && 
                 !IsPAddrDefault(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsPAddr(m_pszArgv[2]) && 
                      !IsPAddrDefault(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsAddrRange(m_pszArgv[1], m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsKeywordWith(m_pszArgv[3]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsPAddr(m_pszArgv[4]) && 
                      !IsPAddrDefault(m_pszArgv[4]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsPAddr(m_pszArgv[5]) && 
                      !IsPAddrDefault(m_pszArgv[5]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsAddrRange(m_pszArgv[4], m_pszArgv[5]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckPatch().


// POrt         port
void CSyntaxCore::SyntaxCheckPort(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    // Check command syntax.
    switch ( m_nArgc ) {
        case 2:
            if ( !IsPort(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }
    
}   // End of CSyntaxCore::SyntaxCheckPort().


// QUAlify      [ [ADDRESS {Range adr1 adr2|xadr|badrs..}] 
//              [DATUM {Range data1 data2|xdata|bdatum}] 
//              [STATUS status..] ] |
//              [CLear]
//
//              Note: where <status> is: S, F, R, W, AK; 10 badrs.
void CSyntaxCore::SyntaxCheckQualify(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Check command syntax.
    if ( m_nArgc < 1 ) {
        m_nErrorID = SYNTAX_ERROR;
        return;
    }
    else if ( 1 == m_nArgc ) {
        return;
    }
    else if ( 2 == m_nArgc ) {
        if ( !IsKeywordClear(m_pszArgv[1]) ) {
            m_nErrorID = SYNTAX_ERROR;
        }
        return;
    }
    else {  // m_nArgc >= 3.
        // Check m_pszArgv[1].
        if ( 0 != stricmp(m_pszArgv[1], "ADDRESS") &&
             0 != stricmp(m_pszArgv[1], "DATUM") &&
             0 != stricmp(m_pszArgv[1], "STATUS") ) {
            m_nErrorID = SYNTAX_ERROR;
            return;
        }
        
        // Initial flag.
        BOOL isA = FALSE;
        BOOL isD = FALSE;
        BOOL isS = FALSE;
        int nIndex = 1;

        // Check m_pszArgv[].
        while ( nIndex < m_nArgc ) {
            if ( 0 == stricmp(m_pszArgv[nIndex], "ADDRESS") ) {
                // "ADDRESS...".
                if ( isA ) {
                    m_nErrorID = SYNTAX_ERROR;
                    return;
                }
                else {
                    isA = TRUE;
                }
                nIndex++;
                if ( nIndex >= m_nArgc ) {
                    m_nErrorID = SYNTAX_ERROR;
                    return;
                }
                if ( IsKeywordRange(m_pszArgv[nIndex]) ) {
                    nIndex++;
                    if ( nIndex >= m_nArgc ) {
                        m_nErrorID = SYNTAX_ERROR;
                        return;
                    }
                    if ( !IsPAddr(m_pszArgv[nIndex]) &&
                         !IsPAddrDefault(m_pszArgv[nIndex]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        return;
                    }
                    else {
                        nIndex++;
                        if ( nIndex >= m_nArgc ) {
                            m_nErrorID = SYNTAX_ERROR;
                            return;
                        }
                        if ( !IsPAddr(m_pszArgv[nIndex]) &&
                             !IsPAddrDefault(m_pszArgv[nIndex]) ) {
                            m_nErrorID = SYNTAX_ERROR;
                            return;
                        }
                        else {
                            nIndex++;
                        }
                    }
                }
                else if ( IsWildcardAddr(m_pszArgv[nIndex]) ) {
                    nIndex++;
                }
                else if ( IsPAddr(m_pszArgv[nIndex]) ||
                          IsPAddrDefault(m_pszArgv[nIndex]) ) {
                    nIndex++;
                    if ( nIndex >= m_nArgc ) {
                        return;
                    }
                    for ( int i = 2; i <= 10; i++ ) {
                        if ( IsPAddr(m_pszArgv[nIndex]) ||
                             IsPAddrDefault(m_pszArgv[nIndex]) ) {
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                                return;
                            }
                        }
                        else {
                            break;
                        }
                    }
                }
                else {
                    m_nErrorID = SYNTAX_ERROR;
                    return;
                }
            }   // End of "ADDRESS...".

            else if ( 0 == stricmp(m_pszArgv[nIndex], "DATUM") ) {
                // "DATUM...".
                if ( isD ) {
                    m_nErrorID = SYNTAX_ERROR;
                    return;
                }
                else {
                    isD = TRUE;
                }
                nIndex++;
                if ( nIndex >= m_nArgc ) {
                    m_nErrorID = SYNTAX_ERROR;
                    return;
                }
                if ( IsKeywordRange(m_pszArgv[nIndex]) ) {
                    nIndex++;
                    if ( nIndex >= m_nArgc ) {
                        m_nErrorID = SYNTAX_ERROR;
                        return;
                    }
                    if ( !IsEventData(m_pszArgv[nIndex]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        return;
                    }
                    else {
                        nIndex++;
                        if ( nIndex >= m_nArgc ) {
                            m_nErrorID = SYNTAX_ERROR;
                            return;
                        }
                        if ( !IsEventData(m_pszArgv[nIndex]) ) {
                            m_nErrorID = SYNTAX_ERROR;
                            return;
                        }
                        else {
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                                return;
                            }
                        }
                    }
                }
                else if ( IsWildcardData(m_pszArgv[nIndex]) ) {
                    nIndex++;
                    if ( nIndex >= m_nArgc ) {
                        return;
                    }
                }
                else if ( IsEventData(m_pszArgv[nIndex]) ) {
                    nIndex++;
                    if ( nIndex >= m_nArgc ) {
                        return;
                    }
                }
                else {
                    m_nErrorID = SYNTAX_ERROR;
                    return;
                }
            }   // End of "DATUM...".

            else if ( 0 == stricmp(m_pszArgv[nIndex], "STATUS") ) {
                // "STATUS...".
                if ( isS ) {
                    m_nErrorID = SYNTAX_ERROR;
                    return;
                }
                else {
                    isS = TRUE;
                }
                nIndex++;
                if ( nIndex >= m_nArgc ) {
                    m_nErrorID = SYNTAX_ERROR;
                    return;
                }
                // Is "S", "F", "R", "W" or "AK".
                BOOL isStatusS = FALSE;
                BOOL isStatusF = FALSE;
                BOOL isStatusR = FALSE;
                BOOL isStatusW = FALSE;
                BOOL isStatusAK = FALSE;

                if ( !stricmp(m_pszArgv[nIndex],"S") && !isStatusS ) {
                    isStatusS = TRUE;
                }
                else if ( !stricmp(m_pszArgv[nIndex],"F") && !isStatusF ) {
                    isStatusF = TRUE;
                }
                else if ( !stricmp(m_pszArgv[nIndex],"R") && !isStatusR ) {
                    isStatusR = TRUE;
                }
                else if ( !stricmp(m_pszArgv[nIndex],"W") && !isStatusW ) {
                    isStatusW = TRUE;
                }
                else if ( !stricmp(m_pszArgv[nIndex],"AK") && !isStatusAK ) {
                    isStatusAK = TRUE;
                }
                else {
                    m_nErrorID = SYNTAX_ERROR;
                    return;
                }

                nIndex++;
                if ( nIndex >= m_nArgc ) {
                    return;
                }
                for ( int j = 2; j <= 5; j++ ) {
                    if ( 0 == stricmp(m_pszArgv[nIndex], "S") ) {
                        if ( !isStatusS ) {
                            isStatusS = TRUE;
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                                return;
                            }
                        }
                        else {
                            m_nErrorID = SYNTAX_ERROR;
                            return;
                        }
                    }
                    else if ( 0 == stricmp(m_pszArgv[nIndex], "F") ) {
                        if ( !isStatusF ) {
                            isStatusF = TRUE;
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                                return;
                            }
                        }
                        else {
                            m_nErrorID = SYNTAX_ERROR;
                            return;
                        }
                    }
                    else if ( 0 == stricmp(m_pszArgv[nIndex], "R") ) {
                        if ( !isStatusR ) {
                            isStatusR = TRUE;
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                                return;
                            }
                        }
                        else {
                            m_nErrorID = SYNTAX_ERROR;
                            return;
                        }
                    }
                    else if ( 0 == stricmp(m_pszArgv[nIndex], "W") ) {
                        if ( !isStatusW ) {
                            isStatusW = TRUE;
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                                return;
                            }
                        }
                        else {
                            m_nErrorID = SYNTAX_ERROR;
                            return;
                        }
                    }
                    else if ( 0 == stricmp(m_pszArgv[nIndex], "AK") ) {
                        if ( !isStatusAK ) {
                            isStatusAK = TRUE;
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                                return;
                            }
                        }
                        else {
                            m_nErrorID = SYNTAX_ERROR;
                            return;
                        }
                    }
                    else {
                        break;
                    }
                }
            }   // End of "STATUS...".
            
            else {
                // Not "A", "D", or "S".
                m_nErrorID = SYNTAX_ERROR;
                return;
            }
            
        }   // End of while()...
        
    }   // End of else...

}   // End of CSyntaxCore::SyntaxCheckQualify().


// Quit
void CSyntaxCore::SyntaxCheckQuit(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Check command syntax.
    switch ( m_nArgc ) {
        case 1:
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckQuit().


// Register     [reg_id data]
void CSyntaxCore::SyntaxCheckRegister(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    // Check command syntax.
    switch ( m_nArgc ) {
        case 1:
            break;
        case 3:
            if ( !IsRegName(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsRegData(m_pszArgv[1], m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckRegister().


// RESet        [adr]
void CSyntaxCore::SyntaxCheckReset(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    // Check command syntax.
    switch ( m_nArgc ) {
        case 1:
            break;
        case 2:
            if ( !IsPAddr(m_pszArgv[1]) && 
                 !IsPAddrDefault(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckReset().


// SEarch       adr1 {adr2|Length length} {[Insensitive] "string"|data..}
void CSyntaxCore::SyntaxCheckSearch(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Pre-process the field: "string" & Data.
    if ( m_nArgc < 4 ) {
        m_nErrorID = SYNTAX_ERROR;
        return;
    }
        
    int nArgc;
    if ( IsKeywordLength(m_pszArgv[2]) ) {
        if ( m_nArgc < 5 ) {
            m_nErrorID = SYNTAX_ERROR;
            return;
        }
        if ( IsKeywordInsensitive(m_pszArgv[4]) ) {
            if ( m_nArgc < 6 ) {
                m_nErrorID = SYNTAX_ERROR;
                return;
            }
            else {
                nArgc = 5;
            }
        }
        else {
            nArgc = 4;
        }
    }
    else {
        if ( IsKeywordInsensitive(m_pszArgv[3]) ) {
            if ( m_nArgc < 5 ) {
                m_nErrorID = SYNTAX_ERROR;
                return;
            }
            else {
                nArgc = 4;
            }
        }
        else {
            nArgc = 3;
        }
    }
        
    if ( !PreStringData(nArgc, 2) ) {
        return;
    }

    // Check command syntax.
    if ( !IsKeywordLength(m_pszArgv[2]) ) {
        switch ( m_nArgc ) {
            case 4:
                // SEarch adr1 adr2 {"string"|data..}
                if ( !IsPAddr(m_pszArgv[1]) &&
                     !IsXAddr(m_pszArgv[1]) &&
                     !IsXAddrDefault(m_pszArgv[1]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                    break;
                }
                else if ( !IsPAddr(m_pszArgv[2]) &&
                          !IsXAddr(m_pszArgv[2]) &&
                          !IsXAddrDefault(m_pszArgv[2]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                    break;
                }
                else if ( IsXAddrDefault(m_pszArgv[1]) ) {
                    if ( !IsXAddr(m_pszArgv[2]) &&
                         !IsXAddrDefault(m_pszArgv[2]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        break;
                    }
                }
                if ( ':' == m_pszArgv[2][1] ) {
                    if ( 'X' == toupper(m_pszArgv[2][0]) ) {
                        if ( !IsXAddr(m_pszArgv[1]) &&
                             !IsXAddrDefault(m_pszArgv[1]) ) {
                            m_nErrorID = SYNTAX_ERROR;
                            break;
                        }
                    }
                    else if ( toupper(m_pszArgv[1][0]) != 
                              toupper(m_pszArgv[2][0]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        break;
                    }
                }
                else {
                    if ( IsXAddr(m_pszArgv[1]) || IsXAddrDefault(m_pszArgv[1]) ) {
                        if ( !IsXAddrDefault(m_pszArgv[2]) ) {
                            m_nErrorID = SYNTAX_ERROR;
                            break;
                        }
                    }
                    else if ( IsPAddr(m_pszArgv[1]) ) {
                        if ( !IsPAddrDefault(m_pszArgv[2]) ) {
                            m_nErrorID = SYNTAX_ERROR;
                            break;
                        }
                    }
                    else {
                        m_nErrorID = SYNTAX_ERROR;
                        break;
                    }
                }
                if ( !IsAddrRange(m_pszArgv[1], m_pszArgv[2]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                    break;
                }
                else if (!IsData(m_pszArgv[3]) && !IsString(m_pszArgv[3])) {
                    m_nErrorID = SYNTAX_ERROR;
                    break;
                }
                else if ( IsData(m_pszArgv[3]) ) {
                    if ( !IsDataRange(m_nArgc, m_pszArgv) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        break;
                    }
                }
                else if ( IsString(m_pszArgv[3]) ) {
                    if ( !IsStringRange(m_nArgc, m_pszArgv) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        break;
                    }
                }
                break;
            case 5:
                // SEarch adr1 adr2 Insensitive "string"
                if ( !IsPAddr(m_pszArgv[1]) &&
                     !IsXAddr(m_pszArgv[1]) &&
                     !IsXAddrDefault(m_pszArgv[1]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                    break;
                }
                else if ( !IsPAddr(m_pszArgv[2]) &&
                          !IsXAddr(m_pszArgv[2]) &&
                          !IsXAddrDefault(m_pszArgv[2]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                    break;
                }
                else if ( IsXAddrDefault(m_pszArgv[1]) ) {
                    if ( !IsXAddr(m_pszArgv[2]) &&
                         !IsXAddrDefault(m_pszArgv[2]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        break;
                    }
                }
                if ( ':' == m_pszArgv[2][1] ) {
                    if ( 'X' == toupper(m_pszArgv[2][0]) ) {
                        if ( !IsXAddr(m_pszArgv[1]) &&
                             !IsXAddrDefault(m_pszArgv[1]) ) {
                            m_nErrorID = SYNTAX_ERROR;
                            break;
                        }
                    }
                    else if ( toupper(m_pszArgv[1][0]) != 
                              toupper(m_pszArgv[2][0]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        break;
                    }
                }
                else {
                    if ( IsXAddr(m_pszArgv[1]) || IsXAddrDefault(m_pszArgv[1]) ) {
                        if ( !IsXAddrDefault(m_pszArgv[2]) ) {
                            m_nErrorID = SYNTAX_ERROR;
                            break;
                        }
                    }
                    else if ( IsPAddr(m_pszArgv[1]) ) {
                        if ( !IsPAddrDefault(m_pszArgv[2]) ) {
                            m_nErrorID = SYNTAX_ERROR;
                            break;
                        }
                    }
                    else {
                        m_nErrorID = SYNTAX_ERROR;
                        break;
                    }
                }
                if ( !IsAddrRange(m_pszArgv[1], m_pszArgv[2]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                    break;
                }
                else if ( !IsKeywordInsensitive(m_pszArgv[3]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                    break;
                }
                else if ( !IsString(m_pszArgv[4]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                    break;
                }
                else if ( !IsStringRange(m_nArgc, m_pszArgv) ) {
                    m_nErrorID = SYNTAX_ERROR;
                    break;
                }
                break;
            default:
                m_nErrorID = SYNTAX_ERROR;
                break;
        }
    }
    else {
        switch ( m_nArgc ) {
            case 5:
                // SEarch adr1 Length length {"string"|data..}
                if ( !IsPAddr(m_pszArgv[1]) &&
                     !IsXAddr(m_pszArgv[1]) &&
                     !IsXAddrDefault(m_pszArgv[1]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                    break;
                }
                else if ( !IsKeywordLength(m_pszArgv[2]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                    break;
                }
                else if ( !IsAddrLen(m_pszArgv[3]) )  {
                     m_nErrorID = SYNTAX_ERROR;
                    break;
                }
                else if ( !IsLengthRange(m_pszArgv[1], m_pszArgv[3]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                    break;
                }
                else if (!IsData(m_pszArgv[4]) && !IsString(m_pszArgv[4])) {
                    m_nErrorID = SYNTAX_ERROR;
                    break;
                }
                else if ( IsData(m_pszArgv[4]) ) {
                    if ( !IsDataRange(m_nArgc, m_pszArgv) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        break;
                    }
                }
                else if ( IsString(m_pszArgv[4]) ) {
                    if ( !IsStringRange(m_nArgc, m_pszArgv) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        break;
                    }
                }
                break;
            case 6:
                // SEarch adr1 Length length Insensitive "string"
                if ( !IsPAddr(m_pszArgv[1]) &&
                     !IsXAddr(m_pszArgv[1]) &&
                     !IsXAddrDefault(m_pszArgv[1]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                else if ( !IsKeywordLength(m_pszArgv[2]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                else if ( !IsAddrLen(m_pszArgv[3]) )  {
                     m_nErrorID = SYNTAX_ERROR;
                }
                else if ( !IsLengthRange(m_pszArgv[1], m_pszArgv[3]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                else if ( !IsKeywordInsensitive(m_pszArgv[4]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                else if ( !IsString(m_pszArgv[5]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                else if ( !IsStringRange(m_nArgc, m_pszArgv) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                break;
            default:
                m_nErrorID = SYNTAX_ERROR;
                break;
        }
    }
                    
    
/*
    // SEarch [Insensitive] adr1 {adr2|Length length} {"string"|data..}
    // Pre-process the field: "string" & Data.
    int nArgc;
    if ( m_nArgc < 4 ) {
        m_nErrorID = SYNTAX_ERROR;
        return;
    }
        
    if ( IsKeywordInsensitive(m_pszArgv[1]) ) {
        if ( m_nArgc < 5 ) {
            m_nErrorID = SYNTAX_ERROR;
            return;
        }
        if ( IsKeywordLength(m_pszArgv[3]) ) {
            if ( m_nArgc < 6 ) {
                m_nErrorID = SYNTAX_ERROR;
                return;
            }
            nArgc = 5;
        }
        else {
            nArgc = 4;
        }
    }
    else {
        if ( IsKeywordLength(m_pszArgv[2]) ) {
            if ( m_nArgc < 5 ) {
                m_nErrorID = SYNTAX_ERROR;
                return;
            }
            nArgc = 4;
        }
        else {
            nArgc = 3;
        }
    }

    if ( !PreStringData(nArgc, 2) ) {
        return;
    }

    // Check command syntax.
    if ( !IsKeywordInsensitive(m_pszArgv[1]) ) {
        // SEarch adr1 {adr2|Length length} {"string"|data..}
        switch ( m_nArgc ) {
            case 4:
                if ( !IsAddr(m_pszArgv[1]) || !IsAddr(m_pszArgv[2]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                else if (toupper(m_pszArgv[1][0])!=toupper(m_pszArgv[2][0])){
                    m_nErrorID = SYNTAX_ERROR;
                }
                else if ( !IsAddrRange(m_pszArgv[1], m_pszArgv[2]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                else if (!IsData(m_pszArgv[3]) && !IsString(m_pszArgv[3])) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                else if ( IsData(m_pszArgv[3]) ) {
                    if ( !IsDataRange(m_nArgc, m_pszArgv) ) {
                        m_nErrorID = SYNTAX_ERROR;
                    }
                }
                else if ( IsString(m_pszArgv[3]) ) {
                    if ( !IsStringRange(m_nArgc, m_pszArgv) ) {
                        m_nErrorID = SYNTAX_ERROR;
                    }
                }
                break;
            case 5:
                if ( !IsAddr(m_pszArgv[1]) ||
                     !IsKeywordLength(m_pszArgv[2]) || 
                     !IsAddrLen(m_pszArgv[3]) )  {
                     m_nErrorID = SYNTAX_ERROR;
                }
                else if ( !IsLengthRange(m_pszArgv[1], m_pszArgv[3]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                else if (!IsData(m_pszArgv[4]) && !IsString(m_pszArgv[4])) {
                    m_nErrorID = SYNTAX_ERROR;
                }       
                else if ( IsData(m_pszArgv[4]) ) {
                    if ( !IsDataRange(m_nArgc, m_pszArgv) ) {
                        m_nErrorID = SYNTAX_ERROR;
                    }
                }
                else if ( IsString(m_pszArgv[4]) ) {
                    if ( !IsStringRange(m_nArgc, m_pszArgv) ) {
                        m_nErrorID = SYNTAX_ERROR;
                    }
                }
                break;
            default:
                m_nErrorID = SYNTAX_ERROR;
                break;
        }
    }
    else {
        // SEarch Insensitive adr1 {adr2|Length length} {"string"|data..}
        switch ( m_nArgc ) {
            case 5:
                if ( !IsAddr(m_pszArgv[2]) || !IsAddr(m_pszArgv[3]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                else if (toupper(m_pszArgv[2][0])!=toupper(m_pszArgv[3][0])){
                    m_nErrorID = SYNTAX_ERROR;
                }
                else if ( !IsAddrRange(m_pszArgv[2], m_pszArgv[3]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                else if ( !IsString(m_pszArgv[4]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                else if ( !IsCaseStringRange(m_nArgc, m_pszArgv) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                break;
            case 6:
                if ( !IsAddr(m_pszArgv[2]) ||
                     !IsKeywordLength(m_pszArgv[3]) || 
                     !IsAddrLen(m_pszArgv[4]) )  {
                     m_nErrorID = SYNTAX_ERROR;
                }
                else if ( !IsLengthRange(m_pszArgv[2], m_pszArgv[4]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                else if ( !IsString(m_pszArgv[5]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }       
                else if ( !IsCaseStringRange(m_nArgc, m_pszArgv) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                break;
            default:
                m_nErrorID = SYNTAX_ERROR;
                break;
        }
    }
*/    

}   // End of CSyntaxCore::SyntaxCheckSearch().


// Step         [Over] 
//              [ count | FOrever | adr1 adr2 | 
//              Till { Ret | CAll } | Till {@reg | adr} IS value ]
void CSyntaxCore::SyntaxCheckStep(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Check command syntax.
    switch ( m_nArgc ) {
        case 1:
            break;
        case 2:
            if ( !IsKeywordOver(m_pszArgv[1]) &&
                 !IsKeywordForever(m_pszArgv[1]) &&
                 !IsStepCount(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        case 3:
            if ( IsKeywordOver(m_pszArgv[1]) ) {
                if ( !IsStepCount(m_pszArgv[2]) &&
                     !IsKeywordForever(m_pszArgv[2]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
            }
            else if ( IsKeywordTill(m_pszArgv[1]) ) {
                if ( !IsKeywordRet(m_pszArgv[2]) &&
                     !IsKeywordCall(m_pszArgv[2]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
            }
            else {
                if ( !IsPAddr(m_pszArgv[1]) && 
                     !IsPAddrDefault(m_pszArgv[1]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                else if ( !IsPAddr(m_pszArgv[2]) && 
                          !IsPAddrDefault(m_pszArgv[2]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                else if ( !IsAddrRange(m_pszArgv[1], m_pszArgv[2]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
            }
            break;
        case 4:
            if ( !IsKeywordOver(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( IsKeywordTill(m_pszArgv[2]) ) {
                if ( !IsKeywordRet(m_pszArgv[3]) &&
                     !IsKeywordCall(m_pszArgv[3]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
            }
            else {
                if ( !IsPAddr(m_pszArgv[2]) && 
                     !IsPAddrDefault(m_pszArgv[2]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                else if ( !IsPAddr(m_pszArgv[3]) && 
                          !IsPAddrDefault(m_pszArgv[3]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                else if ( !IsAddrRange(m_pszArgv[2], m_pszArgv[3]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
            }
            break;
        case 5:
            if ( !IsKeywordTill(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( '@' == m_pszArgv[2][0] ) {
                if ( !IsRegName(m_pszArgv[2]+1) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                else if ( 0 != stricmp(m_pszArgv[3], "IS") ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                else if ( !IsRegData(m_pszArgv[2]+1, m_pszArgv[4]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
            }
            else {
                if ( !IsAddr(m_pszArgv[2]) &&
                     !IsPAddrDefault(m_pszArgv[2]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                else if ( 0 != stricmp(m_pszArgv[3], "IS") ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                else if ( !IsAddrData(m_pszArgv[4]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
            }
            break;
        case 6:
            if ( !IsKeywordOver(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsKeywordTill(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( '@' == m_pszArgv[3][0] ) {
                if ( !IsRegName(m_pszArgv[3]+1) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                else if ( 0 != stricmp(m_pszArgv[4], "IS") ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                else if ( !IsRegData(m_pszArgv[3]+1, m_pszArgv[5]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
            }
            else {
                if ( !IsAddr(m_pszArgv[3]) &&
                     !IsPAddrDefault(m_pszArgv[3]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                else if ( 0 != stricmp(m_pszArgv[4], "IS") ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                else if ( !IsAddrData(m_pszArgv[5]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckStep().


// STEPOption   [Instruction|Statement|Line]
void CSyntaxCore::SyntaxCheckStepoption(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    // Check command syntax.
    switch ( m_nArgc ) {
        case 1:
            break;
        case 2:
            if ( !IsKeywordInstruction(m_pszArgv[1]) &&
                 !IsKeywordStatement(m_pszArgv[1]) &&
                 !IsKeywordLine(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckStepoption().


// TEst         adr1 {adr2|Length length}
void CSyntaxCore::SyntaxCheckTest(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Check command syntax.
    switch ( m_nArgc ) {
        case 3:
            if ( !IsPAddr(m_pszArgv[1]) &&
                 !IsXAddr(m_pszArgv[1]) &&
                 !IsIAddr(m_pszArgv[1]) &&
                 !IsXAddrDefault(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
                break;
            }
            else if ( !IsPAddr(m_pszArgv[2]) &&
                      !IsXAddr(m_pszArgv[2]) &&
                      !IsIAddr(m_pszArgv[2]) &&
                      !IsXAddrDefault(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
                break;
            }
            else if ( IsXAddrDefault(m_pszArgv[1]) ) {
                if ( !IsXAddr(m_pszArgv[2]) &&
                     !IsXAddrDefault(m_pszArgv[2]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                    break;
                }
            }
            if ( ':' == m_pszArgv[2][1] ) {
                if ( 'X' == toupper(m_pszArgv[2][0]) ) {
                    if ( !IsXAddr(m_pszArgv[1]) &&
                         !IsXAddrDefault(m_pszArgv[1]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        break;
                    }
                }
                else if ( toupper(m_pszArgv[1][0]) != 
                          toupper(m_pszArgv[2][0]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                    break;
                }
            }
            else {
                if ( IsXAddr(m_pszArgv[1]) || IsXAddrDefault(m_pszArgv[1]) ) {
                    if ( !IsXAddrDefault(m_pszArgv[2]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        break;
                    }
                }
                else if ( IsPAddr(m_pszArgv[1]) ) {
                    if ( !IsPAddrDefault(m_pszArgv[2]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        break;
                    }
                }
                else if ( IsIAddr(m_pszArgv[1]) ) {
                    if ( !IsIAddrDefault(m_pszArgv[2]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        break;
                    }
                }
                else {
                    m_nErrorID = SYNTAX_ERROR;
                    break;
                }
            }
            if ( !IsAddrRange(m_pszArgv[1], m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
                break;
            }
            break;
        case 4:
            if ( !IsPAddr(m_pszArgv[1]) &&
                 !IsXAddr(m_pszArgv[1]) &&
                 !IsIAddr(m_pszArgv[1]) &&
                 !IsXAddrDefault(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsKeywordLength(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsAddrLen(m_pszArgv[3]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsLengthRange(m_pszArgv[1], m_pszArgv[3]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckTest().


// TImer        [ON|OFf]
void CSyntaxCore::SyntaxCheckTimer(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    // Check command syntax.
    switch ( m_nArgc ) {
        case 1:
            break;
        case 2:
            if ( !IsKeywordOn(m_pszArgv[1]) &&
                 !IsKeywordOff(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckTimer().


// TRace        [ON|OFf]
void CSyntaxCore::SyntaxCheckTrace(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    // Check command syntax.
    switch ( m_nArgc ) {
        case 1:
            break;
        case 2:
            if ( !IsKeywordOn(m_pszArgv[1]) &&
                 !IsKeywordOff(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckTrace().


// Trigger      [ [Run] {LV1|LV2} [Then {LV1|LV2}]
//              [FOrward|BACKward|CENter|DELay count] ] |
//              [ON|OFf]
void CSyntaxCore::SyntaxCheckTrigger(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    // Check command syntax.
    switch ( m_nArgc ) {
        case 1:
            // Trigger
            break;
        case 2:
            // Trigger ON|OFf
            // Trigger LV1|LV2
            if ( !IsKeywordOn(m_pszArgv[1]) &&
                 !IsKeywordOff(m_pszArgv[1]) &&
                 !IsKeywordLv1(m_pszArgv[1]) &&
                 !IsKeywordLv2(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        case 3:
            // Trigger Run LV1|LV2
            // Trigger LV1|LV2 FOrward|BACKward|CENter
            if ( IsKeywordRun(m_pszArgv[1]) ) {
                if ( !IsKeywordLv1(m_pszArgv[2]) &&
                     !IsKeywordLv2(m_pszArgv[2]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
            }
            else if ( IsKeywordLv1(m_pszArgv[1]) ||
                      IsKeywordLv2(m_pszArgv[1]) ) {
                if ( !IsKeywordForward(m_pszArgv[2]) &&
                     !IsKeywordBackward(m_pszArgv[2]) &&
                     !IsKeywordCenter(m_pszArgv[2]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
            }
            else {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        case 4:
            // Trigger Run LV1|LV2 FOrward|BACKward|CENter
            // Trigger LV1|LV2 DELay count
            // Trigger LV1 Then LV2
            if ( IsKeywordRun(m_pszArgv[1]) ) {
                if ( !IsKeywordLv1(m_pszArgv[2]) &&
                     !IsKeywordLv2(m_pszArgv[2]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                else if ( !IsKeywordForward(m_pszArgv[3]) &&
                          !IsKeywordBackward(m_pszArgv[3]) &&
                          !IsKeywordCenter(m_pszArgv[3]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
            }
            else if ( !IsKeywordLv1(m_pszArgv[1]) &&
                      !IsKeywordLv2(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( IsKeywordDelay(m_pszArgv[2]) ) {
                if ( !IsAddrData(m_pszArgv[3]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
            }
            else if ( IsKeywordThen(m_pszArgv[2]) ) {
                if ( !IsKeywordLv1(m_pszArgv[1]) ||
                     !IsKeywordLv2(m_pszArgv[3]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }    
            }
            else {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        case 5:
            // Trigger Run LV1 Then LV2
            // Trigger Run {LV1|LV2} Delay count 
            // Trigger LV1 Then LV2 FOrward|BACKward|CENter
            if ( IsKeywordRun(m_pszArgv[1]) ) {
                if ( IsKeywordThen(m_pszArgv[3]) ) {
                    if ( !IsKeywordLv1(m_pszArgv[2]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        break;
                    }
                    else if ( !IsKeywordLv2(m_pszArgv[4]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        break;
                    }
                    else {
                        break;
                    }
                }
                else if ( IsKeywordDelay(m_pszArgv[3]) ) {
                    if ( !IsKeywordLv1(m_pszArgv[2]) &&
                         !IsKeywordLv2(m_pszArgv[2]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        break;
                    }
                    else if ( !IsAddrData(m_pszArgv[4]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        break;
                    }
                    else {
                        break;
                    }
                }
                else {
                    m_nErrorID = SYNTAX_ERROR;
                    break;
                }
            }
            else if ( !IsKeywordLv1(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsKeywordThen(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsKeywordLv2(m_pszArgv[3]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsKeywordForward(m_pszArgv[4]) &&
                      !IsKeywordBackward(m_pszArgv[4]) &&
                      !IsKeywordCenter(m_pszArgv[4]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;                                                 
        case 6:
            // Trigger Run LV1 Then LV2 FOrward|BACKward|CENter
            // Trigger LV1 Then LV2 DELay count
            if ( IsKeywordRun(m_pszArgv[1]) ) {
                if ( !IsKeywordLv1(m_pszArgv[2]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                else if ( !IsKeywordThen(m_pszArgv[3]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                else if ( !IsKeywordLv2(m_pszArgv[4]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                else if ( !IsKeywordForward(m_pszArgv[5]) &&
                          !IsKeywordBackward(m_pszArgv[5]) &&
                          !IsKeywordCenter(m_pszArgv[5]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
            }
            else if ( !IsKeywordLv1(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsKeywordThen(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsKeywordLv2(m_pszArgv[3]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsKeywordDelay(m_pszArgv[4]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsAddrData(m_pszArgv[5]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        case 7:
            // Trigger Run LV1 Then LV2 DELay count
            if ( !IsKeywordRun(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsKeywordLv1(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsKeywordThen(m_pszArgv[3]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsKeywordLv2(m_pszArgv[4]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsKeywordDelay(m_pszArgv[5]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsAddrData(m_pszArgv[6]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }
            
}   // End of CSyntaxCore::SyntaxCheckTrigger().


// Upload       adr1 {adr2|Length length} filename
void CSyntaxCore::SyntaxCheckUpload(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Check command syntax.
    switch ( m_nArgc ) {
        case 4:
            if ( !IsPAddr(m_pszArgv[1]) &&
                 !IsPAddrDefault(m_pszArgv[1]) &&
                 !IsXAddr(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
                break;
            }
            else if ( !IsPAddr(m_pszArgv[2]) &&
                      !IsPAddrDefault(m_pszArgv[2]) &&
                      !IsXAddr(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
                break;
            }
            else if ( IsPAddrDefault(m_pszArgv[1]) ) {
                if ( !IsPAddr(m_pszArgv[2]) &&
                     !IsPAddrDefault(m_pszArgv[2]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                    break;
                }
            }
            if ( ':' == m_pszArgv[2][1] ) {
                if ( 'P' == toupper(m_pszArgv[2][0]) ) {
                    if ( !IsPAddr(m_pszArgv[1]) &&
                         !IsPAddrDefault(m_pszArgv[1]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        break;
                    }
                }
                else if ( toupper(m_pszArgv[1][0]) != 
                          toupper(m_pszArgv[2][0]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                    break;
                }
            }
            else {
                if ( IsXAddr(m_pszArgv[1]) || IsXAddrDefault(m_pszArgv[1]) ) {
                    if ( !IsXAddrDefault(m_pszArgv[2]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        break;
                    }
                }
                else if ( IsPAddr(m_pszArgv[1]) ) {
                    if ( !IsPAddrDefault(m_pszArgv[2]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        break;
                    }
                }
                else {
                    m_nErrorID = SYNTAX_ERROR;
                    break;
                }
            }
            if ( !IsAddrRange(m_pszArgv[1], m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
                break;
            }
            else if ( !IsFilename(m_pszArgv[3]) ) {
                m_nErrorID = SYNTAX_ERROR;
                break;
            }
            break;
        case 5:
            if ( !IsPAddr(m_pszArgv[1]) &&
                 !IsPAddrDefault(m_pszArgv[1]) &&
                 !IsXAddr(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsKeywordLength(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsAddrLen(m_pszArgv[3]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsLengthRange(m_pszArgv[1], m_pszArgv[3]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsFilename(m_pszArgv[4]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckUpload().


// Verify       [ON|OFf]
void CSyntaxCore::SyntaxCheckVerify(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    // Check command syntax.
    switch ( m_nArgc ) {
        case 1:
            break;
        case 2:
            if ( !IsKeywordOn(m_pszArgv[1]) &&
                 !IsKeywordOff(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckVerify().


// Word         adr data1 [.. data16]
void CSyntaxCore::SyntaxCheckWord(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Pre-process the field: "string" & Data.
    if ( m_nArgc < 3 ) {
        m_nErrorID = SYNTAX_ERROR;
        return;
    }
    
    int nArgc = 2;
    if ( !PreStringData(nArgc, 4) ) {
        return;
    }

    // Check command syntax.
    switch ( m_nArgc ) {
        case 3:
            if ( !IsPAddr(m_pszArgv[1]) &&
                 !IsXAddr(m_pszArgv[1]) &&
                 !IsIAddr(m_pszArgv[1]) &&
                 !IsRAddr(m_pszArgv[1]) &&
                 !IsBAddr(m_pszArgv[1]) &&
                 !IsXAddrDefault(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsDataWord(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsDataRange(m_nArgc, m_pszArgv, 2) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckWord().


// BAck
void CSyntaxCore::SyntaxCheckBack(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    // Check command syntax.
    switch ( m_nArgc ) {
        case 1:
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckBack().


// CReate       #symbol adr
void CSyntaxCore::SyntaxCheckCreate(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    // Check command syntax.
    switch ( m_nArgc ) {
        case 3:
            if ( !IsVariableName(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsPAddr(m_pszArgv[2]) &&
                      !IsXAddr(m_pszArgv[2]) &&
                      !IsIAddr(m_pszArgv[2]) &&
                      !IsRAddr(m_pszArgv[2]) &&
                      !IsBAddr(m_pszArgv[2]) &&
                      !IsPAddrDefault(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckCreate().


// DElete       #symbol | All
void CSyntaxCore::SyntaxCheckDelete(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    // Check command syntax.
    switch ( m_nArgc ) {
        case 2:
            if ( !IsVariableName(m_pszArgv[1]) && 
                 !IsKeywordAll(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckDelete().


// LOAd         filename 
//              [Symbols|NOSymbols] 
//              [Code|NOCode]
//              [Progress|NOProgress] 
//              [Demand|NODemand]
//              [Module module_name]
//              [Warn|NOWarn] 
//              [Mangle|NOMangle]
//              [p:|x:]
void CSyntaxCore::SyntaxCheckLoad(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    // Check command syntax.
    switch ( m_nArgc ) {
        case 2:
            if ( !IsFilename(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        case 3:
        case 4:
        case 5:
        case 6:
        case 7:
        case 8:
        case 9:
//        case 10:
//        case 11:
            if ( !IsFilename(m_pszArgv[1]) ||
                 !IsLoadOption(m_nArgc, m_pszArgv) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckLoad().


// MODUle
void CSyntaxCore::SyntaxCheckModule(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    // Check command syntax.
    switch ( m_nArgc ) {
        case 1:
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckModule().


// QUEry        #symbol | #module#line_no | hex_adr
void CSyntaxCore::SyntaxCheckQuery(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Check command syntax.
    switch ( m_nArgc ) {
        case 2:
            if ( !IsSymbolName(m_pszArgv[1]) &&
                 //!IsLineNo(m_pszArgv[1]) &&
                 !IsAddr(m_pszArgv[1]) &&
                 !IsPAddrDefault(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckQuery().


// SSave        filename
void CSyntaxCore::SyntaxCheckSsave(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Check command syntax.
    switch ( m_nArgc ) {
        case 2:
            if ( !IsFilename(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckSsave().


// SRecall      filename
void CSyntaxCore::SyntaxCheckSrecall(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Check command syntax.
    switch ( m_nArgc ) {
        case 2:
            if ( !IsFilename(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }
    
}   // End of CSyntaxCore::SyntaxCheckSrecall().


// SYmbol       [ Global | Module | #module ]
void CSyntaxCore::SyntaxCheckSymbol(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Check command syntax.
    switch ( m_nArgc ) {
        case 1:
            break;
        case 2:
            if ( !IsKeywordGlobal(m_pszArgv[1]) &&
                 !IsKeywordModule(m_pszArgv[1]) &&
                 !IsVariableName(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckSymbol().


// Watch        [[@n][variable_name]]
void CSyntaxCore::SyntaxCheckWatch(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Check command syntax.
    switch ( m_nArgc ) {
        case 1:
            break;
        case 2:
            if ( !IsBackLevel(m_pszArgv[1]) &&
                 !IsVariableName(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        case 3:
            if ( !IsBackLevel(m_pszArgv[1]) ||
                 !IsVariableName(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;        
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckWatch().


#ifdef _CHEN_

// Calculate
void CSyntaxCore::SyntaxCheckCalculate(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    // Check command syntax.

}   // End of CSyntaxCore::SyntaxCheckCalculate().

#endif  // _CHEN_


#ifdef _GATES

// COUNT
void CSyntaxCore::SyntaxCheckCount(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    // Check command syntax.
    switch ( m_nArgc ) {
        case 1:
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckCount().


// LINE
void CSyntaxCore::SyntaxCheckLine(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    // Check command syntax.
    switch ( m_nArgc ) {
        case 1:
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckLine().


// STATEMENT
void CSyntaxCore::SyntaxCheckStatement(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    // Check command syntax.
    switch ( m_nArgc ) {
        case 1:
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckStatement().


// VOID
void CSyntaxCore::SyntaxCheckVoid(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    // Check command syntax.

}   // End of CSyntaxCore::SyntaxCheckVoid().


// TYPE
void CSyntaxCore::SyntaxCheckType(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    // Check command syntax.
    switch ( m_nArgc ) {
        case 1:
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckType().

#endif  // _GATES


//////////////////////////////// End of File ////////////////////////////////
