
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/SYNTAX.H__   1.8   20 Jun 1996 09:25:22   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/SYNTAX.H__  $
** 
**    Rev 1.8   20 Jun 1996 09:25:22   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.6   10 Jun 1996 10:20:00   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.4   29 May 1996 09:29:22   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:06:38   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:11:18   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:28:54   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 12:58:02   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:41:42   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:56:40   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:08:00   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:34:28   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:48:48   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:14:48   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:18:10   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:18:06   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:33:52   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:28:26   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:15:10   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:17:16   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:08:22   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:14:10   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:33:04   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:23:34   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:25:54   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:28:50   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:28:12   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:41:26   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:03:22   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:46:34   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:45:34   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:27:08   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:51:18   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:22:24   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:51:26   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:54:28   Shirley
** EasyPack/SLD Version 0.1b
** 
**    Rev 1.1   15 Sep 1995 09:48:58   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:54:08   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: SYNTAX.H
//
//  Description: The header file for the class: CSyntaxCheck.
//
//  Author: Chen Jun
//
//  Date: 04/03/95
//
//  Modification:
//      1. 04/03/95, Initial version of the class: CSyntaxCheck.
//
/////////////////////////////////////////////////////////////////////////////
#ifndef _SYNTAX_
#define _SYNTAX_

#include "syncore.h"

/////////////////////////////////////////////////////////////////////////////
// CSyntaxCheck class.
class CSyntaxCheck : public CSyntaxCore
{
// Construction & Destruction.
public:
    CSyntaxCheck();
    ~CSyntaxCheck();
    
// Member variables.
private:
    // Local macro definition.
    enum { MIN_KEY = 0x20, MAX_KEY = 0x7F, TOKEN_KEY = 0x20, KEY_DQ = 0x22 };
    
    enum { MAX_FILL_SIZE = 32 };
    
    // Receive from the Shell command line.
    int m_nLen;
    char m_pchLineBuf[MAX_CMDLINE+1];

    // Command ID.
    int m_nCommandID;
    
// Implementations.
private:
    // Syntax check common routine.
    void CopyCommandLine(const char* pchEditBuf, const int nLen);
    BOOL CommandParse(void);
    BOOL CheckCommandKeyword(void);
    void DisplaySyntaxError(void) const;
    void DispatchCommand(void);

public:
    BOOL CheckCommandSyntax(const char* pchEditBuf, const int nLen);

};  // End of class: CSyntaxCheck.

#endif
//////////////////////////////// End of File ////////////////////////////////
