
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/TABDLL11.H__   1.8   20 Jun 1996 09:30:44   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/TABDLL11.H__  $
** 
**    Rev 1.8   20 Jun 1996 09:30:44   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.6   10 Jun 1996 10:25:22   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.4   29 May 1996 09:38:16   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:00:34   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:15:00   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:22:52   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 13:02:40   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:36:44   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:49:42   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:02:12   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:27:26   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:43:04   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:15:56   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:12:48   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:13:26   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:39:14   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:28:04   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:10:00   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:16:16   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:11:48   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:08:26   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:34:58   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:24:14   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:24:56   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:29:22   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:32:48   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:42:10   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:06:30   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:50:06   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:49:28   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:26:20   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:49:00   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:21:24   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:51:26   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:54:30   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:49:00   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:54:10   Shirley
** Initial revision.
**
****************************************************************************/

/*************
* TABDLL11.H
*************/

#ifndef TABDLL11_H
#define TABDLL11_H

#ifdef __cplusplus
extern "C" {
#endif

/*******************************************************************
*                          Tab Control
*******************************************************************/

#define FPCLASS_TAB "fpTabPro11"

/***************
* Error Status
***************/

typedef long FP_ERROR;

/***************
* Error Status
***************/

typedef long FP_ERROR;

/***********
* Messages
***********/

#define TABM_SETPROPERTY                  (WM_USER + 1)
#define TABM_GETPROPERTY                  (WM_USER + 2)

#define TABM_TABACTIVATE                  0x0501
#define TABM_TABSHOWN                     0x0502
#define TABM_TABPREVIEW                   0x0503
#define TABM_TABSCROLL                    0x0504
#define TABM_CLIENTCLICK                  0x0505
#define TABM_USERERROR                    0x0506

#define TABN_SETFOCUS                     51
#define TABN_KILLFOCUS                    52

/*********
* Styles
*********/

#define TABS_HALIGN_CENTER                0x0001L
#define TABS_HALIGN_RIGHT                 0x0002L
#define TABS_FLIPTEXT                     0x0004L
#define TABS_NOTHREED                     0x0008L
#define TABS_ORIENT_RIGHT                 0x0010L
#define TABS_ORIENT_BOTTOM                0x0020L
#define TABS_ORIENT_LEFT                  0x0030L
#define TABS_SHAPE_SLANTED                0x0040L
#define TABS_SHAPE_ROUNDED                0x0080L
#define TABS_SHAPE_SQUARE                 0x00C0L
#define TABS_MODE_BOOK_ONEPAGE            0x0100L
#define TABS_MODE_BOOK_TWOPAGES           0x0200L
#define TABS_ROTATETEXT90                 0x0400L

/***********************
* Property Definitions
***********************/

#define TABPROP_AlignTextV                 0
#define TABPROP_AlignTextH                 1
#define TABPROP_WordWrap                   2
#define TABPROP_ActiveTab                  3
#define TABPROP_Tab                        4
#define TABPROP_TabHeight                  5
#define TABPROP_TabsPerRow                 6
#define TABPROP_TabCount                   7
#define TABPROP_TabCaption                 9
#define TABPROP_TabCaptionLength           10
#define TABPROP_Orientation                11
#define TABPROP_FlipText                   12
#define TABPROP_ThreeD                     13
#define TABPROP_ThreeDShadowColor          14
#define TABPROP_ThreeDHighlightColor       15
#define TABPROP_ClientHeight               16
#define TABPROP_ClientLeft                 17
#define TABPROP_ClientTop                  18
#define TABPROP_ClientWidth                19
#define TABPROP_ShowFocusRect              20
#define TABPROP_ThreeDText                 21
#define TABPROP_ThreeDTextOffset           22
#define TABPROP_ThreeDTextHighlightColor   23
#define TABPROP_ThreeDTextShadowColor      24
#define TABPROP_TabShape                   25
#define TABPROP_MarginLeft                 26
#define TABPROP_MarginRight                27
#define TABPROP_TabMaxWidth                28
#define TABPROP_TabState                   29
#define TABPROP_BackColor                  30
#define TABPROP_ForeColor                  31
#define TABPROP_ApplyTo                    32
#define TABPROP_ActiveTabBold              33
#define TABPROP_GrayAreaColor              34
#define TABPROP_OutlineColor               35
#define TABPROP_TabPicture                 36
#define TABPROP_AlignPictureV              37
#define TABPROP_AlignPictureH              38
#define TABPROP_TabSeparator               39
#define TABPROP_PageColor                  40
#define TABPROP_MouseOverTab               41
#define TABPROP_OffsetFromClientTop        42
#define TABPROP_HighestPrecedence          43
#define TABPROP_RotateText90               44
#define TABPROP_ChamferedWidth             45
#define TABPROP_ChamferedHeight            46
#define TABPROP_TabRowOffset               47
#define TABPROP_AllowPreview               48
#define TABPROP_TabID                      49
#define TABPROP_Action                     50
#define TABPROP_TabDest                    51
#define TABPROP_AllowScroll                52
#define TABPROP_ShowEarMark                53
#define TABPROP_TabLeft                    54
#define TABPROP_TabRight                   55
#define TABPROP_EarMarkColorDark           56
#define TABPROP_EarMarkColorLight          57
#define TABPROP_EarMarkColorOutline        58
#define TABPROP_EarMarkHeight              59
#define TABPROP_Mode                       60
#define TABPROP_BookMarginH                61
#define TABPROP_BookMarginV                62
#define TABPROP_BookCreaseType             63
#define TABPROP_BookCreaseColor            64
#define TABPROP_BookColor                  65
#define TABPROP_BookRingColor              66
#define TABPROP_BookRingColorLight         67
#define TABPROP_BookRingColorOutline       68
#define TABPROP_BookRingLength             69
#define TABPROP_BookRingWidth              70
#define TABPROP_BookRingCount              71
#define TABPROP_BookRingGroupCount         72
#define TABPROP_BookRingMargin             73
#define TABPROP_BookRingOutsideMargin      74
#define TABPROP_BookShowMetalSpine         75
#define TABPROP_BookMetalSpineColor        76
#define TABPROP_BookMetalSpineOutlineColor 77
#define TABPROP_BookCornerType             78
#define TABPROP_BookCornerWidth            79
#define TABPROP_BookCornerHeight           80
#define TABPROP_BookShadowSize             81
#define TABPROP_BookShadowColor            82
#define TABPROP_BookGutter                 83
#define TABPROP_BookRingType               84
#define TABPROP_BookDoubleWireMargin       85
#define TABPROP_BookRingArc                86
#define TABPROP_BookRingShowHole           87
#define TABPROP_BookCoverStyle             88
#define TABPROP_PageMax                    89
#define TABPROP_Page                       90
#define TABPROP_ActivePage                 91
#define TABPROP_PageEarMarkType            92
#define TABPROP_PageFlipEffect             93
#define TABPROP_PageEarMarkColorDark       94
#define TABPROP_PageEarMarkColorLight      95
#define TABPROP_PageEarMarkColorOutline    96
#define TABPROP_PageEarMarkHeight          97
#define TABPROP_PageEarMarkAlignNext       98
#define TABPROP_PageEarMarkAlignPrev       99
#define TABPROP_MaxScrollRows              100
#define TABPROP_ClientHeightPrev           101
#define TABPROP_ClientLeftPrev             102
#define TABPROP_ClientTopPrev              103
#define TABPROP_ClientWidthPrev            104
#define TABPROP_AutoSize                   105
#define TABPROP_PageFlipSpeed              106
#define TABPROP_AutoSizeOffsetLeft         107
#define TABPROP_AutoSizeOffsetRight        108
#define TABPROP_AutoSizeOffsetTop          109
#define TABPROP_AutoSizeOffsetBottom       110
#define TABPROP_BookShowCornerGuard        111
#define TABPROP_BookCornerGuardWidth       112
#define TABPROP_BookCornerGuardLength      113
#define TABPROP_BookCornerGuardColor       114
#define TABPROP_BookCornerGuardColorDark   115
#define TABPROP_BookCornerGuardColorLight  116
#define TABPROP_BookModeType               117
#define TABPROP_FreezeRows                 118

/************
* Constants
************/

#define TABERR_OK                     0
#define TABERR_INVALIDVAL             1

// AlignPictureH
#define TAB_ALIGNPICT_H_LEFT     0
#define TAB_ALIGNPICT_H_CENTER   1
#define TAB_ALIGNPICT_H_RIGHT    2
#define TAB_ALIGNPICT_H_LEFTTXT  3
#define TAB_ALIGNPICT_H_RIGHTTXT 4

// AlignPictureV
#define TAB_ALIGNPICT_V_TOP    0
#define TAB_ALIGNPICT_V_CENTER 1
#define TAB_ALIGNPICT_V_BOTTOM 2

// AlignTextH
#define TAB_ALIGNTEXT_H_LEFT   0
#define TAB_ALIGNTEXT_H_CENTER 1
#define TAB_ALIGNTEXT_H_RIGHT  2

// AlignTextV
#define TAB_ALIGNTEXT_V_TOP    0
#define TAB_ALIGNTEXT_V_CENTER 1
#define TAB_ALIGNTEXT_V_BOTTOM 2

// ApplyTo
#define TAB_APPLYTO_DEFAULT 0
#define TAB_APPLYTO_ACTIVE  1
#define TAB_APPLYTO_TAB     2

// BorderAlignTextH
#define TAB_BORDERALIGNTEXT_H_LEFT   0
#define TAB_BORDERALIGNTEXT_H_CENTER 1
#define TAB_BORDERALIGNTEXT_H_RIGHT  2
#define TAB_BORDERALIGNTEXT_H_TOP    0
#define TAB_BORDERALIGNTEXT_H_BOTTOM 2

// BorderTextOrientation
#define TAB_BORDERORIENT_TOP    0
#define TAB_BORDERORIENT_RIGHT  1
#define TAB_BORDERORIENT_BOTTOM 2
#define TAB_BORDERORIENT_LEFT   3

// FrameThreeDStyle
#define TAB_FRAME3D_STY_NONE      0
#define TAB_FRAME3D_STY_LOW       1
#define TAB_FRAME3D_STY_RAISED    2
#define TAB_FRAME3D_STY_GRPLOW    3
#define TAB_FRAME3D_STY_GRPRAISED 4

// Orientation
#define TAB_ORIENTATION_TOP    0
#define TAB_ORIENTATION_RIGHT  1
#define TAB_ORIENTATION_BOTTOM 2
#define TAB_ORIENTATION_LEFT   3

// TabShape
#define TAB_SHAPE_CORNERED  0       // Left in for backward compatibility
#define TAB_SHAPE_CHAMFERED 0
#define TAB_SHAPE_SLANTED   1
#define TAB_SHAPE_ROUNDED   2
#define TAB_SHAPE_SQUARE    3

// TabState
#define TAB_STATE_ENABLED         0
#define TAB_STATE_HIDE            1
#define TAB_STATE_DISABLED_TEXT   2
#define TAB_STATE_DISABLED_NOTEXT 3

// TextRotation
#define TAB_TEXT_ROTATE_0   0
#define TAB_TEXT_ROTATE_90  1
#define TAB_TEXT_ROTATE_180 2
#define TAB_TEXT_ROTATE_270 3

// ThreeDStyle
#define TAB_3DSTYLE_NONE      0
#define TAB_3DSTYLE_LOW       1
#define TAB_3DSTYLE_RAISED    2
#define TAB_3DSTYLE_GRPLOW    3
#define TAB_3DSTYLE_GRPRAISED 4

// ThreeDText
#define TAB_3DTEXT_NONE      0
#define TAB_3DTEXT_RSD_LIGHT 1
#define TAB_3DTEXT_LOW_LIGHT 2
#define TAB_3DTEXT_RSD_HEAVY 3
#define TAB_3DTEXT_LOW_HEAVY 4

// HighestPecedence
#define TAB_PRECEDENCE_ACTIVE     0
#define TAB_PRECEDENCE_INDIVIDUAL 1

// Action
#define TAB_ACTION_INSERT 0
#define TAB_ACTION_DELETE 1
#define TAB_ACTION_MOVE   2
#define TAB_ACTION_SWAP   3
#define TAB_ACTION_CLEAR  4

// AllowScroll
#define TAB_SCROLL_OFF     0
#define TAB_SCROLL_WHOLE   1
#define TAB_SCROLL_PARTIAL 2

// Mode
#define TAB_MODE_TAB           0
#define TAB_MODE_BOOK_ONEPAGE  1
#define TAB_MODE_BOOK_TWOPAGES 2

// BookCreaseType
#define TAB_BOOK_CREASETYPE_NONE   0
#define TAB_BOOK_CREASETYPE_1LINE  1
#define TAB_BOOK_CREASETYPE_2LINES 2

// BookCornerType
#define TAB_BOOK_CORNERTYPE_ROUND     0
#define TAB_BOOK_CORNERTYPE_SQUARE    1
#define TAB_BOOK_CORNERTYPE_CHAMFERED 2

// BookRingType
#define TAB_BOOK_RINGTYPE_METAL      0
#define TAB_BOOK_RINGTYPE_SINGLEWIRE 1
#define TAB_BOOK_RINGTYPE_DOUBLEWIRE 2

// BookCoverStyle
#define TAB_BOOKCOVERSTYLE_NONE   0
#define TAB_BOOKCOVERSTYLE_OPEN   1
#define TAB_BOOKCOVERSTYLE_CLOSED 2

// PageEarMarkType
#define TAB_PAGEEARMARKTYPE_NONE   0
#define TAB_PAGEEARMARKTYPE_TRANS  1
#define TAB_PAGEEARMARKTYPE_SIMPLE 2
#define TAB_PAGEEARMARKTYPE_THREED 3

// PageFlipEffect
#define TAB_PAGEFLIPEFFECT_FAST     0
#define TAB_PAGEFLIPEFFECT_ANIMATED 1

// PageEarMarkAlignNext
// PageEarMarkAlignPrev
#define TAB_PAGEEARMARKALIGN_UR 0
#define TAB_PAGEEARMARKALIGN_LR 1
#define TAB_PAGEEARMARKALIGN_LL 2
#define TAB_PAGEEARMARKALIGN_UL 3

// AutoSize
#define TAB_AUTOSIZE_NONE   0
#define TAB_AUTOSIZE_TOP    1
#define TAB_AUTOSIZE_BOTTOM 2
#define TAB_AUTOSIZE_LEFT   3
#define TAB_AUTOSIZE_RIGHT  4
#define TAB_AUTOSIZE_FILL   5

// BookModeType
#define TAB_BOOKMODETYPE_TABDIV  0
#define TAB_BOOKMODETYPE_TABPAGE 1

// Preview Action
#define TAB_PREVIEW_ACTION_QUERY 0
#define TAB_PREVIEW_ACTION_SHOW  1

/*************
* Structures
*************/

typedef struct tagTABSCROLL
   {
   short nOldTabLeft;
   short nNewTabLeft;
   } TABSCROLL, FAR *LPTABSCROLL;

/**********************
* Function Prototypes
**********************/

typedef short FAR *LPSHORT;

void FAR PASCAL _export TabGetCurrentPages(HWND hWnd, LPSHORT lpnTabNext,
                                           LPSHORT lpnPageNext,
                                           LPSHORT lpnTabPrev,
                                           LPSHORT lpnPagePrev);
BOOL FAR PASCAL _export TabSetActiveTabPage(HWND hWnd, short nTab, short nPage);

int FAR PASCAL _export TabGetActivePage(HWND hWnd);
int FAR PASCAL _export TabGetActiveTab(HWND hWnd);
BOOL FAR PASCAL _export TabGetActiveTabBold(HWND hWnd);
short FAR PASCAL _export TabGetAlignPictureH(HWND hWnd);
short FAR PASCAL _export TabGetAlignPictureV(HWND hWnd);
short FAR PASCAL _export TabGetAlignTextH(HWND hWnd);
short FAR PASCAL _export TabGetAlignTextV(HWND hWnd);
BOOL FAR PASCAL _export TabGetAllowPreview(HWND hWnd);
short FAR PASCAL _export TabGetAllowScroll(HWND hWnd);
short FAR PASCAL _export TabGetApplyTo(HWND hWnd);
short FAR PASCAL _export TabGetAutoSize(HWND hWnd);
short FAR PASCAL _export TabGetAutoSizeChildren(HWND hWnd);
int FAR PASCAL _export TabGetAutoSizeOffsetBottom(HWND hWnd);
int FAR PASCAL _export TabGetAutoSizeOffsetLeft(HWND hWnd);
int FAR PASCAL _export TabGetAutoSizeOffsetRight(HWND hWnd);
int FAR PASCAL _export TabGetAutoSizeOffsetTop(HWND hWnd);
COLORREF FAR PASCAL _export TabGetBackColor(HWND hWnd);
COLORREF FAR PASCAL _export TabGetBookColor(HWND hWnd);
COLORREF FAR PASCAL _export TabGetBookCornerGuardColor(HWND hWnd);
COLORREF FAR PASCAL _export TabGetBookCornerGuardColorDark(HWND hWnd);
COLORREF FAR PASCAL _export TabGetBookCornerGuardColorLight(HWND hWnd);
int FAR PASCAL _export TabGetBookCornerGuardLength(HWND hWnd);
int FAR PASCAL _export TabGetBookCornerGuardWidth(HWND hWnd);
int FAR PASCAL _export TabGetBookCornerHeight(HWND hWnd);
short FAR PASCAL _export TabGetBookCornerType(HWND hWnd);
int FAR PASCAL _export TabGetBookCornerWidth(HWND hWnd);
short FAR PASCAL _export TabGetBookCoverStyle(HWND hWnd);
COLORREF FAR PASCAL _export TabGetBookCreaseColor(HWND hWnd);
short FAR PASCAL _export TabGetBookCreaseType(HWND hWnd);
int FAR PASCAL _export TabGetBookDoubleWireMargin(HWND hWnd);
int FAR PASCAL _export TabGetBookGutter(HWND hWnd);
int FAR PASCAL _export TabGetBookMarginH(HWND hWnd);
int FAR PASCAL _export TabGetBookMarginV(HWND hWnd);
COLORREF FAR PASCAL _export TabGetBookMetalSpineColor(HWND hWnd);
COLORREF FAR PASCAL _export TabGetBookMetalSpineOutlineColor(HWND hWnd);
short FAR PASCAL _export TabGetBookModeType(HWND hWnd);
int FAR PASCAL _export TabGetBookRingArc(HWND hWnd);
COLORREF FAR PASCAL _export TabGetBookRingColor(HWND hWnd);
COLORREF FAR PASCAL _export TabGetBookRingColorLight(HWND hWnd);
COLORREF FAR PASCAL _export TabGetBookRingColorOutline(HWND hWnd);
int FAR PASCAL _export TabGetBookRingCount(HWND hWnd);
int FAR PASCAL _export TabGetBookRingGroupCount(HWND hWnd);
int FAR PASCAL _export TabGetBookRingLength(HWND hWnd);
int FAR PASCAL _export TabGetBookRingMargin(HWND hWnd);
int FAR PASCAL _export TabGetBookRingOutsideMargin(HWND hWnd);
BOOL FAR PASCAL _export TabGetBookRingShowHole(HWND hWnd);
short FAR PASCAL _export TabGetBookRingType(HWND hWnd);
int FAR PASCAL _export TabGetBookRingWidth(HWND hWnd);
COLORREF FAR PASCAL _export TabGetBookShadowColor(HWND hWnd);
int FAR PASCAL _export TabGetBookShadowSize(HWND hWnd);
BOOL FAR PASCAL _export TabGetBookShowCornerGuard(HWND hWnd);
BOOL FAR PASCAL _export TabGetBookShowMetalSpine(HWND hWnd);
int FAR PASCAL _export TabGetChamferedHeight(HWND hWnd);
int FAR PASCAL _export TabGetChamferedWidth(HWND hWnd);
int FAR PASCAL _export TabGetClientHeight(HWND hWnd);
int FAR PASCAL _export TabGetClientHeightPrev(HWND hWnd);
int FAR PASCAL _export TabGetClientLeft(HWND hWnd);
int FAR PASCAL _export TabGetClientLeftPrev(HWND hWnd);
int FAR PASCAL _export TabGetClientTop(HWND hWnd);
int FAR PASCAL _export TabGetClientTopPrev(HWND hWnd);
int FAR PASCAL _export TabGetClientWidth(HWND hWnd);
int FAR PASCAL _export TabGetClientWidthPrev(HWND hWnd);
COLORREF FAR PASCAL _export TabGetEarMarkColorDark(HWND hWnd);
COLORREF FAR PASCAL _export TabGetEarMarkColorLight(HWND hWnd);
COLORREF FAR PASCAL _export TabGetEarMarkColorOutline(HWND hWnd);
int FAR PASCAL _export TabGetEarMarkHeight(HWND hWnd);
BOOL FAR PASCAL _export TabGetFlipText(HWND hWnd);
COLORREF FAR PASCAL _export TabGetForeColor(HWND hWnd);
BOOL FAR PASCAL _export TabGetFreezeRows(HWND hWnd);
COLORREF FAR PASCAL _export TabGetGrayAreaColor(HWND hWnd);
short FAR PASCAL _export TabGetHighestPrecedence(HWND hWnd);
int FAR PASCAL _export TabGetMarginLeft(HWND hWnd);
int FAR PASCAL _export TabGetMarginRight(HWND hWnd);
int FAR PASCAL _export TabGetMaxScrollRows(HWND hWnd);
short FAR PASCAL _export TabGetMode(HWND hWnd);
int FAR PASCAL _export TabGetMouseOverTab(HWND hWnd);
BOOL FAR PASCAL _export TabGetOffsetFromClientTop(HWND hWnd);
short FAR PASCAL _export TabGetOrientation(HWND hWnd);
COLORREF FAR PASCAL _export TabGetOutlineColor(HWND hWnd);
int FAR PASCAL _export TabGetPage(HWND hWnd);
COLORREF FAR PASCAL _export TabGetPageColor(HWND hWnd);
short FAR PASCAL _export TabGetPageEarMarkAlignNext(HWND hWnd);
short FAR PASCAL _export TabGetPageEarMarkAlignPrev(HWND hWnd);
COLORREF FAR PASCAL _export TabGetPageEarMarkColorDark(HWND hWnd);
COLORREF FAR PASCAL _export TabGetPageEarMarkColorLight(HWND hWnd);
COLORREF FAR PASCAL _export TabGetPageEarMarkColorOutline(HWND hWnd);
int FAR PASCAL _export TabGetPageEarMarkHeight(HWND hWnd);
short FAR PASCAL _export TabGetPageEarMarkType(HWND hWnd);
short FAR PASCAL _export TabGetPageFlipEffect(HWND hWnd);
int FAR PASCAL _export TabGetPageFlipSpeed(HWND hWnd);
int FAR PASCAL _export TabGetPageMax(HWND hWnd);
BOOL FAR PASCAL _export TabGetRotateText90(HWND hWnd);
BOOL FAR PASCAL _export TabGetShowEarMark(HWND hWnd);
BOOL FAR PASCAL _export TabGetShowFocusRect(HWND hWnd);
int FAR PASCAL _export TabGetTab(HWND hWnd);
void FAR PASCAL _export TabGetTabCaption(HWND hWnd, LPSTR value);
int FAR PASCAL _export TabGetTabCount(HWND hWnd);
int FAR PASCAL _export TabGetTabCaptionLength(HWND hWnd);
int FAR PASCAL _export TabGetTabDest(HWND hWnd);
int FAR PASCAL _export TabGetTabHeight(HWND hWnd);
long FAR PASCAL _export TabGetTabID(HWND hWnd);
int FAR PASCAL _export TabGetTabLeft(HWND hWnd);
int FAR PASCAL _export TabGetTabMaxWidth(HWND hWnd);
HANDLE FAR PASCAL _export TabGetTabPicture(HWND hWnd);
int FAR PASCAL _export TabGetTabRight(HWND hWnd);
int FAR PASCAL _export TabGetTabRowOffset(HWND hWnd);
int FAR PASCAL _export TabGetTabSeparator(HWND hWnd);
short FAR PASCAL _export TabGetTabShape(HWND hWnd);
short FAR PASCAL _export TabGetTabState(HWND hWnd);
int FAR PASCAL _export TabGetTabsPerRow(HWND hWnd);
BOOL FAR PASCAL _export TabGetThreeD(HWND hWnd);
COLORREF FAR PASCAL _export TabGetThreeDHighlightColor(HWND hWnd);
COLORREF FAR PASCAL _export TabGetThreeDShadowColor(HWND hWnd);
short FAR PASCAL _export TabGetThreeDText(HWND hWnd);
COLORREF FAR PASCAL _export TabGetThreeDTextHighlightColor(HWND hWnd);
int FAR PASCAL _export TabGetThreeDTextOffset(HWND hWnd);
COLORREF FAR PASCAL _export TabGetThreeDTextShadowColor(HWND hWnd);
BOOL FAR PASCAL _export TabGetWordWrap(HWND hWnd);

FP_ERROR FAR PASCAL _export TabSetAction(HWND hWnd, short value);
FP_ERROR FAR PASCAL _export TabSetActivePage(HWND hWnd, int value);
FP_ERROR FAR PASCAL _export TabSetActiveTab(HWND hWnd, int value);
FP_ERROR FAR PASCAL _export TabSetActiveTabBold(HWND hWnd, BOOL value);
FP_ERROR FAR PASCAL _export TabSetAlignPictureH(HWND hWnd, short value);
FP_ERROR FAR PASCAL _export TabSetAlignPictureV(HWND hWnd, short value);
FP_ERROR FAR PASCAL _export TabSetAlignTextH(HWND hWnd, short value);
FP_ERROR FAR PASCAL _export TabSetAlignTextV(HWND hWnd, short value);
FP_ERROR FAR PASCAL _export TabSetAllowPreview(HWND hWnd, BOOL value);
FP_ERROR FAR PASCAL _export TabSetAllowScroll(HWND hWnd, short value);
FP_ERROR FAR PASCAL _export TabSetApplyTo(HWND hWnd, short value);
FP_ERROR FAR PASCAL _export TabSetAutoSize(HWND hWnd, short value);
FP_ERROR FAR PASCAL _export TabSetAutoSizeChildren(HWND hWnd, short value);
FP_ERROR FAR PASCAL _export TabSetAutoSizeOffsetBottom(HWND hWnd, int value);
FP_ERROR FAR PASCAL _export TabSetAutoSizeOffsetLeft(HWND hWnd, int value);
FP_ERROR FAR PASCAL _export TabSetAutoSizeOffsetRight(HWND hWnd, int value);
FP_ERROR FAR PASCAL _export TabSetAutoSizeOffsetTop(HWND hWnd, int value);
FP_ERROR FAR PASCAL _export TabSetBackColor(HWND hWnd, COLORREF value);
FP_ERROR FAR PASCAL _export TabSetBookColor(HWND hWnd, COLORREF value);
FP_ERROR FAR PASCAL _export TabSetBookCornerGuardColor(HWND hWnd, COLORREF value);
FP_ERROR FAR PASCAL _export TabSetBookCornerGuardColorDark(HWND hWnd, COLORREF value);
FP_ERROR FAR PASCAL _export TabSetBookCornerGuardColorLight(HWND hWnd, COLORREF value);
FP_ERROR FAR PASCAL _export TabSetBookCornerGuardLength(HWND hWnd, int value);
FP_ERROR FAR PASCAL _export TabSetBookCornerGuardWidth(HWND hWnd, int value);
FP_ERROR FAR PASCAL _export TabSetBookCornerHeight(HWND hWnd, int value);
FP_ERROR FAR PASCAL _export TabSetBookCornerType(HWND hWnd, short value);
FP_ERROR FAR PASCAL _export TabSetBookCornerWidth(HWND hWnd, int value);
FP_ERROR FAR PASCAL _export TabSetBookCoverStyle(HWND hWnd, short value);
FP_ERROR FAR PASCAL _export TabSetBookCreaseColor(HWND hWnd, COLORREF value);
FP_ERROR FAR PASCAL _export TabSetBookCreaseType(HWND hWnd, short value);
FP_ERROR FAR PASCAL _export TabSetBookDoubleWireMargin(HWND hWnd, int value);
FP_ERROR FAR PASCAL _export TabSetBookGutter(HWND hWnd, int value);
FP_ERROR FAR PASCAL _export TabSetBookMarginH(HWND hWnd, int value);
FP_ERROR FAR PASCAL _export TabSetBookMarginV(HWND hWnd, int value);
FP_ERROR FAR PASCAL _export TabSetBookMetalSpineColor(HWND hWnd, COLORREF value);
FP_ERROR FAR PASCAL _export TabSetBookMetalSpineOutlineColor(HWND hWnd, COLORREF value);
FP_ERROR FAR PASCAL _export TabSetBookModeType(HWND hWnd, short value);
FP_ERROR FAR PASCAL _export TabSetBookRingArc(HWND hWnd, int value);
FP_ERROR FAR PASCAL _export TabSetBookRingColor(HWND hWnd, COLORREF value);
FP_ERROR FAR PASCAL _export TabSetBookRingColorLight(HWND hWnd, COLORREF value);
FP_ERROR FAR PASCAL _export TabSetBookRingColorOutline(HWND hWnd, COLORREF value);
FP_ERROR FAR PASCAL _export TabSetBookRingCount(HWND hWnd, int value);
FP_ERROR FAR PASCAL _export TabSetBookRingGroupCount(HWND hWnd, int value);
FP_ERROR FAR PASCAL _export TabSetBookRingLength(HWND hWnd, int value);
FP_ERROR FAR PASCAL _export TabSetBookRingMargin(HWND hWnd, int value);
FP_ERROR FAR PASCAL _export TabSetBookRingOutsideMargin(HWND hWnd, int value);
FP_ERROR FAR PASCAL _export TabSetBookRingShowHole(HWND hWnd, BOOL value);
FP_ERROR FAR PASCAL _export TabSetBookRingType(HWND hWnd, short value);
FP_ERROR FAR PASCAL _export TabSetBookRingWidth(HWND hWnd, int value);
FP_ERROR FAR PASCAL _export TabSetBookShadowColor(HWND hWnd, COLORREF value);
FP_ERROR FAR PASCAL _export TabSetBookShadowSize(HWND hWnd, int value);
FP_ERROR FAR PASCAL _export TabSetBookShowCornerGuard(HWND hWnd, BOOL value);
FP_ERROR FAR PASCAL _export TabSetBookShowMetalSpine(HWND hWnd, BOOL value);
FP_ERROR FAR PASCAL _export TabSetChamferedHeight(HWND hWnd, int value);
FP_ERROR FAR PASCAL _export TabSetChamferedWidth(HWND hWnd, int value);
FP_ERROR FAR PASCAL _export TabSetEarMarkColorDark(HWND hWnd, COLORREF value);
FP_ERROR FAR PASCAL _export TabSetEarMarkColorLight(HWND hWnd, COLORREF value);
FP_ERROR FAR PASCAL _export TabSetEarMarkColorOutline(HWND hWnd, COLORREF value);
FP_ERROR FAR PASCAL _export TabSetEarMarkHeight(HWND hWnd, int value);
FP_ERROR FAR PASCAL _export TabSetFlipText(HWND hWnd, BOOL value);
FP_ERROR FAR PASCAL _export TabSetForeColor(HWND hWnd, COLORREF value);
FP_ERROR FAR PASCAL _export TabSetFreezeRows(HWND hWnd, BOOL value);
FP_ERROR FAR PASCAL _export TabSetGrayAreaColor(HWND hWnd, COLORREF value);
FP_ERROR FAR PASCAL _export TabSetHighestPrecedence(HWND hWnd, short value);
FP_ERROR FAR PASCAL _export TabSetMarginLeft(HWND hWnd, int value);
FP_ERROR FAR PASCAL _export TabSetMarginRight(HWND hWnd, int value);
FP_ERROR FAR PASCAL _export TabSetMaxScrollRows(HWND hWnd, int value);
FP_ERROR FAR PASCAL _export TabSetMode(HWND hWnd, short value);
FP_ERROR FAR PASCAL _export TabSetOffsetFromClientTop(HWND hWnd, BOOL value);
FP_ERROR FAR PASCAL _export TabSetOrientation(HWND hWnd, short value);
FP_ERROR FAR PASCAL _export TabSetOutlineColor(HWND hWnd, COLORREF value);
FP_ERROR FAR PASCAL _export TabSetPage(HWND hWnd, int value);
FP_ERROR FAR PASCAL _export TabSetPageColor(HWND hWnd, COLORREF value);
FP_ERROR FAR PASCAL _export TabSetPageEarMarkAlignNext(HWND hWnd, short value);
FP_ERROR FAR PASCAL _export TabSetPageEarMarkAlignPrev(HWND hWnd, short value);
FP_ERROR FAR PASCAL _export TabSetPageEarMarkColorDark(HWND hWnd, COLORREF value);
FP_ERROR FAR PASCAL _export TabSetPageEarMarkColorLight(HWND hWnd, COLORREF value);
FP_ERROR FAR PASCAL _export TabSetPageEarMarkColorOutline(HWND hWnd, COLORREF value);
FP_ERROR FAR PASCAL _export TabSetPageEarMarkHeight(HWND hWnd, int value);
FP_ERROR FAR PASCAL _export TabSetPageEarMarkType(HWND hWnd, short value);
FP_ERROR FAR PASCAL _export TabSetPageFlipEffect(HWND hWnd, short value);
FP_ERROR FAR PASCAL _export TabSetPageFlipSpeed(HWND hWnd, int value);
FP_ERROR FAR PASCAL _export TabSetPageMax(HWND hWnd, int value);
FP_ERROR FAR PASCAL _export TabSetRotateText90(HWND hWnd, BOOL value);
FP_ERROR FAR PASCAL _export TabSetShowEarMark(HWND hWnd, BOOL value);
FP_ERROR FAR PASCAL _export TabSetShowFocusRect(HWND hWnd, BOOL value);
FP_ERROR FAR PASCAL _export TabSetTab(HWND hWnd, int value);
FP_ERROR FAR PASCAL _export TabSetTabCaption(HWND hWnd, LPCSTR value);
FP_ERROR FAR PASCAL _export TabSetTabCount(HWND hWnd, int value);
FP_ERROR FAR PASCAL _export TabSetTabDest(HWND hWnd, int value);
FP_ERROR FAR PASCAL _export TabSetTabHeight(HWND hWnd, int value);
FP_ERROR FAR PASCAL _export TabSetTabID(HWND hWnd, long value);
FP_ERROR FAR PASCAL _export TabSetTabLeft(HWND hWnd, int value);
FP_ERROR FAR PASCAL _export TabSetTabMaxWidth(HWND hWnd, int value);
FP_ERROR FAR PASCAL _export TabSetTabPicture(HWND hWnd, HANDLE value);
FP_ERROR FAR PASCAL _export TabSetTabRowOffset(HWND hWnd, int value);
FP_ERROR FAR PASCAL _export TabSetTabSeparator(HWND hWnd, int value);
FP_ERROR FAR PASCAL _export TabSetTabShape(HWND hWnd, short value);
FP_ERROR FAR PASCAL _export TabSetTabState(HWND hWnd, short value);
FP_ERROR FAR PASCAL _export TabSetTabsPerRow(HWND hWnd, int value);
FP_ERROR FAR PASCAL _export TabSetThreeD(HWND hWnd, BOOL value);
FP_ERROR FAR PASCAL _export TabSetThreeDHighlightColor(HWND hWnd, COLORREF value);
FP_ERROR FAR PASCAL _export TabSetThreeDShadowColor(HWND hWnd, COLORREF value);
FP_ERROR FAR PASCAL _export TabSetThreeDText(HWND hWnd, short value);
FP_ERROR FAR PASCAL _export TabSetThreeDTextHighlightColor(HWND hWnd, COLORREF value);
FP_ERROR FAR PASCAL _export TabSetThreeDTextOffset(HWND hWnd, int value);
FP_ERROR FAR PASCAL _export TabSetThreeDTextShadowColor(HWND hWnd, COLORREF value);
FP_ERROR FAR PASCAL _export TabSetWordWrap(HWND hWnd, BOOL value);

/*******************
* Message crackers
*******************/

/* void OnClientClick(HWND hWnd, HWND hTab, short x, short y) */
#define HANDLE_TABM_CLIENTCLICK(hWnd, wParam, lParam, fn) \
  ((fn)((hWnd), (HWND)(wParam), (short)LOWORD(lParam), (short)HIWORD(lParam)), 0)
#define FORWARD_TABM_CLIENTCLICK(hWnd, hTab, x, y, fn) \
  (void)(fn)((hWnd), TABM_CLIENTCLICK, (WPARAM)(hTab), MAKELPARAM((x),(y)))

/* BOOL OnTabActivate (HWND hWnd, HWND hTab, short nTab, short nPage) */
#define HANDLE_TABM_TABACTIVATE(hWnd, wParam, lParam, fn) \
  (LRESULT)(fn)((hWnd), (HWND)(wParam), (short)LOWORD(lParam), (short)HIWORD(lParam))
#define FORWARD_TABM_TABACTIVATE(hWnd, hTab, nTab, nPage, fn) \
  (BOOL)(fn)((hWnd), TABM_TABACTIVATE, (WPARAM)(hTab), MAKELPARAM((nTab),(nPage)))

/* BOOL OnTabPreview(HWND hWnd, HWND hTab, short nTab, WORD wAction) */
#define HANDLE_TABM_TABPREVIEW(hWnd, wParam, lParam, fn) \
  (LRESULT)(fn)((hWnd), (HWND)(wParam), (short)LOWORD(lParam), (WORD)HIWORD(lParam))
#define FORWARD_TABM_TABPREVIEW(hWnd, hTab, nTab, wAction, fn) \
  (BOOL)(fn)((hWnd), TABM_TABPREVIEW, (WPARAM)(hTab), MAKELPARAM((nTab),(wAction)))

/* void OnTabScroll(HWND hWnd, HWND hTab, LPTABSCROLL lpTabScroll) */
#define HANDLE_TABM_TABSCROLL(hWnd, wParam, lParam, fn) \
  ((fn)((hWnd), (HWND)(wParam), (LPTABSCROLL)(lParam)), 0)
#define FORWARD_TABM_TABSCROLL(hWnd, hTab, lpTabScroll, fn) \
  (void)(fn)((hWnd), TABM_TABSCROLL, (WPARAM)(hTab), (LPARAM)(lpTabScroll))

/* BOOL OnTabShown (HWND hWnd, HWND hTab, short nTab) */
#define HANDLE_TABM_TABSHOWN(hWnd, wParam, lParam, fn) \
  ((fn)((hWnd), (HWND)(wParam), (short)(lParam)), 0)
#define FORWARD_TABM_TABSHOWN(hWnd, hTab, nTab, fn) \
  (void)(fn)((hWnd), TABM_TABSHOWN, (WPARAM)(hTab), (LPARAM)(nTab))

/* void OnUserError(HWND hWnd, HWND hTab, WORD wUserError, short nClickedOnTab) */
#define HANDLE_TABM_USERERROR(hWnd, wParam, lParam, fn) \
  ((fn)((hWnd), (HWND)(wParam), (WORD)LOWORD(lParam), (short)HIWORD(lParam)), 0)
#define FORWARD_TABM_USERERROR(hWnd, hTab, wUserError, nClickedOnTab, fn) \
  (void)(fn)((hWnd), TABM_USERERROR, (WPARAM)(hTab), MAKELPARAM((wUserError), (nClickedOnTab)))


/*******************************************************************
*                        Imprint Control
*******************************************************************/

#define FPCLASS_IMPRINT                   "fpImprintPro11"

/***********
* Messages
***********/

#define IMPM_SETPROPERTY                  (WM_USER + 51)
#define IMPM_GETPROPERTY                  (WM_USER + 52)

/*********
* Styles
*********/

#define IMPS_RAISED                         0x0001L
#define IMPS_LOWERED                        0x0002L
#define IMPS_GROUPBOX                       0x0004L
#define IMPS_FRAME_RAISED                   0x0008L
#define IMPS_FRAME_LOWERED                  0x0010L
#define IMPS_FRAME_GROUPBOX                 0x0020L
#define IMPS_INSIDEBORDER                   0x0040L
#define IMPS_OUTSIDEBORDER                  0x0080L
#define IMPS_TEXTCENTER                     0x0100L
#define IMPS_TEXTRIGHT                      0x0200L
#define IMPS_TEXTVCENTER                    0x0400L
#define IMPS_TEXTBOTTOM                     0x0800L
#define IMPS_ROTATE90                       0x1000L
#define IMPS_ROTATE180                      0x2000L
#define IMPS_ROTATE270                      0x3000L
#define IMPS_TEXTBORDER                     0x4000L
#define IMPS_NOPREFIX                       0x8000L

/******************
* Extended Styles
******************/

#define IMPSX_BORDERTEXTCENTER              0x0100L
#define IMPSX_BORDERTEXTRIGHT               0x0200L
#define IMPSX_BORDERORIENTRIGHT             0x0400L
#define IMPSX_BORDERORIENTBOTTOM            0x0800L
#define IMPSX_BORDERORIENTLEFT              0x1000L
#define IMPSX_BORDERTEXTFLIP                0x2000L

/******************
* Property values
******************/

#define IMPPROP_AlignTextH                0
#define IMPPROP_AlignTextV                1
#define IMPPROP_BackColor                 2
#define IMPPROP_BorderAlignTextH          3
#define IMPPROP_BorderText                4
#define IMPPROP_BorderTextOrientation     5
#define IMPPROP_BorderTextFlip            6
#define IMPPROP_ForeColor                 7
#define IMPPROP_FrameColor                8
#define IMPPROP_FrameThreeDHighlightColor 9
#define IMPPROP_FrameThreeDShadowColor    10
#define IMPPROP_FrameThreeDStyle          11
#define IMPPROP_FrameThreeDWidth          12
#define IMPPROP_FrameWidth                13
#define IMPPROP_LineHCount                14
#define IMPPROP_LineHWidth                15
#define IMPPROP_LineVCount                16
#define IMPPROP_LineVWidth                17
#define IMPPROP_NoPrefix                  18
#define IMPPROP_OutlineInside             19
#define IMPPROP_OutlineInsideColor        20
#define IMPPROP_OutlineOutside            21
#define IMPPROP_OutlineOutsideColor       22
#define IMPPROP_TextRotation              23
#define IMPPROP_ThreeDHighlightColor      24
#define IMPPROP_ThreeDShadowColor         25
#define IMPPROP_ThreeDStyle               26
#define IMPPROP_ThreeDText                27
#define IMPPROP_ThreeDTextHighlightColor  28
#define IMPPROP_ThreeDTextOffset          29
#define IMPPROP_ThreeDTextShadowColor     30
#define IMPPROP_ThreeDWidth               31
#define IMPPROP_BorderTextLength          32
#define IMPPROP_Caption                   33
#define IMPPROP_CaptionLength             34
#define IMPPROP_AutoSize                  35
#define IMPPROP_AutoSizeOffsetLeft        36
#define IMPPROP_AutoSizeOffsetRight       37
#define IMPPROP_AutoSizeOffsetTop         38
#define IMPPROP_AutoSizeOffsetBottom      39

/************
* Constants
************/

#define IMP_ALIGNTEXT_H_LEFT              0
#define IMP_ALIGNTEXT_H_CENTER            1
#define IMP_ALIGNTEXT_H_RIGHT             2

#define IMP_ALIGNTEXT_V_TOP               0
#define IMP_ALIGNTEXT_V_CENTER            1
#define IMP_ALIGNTEXT_V_BOTTOM            2

#define IMP_BORDERTEXTORIENT_TOP          0
#define IMP_BORDERTEXTORIENT_RIGHT        1
#define IMP_BORDERTEXTORIENT_BOTTOM       2
#define IMP_BORDERTEXTORIENT_LEFT         3

#define IMP_FRAMETHREEDSTYLE_NONE         0
#define IMP_FRAMETHREEDSTYLE_LOWERED      1
#define IMP_FRAMETHREEDSTYLE_RAISED       2
#define IMP_FRAMETHREEDSTYLE_GBLOWERED    3
#define IMP_FRAMETHREEDSTYLE_GBRAISED     4

#define IMP_TEXTROTATION_0                0
#define IMP_TEXTROTATION_90               1
#define IMP_TEXTROTATION_180              2
#define IMP_TEXTROTATION_270              3

#define IMP_THREEDTEXT_NONE               0
#define IMP_THREEDTEXT_RAISED_LIGHT       1
#define IMP_THREEDTEXT_LOWERED_LIGHT      2
#define IMP_THREEDTEXT_RAISED_HEAVY       3
#define IMP_THREEDTEXT_LOWERED_HEAVY      4

#define IMP_AUTOSIZE_NONE                 0
#define IMP_AUTOSIZE_TOP                  1
#define IMP_AUTOSIZE_BOTTOM               2
#define IMP_AUTOSIZE_LEFT                 3
#define IMP_AUTOSIZE_RIGHT                4
#define IMP_AUTOSIZE_FILL                 5

short FAR PASCAL _export ImpGetAlignTextH(HWND hWnd);
short FAR PASCAL _export ImpGetAlignTextV(HWND hWnd);
short FAR PASCAL _export ImpGetAutoSize(HWND hWnd);
int FAR PASCAL _export ImpGetAutoSizeOffsetBottom(HWND hWnd);
int FAR PASCAL _export ImpGetAutoSizeOffsetLeft(HWND hWnd);
int FAR PASCAL _export ImpGetAutoSizeOffsetRight(HWND hWnd);
int FAR PASCAL _export ImpGetAutoSizeOffsetTop(HWND hWnd);
COLORREF FAR PASCAL _export ImpGetBackColor(HWND hWnd);
short FAR PASCAL _export ImpGetBorderAlignTextH(HWND hWnd);
void FAR PASCAL _export ImpGetBorderText(HWND hWnd, LPSTR value);
short FAR PASCAL _export ImpGetBorderTextLength(HWND hWnd);
BOOL FAR PASCAL _export ImpGetBorderTextFlip(HWND hWnd);
short FAR PASCAL _export ImpGetBorderTextOrientation(HWND hWnd);
void FAR PASCAL _export ImpGetCaption(HWND hWnd, LPSTR value);
short FAR PASCAL _export ImpGetCaptionLength(HWND hWnd);
COLORREF FAR PASCAL _export ImpGetForeColor(HWND hWnd);
COLORREF FAR PASCAL _export ImpGetFrameColor(HWND hWnd);
COLORREF FAR PASCAL _export ImpGetFrameThreeDHighlightColor(HWND hWnd);
COLORREF FAR PASCAL _export ImpGetFrameThreeDShadowColor(HWND hWnd);
short FAR PASCAL _export ImpGetFrameThreeDStyle(HWND hWnd);
int FAR PASCAL _export ImpGetFrameThreeDWidth(HWND hWnd);
int FAR PASCAL _export ImpGetFrameWidth(HWND hWnd);
int FAR PASCAL _export ImpGetLineHCount(HWND hWnd);
int FAR PASCAL _export ImpGetLineHWidth(HWND hWnd);
int FAR PASCAL _export ImpGetLineVCount(HWND hWnd);
int FAR PASCAL _export ImpGetLineVWidth(HWND hWnd);
BOOL FAR PASCAL _export ImpGetNoPrefix(HWND hWnd);
BOOL FAR PASCAL _export ImpGetOutlineInside(HWND hWnd);
COLORREF FAR PASCAL _export ImpGetOutlineInsideColor(HWND hWnd);
BOOL FAR PASCAL _export ImpGetOutlineOutside(HWND hWnd);
COLORREF FAR PASCAL _export ImpGetOutlineOutsideColor(HWND hWnd);
short FAR PASCAL _export ImpGetTextRotation(HWND hWnd);
COLORREF FAR PASCAL _export ImpGetThreeDHighlightColor(HWND hWnd);
COLORREF FAR PASCAL _export ImpGetThreeDShadowColor(HWND hWnd);
short FAR PASCAL _export ImpGetThreeDStyle(HWND hWnd);
short FAR PASCAL _export ImpGetThreeDText(HWND hWnd);
COLORREF FAR PASCAL _export ImpGetThreeDTextHighlightColor(HWND hWnd);
int FAR PASCAL _export ImpGetThreeDTextOffset(HWND hWnd);
COLORREF FAR PASCAL _export ImpGetThreeDTextShadowColor(HWND hWnd);
int FAR PASCAL _export ImpGetThreeDWidth(HWND hWnd);

FP_ERROR FAR PASCAL _export ImpSetAlignTextH(HWND hWnd, short value);
FP_ERROR FAR PASCAL _export ImpSetAlignTextV(HWND hWnd, short value);
FP_ERROR FAR PASCAL _export ImpSetAutoSize(HWND hWnd, short value);
FP_ERROR FAR PASCAL _export ImpSetAutoSizeOffsetBottom(HWND hWnd, int value);
FP_ERROR FAR PASCAL _export ImpSetAutoSizeOffsetLeft(HWND hWnd, int value);
FP_ERROR FAR PASCAL _export ImpSetAutoSizeOffsetRight(HWND hWnd, int value);
FP_ERROR FAR PASCAL _export ImpSetAutoSizeOffsetTop(HWND hWnd, int value);
FP_ERROR FAR PASCAL _export ImpSetBackColor(HWND hWnd, COLORREF value);
FP_ERROR FAR PASCAL _export ImpSetBorderAlignTextH(HWND hWnd, short value);
FP_ERROR FAR PASCAL _export ImpSetBorderText(HWND hWnd, LPCSTR value);
FP_ERROR FAR PASCAL _export ImpSetBorderTextFlip(HWND hWnd, BOOL value);
FP_ERROR FAR PASCAL _export ImpSetBorderTextOrientation(HWND hWnd, short value);
FP_ERROR FAR PASCAL _export ImpSetCaption(HWND hWnd, LPCSTR value);
FP_ERROR FAR PASCAL _export ImpSetForeColor(HWND hWnd, COLORREF value);
FP_ERROR FAR PASCAL _export ImpSetFrameColor(HWND hWnd, COLORREF value);
FP_ERROR FAR PASCAL _export ImpSetFrameThreeDHighlightColor(HWND hWnd, COLORREF value);
FP_ERROR FAR PASCAL _export ImpSetFrameThreeDShadowColor(HWND hWnd, COLORREF value);
FP_ERROR FAR PASCAL _export ImpSetFrameThreeDStyle(HWND hWnd, short value);
FP_ERROR FAR PASCAL _export ImpSetFrameThreeDWidth(HWND hWnd, int value);
FP_ERROR FAR PASCAL _export ImpSetFrameWidth(HWND hWnd, int value);
FP_ERROR FAR PASCAL _export ImpSetLineHCount(HWND hWnd, int value);
FP_ERROR FAR PASCAL _export ImpSetLineHWidth(HWND hWnd, int value);
FP_ERROR FAR PASCAL _export ImpSetLineVCount(HWND hWnd, int value);
FP_ERROR FAR PASCAL _export ImpSetLineVWidth(HWND hWnd, int value);
FP_ERROR FAR PASCAL _export ImpSetNoPrefix(HWND hWnd, BOOL value);
FP_ERROR FAR PASCAL _export ImpSetOutlineInside(HWND hWnd, BOOL value);
FP_ERROR FAR PASCAL _export ImpSetOutlineInsideColor(HWND hWnd, COLORREF value);
FP_ERROR FAR PASCAL _export ImpSetOutlineOutside(HWND hWnd, BOOL value);
FP_ERROR FAR PASCAL _export ImpSetOutlineOutsideColor(HWND hWnd, COLORREF value);
FP_ERROR FAR PASCAL _export ImpSetTextRotation(HWND hWnd, short value);
FP_ERROR FAR PASCAL _export ImpSetThreeDHighlightColor(HWND hWnd, COLORREF value);
FP_ERROR FAR PASCAL _export ImpSetThreeDShadowColor(HWND hWnd, COLORREF value);
FP_ERROR FAR PASCAL _export ImpSetThreeDStyle(HWND hWnd, short value);
FP_ERROR FAR PASCAL _export ImpSetThreeDText(HWND hWnd, short value);
FP_ERROR FAR PASCAL _export ImpSetThreeDTextHighlightColor(HWND hWnd, COLORREF value);
FP_ERROR FAR PASCAL _export ImpSetThreeDTextOffset(HWND hWnd, int value);
FP_ERROR FAR PASCAL _export ImpSetThreeDTextShadowColor(HWND hWnd, COLORREF value);
FP_ERROR FAR PASCAL _export ImpSetThreeDWidth(HWND hWnd, int value);

#ifdef __cplusplus
}
#endif

#endif // FPTAB_H
