
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/TRCWIN.CPP   1.7   11 Jun 1996 10:23:58   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/TRCWIN.CPP  $
** 
**    Rev 1.7   11 Jun 1996 10:23:58   ZJRD
** EasyPack/SLD Version 1.97
** 
**    Rev 1.5   05 Jun 1996 14:51:42   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:33:08   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:05:14   ZJRD
** EasyPack/SLD Version 1.94
** 
**    Rev 1.2   10 May 1996 09:14:06   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:28:56   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 12:58:02   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:41:42   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:56:44   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:08:02   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:34:30   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:48:50   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:14:50   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:18:14   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:18:08   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:35:44   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:29:02   Shirley
** EasypPack/SLD Version 0.34c
** 
**    Rev 1.18   15 Jan 1996 16:10:46   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:10:02   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:13:26   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:33:24   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:20:40   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:27:04   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:31:38   Shirley
** EasyPack/SLD Version 0.24
** 
**    Rev 1.11   08 Nov 1995 16:33:44   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:43:26   Shirley
** EasyPack/SLD Version 0.22
** 
**    Rev 1.7   27 Oct 1995 13:48:58   Shirley
** EasyPack/SLD Version 0.1g
** 
**    Rev 1.4   13 Oct 1995 13:21:36   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:53:28   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:58:14   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:46:08   Shirley
** EasyPack/SLDV0.1a 
** 
**    Rev 1.0   07 Sep 1995 09:54:02   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  TRCWIN.CPP
//
//  Description:The implement file for the class: CTraceWindow
//
//  Author:     Chris Fang
//
//  Date:       09/10/95
//
//  Modification:
//
//      1. 09/10/95, Initial version
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "resource.h"

#include "uicom.h"
#include "trcserve.h"
#include "ctrcbuf.h"
#include "trcview.h"
#include "trcwin.h"
#include "spin.h"
#include "myedit.h"
#include "trcgtdlg.h"
#include "trcschdg.h"
#include "lanecom.h"
#include "string.h"     
#include "trcgrpdi.h"
#include "trcfidlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif
  
//////////////////////////////////////////////////////////////////////////////
//
void TrcOpenWindow(CMDIFrameWnd * pParent)
{                                         
	if(nTraceViewOption==0)						//init
		nTraceViewOption = TRACEMODE_BUS;
    if(isTraceOn)    return;
    pTraceWnd = new CTraceWindow;
    if(!((CTraceWindow *)pTraceWnd)->Create("Trace",
        WS_CHILD|WS_VISIBLE|WS_OVERLAPPEDWINDOW,
        CFrameWnd::rectDefault, pParent))
        ASSERT(0);                

    isTraceOn = TRUE;
}

//////////////////////////////////////////////
CMenu NEAR CTraceWindow::m_menu;                              

/////////////////////////////////////////////////////////////////////////////
// CTraceWindow

IMPLEMENT_DYNCREATE(CTraceWindow, CMDIChildWnd)

CTraceWindow::CTraceWindow()
{                                                 
	m_nIDHelp = IDR_TRACE;
	m_wTitleHeight=20;
 	m_bSizeCursor=FALSE;		
 	m_bLBtnPress=FALSE;

}

CTraceWindow::~CTraceWindow()
{
    isTraceOn = FALSE;
}                     

BOOL CTraceWindow::Create(LPCSTR szTitle, LONG style,
    const RECT& rect, CMDIFrameWnd * pParent)
{
    // Setup the shared m_menu
    if(m_menu.m_hMenu == NULL)
        m_menu.LoadMenu(IDR_TRACE);
    m_hMenuShared = m_menu.m_hMenu;

    const char * pszTraceClass =
        AfxRegisterWndClass(CS_HREDRAW,
//            LoadCursor(NULL, IDC_ARROW),
			NULL,			//for easily change mouse cursor when recolumn
            (HBRUSH)(COLOR_WINDOW + 1),
            AfxGetApp()->LoadIcon(IDR_TRACE));
    return CMDIChildWnd::Create(pszTraceClass, szTitle,
        style, rect, pParent);
}

/////////////////////////////////////////////////////////////////////////////
//general usage routine

long CTraceWindow::SearchBus(int begin)
{
    WORD firstNo,lastNo,i;
    long count;
    char* find;
    WORD a;
    TRACE_BUSREC* ptrBuf;
    TRACE_BUSREC* buf = new TRACE_BUSREC[10];

    ASSERT(buf!=NULL);
    count = long(m_viewTrace.m_wCurFrame);
    count += begin;
    find = NULL;
    a = 10;
    while(count<long(m_viewTrace.m_wLastFrame))
    {
		if(TestKey(VK_ESCAPE))
        {
        	delete buf;
        	return (-count);
        }
        firstNo = WORD(count);
        lastNo = firstNo + 10;
        lastNo=min(m_viewTrace.m_wLastFrame, lastNo);
        a = 10;
        ListTrcDataToWnd(0, &firstNo, &lastNo, &a, (struct FrameData*)buf);
        count = firstNo;
        ptrBuf = buf;
        for(i=0;i<a;i++)
        {
            find = strstr(ptrBuf->frameNo, searchContent);
            if (find!=NULL)
                break;
            find = strstr(ptrBuf->addr, searchContent);
            if (find!=NULL)
                break;
            find = strstr(ptrBuf->data, searchContent);
            if (find!=NULL)
                break;
            find = strstr(ptrBuf->status, searchContent);
            if (find!=NULL)
                break;
            find = strstr(ptrBuf->spare, searchContent);
            if (find!=NULL)
                break;
            find = strstr(ptrBuf->portdata, searchContent);
            if (find!=NULL)
                break;
            count++;
            ptrBuf++;
        }
        if (find!=NULL) 
        {
        	count=ptrBuf->phisicalNo;
        	break;
        }
    }
    delete buf;
    if (find!=NULL) return (count);
    else return(-1);
}

long CTraceWindow::SearchIns(int begin)
{
    WORD firstNo,lastNo,i;                                 
    long count;
    char* find;
    WORD a;
    TRACE_INSTREC* ptrBuf;
    TRACE_INSTREC* buf = new TRACE_INSTREC[10];

    ASSERT(buf!=NULL);
    count = long(m_viewTrace.m_wCurFrame);
    count += begin;
    find = NULL;
    a = 10;
    while (count<long(m_viewTrace.m_wLastFrame))
    {
        if(TestKey(VK_ESCAPE))
        {
         	delete buf;
        	return (-count);
        }
        firstNo = WORD(count);
        lastNo = firstNo + 10;

        a = 10;
        ListTrcInstToWnd(0, &firstNo, &lastNo, &a, (struct FrameInst*)buf);
        ptrBuf = buf;
        for(i=0;i<a;i++)
        {
            find = strstr(ptrBuf->frameNo, searchContent);
            if (find!=NULL)
                break;
            find = strstr(ptrBuf->addr, searchContent);
            if (find!=NULL)
                break;
            find = strstr((char*)(ptrBuf->instruction), searchContent);
            if (find!=NULL)
                break;
            count++;
            ptrBuf++;
        }
        if (find!=NULL) 
        {
        	count=ptrBuf->phisicalNo;
        	break;
        }	
        count=lastNo+1;
    }                                  
    delete buf;
    if (find!=NULL)
		return (count);
    else return(-1);
}            

long CTraceWindow::SearchSrc(int begin)
{
    WORD firstNo,lastNo,i;
    long count;
    char* find;
    WORD a;
    TRACE_SOURCEREC* ptrBuf;
    TRACE_SOURCEREC* buf = new TRACE_SOURCEREC[10];
    
    ASSERT(buf!=NULL);
    count = long(m_viewTrace.m_wCurFrame);
    count += begin;
    find = NULL;
    a = 10;
    while (count<long(m_viewTrace.m_wLastFrame))
    {
        if(TestKey(VK_ESCAPE))
        {
        	delete buf;
        	return (-count);
        }
        firstNo = (WORD)count;                   
        lastNo = firstNo + 10;
        a = 10;
        ListTrcCToWnd(0, &firstNo, &lastNo, &a, (struct FrameC*)buf);
        ptrBuf = buf;
        for(i=0;i<a;i++)
        {      
            find = strstr(ptrBuf->frameNo, searchContent);
            if (find!=NULL)
                break;
            find = strstr(ptrBuf->line, searchContent);
            if (find!=NULL)
                break;
            find = strstr((char*)(ptrBuf->c), searchContent);
            if (find!=NULL)
                break;
            count++;
            ptrBuf++;
        }                        
        if (find!=NULL) 
        {
        	count=ptrBuf->phisicalNo;
        	break;
        }	
        count=lastNo+1;
    }
    delete buf;
    if (find!=NULL) 
		return (count);
    else return(-1);
}


void CTraceWindow::DrawStatic(LPCSTR lpszText, UINT nCount, RECT rect, CDC* pDc)
{
COLORREF oldColor;                           
SIZE 	size;                         
CPen	pen;
int 	addx = 2;
int 	addy;
                   
	pDc->SelectStockObject(ANSI_FIXED_FONT);      
    oldColor = pDc->SetBkColor(PALETTEINDEX(7));
    size = pDc->GetOutputTextExtent(lpszText, nCount);
    addy = (rect.bottom - rect.top - size.cy) / 2;
    pDc->ExtTextOut(rect.left+addx, rect.top+addy, 
        ETO_CLIPPED | ETO_OPAQUE, 
        &rect, 
        lpszText, 
        nCount, 
        NULL);
    pDc->SetBkColor(oldColor);
    pDc->SelectStockObject(WHITE_PEN);          
    pDc->MoveTo((rect.right-3),rect.top);
    pDc->LineTo((rect.left+1),rect.top);   		//white line
    pDc->LineTo((rect.left+1),(rect.bottom-1));
    pen.CreatePen(PS_SOLID,1,PALETTEINDEX(12));
    pDc->SelectObject(&pen);
    pDc->MoveTo((rect.right-2),rect.top);
    pDc->LineTo((rect.right-2),(rect.bottom-2));	//darkgrey line _|
    pDc->LineTo(rect.left,(rect.bottom-2));
    pDc->SelectStockObject(BLACK_PEN);    
    pDc->MoveTo((rect.right-1),rect.top);
    pDc->LineTo((rect.right-1),(rect.bottom-1));
    pDc->LineTo(rect.left-1,(rect.bottom-1));
}        

BEGIN_MESSAGE_MAP(CTraceWindow, CMDIChildWnd)
    //{{AFX_MSG_MAP(CTraceWindow)
	ON_WM_CREATE()
    ON_WM_SIZE()
    ON_WM_PAINT()
    ON_WM_RBUTTONDOWN()
    ON_COMMAND(ID_EDIT_SEARCH, OnEditSearch)
    ON_COMMAND(ID_EDIT_SEARCHNEXT, OnEditSearchnext)
    ON_COMMAND(ID_VIEW_BUS, OnViewBus)
    ON_UPDATE_COMMAND_UI(ID_VIEW_BUS, OnUpdateViewBus)
    ON_COMMAND(ID_VIEW_INSTRUCTION, OnViewInstruction)
    ON_UPDATE_COMMAND_UI(ID_VIEW_INSTRUCTION, OnUpdateViewInstruction)
    ON_COMMAND(ID_EDIT_GOTOFRAME, OnEditGotoframe)
    ON_COMMAND(ID_EDIT_GOTOSTARTFRAME, OnEditGotostartframe)
    ON_COMMAND(ID_EDIT_GOTOENDFRAME, OnEditGotoendframe)
    ON_COMMAND(ID_TRACE_CONTROL, OnTraceControl)
    ON_COMMAND(ID_TRACE_EVENT, OnTraceEvent)
    ON_COMMAND(ID_TRACE_FILTER, OnTraceFilter)
    ON_COMMAND(ID_TRACE_TRIGGER, OnTraceTrigger)
    ON_COMMAND(ID_FILE_SAVETRACE, OnFileSavetrace)
    ON_COMMAND(ID_VIEW_SOURCE, OnViewSource)
	ON_UPDATE_COMMAND_UI(ID_VIEW_SOURCE, OnUpdateViewSource)
	ON_COMMAND(ID_VIEW_REFRESH, OnViewRefresh)
	ON_WM_KEYDOWN()
	ON_COMMAND(ID_SHIFTRETURN, OnShiftreturn)
	ON_UPDATE_COMMAND_UI(ID_EDIT_SEARCHNEXT, OnUpdateEditSearchnext)
	ON_WM_MDIACTIVATE()
	ON_WM_SETCURSOR()
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONUP()
	ON_WM_LBUTTONDOWN()
	ON_COMMAND(ID_VIEW_MIXED, OnViewMixed)
	ON_UPDATE_COMMAND_UI(ID_VIEW_MIXED, OnUpdateViewMixed)
	//}}AFX_MSG_MAP
	ON_MESSAGE(XM_REPAINT,OnXMRepaint)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTraceWindow message handlers

int CTraceWindow::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CMDIChildWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// TODO: Add your specialized creation code here
	const char * pszTraceClass =
        AfxRegisterWndClass(CS_HREDRAW|CS_VREDRAW,
            LoadCursor(NULL, IDC_ARROW),
            (HBRUSH)(COLOR_WINDOW + 1),
            NULL);
    
    if (!(m_viewTrace.Create(pszTraceClass,NULL,
        WS_CHILD | WS_VISIBLE | WS_VSCROLL,
        CFrameWnd::rectDefault,
        this,1000,NULL)))
		ASSERT(0);
	m_nCxVscroll=GetSystemMetrics(SM_CXVSCROLL);
 	::SetCursor(::LoadCursor(NULL, IDC_ARROW));	
	return 0;
}

void CTraceWindow::OnMDIActivate(BOOL bActivate, CWnd* pActivateWnd, CWnd* pDeactivateWnd)
{
	CMDIChildWnd::OnMDIActivate(bActivate, pActivateWnd, pDeactivateWnd);
	
	// TODO: Add your message handler code here
    if(bActivate && pActivateWnd == this)
        GetMDIFrame()->SendMessage(XM_MDIACTIVE, WORD(bActivate), 
            LONG(WID_TRACE));
    else if(!bActivate && !pActivateWnd)
        GetMDIFrame()->SendMessage(XM_MDIACTIVE, WORD(bActivate)); 
}

void CTraceWindow::OnSize(UINT nType, int cx, int cy)
{
    CMDIChildWnd::OnSize(nType, cx, cy);
    
    // TODO: Add your message handler code here
    m_viewTrace.SetWindowPos(NULL, 0, m_wTitleHeight,
    	cx, cy-m_wTitleHeight, SWP_NOZORDER|SWP_SHOWWINDOW);
    cx-=m_nCxVscroll;
    if(cx<=0)
    	return;
    cy=max(int(cy-m_wTitleHeight), 0);
#ifdef 	_WIN31    
    m_viewTrace.ReSize(cx,cy);
#else    
    m_viewTrace.ReSize(cx+1,cy);	//in windows 3.1 and windows 95,
#endif 								//there are different output on screen.
    								
}

void CTraceWindow::OnPaint()
{
    CPaintDC dc(this); // device context for painting
    
    // TODO: Add your message handler code here
RECT rect;     
	switch (nTraceViewOption)
	{
     case TRACEMODE_BUS:
        rect.left = m_viewTrace.m_nLeftfrom;
        rect.top = 0;
        rect.right = rect.left + m_viewTrace.m_nCol1len;
        rect.bottom = m_wTitleHeight;
        DrawStatic("Frame", 5, rect, &dc);
    
        rect.left = rect.right;
        rect.right = rect.left + m_viewTrace.m_nCol2len;
        DrawStatic("Address", 7, rect, &dc);

        rect.left = rect.right;
        rect.right = rect.left + m_viewTrace.m_nCol3len;
        DrawStatic("Data", 4, rect, &dc);

        rect.left = rect.right;
        rect.right = rect.left + m_viewTrace.m_nCol4len;
        DrawStatic("Status", 6, rect, &dc);

        rect.left = rect.right;
        rect.right = rect.left + m_viewTrace.m_nCol5len;
        DrawStatic("Spare[4-0]", 10, rect, &dc);

        rect.left = rect.right;
        rect.right = rect.left + m_viewTrace.m_nCol6len;
        DrawStatic("Port", 4, rect, &dc);

        
        
        GetClientRect(&rect);
		rect.left = rect.right - m_nCxVscroll+1;
		rect.top=0;
		rect.bottom = m_wTitleHeight;
        DrawStatic("", 0, rect, &dc);
        return;
    
     case TRACEMODE_INSTRUCTION:    
        rect.left = m_viewTrace.m_nLeftfrom;
        rect.top = 0;
        rect.right = rect.left + m_viewTrace.m_nCol1len;
        rect.bottom = m_wTitleHeight;
        DrawStatic("Frame", 5, rect, &dc);
    
        rect.left = rect.right;
        rect.right = rect.left + m_viewTrace.m_nCol2len;
        DrawStatic("Address", 7, rect, &dc);

        rect.left = rect.right;
        rect.right = rect.left + m_viewTrace.m_nCol3len;
        DrawStatic("Instruction", 11, rect, &dc);

        GetClientRect(&rect);
		rect.left = rect.right - m_nCxVscroll+1;
		rect.top=0;
		rect.bottom = m_wTitleHeight;
        DrawStatic("", 0, rect, &dc);
        return;

     case TRACEMODE_SOURCE:
        rect.left = m_viewTrace.m_nLeftfrom;
        rect.top = 0;
        rect.right = rect.left + m_viewTrace.m_nCol1len;
        rect.bottom = m_wTitleHeight;
        DrawStatic("Frame", 5, rect, &dc);
    
        rect.left = rect.right;
        rect.right = rect.left + m_viewTrace.m_nCol2len;
        DrawStatic("Line", 4, rect, &dc);

        rect.left = rect.right;
        rect.right = rect.left + m_viewTrace.m_nCol3len;
        DrawStatic("Source", 6, rect, &dc);

        GetClientRect(&rect);
		rect.left = rect.right - m_nCxVscroll+1;
		rect.top=0;
		rect.bottom = m_wTitleHeight;
        DrawStatic("", 0, rect, &dc);
        return;
     case TRACEMODE_MIXED:
        rect.left = m_viewTrace.m_nLeftfrom;
        rect.top = 0;
        rect.right = rect.left + m_viewTrace.m_nCol1len;
        rect.bottom = m_wTitleHeight;
        DrawStatic("Frame", 5, rect, &dc);
    
        rect.left = rect.right;
        rect.right = rect.left + m_viewTrace.m_nCol2len;
        DrawStatic("Line(M)", 7, rect, &dc);

        rect.left = rect.right;
        rect.right = rect.left + m_viewTrace.m_nCol3len;
        DrawStatic("Source", 6, rect, &dc);

        GetClientRect(&rect);
		rect.left = rect.right - m_nCxVscroll+1;
		rect.top=0;
		rect.bottom = m_wTitleHeight;
        DrawStatic("", 0, rect, &dc);
        return;
    }
    // Do not call CMDIChildWnd::OnPaint() for painting messages
}

BOOL CTraceWindow::OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message)
{
	// TODO: Add your message handler code here and/or call default
    if(message == WM_RBUTTONDOWN)   
        return FALSE;
	return CMDIChildWnd::OnSetCursor(pWnd, nHitTest, message);
}

void CTraceWindow::OnRButtonDown(UINT nFlags, CPoint point)
{
    // TODO: Add your message handler code here and/or call default
	if(m_bSizeCursor&&m_bLBtnPress)
		{
		 ReleaseCapture();
		 m_bLBtnPress=FALSE;
		 m_viewTrace.DrawColLine(m_nMousePointx);
		 return;
		} 

CMenu * pLocalMenu = new CMenu;
    if (!pLocalMenu)
        return;

    pLocalMenu->CreatePopupMenu();
	pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_REFRESH, "&Refresh");
	pLocalMenu->AppendMenu(MF_SEPARATOR);
    pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_BUS, "&Bus");
    pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_INSTRUCTION,
                            "&Instruction");
    pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_SOURCE,
                            "S&ource");
    pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_MIXED,
                            "&Mixed");
    pLocalMenu->AppendMenu(MF_SEPARATOR);
    pLocalMenu->AppendMenu(MF_STRING, ID_EDIT_GOTOSTARTFRAME,
                          	"Goto &Start Frame");
    pLocalMenu->AppendMenu(MF_STRING, ID_EDIT_GOTOENDFRAME, "Goto &End Frame");
    pLocalMenu->AppendMenu(MF_STRING, ID_EDIT_GOTOFRAME, "&Goto Frame...");
    pLocalMenu->AppendMenu(MF_SEPARATOR);
    pLocalMenu->AppendMenu(MF_STRING, ID_FILE_SAVETRACE, "S&ave Trace...");
    pLocalMenu->AppendMenu(MF_SEPARATOR);
    pLocalMenu->AppendMenu(MF_STRING, ID_TRACE_CONTROL, "Trace &Control...");
    pLocalMenu->AppendMenu(MF_STRING, ID_TRACE_EVENT, "E&vent...");
    pLocalMenu->AppendMenu(MF_STRING, ID_TRACE_TRIGGER, "&Trigger...");
    pLocalMenu->AppendMenu(MF_STRING, ID_TRACE_FILTER, "Trace &Filter...");

    ClientToScreen(&point);
    pLocalMenu->TrackPopupMenu(TPM_LEFTALIGN, point.x, point.y, this);
    delete pLocalMenu;
    
    CMDIChildWnd::OnRButtonDown(nFlags, point);
}

/****************************************************************************
**
**  Name: CTraceWindow::OnEditSearch
**
**  Description: TraceServer should offer routine.
**
**  Parameters:
**     input:
**
**     output:
**
**  Return data --
**
****************************************************************************/
void CTraceWindow::OnEditSearch()
{
    // TODO: Add your command handler code here
    long result;
    CTrcSchDg dlg(this);

    result = dlg.DoModal();
    if (result!=1) return;

	BeginWaitCursor();
	
    switch (nTraceViewOption)
    {
        case TRACEMODE_INSTRUCTION:
            result = SearchIns(0);
            EndWaitCursor();
            if (result<-1)
            {
                char info[50];
                sprintf(info, "Break by User at frame 0x%lX !", -result);
                MessageBox(info,"Search",MB_OK|MB_ICONHAND|MB_ICONSTOP);
                break;
            }
            if (result==-1) 
            {
                MessageBox("String Not Found!","Search",MB_OK|MB_ICONHAND|MB_ICONSTOP);
                break;
            }
            m_viewTrace.SendMessage(WM_VSCROLL, SB_THUMBPOSITION, LPARAM(result));
            break;
        case TRACEMODE_BUS:
            result = SearchBus(0);
            EndWaitCursor();
            if (result<-1)
            {
                char info[50];
                sprintf(info, "Break by User at frame 0x%lX !", -result);
                MessageBox(info,"Search",MB_OK|MB_ICONHAND|MB_ICONSTOP);
                break;
            }
            if (result==-1) 
            {
                MessageBox("String Not Found!","Search",MB_OK|MB_ICONHAND|MB_ICONSTOP);
                break;
            }
            m_viewTrace.SendMessage(WM_VSCROLL, SB_THUMBPOSITION, LPARAM(result));
            break;
        case TRACEMODE_SOURCE:
            result = SearchSrc(0);
			EndWaitCursor();
			if (result<-1)
            {
                char info[50];
                sprintf(info, "Break by User at frame 0x%lX !", -result);
                MessageBox(info,"Search",MB_OK|MB_ICONHAND|MB_ICONSTOP);
                break;
            }
            if (result==-1) 
            {
                MessageBox("String Not Found!","Search",MB_OK|MB_ICONHAND|MB_ICONSTOP);
                break;
            }
            m_viewTrace.SendMessage(WM_VSCROLL, SB_THUMBPOSITION, LPARAM(result));
            break;
        default:
            break;
    }   
}

/****************************************************************************
**
**  Name: CTraceWindow::OnEditSearchnext
**
**  Description: TraceServer should offer routine.
**
**  Parameters:
**     input:
**
**     output:
**
**  Return data --
**
****************************************************************************/
void CTraceWindow::OnEditSearchnext()
{
    // TODO: Add your command handler code here
    long result;

	BeginWaitCursor();

    switch (nTraceViewOption)
    {
        case TRACEMODE_BUS:
            result = SearchBus(1);
            EndWaitCursor();
            
            if (result<-1)
            {
                char info[50];
                sprintf(info, "Break by User at frame 0x%lX !", -result);
                MessageBox(info,"Search",MB_OK|MB_ICONHAND|MB_ICONSTOP);
                break;
            }
            if (result==-1) 
            {
                MessageBox("String Not Found!","Search",MB_OK|MB_ICONHAND|MB_ICONSTOP);
                break;
            }
            m_viewTrace.SendMessage(WM_VSCROLL, SB_THUMBPOSITION, LPARAM(result));
            break;
        case TRACEMODE_INSTRUCTION:
            result = SearchIns(1);
            EndWaitCursor();
            if (result<-1)
            {
                char info[50];
                sprintf(info, "Break by User at frame 0x%lX !", -result);
                MessageBox(info,"Search",MB_OK|MB_ICONHAND|MB_ICONSTOP);
                break;
            }
            if (result==-1) 
            {
                MessageBox("String Not Found!","Search",MB_OK|MB_ICONHAND|MB_ICONSTOP);
                break;
            }
            m_viewTrace.SendMessage(WM_VSCROLL, SB_THUMBPOSITION, LPARAM(result));
            break;
        case TRACEMODE_SOURCE:
            result = SearchSrc(1);
            EndWaitCursor();
            if (result<-1)
            {
                char info[50];
                sprintf(info, "Break by User at frame 0x%lX !", -result);
                MessageBox(info,"Search",MB_OK|MB_ICONHAND|MB_ICONSTOP);
                break;
            }
            if (result==-1) 
            {
                MessageBox("String Not Found!","Search",MB_OK|MB_ICONHAND|MB_ICONSTOP);
                break;
            }
            m_viewTrace.SendMessage(WM_VSCROLL, SB_THUMBPOSITION, LPARAM(result));
            break;
        default:
            break;
    }   
    
}

void CTraceWindow::OnUpdateEditSearchnext(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
	pCmdUI->Enable(searchContent[0]!= '\0');
}

void CTraceWindow::OnViewBus()
{
    // TODO: Add your command handler code here
    if (nTraceViewOption==TRACEMODE_BUS) return;
    m_viewTrace.OnModechange(TRACEMODE_BUS);
	InvalidateRect(NULL, TRUE);
}

void CTraceWindow::OnUpdateViewBus(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    pCmdUI->Enable(TRUE);
    if (nTraceViewOption==TRACEMODE_BUS)
        pCmdUI->SetCheck(1);
    else
        pCmdUI->SetCheck(0);
}

void CTraceWindow::OnViewInstruction()
{
    // TODO: Add your command handler code here  
    if (nTraceViewOption==TRACEMODE_INSTRUCTION) return;
    m_viewTrace.OnModechange(TRACEMODE_INSTRUCTION);
	InvalidateRect(NULL, TRUE);
}

void CTraceWindow::OnUpdateViewInstruction(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    pCmdUI->Enable(TRUE);
    if (nTraceViewOption==TRACEMODE_INSTRUCTION)
        pCmdUI->SetCheck(1);
    else
        pCmdUI->SetCheck(0);
}

void CTraceWindow::OnViewSource()
{
    // TODO: Add your command handler code here
    if (nTraceViewOption==TRACEMODE_SOURCE) return;
    m_viewTrace.OnModechange(TRACEMODE_SOURCE);
	InvalidateRect(NULL, TRUE);
}

void CTraceWindow::OnUpdateViewSource(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    pCmdUI->Enable(TRUE);
    if (nTraceViewOption==TRACEMODE_SOURCE)
        pCmdUI->SetCheck(1);
    else
        pCmdUI->SetCheck(0);
}
       
void CTraceWindow::OnViewMixed()
{
	// TODO: Add your command handler code here
    if (nTraceViewOption==TRACEMODE_MIXED) return;
    m_viewTrace.OnModechange(TRACEMODE_MIXED);
	InvalidateRect(NULL, TRUE);
}

void CTraceWindow::OnUpdateViewMixed(CCmdUI* pCmdUI)
{
	// TODO: Add your command update UI handler code here
    pCmdUI->Enable(TRUE);
    if (nTraceViewOption==TRACEMODE_MIXED)
        pCmdUI->SetCheck(1);
    else
        pCmdUI->SetCheck(0);
}

void CTraceWindow::OnEditGotoframe()
{
    // TODO: Add your command handler code here

    HINSTANCE hLib;
    int i = 1;
    if ((hLib = LoadLibrary("MUSCROLL.DLL")) < HINSTANCE_ERROR)
    {
    	AfxMessageBox("Can't find MUSCROLL.DLL");
    	i = 0;
    }
    CTrcGtdlg dlg(this);
    int result = dlg.DoModal();
    if(i) FreeLibrary(hLib);
    if (result<0) return;
	if(result>(int)m_viewTrace.m_wVscrollMaxpos)
		result=m_viewTrace.m_wVscrollMaxpos;
	m_viewTrace.SendMessage(WM_VSCROLL, SB_THUMBPOSITION, LPARAM(result));
}

void CTraceWindow::OnEditGotostartframe()
{
    // TODO: Add your command handler code here
    m_viewTrace.SendMessage(WM_VSCROLL, SB_THUMBPOSITION, 0);
}

void CTraceWindow::OnEditGotoendframe()         
{
    // TODO: Add your command handler code here
    int result;
    result = (int)m_viewTrace.m_wVscrollMaxpos;    
    m_viewTrace.SendMessage(WM_VSCROLL, SB_THUMBPOSITION, 
    			LPARAM(m_viewTrace.m_wVscrollMaxpos));
}

void CTraceWindow::OnTraceControl()
{
    // TODO: Add your command handler code here
    CTraceGroupDialog dlg(this,1);
    dlg.DoModal();
    if(dlg.m_bDisplayChange)
        SendMessage(WM_COMMAND,ID_VIEW_REFRESH, NULL);
}

void CTraceWindow::OnTraceEvent()
{
    // TODO: Add your command handler code here
    CTraceGroupDialog dlg(this, 0);
    dlg.DoModal();
    if(dlg.m_bDisplayChange)
      SendMessage(WM_COMMAND,ID_VIEW_REFRESH, NULL);
}

void CTraceWindow::OnTraceFilter()
{
    // TODO: Add your command handler code here
    CTraceGroupDialog dlg(this,3);
    dlg.DoModal();
    if(dlg.m_bDisplayChange)
        SendMessage(WM_COMMAND,ID_VIEW_REFRESH, NULL);
}

void CTraceWindow::OnTraceTrigger()
{
    // TODO: Add your command handler code here
    CTraceGroupDialog dlg(this,2);
    dlg.DoModal();
    if(dlg.m_bDisplayChange)
        SendMessage(WM_COMMAND,ID_VIEW_REFRESH, NULL);
}

void CTraceWindow::OnFileSavetrace()
{
    // TODO: Add your command handler code here
    long b;
    WORD last=0xffff;
    HINSTANCE hLib;
    int i = 1;
    TRACE_BUSREC bus[2];
    TRACE_INSTREC instruction[2];      
    TRACE_SOURCEREC source[2];
    WORD topFrame,bottomFrame;
    WORD count, inc;      
    char line[256]; 
    BOOL Isreadonly=FALSE;
    CString filename;
    
    if ((hLib = LoadLibrary("MUSCROLL.DLL")) < HINSTANCE_ERROR)
    {
    	AfxMessageBox("Can't find MUSCROLL.DLL");
    	i = 0;
    }
    CTrcFiDlg dlg(this);
    count = WORD(dlg.DoModal());
    if(dlg.GetReadOnlyPref())						//by chris.
    		{
    		 Isreadonly=TRUE;
    		 filename=dlg.GetPathName();
    		} 
        
    if(i) FreeLibrary(hLib);
    if (count==1)
    {
    	BeginWaitCursor();
    	
    	CStdioFile savefile;
    	savefile.Open(dlg.GetPathName(),CFile::modeCreate|CFile::modeWrite);
    	switch (dlg.m_nTraceMode)
    	{
    		case 1:
    			savefile.WriteString("Frame  Address  Data  Status  Spare[4-0]  Port\n");
    			break;
    		case 2:
    			savefile.WriteString("Frame  Address  Instruction\n");
    			break;
    		case 3:
    			savefile.WriteString("Frame  Line     Source\n");
    			break;
    		default:
    			break;
    	}
    	b=(long)dlg.m_nSaveStart;
    	while(b<=(long)dlg.m_nSaveEnd)
    	{        
    		switch (dlg.m_nTraceMode)
    		{
    			case 1:
    				topFrame = (WORD)b;
    				bottomFrame = (WORD)b;                     
    				count = 1;
    				ListTrcDataToWnd(0, &topFrame, &bottomFrame, &count, 
    									(struct FrameData*)bus);
    				b = topFrame;
    				if (b>dlg.m_nSaveEnd)
    					break;
    				if (bus[0].frameNo[0]==' ') 
    				{
    					b = dlg.m_nSaveEnd;
    					break;
    				}              
    				line[0]='\0';
    				sprintf(line,"%4s   %4s     %2s    %2s      %5s       %2s\n",
    					bus[0].frameNo,bus[0].addr,bus[0].data,bus[0].status,bus[0].spare,bus[0].portdata);
    				savefile.WriteString(line);
    				break;
    			case 2: 			//instruction
    				topFrame = (WORD)b;
    				bottomFrame = (WORD)b;                     
    				count = 1;
    				ListTrcInstToWnd(0, &topFrame, &bottomFrame,
                                             &count, (struct FrameInst*)instruction);
    				b = topFrame;
    				if (b>dlg.m_nSaveEnd)
    					break;
    				if (instruction[0].frameNo[0]==' ') 
    				{
    					b = dlg.m_nSaveEnd;
    					break;
    				}              
    				line[0]='\0';
    				sprintf(line,"%4s   %4s     %s\n",
    					instruction[0].frameNo,instruction[0].addr,instruction[0].instruction);
    				savefile.WriteString(line);
    				break;
    			case 3:
    				topFrame = (WORD)b;
    				bottomFrame = (WORD)b;                     
    				count = 1;
    				inc=topFrame;
    				ListTrcCToWnd(0, &topFrame, &bottomFrame,
                                                &count, (struct FrameC*)source);
                    if(last==source[0].phisicalNo)
                    {
                    	b=(long)dlg.m_nSaveEnd;
                    	break;
                    }
                    last=source[0].phisicalNo;
                    b = topFrame;
                    if(inc>topFrame)                            
    					b=inc;
    				if (b>dlg.m_nSaveEnd)
    					break;
    				if (source[0].frameNo[0]==' ') 
    				{
    					b = dlg.m_nSaveEnd;
    					break;
    				}              
    				line[0]='\0';
    				sprintf(line,"%4s   %s     %s\n",
    					source[0].frameNo,source[0].line,source[0].c);
    				savefile.WriteString(line);
    				break;
    			default:      
    				break;
    		}
    		b++;
    	}
    	savefile.Close();
    	if(Isreadonly)						//by chris.
  		{
			 CFileStatus status;
			 CFile::GetStatus( (const char*)filename, status );
			 status.m_attribute |= 0x01;			//read only attribute
    		 CFile::SetStatus( (const char*)filename, status );
    		} 
    	EndWaitCursor();
    }

}

void CTraceWindow::OnViewRefresh()
{
	// TODO: Add your command handler code here
RECT rect;	
	m_viewTrace.PrepareData(TRUE);
	m_viewTrace.CalcMaxlenofSrcorInst();
	m_viewTrace.GetClientRect(&rect);
	m_viewTrace.ReColumn(rect.right-rect.left);
	InvalidateRect(NULL, TRUE);
}

void CTraceWindow::OnKeyDown(UINT nChar, UINT /*nRepCnt*/, UINT /*nFlags*/)
{
	// TODO: Add your message handler code here and/or call default
		switch(nChar)
		{
		 case VK_HOME:
            m_viewTrace.SendMessage(WM_VSCROLL, SB_TOP, 0l);
		 	break;
		 case VK_END:
            m_viewTrace.SendMessage(WM_VSCROLL, SB_BOTTOM, 0l);
		 	break;		 	
	     case VK_PRIOR:
            m_viewTrace.SendMessage(WM_VSCROLL, SB_PAGEUP, 0l);
		 	break;                                 
		 case VK_NEXT:
            m_viewTrace.SendMessage(WM_VSCROLL, SB_PAGEDOWN, 0l);
		 	break;
		 case VK_UP:
            m_viewTrace.SendMessage(WM_VSCROLL, SB_LINEUP, 0l);
		 	break;	                               
		 case VK_DOWN:
            m_viewTrace.SendMessage(WM_VSCROLL, SB_LINEDOWN, 0l);
		 	break;	                                 
		 case VK_LEFT:
            m_viewTrace.SendMessage(WM_HSCROLL, SB_LINEUP, 0l);
		 	break;	                                        
		 case VK_RIGHT:
            m_viewTrace.SendMessage(WM_HSCROLL, SB_LINEDOWN, 0l);
		 	break;	                                   
		} 	
		return;
}

void CTraceWindow::OnShiftreturn()
{
	// TODO: Add your command handler code here
	SendMessage(WM_RBUTTONDOWN);
}

long CTraceWindow::OnXMRepaint(UINT /*wParam*/,LONG /*lParam*/)
{
RECT rect;	
	m_viewTrace.PrepareData(TRUE);
	m_viewTrace.CalcMaxlenofSrcorInst();
	m_viewTrace.GetClientRect(&rect);
	m_viewTrace.ReColumn(rect.right-rect.left);
	InvalidateRect(NULL, TRUE);
    return 0;
}

int	 CTraceWindow::CursorOnCol(int x, int y)
{
	if(0>y||int(m_wTitleHeight)<y)
	return 0;
int	xlen=m_viewTrace.m_nLeftfrom+m_viewTrace.m_nCol1len;
 	if(x>(xlen-5)&&x<(xlen+5))
		return 1;
	xlen+=m_viewTrace.m_nCol2len;
	if(x>(xlen-5)&&x<(xlen+5))
		return 2;
   	if(m_viewTrace.m_nColnum==3)	 
		return 0;
   	xlen+=m_viewTrace.m_nCol3len;		
	if(x>(xlen-5)&&x<(xlen+5))
		return 3;               
//	if(m_viewTrace.m_nColnum==4)	 
//		return 0;
   	xlen+=m_viewTrace.m_nCol4len;
	if(x>(xlen-5)&&x<(xlen+5))
		return 4;
//	if(m_viewTrace.m_nColnum==5)
//		return 0;
   	xlen+=m_viewTrace.m_nCol5len;		
	if(x>(xlen-5)&&x<(xlen+5))
		return 5;
	return 0;	
}			

void CTraceWindow::OnMouseMove(UINT nFlags, CPoint point)
{
	// TODO: Add your message handler code here and/or call default
	if(m_bSizeCursor)
		{
		 if(!m_bLBtnPress)				//not press
		  {
		   if(!(nFlags&MK_CONTROL)||!(CursorOnCol(point.x, point.y)))
		 	{
		 	 ::SetCursor(::LoadCursor(NULL, IDC_ARROW));
			 m_bSizeCursor=FALSE;	                  
			}
		   return;
		  }
		 else							//press 
		  {
		   if(point.x<m_nLeftMax)
		   		point.x=m_nLeftMax;
		   if(point.x>m_nRightMax)
		   		point.x=m_nRightMax;
		   if(point.x-m_nMousePointx)
		   	{    
		   	 m_viewTrace.DrawColLine(m_nMousePointx);
		   	 m_viewTrace.DrawColLine(point.x);
		   	 m_nMousePointx=point.x;
		   	}    
		  }	
		  return;
		}  
	if((nFlags&MK_CONTROL)&&!m_bSizeCursor)
		{
		 if(m_nChangeCol=CursorOnCol(point.x, point.y))
		 	{
		   	 ::SetCursor(::LoadCursor(NULL, IDC_SIZEWE));
			 switch(m_nChangeCol)
			 	{
			 	 case 1:
			 	 	m_nLeftMax=m_viewTrace.m_nLeftfrom+m_viewTrace.m_nCharWidth;
			 		m_nRightMax=m_viewTrace.m_nLeftfrom+m_viewTrace.m_nCol1len+m_viewTrace.m_nCol2len-m_viewTrace.m_nCharWidth;
			 	 	break;
			 	 case 2:
			 	 	m_nLeftMax=m_viewTrace.m_nLeftfrom+m_viewTrace.m_nCol1len+m_viewTrace.m_nCharWidth;
			 	 	m_nRightMax=m_viewTrace.m_nLeftfrom+m_viewTrace.m_nCol1len+m_viewTrace.m_nCol2len+m_viewTrace.m_nCol3len-m_viewTrace.m_nCharWidth;
			 	 	break;	
			 	 case 3:	
			 	 	m_nLeftMax=m_viewTrace.m_nLeftfrom+m_viewTrace.m_nCol1len+m_viewTrace.m_nCol2len+m_viewTrace.m_nCharWidth;
			 	 	m_nRightMax=m_viewTrace.m_nLeftfrom+m_viewTrace.m_nCol1len+m_viewTrace.m_nCol2len+m_viewTrace.m_nCol3len+m_viewTrace.m_nCol4len-m_viewTrace.m_nCharWidth;
			 	 	break;	
			 	 case 4:
			 	 	m_nLeftMax=m_viewTrace.m_nLeftfrom+m_viewTrace.m_nCol1len+m_viewTrace.m_nCol2len+m_viewTrace.m_nCol3len+m_viewTrace.m_nCharWidth;
			 	 	m_nRightMax=m_viewTrace.m_nLeftfrom+m_viewTrace.m_nCol1len+m_viewTrace.m_nCol2len+m_viewTrace.m_nCol3len+m_viewTrace.m_nCol4len+m_viewTrace.m_nCol5len-m_viewTrace.m_nCharWidth;
			 	 	break;	
			 	 case 5:
			 	 	m_nLeftMax=m_viewTrace.m_nLeftfrom+m_viewTrace.m_nCol1len+m_viewTrace.m_nCol2len+m_viewTrace.m_nCol3len+m_viewTrace.m_nCol4len+m_viewTrace.m_nCharWidth;
			 	 	m_nRightMax=m_viewTrace.m_nLeftfrom+m_viewTrace.m_nCol1len+m_viewTrace.m_nCol2len+m_viewTrace.m_nCol3len+m_viewTrace.m_nCol4len+m_viewTrace.m_nCol5len+m_viewTrace.m_nCol6len-m_viewTrace.m_nCharWidth;
			 	 	break;
			 	 default: 
			 	 	ASSERT(0);	
			 	} 
			 m_bSizeCursor=TRUE;	
			 return;
		   	}
		}  		
		      
//	OUT:	
	::SetCursor(::LoadCursor(NULL, IDC_ARROW));
	m_bSizeCursor=FALSE;
	CMDIChildWnd::OnMouseMove(nFlags, point);
}

void CTraceWindow::OnLButtonUp(UINT nFlags, CPoint point)
{
	// TODO: Add your message handler code here and/or call default
	if(m_bSizeCursor&&GetCapture())
		{
		 ReleaseCapture();
		 m_bLBtnPress=FALSE;
		 m_viewTrace.DrawColLine(m_nMousePointx);
		 m_viewTrace.m_ColumnMode[nTraceViewOption-1]=3;
		 //now: is the size of that column after drag.
		 int now=m_nMousePointx-(m_nLeftMax-m_viewTrace.m_nCharWidth);
		 switch(m_nChangeCol)
		 	{
		 	 case 1:
		 	 	m_viewTrace.m_nCol2len=m_viewTrace.m_nCol1len+m_viewTrace.m_nCol2len-now;
		 	 	m_viewTrace.m_nCol1len=now;
		 	 	break;
		 	 case 2:	
		 	 	m_viewTrace.m_nCol3len=m_viewTrace.m_nCol2len+m_viewTrace.m_nCol3len-now;
		 	 	m_viewTrace.m_nCol2len=now;
		 	 	break;
		 	 case 3:	
		 	 	m_viewTrace.m_nCol4len=m_viewTrace.m_nCol3len+m_viewTrace.m_nCol4len-now;
		 	 	m_viewTrace.m_nCol3len=now;
		 	 	break;
		 	 case 4:	
		 	 	m_viewTrace.m_nCol5len=m_viewTrace.m_nCol4len+m_viewTrace.m_nCol5len-now;
		 	 	m_viewTrace.m_nCol4len=now;
		 	 	break;
		 	 case 5:	
		 	 	m_viewTrace.m_nCol6len=m_viewTrace.m_nCol5len+m_viewTrace.m_nCol6len-now;
		 	 	m_viewTrace.m_nCol5len=now;
		 	 	break;
		 	 default: ASSERT(0);
		 	}
		 switch(nTraceViewOption)
		 	{
		 	 case TRACEMODE_BUS:
		 	 	m_viewTrace.m_nBusCollen[0]=m_viewTrace.m_nCol1len;
		 	 	m_viewTrace.m_nBusCollen[1]=m_viewTrace.m_nCol2len;
		 	 	m_viewTrace.m_nBusCollen[2]=m_viewTrace.m_nCol3len;
		 	 	m_viewTrace.m_nBusCollen[3]=m_viewTrace.m_nCol4len;
		 	 	m_viewTrace.m_nBusCollen[4]=m_viewTrace.m_nCol5len;
		 	 	m_viewTrace.m_nBusCollen[5]=m_viewTrace.m_nCol6len;
		 	 	break;
		 	 case TRACEMODE_INSTRUCTION:
		 	 	m_viewTrace.m_nInsCollen[0]=m_viewTrace.m_nCol1len;
		 	 	m_viewTrace.m_nInsCollen[1]=m_viewTrace.m_nCol2len;
		 	 	m_viewTrace.m_nInsCollen[2]=m_viewTrace.m_nCol3len;
		 	 	break;
		 	 case TRACEMODE_SOURCE:
		 	 	m_viewTrace.m_nSrcCollen[0]=m_viewTrace.m_nCol1len;
		 	 	m_viewTrace.m_nSrcCollen[1]=m_viewTrace.m_nCol2len;
		 	 	m_viewTrace.m_nSrcCollen[2]=m_viewTrace.m_nCol3len;
		 	 	break;
		 	 case TRACEMODE_MIXED:
		 	 	m_viewTrace.m_nMixedCollen[0]=m_viewTrace.m_nCol1len;
		 	 	m_viewTrace.m_nMixedCollen[1]=m_viewTrace.m_nCol2len;
		 	 	m_viewTrace.m_nMixedCollen[2]=m_viewTrace.m_nCol3len;
		 	 	break;
		 	 default:
		 	 	break;
		 	}
		 InvalidateRect(NULL, TRUE);		 	
		} 
	CMDIChildWnd::OnLButtonUp(nFlags, point);
}

void CTraceWindow::OnLButtonDown(UINT nFlags, CPoint point)
{
	// TODO: Add your message handler code here and/or call default
	if(m_bSizeCursor)
		{
		 SetCapture();
		 m_bLBtnPress=TRUE;
		 m_nMousePointx=point.x;                     
		 m_viewTrace.DrawColLine(m_nMousePointx);
		} 
	CMDIChildWnd::OnLButtonDown(nFlags, point);
}
