
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/TSTBASE.H__   1.8   20 Jun 1996 09:24:36   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/TSTBASE.H__  $
** 
**    Rev 1.8   20 Jun 1996 09:24:36   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.6   10 Jun 1996 10:19:14   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.4   29 May 1996 09:28:12   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:08:32   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:09:04   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:24:58   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 13:00:44   Shirley
** EasyPack/SLD Version 1.91
** 
**    Rev 1.30   12 Apr 1996 10:37:48   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:52:18   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:06:50   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:33:20   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:48:14   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:12:34   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:12:18   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:12:58   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:36:36   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:27:06   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:12:10   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:15:08   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:08:56   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:12:32   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:29:36   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:21:52   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:23:32   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:34:26   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:32:24   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:41:46   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:07:28   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:47:06   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:48:18   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:29:34   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:48:06   Shirley
** EasyPack/SLD Version 0.1e
** 
**    Rev 1.4   13 Oct 1995 13:21:40   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:53:30   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:58:16   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:46:10   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:54:02   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: TSTBASE.H
//
//  Description: The header file for the class: CFileBase.
//
//  Author: Chen Jun
//
//  Date: 05/19/95
//
//  Modification:
//      1. 05/19/95, Initial version of the class: CFileBase.
//
/////////////////////////////////////////////////////////////////////////////
#ifndef _TSTBASE_
#define _TSTBASE_

#include "syntest.h"


/////////////////////////////////////////////////////////////////////////////
// CFileBase class.
class CFileBase : public CStdioFile, public CSyntaxTest
{
// Construction & Destruction.
public:
    CFileBase();
    ~CFileBase();
    
// Member variables.
public:
    // File operation error.
    enum {  // No error.
            NO_ERROR = 0,
            // For Log command.
            LOG_EXIST,
            LOG_UNOPEN,
            // File basic operation.
            OPEN_ERROR,
            CLOSE_ERROR,
            READ_ERROR,
            WRITE_ERROR,
            // For Include command.
            FILE_END,
            LONG_LINE,
            // Include inner command error.
            NOT_INNER,
            INNER_ERROR,
            INNER_ERROR_SYNTAX,
            INNER_ERROR_COUNT,
            INNER_ERROR_LABEL,
            INNER_ERROR_GOTO,
            INNER_ERROR_LOOP,
            INNER_ERROR_LOOPEND,
            INNER_ERROR_IF,
            INNER_ERROR_ELSE,
            INNER_ERROR_BEGIN,
            INNER_ERROR_END,
            INNER_ERROR_MATCH,
            INNER_ERROR_ESC,    
            //Macro Error
			DELETE_MACRO_ERROR,   
			MACRO_FILE_END,
            // Macro inner command error.
            NOT_MACRO_INNER,
            INNER_MACRO_ERROR,
            INNER_MACRO_ERROR_SYNTAX,
            INNER_MACRO_ERROR_IF,
            INNER_MACRO_ERROR_ELSE,
            INNER_MACRO_ERROR_BEGIN,
            INNER_MACRO_ERROR_END,
            INNER_MACRO_ERROR_MATCH,
            INNER_MACRO_ERROR_ESC,
            INNER_MACRO_ERROR_COUNT,
            INNER_MACRO_ERROR_LABEL,
            INNER_MACRO_ERROR_GOTO,
            INNER_MACRO_ERROR_LOOP,
            INNER_MACRO_ERROR_LOOPEND,            
            // Maximum error.
            MAX_ERROR
    };
    int m_nErrorID;

protected:
    // File name.    
    CString m_strFileName;
    
    // File open mode.
    int m_nOpenFlag;
    
    // One line contents.
    enum { MIN_KEY = 0x20, MAX_KEY = 0x7F };
    enum { maxChar = 255 };
    char* m_pszLineBuf;

    // Used by StrToVar().
    unsigned long m_ulVar;

// Implementations.
protected:
    void OpenFile(void);
    void CloseFile(void);
    void ReadFromFile(void);
    void WriteToFile(void);

    void StrToVar(char* pszConvStr);

    void DisplayErrorMessage(void) const;

};  // End of class: CFileBase.

#endif
//////////////////////////////// End of File ////////////////////////////////
