
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/TYPETBL.H__   1.8   20 Jun 1996 09:27:44   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/TYPETBL.H__  $
** 
**    Rev 1.8   20 Jun 1996 09:27:44   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.6   10 Jun 1996 10:22:20   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.4   29 May 1996 09:33:02   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:05:08   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:14:00   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:24:34   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 12:53:50   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:40:40   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:54:10   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:09:28   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:35:50   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:50:06   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:14:36   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:20:30   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:20:24   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:37:42   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:23:10   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:12:38   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:15:36   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:09:22   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:10:56   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:30:04   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:19:38   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:22:20   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:33:56   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:34:24   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:44:18   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:05:12   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:51:06   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:44:52   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:31:16   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:47:08   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:23:26   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:53:42   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:56:08   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:45:06   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:55:58   Shirley
** Initial revision.
**
****************************************************************************/

/*----------------------------------------------------------------------------
** Name: typetbl.h
**
** Title: Type Table
**
** Purpose:
**  Create and manage all simple and complex data types
**
** Status: PRELIMINARY
**
** $Log$
** 
** $Header:   D:/EPSLDV1/SRC/LOG/TYPETBL.H__   1.8   20 Jun 1996 09:27:44   ZJRD  $
**
** Copyright (C) 1995 Microtek International.  All rights reserved.
**
**--------------------------------------------------------------------------*/

#ifndef _TYPETBL_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include "memmanag.h"
#include "symutil.h"

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

                       /**********************************
                        *                                *
                        *   MEMBER FUNCTION PROTOTYPES   *
                        *                                *
                        **********************************/

#ifdef __cplusplus

class TypeTable : public Table {

private:

   TABLE_OFFSET availMemOffset;  // acts as ptr to start of available mem ;
                                 // also equals the number of bytes used ;
   U16 bytesThrownAway;          // measurement of memory loss ;
   TYPE_INDEX typeIndex;         // index to the last type header added. ;
                                 // all future put bytes will operate using ;
                                 // this index.
   TYPE_INDEX maxTypeIndex;      // holds the value of the largest type ;
                                 // index stored away so far. ;

public:
   // constructor ;
   TypeTable();

//---------------------------------------------------------------------------
// AllocBytes
//
// Purpose:
//    Allocate 1 to 64k bytes into table.  Returns offset to start of data.
//
// Input parameters:
//    size: number of bytes
//
// Output parameters:
//    tableDataOffset: offset to start of stored bytes.
//
// Error: Reports ER_MEM_OUT_OF_MEMORY if there is not enough memory
//        to hold data
//
//------------------------------------------------------------------------
RETCODE AllocBytes(U16 size, TABLE_OFFSET& tableDataOffset);


//---------------------------------------------------------------------------
// GetAvailMemOffset
//
// Purpose:
//    Return the value of the variable that points to the next available
//    location in the table to add data.
//
//---------------------------------------------------------------------------
TABLE_OFFSET GetAvailMemOffset() {return availMemOffset;};


//---------------------------------------------------------------------------
// GetBytesThrownAway
//
// Purpose:
//    FOR TESTING.
//    Return the value of the variable holding the number of bytes that were
//    "discarded" when it crossed the allocated boundary (which required
//    ReAlloc)
//
//---------------------------------------------------------------------------
U16 GetBytesThrownAway() { return bytesThrownAway; };


// GetMaxTypeIndex
//
// Purpose:
//    Returns the largest type index used so far ;
//
//---------------------------------------------------------------------------
RETCODE GetMaxTypeIndex(TYPE_INDEX &typeIndexMax) { 
   typeIndexMax = maxTypeIndex;
   return GOOD;
};


//---------------------------------------------------------------------------
// GetTypeIndex
//
// Purpose:
//    Returns the type index of the current type header. ;
//
//---------------------------------------------------------------------------
U32 GetTypeIndex(VOID) { return typeIndex; };


//---------------------------------------------------------------------------
// IncrementMemberCount
//
// Purpose:
//    Every time a type is added to the table the member count in the type ;
//    header must be incremented.
//
//---------------------------------------------------------------------------
RETCODE IncrementMemberCount(VOID);


//---------------------------------------------------------------------------
// InitBasicTypes
//
// Purpose:
//    Initialize the builtin language types ;
//
//---------------------------------------------------------------------------
RETCODE InitBasicTypes(VOID);


//---------------------------------------------------------------------------
// ObliterateTable
//
// Purpose:
//    Unlocks, then frees the table to Windows memory.
//---------------------------------------------------------------------------
VOID ObliterateTable(VOID);


//---------------------------------------------------------------------------
// PutBytes
//
// Purpose:
//    Insert 1 to 64K bytes into table.  Uses type index from last type_hdr.
//    This routine is used for putting structures into the table by passing
//    a pointer to the structure with size = sizeof(struct).
//
// Input parameters:
//    inputDataPtr: pointer to data.
//    size: number of bytes
//
// Output parameters:
//    offset: offset to head of data just stored
//
// Error: Reports ER_MEM_OUT_OF_MEMORY if there is not enough memory
//        to hold data
//
//------------------------------------------------------------------------
RETCODE PutBytes(U8 *inputDataPtr, U16 size, TABLE_OFFSET &offset);


//---------------------------------------------------------------------------
// PutHeader
//
// Purpose:
//    Insert a type header into the type table.  
//
// Input parameters:
//    inputDataPtr: pointer to data.
//    size: number of bytes
//    index: the index for the header to be added
//
// Output parameters:
//    none:
//
// Error: Reports ER_MEM_OUT_OF_MEMORY if there is not enough memory
//        to hold data
//
//------------------------------------------------------------------------
RETCODE PutHeader(U8 *inputDataPtr, U16 size, TYPE_INDEX index);


//---------------------------------------------------------------------------
// SetAvailableMem
//
// Purpose:
//    TESTING ONLY!!  Positions the unused memory pointer to a new location.
//---------------------------------------------------------------------------
VOID SetAvailableMem(U32 setValue) {

   availMemOffset = min(setValue, tableSize);
}


//---------------------------------------------------------------------------
// UpdateMAUSize
//
// Purpose:
//    When a new type is added the size of the new type in MAU's needs to ;
//    be updated. ;
//---------------------------------------------------------------------------
RETCODE UpdateMAUSize(TYPE_INDEX prevIndex);


//---------------------------------------------------------------------------
// UpdateRecordSize
//
// Purpose:
//    When a new type is added the size of the entire type record needs to ;
//    be updated. ;
//---------------------------------------------------------------------------
RETCODE UpdateRecordSize(U16 setValue);

};  // end of class MemPool

#endif

#define _TYPETBL_
#endif
/******************************** E O F *************************************/
