
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/VAREDIT.CPP   1.8   20 Jun 1996 09:26:10   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/VAREDIT.CPP  $
** 
**    Rev 1.8   20 Jun 1996 09:26:10   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.6   10 Jun 1996 10:20:50   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.4   29 May 1996 09:30:40   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:03:56   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:12:48   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:27:44   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 13:01:26   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:38:26   Shirley
** No change.
** 
**    Rev 1.29   02 Apr 1996 09:23:28   Shirley
** No change.
** 
**    Rev 1.28   15 Feb 1996 08:51:22   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:05:50   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:35:16   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:49:34   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:15:46   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:12:38   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:13:18   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:40:14   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:22:16   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:13:10   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:14:36   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:13:26   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:11:20   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:31:58   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:18:50   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:27:36   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:31:08   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:34:20   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:44:16   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:05:10   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:51:04   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:44:50   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:32:06   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:52:06   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:20:58   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:51:42   Shirley
** EasyPack/SLD Version 0.1c
** 
**    Rev 1.2   20 Sep 1995 10:56:14   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:45:10   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:56:02   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: VAREDIT.CPP
//
//  Description: The implementation file fore class: CVarEditVariableDialog.
//
//  Author: Chen Jun
//
//  Date: 07/26/95
//
//  Modification:
//      1. 07/26/95, Initial version of the class: CVarEditVariableDialog.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"

#include "varedit.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Global variables.
CStringList* pVarEditVariableList;


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.
void VarGetHighlightName(CString& strName);
void VarEditVariable(void);


/////////////////////////////////////////////////////////////////////////////
// CVarEditVariableDialog dialog


CVarEditVariableDialog::CVarEditVariableDialog(CWnd* pParent /*=NULL*/)
    : CDialog(CVarEditVariableDialog::IDD, pParent)
{
    //{{AFX_DATA_INIT(CVarEditVariableDialog)
    m_strVariable = "";
    //}}AFX_DATA_INIT
    
    // Initial.
    m_isDropdown = FALSE;
}

void CVarEditVariableDialog::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CVarEditVariableDialog)
    DDX_Control(pDX, IDC_COMBO_EDITVARIABLE_VARIABLE, m_comboVariable);
    DDX_CBString(pDX, IDC_COMBO_EDITVARIABLE_VARIABLE, m_strVariable);
    DDV_MaxChars(pDX, m_strVariable, 80);
    //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CVarEditVariableDialog, CDialog)
    //{{AFX_MSG_MAP(CVarEditVariableDialog)
    ON_CBN_DROPDOWN(IDC_COMBO_EDITVARIABLE_VARIABLE, OnDropdownComboVariable)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CVarEditVariableDialog message handlers

void CVarEditVariableDialog::OnCancel()
{
    // TODO: Add extra cleanup here
    
    CDialog::OnCancel();
}

void CVarEditVariableDialog::OnOK()
{
    // TODO: Add extra validation here
    
    // Detect if it has been dropdown.
    if ( m_isDropdown ) {
        // Add to the global list.
        ::pVarEditVariableList->RemoveAll();
        CString str;
        for ( int i = 0; i < m_comboVariable.GetCount(); i++ ) {
            m_comboVariable.GetLBText(i, str);
            if ( !str.IsEmpty() ) {
                ::pVarEditVariableList->AddTail(str);
            }
        }
    }

    // Add to combo list box.
    m_comboVariable.GetWindowText(m_strVariable);
    if ( !m_strVariable.IsEmpty() ) {
        ::pVarEditVariableList->AddTail(m_strVariable);
        // Call kernel routine.
        ::VarEditVariable();
    }

    CDialog::OnOK();
}

void CVarEditVariableDialog::OnDropdownComboVariable()
{
    // TODO: Add your control notification handler code here

    // Get the last entered string from the combo box.
    m_comboVariable.GetWindowText(m_strVariable);
    
    // Detect if it has been dropdown.
    if ( !m_isDropdown ) {
        // Set the dropdown flag.
        m_isDropdown = TRUE;
        // Get the variable name from the global list.
        if ( !::pVarEditVariableList->IsEmpty() ) {
            m_comboVariable.ResetContent();
            POSITION posHead = ::pVarEditVariableList->GetHeadPosition();
            while ( posHead ) {
                CString str = 
                    (CString)::pVarEditVariableList->GetNext(posHead);
                m_comboVariable.AddString(str);
            }
        }
    }
        
    // Add the last entered string to the combo box.
    m_comboVariable.SetWindowText(m_strVariable);
}

BOOL CVarEditVariableDialog::OnInitDialog()
{
    CDialog::OnInitDialog();
    
    // TODO: Add extra initialization here
    
    // Central the dialog position.
    CenterWindow();
        
    // Get the current highlight variable name.
    ::VarGetHighlightName(m_strVariable);

    // Show the selected variable.
    m_comboVariable.SetWindowText(m_strVariable);

    // Set the initial value.
    UpdateData(FALSE);

    return TRUE;  // return TRUE  unless you set the focus to a control
}
