
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/VARMODI.CPP   1.8   20 Jun 1996 09:27:40   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/VARMODI.CPP  $
** 
**    Rev 1.8   20 Jun 1996 09:27:40   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.6   10 Jun 1996 10:22:18   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.4   29 May 1996 09:32:58   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:05:04   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:13:56   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:24:30   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 12:53:46   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:40:36   Shirley
** No change.
** 
**    Rev 1.29   02 Apr 1996 09:22:52   Shirley
** No change.
** 
**    Rev 1.28   15 Feb 1996 08:54:04   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:09:22   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:35:46   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:50:02   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:14:32   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:20:26   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:20:20   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:37:36   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:23:06   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:12:32   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:15:32   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:09:18   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:12:56   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:35:16   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:24:30   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:25:22   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:28:20   Shirley
** EasyPack/SLD Version 0.24
** 
**    Rev 1.11   08 Nov 1995 16:29:06   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:41:38   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:07:22   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:47:00   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:48:10   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:29:28   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:49:14   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:19:18   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:51:46   Shirley
** EasyPack/SLD Version 0.1c
** 
**    Rev 1.2   20 Sep 1995 10:53:08   Shirley
** EasyPack/SLD Version 0.1b
** 
**    Rev 1.1   15 Sep 1995 09:49:24   Shirley
** EasyPack/SLDV0.1a 
** 
**    Rev 1.0   07 Sep 1995 09:54:20   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: VARMODI.CPP
//
//  Description: The implementation file fore class:CVarModifyVariableDialog.
//
//  Author: Chen Jun
//
//  Date: 07/26/95
//
//  Modification:
//      1. 07/26/95, Initial version of the class: CVarModifyVariableDialog.
//      2. 09/08/95, Fix bug 48, CVarModifyVariableDialog::OnInitDialog().
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"

#include "varmodi.h"


#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.
void VarGetHighlightName(CString& strName);
void VarGetHighlightValue(CString& strValue);
BOOL VarModifyValue(CString& strNewValue);

void StkGetHighlightName(CString& strName);
void StkGetHighlightValue(CString& strValue);
BOOL StkModifyValue(CString& strNewValue);

void RepaintStack(void);
void RepaintVariable(void);
void RepaintCPU(void);
void RepaintMemory(void);
void RepaintBMemory(void);
void RepaintPeri(void);


/////////////////////////////////////////////////////////////////////////////
// External variables.
extern BOOL isVarWindowActive;
extern BOOL isStkLocalActive;


/////////////////////////////////////////////////////////////////////////////
// CVarModifyVariableDialog dialog

CVarModifyVariableDialog::CVarModifyVariableDialog(CWnd* pParent /*=NULL*/)
    : CDialog(CVarModifyVariableDialog::IDD, pParent)
{
    //{{AFX_DATA_INIT(CVarModifyVariableDialog)
    m_strNewValue = "";
    m_strCurrentContent = "";
    m_strVariable = "";
    //}}AFX_DATA_INIT
}

void CVarModifyVariableDialog::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CVarModifyVariableDialog)
    DDX_Control(pDX, IDC_STATIC_MODIFYVARIABLE_VARIABLENAME, m_staticVariableName);
    DDX_Control(pDX, IDC_STATIC_MODIFYVARIABLE_CONTENT, m_staticCurrentContent);
    DDX_Control(pDX, IDC_EDIT_MODIFYVARIABLE_NEWVALUE, m_editNewValue);
    DDX_Text(pDX, IDC_EDIT_MODIFYVARIABLE_NEWVALUE, m_strNewValue);
    DDV_MaxChars(pDX, m_strNewValue, 80);
    DDX_Text(pDX, IDC_STATIC_MODIFYVARIABLE_CONTENT, m_strCurrentContent);
    DDV_MaxChars(pDX, m_strCurrentContent, 80);
    DDX_Text(pDX, IDC_STATIC_MODIFYVARIABLE_VARIABLENAME, m_strVariable);
    DDV_MaxChars(pDX, m_strVariable, 80);
    //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CVarModifyVariableDialog, CDialog)
    //{{AFX_MSG_MAP(CVarModifyVariableDialog)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CVarModifyVariableDialog message handlers

void CVarModifyVariableDialog::OnOK()
{
    // TODO: Add extra validation here

    // Get the new value.
    m_editNewValue.GetWindowText(m_strNewValue);
    
    // Modify the value by calling from Variable / Stack server.
    if ( !m_strNewValue.IsEmpty() ) {
        if ( ::isVarWindowActive ) {
            if ( ::VarModifyValue(m_strNewValue) ) {
                ::RepaintStack();
                ::RepaintCPU();
                ::RepaintMemory();
                ::RepaintBMemory();
                ::RepaintPeri();
                CDialog::OnOK();
            }
        }
        else if ( ::isStkLocalActive ) {
            if ( ::StkModifyValue(m_strNewValue) ) {
                ::RepaintVariable();
                ::RepaintCPU();
                ::RepaintMemory();
                ::RepaintBMemory();
                ::RepaintPeri();
                CDialog::OnOK();
            }
        }
    }
    else {
        CDialog::OnOK();
    }
}

void CVarModifyVariableDialog::OnCancel()
{
    // TODO: Add extra cleanup here
    
    CDialog::OnCancel();
}

void CVarModifyVariableDialog::GetHighlightVariableName(void)
{
    // Get the current highlight variable name.
    if ( ::isVarWindowActive ) {
        ::VarGetHighlightName(m_strVariable);
    }
    else if ( ::isStkLocalActive ) {
        ::StkGetHighlightName(m_strVariable);
    }
}

void CVarModifyVariableDialog::GetHighlightVariableValue(void)
{
    // Get the current highlight variable value.
    if ( ::isVarWindowActive ) {
        ::VarGetHighlightValue(m_strCurrentContent);
    }
    else if ( ::isStkLocalActive ) {
        ::StkGetHighlightValue(m_strCurrentContent);
    }
}

BOOL CVarModifyVariableDialog::OnInitDialog()
{
    CDialog::OnInitDialog();
    
    // TODO: Add extra initialization here
    
    // Central the dialog position.
    CenterWindow();
        
    // Get the current modified variable name.
    GetHighlightVariableName();

    // Show the current modified variable name.
    m_staticVariableName.SetFont(GetFont());
    m_staticVariableName.SetWindowText(m_strVariable);

    // Get the current modified variable value.
    GetHighlightVariableValue();

    // Show the current value of the special variable.
    m_staticCurrentContent.SetFont(GetFont());
    m_staticCurrentContent.SetWindowText(m_strCurrentContent);
    
    // Set the initial value.
    UpdateData(FALSE);

    return TRUE;  // return TRUE  unless you set the focus to a control
}
