
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/VARSRCH.CPP   1.8   20 Jun 1996 09:28:46   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/VARSRCH.CPP  $
** 
**    Rev 1.8   20 Jun 1996 09:28:46   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.6   10 Jun 1996 10:23:24   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.4   29 May 1996 09:34:40   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:00:06   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:16:38   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:30:58   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 12:56:08   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:35:10   Shirley
** No change.
** 
**    Rev 1.29   02 Apr 1996 09:28:04   Shirley
** No change.
** 
**    Rev 1.28   15 Feb 1996 08:56:26   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:07:46   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:34:12   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:48:26   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:12:46   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:12:30   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:13:08   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:40:04   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:22:08   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:13:02   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:14:28   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:13:18   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:11:12   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:34:36   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:22:18   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:23:58   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:28:16   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:29:02   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:41:34   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:07:18   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:46:56   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:44:28   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:26:16   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:48:58   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:19:22   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:51:50   Shirley
** EasyPack/SLD Version 0.1c
** 
**    Rev 1.2   20 Sep 1995 10:55:58   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:46:16   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:55:10   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: VARMODI.CPP
//
//  Description: The implementation file for the class: CVarSearchDialog.
//
//  Author: Chen Jun
//
//  Date: 07/26/95
//
//  Modification:
//      1. 07/26/95, Initial version of the class: CVarSearchDialog.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"

#include "varsrch.h"


#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Global variables.
CStringList* pVarSearchPatternList;
CStringList* pStkSearchPatternList;


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.
void VarGetHighlightName(CString& strName);
void StkGetHighlightName(CString& strName);
void VarSearchToken(void);
void StkSearchToken(void);


/////////////////////////////////////////////////////////////////////////////
// External variables.
extern BOOL isVarWindowActive;
extern BOOL isStkLocalActive;


/////////////////////////////////////////////////////////////////////////////
// CVarSearchDialog dialog


CVarSearchDialog::CVarSearchDialog(CWnd* pParent /*=NULL*/)
    : CDialog(CVarSearchDialog::IDD, pParent)
{
    //{{AFX_DATA_INIT(CVarSearchDialog)
    m_strSearchWhat = "";
    //}}AFX_DATA_INIT

    // Initial.
    m_isDropdown = FALSE;

    // Point to the relative list.
    if ( ::isVarWindowActive ) {
        m_pList = ::pVarSearchPatternList;
    }
    else if ( ::isStkLocalActive ) {
        m_pList = ::pStkSearchPatternList;
    }
}

void CVarSearchDialog::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CVarSearchDialog)
    DDX_Control(pDX, IDC_COMBO_SEARCH_SEARCHWHAT, m_comboSearchWhat);
    DDX_CBString(pDX, IDC_COMBO_SEARCH_SEARCHWHAT, m_strSearchWhat);
    DDV_MaxChars(pDX, m_strSearchWhat, 80);
    //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CVarSearchDialog, CDialog)
    //{{AFX_MSG_MAP(CVarSearchDialog)
    ON_BN_CLICKED(IDC_BUTTON_SEARCH_SEARCH, OnButtonSearchSearch)
    ON_CBN_DROPDOWN(IDC_COMBO_SEARCH_SEARCHWHAT, OnDropdownComboSearchwhat)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CVarSearchDialog message handlers

void CVarSearchDialog::OnButtonSearchSearch()
{
    // TODO: Add your control notification handler code here
    
    // Detect if it has been dropdown.
    if ( m_isDropdown ) {
        // Add to the global list.
        m_pList->RemoveAll();
        CString str;
        for ( int i = 0; i < m_comboSearchWhat.GetCount(); i++ ) {
            m_comboSearchWhat.GetLBText(i, str);
            if ( !str.IsEmpty() ) {
                m_pList->AddTail(str);
            }
        }
    }

    // Get from the combo edit box.
    m_comboSearchWhat.GetWindowText(m_strSearchWhat);
    if ( !m_strSearchWhat.IsEmpty() ) {
        m_pList->AddTail(m_strSearchWhat);
        // Call kernel routine.
        if ( ::isVarWindowActive ) {
            ::VarSearchToken();
        }
        else if ( ::isStkLocalActive ) {
            ::StkSearchToken();
        }
    }

    CDialog::OnOK();
}

void CVarSearchDialog::OnCancel()
{
    // TODO: Add extra cleanup here
    
    CDialog::OnCancel();
}

void CVarSearchDialog::OnDropdownComboSearchwhat()
{
    // TODO: Add your control notification handler code here
    
    // Get the last entered string from the combo box.
    m_comboSearchWhat.GetWindowText(m_strSearchWhat);
    
    // Detect if it has been dropdown.
    if ( !m_isDropdown ) {
        // Set the dropdown flag.
        m_isDropdown = TRUE;
        // Get the variable name from the global list.
        if ( !m_pList->IsEmpty() ) {
            m_comboSearchWhat.ResetContent();
            POSITION posHead = m_pList->GetHeadPosition();
            while ( posHead ) {
                CString str = 
                    (CString)(m_pList->GetNext(posHead));
                m_comboSearchWhat.AddString(str);
            }
        }
    }
        
    // Add the last entered string to the combo box.
    m_comboSearchWhat.SetWindowText(m_strSearchWhat);
}

BOOL CVarSearchDialog::OnInitDialog()
{
    CDialog::OnInitDialog();
    
    // TODO: Add extra initialization here
    
    // Central the dialog position.
    CenterWindow();
        
    // Set the last variable name.
    if ( !m_pList->IsEmpty() ) {
        m_strSearchWhat = (CString)(m_pList->GetTail());
    }
    else {
        // Select the highlight variable.
        if ( ::isVarWindowActive ) {
            ::VarGetHighlightName(m_strSearchWhat);
        }
        else if ( ::isStkLocalActive ) {
            ::StkGetHighlightName(m_strSearchWhat);
        }
    }

    // Show the selected variable.
    m_comboSearchWhat.SetWindowText(m_strSearchWhat);

    // Set the initial value.
    UpdateData(FALSE);

    return TRUE;  // return TRUE  unless you set the focus to a control
}
